<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Staffattendance extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->helper('file');
        $this->config->load("mailsms");
        $this->config->load("payroll");
        $this->load->library('mailsmsconf');
        $this->config_attendance = $this->config->item('attendence');
        $this->staff_attendance  = $this->config->item('staffattendance');
        $this->load->model("staffattendancemodel");
        $this->load->model("staff_model");
        $this->load->model("payroll_model"); 
        $this->load->model("leaverequest_model"); 
        $this->load->model("staffAttendaceSetting_model");
        
    }

    // public function index(){
    //     ini_set('display_errors', 1);
    //     error_reporting(E_ALL);
    //     if (!($this->rbac->hasPrivilege('staff_attendance', 'can_view'))) {
    //         access_denied();
    //     }

    //     $this->session->set_userdata('top_menu', 'HR');
    //     $this->session->set_userdata('sub_menu', 'admin/staffattendance');
    //     $data['title']        = 'Staff Attendance List';
    //     $data['title_list']   = 'Staff Attendance List';
    //     $user_type            = $this->staff_model->getStaffRole();
    //     $data['sch_setting']  = $this->setting_model->getSetting();
    //     $data['classlist']    = $user_type;
    //     $data['class_id']     = "";
    //     $data['section_id']   = "";
    //     $data['date']         = "";
    //     $user_type_id         = $this->input->post('user_id');
    //     $data["user_type_id"] = $user_type_id;
    //     $staff_settings           = $this->staffAttendaceSetting_model->getRoleWiseAttendanceSetting($user_type_id);
    //     $data['staff_settings']   = $staff_settings;   

    //     if (!(isset($user_type_id))) {
    //         $this->load->view('layout/header', $data);
    //         $this->load->view('admin/staffattendance/staffattendancelist', $data);
    //         $this->load->view('layout/footer', $data);
    //     } else {
    //         $user_type            = $this->input->post('user_id');
    //         $date                 = $this->input->post('date');
    //         $user_list            = $this->staffattendancemodel->get();
    //         $data['userlist']     = $user_list;
    //         $data['class_id']     = $user_list;
    //         $data['user_type_id'] = $user_type_id;
    //         $data['section_id']   = "";
    //         $data['date']         = $date;
    //         $is_first_time_attendance      = true;
    //         $search               = $this->input->post('search');
    //         $holiday              = $this->input->post('holiday');
    //         $this->session->set_flashdata('msg', '');
    //         if ($search == "saveattendence") {
            
    //             $user_type_ary       = $this->input->post('student_session');
    //             $attendance_array=[];
    //             $absent_staff_list=[];
    //             foreach ($user_type_ary as $key => $value) {
                    
    //                 $attendencetype = $this->input->post('attendencetype' . $value);
    //               $in_time    =   $this->input->post("in_time_" . $value);
    //               $out_time   =   $this->input->post("out_time_" . $value);

    //                 if((!isset($in_time) || $in_time=="") && (!isset($out_time) || $out_time=="")){
    //                     $in_time  = null;
    //                     $out_time = null;
    //                 }else{
    //                     $in_time=date('H:i:s', strtotime($this->input->post("in_time_" . $value)));
    //                     $out_time=date('H:i:s', strtotime($this->input->post("out_time_" . $value)));
    //                 }

    //                 $absent_config = $this->staff_attendance['absent'];
                
    //                 if ($attendencetype == $absent_config) {
    //                     $absent_staff_list[] = $value;
    //                 }

    //                 $attendance_array[] = array(                       
    //                     'staff_id'                 => $value,
    //                     'staff_attendance_type_id' => $this->input->post('attendencetype' . $value),
    //                     'remark'                   => $this->input->post("remark" . $value),
    //                     'in_time'                  => $in_time,
    //                     'out_time'                 => $out_time, 
    //                     'date'                     => date('Y-m-d', $this->customlib->datetostrtotime($date)),
    //                     'updated_at'               => date('Y-m-d', $this->customlib->datetostrtotime($date)),
    //                 );
    //             }
               
    //             $this->staffattendancemodel->addorUpdate($attendance_array);
    //             //added mail sms code //
    //             if (!empty($absent_staff_list)) {
    //                 $this->mailsmsconf->mailsms('staff_absent_attendence', $absent_staff_list, $date);
    //             }
    //             if (!empty($present_staff_list)) {
    //                 $this->mailsmsconf->mailsms('staff_present_attendence', $present_staff_list, $date);
    //             }
    //             // added mail sms code //

    //             $absent_config = $this->config_attendance['absent'];
    //             $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
    //             redirect('admin/staffattendance/index');
    //         }

    //         $attendencetypes             = $this->attendencetype_model->getStaffAttendanceType();
    //         $data['attendencetypeslist'] = $attendencetypes;        
    //         $resultlist                  = $this->staffattendancemodel->searchAttendenceUserType($user_type, date('Y-m-d', $this->customlib->datetostrtotime($date)));
    //         if (!empty($resultlist)) {
    //             foreach ($resultlist as $key => $value) {
    //                 if (!IsNullOrEmptyString($value['staff_attendance_type_id'])) {
    //                     $is_first_time_attendance = false;
    //                 }
    //             }
    //         }
    //         $data['is_first_time_attendance']  = $is_first_time_attendance;
    //         $data['resultlist']  = $resultlist;

    //         $this->load->view('layout/header', $data);
    //         $this->load->view('admin/staffattendance/staffattendancelist', $data);
    //         $this->load->view('layout/footer', $data);
    //     }
    // }    
    
    public function index() {
        if (!($this->rbac->hasPrivilege('staff_attendance', 'can_view'))) {
            access_denied();
        }
        
        
    
        $this->session->set_userdata('top_menu', 'HR');
        $this->session->set_userdata('sub_menu', 'admin/staffattendance');
        $data['title'] = 'Staff Attendance List';
        $data['title_list'] = 'Staff Attendance List';
        $user_type = $this->staff_model->getStaffRole();
        $data['sch_setting'] = $this->setting_model->getSetting();
        $data['classlist'] = $user_type;
        $data['class_id'] = "";
        $data['section_id'] = "";
        $data['date'] = "";
        $date = $this->input->post('date');
        $user_type_id = $this->input->post('user_id');
        $data["user_type_id"] = $user_type_id;
        $staff_settings = $this->staffAttendaceSetting_model->getRoleWiseAttendanceSetting($user_type_id);
        $data['staff_settings'] = $staff_settings;
        $is_first_time_attendance = true;
    
        if (!isset($user_type_id) && !isset($date)) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/staffattendance/staffattendancelist', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $user_type = $this->input->post('user_id');
            $date = $date ?: $this->input->post('date');
            
            $user_list = $this->staffattendancemodel->get();
            $data['userlist'] = $user_list;
            $data['class_id'] = $user_list;
            $data['user_type_id'] = $user_type_id;
            $data['section_id'] = "";
            $data['date'] = $date;
            $search = $this->input->post('search');
            $holiday = $this->input->post('holiday');
            $applied_by = $this->customlib->getAdminSessionUserName();
            $this->session->set_flashdata('msg', '');
    
            if ($search == "saveattendence") {
                $user_type_ary = $this->input->post('student_session');
                $absent_student_list = array();
                $present_staff_list = array();
                $attendance_array = array();
    
                foreach ($user_type_ary as $key => $value) {
                    $checkForUpdate = $this->input->post('attendendence_id' . $value);
                    $attendencetype = $this->input->post('attendencetype' . $value);
                    $in_time = $this->input->post("in_time_" . $value);
                    $out_time = $this->input->post("out_time_" . $value);
    
                    // Handle time inputs
                    if ((!isset($in_time) || $in_time == "") && (!isset($out_time) || $out_time == "")) {
                        $in_time = null;
                        $out_time = null;
                    } else {
                        $in_time = date('H:i:s', strtotime($in_time));
                        $out_time = date('H:i:s', strtotime($out_time));
                    }
    
                    $absent_config = $this->staff_attendance['absent'];
                    if ($attendencetype == $absent_config) {
                        $absent_student_list[] = $value;
                    } else {
                        $present_staff_list[] = $value;
                    }
                    
                    // New array-based approach
                    $attendance_array[] = array(
                        'staff_id' => $value,
                        'staff_attendance_type_id' => $attendencetype,
                        'remark' => $this->input->post("remark" . $value),
                        'in_time' => $in_time,
                        'out_time' => $out_time,
                        'date' => date('Y-m-d', $this->customlib->datetostrtotime($date)),
                        'updated_at' => date('Y-m-d', $this->customlib->datetostrtotime($date)),
                    );
                    
                    
    
                    // Original individual record processing
                    if ($checkForUpdate != 0) {
                        // Get current attendance record before updating
                        $current_attendance = $this->staffattendancemodel->getAttendanceById($checkForUpdate);
                        
                        
                        $current_attendance_type = $current_attendance['staff_attendance_type_id'];
                        
                        if (isset($holiday)) {
                            $arr = array(
                                'id' => $checkForUpdate,
                                'staff_id' => $value,
                                'staff_attendance_type_id' => 5,
                                'remark' => $this->input->post("remark" . $value),
                                'date' => date('Y-m-d', $this->customlib->datetostrtotime($date))
                            );
                        } else {
                            $arr = array(
                                'id' => $checkForUpdate,
                                'staff_id' => $value,
                                'staff_attendance_type_id' => $attendencetype,
                                'remark' => $this->input->post("remark" . $value),
                                'date' => date('Y-m-d', $this->customlib->datetostrtotime($date))
                            );
                        }
                        
                         
                        
                        // Handle leave management for attendance updates
                        if ($current_attendance_type != $attendencetype) {
                            // If changing from leave to present/other status
                            if (($current_attendance_type == 3 || $current_attendance_type == 4 || $current_attendance_type == 6 || $current_attendance_type == 2)  && !in_array($attendencetype, [3,4,6])) {
                                
                                $leave_request = $this->leaverequest_model->getLeaveByStaffIdAndDate($value, date('Y-m-d', $this->customlib->datetostrtotime($date)));
                                
                                
                                
                                if ($leave_request) {
                                    
                                    // Remove the leave record
                                    $this->leaverequest_model->leave_remove($leave_request['id']);
                                }
                                
                                // Handle Sunday leave if applicable
                                if ($this->sch_setting_detail->sch_sunday_leave == 1) {
                                    $selected_date = date('Y-m-d', $this->customlib->datetostrtotime($date));
                                    $day_of_week = date('w', strtotime($selected_date));
                                    
                                    if ($day_of_week == 1) { // Monday
                                        $sunday_date = date('Y-m-d', strtotime($selected_date . ' - 1 day'));
                                        $sunday_leave = $this->leaverequest_model->getLeaveByStaffIdAndDate($value, $sunday_date);
                                        
                                        if ($sunday_leave) {
                                            $this->leaverequest_model->leave_remove($sunday_leave['id']);
                                        }
                                    }
                                }
                            }
                            // If changing to leave from other status
                            elseif (in_array($attendencetype, [3,4,6])) {
                               
                                // Handle conversion between half-day (6) and absent (3)
                                
                                if (($current_attendance_type == 4  || $current_attendance_type == 6) && $attendencetype == 3) {
                                    // Changing from half-day to absent - need to update leave from 0.5 to 1 day
                                    $leave_request = $this->leaverequest_model->getLeaveByStaffIdAndDate($value, date('Y-m-d', $this->customlib->datetostrtotime($date)));
                                    
                                    if ($leave_request) {
                                        // Only adjust if it's a paid leave (not unpaid 101)
                                        // if ($leave_request['leave_type_id'] != 101) {
                                            // Calculate difference (1 - 0.5 = 0.5 additional days needed)
                                            $additional_days = 0.5;
                                           
                                            
                                            // Update leave record to full day
                                            $this->leaverequest_model->addLeave($leave_request['id'], $additional_days,'fullday');
                                            
                                            // Adjust alloted leave
                                            // $this->leaverequest_model->removeAllotedLeave(
                                            //     $leave_request['leave_type_id'],
                                            //     $value,
                                            //     $additional_days
                                            // );
                                        // } else {
                                        //     // For unpaid leave, just update the status
                                        //     $this->leaverequest_model->addLeave($leave_request['id'], $additional_days,'fullday');
                                        // }
                                    }
                                } 
                                elseif ($current_attendance_type == 3 && ($attendencetype == 4 || $attendencetype == 6)) {
                                    // Changing from absent to half-day - need to update leave from 1 to 0.5 day
                                    $leave_request = $this->leaverequest_model->getLeaveByStaffIdAndDate($value, date('Y-m-d', $this->customlib->datetostrtotime($date)));
                                    
                                    if ($leave_request) {
                                        // Only adjust if it's a paid leave (not unpaid 101)
                                        // if ($leave_request['leave_type_id'] != 101) {
                                            // Calculate difference (0.5 - 1 = -0.5 days to return)
                                            $return_days = 0.5;
                                            
                                        // Update leave record to half day
                                        $this->leaverequest_model->subtractLeave($leave_request['id'], $return_days,'halfday');
                                           
                                            
                                            
                                            
                                            // Adjust alloted leave
                                            // $this->leaverequest_model->addAllotedLeave(
                                            //     $leave_request['leave_type_id'],
                                            //     $value,
                                            //     $return_days
                                            // );
                                        // } else {
                                        //     // For unpaid leave, just update the status
                                        //     $this->leaverequest_model->subtractLeave($leave_request['id'], $return_days,'halfday');
                                        // }
                                    }
                                }
                                else {
                                    // Regular leave processing for new records
                                    $checkLeave = $this->leaverequest_model->check_leave($value, $date);
                                    if (!$checkLeave) {
                                        $available_leaves = $this->leaverequest_model->check_available_leave($value);
                                        $leave_type_id = 101; // Default to unpaid leave
                                        $alloted_leave = 0;
                                        
                                        if (!empty($available_leaves)) {
                                            foreach ($available_leaves as $key => $leave_value) {
                                                $staff_leave_days = $this->leaverequest_model->get_staff_leave($value,$leave_value['leave_type_id']);
                                                if ($leave_value['leave_type_id'] == 3) { // Check for casual leave first
                                                    if ($leave_value['alloted_leave'] >= 1 && $leave_value['alloted_leave']>$staff_leave_days) {
                                                        $leave_type_id = $leave_value['leave_type_id'];
                                                        $alloted_leave = $leave_value['alloted_leave'];
                                                        break;
                                                    }
                                                } elseif ($leave_value['alloted_leave'] > 0 && $leave_value['alloted_leave']>$staff_leave_days) {
                                                    $leave_type_id = $leave_value['leave_type_id'];
                                                    $alloted_leave = $leave_value['alloted_leave'];
                                                    break;
                                                }
                                            }
                                        }
                                        
                                        $half_leave_status = ($attendencetype == 3) ? 'fullday' : 'halfday';
                                        $leave_days = ($attendencetype == 3) ? 1 : 0.5;
                                        
                                        $leavedata = array(
                                            'staff_id' => $value,
                                            'date' => date("Y-m-d", $this->customlib->datetostrtotime($date)),
                                            'leave_type_id' => $leave_type_id,
                                            'leave_from' => date("Y-m-d", $this->customlib->datetostrtotime($date)),
                                            'half_leave_status' => $half_leave_status,
                                            'leave_days' => $leave_days,
                                            'leave_to' => date("Y-m-d", $this->customlib->datetostrtotime($date)),
                                            'employee_remark' => ($attendencetype == 3) ? 'Absent' : 'Half Day',
                                            'status' => 'approved',
                                            'admin_remark' => ($attendencetype == 3) ? 'Absent' : 'Half Day',
                                            'applied_by' => $applied_by
                                        );
                                        
                                        $this->leaverequest_model->addLeaveRequest($leavedata);
                                        
                                        // if ($leave_type_id != 101) {
                                        //     $updated_alloted_leave = $alloted_leave - $leave_days;
                                        //     $update_leave_data['alloted_leave'] = $updated_alloted_leave;
                                        //     // $this->leaverequest_model->adjustAllotedLeave($leave_type_id, $value, $update_leave_data);
                                        // }
                                    }
                                }
                            }
                            else if ($attendencetype == 2) {
                                
                                // Get current week's Monday and Sunday dates
                                $current_date = date('Y-m-d', $this->customlib->datetostrtotime($date));
                                $monday_date = date('Y-m-d', strtotime('monday this week', strtotime($current_date)));
                                $sunday_date = date('Y-m-d', strtotime('sunday this week', strtotime($current_date)));
                                
                                // Count existing half-day attendances this week (type 4)
                                $late_count = $this->leaverequest_model->countWeeklyLate($value, $monday_date, $sunday_date);
                                
                                // If this is the 3rd half-day this week
                                if ($late_count >= 2) {
                                    // Check if we already processed this conversion
                                    
                                    $checkLeave = $this->leaverequest_model->check_leave($value, $date);
                                    
                                    if (!$checkLeave) {
                                        // Create 1 day leave for 3 half-days
                                        $available_leaves = $this->leaverequest_model->check_available_leave($value);
                                        $leave_type_id = 101; // Default to unpaid
                                        $alloted_leave = 0;
                                        
                                        if (!empty($available_leaves)) {
                                            foreach ($available_leaves as $leave_value) {
                                                $staff_leave_days = $this->leaverequest_model->get_staff_leave($value,$leave_value['leave_type_id']);
                                                if ($leave_value['leave_type_id'] == 3 && $leave_value['alloted_leave'] >= 1) {
                                                    $leave_type_id = $leave_value['leave_type_id'];
                                                    $alloted_leave = $leave_value['alloted_leave'];
                                                    break;
                                                } elseif ($leave_value['alloted_leave'] > 0 && $leave_value['alloted_leave']>$staff_leave_days) {
                                                    $leave_type_id = $leave_value['leave_type_id'];
                                                    $alloted_leave = $leave_value['alloted_leave'];
                                                }
                                            }
                                        }
                                        
                                        $leavedata = [
                                            'staff_id' => $value,
                                            'date' => $current_date,
                                            'leave_type_id' => $leave_type_id,
                                            'leave_from' => $current_date,
                                            'leave_to' => $current_date,
                                            'half_leave_status' => 'fullday',
                                            'leave_days' => 1,
                                            'employee_remark' => 'Auto leave for 3 half-days',
                                            'status' => 'approved',
                                            'admin_remark' => 'Converted from 3 half-day attendances',
                                            'applied_by' => $applied_by,
                                            'is_auto_converted' => 1 // Mark as auto-converted
                                        ];
                                        
                                        $this->leaverequest_model->addLeaveRequest($leavedata);
                                        
                                        // if ($leave_type_id != 101) {
                                        //     $this->leaverequest_model->adjustAllotedLeave(
                                        //         $leave_type_id, 
                                        //         $value, 
                                        //         ['alloted_leave' => $alloted_leave - 1]
                                        //     );
                                        // }
                                        
                                        
                                    }
                                } 
                            }
                        }
                        
                        $this->staffattendancemodel->add($arr);
                    } else {
                        if (isset($holiday)) {
                            $arr = array(
                                'staff_id' => $value,
                                'staff_attendance_type_id' => 5,
                                'date' => date('Y-m-d', $this->customlib->datetostrtotime($date)),
                                'remark' => ''
                            );
                        } else {
                            $arr = array(
                                'staff_id' => $value,
                                'staff_attendance_type_id' => $attendencetype,
                                'date' => date('Y-m-d', $this->customlib->datetostrtotime($date)),
                                'remark' => $this->input->post("remark" . $value),
                            );
    
                            // Leave management logic for new attendance records
                            if ($attendencetype == 3 || $attendencetype == 4 || $attendencetype == 6) {
                                $checkLeave = $this->leaverequest_model->check_leave($value, $date);
                                if (!$checkLeave) {
                                    $available_leaves = $this->leaverequest_model->check_available_leave($value);
                                    
                                    $leave_type_id = 101;
                                    $alloted_leave = 0;
    
                                    if (!empty($available_leaves)) {
                                        foreach ($available_leaves as $key => $leave_value) {
                                            $staff_leave_days = $this->leaverequest_model->get_staff_leave($value,$leave_value['leave_type_id']);
                                            if ($leave_value['leave_type_id'] == 3) {
                                                if ($leave_value['alloted_leave'] >= 1 && $leave_value['alloted_leave']>$staff_leave_days) {
                                                    $leave_type_id = $leave_value['leave_type_id'];
                                                    $alloted_leave = $leave_value['alloted_leave'];
                                                    break;
                                                }
                                            } elseif ($leave_value['alloted_leave'] > 0 && $leave_value['alloted_leave']>$staff_leave_days) {
                                                $leave_type_id = $leave_value['leave_type_id'];
                                                $alloted_leave = $leave_value['alloted_leave'];
                                                break;
                                            }
                                        }
                                    }
    
                                    $half_leave_status = ($attendencetype == 3) ? 'fullday' : 'halfday';
                                    $leave_days = ($attendencetype == 3) ? 1 : 0.5;
    
                                    $leavedata = array(
                                        'staff_id' => $value,
                                        'date' => date("Y-m-d", $this->customlib->datetostrtotime($date)),
                                        'leave_type_id' => $leave_type_id,
                                        'leave_from' => date("Y-m-d", $this->customlib->datetostrtotime($date)),
                                        'half_leave_status' => $half_leave_status,
                                        'leave_days' => $leave_days,
                                        'leave_to' => date("Y-m-d", $this->customlib->datetostrtotime($date)),
                                        'employee_remark' => 'Absent',
                                        'status' => 'approved',
                                        'admin_remark' => 'Absent',
                                        'applied_by' => $applied_by
                                    );
    
                                    $this->leaverequest_model->addLeaveRequest($leavedata);
    
                                    // if ($leave_type_id != 101) {
                                    //     $updated_alloted_leave = $alloted_leave - $leave_days;
                                    //     $update_leave_data['alloted_leave'] = $updated_alloted_leave;
                                    //     $this->leaverequest_model->adjustAllotedLeave($leave_type_id, $value, $update_leave_data);
                                    // }
                                }
                            }
                            else if ($attendencetype == 2) {
                                // Get current week's Monday and Sunday dates
                                $current_date = date('Y-m-d', $this->customlib->datetostrtotime($date));
                                $monday_date = date('Y-m-d', strtotime('monday this week', strtotime($current_date)));
                                $sunday_date = date('Y-m-d', strtotime('sunday this week', strtotime($current_date)));
                                
                                // Count existing half-day attendances this week (type 4)
                                $late_count = $this->leaverequest_model->countWeeklyLate($value, $monday_date, $sunday_date);
                                
                                // If this is the 3rd half-day this week
                                if ($late_count >= 2) {
                                    // Check if we already processed this conversion
                                    
                                    $checkLeave = $this->leaverequest_model->check_leave($value, $date);
                                    
                                    if (!$checkLeave) {
                                        // Create 1 day leave for 3 half-days
                                        $available_leaves = $this->leaverequest_model->check_available_leave($value);
                                        $leave_type_id = 101; // Default to unpaid
                                        $alloted_leave = 0;
                                        
                                        if (!empty($available_leaves)) {
                                            foreach ($available_leaves as $leave_value) {
                                                $staff_leave_days = $this->leaverequest_model->get_staff_leave($value,$leave_value['leave_type_id']);
                                                if ($leave_value['leave_type_id'] == 3 && $leave_value['alloted_leave'] >= 1 && $leave_value['alloted_leave']>$staff_leave_days) {
                                                    $leave_type_id = $leave_value['leave_type_id'];
                                                    $alloted_leave = $leave_value['alloted_leave'];
                                                    break;
                                                } elseif ($leave_value['alloted_leave'] > 0 && $leave_value['alloted_leave']>$staff_leave_days) {
                                                    $leave_type_id = $leave_value['leave_type_id'];
                                                    $alloted_leave = $leave_value['alloted_leave'];
                                                }
                                            }
                                        }
                                        
                                        $leavedata = [
                                            'staff_id' => $value,
                                            'date' => $current_date,
                                            'leave_type_id' => $leave_type_id,
                                            'leave_from' => $current_date,
                                            'leave_to' => $current_date,
                                            'half_leave_status' => 'fullday',
                                            'leave_days' => 1,
                                            'employee_remark' => 'Auto leave for 3 half-days',
                                            'status' => 'approved',
                                            'admin_remark' => 'Converted from 3 half-day attendances',
                                            'applied_by' => $applied_by,
                                            'is_auto_converted' => 1 // Mark as auto-converted
                                        ];
                                        
                                        $this->leaverequest_model->addLeaveRequest($leavedata);
                                        
                                        // if ($leave_type_id != 101) {
                                        //     $this->leaverequest_model->adjustAllotedLeave(
                                        //         $leave_type_id, 
                                        //         $value, 
                                        //         ['alloted_leave' => $alloted_leave - 1]
                                        //     );
                                        // }
                                        
                                        
                                    }
                                } 
                            }
    
                            // Process Saturday and Monday absences
                            if ($this->sch_setting_detail->sch_sunday_leave == 1) {
                                $selected_date = date('Y-m-d', $this->customlib->datetostrtotime($date));
                                $day_of_week = date('w', strtotime($selected_date));
    
                                if ($day_of_week == 1) {
                                    $saturday_date = date('Y-m-d', strtotime($selected_date . ' - 2 days'));
                                    $monday_date = $selected_date;
                                } else {
                                    $monday_date = date('Y-m-d', strtotime($selected_date . ' next Monday'));
                                    $saturday_date = date('Y-m-d', strtotime($monday_date . ' - 1 day'));
                                }
    
                                $saturday_absent = $this->staffattendancemodel->checkAttendance($value, $saturday_date);
                                $monday_absent = $this->staffattendancemodel->checkAttendance($value, $monday_date);
    
                                if ($saturday_absent && $monday_absent) {
                                    $checkLeave = $this->leaverequest_model->check_leave($value, date("Y-m-d", strtotime($saturday_date . ' + 1 day')));
                                    if (!$checkLeave) {
                                        $available_leaves = $this->leaverequest_model->check_available_leave($value);
                                        $leave_type_id = 101;
                                        $alloted_leave = 0;
    
                                        if (!empty($available_leaves)) {
                                            foreach ($available_leaves as $key => $leave_value) {
                                                $staff_leave_days = $this->leaverequest_model->get_staff_leave($value,$leave_value['leave_type_id']);
                                                if ($leave_value['leave_type_id'] == 3) {
                                                    if ($leave_value['alloted_leave'] >= 1 && $leave_value['alloted_leave']>$staff_leave_days) {
                                                        $leave_type_id = $leave_value['leave_type_id'];
                                                        $alloted_leave = $leave_value['alloted_leave'];
                                                        break;
                                                    }
                                                } elseif ($leave_value['alloted_leave'] > 0 && $leave_value['alloted_leave']>$staff_leave_days) {
                                                    $leave_type_id = $leave_value['leave_type_id'];
                                                    $alloted_leave = $leave_value['alloted_leave'];
                                                    break;
                                                }
                                            }
                                        }
    
                                        $leave_days = ($half_leave_status == 'halfday') ? 0.5 : 1;
                                        $half_leave_status = ($half_leave_status == 'halfday') ? 'halfday' : 'fullday';
    
                                        $leavedata = array(
                                            'staff_id' => $value,
                                            'date' => date("Y-m-d", strtotime($saturday_date . ' + 1 day')),
                                            'leave_type_id' => $leave_type_id,
                                            'leave_from' => date("Y-m-d", strtotime($saturday_date . ' + 1 day')),
                                            'half_leave_status' => $half_leave_status,
                                            'leave_days' => $leave_days,
                                            'leave_to' => date("Y-m-d", strtotime($saturday_date . ' + 1 day')),
                                            'employee_remark' => 'Absent',
                                            'status' => 'approved',
                                            'admin_remark' => 'Absent On Saturday and Monday',
                                            'applied_by' => $applied_by
                                        );
    
                                        $this->leaverequest_model->addLeaveRequest($leavedata);
    
                                        // if ($leave_type_id != 101) {
                                        //     $updated_alloted_leave = $alloted_leave - $leave_days;
                                        //     $update_leave_data['alloted_leave'] = $updated_alloted_leave;
                                        //     $this->leaverequest_model->adjustAllotedLeave($leave_type_id, $value, $update_leave_data);
                                        // }
                                    }
                                }
                            }
                        }
                        $this->staffattendancemodel->add($arr);
                    }
                }
    
                // Use the batch update method if available
                if (!empty($attendance_array)) {
                    $this->staffattendancemodel->addorUpdate($attendance_array);
                }
    
                // Send notifications
                // if (!empty($absent_student_list)) {
                //     $this->mailsmsconf->mailsms('absent_attendence', $absent_student_list, $date);
                //     $this->mailsmsconf->mailsms('staff_absent_attendence', $absent_student_list, $date);
                // }
                // if (!empty($present_staff_list)) {
                //     $this->mailsmsconf->mailsms('staff_present_attendence', $present_staff_list, $date);
                // }
    
                $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
                redirect('admin/staffattendance/index');
            }
    
            $attendencetypes = $this->attendencetype_model->getStaffAttendanceType();
            $data['attendencetypeslist'] = $attendencetypes;
            $resultlist = $this->staffattendancemodel->searchAttendenceUserType($user_type, date('Y-m-d', $this->customlib->datetostrtotime($date)));
            
            if (!empty($resultlist)) {
                foreach ($resultlist as $key => $value) {
                    if (!IsNullOrEmptyString($value['staff_attendance_type_id'])) {
                        $is_first_time_attendance = false;
                    }
                }
            }
            
            $data['is_first_time_attendance'] = $is_first_time_attendance;
            $data['resultlist'] = $resultlist;
    
            $this->load->view('layout/header', $data);
            $this->load->view('admin/staffattendance/staffattendancelist', $data);
            $this->load->view('layout/footer', $data);
        }
    }

    public function monthAttendance($st_month, $no_of_months, $emp)
    {
        $this->load->model("payroll_model");
        $record = array();
        $r     = array();
        $month = date('m', strtotime($st_month));
        $year  = date('Y', strtotime($st_month));
        foreach ($this->staff_attendance as $att_key => $att_value) {
            $s = $this->payroll_model->count_attendance_obj($month, $year, $emp, $att_value);
            $r[$att_key] = $s;
        }

        $record[$emp] = $r;
        return $record;
    }

    public function profileattendance()
    {
        $monthlist             = $this->customlib->getMonthDropdown();
        $startMonth            = $this->setting_model->getStartMonth();
        $data["monthlist"]     = $monthlist;
        $data['yearlist']      = $this->staffattendancemodel->attendanceYearCount();
        $staffRole             = $this->staff_model->getStaffRole();
        $data["role"]          = $staffRole;
        $data["role_selected"] = "";
        $j                     = 0;
        for ($i = 1; $i <= 31; $i++) {
            $att_date = sprintf("%02d", $i);
            $attendence_array[] = $att_date;
            foreach ($monthlist as $key => $value) {
                $datemonth       = date("m", strtotime($value));
                $att_dates       = date("Y") . "-" . $datemonth . "-" . sprintf("%02d", $i);
                $date_array[]    = $att_dates;
                $res[$att_dates] = $this->staffattendancemodel->searchStaffattendance($att_dates, $staff_id = 8);
            }

            $j++;
        }

        $data["resultlist"]       = $res;
        $data["attendence_array"] = $attendence_array;
        $data["date_array"]       = $date_array;
        $this->load->view("layout/header");
        $this->load->view("admin/staff/staffattendance", $data);
        $this->load->view("layout/footer");
    }

}
