<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Staff_loan extends Admin_Controller
{
 
    public function __construct()
    {
        parent::__construct();
        $this->load->helper('form');
        $this->config->load('app-config');
        $this->load->library("datatables");
        $this->load->model('staff_loan_model');
    }

    public function index()
    {

        

        $this->session->set_userdata('top_menu', 'HR');
        $this->session->set_userdata('sub_menu', 'admin/staff_loan');
        $data['title']      = 'Add Loan';
        
        $this->form_validation->set_rules('staff_id[]', $this->lang->line('staff'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('loan_amount', $this->lang->line('amount'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('emi_amount', 'EMI Amount', 'trim|required|xss_clean');
        if ($this->form_validation->run() == false) {

        } else {
            $staff_id = $this->input->post('staff_id');

            foreach ($staff_id as $key => $value) {
                
            
            $data = array(
                'staff_id'            => $value,
                'loan_amount'         => $this->input->post('loan_amount'),
                'actual_loan_amount'  => $this->input->post('loan_amount'),
                'emi_amount'          => $this->input->post('emi_amount'),
                
            );

            $insert_id = $this->staff_loan_model->add($data);
        }
            
            
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/staff_loan/index');
        }

        $staff_loan_result   = $this->staff_loan_model->get();
        $data['loanlist']    = $staff_loan_result;
        $stafflist           = $this->staff_model->get();
        $data['stafflist']   = $stafflist;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/staff/loanList', $data);
        $this->load->view('layout/footer', $data);
    }

    public function download($documents)
    {
        $this->load->helper('download');
        $filepath = "./uploads/school_income/" . $this->uri->segment(6);
        $data     = file_get_contents($filepath);
        $name     = $this->uri->segment(6);
        force_download($name, $data);
    }

    public function view($id)
    {
        if (!$this->rbac->hasPrivilege('income', 'can_view')) {
            access_denied();
        }
        $data['title']  = 'Fees Master List';
        $income         = $this->income_model->get($id);
        $data['income'] = $income;
        $this->load->view('layout/header', $data);
        $this->load->view('income/incomeShow', $data);
        $this->load->view('layout/footer', $data);
    }

    public function getByFeecategory()
    {
        $feecategory_id = $this->input->get('feecategory_id');
        $data           = $this->feetype_model->getTypeByFeecategory($feecategory_id);
        echo json_encode($data);
    }

    public function getStudentCategoryFee()
    {
        $type     = $this->input->post('type');
        $class_id = $this->input->post('class_id');
        $data     = $this->income_model->getTypeByFeecategory($type, $class_id);
        if (empty($data)) {
            $status = 'fail';
        } else {
            $status = 'success';
        }
        $array = array('status' => $status, 'data' => $data);
        echo json_encode($array);
    }

    public function getIncomeData()
    {
        $id     = $this->input->post('id');
        $voucher_no=$this->input->post('voucher_no');
        $data    = $this->income_model->get($id);
        
        $feetype_id=$data['inc_head_id'];
        $feetypeData=$this->feetype_model->get($feetype_id);
        $data['account_number']=$feetypeData['account_number'];
        $vdata    = $this->income_model->getvoucher($voucher_no);
        if (!empty($vdata)) {
           $data['voucher_data']=$vdata;
        }else{
            $data['voucher_data']='';
        }
      
        $data['wordsAmount']  = getIndianCurrencyInWord($data['amount'],'','');
      
        echo json_encode($data);
    }

    public function createVoucher()
    {
        $voucher_name     = $this->input->post('voucher_name');
        $voucher_date     = $this->input->post('voucher_date');
        $voucher_amount     = $this->input->post('voucher_amount');
        $income_head_id     = $this->input->post('income_head_id');
        $description     = $this->input->post('description');
        $voucher_no     = $this->input->post('voucher_no');
        $ac_no     = $this->input->post('ac_no');
        $file_no     = $this->input->post('file_no');
        $address     = $this->input->post('address');
        $voucher_type     = $this->input->post('voucher_type');

        $data= array(
            'voucher_name' =>$voucher_name ,
            'voucher_date' =>$voucher_date ,
            'voucher_amount' =>$voucher_amount ,
            'inc_head_id' =>$income_head_id ,
            'description' =>$description ,
            'voucher_no' =>$voucher_no ,
            'ac_no' =>$ac_no ,
            'file_no' =>$file_no , 
            'address' =>$address,
            'voucher_type'=>$voucher_type
        );


        $this->income_model->createvoucher($data);
    }
  
    public function delete($id)
    {
        
        $this->staff_loan_model->remove($id);
        redirect('admin/staff_loan/index');
    }

    public function create()
    {
        $data['title'] = 'Add Fees Master';
        $this->form_validation->set_rules('income', $this->lang->line('fees_master'), 'trim|required|xss_clean');
        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('income/incomeCreate', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $data = array(
                'income' => $this->input->post('income'),
            );
            $this->income_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('income/index');
        }
    }

    public function handle_upload()
    {

        $image_validate = $this->config->item('file_validate');
        $result         = $this->filetype_model->get();
        if (isset($_FILES["documents"]) && !empty($_FILES['documents']['name'])) {

            $file_type = $_FILES["documents"]['type'];
            $file_size = $_FILES["documents"]["size"];
            $file_name = $_FILES["documents"]["name"];

            $allowed_extension = array_map('trim', array_map('strtolower', explode(',', $result->file_extension)));
            $allowed_mime_type = array_map('trim', array_map('strtolower', explode(',', $result->file_mime)));
            $ext               = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

            if ($files = filesize($_FILES['documents']['tmp_name'])) {

                if (!in_array($file_type, $allowed_mime_type)) {
                    $this->form_validation->set_message('handle_upload', 'File Type Not Allowed');
                    return false;
                }

                if (!in_array($ext, $allowed_extension) || !in_array($file_type, $allowed_mime_type)) {
                    $this->form_validation->set_message('handle_upload', 'Extension Not Allowed');
                    return false;
                }
                if ($file_size > $result->file_size) {
                    $this->form_validation->set_message('handle_upload', $this->lang->line('file_size_shoud_be_less_than') . number_format($image_validate['upload_size'] / 1048576, 2) . " MB");
                    return false;
                }
            } else {
                $this->form_validation->set_message('handle_upload', "File Type / Extension Error Uploading  Image");
                return false;
            }

            return true;
        }
        return true;
    }

    public function edit($id)
    {
        
        
        $data['id']        = $id;
        $loan              = $this->staff_loan_model->get($id);
        $data['loan']      = $loan;
        $stafflist         = $this->staff_model->get();
        $data['stafflist'] = $stafflist;
        $this->form_validation->set_rules('staff_id', $this->lang->line('staff'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('loan_amount', $this->lang->line('amount'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('emi_amount', 'EMI Amount', 'trim|required|xss_clean');
        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/staff/loanEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $data = array(
                'id'                => $id,
                'staff_id'          => $this->input->post('staff_id'),
                'loan_amount'       => $this->input->post('loan_amount'),
                'actual_loan_amount'=> $this->input->post('loan_amount'),
                'emi_amount'        => $this->input->post('emi_amount')
            );
            $insert_id = $this->staff_loan_model->add($data);
            
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/staff_loan/index');
        }
    }

    public function incomeSearch()
    {
        if (!$this->rbac->hasPrivilege('search_due_fees', 'can_view')) {
            access_denied();
        }
        $data['searchlist'] = $this->customlib->get_searchtype();
        $this->session->set_userdata('top_menu', 'Income');
        $this->session->set_userdata('sub_menu', 'income/incomesearch');
        $data['search_type'] = '';
        $data['title']       = 'Search Income';
        $this->load->view('layout/header', $data);
        $this->load->view('admin/income/incomeSearch', $data);
        $this->load->view('layout/footer', $data);

    }

    public function getloanlist()
    {

        $m               = $this->staff_loan_model->getlist();
        $m               = json_decode($m);
        
        $dt_data         = array();
        if (!empty($m->data)) {
            foreach ($m->data as $key => $value) {
                $editbtn     = '';
                $deletebtn   = '';
                $documents   = '';
                

                    $editbtn = "<a href='" . base_url() . "admin/Staff_loan/edit/" . $value->id . "'   class='btn btn-default btn-xs'  data-toggle='tooltip' data-placement='left' title='" . $this->lang->line('edit') . "'><i class='fa fa-pencil'></i></a>";
                

                


                
                    $deletebtn = '';
                    $deletebtn = "<a onclick='return confirm(" . '"' . $this->lang->line('delete_confirm') . '"' . "  )' href='" . base_url() . "admin/Staff_loan/delete/" . $value->id . "' class='btn btn-default btn-xs' data-placement='left' title='" . $this->lang->line('delete') . "' data-toggle='tooltip'><i class='fa fa-trash'></i></a>";
                


                
                $row   = array();
                $row[] = $value->name .' '. $value->surname;
                $row[]     = $value->actual_loan_amount;
                $row[]     = $value->loan_amount;
                $row[]     = $value->emi_amount;
                $row[]     = $editbtn . ' ' . $deletebtn;
                $dt_data[] = $row;
            }
        }

        $json_data = array(
            "draw"            => intval($m->draw),
            "recordsTotal"    => intval($m->recordsTotal),
            "recordsFiltered" => intval($m->recordsFiltered),
            "data"            => $dt_data,
        );
        echo json_encode($json_data);
    }

    public function checkvalidation()
    {
        $search    = $this->input->post('search');
        $date_from = "";
        $date_to   = "";
        if ($search == "search_filter") {
            $this->form_validation->set_rules('search_type', $this->lang->line('search') . " " . $this->lang->line('type'), 'trim|required|xss_clean');
            if ($this->form_validation->run() == false) {
                $msg        = array('search_type' => form_error('search_type'));
                $json_array = array('status' => 'fail', 'error' => $msg, 'message' => '');

            } else {
                $search_type = $this->input->post('search_type');
                $date_from   = $this->input->post('date_from');
                $date_to     = $this->input->post('date_to');

                if (isset($date_from) && $date_from != "" && isset($date_to) && $date_to != "") {
                    $date_from = strtotime($date_from);
                    $date_to   = strtotime($date_to);
                }

                $json_array = array('status' => 'success', 'error' => '', 'search_type' => $search_type, 'message' => $this->lang->line('success_message'), 'date_from' => $date_from, 'date_to' => $date_to);
            }
        } else {

            $this->form_validation->set_rules('search_text', $this->lang->line('search_text'), 'trim|required|xss_clean');
            if ($this->form_validation->run() == false) {
                $msg        = array('search_text' => form_error('search_text'));
                $json_array = array('status' => 'fail', 'error' => $msg, 'message' => '');

            } else {
                $search_type = $this->input->post('search_text');

                $json_array = array('status' => 'success', 'error' => '', 'search_type' => $search_type, 'message' => $this->lang->line('success_message'));
            }
        }
        echo json_encode($json_array);
    }

    public function getincomesearchlist($str)
    {
        $res         = explode("-", $str);
        $search_type = $res[0];
        $search      = $res[1];
        if (count($res) == 4) {
            $date_from = $res[2];
            $date_to   = $res[3];
            $date_from = date('Y-m-d', $date_from);
            $date_to   = date('Y-m-d', $date_to);
        }

        if ($search == "search_filter") {

            if (isset($search_type) && $search_type != '') {

                if ($search_type == 'all') {
                    $dates = $this->customlib->get_betweendate('this_year');
                }
                if ($search_type == 'period') {
                    $dates['from_date'] = $date_from;
                    $dates['to_date']   = $date_to;
                } else {

                    $dates = $this->customlib->get_betweendate($search_type);

                }

                $data['search_type'] = $search_type;
            } else {

                $dates               = $this->customlib->get_betweendate('this_year');
                $data['search_type'] = '';
            }

            $dateformat = $this->customlib->getSchoolDateFormat();
            $this->customlib->dateFormatToYYYYMMDD($dates['from_date']);
            $date_from         = date('Y-m-d', strtotime($dates['from_date']));
            $date_to           = date('Y-m-d', strtotime($dates['to_date']));
            $search            = $this->input->post('search');
            $data['inc_title'] = 'Income Result From ' . date($dateformat, strtotime($date_from)) . " To " . date($dateformat, strtotime($date_to));

            $date_from  = date('Y-m-d', $this->customlib->dateYYYYMMDDtoStrtotime($date_from));
            $date_to    = date('Y-m-d', $this->customlib->dateYYYYMMDDtoStrtotime($date_to));
            $resultList = $this->income_model->search("", $date_from, $date_to);
            $resultList = $resultList;
        } else {

            $search_text = $search_type;
            $resultList  = $this->income_model->search($search_text, "", "");
            $resultList  = $resultList;
        }
        $m               = json_decode($resultList);
        $currency_symbol = $this->customlib->getSchoolCurrencyFormat();
        $dt_data         = array();
        $total_amount    = 0;
        if (!empty($m->data)) {
            foreach ($m->data as $key => $value) {
                $total_amount += $value->amount;
                $row       = array();
                $row[]     = $value->name;
                $row[]     = $value->invoice_no;
                $row[]     = $value->income_category;
                $row[]     = date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($value->date));
                $row[]     = $currency_symbol . $value->amount;
                $dt_data[] = $row;
            }
            $footer_row   = array();
            $footer_row[] = "";
            $footer_row[] = "";
            $footer_row[] = "";
            $footer_row[] = "";
            $footer_row[] = "<b>" . $this->lang->line('grand_total') . " : " . $currency_symbol . $total_amount . "</b>";
            $dt_data[]    = $footer_row;
        }

        $json_data = array(
            "draw"            => intval($m->draw),
            "recordsTotal"    => intval($m->recordsTotal),
            "recordsFiltered" => intval($m->recordsFiltered),
            "data"            => $dt_data,
        );
        echo json_encode($json_data);

    }

}
