<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class SessionCopy extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->database(); // Load database here
        $this->load->library('Customlib');
        $this->sch_current_session = $this->setting_model->getCurrentSession();
        $this->staff_id            = $this->customlib->getStaffID();
        $this->load->library("datatables");
    }
    public function index()
    {
       

        $this->session->set_userdata('top_menu', 'lessonplan');
        $this->session->set_userdata('sub_menu', 'admin/lessonplan');


        $data                    = array();
        $data['current_session'] = $this->sch_current_session;

        $data['no_record']        = '0';
        $session_result           = $this->session_model->get();
        $data['sessionlist']      = $session_result;
        $class                    = $this->class_model->get();
        $data['classlist']        = $class;
        $data['class_id']         = "";
        $data['section_id']       = "";
        $data['subject_group_id'] = "";
        $data['subject_id']       = "";
        $data['subject_name']     = "";
        $data['lessons']          = array();
        
$this->db->order_by('id', 'desc');
$this->db->select('l.*, s1.session as old_session_name, s2.session as new_session_name');
$this->db->from('session_transfer_logs l');
$this->db->join('sessions s1', 's1.id = l.old_session_id', 'left');
$this->db->join('sessions s2', 's2.id = l.new_session_id', 'left');
$data['getLogsData'] = $this->db->get()->result_array();

        $this->load->view('layout/header');
        $this->load->view('admin/sessionCopy/copyOldSession', $data);
        $this->load->view('layout/footer');
    }
    public function transferModule()
    {

        $data['title'] = 'Transfer Module';
        $this->form_validation->set_rules('module_name', $this->lang->line('module_name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('old_session_id', $this->lang->line('old_session_id'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('new_session_id', $this->lang->line('new_session_id'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {
            $msg = array(
                'topic_id'                 => form_error('topic_id[]'),
                'class_id'                 => form_error('class_id'),
                'section_id'               => form_error('section_id'),
                'subject_group_subject_id' => form_error('subject_group_id'),
                'subject_id'               => form_error('subject_group_subject_id'),
            );
            $array = array('status' => 0, 'error' => $msg, 'message' => '');
        } else {

            $array = array('status' => 1, 'error' => '', 'message' => $this->lang->line('success_message'), 'redirect_url' => site_url('admin/lessonplan/lesson'));


            $module_name = $_POST['module_name'];
            $old_session_id = $_POST['old_session_id'];
            $new_session_id = $_POST['new_session_id'];
            $transfer = $_POST['transfer'];
            if($module_name == 'AcademicModule')
            {
                $this->transferAcademicModule($old_session_id,$new_session_id);
                $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
                $this->storeTransferLogs('AcademicModule',$old_session_id,$new_session_id,'Old to New Transfer','Data Transfer');
                redirect('admin/SessionCopy/index');

            }

            // Log Insert
            $module_name    = $this->input->post('module_name', true);
            $old_session_id = (int) $this->input->post('old_session_id');
            $new_session_id = (int) $this->input->post('new_session_id');
            $transfer       = $this->input->post('transfer', true);
            $note           = 'Transfer Module';// ← your custom note

            exit();
            
        }
        echo json_encode($array);
    }
// Start

    public function storeTransferLogs($module_name,$old_session_id,$new_session_id,$transfer,$note)
    {

            $data = array(
                'module_name'    => $module_name,
                'old_session_id' => $old_session_id,
                'new_session_id' => $new_session_id,
                'transfer'       => $transfer,
                'note'           => $note,
                'created_at'     => date('Y-m-d H:i:s')
            );

            $this->db->insert('session_transfer_logs', $data);
    }
    public function transferAcademicModule($old_session_id,$new_session_id)
    {

        // 1.Class Timetable & 2.Teacher Time Table
                $sql = "
                    INSERT INTO subject_timetable (
                        session_id, class_id, section_id, subject_group_id, subject_group_subject_id,
                        staff_id, day, time_from, time_to, start_time, end_time, room_no,
                        created_at, updated_at
                    )
                    SELECT
                        $new_session_id, class_id, section_id, subject_group_id, subject_group_subject_id,
                        staff_id, day, time_from, time_to, start_time, end_time, room_no,
                        NOW(), NOW()
                    FROM subject_timetable
                    WHERE session_id = $old_session_id
                ";
                $this->db->query($sql);

        // 3.Assign Class Teacher
            $assingClassSql = "
                INSERT INTO class_teacher (
                    session_id, class_id, section_id, staff_id
                )
                SELECT
                    $new_session_id, class_id, section_id, staff_id
                FROM class_teacher
                WHERE session_id = $old_session_id";
            $this->db->query($assingClassSql);

        // 4.Subject Group
                // SELECT * FROM `subject_groups`
                //     SELECT `id`, `name`, `description`, `session_id`, `created_at`, `updated_at` FROM `subject_groups` WHERE 1
            $subjectGroupSql = "
                INSERT INTO subject_groups (
                    name, description, session_id, created_at, updated_at
                )
                SELECT
                    name, description, $new_session_id, NOW(), NOW()
                FROM subject_groups
                WHERE session_id = $old_session_id
            ";

        $this->db->query($subjectGroupSql);
return true;
    }
// End


}
