<?php

class LeaveTypes extends Admin_Controller
{

    public function __construct()
    {

        parent::__construct();
        $this->load->helper('file');
        $this->config->load("payroll");
        $this->load->model('leavetypes_model');
        $this->load->model('staff_model');
    }

    public function index()
    {
        $this->session->set_userdata('top_menu', 'HR');
        $this->session->set_userdata('sub_menu', 'admin/leavetypes');
        $data["title"]     = $this->lang->line('add_leave_type');
       
        $LeaveTypes = $this->leavetypes_model->getLeaveType();

        $staffRole = $this->staff_model->getStaffRole();

        $data["staffrole"] = $staffRole;
        $data["leavetype"] = $LeaveTypes;
        $this->load->view("layout/header");
        $this->load->view("admin/staff/leavetypes", $data);
        $this->load->view("layout/footer");
    }

    public function createleavetype()
    {
        $this->form_validation->set_rules(
            'type', $this->lang->line('name'), array('required',
                array('check_exists', array($this->leavetypes_model, 'valid_leave_type')),
            )
        );
        
        $leavetypeid = $this->input->post("leavetypeid");
        
        if (!empty($leavetypeid)) {
            $data["title"] = $this->lang->line('edit_leave_type');            
            $result            = $this->staff_model->getLeaveType($leavetypeid);        
            $data["result"]    = $result;        
        } else {
            $data["title"] = $this->lang->line('add_leave_type');
        }  
        
        if ($this->form_validation->run()) {

            $type        = $this->input->post("type");
            
            $status      = $this->input->post("status");
            if (empty($leavetypeid)) {

                if (!$this->rbac->hasPrivilege('leave_types', 'can_add')) {
                    access_denied();
                }
            } else {

                if (!$this->rbac->hasPrivilege('leave_types', 'can_edit')) {
                    access_denied();
                }
            }

            if (!empty($leavetypeid)) {
                $data = array('type' => $type, 'is_active' => 'yes', 'id' => $leavetypeid);
            } else {

                $data = array('type' => $type, 'is_active' => 'yes');
            }

            $insert_id = $this->leavetypes_model->addLeaveType($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">' . $this->lang->line('success_message') . '</div>');
            redirect("admin/leavetypes");
        } else {

            $LeaveTypes        = $this->leavetypes_model->getLeaveType();
            $data["leavetype"] = $LeaveTypes;
            $this->load->view("layout/header");
            $this->load->view("admin/staff/leavetypes", $data);
            $this->load->view("layout/footer");
        }
    }

    public function AssignLeaves()
    {
    //     ini_set('display_errors', 1);
    // error_reporting(E_ALL);
        $role_id = $this->input->post('role_id');
        $leave_type = $this->input->post('leave_type');
    
        // Fetch the staff data by role
    
        $staff_data = $this->staff_model->getStaffbyrole($role_id);
    
        
        
        // Initialize leave data array
        if (!empty($staff_data)) {
            foreach ($staff_data as $staff) {
                foreach ($leave_type as $leave_key => $leave_value) {
                    // Get the allotted leave for the current leave type
                    $alloted_leave = $this->input->post('alloted_leave_' . $leave_value);
                    
                    // Check if the staff has an existing record for this leave type
                    $existing_leave = $this->staff_model->getLeaveDetailsByStaffIdAndLeaveType($staff['id'], $leave_value);
    
                    if (!empty($existing_leave)) {
                        // If record exists, update the allotted leave
                        $update_data = array(
                            'alloted_leave' => $alloted_leave
                        );
    
                        // Update the staff leave details for this leave type
                        $this->staff_model->updateLeaveDetails($staff['id'], $leave_value, $update_data);
                    } else {
                        // If no record exists, insert a new one
                        $insert_data = array(
                            'staff_id'      => $staff['id'],
                            'leave_type_id' => $leave_value,
                            'alloted_leave' => $alloted_leave,
                        );
    
                        // Insert the new leave data into the database
                        $this->staff_model->insertLeaveDetails($insert_data);
                    }
                }
            }
    
            $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('success_message'));
            echo json_encode($array);
        }
    }
    public function leaveedit($id)
    {
        $result            = $this->staff_model->getLeaveType($id);
        $data["title"]     = $this->lang->line('edit_leave_type');
        $data["result"]    = $result;
        $LeaveTypes        = $this->leavetypes_model->getLeaveType();
        $data["leavetype"] = $LeaveTypes;
        $this->load->view("layout/header");
        $this->load->view("admin/staff/leavetypes", $data);
        $this->load->view("layout/footer");
    }

    public function leavedelete($id)
    {
        $this->leavetypes_model->deleteLeaveType($id);
        redirect('admin/leavetypes');
    }

}
