<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Generatecertificate extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();

        $this->load->library('Customlib');
        $this->sch_setting_detail = $this->setting_model->getSetting();
            $this->load->library('media_storage');
             $this->load->model('certificate_model');
    }

     public function index()
    {
        if (!$this->rbac->hasPrivilege('generate_certificate', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Certificate');
        $this->session->set_userdata('sub_menu', 'admin/generatecertificate');
           $data['eventlist'] = $this->certificate_model->getbycurrentsessioncertificategroupby();
        $certificateList = $this->Certificate_model->getstudentcertificate();
        $data['certificateList'] = $certificateList;
        $class                   = $this->class_model->get();
        $data['classlist']       = $class;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/certificate/generatecertificate', $data);
        $this->load->view('layout/footer', $data);
    }

  public function search()
{
    $this->session->set_userdata('top_menu', 'Certificate');
    $this->session->set_userdata('sub_menu', 'admin/generatecertificate');

    // Get class list
    $data['classlist'] = $this->class_model->get();

    // Get event list (one per unique event name)
    $data['eventlist'] = $this->certificate_model->getbycurrentsessioncertificategroupby();

    if ($this->input->server('REQUEST_METHOD') == "GET") {
        $this->load->view('layout/header', $data);
        $this->load->view('admin/certificate/generatecertificate', $data);
        $this->load->view('layout/footer', $data);
    } else {
        // Get post values
        $class_id   = $this->input->post('class_id');
        $section_id = $this->input->post('section_id');
        $event_name = $this->input->post('event_name');

        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('event_name', $this->lang->line('event_name'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/certificate/generatecertificate', $data);
            $this->load->view('layout/footer', $data);
        } else {
            // Fetch students filtered by class, section, and event name
            $data['resultlist'] = $this->certificate_model->getStudentsByClassSectionEvent($class_id, $section_id, $event_name);

            $data['class_id']   = $class_id;
            $data['section_id'] = $section_id;
            $data['event_name'] = $event_name;

            $data['sch_setting'] = $this->sch_setting_detail;

            $this->load->view('layout/header', $data);
            $this->load->view('admin/certificate/generatecertificate', $data);
            $this->load->view('layout/footer', $data);
        }
    }
}

    public function generate($student, $class, $certificate)
    {
        $certificateResult         = $this->Generatecertificate_model->getcertificatebyid($certificate);
        $data['certificateResult'] = $certificateResult;
        $resultlist                = $this->student_model->searchByClassStudent($class, $student);
        $data['resultlist']        = $resultlist;

        $this->load->view('admin/certificate/transfercertificate', $data);
    }

    public function generatemultiple()
    {

        $studentid           = $this->input->post('data');
        $student_array       = json_decode($studentid);
        $certificate_id      = $this->input->post('certificate_id');
        $class               = $this->input->post('class_id');
        $data                = array();
        $results             = array();
        $std_arr             = array();
        $data['sch_setting'] = $this->setting_model->get();
        $data['certificate'] = $this->Generatecertificate_model->getcertificatebyid($certificate_id);

        foreach ($student_array as $key => $value) {
            $std_arr[] = $value->student_id;
        }
        $data['students'] = $this->student_model->getStudentsByArray($std_arr);
        foreach ($data['students'] as $key => $value) {
            $data['students'][$key]->name = $this->customlib->getFullName($value->firstname, $value->middlename, $value->lastname, $this->sch_setting_detail->middlename, $this->sch_setting_detail->lastname);
        }

        $data['sch_setting'] = $this->sch_setting_detail;
        $certificates        = $this->load->view('admin/certificate/printcertificate', $data, true);
        echo $certificates;
    }
        
public function generateMultipleCertificates()
{
    $student_ids = json_decode($this->input->post('student_ids'), true);

    if (empty($student_ids)) {
        show_error('No students selected.');
    }

    // Load required data
    $duration = $this->setting_model->getCurrentSessionName();
    $setting_result = $this->setting_model->get();

    // Initialize MPDF
    $this->load->library('MPdf_instance');
    $mpdf = new \Mpdf\Mpdf([
        'format' => 'A4-L', // Landscape
        'margin_left' => 10,
        'margin_right' => 10,
        'margin_top' => 10,
        'margin_bottom' => 10,
    ]);

    $firstPage = true;

    // Loop through all selected students
    foreach ($student_ids as $student_id) {
        $certificate = $this->certificate_model->multigetCertificateByStudentId($student_id);

        if (!empty($certificate)) {
            $html = $this->load->view('admin/certificate/certificatepdf', [
                'certificate'    => $certificate,
                'settinglist'    => $setting_result,
                'currentsession' => $duration
            ], true);

            // Add new page only after the first one
            if (!$firstPage) {
                $mpdf->AddPage();
            }
            $mpdf->WriteHTML($html);
            $firstPage = false;
        }
    }

    // Output as single combined PDF
    $mpdf->Output('All_Certificates.pdf', 'I');
}


}
