<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Gatepass extends Admin_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('form_validation');

        $this->load->model("Gatepass_model");
    }

    public function index() {
        

        $this->session->set_userdata('top_menu', 'front_office');
        $this->session->set_userdata('sub_menu', 'admin/gatepass');
        $this->form_validation->set_rules('type', $this->lang->line('type'), 'required');
        $this->form_validation->set_rules('student_staff_id', $this->lang->line('staff') . "/" . $this->lang->line('student'), 'required');
        $this->form_validation->set_rules('start_date', $this->lang->line('start') . " " . $this->lang->line('date'), 'required');
        $this->form_validation->set_rules('end_date', $this->lang->line('end') . " " . $this->lang->line('date'), 'required');
        $this->form_validation->set_rules('in_time', "IN" . " " . $this->lang->line('time'), 'required');
        $this->form_validation->set_rules('out_time', "OUT" . " " . $this->lang->line('time'), 'required');
        
        if ($this->form_validation->run() == FALSE) {
            $data['DispatchList'] = $this->Gatepass_model->list();
            $this->load->view('layout/header');
            $this->load->view('admin/frontoffice/gatepassview', $data);
            $this->load->view('layout/footer');
        } else {

            $gatepass_arr = array(
                'type' => $this->input->post('type'),
                'start_date' => date('Y-m-d', $this->customlib->datetostrtotime($this->input->post('start_date'))),
                'end_date' => date('Y-m-d', $this->customlib->datetostrtotime($this->input->post('end_date'))),
                'in_time' => $this->input->post('in_time'),
                'out_time' => $this->input->post('out_time'),
                'note' => $this->input->post('note'),
            
            );

            if ($this->input->post('type')=='student') {
                $gatepass_arr['student_id'] = $this->input->post('student_staff_id');
            }else{
                $gatepass_arr['staff_id'] = $this->input->post('student_staff_id');
            }

            $dispatch_id = $this->Gatepass_model->insert('gatepasses', $gatepass_arr);
            

            $this->session->set_flashdata('msg', '<div class="alert alert-success">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/gatepass');
        }
    }


    public function getStaffOrStudents() {
        $type = $this->input->post('type'); // Get the selected type
        
        if ($type == 'student') {
            $data = $this->student_model->get(); 
        } else {
            $data = $this->staff_model->get(); 
        }
        
        echo json_encode($data); // Send the data back as JSON
    }


    function edit($id) {
        

        $this->form_validation->set_rules('type', $this->lang->line('type'), 'required');
        $this->form_validation->set_rules('student_staff_id', $this->lang->line('staff') . "/" . $this->lang->line('student'), 'required');
        $this->form_validation->set_rules('start_date', $this->lang->line('start') . " " . $this->lang->line('date'), 'required');
        $this->form_validation->set_rules('end_date', $this->lang->line('end') . " " . $this->lang->line('date'), 'required');
        $this->form_validation->set_rules('in_time', "IN" . " " . $this->lang->line('time'), 'required');
        $this->form_validation->set_rules('out_time', "OUT" . " " . $this->lang->line('time'), 'required');
        if ($this->form_validation->run() == FALSE) {
            $data['id']=$id;
            $data['DispatchList'] = $this->Gatepass_model->list();
            $data['Gatepass_data'] = $this->Gatepass_model->dis_rec_data($id);

            $this->load->view('layout/header');
            $this->load->view('admin/frontoffice/gatepassedit', $data);
            $this->load->view('layout/footer');
        } else {
            $id;

            $gatepass_arr = array(
                'type' => $this->input->post('type'),
                'start_date' => date('Y-m-d', $this->customlib->datetostrtotime($this->input->post('start_date'))),
                'end_date' => date('Y-m-d', $this->customlib->datetostrtotime($this->input->post('end_date'))),
                'in_time' => $this->input->post('in_time'),
                'out_time' => $this->input->post('out_time'),
                'note' => $this->input->post('note'),
            
            );

            if ($this->input->post('type')=='student') {
                $gatepass_arr['student_id'] = $this->input->post('student_staff_id');
            }else{
                $gatepass_arr['staff_id'] = $this->input->post('student_staff_id');
            }


            $this->Gatepass_model->update('gatepasses', $id, $gatepass_arr);

            

            $this->session->set_flashdata('msg', '<div class="alert alert-success">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/gatepass');
        }
    }

    

    public function delete($id) {
        if (!$this->rbac->hasPrivilege('postal_dispatch', 'can_delete')) {
            access_denied();
        }

        $this->Gatepass_model->delete($id);
    }

    public function getPassDetails()
    {
        $id = $this->input->post('id');
        $data = $this->Gatepass_model->list($id);

        echo json_encode(['gatepass'=>$data]);

    }

    

}
