<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class FeesREvert_request extends Admin_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Studentfee_model');
    }

    function index() {
        $this->session->set_userdata('top_menu', 'front_office');
        $this->session->set_userdata('sub_menu', 'FeesREvert_request/index');
        $data['title'] = 'Admin User';
        $revertfee_result = $this->Studentfee_model->getRevert_requestData();
        $data['revertfee_list'] = $revertfee_result;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/Feesrevert/revertList', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        $data['title'] = 'Admin User List';
        $this->admin_model->remove($id);
        redirect('admin/adminuser/index');
    }

    function changeStatus() {
        $id=$this->input->post('id');
        $status= $this->input->post('status');
        $main_invoice= $this->input->post('main_invoice');
        $sub_invoice= $this->input->post('sub_invoice');
        
        $rev_status=$this->Studentfee_model->RevertRequest_Status($id,array('status'=>$status));
        
        $this->Studentfee_model->fees_deposite_status($main_invoice,$sub_invoice);
        
        $array = array('status' => 'success', 'message' => 'Request Approved Successfully!');
        echo json_encode($array);
    }



    function create() {
        $data['title'] = 'Add Admin User';
        $adminuser_result = $this->admin_model->get();
        $data['adminlist'] = $adminuser_result;
        $this->form_validation->set_rules('username', 'Admin Name', 'trim|required|xss_clean');
        $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
        $this->form_validation->set_rules('password', 'Password', 'trim|required|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/adminuser/adminuserList', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $data = array(
                'username' => $this->input->post('username'),
                'email' => $this->input->post('email'),
                'password' => md5($this->input->post('password')),
                'role' => 'admin',
                'is_active' => 'yes'
            );
            $this->admin_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">Admin user added successfully</div>');
            redirect('admin/adminuser/index');
        }
    }

}

?>