<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class FeemasterCollage extends Admin_Controller {

    function __construct() {
        parent::__construct();
        $this->sch_setting_detail = $this->setting_model->getSetting();
        $this->load->model('Feesessiongroup_model');
        $this->load->model('section_model');
    }

    function index() {
        $this->session->set_userdata('top_menu', 'Fees Collection');
        $this->session->set_userdata('sub_menu', 'admin/feemastercollage');
        $data['title'] = 'Feemaster Collage List';
        
        $coursedata= $this->feesessiongroup_model->getCourse();
        $data['courseList'] = $coursedata;

        $feecategory= $this->feecategory_model->get();
        $data['feecategoryList'] = $feecategory;

        $feetype = $this->feetype_model->get();
        $data['feetypeList'] = $feetype;
 
        $feeheadcourse_result = $this->feesessiongroup_model->getFeesHeadCourse();
        $data['feeheadcourseList'] = $feeheadcourse_result;

        // $this->form_validation->set_rules('feetype_id_0', $this->lang->line('feetype'), 'required');
        $this->form_validation->set_rules('fee_category_id', $this->lang->line('fee_category'), 'required');
        
        $this->form_validation->set_rules('course_id', $this->lang->line('course'), 'required');
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'required');
        // $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'required');
        $this->form_validation->set_rules('amount_0', $this->lang->line('amount'), 'required|numeric');



        

        if ($this->form_validation->run() == FALSE) {
            
        } else {


            $loop = $this->input->post('i');
            

            foreach ($loop as $key => $value) {
                $s = array();
                

                
                $s['fee_type_id'] = $this->input->post('feetype_id_' . $value);
                $s['fee_cat_id'] = $this->input->post('fee_category_id');
                $section_ids = $this->input->post('section_id');
                $s['class_ids'] = $this->input->post('class_id');
                $s['course_id'] = $this->input->post('course_id');
                $s['status'] = 1;
                $s['amount'] = $this->input->post('amount_' . $value);
                $row_id = $this->input->post('row_id_' . $value);
                $s['section_id'] = json_encode($section_ids);
                
                $insert_id = $this->feesessiongroup_model->addfeeHeadCourse($s);

               
                $resultlist = $this->studentfeemaster_model->getStudentSession($this->input->post('class_id'), $this->input->post('section_id'));
                
 
                foreach ($resultlist as $key => $value) {
                    $data=array(
                        'student_session_id'=>$value['student_session_id'],
                        'fee_head_course_id'=>$insert_id,
                        'fee_session_group_id'=>''
                    );

                    
                    $inserted_id = $this->studentfeemaster_model->add($data);

                    

                }


                    
                
            }

           

            


            

            
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/FeemasterCollage/index');
        }
 
        $this->load->view('layout/header', $data);
        $this->load->view('admin/feemastercollage/feemasterList', $data);
        $this->load->view('layout/footer', $data);
    }

    public function getClasses() {
        $course_id = $this->input->post('course_id');
        $classes = $this->feesessiongroup_model->getClassesByCourseId($course_id);

        echo json_encode($classes);
    }

    public function getSection() {
        $class_id = $this->input->post('class_id');
        $data = $this->section_model->getClassBySection($class_id);
        echo json_encode($data);

    }

    function delete($id) {
        if (!$this->rbac->hasPrivilege('fees_master_collage', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Fees Master List';
        $this->feesessiongroup_model->remove_fee_headcourse($id);
        redirect('admin/FeemasterCollage/index');
    }

    function deletegrp($id) {
        $data['title'] = 'Fees Master List';
        $this->feesessiongroup_model->remove($id);
        redirect('admin/feemaster');
    }

    function assign($id) {
        if (!$this->rbac->hasPrivilege('fees_group_assign', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Fees Collection');
        $this->session->set_userdata('sub_menu', 'admin/feemaster');
        $data['id'] = $id;
        $data['title'] = 'student fees';
        $class = $this->class_model->get();
        $coursedata= $this->feesessiongroup_model->getCourse();
        $data['courseList'] = $coursedata;
        // $data['classlist'] = $class;
        $feegroup_result = $this->feesessiongroup_model->getFeesByFeeHeadCourse($id);
        $data['feegroupList'] = $feegroup_result;
        $data['adm_auto_insert'] = $this->sch_setting_detail->adm_auto_insert;
        $data['sch_setting'] = $this->sch_setting_detail;

        $genderList = $this->customlib->getGender();
        $data['genderList'] = $genderList;
        $RTEstatusList = $this->customlib->getRteStatus();
        $data['RTEstatusList'] = $RTEstatusList;

        $category = $this->category_model->get();
        $data['categorylist'] = $category;


        if ($this->input->server('REQUEST_METHOD') == 'POST') {

            $data['category_id'] = $this->input->post('category_id');
            $data['gender'] = $this->input->post('gender');
            $data['rte_status'] = $this->input->post('rte');
            $data['course_id'] = $this->input->post('course_id');
            $data['class_id'] = $this->input->post('class_id');
            $data['section_id'] = $this->input->post('section_id');

            $resultlist = $this->studentfeemaster_model->searchAssignFeeByClassSectionCollage($data['class_id'], $data['section_id'], $id, $data['category_id'], $data['gender'], $data['rte_status'], $data['course_id']);
            $data['resultlist'] = $resultlist;
        }

        $this->load->view('layout/header', $data);
        $this->load->view('admin/feemastercollage/assign', $data);
        $this->load->view('layout/footer', $data);
    }

    public function changeStatus() {

        $id = $this->input->post("id");
        $status = $this->input->post("status");

        if (!empty($id)) {

            $data = array('id' => $id, 'status' => $status);
            $result = $this->Feesessiongroup_model->changeStatus($data);
            $response = array('status' => 1, 'msg' => 'Status change successfully');
            echo json_encode($response);
        }
    }

    function edit($id) {
        if (!$this->rbac->hasPrivilege('fees_master_collage', 'can_edit')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Fees Collection');
        $this->session->set_userdata('sub_menu', 'admin/feemastercollage');
        $data['id'] = $id;
        $coursedata= $this->feesessiongroup_model->getCourse();
        $data['courseList'] = $coursedata;

        $feecategory= $this->feecategory_model->get();
        $data['feecategoryList'] = $feecategory;

        $feetype = $this->feetype_model->get();
        $data['feetypeList'] = $feetype;
 
        $feeheadcourse_result = $this->feesessiongroup_model->getFeesHeadCourse();
        $data['feeheadcourseList'] = $feeheadcourse_result;

        $feeheadcourse_edit = $this->feesessiongroup_model->getFeesHeadCourse($id);
        $data['feeheadcourse_edit'] = $feeheadcourse_edit;


        $this->form_validation->set_rules('feetype_id', $this->lang->line('feetype'), 'required');
        $this->form_validation->set_rules('fee_category_id', $this->lang->line('fee_category'), 'required');
        
        $this->form_validation->set_rules('course_id', $this->lang->line('course'), 'required');
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'required');
        // $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'required');
        $this->form_validation->set_rules('amount', $this->lang->line('amount'), 'required|numeric');
        
        if ($this->form_validation->run() == FALSE) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/feemastercollage/feemasterEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            


            $insert_array = array(
                'id'         =>$id,
                'fee_cat_id' => $this->input->post('fee_category_id'),
                'fee_type_id' => $this->input->post('feetype_id'),
                'amount' => $this->input->post('amount'),
                'class_ids' => $this->input->post('class_id'),
                'course_id' => $this->input->post('course_id'),
                
            );

            $section_ids = $this->input->post('section_id');

            $insert_array['section_id'] = json_encode($section_ids); 

            $feegroup_result = $this->feesessiongroup_model->addfeeHeadCourse($insert_array);

            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/FeemasterCollage/index');
        }
    }

    

}

?>