<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Examresult extends Admin_Controller
{

    public $exam_type = array();

    public function __construct()
    {
        parent::__construct();
        $this->exam_type          = $this->config->item('exam_type');
        $this->attendence_exam    = $this->config->item('attendence_exam');
         $this->config_attendance = $this->config->item('attendence');
        $this->sch_setting_detail = $this->setting_model->getSetting();
        $this->load->model(array('marksdivision_model', 'marksdivision_model', 'stuattendence_model'));
        $this->load->library('mailsmsconf');
         $this->load->library('media_storage');
        $this->load->model('Class_model');
        $this->load->model('Section_model');
    }

    public function printCard()
    {
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('admitcard_template', $this->lang->line('template'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_exam_id', $this->lang->line('exam'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_exam_group_id', $this->lang->line('exam_group'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('exam_group_class_batch_exam_student_id[]', $this->lang->line('students'), 'required|trim|xss_clean');
        $data = array();

        if ($this->form_validation->run() == false) {
            $data = array(
                'admitcard_template'                     => form_error('admitcard_template'),
                'post_exam_id'                           => form_error('post_exam_id'),
                'post_exam_group_id'                     => form_error('post_exam_group_id'),
                'exam_group_class_batch_exam_student_id' => form_error('exam_group_class_batch_exam_student_id'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {
            $post_exam_id            = $this->input->post('post_exam_id');
            $post_exam_group_id      = $this->input->post('post_exam_group_id');
            $students_array          = $this->input->post('exam_group_class_batch_exam_student_id');
            $exam                    = $this->examgroup_model->getExamByID($post_exam_id);
            $data['exam']            = $exam;
            $exam_grades             = $this->grade_model->getByExamType($exam->exam_group_type);
            $data['exam_grades']     = $exam_grades;
            $data['admitcard']       = $this->admitcard_model->get($this->input->post('admitcard_template'));
            $data['exam_subjects']   = $this->batchsubject_model->getExamSubjects($post_exam_id);
            $data['student_details'] = $this->examstudent_model->getStudentsAdmitCardByExamAndStudentID($students_array, $post_exam_id);
            $data['sch_setting']     = $this->sch_setting_detail;
            $student_admit_cards     = $this->load->view('admin/admitcard/_printadmitcard', $data, true);
            $array                   = array('status' => '1', 'error' => '', 'page' => $student_admit_cards);
            echo json_encode($array);
        }
    }

    public function admitcard()
    {
        if (!$this->rbac->hasPrivilege('print_admit_card', 'can_view')) {
            access_denied();
        }

        $this->session->set_userdata('top_menu', 'Examinations');
        $this->session->set_userdata('sub_menu', 'Examinations/examresult/admitcard');
        $examgroup_result      = $this->examgroup_model->get();
        $data['examgrouplist'] = $examgroup_result;
    
        $class                 = $this->class_model->get();
        $data['title']         = 'Add Batch';
        $data['title_list']    = 'Recent Batch';
        $data['examType']      = $this->exam_type;
        $data['classlist']     = $class;
        $session               = $this->session_model->get();
        $data['sessionlist']   = $session;
        $data['get_active_admitcard']  = $this->admitcard_model->get_active_admitcard();

        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('session_id', $this->lang->line('session'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_group_id', $this->lang->line('exam_group'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_id', $this->lang->line('exam'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

        } else {
            $exam_group_id              = $this->input->post('exam_group_id');
            $exam_id                    = $this->input->post('exam_id');
            $session_id                 = $this->input->post('session_id');
            $class_id                   = $this->input->post('class_id');
            $section_id                 = $this->input->post('section_id');
            $data['studentList'] = $this->examgroupstudent_model->searchExamStudents($exam_group_id, $exam_id, $class_id, $section_id, $session_id);
            $data['examList'] = $this->examgroup_model->getExamByExamGroup($exam_group_id, true);
            $data['exam_id']       = $exam_id;
            $data['exam_group_id'] = $exam_group_id;
        }
        $data['sch_setting'] = $this->sch_setting_detail;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/examresult/admitcard', $data);
        $this->load->view('layout/footer', $data);
    }

    // public function marksheet()
    // {

    //     if (!$this->rbac->hasPrivilege('print_marksheet', 'can_view')) {
    //         access_denied();
    //     }
    //     $this->session->set_userdata('top_menu', 'Examinations');
    //     $this->session->set_userdata('sub_menu', 'Examinations/examresult/marksheet');

    //     $examgroup_result      = $this->examgroup_model->get();
    //     $data['examgrouplist'] = $examgroup_result;
    //     $marksheet_result      = $this->marksheet_model->get();
    //     $data['marksheetlist'] = $marksheet_result;
    //     $class                 = $this->class_model->get();
    //     $data['title']         = 'Add Batch';
    //     $data['title_list']    = 'Recent Batch';
    //     $data['examType']      = $this->exam_type;
    //     $data['classlist']     = $class;
    //     $session               = $this->session_model->get();
    //     $data['sessionlist']   = $session;
    //     $this->form_validation->set_rules('marksheet', $this->lang->line('marksheet_template'), 'trim|required|xss_clean');
    //     $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
    //     $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
    //     $this->form_validation->set_rules('session_id', $this->lang->line('session'), 'trim|required|xss_clean');
    //     $this->form_validation->set_rules('exam_group_id', $this->lang->line('exam_group'), 'trim|required|xss_clean');
    //     $this->form_validation->set_rules('exam_id', $this->lang->line('exam'), 'trim|required|xss_clean');

    //     if ($this->form_validation->run() == false) {

    //     } else {
    //         $exam_group_id = $this->input->post('exam_group_id');
    //         $exam_id       = $this->input->post('exam_id');
    //         $session_id    = $this->input->post('session_id');
    //         $class_id      = $this->input->post('class_id');
    //         $section_id    = $this->input->post('section_id');

    //         $marksheet_template         = $this->input->post('marksheet');
    //         $data['marksheet_template'] = $marksheet_template;
    //         $data['studentList']        = $this->examgroupstudent_model->searchExamStudents($exam_group_id, $exam_id, $class_id, $section_id, $session_id);
    //         $data['examList']           = $this->examgroup_model->getExamByExamGroup($exam_group_id, true);
    //         $data['exam_id']            = $exam_id;
    //         $data['exam_group_id']      = $exam_group_id;
    //     }
    //     $data['sch_setting'] = $this->sch_setting_detail;
    //     $this->load->view('layout/header', $data);
    //     $this->load->view('admin/examresult/marksheet', $data);
    //     $this->load->view('layout/footer', $data);
    // }
    
    public function marksheet() {

        if (!$this->rbac->hasPrivilege('print_marksheet', 'can_view')) {

            access_denied();

        }
        


        $this->session->set_userdata('top_menu', 'Examinations');

        $this->session->set_userdata('sub_menu', 'Examinations/examresult/marksheet');

        $examgroup_result = $this->examgroup_model->get();

        $data['examgrouplist'] = $examgroup_result;



        $marksheet_result = $this->marksheet_model->get();

        $data['marksheetlist'] = $marksheet_result;

        

        $exam_list = $this->examgroup_model->getExamByExamGroup('', true);

        $data['exam_list'] = $exam_list;

        $data['exam_list_ids'] = array();

        $data['exam_ids_selected'] = array();

        

        $class = $this->class_model->get();

        $data['title'] = 'Add Batch';

        $data['title_list'] = 'Recent Batch';

        $data['examType'] = $this->exam_type;

        $data['classlist'] = $class;

        $session = $this->session_model->get();

        $data['sessionlist'] = $session;

        $this->form_validation->set_rules('marksheet', $this->lang->line('marksheet'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('session_id', $this->lang->line('student'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('exam_group_id[]', $this->lang->line('exam') . " " . $this->lang->line('group'), 'trim|required|xss_clean');
        // exam_group_id to exam_group_id[] by sweta on 25 april
        $this->form_validation->set_rules('exam_id[]', $this->lang->line('exam'), 'trim|required|xss_clean');



        if ($this->form_validation->run() == false) {

            

        } else {
            
            

            $exam_group_id = $this->input->post('exam_group_id');

            $exam_id = $this->input->post('exam_id');

            if(valid($this->input->post('exam_id')) && !empty($this->input->post('exam_id'))){

                $exam_id = current($this->input->post('exam_id'));

                $result_exam_ids = $this->input->post('exam_id');

                $data['exam_ids_selected'] = $result_exam_ids;

            }

            $exam_list_ids = array();

            if(valid($this->input->post('exam_list_id')) && !empty($this->input->post('exam_list_id'))){

                $exam_list_ids = $this->input->post('exam_list_id');

                $asort_exam_ids = array_unique(array_merge($result_exam_ids,$exam_list_ids));

                asort($asort_exam_ids);

                $result_exam_ids = $asort_exam_ids;

            }

            $data['exam_list_ids'] = $exam_list_ids;

            $session_id = $this->input->post('session_id');
            
            
            

            $class_id = $this->input->post('class_id');

            $section_id = $this->input->post('section_id');

            $data['section_id'] = $section_id;

            $marksheet_template = $this->input->post('marksheet');

            $data['marksheet_template'] = $marksheet_template;

            //$result_exam_ids = $this->getClassExamIdForFinalResult($class_id,$session_id);

            

            // getting and calculating student ranks in exams

            if(valid($result_exam_ids) && !empty($result_exam_ids)){

                
               

                $data['studentList'] = $this->examgroupstudent_model->searchExamStudents($exam_group_id, $result_exam_ids, $class_id, $section_id, $session_id);
              


                // getting and calculating student ranks in exams

                // echo '<pre>';print_r($data['studentList']);exit;

                $students_array = array();

                if(valid($data['studentList']) && !empty($data['studentList'])){

                    foreach($data['studentList'] as $stddata):
                    	

                        array_push($students_array, $stddata->exam_group_class_batch_exam_student_id);

                    endforeach;


                    $students_class_rank = array();

                    $students_section_rank = array();//exam_group_class_batch_exam_student_id
                    

                    $marksheet = $this->examresult_model->getExamResults($exam_id, $exam_group_id, $students_array, $result_exam_ids);
                    // print_r($marksheet); die;
                    
                    $student_present_days = array();
                    $sch_working_days = array();
                    $st_attendance_percentage = array();
                 

                    if(valid($marksheet) && !empty($marksheet)):

                       $session_data = $this->session_model->get($session_id); 

                        foreach ($marksheet['students'] as $student_key => $student_value):
                            
                            $student_session_id = $student_value['student_session_id'];

                            // Session year comes from DB (example: 2024 means June 2024 - May 2025)
                            $session_year = explode('-',$session_data['session'])[0];
                            
                           
                            $start_year   = $session_year;            // e.g. 2024
                            $end_year     = $session_year + 1;        // e.g. 2025
                        
                            // Define session months (June -> May)
                            $session_months = [
                                ['month' => 6,  'year' => $start_year],
                                ['month' => 7,  'year' => $start_year],
                                ['month' => 8,  'year' => $start_year],
                                ['month' => 9,  'year' => $start_year],
                                ['month' => 10, 'year' => $start_year],
                                ['month' => 11, 'year' => $start_year],
                                ['month' => 12, 'year' => $start_year],
                                ['month' => 1,  'year' => $end_year],
                                ['month' => 2,  'year' => $end_year],
                                ['month' => 3,  'year' => $end_year],
                                ['month' => 4,  'year' => $end_year],
                                ['month' => 5,  'year' => $end_year],
                            ];
                        
                           
                            
                            
                            $working_days = 0;
                            foreach ($session_months as $sm) {
                                $month  = $sm['month'];
                                $year   = $sm['year'];
                            
                                // Count all attendance entries for that month (any student) where type != holiday
                                $this->db->select('COUNT(DISTINCT date) as total');
                                $this->db->from('student_attendences');
                                $this->db->where('MONTH(date)', $month);
                                $this->db->where('YEAR(date)', $year);
                                $query = $this->db->get();
                                $res = $query->row();
                            
                                $working_days += ($res ? $res->total : 0);
                            }

                        
                            $present_days = 0;

                            foreach ($session_months as $sm) {
                                $month  = $sm['month'];
                                $year   = $sm['year'];
                            
                                foreach ($this->config_attendance as $att_key => $att_value) {
                                    if(strtolower($att_key) != 'absent'){
                                        $present_days += $this->stuattendence_model->count_attendance_obj_total(
                                            $month,
                                            $year,
                                            $student_session_id,
                                            $att_value
                                        );
                                    }
                                }
                            }

                            
                            
                            // Calculate percentage
                            $attendance_percentage = ($working_days > 0)
                                ? number_format(($present_days * 100) / $working_days, 2, '.', '')
                                : 0;
                                
                        $student_present_days[$student_value['student_id']] =  $present_days;
                       
                        $sch_working_days[$student_value['student_id']] =  $working_days;
                        $st_attendance_percentage[$student_value['student_id']] = $attendance_percentage;
                                
                            
                            
                            

                            if(array_key_exists($student_value['student_id'], $students_class_rank)):

                                continue;

                            endif;

                            $max_mrks = 0;

                            $get_mrks = 0;

                            $std_pert = 0;

                            foreach($result_exam_ids as $exmid):

                                foreach($student_value['exam_result']['exam_result_' . $exmid] as $exmresult):

                                    $max_mrks = $max_mrks + intval(($exmresult->mark_entry_type == 2) ? 0 : $exmresult->max_marks);

                                    $get_mrks = $get_mrks + intval(($exmresult->mark_entry_type == 2) ? 0 : $exmresult->get_marks);

                                endforeach;

                            endforeach;

                            //$std_pert = ($max_mrks > 0) ? ($get_mrks * 100) / $max_mrks : 0;

                            $std_pert = number_format(($max_mrks > 0) ? ($get_mrks * 100) / $max_mrks : 0, 2, '.', '');

                            $students_class_rank[$student_value['student_id']] = array('percentage' => $std_pert, 'student_id' => $student_value['student_id']);

                            if($student_value['section_id'] == $section_id)

                            {

                                $students_section_rank[$student_value['student_id']] = array('percentage' => $std_pert, 'student_id' => $student_value['student_id']);

                            }

                        endforeach;
                        
                        
                        

                    endif;

                    array_multisort(array_column($students_class_rank, 'percentage'), SORT_DESC, $students_class_rank);

                    array_multisort(array_column($students_section_rank, 'percentage'), SORT_DESC, $students_section_rank);

                    $students_class_rank_desc = array();

                    $students_section_rank_desc = array();

                    if (!empty($students_class_rank)) {
                        $previous_percentage = null;
                        $rank = 0;
                        $same_rank_count = 0;

                        foreach ($students_class_rank as $key => $stddata) {
                            if ($stddata['percentage'] !== $previous_percentage) {
                                $rank += 1;  // Increment by 1 instead of skipping
                            }

                            $students_class_rank_desc[$stddata['student_id']] = $rank;
                            $previous_percentage = $stddata['percentage'];
                        }
                    }



                    if (!empty($students_section_rank)) {
                            $previous_percentage = null;
                            $rank = 0;

                            foreach ($students_section_rank as $key => $stddata) {
                                if ($stddata['percentage'] !== $previous_percentage) {
                                    $rank += 1;  // Increment by 1 instead of skipping
                                }

                                $students_section_rank_desc[$stddata['student_id']] = $rank;
                                $previous_percentage = $stddata['percentage'];
                            }
                        }


                    $data['student_present_days'] = $student_present_days;
                    
                    $data['sch_working_days'] = $sch_working_days;
                    
                    $data['st_attendance_percentage'] = $st_attendance_percentage;
                    
                    $data['students_class_rank'] = $students_class_rank_desc;

                    $data['students_section_rank'] = $students_section_rank_desc;
                    
                    

                }


                
                

            } else {

                $data['studentList'] = $this->examgroupstudent_model->searchExamStudents($exam_group_id, $exam_id, $class_id, $section_id, $session_id);

            }
            
            

            $data['examList'] = $this->examgroup_model->getNewExamByExamGroup($exam_group_id, true);
            
            

            // $data['examList'] = $this->examgroup_model->getExamByExamGroup($exam_group_id, true); comment by sweta 25 April

            

            $data['selected_exam_ids'] = $result_exam_ids; // $exam_id;

            $data['selected_exam_group_ids'] = $exam_group_id;
            
            $data['exam_id'] = $result_exam_ids; // $exam_id;

            $data['exam_group_id'] = $exam_group_id;

            $data['exam_class_id'] = $class_id;          

            

        }

        $data['sch_setting'] = $this->sch_setting_detail;

        $this->load->view('layout/header', $data);

        $this->load->view('admin/examresult/marksheet', $data);

        $this->load->view('layout/footer', $data);

    }

    public function pdftmarksheet()
    {      
        // error_reporting(E_ALL);
        // ini_set('display_errors',1);
        $template         = $this->marksheet_model->get($this->input->post('marksheet_template'));
        $data['template'] = $template;

        $student_id                             = $this->input->post('student_id');
        $post_exam_id                           = $this->input->post('post_exam_id');
        $post_exam_group_id                     = $this->input->post('post_exam_group_id');
        $exam_group_class_batch_exam_student_id = $this->input->post('exam_group_class_batch_exam_student_id');
        $exam                                   = $this->examgroup_model->getExamByID($post_exam_id);
        $data['exam']                           = $exam;
        $marks_division                         = $this->marksdivision_model->get();
        $data['marks_division']                 = $marks_division;
        $student_data                           = $this->student_model->get($student_id);
        $exam_grades                            = $this->grade_model->getByExamType($exam->exam_group_type);
        $data['exam_grades']                    = $exam_grades;
        $data['marksheet']                      = $this->examresult_model->getStudentExamResults($post_exam_id, $post_exam_group_id, $exam_group_class_batch_exam_student_id, $student_id);
        $data['sch_setting']                    = $this->sch_setting_detail;
        $html                                   = $this->load->view('admin/examresult/_printpdfmarksheet', $data, true);

        $type = $this->input->post('type');
        $this->load->library('m_pdf');
        $mpdf       = $this->m_pdf->load();
        $stylesheet = file_get_contents(base_url() . 'backend/pdf_style.css'); // external css
        if ($template->background_img != "") {

            $mpdf->SetDefaultBodyCSS('background', "url('".$this->customlib->getFolderPath()."./uploads/marksheet/" . $template->background_img . "')");
            $mpdf->SetDefaultBodyCSS('background-image-resize', 6);
        }
        $mpdf->WriteHTML($stylesheet, 1); // Writing style to pdf
		$mpdf->SetWatermarkText("", .2); // add watermark text to be show in marksheet
        $mpdf->SetDisplayMode('fullpage');
        $mpdf->showWatermarkText = true;
        $mpdf->autoScriptToLang  = true;
        $mpdf->baseScript        = 1;
        $mpdf->autoLangToFont    = true;
        $mpdf->WriteHTML($html, \Mpdf\HTMLParserMode::HTML_BODY);
        $response = true;
        if ($type == "email") {
            $content = $mpdf->Output(random_string() . '.pdf', 'S');
            $student_value=$data['marksheet']['student'];
            $exam_roll_no=($exam->use_exam_roll_no) ? $student_value['exam_roll_no']:$student_value['student_roll_no'];

            $student_name = $this->customlib->getFullName($student_data['firstname'], $student_data['middlename'], $student_data['lastname'], $data['sch_setting']->middlename, $data['sch_setting']->lastname);

            $sender_details = array('email' => $student_data['email'], 'student_name' => $student_name, 'class' => $student_data['class'], 'section' => $student_data['section'], 'admission_no' => $student_data['admission_no'], 'roll_no' => $student_data['roll_no'], 'admit_card_roll_no'=>$exam_roll_no,'dob' => $student_data['dob'], 'guardian_name' => $student_data['guardian_name'], 'guardian_relation' => $student_data['guardian_relation'], 'guardian_phone' => $student_data['guardian_phone'], 'father_name' => $student_data['father_name'], 'father_phone' => $student_data['father_phone'], 'mother_name' => $student_data['mother_name'], 'gender' => $student_data['gender'], 'guardian_email' => $student_data['guardian_email'], 'exam' => $exam->exam);


            $this->mailsmsconf->mailsms('email_pdf_exam_marksheet', $sender_details, '', '', $content);

        } elseif ($type == "download") {

            $content = $mpdf->Output(random_string() . '.pdf', 'I');
            return $content;

        }
        if ($response) {
            $array = array('status' => 1, 'message' => $this->lang->line('mail_sent_successfully'));

        } else {
            $array = array('status' => 0, 'message' => $this->lang->line('something_went_wrong'));

        }
        echo json_encode($array);

    }

//     public function printmarksheet()
//     {
//         error_reporting(E_ALL);
//         ini_set('display_errors',1);
//         $this->form_validation->set_error_delimiters('', '');
//         $this->form_validation->set_rules('post_exam_id', $this->lang->line('exam'), 'required|trim|xss_clean');
//         $this->form_validation->set_rules('post_exam_group_id', $this->lang->line('exam_group'), 'required|trim|xss_clean');
//         $this->form_validation->set_rules('exam_group_class_batch_exam_student_id[]', $this->lang->line('students'), 'required|trim|xss_clean');
//         $data = array();

//         if ($this->form_validation->run() == false) {
//             $data = array(
//                 'post_exam_id'                           => form_error('post_exam_id'),
//                 'post_exam_group_id'                     => form_error('post_exam_group_id'),
//                 'exam_group_class_batch_exam_student_id' => form_error('exam_group_class_batch_exam_student_id'),
//             );
//             $array = array('status' => 0, 'error' => $data);
//             echo json_encode($array);
//         } else {
//             $template = $this->marksheet_model->get($this->input->post('marksheet_template'));

//             $data['template'] = $template;

//             $post_exam_id           = $this->input->post('post_exam_id');
//             $post_exam_group_id     = $this->input->post('post_exam_group_id');
//             $students_array         = $this->input->post('exam_group_class_batch_exam_student_id');
//             $marks_division         = $this->marksdivision_model->get();
//             $data['marks_division'] = $marks_division;
//             $exam                   = $this->examgroup_model->getExamByID($post_exam_id);
//             $data['exam']           = $exam;
//             $exam_grades            = $this->grade_model->getByExamType($exam->exam_group_type);
//             $data['exam_grades']    = $exam_grades;
//             $data['marksheet']      = $this->examresult_model->getExamResults($post_exam_id, $post_exam_group_id, $students_array);
//             $data['sch_setting']    = $this->sch_setting_detail;
//             $html                   = $this->load->view('admin/examresult/_printmarksheet', $data, true);
//             $this->load->library('m_pdf');

//             $mpdf       = $this->m_pdf->load();
//             $stylesheet = file_get_contents(base_url() . 'backend/pdf_style.css'); // external css
//             if ($template->background_img != "") {

// 				$mpdf->SetDefaultBodyCSS('background', "url('".$this->customlib->getFolderPath()."./uploads/marksheet/" . $template->background_img . "')");
//                 $mpdf->SetDefaultBodyCSS('background-image-resize', 6);
//             }
//             $mpdf->WriteHTML($stylesheet, 1); // Writing style to pdf
// 			$mpdf->SetWatermarkText("", .2); // add watermark text to be show in marksheet
//             $mpdf->SetDisplayMode('fullpage');
//             $mpdf->showWatermarkText = true;
//             $mpdf->autoScriptToLang  = true;
//             $mpdf->baseScript        = 1;
//             $mpdf->autoLangToFont    = true;
//             $mpdf->WriteHTML($html, \Mpdf\HTMLParserMode::HTML_BODY);
//             $response = true;

//             $content = $mpdf->Output(random_string() . '.pdf', 'I');
//             return $content;

//         }
//     }


    public function printmarksheet() {
    	
        // error_reporting(E_ALL);
        // ini_set('display_errors',1);

        $this->form_validation->set_error_delimiters('', '');

        $this->form_validation->set_rules('post_exam_id', $this->lang->line('exam'), 'required|trim|xss_clean');

        $this->form_validation->set_rules('post_exam_group_id', $this->lang->line('exam') . " " . $this->lang->line('group'), 'required|trim|xss_clean');

        $this->form_validation->set_rules('exam_group_class_batch_exam_student_id[]', $this->lang->line('students'), 'required|trim|xss_clean');

        $data = array();



        if ($this->form_validation->run() == false) {

            $data = array(

                'post_exam_id' => form_error('post_exam_id'),

                'post_exam_group_id' => form_error('post_exam_group_id'),

                'exam_group_class_batch_exam_student_id' => form_error('exam_group_class_batch_exam_student_id'),

            );

            $array = array('status' => 0, 'error' => $data);

            echo json_encode($array);

        } else {

            $data['template'] = $this->marksheet_model->get($this->input->post('marksheet_template'));
            $data['sch_setting'] = $this->sch_setting_detail;
            // print_r($data['sch_setting']); die;
            $post_exam_id = $this->input->post('post_exam_id');

            $post_exam_group_id = $this->input->post('post_exam_group_id');

            $post_exam_class_id = $this->input->post('post_exam_class_id');

            $session_id = ($post_exam_class_id == 24000) ? 26 : ''; // this is temporary to get old session exam Ids for specific class(ex:9th class) for printmarksheet

            $result_exam_ids = (strpos($post_exam_id, ',') !== false) ? explode(',', $post_exam_id) : array($post_exam_id) ; 

            if(strpos($post_exam_id, ',') !== false){

                $post_exam_id_arr = explode(',', $post_exam_id);

                $post_exam_id = current($post_exam_id_arr);

            }

            //$result_exam_ids = $this->getClassExamIdForFinalResult($post_exam_class_id,$session_id); 

            $students_array = $this->input->post('exam_group_class_batch_exam_student_id');

            $students_class_rank = $this->input->post('students_class_rank');
            $student_present_days = $this->input->post('student_present_days');
            $sch_working_days = $this->input->post('sch_working_days');
            $st_attendance_percentage = $this->input->post('st_attendance_percentage');
            



            $students_section_rank = $this->input->post('students_section_rank');

            $exam = $this->examgroup_model->getExamByID($post_exam_id);
            $student_result = $this->examgroupstudent_model->getExamStudents($students_array);
        

            $data['exam'] = $exam;

            $data['exam_ids'] = $result_exam_ids;
            
            $data['student_present_days'] = $student_present_days;
            $data['sch_working_days'] = $sch_working_days;
            $data['st_attendance_percentage'] = $st_attendance_percentage;

            $data['students_class_rank'] = $students_class_rank;

            $data['students_section_rank'] = $students_section_rank;
            
          
            // Step 1: Define the month sequence (your academic session)
            $months = ["June", "July", "August", "September", "October", "November", "December", "January", "February", "March", "April", "May"];

            // Step 2: Initialize arrays to hold monthly and yearly attendance
            $monthAttendanceCount = [];
            $yearlyAttendanceSummary = [];

            







            $exam_grades = $this->grade_model->getByExamType($exam->exam_group_type);

            $data['exam_grades'] = $exam_grades;

            $data['monthAttendanceCount'] = $monthAttendanceCount;

            $data['marksheet'] = $this->examresult_model->getExamResults($post_exam_id, $post_exam_group_id, $students_array, $result_exam_ids);
            // echo "<pre>";
            // print_r($data['marksheet']); die();

            $data['sch_setting'] = $this->sch_setting_detail;
            

            $student_exam_page = $this->load->view('admin/examresult/_printmarksheet', $data, true); 

            $array = array('status' => '1', 'error' => '', 'page' => $student_exam_page);

            echo json_encode($array);

        }

    }

    public function index() {
        // error_reporting(E_ALL); // Report all errors
        // ini_set('display_errors', 1);
        if (!$this->rbac->hasPrivilege('exam_result', 'can_view')) {
            access_denied();
        }
    
        $this->session->set_userdata('top_menu', 'Examinations');
        $this->session->set_userdata('sub_menu', 'Examinations/Examresult');
    
        $data['examgrouplist'] = $this->examgroup_model->get();
        $data['marksheetlist'] = $this->marksheet_model->get();
        $data['classlist'] = $this->class_model->get();
        $data['title'] = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType'] = $this->exam_type;
        $data['sessionlist'] = $this->session_model->get();
    
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('session_id', $this->lang->line('session'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_group_id', $this->lang->line('exam') . " " . $this->lang->line('group'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_id', $this->lang->line('exam'), 'trim|required|xss_clean');
    
        if ($this->form_validation->run() !== false) {
            $exam_group_id = $this->input->post('exam_group_id');
            $exam_id = $this->input->post('exam_id');
            $session_id = $this->input->post('session_id');
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
    
            $data['selected_class'] = $this->class_model->get($class_id)['class'];
            $data['selected_section'] = $this->section_model->get($section_id)['section'];
            $data['marksheet_template'] = $this->input->post('marksheet');
    
            $exam_details = $this->examgroup_model->getExamByID($exam_id);
            $data['exam_details'] = $exam_details;
    
            $studentList = $this->examgroupstudent_model->searchExamStudents($exam_group_id, $exam_id, $class_id, $section_id, $session_id);
            $exam_subjects = $this->batchsubject_model->getExamSubjects($exam_id);
            $data['subjectList'] = $exam_subjects;
    
            if (!empty($studentList)) {
                $students_class_rank = [];
                $students_section_rank = [];
    
                foreach ($studentList as $student_key => $student_value) {
                    $student_results = $this->examresult_model->getStudentResultByExam($exam_id, $student_value->exam_group_class_batch_exam_student_id);
                    
                    // Calculate total marks and percentage
                    $total_marks_obtained = 0;
                    $total_max_marks = 0;
                    foreach ($student_results as $subject_result) {
                        $total_marks_obtained += $subject_result->get_marks;
                        $total_max_marks += $subject_result->max_marks;
                    }
    
    
                    $percentage = ($total_max_marks > 0) ? ($total_marks_obtained / $total_max_marks) * 100 : 0;
    
                    // Store student percentage for ranking
                    $students_class_rank[] = [
                        'student_id' => $student_value->student_id,
                        'percentage' => $percentage
                    ];
    
                    if ($student_value->section_id == $section_id) {
                        $students_section_rank[] = [
                            'student_id' => $student_value->student_id,
                            'percentage' => $percentage
                        ];
                    }
    
                    $studentList[$student_key]->subject_results = $student_results;
                }
    
                // Rank students by percentage (Class Level)
                usort($students_class_rank, function ($a, $b) {
                    return $b['percentage'] <=> $a['percentage'];
                });
    
                $class_rankings = [];
                $previous_percentage = null;
                $rank = 0;
                $same_rank_count = 0;
    
                foreach ($students_class_rank as $key => $stddata) {
                    if ($stddata['percentage'] !== $previous_percentage) {
                        $rank += 1;
                        $same_rank_count = 0;
                    } else {
                        $same_rank_count++;
                    }
    
                    $class_rankings[$stddata['student_id']] = $rank;
                    $previous_percentage = $stddata['percentage'];
                }
    
                // Rank students by percentage (Section Level)
                usort($students_section_rank, function ($a, $b) {
                    return $b['percentage'] <=> $a['percentage'];
                });
    
                $section_rankings = [];
                $previous_percentage = null;
                $rank = 0;
                $same_rank_count = 0;
    
                foreach ($students_section_rank as $key => $stddata) {
                    if ($stddata['percentage'] !== $previous_percentage) {
                        $rank += 1;
                        $same_rank_count = 0;
                    } else {
                        $same_rank_count++;
                    }
    
                    $section_rankings[$stddata['student_id']] = $rank;
                    $previous_percentage = $stddata['percentage'];
                }
    
                // Assign ranks to students
                foreach ($studentList as $key => $student) {
    
                    $studentList[$key]->class_rank = $class_rankings[$student->student_id] ?? '-';
                    $studentList[$key]->section_rank = $section_rankings[$student->student_id] ?? '-';
                }
            }
    
            
    
            $data['studentList'] = $studentList;
            $data['exam_grades'] = $this->grade_model->getByExamType($exam_details->exam_group_type);
            $data['exam_id'] = $exam_id;
            $data['exam_group_id'] = $exam_group_id;
        }
    
        $data['sch_setting'] = $this->sch_setting_detail;
    
        $this->load->view('layout/header', $data);
        $this->load->view('admin/examresult/index', $data);
        $this->load->view('layout/footer', $data);
    }

    public function updaterank()
    {
        $exam_group_class_batch_exam_id         = $this->input->post('exam_group_class_batch_exam_id');
        $exam_group_class_batch_exam_student_id = $this->input->post('exam_group_class_batch_exam_student_id');
        if (!empty($exam_group_class_batch_exam_student_id)) {
            $exam_group_class_batch_exam_students = array();
            foreach ($exam_group_class_batch_exam_student_id as $exam_student_id_key => $exam_student_id_value) {
                $exam_group_class_batch_exam_students[] = array(
                    'id'   => $exam_student_id_value,
                    'rank' => $this->input->post('exam_group_class_batch_exam_student_id_' . $exam_student_id_value),
                );

            }
            $this->examresult_model->updaterank($exam_group_class_batch_exam_students, $exam_group_class_batch_exam_id);
        }

        $array = array('status' => '1', 'message' => $this->lang->line('update_message'));
        echo json_encode($array);
    }

    public function examrank()
    {
        $exam_id       = $this->input->post('exam_id');
        $studentList   = $this->examgroupstudent_model->searchExamStudentsByExam($exam_id);         
        $exam_details  = $this->examgroup_model->getExamByID($exam_id);
        $exam_subjects = $this->batchsubject_model->getExamSubjects($exam_id);        
        $subjectList   = $exam_subjects;

        if (!empty($studentList)) {
            foreach ($studentList as $student_key => $student_value) {
                $studentList[$student_key]->subject_results = $this->examresult_model->getStudentResultByExam($exam_id, $student_value->exam_group_class_batch_exam_student_id);
            }
        }
        $data['subjectList']  = $exam_subjects;
        $data['studentList']  = $studentList;
        $exam_grades          = $this->grade_model->getByExamType($exam_details->exam_group_type);
        $data['exam_grades']  = $exam_grades;
        $data['exam_details'] = $exam_details;
        $data['exam_id']      = $exam_id;
        $data['sch_setting']  = $this->sch_setting_detail;
        $page                 = $this->load->view('admin/examresult/_partialexamrank', $data, true);

        $array = array('status' => '1', 'page' => $page, 'exam_details' => $exam_details, 'message' => $this->lang->line('success_message'));
        echo json_encode($array);

    }

    public function getStudentByClassBatch()
    {
        $class_id            = $this->input->post('class_id');
        $section_id          = $this->input->post('section_id');
        $session_id          = $this->input->post('session_id');
        $data['studentList'] = $this->examgroupstudent_model->searchStudentByClassSectionSession($class_id, $section_id, $session_id);
        echo json_encode($data);
    }

    public function getExamGroupByStudent()
    {
        $student_id = $this->input->post('student_id');
        $data['examgrouplist'] = $this->examgroup_model->getExamGroupByStudent($student_id);
        echo json_encode($data);
    }

    public function studentresult()
    {
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('exam_group_id', $this->lang->line('exam_group_id'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('student_id', $this->lang->line('student_id'), 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'exam_group_id' => form_error('exam_group_id'),
                'student_id'    => form_error('student_id'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {

            $student_id         = $this->input->post('student_id');
            $exam_group_id      = $this->input->post('exam_group_id');
            $exam_group_exam_id = $this->input->post('exam_id');

            $examresult  = array();
            $exam_grades = array();
            if ($exam_group_exam_id != "") {
                $examresult = $this->examgroup_model->getExamResultDetailStudent($exam_group_exam_id, $exam_group_id, $student_id);
                $data['examresult']  = $examresult;
                $exam_grades         = $this->grade_model->getByExamType($examresult->exam_type);
                $data['exam_grades'] = $exam_grades;
                $examresult          = $this->load->view('admin/examresult/_getExam', $data, true);
            } else {
                $exam_group         = $this->examgroup_model->get($exam_group_id);
                $data['exam_group'] = $exam_group;
                $exam_grades         = $this->grade_model->getByExamType($exam_group->exam_type);
                $data['exam_grades'] = $exam_grades;
                $exam_result              = $this->examgroup_model->getExamGroupExamsResultByStudentID($exam_group_id, $student_id);
                $data['examresult']       = $exam_result;
                $exam_connections         = $this->examgroup_model->getExamGroupConnection($exam_group_id);
                $data['exam_connections'] = $exam_connections;
                $examresult               = $this->load->view('admin/examresult/_getExamGroupResult', $data, true);
            }

            $data['exam_grades'] = $exam_grades;

            $array = array('status' => '1', 'result' => $examresult, 'message' => $this->lang->line('success_message'));
            echo json_encode($array);
        }
    }

    public function getStudentCurrentResult()
    {
        $this->form_validation->set_rules('student_session_id', $this->lang->line('student_id'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {
            $msg = array(
                'student_session_id' => form_error('student_session_id'),
            );

            $array = array('status' => 0, 'error' => $msg);
        } else {
            $student_session_id  = $this->input->post('student_session_id');
            $data['exam_grades'] = $this->grade_model->get();
            $exam_groups_attempt = $this->examgroup_model->getExamGroupByStudentSession($student_session_id);

            $data['exam_groups_attempt'] = $exam_groups_attempt;
            $examresult                  = $this->load->view('admin/examresult/_getExamGroupResult', $data, true);
            $array                       = array('status' => 1, 'error' => '', 'result' => $examresult);
        }
        echo json_encode($array);
    }

    public function generatemarksheet()
    {
        $this->form_validation->set_rules('exam_id', $this->lang->line('exam_id'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('check[]', $this->lang->line('students'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

            $msg = array(
                'exam_id' => form_error('exam_id'),
                'check'   => form_error('check'),
            );

            $array = array('status' => 0, 'error' => $msg);
        } else {
            echo "<pre/>";
            $exam_id         = $this->input->post('exam_id');
            $students        = $this->input->post('check');
            $exam            = $this->examgroup_model->getExamByID($exam_id);
            $exam_id         = $exam->id;
            $students_result = array();
            if (!empty($students)) {
                foreach ($students as $student_key => $student_value) {
                    print_r($student_value);
                    exit();

                    $students_result[] = $this->examresult_model->getStudentExamResult($exam_id, $student_value);
                }
            }
            print_r($students_result);
            exit();
        }
        echo json_encode($array);
    }

    public function rankreport()
    {
        if (!$this->rbac->hasPrivilege('rank_report', 'can_view')) {
            access_denied();
        }

        $this->session->set_userdata('top_menu', 'Reports');
        $this->session->set_userdata('sub_menu', 'Reports/examinations');
        $this->session->set_userdata('subsub_menu', 'Reports/examinations/rankreport');
        $examgroup_result      = $this->examgroup_model->get();
        $data['examgrouplist'] = $examgroup_result;

        $marksheet_result      = $this->marksheet_model->get();
        $data['marksheetlist'] = $marksheet_result;

        $class               = $this->class_model->get();
        $data['title']       = 'Add Batch';
        $data['title_list']  = 'Recent Batch';
        $data['examType']    = $this->exam_type;
        $data['classlist']   = $class;
        $session             = $this->session_model->get();
        $data['sessionlist'] = $session;
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('session_id', $this->lang->line('session'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_group_id', $this->lang->line('exam_group'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_id', $this->lang->line('exam'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == true) {

   
            $exam_group_id = $this->input->post('exam_group_id');
            $exam_id       = $this->input->post('exam_id');
            $session_id    = $this->input->post('session_id');
            $class_id      = $this->input->post('class_id');
            $section_id    = $this->input->post('section_id');

            $marksheet_template         = $this->input->post('marksheet');
            $data['marksheet_template'] = $marksheet_template;
            $exam_details               = $this->examgroup_model->getExamByID($exam_id);

            $studentList = $this->examgroupstudent_model->searchExamStudents($exam_group_id, $exam_id, $class_id, $section_id, $session_id);

            $exam_subjects       = $this->batchsubject_model->getExamSubjects($exam_id);
            $data['subjectList'] = $exam_subjects;

            if (!empty($studentList)) {
                foreach ($studentList as $student_key => $student_value) {
                    $studentList[$student_key]->subject_results = $this->examresult_model->getStudentResultByExam($exam_id, $student_value->exam_group_class_batch_exam_student_id);
                }
            }

            $data['studentList'] = $studentList;

            $exam_grades           = $this->grade_model->getByExamType($exam_details->exam_group_type);
            $data['exam_grades']   = $exam_grades;
            $data['exam_details']  = $exam_details;
            $data['exam_id']       = $exam_id;
            $data['exam_group_id'] = $exam_group_id;
        }
        $data['sch_setting'] = $this->sch_setting_detail;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/examresult/rankreport', $data);
        $this->load->view('layout/footer', $data);
    }
    
    
    public function termwisereport() {
        if (!$this->rbac->hasPrivilege('rank_report', 'can_view')) {
            access_denied();
        }

        $this->session->set_userdata('top_menu', 'Reports');
        $this->session->set_userdata('sub_menu', 'Reports/examinations');
        $this->session->set_userdata('subsub_menu', 'Reports/examinations/termwisereport');
        $examgroup_result = $this->examgroup_model->get();
        $data['examgrouplist'] = $examgroup_result;

        $marksheet_result = $this->marksheet_model->get();
        $data['marksheetlist'] = $marksheet_result;

        $class = $this->class_model->get();
        $data['title'] = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType'] = $this->exam_type;
        $data['classlist'] = $class;
        $session = $this->session_model->get();
        $data['sessionlist'] = $session;
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        // $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('session_id', $this->lang->line('session'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_group_id[]', $this->lang->line('exam') . " " . $this->lang->line('group'), 'trim|required|xss_clean');
        

        if ($this->form_validation->run() == false) {
            
        } else {
            $exam_group_id = $this->input->post('exam_group_id');
            
            
            $session_id = $this->input->post('session_id');
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');

            $marksheet_template = $this->input->post('marksheet');
            $data['marksheet_template'] = $marksheet_template;
            $exam_details = $this->examgroup_model->getExamsByExamGroups($exam_group_id);



            

            $exam_ids = array_column($exam_details, 'id');

            // print_r($exam_ids); die();

            $studentList = $this->examgroupstudent_model->searchExamsStudents($exam_group_id, $exam_ids, $class_id, $section_id, $session_id);

            // Initialize an empty array for unique subjects
            $unique_subjects = [];

            foreach ($exam_ids as $exam_id) {
                foreach ($this->batchsubject_model->getExamSubjects($exam_id) as $subject) {
                    $unique_subjects[$subject->subject_id] = $subject;
                }
            }
        
            $data['subjectList'] = array_values($unique_subjects);

            if (!empty($studentList)) {
            
                foreach ($studentList as $student_key => $student_value) {
                    $examResults = [];
                    foreach ($exam_ids as $exam_id) {
                        $examSubjectResultData = $this->examresult_model->getStudentResultByExam($exam_id, $student_value->exam_group_class_batch_exam_student_id);
                        foreach ($data['subjectList'] as $subject) {
                            $examResults[$exam_id][$subject->subject_id] = $this->getSubjectMarks($examSubjectResultData, $subject->subject_id);
                        }
                    }
                    $studentList[$student_key]->exam_results = $examResults;
                }
            }

            $uniqueStudent = [];

            foreach ($studentList as $list) {
                // Check if the student already exists in the array
                if (!isset($uniqueStudent[$list->student_id])) {
                    // If the student doesn't exist, add the student data
                    $uniqueStudent[$list->student_id] = $list;
                }

                // Loop through each student's exam results
                foreach ($list->exam_results as $exam_id => $exam) {
                    // Loop through the subject list
                    foreach ($exam as $subject_id => $subject) {
                    
                        if (!empty($subject)) {
                            if (isset($uniqueStudent[$list->student_id]->exam_results[$exam_id][$subject_id])) {
                                $uniqueStudent[$list->student_id]->exam_results[$exam_id][$subject_id] = $subject;
                            }
                        }
                    }
                }
            }

            $examGroups=[];

            if (!empty($exam_group_id)) {

                foreach ($exam_group_id as $exam_group_idkey => $exam_group_idvalue) {

                    $examGroups[] = $this->examgroup_model->get($exam_group_idvalue);
                }

                

                
            }

            //print_r($examGroups); die();

            $data['examGroups'] = $examGroups;
            
            $data['studentList'] = array_values($uniqueStudent);
            $data['exam_details'] = $exam_details;
            // $data['exam_id'] = $exam_id;
            $data['class_id'] = $class_id;
            $data['section_id'] = $section_id;
            $data['exam_group_id'] = $exam_group_id;
            // print_r($data['exam_group_id']); die();
            
            $examGroupDetial =  $this->examgroup_model->getExamGroupsDetailByID($exam_group_id);
            $exam_grades = $this->grade_model->getByExamType($examGroupDetial->exam_type);
            $data['exam_grades'] = $exam_grades;
        }
        // echo "<pre>";
        // print_r($studentList); die();
        
        $data['sch_setting'] = $this->sch_setting_detail;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/examresult/termwisereport', $data);
        $this->load->view('layout/footer', $data);
    }

    public function subjectwisereport() {
        if (!$this->rbac->hasPrivilege('rank_report', 'can_view')) {
            access_denied();
        }

        $this->session->set_userdata('top_menu', 'Reports');
        $this->session->set_userdata('sub_menu', 'Reports/examinations');
        $this->session->set_userdata('subsub_menu', 'Reports/examinations/subjectwisereport');
        $examgroup_result = $this->examgroup_model->get();
        $data['examgrouplist'] = $examgroup_result;

        $marksheet_result = $this->marksheet_model->get();
        $data['marksheetlist'] = $marksheet_result;

        $class = $this->class_model->get();
        $data['title'] = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType'] = $this->exam_type;
        $data['classlist'] = $class;
        $session = $this->session_model->get();
        $data['sessionlist'] = $session;
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        // $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('session_id', $this->lang->line('session'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_group_id', $this->lang->line('exam') . " " . $this->lang->line('group'), 'trim|required|xss_clean');
        

        if ($this->form_validation->run() == false) {
            
        } else {
            $exam_group_id = $this->input->post('exam_group_id');
            
            $session_id = $this->input->post('session_id');
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');

            $subject_ids = $this->input->post('subject_id');

            // print_r($subject_ids);

            // var_dump($subject_ids); die();

            $marksheet_template = $this->input->post('marksheet');
            $data['marksheet_template'] = $marksheet_template;
            $exam_details = $this->examgroup_model->getExamByExamGroup($exam_group_id);

            $exam_ids = array_column($exam_details, 'id');

            $studentList = $this->examgroupstudent_model->searchExamStudents($exam_group_id, $exam_ids, $class_id, $section_id, $session_id);

            // Initialize an empty array for unique subjects
            $unique_subjects = [];

            foreach ($exam_ids as $exam_id) {
                foreach ($this->batchsubject_model->getExamSubjects($exam_id,$subject_ids) as $subject) {
                    $unique_subjects[$subject->subject_id] = $subject;
                }
            }




        
            $data['subjectList'] = array_values($unique_subjects);



            if (!empty($studentList)) {
            
                foreach ($studentList as $student_key => $student_value) {
                    $examResults = [];
                    foreach ($exam_ids as $exam_id) {
                        $examSubjectResultData = $this->examresult_model->getStudentResultByExam($exam_id, $student_value->exam_group_class_batch_exam_student_id);
                        foreach ($data['subjectList'] as $subject) {
                            $examResults[$exam_id][$subject->subject_id] = $this->getSubjectMarks($examSubjectResultData, $subject->subject_id);
                        }
                    }
                    $studentList[$student_key]->exam_results = $examResults;
                }
            }



            $uniqueStudent = [];

            foreach ($studentList as $list) {
                // Check if the student already exists in the array
                if (!isset($uniqueStudent[$list->student_id])) {
                    // If the student doesn't exist, add the student data
                    $uniqueStudent[$list->student_id] = $list;
                }

                // Loop through each student's exam results
                foreach ($list->exam_results as $exam_id => $exam) {
                    // Loop through the subject list
                    foreach ($exam as $subject_id => $subject) {
                    
                        if (!empty($subject)) {
                            if (isset($uniqueStudent[$list->student_id]->exam_results[$exam_id][$subject_id])) {
                                $uniqueStudent[$list->student_id]->exam_results[$exam_id][$subject_id] = $subject;
                            }
                        }
                    }
                }
            }
            
            $data['studentList'] = array_values($uniqueStudent);
            $data['exam_details'] = $exam_details;
            $data['exam_id'] = $exam_id;
            $data['exam_group_id'] = $exam_group_id;

            $data['subject_ids'] = $subject_ids;
            
            $examGroupDetial =  $this->examgroup_model->getExamGroupDetailByID($exam_group_id);
            $exam_grades = $this->grade_model->getByExamType($examGroupDetial->exam_type);
            $data['exam_grades'] = $exam_grades;

            // print_r($unique_subjects); die();
        }
        // echo "<pre>";
        // print_r($studentList); die();
        
        $data['sch_setting'] = $this->sch_setting_detail;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/examresult/subjectwisereport', $data);
        $this->load->view('layout/footer', $data);
    }

    public function examGroupSubjects()
    {
        $exam_group_id = $this->input->post('exam_group_id');
        // print_r($exam_group_id); die();
        $exam_details = $this->examgroup_model->getExamByExamGroup($exam_group_id);
        $exam_ids = array_column($exam_details, 'id');

        $unique_subjects = [];

            foreach ($exam_ids as $exam_id) {
                foreach ($this->batchsubject_model->getExamSubjects($exam_id) as $subject) {
                    $unique_subjects[$subject->subject_id] = $subject;
                }
            }
        
        $subjectList = array_values($unique_subjects);

        echo json_encode($subjectList);
    }
    
    function getSubjectMarks($subject_results, $subject_id)
    {
        if (!empty($subject_results))
        {
            
            foreach ($subject_results as $subject_result_key => $subject_result_value)
            {
                if ($subject_id == $subject_result_value->subject_id)
                {
                    return $subject_result_value;
                }
            }
        }
        return false;
    }
    
    public function examinations()
    {
        if (!$this->rbac->hasPrivilege('rank_report', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Reports');
        $this->session->set_userdata('sub_menu', 'Reports/examinations');
        $this->session->set_userdata('subsub_menu', '');
        $this->load->view('layout/header');
        $this->load->view('admin/examresult/examinations');
        $this->load->view('layout/footer');
    }

}
