<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Exampattern extends Admin_Controller
{

    public $exam_type            = array();
    private $sch_current_session = "";

    public function __construct()
    {
        parent::__construct();
        $this->load->library('encoding_lib');
        $this->load->library('mailsmsconf');
        $this->exam_type           = $this->config->item('exam_type');
        $this->config_attendance = $this->config->item('attendence');
        $this->sch_current_session = $this->setting_model->getCurrentSession();
        $this->attendence_exam     = $this->config->item('attendence_exam');
        $this->sch_setting_detail  = $this->setting_model->getSetting();
    }

    public function exportformat($class_id, $section_id)
    {
        // Fetch students of this class & section
        $students = $this->student_model->searchByClassSection($class_id, $section_id);
    
        // File name
        $filename = "import_marks_sample_file.csv";
    
        // Force download headers
        header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        header('Pragma: no-cache');
        header('Expires: 0');
    
        // Open output stream AFTER headers
        $fp = fopen('php://output', 'w');
    
        // Set CSV headers
        $header = ['adm_no','student_name','status','marks','note'];
        fputcsv($fp, $header);
    
        // Fill student rows
        foreach ($students as $stu) {
            $row = [
                $stu['admission_no'],
                $stu['firstname'] . ' ' . $stu['lastname'],
                0,
                '',
                '' // keep blank for marks entry
            ];
            fputcsv($fp, $row);
        }
    
        fclose($fp);
        exit;
    }


    public function uploadfile()
    {
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('file', $this->lang->line('image'), 'callback_handle_upload');

        if ($this->form_validation->run() == false) {
            $data = array(
                'file' => form_error('file'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {
            $return_array = array();

            if (isset($_FILES["file"]) && !empty($_FILES['file']['name'])) {

                $fileName = $_FILES["file"]["tmp_name"];
                if ($_FILES["file"]["size"] > 0) {
                    $file = fopen($fileName, "r");

                    // ✅ First row = headers
                    $headers = fgetcsv($file, 10000, ",");
                    $headers = array_map('trim', $headers); // remove spaces
                    $headerIndex = array_flip($headers);   // map header name to column index

                    // Loop rows
                    while (($row = fgetcsv($file, 10000, ",")) !== false) {
                        if (empty($row)) continue;

                        // Access by column name
                        $adm_no     = isset($headerIndex['adm_no']) ? ($row[$headerIndex['adm_no']]) : '';
                        $attendence = isset($headerIndex['status']) ? trim($row[$headerIndex['status']]) : '';
                        $marks      = isset($headerIndex['marks']) ? trim($row[$headerIndex['marks']]) : '';
                        $note       = isset($headerIndex['note']) ? $this->encoding_lib->toUTF8($row[$headerIndex['note']]) : '';

                        if ($adm_no != "" && $attendence != "" && $marks != "") {
                            $return_array[] = json_encode( array(
                                'adm_no'     => $adm_no,
                                'attendence' => $attendence,
                                'marks'      => number_format((float)$marks, 2, '.', ''),
                                'note'       => $note,
                            )
                        );
                        }
                    }
                    fclose($file);
                }

               

                $array = array('status' => '1', 'error' => '', 'student_marks' => $return_array);
                echo json_encode($array);
            }
        }
    }

    public function handle_upload()
    {

        $image_validate = $this->config->item('csv_validate');

        if (isset($_FILES["file"]) && !empty($_FILES['file']['name']) && $_FILES["file"]["size"] > 0) {

            $file_type         = $_FILES["file"]['type'];
            $file_size         = $_FILES["file"]["size"];
            $file_name         = $_FILES["file"]["name"];
            $allowed_extension = $image_validate['allowed_extension'];
            $ext               = pathinfo($file_name, PATHINFO_EXTENSION);
            $allowed_mime_type = $image_validate['allowed_mime_type'];
            $finfo             = finfo_open(FILEINFO_MIME_TYPE);
            $mtype             = finfo_file($finfo, $_FILES['file']['tmp_name']);
            finfo_close($finfo);

            if (!in_array($mtype, $allowed_mime_type)) {
                $this->form_validation->set_message('handle_upload', 'File Type Not Allowed');
                return false;
            }

            if (!in_array($ext, $allowed_extension) || !in_array($file_type, $allowed_mime_type)) {
                $this->form_validation->set_message('handle_upload', 'Extension Not Allowed');
                return false;
            }
            if ($file_size > $image_validate['upload_size']) {
                $this->form_validation->set_message('handle_upload', $this->lang->line('file_size_shoud_be_less_than') . number_format($image_validate['upload_size'] / 1048576, 2) . " MB");
                return false;
            }

            return true;
        } else {
            $this->form_validation->set_message('handle_upload', 'Please choose a file to upload.');
            return false;
        }
    }

    public function index()
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_view')) {
            access_denied();
        }
        // error_reporting(E_ALL);
        // ini_set('display_errors', 1);
        $this->session->set_userdata('top_menu', 'exam_pattern');
        $this->session->set_userdata('sub_menu', 'Examinations/exampattern');
        $data['title']      = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType']   = $this->exam_type;
        $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_type', $this->lang->line('exam') . " " . $this->lang->line('type'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

        } else {
            $is_active = 0;

            $data = array(
                'name'        => $this->input->post('name'),
                'exam_type'   => $this->input->post('exam_type'),
                'is_active'   => $is_active,
                'description' => $this->input->post('description'),
            );

            $insert_id = $this->examgroup_model->add_mh_examgroup($data);

            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/exampattern/index');
        }
        $menu_data['selected'] = 'exam_terms';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        $examgroup_result      = $this->examgroup_model->getexamgroup_mh();
        $data['examgrouplist'] = $examgroup_result;

        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/mh/examgroup', $data);
        $this->load->view('layout/footer', $data);
    }
    
    
    public function add_mh_exam($data) {
        if (isset($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('mh_exam_group_class_batch_exams', $data);
            $message = UPDATE_RECORD_CONSTANT . " On mh exam group exams name id " . $data['id'];
            $action = "Update";
            $record_id = $data['id'];
            $this->log($message, $record_id, $action);
        } else {
            $this->db->trans_start(); # Starting Transaction
            $this->db->trans_strict(false); # See Note 01. If you wish can remove as well

            $exam_group = $this->examgroup_model->get($data['exam_group_id']);
            $this->db->insert('mh_exam_group_class_batch_exams', $data);
            $insert_id = $this->db->insert_id();
            $message = INSERT_RECORD_CONSTANT . " On mh exam group exams name id " . $insert_id;
            $action = "Insert";
            $record_id = $insert_id;
            $this->log($message, $record_id, $action);
            // if ($exam_group->exam_type != "coll_grade_system") {
            //     $batch_subjects = $this->batchsubject_model->getClassBatchSubjects($data['class_batch_id']);
            //     if (!empty($batch_subjects)) {
            //         $exam_subjects = array();
            //         foreach ($batch_subjects as $batch_subject_key => $batch_subject_value) {
            //             $exam_subjects[] = array(
            //                 'exam_group_class_batch_exams_id' => $insert_id,
            //                 'class_batch_subject_id'          => $batch_subject_value->id,
            //             );
            //         }
            //         if (!empty($exam_subjects)) {
            //             $this->db->insert_batch('exam_group_class_batch_exam_subjects', $exam_subjects);
            //         }
            //     }
            // }
            $this->db->trans_complete(); # Completing transaction

            /* Optional */

            if ($this->db->trans_status() === false) {
                # Something went wrong.
                $this->db->trans_rollback();
                return false;
            } else {
                # Everything is Perfect.
                # Committing data to the database.
                $this->db->trans_commit();
                return true;
            }
        }
    }

//added by sweta 
        public function getNewExamByExamGroup($id, $is_active = false) {
            $this->db->select('exam_group_class_batch_exams.*, sessions.session, 
                               (SELECT COUNT(*) 
                                FROM exam_group_class_batch_exam_subjects 
                                WHERE exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id = exam_group_class_batch_exams.id) as `total_subjects`')
                     ->from('exam_group_class_batch_exams')
                     ->join('sessions', 'sessions.id = exam_group_class_batch_exams.session_id');
        
            // Check if $is_active is true and filter accordingly
            if ($is_active) {
                $this->db->where('exam_group_class_batch_exams.is_active', $is_active);
            }
        
            // Check if $id is an array (multiple exam_group_ids)
            if (is_array($id)) {
                $this->db->where_in('exam_group_class_batch_exams.exam_group_id', $id);
            } else {
                // If it's a single value, filter using where()
                if (valid($id)) {
                    $this->db->where('exam_group_class_batch_exams.exam_group_id', $id);
                }
            }
         
            $this->db->order_by('exam_group_class_batch_exams.exam_group_id');
        
            $query = $this->db->get();
        
            return $query->result();
        }
        
        
        public function getMHExamByExamGroup($id, $is_active = false,$is_termexam=null) {
        $this->db->select('mh_exam_group_class_batch_exams.*,mh_exam_groups.exam_type as `exam_group_type`,sessions.session,(select COUNT(*) from mh_exam_group_class_batch_exam_subjects WHERE mh_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id = mh_exam_group_class_batch_exams.id) as `total_subjects`')->from('mh_exam_group_class_batch_exams');
        $this->db->join('sessions', 'sessions.id = mh_exam_group_class_batch_exams.session_id');
        $this->db->join('mh_exam_groups', 'mh_exam_groups.id = mh_exam_group_class_batch_exams.exam_group_id');
        if ($is_active) {
            $this->db->where('mh_exam_group_class_batch_exams.is_active', $is_active);
        }
        if ($is_termexam) {
            $this->db->where('mh_exam_group_class_batch_exams.is_termexam', $is_termexam);
        }
        $this->db->where('mh_exam_group_class_batch_exams.exam_group_id', $id);
        $this->db->order_by('mh_exam_group_class_batch_exams.exam_group_id');

        $query = $this->db->get();

        return $query->result();
    }

    public function getExamByExamgroup()
    {
        $is_termexam   = $this->input->post('is_termexam');
        $exam_group_id = $this->input->post('exam_group_id');
        $data          = $this->examgroup_model->getMHExamByExamGroup($exam_group_id, true,$is_termexam);
        echo json_encode($data);
    }

    public function deleteExam()
    {

        $data['title'] = 'deleteExam';
        $id            = $this->input->post('id');
        if (!$this->examgroup_model->delete_mh_exam($id)) {
            echo json_encode(array('status' => 0, 'message' => $this->lang->line('something_wrong')));
        } else {
            echo json_encode(array('status' => 1, 'message' => $this->lang->line('record_deleted_successfully')));
        }
    }

    public function exam($id)
    {
        $data                    = array();
        $data['examgroupDetail'] = $this->examgroup_model->getExamByID($id);
        $data['exam_subjects']   = $this->batchsubject_model->getExamSubjects($id);
        $class                   = $this->class_model->get();
        $data['classlist']       = $class;
        $session                 = $this->session_model->get();
        $data['sessionlist']     = $session;
        $data['current_session'] = $this->sch_current_session;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/examgroup/exam', $data);
        $this->load->view('layout/footer', $data);
    }

    public function examresult($id)
    {
        $data = array();

        $data['id']        = $id;
        $class             = $this->class_model->get();
        $data['classlist'] = $class;
        if ($this->input->server('REQUEST_METHOD') == 'POST') {
            $exam_subject_id                                = $this->input->post('exam_group_class_batch_exam_subject_id');
            $class_id                                       = $this->input->post('class_id');
            $batch_id                                       = $this->input->post('batch_id');
            $data['class_id']                               = $this->input->post('class_id');
            $data['batch_id']                               = $this->input->post('batch_id');
            $data['exam_group_class_batch_exam_subject_id'] = $this->input->post('exam_group_class_batch_exam_subject_id');

            $data['exam_subjects'] = $this->batchsubject_model->getExamSubjects($id);
            $resultlist            = $this->batchsubject_model->examGroupExamResult($class_id, $batch_id, $id);

            $data['resultlist'] = $resultlist;
        }

        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/mh/examresult', $data);
        $this->load->view('layout/footer', $data);
    }

    public function addmark($id)
    {
        $data = array();

        $data['exam_subjects'] = $this->batchsubject_model->getExamSubjects($id);
        $data['id']            = $id;
        $class                 = $this->class_model->get();
        $data['classlist']     = $class;
        $session               = $this->session_model->get();
        $data['sessionlist']   = $session;
        if ($this->input->server('REQUEST_METHOD') == 'POST') {

            $exam_subject_id                                = $this->input->post('exam_group_class_batch_exam_subject_id');
            $data['exam_group_class_batch_exam_subject_id'] = $this->input->post('exam_group_class_batch_exam_subject_id');
            $class_id                                       = $this->input->post('class_id');
            $section_id                                     = $this->input->post('section_id');
            $session_id                                     = $this->input->post('session_id');
            $data['class_id']                               = $this->input->post('class_id');
            $data['section_id']                             = $this->input->post('section_id');
            $data['session_id']                             = $this->input->post('session_id');
            $resultlist                                     = $this->examgroupstudent_model->examGroupSubjectResult($exam_subject_id, $class_id, $section_id, $session_id);

            $subject_detail                                 = $this->batchsubject_model->getExamSubject($exam_subject_id);
            $data['subject_detail']                         = $subject_detail;
            $data['attendence_exam']                        = $this->attendence_exam;
            $data['resultlist']                             = $resultlist;
        }

        $this->load->view('layout/header', $data);
        $this->load->view('admin/examgroup/addmark', $data);
        $this->load->view('layout/footer', $data);
    }

    

    public function Exam_result() {
        if (!$this->rbac->hasPrivilege('exam_result', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Examinations');
        $this->session->set_userdata('sub_menu', 'Examinations/Examresult');
        $examgroup_result = $this->examgroup_model->getexamgroup_mh();
        $data['examgrouplist'] = $examgroup_result;

        $marksheet_result = $this->marksheet_model->get();
        $data['marksheetlist'] = $marksheet_result;

        $class = $this->class_model->get();
        $data['title'] = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType'] = $this->exam_type;
        $data['classlist'] = $class;
        $session = $this->session_model->get();
        $data['sessionlist'] = $session;
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('session_id', $this->lang->line('session'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_group_id', $this->lang->line('exam') . " " . $this->lang->line('group'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_id', $this->lang->line('exam'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {
            
        } else {
            $exam_group_id = $this->input->post('exam_group_id');
            $exam_id = $this->input->post('exam_id');
            $session_id = $this->input->post('session_id');
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $selected_class = $this->class_model->get($class_id);
            $data['selected_class'] = $selected_class['class'];
            $selected_section = $this->section_model->get($section_id);
            $data['selected_section'] = $selected_section['section'];
            

            $marksheet_template = $this->input->post('marksheet');
            $data['marksheet_template'] = $marksheet_template;
            $exam_details = $this->examgroup_model->getMHExamByID($exam_id);

            $studentList = $this->examgroupstudent_model->searchMHExamStudents($exam_group_id, $exam_id, $class_id, $section_id, $session_id);


            $exam_subjects = $this->batchsubject_model->getMHExamSubjects($exam_id);
            $data['subjectList'] = $exam_subjects;

            if (!empty($studentList)) {
                foreach ($studentList as $student_key => $student_value) {
                    $studentList[$student_key]->subject_results = $this->examresult_model->getStudentResultByMHExam($exam_id, $student_value->exam_group_class_batch_exam_student_id);
                }
            }
 
            $data['studentList'] = $studentList;

            $exam_grades = $this->grade_model->getByExamType($exam_details->exam_group_type);
            $data['exam_grades'] = $exam_grades;
            $data['exam_details'] = $exam_details;
            $data['exam_id'] = $exam_id;
            $data['exam_group_id'] = $exam_group_id;
        }   
        $data['sch_setting'] = $this->sch_setting_detail;
        $menu_data['selected'] = 'exam_result';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        $this->load->view('layout/header', $data);
        $this->load->view('admin/examresult/index', $data);
        $this->load->view('layout/footer', $data);
    }

    public function delete($id)
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Delete Batch';
        $this->examgroup_model->remove_mh_examgroup($id);
        redirect('admin/exampattern');
    }

    public function edit($id)
    {
        if (!$this->rbac->hasPrivilege('exam', 'can_edit')) {
            access_denied();
        }

        $data['id']            = $id;
        $examgroup             = $this->examgroup_model->getexamgroup_mh($id);
        $data['examgroup']     = $examgroup;
        $data['examType']      = $this->exam_type;
        $examgroup_result      = $this->examgroup_model->getexamgroup_mh();
        $data['examgrouplist'] = $examgroup_result;

        $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/exampattern/mh/examgroupEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $is_active = 0;

            $data = array(
                'id'          => $this->input->post('id'),
                'name'        => $this->input->post('name'),
                'exam_type'   => $this->input->post('exam_type'),
                'is_active'   => $is_active,
                'description' => $this->input->post('description'),
            );
            $insert_id = $this->examgroup_model->add_mh_examgroup($data);

            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/exampattern/index');
        }
    }

    

    public function report() {
        // if (!$this->rbac->hasPrivilege('print_marksheet', 'can_view')) {
        //     access_denied();
        // }
        $this->session->set_userdata('top_menu', 'Reports');
        $this->session->set_userdata('sub_menu', 'Reports/exampattern');
        $this->session->set_userdata('subsub_menu', 'Reports/exampattern/mh_exam_report');
        $examgroup_result = $this->examgroup_model->getexamgroup_mh();
        $data['examgrouplist'] = $examgroup_result;

        $marksheet_result = $this->marksheet_model->get();
        $data['marksheetlist'] = $marksheet_result;

        $class = $this->class_model->get();
        $data['title'] = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType'] = $this->exam_type;
        $data['classlist'] = $class;
        $session = $this->session_model->get();
        $data['sessionlist'] = $session;
        // $this->form_validation->set_rules('marksheet', $this->lang->line('marksheet'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('session_id', $this->lang->line('student'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_group_id', $this->lang->line('exam') . " " . $this->lang->line('group'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_id', $this->lang->line('exam'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {
            
        } else {
            $exam_group_id = $this->input->post('exam_group_id');
            $exam_id = $this->input->post('exam_id');
            $session_id = $this->input->post('session_id');
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $data['section_id'] = $section_id;
            $data['session_id'] = $session_id;
            $result_exam_ids = $this->getClassExamIdForFinalResult($class_id,$session_id);
            

            
            // getting and calculating student ranks in exams
            if(valid($result_exam_ids) && !empty($result_exam_ids)){
                $data['studentList'] = $this->examgroupstudent_model->searchMHExamStudents($exam_group_id, $result_exam_ids, $class_id, $section_id, $session_id);
                // getting and calculating student ranks in exams
                //echo '<pre>';print_r($data['studentList']);exit;
                $students_array = array();
                if(valid($data['studentList']) && !empty($data['studentList'])){
                    foreach($data['studentList'] as $stddata):
                        array_push($students_array, $stddata->exam_group_class_batch_exam_student_id);
                    endforeach;
                    $students_class_rank = array();
                    $students_section_rank = array();//exam_group_class_batch_exam_student_id
                    $marksheet = $this->examresult_model->getMHExamResults($exam_id, $exam_group_id, $students_array, $result_exam_ids);
                    if(valid($marksheet) && !empty($marksheet)):
                        foreach ($marksheet['students'] as $student_key => $student_value):
                            if(array_key_exists($student_value['student_id'], $students_class_rank)):
                                continue;
                            endif;
                            $max_mrks = 0;
                            $get_mrks = 0;
                            $std_pert = 0;
                            foreach($result_exam_ids as $exmid):
                                foreach($student_value['exam_result']['exam_result_' . $exmid] as $exmresult):
                                    $max_mrks = $max_mrks + intval(($exmresult->mark_entry_type == 2) ? 0 : $exmresult->max_marks);
                                    $get_mrks = $get_mrks + intval(($exmresult->mark_entry_type == 2) ? 0 : $exmresult->get_marks);
                                endforeach;
                            endforeach;
                            //$std_pert = ($max_mrks > 0) ? ($get_mrks * 100) / $max_mrks : 0;
                            $std_pert = number_format(($max_mrks > 0) ? ($get_mrks * 100) / $max_mrks : 0, 2, '.', '');
                            $students_class_rank[$student_value['student_id']] = array('percentage' => $std_pert, 'student_id' => $student_value['student_id']);
                            if($student_value['section_id'] == $section_id)
                            {
                                $students_section_rank[$student_value['student_id']] = array('percentage' => $std_pert, 'student_id' => $student_value['student_id']);
                            }
                        endforeach;
                    endif;
                    array_multisort(array_column($students_class_rank, 'percentage'), SORT_DESC, $students_class_rank);
                    array_multisort(array_column($students_section_rank, 'percentage'), SORT_DESC, $students_section_rank);
                    $students_class_rank_desc = array();
                    $students_section_rank_desc = array();
                    if(!empty($students_class_rank))
                    {
                        foreach($students_class_rank as $key => $stddata):
                            $students_class_rank_desc[$stddata['student_id']] = $key + 1;
                        endforeach;
                    }
                    if(!empty($students_section_rank))
                    {
                        foreach($students_section_rank as $key => $stddata):
                            $students_section_rank_desc[$stddata['student_id']] = $key + 1;
                        endforeach;
                    }
                    $data['students_class_rank'] = $students_class_rank_desc;
                    $data['students_section_rank'] = $students_section_rank_desc;
                }
                
            } else {
                $data['studentList'] = $this->examgroupstudent_model->searchMHExamStudents($exam_group_id, $exam_id, $class_id, $section_id, $session_id);
            }
            $data['examList'] = $this->examgroup_model->getMHExamByExamGroup($exam_group_id, true);
            
            $data['exam_id'] = $exam_id;
            $data['exam_group_id'] = $exam_group_id;
            $data['exam_class_id'] = $class_id;          
            
        }
        
        $data['sch_setting'] = $this->sch_setting_detail;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/mh/report', $data);
        $this->load->view('layout/footer', $data);
    }



    public function exam_final_report() {
        // if (!$this->rbac->hasPrivilege('print_marksheet', 'can_view')) {
        //     access_denied();
        // }
        // error_reporting(E_ALL);
        // ini_set('display_errors', 1);
        $this->session->set_userdata('top_menu', 'Reports');
        $this->session->set_userdata('sub_menu', 'Reports/exampattern');
        $this->session->set_userdata('subsub_menu', 'Reports/exampattern/exam_final_report');
        $examgroup_result = $this->examgroup_model->getexamgroup_mh();
        $data['examgrouplist'] = $examgroup_result;

        $marksheet_result = $this->marksheet_model->get();
        $data['marksheetlist'] = $marksheet_result;

        $class = $this->class_model->get();
        $data['title'] = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType'] = $this->exam_type;
        $data['classlist'] = $class;
        $session = $this->session_model->get();
        $data['sessionlist'] = $session;
        // $this->form_validation->set_rules('marksheet', $this->lang->line('marksheet'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_group_id[]', $this->lang->line('exam_group'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('session_id', $this->lang->line('student'), 'trim|required|xss_clean');
        

        if ($this->form_validation->run() == false) {
            
        } else {
            $exam_group_ids = $this->input->post('exam_group_id');
            $session_id = $this->input->post('session_id');
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $data['section_id'] = $section_id;
            $data['session_id'] = $session_id;
            $exam_ids = array();
            foreach ($exam_group_ids as $key => $value) {
                $examData=$this->examgroup_model->getMHExamByExamGroup($value,true,"yes");
                
                foreach ($examData as  $exam) {
                   $exam_ids[] = $exam->id;
                }
            }
            
            
           
            

            
            
            if (!empty($exam_ids)) {
                $data['studentList'] = $this->examgroupstudent_model->searchMHExamStudents('',$exam_ids,$class_id,$section_id,$session_id);
            }

            // print_r($data['studentList']); die();


            
            $data['exam_id'] = $exam_ids;
            $data['exam_group_id'] = $exam_group_ids;
            $data['exam_class_id'] = $class_id;          
            
        }
        
        $data['sch_setting'] = $this->sch_setting_detail;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/mh/exam_final_report', $data);
        $this->load->view('layout/footer', $data);
    }


    public function print_report_card() {
        // error_reporting(E_ALL);
        // ini_set('display_errors', 1);
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('post_exam_id', $this->lang->line('exam'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_exam_group_id', $this->lang->line('exam') . " " . $this->lang->line('group'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('exam_group_class_batch_exam_student_id[]', $this->lang->line('students'), 'required|trim|xss_clean');
        $data = array();

        if ($this->form_validation->run() == false) {
            $data = array(
                'post_exam_id' => form_error('post_exam_id'),
                'post_exam_group_id' => form_error('post_exam_group_id'),
                'exam_group_class_batch_exam_student_id' => form_error('exam_group_class_batch_exam_student_id'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {
            
            $post_exam_id = $this->input->post('post_exam_id');
            $post_exam_group_id = $this->input->post('post_exam_group_id');
            $post_exam_class_id = $this->input->post('post_exam_class_id');
            $post_session_id    = $this->input->post('post_session_id');
            $post_exam_section_id    = $this->input->post('post_exam_section_id');
            
            $startMonth             = $this->setting_model->getStartMonth();
            $session_id = ($post_exam_class_id == 24000) ? 26 : ''; // this is temporary to get old session exam Ids for specific class(ex:9th class) for printmarksheet
            $data['class_data'] = $this->class_model->get($post_exam_class_id);
            $data['section_data'] = $this->section_model->get($post_exam_section_id);
            $result_exam_ids = $this->getClassExamIdForFinalResult($post_exam_class_id,$session_id);
            $students_array = $this->input->post('exam_group_class_batch_exam_student_id');
            $student_result = $this->examgroupstudent_model->getMHExamStudents($students_array);

            $students_class_rank = $this->input->post('students_class_rank');
            $students_section_rank = $this->input->post('students_section_rank');
            $exam = $this->examgroup_model->getMHExamByID($post_exam_id);
            $examsessionData = $this->session_model->get($post_session_id);
            $exam_session = $examsessionData['session'];
            $data['year'] = $exam_session;
            $year = explode('-', $exam_session)[0];

            $months = ["June", "July", "August", "September", "October", "November", "December", "January", "February", "March", "April", "May"];
            $monthAttendanceCount = [];

            foreach ($months as $monthName) {
                $month_number = date("m", strtotime($monthName . " 1")); // Get numeric month (e.g., 06 for June)

                $attendanceYear = ($month_number >= 6) ? $year : ($year + 1);

                foreach ($student_result as $result_v) {
                    // Proper Y-m-d date
                    $date = $attendanceYear . '-' . str_pad($month_number, 2, '0', STR_PAD_LEFT) . '-01';

                    $newdate = date('Y-m-d', strtotime($date));

                    $student_id = $result_v['student_session_id'];

                    // Now get attendance
                    $attendanceData = $this->stuMonthAttendance($newdate, 1, $student_id);

                    // Save properly by student_id -> month -> attendance_data
                    $monthAttendanceCount[$student_id][$monthName] = $attendanceData;
                }
            }


            $data['monthAttendanceCount'] = $monthAttendanceCount;
            $data['exam'] = $exam;
            $data['exam_ids'] = $result_exam_ids;
            $data['students_class_rank'] = $students_class_rank;
            $data['students_section_rank'] = $students_section_rank;
            $setting_result = $this->setting_model->get();
            $data['settinglist'] = $setting_result;

            $exam_grades = $this->grade_model->getByExamType($exam->exam_group_type);
            $data['exam_grades'] = $exam_grades;
            
            $data['marksheet'] = $this->examresult_model->getMHExamResults($post_exam_id, $post_exam_group_id, $students_array, $result_exam_ids);


            

            $data['sch_setting'] = $this->sch_setting_detail;
            $student_exam_page = $this->load->view('admin/exampattern/mh/_print_report_card', $data, true); 
            $array = array('status' => '1', 'error' => '', 'page' => $student_exam_page);
            echo json_encode($array);
        }
    }


    public function print_final_report() {
        // error_reporting(E_ALL);
        // ini_set('display_errors', 1);
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('post_exam_id[]', $this->lang->line('exam'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_exam_group_id[]', $this->lang->line('exam') . " " . $this->lang->line('group'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('exam_group_class_batch_exam_student_id[]', $this->lang->line('students'), 'required|trim|xss_clean');
        
        $data = array();

        if ($this->form_validation->run() == false) {
            $data = array(
                'post_exam_id' => form_error('post_exam_id'),
                'post_exam_group_id' => form_error('post_exam_group_id'),
                'exam_group_class_batch_exam_student_id' => form_error('exam_group_class_batch_exam_student_id'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {
            $post_exam_id = $this->input->post('post_exam_id'); // Now an array

            $post_exam_group_id = $this->input->post('post_exam_group_id'); // Now an array
            $post_exam_class_id = $this->input->post('post_exam_class_id');
            $post_session_id = $this->input->post('post_session_id');
            $post_exam_section_id = $this->input->post('post_exam_section_id');
            
            $startMonth = $this->setting_model->getStartMonth();
            $session_id = ($post_exam_class_id == 24000) ? 26 : ''; 
            $data['class_data'] = $this->class_model->get($post_exam_class_id);
            $data['section_data'] = $this->section_model->get($post_exam_section_id);
            $students_array = $this->input->post('exam_group_class_batch_exam_student_id');
            $students_class_rank = $this->input->post('students_class_rank');
            $students_section_rank = $this->input->post('students_section_rank');
            $examsessionData = $this->session_model->get($post_session_id);
            $exam_session = $examsessionData['session'];
            $data['year'] = $exam_session;
            $year = explode('-', $exam_session)[0];
            
            $marksheets = [];
            $exam_data = [];
            $result_exam_ids = $this->getClassExamIdForFinalResult($post_exam_class_id, $session_id);
                $student_result = $this->examgroupstudent_model->getMHExamStudents($students_array);

            $months = ["June", "July", "August", "September", "October", "November", "December", "January", "February", "March", "April", "May"];
            $monthAttendanceCount = [];

            foreach ($months as $monthName) {
                $month_number = date("m", strtotime($monthName . " 1")); // Get numeric month (e.g., 06 for June)

                $attendanceYear = ($month_number >= 6) ? $year : ($year + 1);

                foreach ($student_result as $result_v) {
                    // Proper Y-m-d date
                    $date = $attendanceYear . '-' . str_pad($month_number, 2, '0', STR_PAD_LEFT) . '-01';

                    $newdate = date('Y-m-d', strtotime($date));

                    $student_id = $result_v['student_session_id'];

                    // Now get attendance
                    $attendanceData = $this->stuMonthAttendance($newdate, 1, $student_id);

                    // Save properly by student_id -> month -> attendance_data
                    $monthAttendanceCount[$student_id][$monthName] = $attendanceData;
                }
            }

            



            





            // foreach ($post_exam_id  as $key => $exam_id) {
            //     $exam = $this->examgroup_model->getMHExamByID($exam_id);
            //     $exam_data[] = $exam;
                

            //     $exam_group_id = $post_exam_group_id[$key];

               

            //     $marksheets = $this->examresult_model->getMHFinalExamResults($exam_id, $exam_group_id, $students_array, $result_exam_ids);
                
                
            // }
            $exam_grades = $this->grade_model->getByExamType('basic_system');
                
                $data['exam_grades'] = $exam_grades;

            $marksheets = $this->examresult_model->getStudentFinalResultByGroupExam($post_exam_id,$students_array,$post_exam_class_id);

           
            // print_r($marksheets); die();


            $data['monthAttendanceCount'] = $monthAttendanceCount;
            $data['exam_data'] = $exam_data;
            $data['exam_ids'] = $post_exam_id; // Store multiple exam IDs
            $data['students_class_rank'] = $students_class_rank;
            $data['students_section_rank'] = $students_section_rank;
            $setting_result = $this->setting_model->get();
            $data['settinglist'] = $setting_result;
            $data['marksheet'] = $marksheets; // Store marksheets for multiple exams
            $data['sch_setting'] = $this->sch_setting_detail;
            
          

            // Load the report view with modified data
            $student_exam_page = $this->load->view('admin/exampattern/mh/print_final_report', $data, true);
            $array = array('status' => '1', 'error' => '', 'page' => $student_exam_page);
            echo json_encode($array);
        }
    }



    


    public function term_report() {
        // if (!$this->rbac->hasPrivilege('print_marksheet', 'can_view')) {
        //     access_denied();
        // }
        $this->session->set_userdata('top_menu', 'Reports');
        $this->session->set_userdata('sub_menu', 'Reports/exampattern');
        $this->session->set_userdata('subsub_menu', 'Reports/exampattern/mh_term_report');
        $examgroup_result = $this->examgroup_model->getexamgroup_mh();
        $data['examgrouplist'] = $examgroup_result;

        $marksheet_result = $this->marksheet_model->get();
        $data['marksheetlist'] = $marksheet_result;

        $class = $this->class_model->get();
        $data['title'] = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType'] = $this->exam_type;
        $data['classlist'] = $class;
        $session = $this->session_model->get();
        $data['sessionlist'] = $session;
        // $this->form_validation->set_rules('marksheet', $this->lang->line('marksheet'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('session_id', $this->lang->line('student'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_group_id', $this->lang->line('exam') . " " . $this->lang->line('group'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_id', $this->lang->line('exam'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {
            
        } else {
            $exam_group_id = $this->input->post('exam_group_id');
            $exam_id = $this->input->post('exam_id');
            $session_id = $this->input->post('session_id');
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $data['section_id'] = $section_id;
            $data['session_id'] = $session_id;
            $result_exam_ids = $this->getClassExamIdForFinalResult($class_id,$session_id);
            

            
            // getting and calculating student ranks in exams
            if(valid($result_exam_ids) && !empty($result_exam_ids)){
                $data['studentList'] = $this->examgroupstudent_model->searchMHExamStudents($exam_group_id, $result_exam_ids, $class_id, $section_id, $session_id);
                // getting and calculating student ranks in exams
                //echo '<pre>';print_r($data['studentList']);exit;
                $students_array = array();
                if(valid($data['studentList']) && !empty($data['studentList'])){
                    foreach($data['studentList'] as $stddata):
                        array_push($students_array, $stddata->exam_group_class_batch_exam_student_id);
                    endforeach;
                    $students_class_rank = array();
                    $students_section_rank = array();//exam_group_class_batch_exam_student_id
                    $marksheet = $this->examresult_model->getMHExamResults($exam_id, $exam_group_id, $students_array, $result_exam_ids);
                    if(valid($marksheet) && !empty($marksheet)):
                        foreach ($marksheet['students'] as $student_key => $student_value):
                            if(array_key_exists($student_value['student_id'], $students_class_rank)):
                                continue;
                            endif;
                            $max_mrks = 0;
                            $get_mrks = 0;
                            $std_pert = 0;
                            foreach($result_exam_ids as $exmid):
                                foreach($student_value['exam_result']['exam_result_' . $exmid] as $exmresult):
                                    $max_mrks = $max_mrks + intval(($exmresult->mark_entry_type == 2) ? 0 : $exmresult->max_marks);
                                    $get_mrks = $get_mrks + intval(($exmresult->mark_entry_type == 2) ? 0 : $exmresult->get_marks);
                                endforeach;
                            endforeach;
                            //$std_pert = ($max_mrks > 0) ? ($get_mrks * 100) / $max_mrks : 0;
                            $std_pert = number_format(($max_mrks > 0) ? ($get_mrks * 100) / $max_mrks : 0, 2, '.', '');
                            $students_class_rank[$student_value['student_id']] = array('percentage' => $std_pert, 'student_id' => $student_value['student_id']);
                            if($student_value['section_id'] == $section_id)
                            {
                                $students_section_rank[$student_value['student_id']] = array('percentage' => $std_pert, 'student_id' => $student_value['student_id']);
                            }
                        endforeach;
                    endif;
                    array_multisort(array_column($students_class_rank, 'percentage'), SORT_DESC, $students_class_rank);
                    array_multisort(array_column($students_section_rank, 'percentage'), SORT_DESC, $students_section_rank);
                    $students_class_rank_desc = array();
                    $students_section_rank_desc = array();
                    if(!empty($students_class_rank))
                    {
                        foreach($students_class_rank as $key => $stddata):
                            $students_class_rank_desc[$stddata['student_id']] = $key + 1;
                        endforeach;
                    }
                    if(!empty($students_section_rank))
                    {
                        foreach($students_section_rank as $key => $stddata):
                            $students_section_rank_desc[$stddata['student_id']] = $key + 1;
                        endforeach;
                    }
                    $data['students_class_rank'] = $students_class_rank_desc;
                    $data['students_section_rank'] = $students_section_rank_desc;
                }
                
            } else {
                $data['studentList'] = $this->examgroupstudent_model->searchMHExamStudents($exam_group_id, $exam_id, $class_id, $section_id, $session_id);
            }
            $data['examList'] = $this->examgroup_model->getMHExamByExamGroup($exam_group_id, true);
            
            $data['exam_id'] = $exam_id;
            $data['exam_group_id'] = $exam_group_id;
            $data['exam_class_id'] = $class_id;          
            
        }
        
        $data['sch_setting'] = $this->sch_setting_detail;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/mh/term_report', $data);
        $this->load->view('layout/footer', $data);
    }

    public function exam_student_report() {
        
        $this->session->set_userdata('top_menu', 'Reports');
        $this->session->set_userdata('sub_menu', 'Reports/exampattern');
        $this->session->set_userdata('subsub_menu', 'Reports/exampattern/exam_student_report');
        $examgroup_result = $this->examgroup_model->getexamgroup_mh();
        $data['examgrouplist'] = $examgroup_result;

        $marksheet_result = $this->marksheet_model->get();
        $data['marksheetlist'] = $marksheet_result;

        $class = $this->class_model->get();
        $data['title'] = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType'] = $this->exam_type;
        $data['classlist'] = $class;
        $session = $this->session_model->get();
        $data['sessionlist'] = $session;
        // $this->form_validation->set_rules('marksheet', $this->lang->line('marksheet'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('session_id', $this->lang->line('student'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_group_id', $this->lang->line('exam') . " " . $this->lang->line('group'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_id', $this->lang->line('exam'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {
            
        } else {
            $exam_group_id = $this->input->post('exam_group_id');
            $exam_id = $this->input->post('exam_id');
            $session_id = $this->input->post('session_id');
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $data['section_id'] = $section_id;
            $data['session_id'] = $session_id;
            $result_exam_ids = $this->getClassExamIdForFinalResult($class_id,$session_id);
            

            
            // getting and calculating student ranks in exams
            if(valid($result_exam_ids) && !empty($result_exam_ids)){
                $data['studentList'] = $this->examgroupstudent_model->searchMHExamStudents($exam_group_id, $result_exam_ids, $class_id, $section_id, $session_id);
                // getting and calculating student ranks in exams
                //echo '<pre>';print_r($data['studentList']);exit;
                $students_array = array();
                if(valid($data['studentList']) && !empty($data['studentList'])){
                    foreach($data['studentList'] as $stddata):
                        array_push($students_array, $stddata->exam_group_class_batch_exam_student_id);
                    endforeach;
                    $students_class_rank = array();
                    $students_section_rank = array();//exam_group_class_batch_exam_student_id
                    $marksheet = $this->examresult_model->getMHExamResults($exam_id, $exam_group_id, $students_array, $result_exam_ids);
                    if(valid($marksheet) && !empty($marksheet)):
                        foreach ($marksheet['students'] as $student_key => $student_value):
                            if(array_key_exists($student_value['student_id'], $students_class_rank)):
                                continue;
                            endif;
                            $max_mrks = 0;
                            $get_mrks = 0;
                            $std_pert = 0;
                            foreach($result_exam_ids as $exmid):
                                foreach($student_value['exam_result']['exam_result_' . $exmid] as $exmresult):
                                    $max_mrks = $max_mrks + intval(($exmresult->mark_entry_type == 2) ? 0 : $exmresult->max_marks);
                                    $get_mrks = $get_mrks + intval(($exmresult->mark_entry_type == 2) ? 0 : $exmresult->get_marks);
                                endforeach;
                            endforeach;
                            //$std_pert = ($max_mrks > 0) ? ($get_mrks * 100) / $max_mrks : 0;
                            $std_pert = number_format(($max_mrks > 0) ? ($get_mrks * 100) / $max_mrks : 0, 2, '.', '');
                            $students_class_rank[$student_value['student_id']] = array('percentage' => $std_pert, 'student_id' => $student_value['student_id']);
                            if($student_value['section_id'] == $section_id)
                            {
                                $students_section_rank[$student_value['student_id']] = array('percentage' => $std_pert, 'student_id' => $student_value['student_id']);
                            }
                        endforeach;
                    endif;
                    array_multisort(array_column($students_class_rank, 'percentage'), SORT_DESC, $students_class_rank);
                    array_multisort(array_column($students_section_rank, 'percentage'), SORT_DESC, $students_section_rank);
                    $students_class_rank_desc = array();
                    $students_section_rank_desc = array();
                    if(!empty($students_class_rank))
                    {
                        foreach($students_class_rank as $key => $stddata):
                            $students_class_rank_desc[$stddata['student_id']] = $key + 1;
                        endforeach;
                    }
                    if(!empty($students_section_rank))
                    {
                        foreach($students_section_rank as $key => $stddata):
                            $students_section_rank_desc[$stddata['student_id']] = $key + 1;
                        endforeach;
                    }
                    $data['students_class_rank'] = $students_class_rank_desc;
                    $data['students_section_rank'] = $students_section_rank_desc;
                }
                
            } else {
                $data['studentList'] = $this->examgroupstudent_model->searchMHExamStudents($exam_group_id, $exam_id, $class_id, $section_id, $session_id);
            }
            $data['examList'] = $this->examgroup_model->getMHExamByExamGroup($exam_group_id, true);
            
            $data['exam_id'] = $exam_id;
            $data['exam_group_id'] = $exam_group_id;
            $data['exam_class_id'] = $class_id;          
            
        }
        
        $data['sch_setting'] = $this->sch_setting_detail;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/mh/term_exam_student_report', $data);
        $this->load->view('layout/footer', $data);
    }

   

    public function student_rank_report() {
        // if (!$this->rbac->hasPrivilege('print_marksheet', 'can_view')) {
        //     access_denied();
        // }

        // error_reporting(E_ALL);
        // ini_set('display_errors', 1);
        
        $this->session->set_userdata('top_menu', 'Reports');
        $this->session->set_userdata('sub_menu', 'Reports/exampattern');
        $this->session->set_userdata('subsub_menu', 'Reports/exampattern/student_rank_report');
        $examgroup_result = $this->examgroup_model->getexamgroup_mh();
        $data['examgrouplist'] = $examgroup_result;

        $marksheet_result = $this->marksheet_model->get();
        $data['marksheetlist'] = $marksheet_result;

        $class = $this->class_model->get();
        $data['title'] = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType'] = $this->exam_type;
        $data['classlist'] = $class;
        $session = $this->session_model->get();
        $data['sessionlist'] = $session;
        // $this->form_validation->set_rules('marksheet', $this->lang->line('marksheet'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_group_id[]', $this->lang->line('exam_group'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('session_id', $this->lang->line('student'), 'trim|required|xss_clean');
        

        if ($this->form_validation->run() == false) {
            
        } else {
            $exam_group_ids = $this->input->post('exam_group_id');
            $session_id = $this->input->post('session_id');
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $data['section_id'] = $section_id;
            $data['session_id'] = $session_id;
            $exam_ids = array();
            
            foreach ($exam_group_ids as $key => $value) {
                $examData=$this->examgroup_model->getMHExamByExamGroup($value,true,"yes");
                
                foreach ($examData as  $exam) {
                   $exam_ids[] = $exam->id;
                }
            }


            if (!empty($exam_ids)) {
                $studentlist = $this->examgroupstudent_model->searchMHExamStudents('',$exam_ids,$class_id,$section_id,$session_id);
            }

            $students_array = [];

            foreach ($studentlist as $student_key => $student_value) {
               $students_array[] = $student_value->exam_group_class_batch_exam_student_id;
            }


            $marksheets = $this->examresult_model->getStudentFinalResultByGroupExam($exam_ids,$students_array,$class_id);
            // echo '<pre>';
            // print_r($marksheets); die();
            $exam = $this->examgroup_model->getMHExamByID($exam_ids[0]);
            $exam_grades = $this->grade_model->getByExamType($exam->exam_group_type);

            $data['exam_grades'] = $exam_grades;
            

            $data['studentList'] = $marksheets;

            $exam_subjects = $this->batchsubject_model->getMHExamSubjects($exam_ids);
            $data['subjectList'] = $exam_subjects;
            
            $data['exam_id'] = $exam_ids;
            $data['exam_group_id'] = $exam_group_ids;
            $data['exam_class_id'] = $class_id;          
            
        }
        
        $data['sch_setting'] = $this->sch_setting_detail;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/mh/student_rank_report', $data);
        $this->load->view('layout/footer', $data);
    }

    

    public function print_term_report() {
        // error_reporting(E_ALL);
        // ini_set('display_errors', 1);
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('post_exam_id', $this->lang->line('exam'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_exam_group_id', $this->lang->line('exam') . " " . $this->lang->line('group'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('exam_group_class_batch_exam_student_id[]', $this->lang->line('students'), 'required|trim|xss_clean');
        $data = array();

        if ($this->form_validation->run() == false) {
            $data = array(
                'post_exam_id' => form_error('post_exam_id'),
                'post_exam_group_id' => form_error('post_exam_group_id'),
                'exam_group_class_batch_exam_student_id' => form_error('exam_group_class_batch_exam_student_id'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {
            
            $post_exam_id = $this->input->post('post_exam_id');
            $post_exam_group_id = $this->input->post('post_exam_group_id');
            $post_exam_class_id = $this->input->post('post_exam_class_id');
            $post_session_id    = $this->input->post('post_session_id');
            $post_exam_section_id    = $this->input->post('post_exam_section_id');

            $marks_distribution_type = get_list('exam_marks_distribution_type', array('status' => 1), null, null, 0, 'id', 'ASC');
            $data['marks_distribution_type'] = $marks_distribution_type;
            $mark_subject_components = get_list('exam_class_subjects_component', array('status' => 1,'class_id' => $post_exam_class_id), null, null, 0, 'id', 'ASC');
                $data['mark_subject_components'] = $mark_subject_components;
                $mark_dist_components = get_list('exam_mark_distribution_component', array('status' => 1), null, null, 0, 'id', 'ASC');
                $data['mark_dist_components'] = $mark_dist_components;
            
            $startMonth             = $this->setting_model->getStartMonth();
            $session_id = ($post_exam_class_id == 24000) ? 26 : ''; // this is temporary to get old session exam Ids for specific class(ex:9th class) for printmarksheet
            $data['class_data'] = $this->class_model->get($post_exam_class_id);
            $data['section_data'] = $this->section_model->get($post_exam_section_id);
            $result_exam_ids = $this->getClassExamIdForFinalResult($post_exam_class_id,$session_id);
            $students_array = $this->input->post('exam_group_class_batch_exam_student_id');
            $student_result = $this->examgroupstudent_model->getMHExamStudents($students_array);
            $students_class_rank = $this->input->post('students_class_rank');
            $students_section_rank = $this->input->post('students_section_rank');
            $exam = $this->examgroup_model->getMHExamByID($post_exam_id);
            $examsessionData = $this->session_model->get($post_session_id);
            $exam_session = $examsessionData['session'];
            $data['year'] = $exam_session;
            $year = explode('-', $exam_session)[0];

            
            $data['exam'] = $exam;

            $data['exam_ids'] = $result_exam_ids;
            $data['students_class_rank'] = $students_class_rank;
            $data['students_section_rank'] = $students_section_rank;
            $setting_result = $this->setting_model->get();
            $data['settinglist'] = $setting_result;

            $exam_grades = $this->grade_model->getByExamType($exam->exam_group_type);

            $data['exam_grades'] = $exam_grades;
            $data['marksheet'] = $this->examresult_model->getMHExamResults($post_exam_id, $post_exam_group_id, $students_array, $result_exam_ids);
            // print_r($data['marksheet']['students']); die();
            $data['sch_setting'] = $this->sch_setting_detail;
            // print_r($data['sch_setting']->name); die();
            $student_exam_page = $this->load->view('admin/exampattern/mh/print_term_report', $data, true); 
            $array = array('status' => '1', 'error' => '', 'page' => $student_exam_page);
            echo json_encode($array);
        }
    }


    public function print_exam_student_report() {
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('post_exam_id', $this->lang->line('exam'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_exam_group_id', $this->lang->line('exam') . " " . $this->lang->line('group'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('exam_group_class_batch_exam_student_id[]', $this->lang->line('students'), 'required|trim|xss_clean');
        $data = array();

        if ($this->form_validation->run() == false) {
            $data = array(
                'post_exam_id' => form_error('post_exam_id'),
                'post_exam_group_id' => form_error('post_exam_group_id'),
                'exam_group_class_batch_exam_student_id' => form_error('exam_group_class_batch_exam_student_id'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {
            
            $post_exam_id = $this->input->post('post_exam_id');
            $post_exam_group_id = $this->input->post('post_exam_group_id');
            $post_exam_class_id = $this->input->post('post_exam_class_id');
            $post_session_id    = $this->input->post('post_session_id');
            $post_exam_section_id    = $this->input->post('post_exam_section_id');

            $marks_distribution_type = get_list('exam_marks_distribution_type', array('status' => 1), null, null, 0, 'id', 'ASC');
            $data['exam_subjects'] = $this->examsubject_model->get_exam_subjects($post_exam_id);
            
            $data['marks_distribution_type'] = $marks_distribution_type;
            $mark_subject_components = get_list('exam_class_subjects_component', array('status' => 1,'class_id' => $post_exam_class_id), null, null, 0, 'id', 'ASC');
                $data['mark_subject_components'] = $mark_subject_components;
                $mark_dist_components = get_list('exam_mark_distribution_component', array('status' => 1), null, null, 0, 'id', 'ASC');
                $data['mark_dist_components'] = $mark_dist_components;
            
            $startMonth             = $this->setting_model->getStartMonth();
            $session_id = ($post_exam_class_id == 24000) ? 26 : ''; // this is temporary to get old session exam Ids for specific class(ex:9th class) for printmarksheet
            $data['class_data'] = $this->class_model->get($post_exam_class_id);
            $data['section_data'] = $this->section_model->get($post_exam_section_id);
            $result_exam_ids = $this->getClassExamIdForFinalResult($post_exam_class_id,$session_id);
            $students_array = $this->input->post('exam_group_class_batch_exam_student_id');
            $student_result = $this->examgroupstudent_model->getMHExamStudents($students_array);
            $students_class_rank = $this->input->post('students_class_rank');
            $students_section_rank = $this->input->post('students_section_rank');
            $exam = $this->examgroup_model->getMHExamByID($post_exam_id);
            $examsessionData = $this->session_model->get($post_session_id);
            $exam_session = $examsessionData['session'];
            $data['year'] = $exam_session;
            $year = explode('-', $exam_session)[0];

            
            $data['exam'] = $exam;

            $data['exam_ids'] = $result_exam_ids;
            $data['students_class_rank'] = $students_class_rank;
            $data['students_section_rank'] = $students_section_rank;
            $setting_result = $this->setting_model->get();
            $data['settinglist'] = $setting_result;

            $exam_grades = $this->grade_model->getByExamType($exam->exam_group_type);
            $data['exam_grades'] = $exam_grades;
            $data['marksheet'] = $this->examresult_model->getMHExamResults($post_exam_id, $post_exam_group_id, $students_array, $result_exam_ids);
            // print_r($data['marksheet']); die();
            $data['sch_setting'] = $this->sch_setting_detail;
            $student_exam_page = $this->load->view('admin/exampattern/mh/print_exam_student_report', $data, true); 
            $array = array('status' => '1', 'error' => '', 'page' => $student_exam_page);
            echo json_encode($array);
        }
    }


    public function stuMonthAttendance($st_month, $no_of_months, $student_id)
    {
        $r = array();
        $month = date('m', strtotime($st_month));
        $year  = date('Y', strtotime($st_month));
        foreach ($this->config_attendance as $att_key => $att_value) {
            $s = $this->stuattendence_model->count_attendance_obj($month, $year, $student_id, $att_value);

            $r[$att_key] = $s;
        }
        return $r;
    }




    public function getByClassSection()
    {
        $section_id = $this->input->post('section_id');
        $data       = $this->examgroup_model->getStudentBatch($section_id);
        echo json_encode($data);
    }

    public function addexam($id)
    {

        if (!$this->rbac->hasPrivilege('exam', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'exam_pattern');
        $this->session->set_userdata('sub_menu', 'Examinations/exampattern');
        $data['title']      = 'Add Batch';
        $data['title_list'] = 'Recent Batch';

        $class               = $this->class_model->get();
        $data['classlist']   = $class;
        $data['examType']    = $this->exam_type;
        $session             = $this->session_model->get();
        $data['sessionlist'] = $session;
        $subjectlist         = $this->subject_model->get();
        $data['subjectlist'] = $subjectlist;

        $data['current_session'] = $this->sch_current_session;
        $data['examgroup']       = $this->examgroup_model->getexamgroup_mh($id);

        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/mh/addexam', $data);
        $this->load->view('layout/footer', $data);
    }

    public function getNotAppliedDiscount($student_session_id)
    {
        return $this->feediscount_model->getDiscountNotApplied($student_session_id);
    }

    public function subjectstudent()
    {
        // error_reporting(E_ALL);
        // ini_set('display_errors', 1);
        $this->form_validation->set_error_delimiters('<p>', '</p>');
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('subject_id', $this->lang->line('subject'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('session_id', $this->lang->line('session'), 'required|trim|xss_clean');
        $userdata = $this->customlib->getUserData();
        $role_id  = $userdata["role_id"];
        $can_edit = 1;
        if (isset($role_id) && ($userdata["role_id"] == 2) && ($userdata["class_teacher"] == "yes")) {
            $myclasssubjects = $this->subjecttimetable_model->canAddExamMarks($userdata["id"], $this->input->post('class_id'), $this->input->post('section_id'), $this->input->post('teachersubject_id'));
            $can_edit        = $myclasssubjects;
        }

        if ($this->form_validation->run() == false) {
            $data = array(
                'class_id'   => form_error('class_id'),
                'section_id' => form_error('section_id'),
                'session_id' => form_error('session_id'),
                'subject_id' => form_error('subject_id'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } 
        // elseif ($can_edit == 0) {
        //     $msg   = array('lesson' => $this->lang->line('not_authoried'));
        //     $array = array('status' => 0, 'error' => $msg);
        //     echo json_encode($array);
        // } 

        else {
            $exam_subject_id                                = $this->input->post('subject_id');
            $data['exam_group_class_batch_exam_subject_id'] = $exam_subject_id;
            $teachersubject_id                              = $this->input->post('teachersubject_id');
            $class_id                                       = $this->input->post('class_id');
            $section_id                                     = $this->input->post('section_id');
            $session_id                                     = $this->input->post('session_id');
            $data['class_id']                               = $this->input->post('class_id');
            $data['section_id']                             = $this->input->post('section_id');
            $data['session_id']                             = $this->input->post('session_id');
            $subjectwise_remark         = get_list('exam_subjectwise_remark', array('status' => 1,'subject_id' => $teachersubject_id), null, null, 0, 'id', 'ASC');
            $data['subjectwise_remark'] = $subjectwise_remark;
            $resultlist                                     = $this->examgroupstudent_model->MHexamGroupSubjectResult($exam_subject_id, $class_id, $section_id, $session_id);
            $subject_detail = $this->batchsubject_model->getMHExamSubject($exam_subject_id);
            $exam_group_class_batch_exams_id = $subject_detail->exam_group_class_batch_exams_id;
            $exam_group_class_batch_exams = $this->examgroup_model->getMHExamByID($exam_group_class_batch_exams_id);
            // $last_exam_id = $this->examgroupstudent_model->getLastExamId($exam_group_class_batch_exams->exam_group_id);

            $previous_exam_results = [];
            if ($exam_group_class_batch_exams->is_termexam == "yes") {
                $previous_exam_results = $this->examgroupstudent_model->getPreviousExamMarks($exam_subject_id, $class_id, $section_id, $session_id);

                $mark_subject_components = get_list('exam_class_subjects_component', array('status' => 1,'class_id' => $class_id,'subject_id' => $teachersubject_id), null, null, 0, 'id', 'ASC');
                $data['mark_subject_components'] = $mark_subject_components;
                $mark_dist_components = get_list('exam_mark_distribution_component', array('status' => 1), null, null, 0, 'id', 'ASC');
                $data['mark_dist_components'] = $mark_dist_components;
        
            }


            

            $data['previous_exam_results'] = $previous_exam_results;
            $data['subject_detail']  = $subject_detail;
            $data['attendence_exam'] = $this->attendence_exam;
            $data['resultlist']      = $resultlist;
            // print_r($resultlist); die();
            $data['sch_setting']     = $this->sch_setting_detail;


            
            $student_exam_page       = $this->load->view('admin/exampattern/mh/_partialstudentmarkEntry', $data, true);

            $array = array('status' => '1', 'error' => '', 'page' => $student_exam_page);
            echo json_encode($array);
        }
    }

    public function examstudent()
    {
        $this->form_validation->set_error_delimiters('<li>', '</li>');
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'required|trim|xss_clean');

        $data['adm_auto_insert'] = $this->sch_setting_detail->adm_auto_insert;
        $data['sch_setting']     = $this->sch_setting_detail;
        if ($this->form_validation->run() == false) {
            $msg = array(
                'class_id'   => form_error('class_id'),
                'section_id' => form_error('section_id'),
                // 'exam_id'    => form_error('exam_id'),
            );
            $array = array('status' => 0, 'error' => $msg);
            echo json_encode($array);
        } else {

            $class_id   = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');

            $data['class_id']   = $this->input->post('class_id');
            $data['section_id'] = $this->input->post('section_id');
            $data['exam_id']    = $this->input->post('exam_id');
            $resultlist         = $this->examstudent_model->searchMHExamStudents($data['class_id'], $data['section_id'], $data['exam_id']);

            $data['resultlist'] = $resultlist;
            $student_exam_page  = $this->load->view('admin/exampattern/mh/_partialexamstudent', $data, true);
            $array              = array('status' => '1', 'error' => '', 'page' => $student_exam_page);
            echo json_encode($array);
        }
    }

    public function ajaxaddexam()
    {
        error_reporting(E_ALL);
        ini_set('display_errors', 1);
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('exam', $this->lang->line('exam'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('session_id', $this->lang->line('session'), 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'exam'       => form_error('exam'),
                'session_id' => form_error('session_id'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {

            $exam_id    = $this->input->post('exam_id');
            $is_active  = $this->input->post('is_active');
            $is_publish = $this->input->post('is_publish');
            $is_termexam = $this->input->post('is_termexam');

            if (isset($is_active)) {
                $is_active = 1;
            } else {
                $is_active = 0;
            }

            if (isset($is_publish)) {
                $is_publish = 1;
            } else {
                $is_publish = 0;
            }

            if (isset($is_termexam)) {
                $is_termexam = $is_termexam;
            } else {
                $is_termexam = 'no';
            }

            $exam_group_id = $this->input->post('exam_group_id');
            $session_id = $this->input->post('session_id');

            $existing_exam_count = $this->examgroup_model->getExamCount($session_id, $exam_group_id);

            if ($existing_exam_count >= 2 && $exam_id == 0) {
                $array = array('status' => 1, 'error' => '', 'message' => "You can't add more than 2 exams.");
                echo json_encode($array);
                return;
            }

            $postarray = array(
                'exam'          => $this->input->post('exam'),
                'exam_group_id' => $this->input->post('exam_group_id'),
                'session_id'    => $this->input->post('session_id'),
                'is_active'     => $is_active,
                'is_publish'    => $is_publish,
                'is_termexam'   => $is_termexam,
                'description'   => $this->input->post('description'),
                'use_exam_roll_no'   => $this->input->post('use_exam_roll_no')
            );

            if ($exam_id != 0) {
                $postarray['id'] = $exam_id;
            }

            $inserted_id = $this->examgroup_model->add_mh_exam($postarray);
            $exam_data   = $this->examgroup_model->getMHExamByID($exam_id);
            if ($is_publish) {
                $exam_students = $this->examgroupstudent_model->searchMHExamStudentsByExam($exam_id);
                $student_exams = array('exam' => $exam_data, 'exam_result' => $exam_students);
                $s             = $this->mailsmsconf->mailsms('exam_result', $student_exams);
            }

            if ($exam_id != 0) {
                $array = array('status' => '1', 'error' => '', 'message' => $this->lang->line('update_message'));
            } else {
                $array = array('status' => '1', 'error' => '', 'message' => $this->lang->line('success_message'));
            }

            echo json_encode($array);
        }
    }
    
    public function ajaxcopyexam()
    {
        // error_reporting(E_ALL);
        // ini_set('display_errors', 1);
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('exam', $this->lang->line('exam'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('session_id', $this->lang->line('session'), 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'exam'       => form_error('exam'),
                'session_id' => form_error('session_id'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {

            $exam_id    = $this->input->post('exam_id');
            $copyexam_id    = $this->input->post('copyexam_id');
            $is_active  = $this->input->post('is_active');
            $is_termexam  = $this->input->post('is_termexam');
            $is_publish = $this->input->post('is_publish');

            if (isset($is_active)) {
                $is_active = 1;
            } else {
                $is_active = 0;
            }

            if (isset($is_publish)) {
                $is_publish = 1;
            } else {
                $is_publish = 0;
            }
            if (isset($is_termexam)) {
                $is_termexam = "yes";
            } else {
                $is_termexam = "no";
            }

            $postarray = array(
                'exam'          => $this->input->post('exam'),
                'exam_group_id' => $this->input->post('exam_group_id'),
                'session_id'    => $this->input->post('session_id'),
                'is_active'     => $is_active,
                'is_publish'    => $is_publish,
                'is_termexam'   => $is_termexam,
                'description'   => $this->input->post('description'),
                'use_exam_roll_no'   => $this->input->post('use_exam_roll_no')
            );

            if ($exam_id != 0) {
                $postarray['id'] = $exam_id;
            }

            // print_r($copyexam_id); die;

            $old_exam_students = $this->examstudent_model->getMHstudentsByExam($copyexam_id);
            

            $old_exam_subjects = $this->examsubject_model->get_mh_exam_subjects_byexam($copyexam_id);
            // print_r($old_exam_subjects); die;
            



            $inserted_id = $this->examgroup_model->add_mh_exam($postarray);

            $insert_student_array = array();
            $insert_subject_array = array();

            foreach ($old_exam_students as $key => $value) {
                $insert_student_array[] = array(
                    'exam_group_class_batch_exam_id' => $inserted_id,
                    'student_id' => $value->student_id,
                    'student_session_id' => $value->student_session_id,
                );
            } 

            foreach ($old_exam_subjects as $key => $value) {
                $insert_subject_array[] = array(
                            'exam_group_class_batch_exams_id' => $inserted_id,
                            'subject_id'                      => $value->subject_id,
                            'credit_hours'                    => $value->credit_hours,
                            'date_from'                       => $value->date_from,
                            'time_from'                       => $value->time_from,
                            'duration'                        => $value->duration,
                            'room_no'                         => $value->room_no,
                            'max_marks'                       => $value->max_marks,
                            'min_marks'                       => $value->min_marks,
                        );
            }

            // ✅ Insert into exam student table
            if (!empty($insert_student_array)) {
                $this->db->insert_batch('mh_exam_group_class_batch_exam_students', $insert_student_array);
            }

            // ✅ Insert into exam subject table
            if (!empty($insert_subject_array)) {
                $this->db->insert_batch('mh_exam_group_class_batch_exam_subjects', $insert_subject_array);
            }

            $exam_data   = $this->examgroup_model->getMHExamByID($exam_id);
            if ($is_publish) {
                $exam_students = $this->examgroupstudent_model->searchMHExamStudentsByExam($exam_id);
                // $student_exams = array('exam' => $exam_data, 'exam_result' => $exam_students);
                // $s             = $this->mailsmsconf->mailsms('exam_result', $student_exams);
            }

            

            if ($exam_id != 0) {
                $array = array('status' => '1', 'error' => '', 'message' => $this->lang->line('update_message'));
            } else {
                $array = array('status' => '1', 'error' => '', 'message' => $this->lang->line('success_message'));
            }

            echo json_encode($array);
        }
    }

    public function getExamsByExamGroup()
    {
        $exam_group_id = $this->input->post('exam_group_id');
        $exams         = $this->examgroup_model->getExamByExamGroup($exam_group_id, true);

        $array = array('status' => '1', 'error' => '', 'result' => $exams);
        echo json_encode($array);
    }

    public function entrymarks()
{
    $this->form_validation->set_error_delimiters('', '');
    $this->form_validation->set_rules('exam_group_class_batch_exam_subject_id', 'Subject', 'required|trim|xss_clean');

    if ($this->form_validation->run() == false) {
        $data = array(
            'exam_group_class_batch_exam_subject_id' => form_error('exam_group_class_batch_exam_subject_id'),
        );
        $array = array('status' => 0, 'error' => $data);
        echo json_encode($array);
    } else {
        $exam_group_student_id = $this->input->post('exam_group_student_id');
        $insert_array          = array();

        if (!empty($exam_group_student_id)) {
            foreach ($exam_group_student_id as $exam_group_student_value) {
                
                // Initialize mark distribution for the student

                $mark_dist_comp = array();



                if (!empty($_POST['mark_dist_comp'])) {
                    foreach ($_POST['mark_dist_comp'] as $compid) {
                        $mdtid = 0;
                        $mark = null;

                        // Check both assessment marks and special marks
                        if (isset($_POST['a_marks_' . $compid . $exam_group_student_value])) {
                            $mdtid = 1;
                            $mark = trim($_POST['a_marks_' . $compid . $exam_group_student_value]);
                        } elseif (isset($_POST['s_marks_' . $compid . $exam_group_student_value])) {
                            $mdtid = 3;
                            $mark = trim($_POST['s_marks_' . $compid . $exam_group_student_value]);
                        }

                        

                        if ($mark !== "" && is_numeric($mark)) {
                            $markdata = array(
                                'mdtid' => $mdtid,
                                'mdcid' => $compid,
                                'mark'  => $mark,
                            );
                            array_push($mark_dist_comp, $markdata);
                        }
                    }
                    
                }

                
                

                $attendance_post = $this->input->post('exam_group_student_attendance_' . $exam_group_student_value);
                $attendance = isset($attendance_post) ? $attendance_post : "present";



                $array = array(
                    'exam_group_class_batch_exam_subject_id' => $this->input->post('exam_group_class_batch_exam_subject_id'),
                    'exam_group_class_batch_exam_student_id' => $exam_group_student_value,
                    'attendence'                             => $attendance,
                    'comp_marks'                             => json_encode($mark_dist_comp),
                    'previous_exammarks'                         => $this->input->post('previous_exam_marks_' . $exam_group_student_value),
                    'get_marks'                              => $this->input->post('exam_group_student_mark_' . $exam_group_student_value),
                    'get_grade'                              => isset($_POST['exam_group_student_grade_' . $exam_group_student_value]) ? $this->input->post('exam_group_student_grade_' . $exam_group_student_value) : '',
                    'note'                                   => $this->input->post('exam_group_student_note_' . $exam_group_student_value),
                );

                $insert_array[] = $array;
            }
        }

        // Insert all student marks into the database
        $this->examgroupstudent_model->add_mh_result($insert_array);
        $array = array('status' => '1', 'error' => '', 'message' => $this->lang->line('success_message'));
        echo json_encode($array);
    }
}


    public function getexam()
    {
        $examgroup_id     = $this->input->post('examgroup_id');
        $data['examList'] = $this->examgroup_model->getMHExamByExamGroup($examgroup_id);

        $data['exam_page'] = $this->load->view('admin/exampattern/mh/_partialexamList', $data, true);

        echo json_encode($data);
    }

    public function connectexams()
    {
        $examgroup_id         = $this->input->post('examgroup_id');
        $data['examList']     = $this->examgroup_model->getExamByExamGroupConnection($examgroup_id);
        $data['examgroup_id'] = $examgroup_id;

        $data['exam_page'] = $this->load->view('admin/examgroup/_partialexamListConnection', $data, true);
        echo json_encode($data);
    }

    public function getExamByID()
    {
        $exam_id = $this->input->post('exam_id');
        $result  = $this->examgroup_model->getMHExamByID($exam_id);
        if (!empty($result)) {
            $result->date_from = $this->customlib->dateformat($result->date_from);
            $result->date_to   = $this->customlib->dateformat($result->date_to);
        }
        $data['exam'] = $result;
        echo json_encode($data);
    }

    public function getexamSubjects()
    {
         
        $exam_id                 = $this->input->post('exam_id');
        $class_batch_id          = $this->input->post('class_batch_id');
        $exam_group_ids          = $this->input->post('exam_group_id');
        $data['examgroupDetail'] = $this->examgroup_model->getMHExamByID($exam_id);
        $data['exam_subjects']   = $this->batchsubject_model->getMHExamSubjects($exam_id);
        $data['batch_subjects']  = $this->subject_model->get();

        $data['exam_id']             = $exam_id;
        $data['exam_subjects_count'] = count($data['exam_subjects']);

        $data['batch_subject_dropdown'] = $this->load->view('admin/exampattern/mh/_partialexamSubjectDropdown', $data, true);

        $data['subject_page'] = $this->load->view('admin/exampattern/mh/_partialexamSubjects', $data, true);

        echo json_encode($data);
    }

    public function getSubjectByExam()
    {
        $data                    = array();
        $id                      = $this->input->post('recordid');
        $data['examgroupDetail'] = $this->examgroup_model->getMHExamByID($id);

        $data['exam_subjects'] = $this->batchsubject_model->getMHExamSubjects($id);

        $class                   = $this->class_model->get();
        $data['classlist']       = $class;
        $session                 = $this->session_model->get();
        $data['sessionlist']     = $session;
        $data['current_session'] = $this->sch_current_session;
        $data['subject_page']    = $this->load->view('admin/exampattern/mh/_getSubjectByExam', $data, true);
        echo json_encode($data);
    }

    public function getTeacherRemarkByExam()
    {
        $data                      = array();
        $id                        = $this->input->post('recordid');
        $data['examgroupDetail']   = $this->examgroup_model->getMHExamByID($id);
        $data['examgroupStudents'] = $this->examgroupstudent_model->searchMHExamStudentsByExam($id);
        $data['sch_setting']       = $this->sch_setting_detail;
        $data['subject_page']      = $this->load->view('admin/examgroup/_getTeacherRemarkByExam', $data, true);
        echo json_encode($data);
    }

    public function addexamsubject()
    {
        //  error_reporting(E_ALL);
        // ini_set('display_errors', 1);

        $student_id = '';
        $this->form_validation->set_rules('examgroup_id', $this->lang->line('exam') . " " . $this->lang->line('group'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_group_class_batch_exam_id', $this->lang->line('exam') . " " . $this->lang->line('id'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('rows[]', $this->lang->line('subject'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

            $msg = array(
                'examgroup_id'                   => form_error('examgroup_id'),
                'exam_group_class_batch_exam_id' => form_error('exam_group_class_batch_exam_id'),
                'rows'                           => form_error('rows[]'),
            );

            $array = array('status' => '0', 'error' => $msg, 'message' => '');
        } else {
            $insert_array  = array();
            $update_array  = array();
            $subject_array = array();

            $not_be_del = array();

            $rows = $this->input->post('rows');
            foreach ($rows as $row_key => $row_value) {

                $update_id = $this->input->post('prev_row[' . $row_value . ']');
                if ($update_id == 0) {

                    if ($this->input->post('exam_group_class_batch_exam_id') != "" && $this->input->post('subject_' . $row_value) != "" && $this->input->post('max_marks_' . $row_value) != "" && $this->input->post('min_marks_' . $row_value) != "") {

                        $insert_array[] = array(
                            'exam_group_class_batch_exams_id' => $this->input->post('exam_group_class_batch_exam_id'),
                            'subject_id'                      => $this->input->post('subject_' . $row_value),
                            'credit_hours'                    => $this->input->post('credit_hours' . $row_value),
                            'date_from' => date('Y-m-d', strtotime($this->input->post('date_from_' . $row_value))),

                            'time_from'                       => $this->input->post('time_from' . $row_value),
                            'duration'                        => $this->input->post('duration' . $row_value),
                            'mark_entry_type'                 => $this->input->post('mark_entry_type_' . $row_value),
                            'room_no'                         => $this->input->post('room_no_' . $row_value),
                            'max_marks'                       => $this->input->post('max_marks_' . $row_value),
                            'min_marks'                       => $this->input->post('min_marks_' . $row_value),
                        );
                    }
                } else {
                    $not_be_del[]   = $update_id;
                    $update_array[] = array(
                        'id'                              => $update_id,
                        'credit_hours'                    => $this->input->post('credit_hours_' . $row_value),
                        'exam_group_class_batch_exams_id' => $this->input->post('exam_group_class_batch_exam_id'),
                        'subject_id'                      => $this->input->post('subject_' . $row_value),
                        'date_from'                       => date('Y-m-d', $this->customlib->datetostrtotime($this->input->post('date_from_' . $row_value))),
                        'time_from'                       => $this->input->post('time_from' . $row_value),
                        'duration'                        => $this->input->post('duration' . $row_value),
                        'mark_entry_type'                 => $this->input->post('mark_entry_type_' . $row_value),
                        'room_no'                         => $this->input->post('room_no_' . $row_value),
                        'max_marks'                       => $this->input->post('max_marks_' . $row_value),
                        'min_marks'                       => $this->input->post('min_marks_' . $row_value),
                    );
                }
            }
           

            $this->examsubject_model->add_mh($insert_array, $update_array, $not_be_del, $this->input->post('exam_group_class_batch_exam_id'));

            $array = array('status' => '1', 'error' => '', 'message' => $this->lang->line('success_message'));
        }

        echo json_encode($array);
    }

    public function assign($id)
    {
        if (!$this->rbac->hasPrivilege('fees_group_assign', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Batch');
        $this->session->set_userdata('sub_menu', 'examgroup/index');
        $data['id']        = $id;
        $data['title']     = 'student fees';
        $class             = $this->class_model->get();
        $data['classlist'] = $class;
        $examgroup         = $this->examgroup_model->getExamGroupDetailByID($id);

        $data['examgroup']   = $examgroup;
        $session_result      = $this->session_model->get();
        $data['sessionlist'] = $session_result;

        if ($this->input->server('REQUEST_METHOD') == 'POST') {

            $data['class_id']     = $this->input->post('class_id');
            $data['section_id']   = $this->input->post('section_id');
            $data['session_id']   = $this->input->post('session_id');
            $data['examgroup_id'] = $this->input->post('examgroup_id');

            $resultlist = $this->examgroupstudent_model->searchExamGroupStudents($data['examgroup_id'], $data['class_id'], $data['section_id'], $data['session_id']);

            $data['resultlist'] = $resultlist;
        }

        $this->load->view('layout/header', $data);
        $this->load->view('admin/examgroup/assign', $data);
        $this->load->view('layout/footer', $data);
    }

    public function addstudent()
    {
        $this->form_validation->set_rules('exam_group', $this->lang->line('exam') . " " . $this->lang->line('group'), 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'exam_group' => form_error('exam_group'),
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        } else {
            $array_insert = array();
            $array_delete = array();
            $exam_group   = $this->input->post('exam_group');

            $students_id  = $this->input->post('students_id');
            $all_students = $this->input->post('all_students');
            $students     = array();
            if (!isset($students_id)) {
                $students_id = array();
            }
            if (!empty($all_students)) {
                foreach ($all_students as $all_students_key => $all_students_value) {
                    if (in_array($all_students_value, $students_id)) {

                        $array_insert[] = array(
                            'exam_group_id'      => $exam_group,
                            'student_id'         => $all_students_value,
                            'student_session_id' => $all_students_value,
                        );
                    } else {
                        $array_delete[] = $all_students_value;
                    }
                }
            }

            $this->examgroupstudent_model->add($array_insert, $array_delete, $exam_group);

            $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('success_message'));
            echo json_encode($array);
        }
    }

    public function ajaxConnectForm()
    {
        if (isset($_POST['action'])) {
            if ($this->input->post('action') == "reset") {
                $exam_group_id = $this->input->post('examgroup_id');
                $this->examgroup_model->deleteExamGroupConnection($exam_group_id);
                $array = array('status' => 1, 'error' => '', 'message' => $this->lang->line('update_message'));
                echo json_encode($array);
            } elseif ($this->input->post('action') == "save") {

                $this->form_validation->set_error_delimiters('', '');
                $this->form_validation->set_rules('examgroup_id', $this->lang->line('exam') . " " . $this->lang->line('group'), 'required|trim|xss_clean');

                if ($this->form_validation->run() == false) {
                    $data = array(
                        'examgroup_id' => form_error('examgroup_id'),
                    );
                    $array = array('status' => 0, 'error' => $data);
                    echo json_encode($array);
                } else {
                    $array      = array();
                    $exam_array = $this->input->post('exam[]');
                    if (!empty($exam_array)) {
                        if (count($exam_array) <= 1) {
                            $array = array('status' => 0, 'error' => '', 'message' => $this->lang->line('please_select_atleast_two_or_more_exams'));
                        } else {

                            $exam_group = $this->examgroup_model->verifyExamConnection($exam_array);

                            if ($exam_group['no_record']) {
                                if (count($exam_group['exam_subject_array']) != count($exam_array)) {
                                    $array          = array('status' => 0, 'error' => '', 'message' => $this->lang->line('please_check_exam_subjects'));
                                    $insert_success = 0;
                                } else {

                                    reset($exam_group['exam_subject_array']);
                                    $result = key($exam_group['exam_subject_array']);

                                    $insert_success = 1;
                                    foreach ($exam_group['exam_subject_array'] as $exam_subject_key => $exam_subject_value) {

                                        $compair_result = $this->compare_multi_Arrays($exam_group['exam_subject_array'][$result], $exam_group['exam_subject_array'][$exam_subject_key]);

                                        if ($compair_result) {

                                            if (!empty($compair_result['more']) || !empty($compair_result['less']) || !empty($compair_result['diff'])) {
                                                $array          = array('status' => 0, 'error' => '', 'message' => $this->lang->line('please_check_exam_subjects'));
                                                $insert_success = 0;
                                                break;
                                            }
                                        } else {
                                            $array          = array('status' => 0, 'error' => '', 'message' => $this->lang->line('please_check_exam_subjects'));
                                            $insert_success = 0;
                                            break;
                                        }
                                    }
                                }
                            } else {
                                $array          = array('status' => 0, 'error' => '', 'message' => $this->lang->line('exams_subject_may_be_empty_please_check_exam_subjects'));
                                $insert_success = 0;
                            }

                            if ($insert_success) {
                                $insert_array  = array();
                                $exam_group_id = $this->input->post('examgroup_id');
                                if (!empty($exam_array)) {
                                    foreach ($exam_array as $exam_key => $exam_value) {

                                        $insert_array[] = array(
                                            'exam_group_id'                   => $exam_group_id,
                                            'exam_group_class_batch_exams_id' => $exam_value,
                                            'exam_weightage'                  => $this->input->post('exam_' . $exam_value),
                                        );
                                    }
                                }

                                $this->examgroup_model->connectExam($insert_array, $exam_group_id);
                                $array = array('status' => 1, 'error' => '', 'message' => $this->lang->line('exam_connected_successfully'));
                            }
                        }
                    } else {
                        $array = array('status' => 0, 'error' => '', 'message' => $this->lang->line('no_exams_selected'));
                    }

                    echo json_encode($array);
                }
            }
        }
    }

    public function compare_multi_Arrays($array1, $array2)
    {
        if (!empty($array1) && !empty($array2)) {
            $result = array("more" => array(), "less" => array(), "diff" => array());
            foreach ($array1 as $k => $v) {
                if (is_array($v) && isset($array2[$k]) && is_array($array2[$k])) {
                    $sub_result = compare_multi_Arrays($v, $array2[$k]);

                    foreach (array_keys($sub_result) as $key) {
                        if (!empty($sub_result[$key])) {
                            $result[$key] = array_merge_recursive($result[$key], array($k => $sub_result[$key]));
                        }
                    }
                } else {
                    if (isset($array2[$k])) {
                        if ($v !== $array2[$k]) {
                            $result["diff"][$k] = array("from" => $v, "to" => $array2[$k]);
                        }
                    } else {
                        $result["more"][$k] = $v;
                    }
                }
            }
            foreach ($array2 as $k => $v) {
                if (!isset($array1[$k])) {
                    $result["less"][$k] = $v;
                }
            }
            return $result;
        }
        return false;
    }

    public function getExamGroupByClassSection()
    {
        $exam_group = array();
        $class_id   = $this->input->post('class_id');
        $section_id = $this->input->post('section_id');
        $session_id = $this->input->post('session_id');
        $exam_group = $this->examgroup_model->getExamGroupByClassSection($class_id, $section_id, $session_id);
        echo json_encode(array('status' => 1, 'exam_group' => $exam_group));
    }

    public function entrystudents()
    {
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('exam_group_class_batch_exam_id', $this->lang->line('exam'), 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {

            $data = array(
                'exam_group_class_batch_exam_id' => form_error('exam_group_class_batch_exam_id'),
            );

            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {
            $check_alreay_inserted_students = array();
            $state                          = 1;
            $exam_group_class_batch_exam_id = $this->input->post('exam_group_class_batch_exam_id');
            $student_session                = $this->input->post('student_session_id');
            $all_students                   = $this->input->post('all_students');
            $insert_array                   = array();
            if (isset($student_session) && !empty($student_session)) {
                foreach ($student_session as $student_key => $student_value) {
                    $check_alreay_inserted_students[] = $this->input->post('student_' . $student_value);
                    $insert_array[]                   = array(
                        'exam_group_class_batch_exam_id' => $exam_group_class_batch_exam_id,
                        'student_id'                     => $this->input->post('student_' . $student_value),
                        'exam_seat_no'                   => $this->input->post('examseatno_' . $student_value),
                        'student_session_id'             => $student_value,
                    );
                }
            }

            $this->examstudent_model->add_mh_student($insert_array, $exam_group_class_batch_exam_id, $all_students);
            $array = array('status' => '1', 'error' => '', 'message' => $this->lang->line('success_message'));            

            echo json_encode($array);
        }
    }

    public function saveexamremark()
    {
        $students = $this->input->post('exam_group_class_batch_exam_student');
        if (!empty($students)) {
            $batch_update_array = array();
            foreach ($students as $student_key => $student_value) {
                $update_array = array(
                    'id'             => $student_value,
                    'teacher_remark' => $this->input->post('remark_' . $student_value),
                );
            $batch_update_array[]=$update_array;
            }
            $this->examgroupstudent_model->updateMHExamStudent($batch_update_array);
        }
        $array = array('status' => '1', 'error' => '', 'message' => $this->lang->line('success_message'));
        echo json_encode($array);
    }
    
    public function marks_distribution_type()
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'exam_pattern');
        $this->session->set_userdata('sub_menu', 'Examinations/exampattern');
        $data['title']      = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType']   = $this->exam_type;
        $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        //$this->form_validation->set_rules('exam_type', $this->lang->line('exam') . " " . $this->lang->line('type'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

        } else {
            $is_active = 0;
            $data = array(
                'name'        => $this->input->post('name'),
                'status'   => 1,
                'description' => $this->input->post('description'),
            );

            //$insert_id = $this->examgroup_model->add($data);
            $insert_id = insertData('exam_marks_distribution_type', $data);

            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/exampattern/marks_distribution_type');
        }
        //$examgroup_result      = $this->examgroup_model->get();
        $examgroup_result      = get_list('exam_marks_distribution_type', array('status' => 1), null, null, 0, 'id', 'ASC');
        $data['examgrouplist'] = $examgroup_result;
        
        $menu_data['selected'] = 'marks_distribution_type';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        
        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/mh/marksDistributionTypeList', $data);
        $this->load->view('layout/footer', $data);
    }
    
    public function edit_marks_distribution_type($id)
    {
        if (!$this->rbac->hasPrivilege('exam', 'can_edit')) {
            access_denied();
        }

        $data['id']            = $id;
        //$examgroup             = $this->examgroup_model->get($id);
        $examgroup             = get_single_row('exam_marks_distribution_type', array('id' => $id));
        $data['examgroup']     = $examgroup;
        $data['examType']      = $this->exam_type;
        //$examgroup_result      = $this->examgroup_model->get();
        $examgroup_result      = get_list('exam_marks_distribution_type', array('status' => 1), null, null, 0, 'id', 'ASC');
        $data['examgrouplist'] = $examgroup_result;
        $menu_data['selected'] = 'marks_distribution_type';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        
        $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/exampattern/mh/marksDistributionTypeEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $is_active = 1;

            $data = array(
                //'mdtid'    => $this->input->post('id'),
                'name'     => $this->input->post('name'),
                'status'   => $is_active,
                'description' => $this->input->post('description'),
            );
            //$insert_id = $this->examgroup_model->add($data);
            $updated_id = updateData('exam_marks_distribution_type','id', $id, $data);

            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/exampattern/marks_distribution_type');
        }
    }
    
    public function delete_marks_distribution_type($id)
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Delete Batch';
        $updated_id = updateData('exam_marks_distribution_type','id', $id, array('status' => 3));
        //$this->examgroup_model->remove($id);
        redirect('admin/exampattern/marks_distribution_type');
    }
    
    public function marks_distribution_component()
    {
        //  error_reporting(E_ALL);
        // ini_set('display_errors', 1);
        //echo '<pre>';print_r($_POST);exit;
        if (!$this->rbac->hasPrivilege('exam_group', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'exam_pattern');
        $this->session->set_userdata('sub_menu', 'Examinations/exampattern');
        $data['title']      = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType']   = $this->exam_type;
        //$this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('mark_dist_type', "Mark distribution " . $this->lang->line('type'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

        } else {
            $is_active = 0;
            if(isset($_POST['name']) && !empty($_POST['name']))
            {
                foreach($_POST['name'] as $comp_name)
                {
                    $data = array(
                        'name'    => $comp_name,
                        'mdtid'   => $this->input->post('mark_dist_type'),
                        'status'  => 1,
                        'description'  => $this->input->post('description'),
                    );
                    $insert_id = insertData('exam_mark_distribution_component', $data);
                }
            } 
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/exampattern/marks_distribution_component');
        }
        //$examgroup_result      = $this->examgroup_model->get();
        $examgroup_result         = get_list('exam_mark_distribution_component', array('status' => 1), null, null, 0, 'id', 'ASC');
        $marks_dist_types         = get_list('exam_marks_distribution_type', array('status' => 1), null, null, 0, 'id', 'ASC');
        $data['examgrouplist']    = $examgroup_result;
        $data['marks_dist_types'] = $marks_dist_types;
        $menu_data['selected'] = 'marks_distribution_component';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        
        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/mh/marksDistributionComponentList', $data);
        $this->load->view('layout/footer', $data);
    }
    
    public function edit_marks_distribution_component($id)
    {
        if (!$this->rbac->hasPrivilege('exam', 'can_edit')) {
            access_denied();
        }

        $data['id']            = $id;
        //$examgroup             = $this->examgroup_model->get($id);
        $examgroup             = get_single_row('exam_mark_distribution_component', array('id' => $id));
        $data['examgroup']     = $examgroup;
        $data['examType']      = $this->exam_type;
        //$examgroup_result      = $this->examgroup_model->get();
        $examgroup_result         = get_list('exam_mark_distribution_component', array('status' => 1), null, null, 0, 'id', 'ASC');
        $marks_dist_types         = get_list('exam_marks_distribution_type', array('status' => 1), null, null, 0, 'id', 'ASC');
        $data['examgrouplist']    = $examgroup_result;
        $data['marks_dist_types'] = $marks_dist_types;
        $menu_data['selected'] = 'marks_distribution_component';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        

        $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('mark_dist_type', "Mark distribution " . $this->lang->line('type'), 'trim|required|xss_clean');
        
        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/exampattern/mh/marksDistributionComponentEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $is_active = 1;
            $data = array(
                'mdtid'    => $this->input->post('mark_dist_type'),
                'name'     => $this->input->post('name'),
                'status'   => $is_active,
                'description' => $this->input->post('description'),
            );
            //$insert_id = $this->examgroup_model->add($data);
            $updated_id = updateData('exam_mark_distribution_component','id', $id, $data);

            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/exampattern/marks_distribution_component');
        }
    }


    public function marksheet() {
        if (!$this->rbac->hasPrivilege('print_marksheet', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'exam_pattern');
        $this->session->set_userdata('sub_menu', 'Examinations/exampattern');
        $examgroup_result = $this->examgroup_model->getexamgroup_mh();
        $data['examgrouplist'] = $examgroup_result;

        $marksheet_result = $this->marksheet_model->get();
        $data['marksheetlist'] = $marksheet_result;

        $class = $this->class_model->get();
        $data['title'] = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType'] = $this->exam_type;
        $data['classlist'] = $class;
        $session = $this->session_model->get();
        $data['sessionlist'] = $session;
        $this->form_validation->set_rules('marksheet', $this->lang->line('marksheet'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('session_id', $this->lang->line('student'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_group_id', $this->lang->line('exam') . " " . $this->lang->line('group'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_id', $this->lang->line('exam'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {
            
        } else {
            $exam_group_id = $this->input->post('exam_group_id');
            $exam_id = $this->input->post('exam_id');
            $session_id = $this->input->post('session_id');
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $data['section_id'] = $section_id;
            $marksheet_template = $this->input->post('marksheet');
            $data['marksheet_template'] = $marksheet_template;
            $result_exam_ids = $this->getClassExamIdForFinalResult($class_id,$session_id);
            
            // getting and calculating student ranks in exams
            if(valid($result_exam_ids) && !empty($result_exam_ids)){
                $data['studentList'] = $this->examgroupstudent_model->searchMHExamStudents($exam_group_id, $result_exam_ids, $class_id, $section_id, $session_id);
                // getting and calculating student ranks in exams
                //echo '<pre>';print_r($data['studentList']);exit;
                $students_array = array();
                if(valid($data['studentList']) && !empty($data['studentList'])){
                    foreach($data['studentList'] as $stddata):
                        array_push($students_array, $stddata->exam_group_class_batch_exam_student_id);
                    endforeach;
                    $students_class_rank = array();
                    $students_section_rank = array();//exam_group_class_batch_exam_student_id
                    $marksheet = $this->examresult_model->getMHExamResults($exam_id, $exam_group_id, $students_array, $result_exam_ids);
                    if(valid($marksheet) && !empty($marksheet)):
                        foreach ($marksheet['students'] as $student_key => $student_value):
                            if(array_key_exists($student_value['student_id'], $students_class_rank)):
                                continue;
                            endif;
                            $max_mrks = 0;
                            $get_mrks = 0;
                            $std_pert = 0;
                            foreach($result_exam_ids as $exmid):
                                foreach($student_value['exam_result']['exam_result_' . $exmid] as $exmresult):
                                    $max_mrks = $max_mrks + intval(($exmresult->mark_entry_type == 2) ? 0 : $exmresult->max_marks);
                                    $get_mrks = $get_mrks + intval(($exmresult->mark_entry_type == 2) ? 0 : $exmresult->get_marks);
                                endforeach;
                            endforeach;
                            //$std_pert = ($max_mrks > 0) ? ($get_mrks * 100) / $max_mrks : 0;
                            $std_pert = number_format(($max_mrks > 0) ? ($get_mrks * 100) / $max_mrks : 0, 2, '.', '');
                            $students_class_rank[$student_value['student_id']] = array('percentage' => $std_pert, 'student_id' => $student_value['student_id']);
                            if($student_value['section_id'] == $section_id)
                            {
                                $students_section_rank[$student_value['student_id']] = array('percentage' => $std_pert, 'student_id' => $student_value['student_id']);
                            }
                        endforeach;
                    endif;
                    array_multisort(array_column($students_class_rank, 'percentage'), SORT_DESC, $students_class_rank);
                    array_multisort(array_column($students_section_rank, 'percentage'), SORT_DESC, $students_section_rank);
                    $students_class_rank_desc = array();
                    $students_section_rank_desc = array();
                    if(!empty($students_class_rank))
                    {
                        foreach($students_class_rank as $key => $stddata):
                            $students_class_rank_desc[$stddata['student_id']] = $key + 1;
                        endforeach;
                    }
                    if(!empty($students_section_rank))
                    {
                        foreach($students_section_rank as $key => $stddata):
                            $students_section_rank_desc[$stddata['student_id']] = $key + 1;
                        endforeach;
                    }
                    $data['students_class_rank'] = $students_class_rank_desc;
                    $data['students_section_rank'] = $students_section_rank_desc;
                }
                
            } else {
                $data['studentList'] = $this->examgroupstudent_model->searchMHExamStudents($exam_group_id, $exam_id, $class_id, $section_id, $session_id);
            }
            $data['examList'] = $this->examgroup_model->getMHExamByExamGroup($exam_group_id, true);
            
            $data['exam_id'] = $exam_id;
            $data['exam_group_id'] = $exam_group_id;
            $data['exam_class_id'] = $class_id;          
            
        }
        $menu_data['selected'] = 'print_marksheet';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        $data['sch_setting'] = $this->sch_setting_detail;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/mh/marksheet', $data);
        $this->load->view('layout/footer', $data);
    }


    public function printmarksheet() {
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('post_exam_id', $this->lang->line('exam'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_exam_group_id', $this->lang->line('exam') . " " . $this->lang->line('group'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('exam_group_class_batch_exam_student_id[]', $this->lang->line('students'), 'required|trim|xss_clean');
        $data = array();

        if ($this->form_validation->run() == false) {
            $data = array(
                'post_exam_id' => form_error('post_exam_id'),
                'post_exam_group_id' => form_error('post_exam_group_id'),
                'exam_group_class_batch_exam_student_id' => form_error('exam_group_class_batch_exam_student_id'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {
            $data['template'] = $this->marksheet_model->get($this->input->post('marksheet_template'));
            $post_exam_id = $this->input->post('post_exam_id');
            $post_exam_group_id = $this->input->post('post_exam_group_id');
            $post_exam_class_id = $this->input->post('post_exam_class_id');
            $session_id = ($post_exam_class_id == 24000) ? 26 : ''; // this is temporary to get old session exam Ids for specific class(ex:9th class) for printmarksheet
            $result_exam_ids = $this->getClassExamIdForFinalResult($post_exam_class_id,$session_id);
            $students_array = $this->input->post('exam_group_class_batch_exam_student_id');
            $students_class_rank = $this->input->post('students_class_rank');
            $students_section_rank = $this->input->post('students_section_rank');
            $exam = $this->examgroup_model->getMHExamByID($post_exam_id);
            $data['exam'] = $exam;
            $data['exam_ids'] = $result_exam_ids;
            $data['students_class_rank'] = $students_class_rank;
            $data['students_section_rank'] = $students_section_rank;

            $exam_grades = $this->grade_model->getByExamType($exam->exam_group_type);
            $data['exam_grades'] = $exam_grades;
            $data['marksheet'] = $this->examresult_model->getMHExamResults($post_exam_id, $post_exam_group_id, $students_array, $result_exam_ids);
            $data['sch_setting'] = $this->sch_setting_detail;
            $student_exam_page = $this->load->view('admin/examresult/_printmarksheet', $data, true); 
            $array = array('status' => '1', 'error' => '', 'page' => $student_exam_page);
            echo json_encode($array);
        }
    }
    
    public function delete_marks_distribution_component($id)
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Delete Batch';
        $updated_id = updateData('exam_mark_distribution_component','id', $id, array('status' => 3));
        //$this->examgroup_model->remove($id);
        redirect('admin/exampattern/marks_distribution_component');
    }
    
    public function subjectwise_remark()
    {
        //echo '<pre>';print_r($_POST);exit;
        if (!$this->rbac->hasPrivilege('exam_group', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'exam_pattern');
        $this->session->set_userdata('sub_menu', 'Examinations/exampattern');
        $data['title']      = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType']   = $this->exam_type;
        //$this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('subject_id', "Subject " . $this->lang->line('type'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

        } else {
            $is_active = 0;
            if(isset($_POST['name']) && !empty($_POST['name']))
            {
                foreach($_POST['name'] as $comp_name)
                {
                    $data = array(
                        'remark_name'    => $comp_name,
                        'subject_id'   => $this->input->post('subject_id'),
                        'status'  => 1,
                        'note'  => $this->input->post('description'),
                    );
                    $insert_id = insertData('exam_subjectwise_remark', $data);
                }
            } 
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/exampattern/subjectwise_remark');
        }
        //$examgroup_result      = $this->examgroup_model->get();
        $examgroup_result         = get_list('exam_subjectwise_remark', array('status' => 1), null, null, 0, 'id', 'ASC');
        $subjects                 = get_list('subjects', array(), null, null, 0, 'id', 'ASC');
        $data['examgrouplist']    = $examgroup_result;
        $data['subjects']         = $subjects;
        $menu_data['selected'] = 'subjectwise_remark';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        

        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/mh/subjectwiseRemarkList', $data);
        $this->load->view('layout/footer', $data);
    }
    
    public function edit_subjectwise_remark($id)
    {
        if (!$this->rbac->hasPrivilege('exam', 'can_edit')) {
            access_denied();
        }

        $data['id']            = $id;
        //$examgroup             = $this->examgroup_model->get($id);
        $examgroup             = get_single_row('exam_subjectwise_remark', array('id' => $id));
        $data['examgroup']     = $examgroup;
        $data['examType']      = $this->exam_type;
        //$examgroup_result      = $this->examgroup_model->get();
        $examgroup_result      = get_list('exam_subjectwise_remark', array('status' => 1), null, null, 0, 'id', 'ASC');
        $subjects              = get_list('subjects', array(), null, null, 0, 'id', 'ASC');
        $data['examgrouplist']    = $examgroup_result;
        $data['subjects'] = $subjects;
        $menu_data['selected'] = 'subjectwise_remark';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        
        $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('subject_id', "Subject " . $this->lang->line('type'), 'trim|required|xss_clean');
        
        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/exampattern/mh/subjectwiseRemarkEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $is_active = 1;
            $data = array(
                'subject_id'    => $this->input->post('subject_id'),
                'remark_name'     => $this->input->post('name'),
                'status'   => $is_active,
                'note' => $this->input->post('description'),
            );
            //$insert_id = $this->examgroup_model->add($data);
            $updated_id = updateData('exam_subjectwise_remark','id', $id, $data);

            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/exampattern/subjectwise_remark');
        }
    }
    
    public function delete_subjectwise_remark($id)
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Delete Batch';
        $updated_id = updateData('exam_subjectwise_remark','id', $id, array('status' => 3));
        //$this->examgroup_model->remove($id);
        redirect('admin/exampattern/subjectwise_remark');
    }
    
    public function classwise_subject_mark()
    {
        //echo '<pre>';print_r($_POST);exit;
        if (!$this->rbac->hasPrivilege('exam_group', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'exam_pattern');
        $this->session->set_userdata('sub_menu', 'Examinations/exampattern');
        $data['title']      = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType']   = $this->exam_type;
        //$this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('class_id', "Subject " . $this->lang->line('type'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

        } else {
            $is_active = 0;
            if(isset($_POST['subject_id']) && !empty($_POST['subject_id']))
            {
                foreach($_POST['subject_id'] as $key => $sub_name)
                {
                    //@todo check for is exist
                    $data = array(
                        'class_id'   => $this->input->post('class_id'),
                        'subject_id' => $sub_name,
                        'subject_mark_type' => isset($_POST['mark_type'][$key]) ? $_POST['mark_type'][$key] : 0,
                        'max_mark' => isset($_POST['max_mark'][$key]) ? $_POST['max_mark'][$key] : 0,
                        'min_mark' => isset($_POST['min_mark'][$key]) ? $_POST['min_mark'][$key] : 0,
                        'aakarik_mark' => isset($_POST['aakarik_mark'][$key]) ? $_POST['aakarik_mark'][$key] : 0,
                        'sankalit_mark' => isset($_POST['sankalit_mark'][$key]) ? $_POST['sankalit_mark'][$key] : 0,
                        //'description'  => $this->input->post('description'),
                        'description'  => '',
                        'status'  => 1,
                        
                    );
                    $insert_id = insertData('exam_classwise_subjects_mark', $data);
                }
            
                $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
                redirect('admin/exampattern/classwise_subject_mark');
            } else {
                $this->session->set_flashdata('msg', '<div class="alert alert-danger text-left">Invalid input. Please select subjects and enter marks.</div>');
                redirect('admin/exampattern/classwise_subject_mark');
            }
            
        }
        //$examgroup_result      = $this->examgroup_model->get();
        $examgroup_result         = get_list('exam_classwise_subjects_mark', array('status' => 1), null, null, 0, 'id', 'ASC');
        $subjects                 = get_list('subjects', array(), null, null, 0, 'id', 'ASC');
        $data['examgrouplist']    = $examgroup_result;
        $data['subjects']         = $subjects;
        $menu_data['selected'] = 'classwise_subject_mark';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        
        //$subject_list = $this->subject_model->get();
        //$data['subjectlist'] = $subject_list;
        $class = $this->class_model->get();
        $data['classlist'] = $class;
        $subjectgroupList = $this->subjectgroup_model->getByID();
        //echo '<pre>';
        //print_r($subjectgroupList);exit;
        $data['subjectgroupList'] = $subjectgroupList;

        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/mh/classwiseSubjectMarkList', $data);
        $this->load->view('layout/footer', $data);
    }
    
    public function edit_classwise_subject_mark($id)
    {
        if (!$this->rbac->hasPrivilege('exam', 'can_edit')) {
            access_denied();
        }

        $data['id']            = $id;
        //$examgroup             = $this->examgroup_model->get($id);
        $examgroup             = get_single_row('exam_classwise_subjects_mark', array('id' => $id));
        $data['examgroup']     = $examgroup;
        $data['examType']      = $this->exam_type;
        //$examgroup_result      = $this->examgroup_model->get();
        $examgroup_result      = get_list('exam_classwise_subjects_mark', array('status' => 1), null, null, 0, 'id', 'ASC');
        $subjects              = get_list('subjects', array(), null, null, 0, 'id', 'ASC');
        $data['examgrouplist'] = $examgroup_result;
        $data['subjects'] = $subjects;
        $menu_data['selected'] = 'classwise_subject_mark';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        
        
        $class = $this->class_model->get();
        $data['classlist'] = $class;
        $subjectgroupList = $this->subjectgroup_model->getByID();
        $data['subjectgroupList'] = $subjectgroupList;

        //$this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('class_id', "Subject " . $this->lang->line('type'), 'trim|required|xss_clean');
        
        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/exampattern/mh/classwiseSubjectMarkEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            
            $is_active = 0;
            if(isset($_POST['subject_id']) && !empty($_POST['subject_id']))
            {
                foreach($_POST['subject_id'] as $key => $sub_name)
                {
                    //@todo check for is exist
                    $data = array(
                        'class_id'   => $this->input->post('class_id'),
                        'subject_id' => $sub_name,
                        'subject_mark_type' => isset($_POST['mark_type'][$key]) ? $_POST['mark_type'][$key] : 0,
                        'max_mark' => isset($_POST['max_mark'][$key]) ? $_POST['max_mark'][$key] : 0,
                        'min_mark' => isset($_POST['min_mark'][$key]) ? $_POST['min_mark'][$key] : 0,
                        'aakarik_mark' => isset($_POST['aakarik_mark'][$key]) ? $_POST['aakarik_mark'][$key] : 0,
                        'sankalit_mark' => isset($_POST['sankalit_mark'][$key]) ? $_POST['sankalit_mark'][$key] : 0,
                        //'description'  => $this->input->post('description'),
                        'description'  => '',
                        'status'  => 1,
                        
                    );
                    $updated_id = updateData('exam_classwise_subjects_mark','id', $id, $data);
                }
            
                $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
                redirect('admin/exampattern/classwise_subject_mark');
            } else {
                $this->session->set_flashdata('msg', '<div class="alert alert-danger text-left">Invalid input. Please select subject and enter marks.</div>');
                redirect('admin/exampattern/classwise_subject_mark');
            }
            
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/exampattern/classwise_subject_mark');
        }
    }
    
    public function getSubjectByClass()
    {
        $class_id = $this->input->get('class_id');
        //$data     = $this->section_model->getClassBySection($class_id);
        $subjectgroupList = $this->subjectgroup_model->getByID();
        $subjects = array();
        if(valid($subjectgroupList) && !empty($subjectgroupList)){
            foreach($subjectgroupList as $subgrp){
                if(valid($subgrp->sections) && !empty($subgrp->sections)){
                    foreach ($subgrp->sections as $group_section_key => $group_section_value) {
                        if($group_section_value->class_id == $class_id){
                            foreach ($subgrp->group_subject as $group_subject_key => $group_subject_value) {
                                array_push($subjects, array('id' => $group_subject_value->subject_id, 'name' => $group_subject_value->name .' ('. $group_subject_value->type . ')'));
                            }
                            break;
                        }
                    }
                }
            }
        }
        echo json_encode($subjects);
    }
    
    public function delete_classwise_subject_mark($id)
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Delete Batch';
        $updated_id = updateData('exam_classwise_subjects_mark','id', $id, array('status' => 3));
        //$this->examgroup_model->remove($id);
        redirect('admin/exampattern/classwise_subject_mark');
    }
    
    public function class_subject_component()
    {
        //echo '<pre>';print_r($_POST);exit;
        if (!$this->rbac->hasPrivilege('exam_group', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'exam_pattern');
        $this->session->set_userdata('sub_menu', 'Examinations/exampattern');
        $data['title']      = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType']   = $this->exam_type;
        //$this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('class_id', "Subject " . $this->lang->line('type'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

        } else {
            $is_active = 0;
            //echo '<pre>';print_r($_POST);exit;
            if(isset($_POST['mark_dist_comp']) && !empty($_POST['mark_dist_comp']))
            {
                $mark_subject_components = get_list('exam_class_subjects_component', array('class_id' => $this->input->post('class_id'),'subject_id' => $this->input->post('subject_id'),'status' => 1), null, null, 0, 'id', 'ASC');
                if(valid($mark_subject_components) && !empty($mark_subject_components)){
                    $this->session->set_flashdata('msg', '<div class="alert alert-danger text-left">The marks distribution is already added for selected class & subject.</div>');
                    redirect('admin/exampattern/class_subject_component');
                    exit;
                }
                $mark_dist_comp = array();
                foreach($_POST['mark_dist_comp'] as $key => $compid)
                {
                    //@todo check for is exist
                    $mdtid = 0;
                    $mark = 0;
                    if(isset($_POST['aakcompmark_'.$compid])){
                        $mdtid = 1;
                        $mark = trim($_POST['aakcompmark_'.$compid]);
                    } elseif (isset($_POST['sankcompmark_'.$compid])) {
                        $mdtid = 3;
                        $mark = trim($_POST['sankcompmark_'.$compid]);
                    }
                    $markdata = array(
                        'mdtid' => $mdtid,
                        'mdcid' => $compid,
                        'mark' => $mark,
                    );
                    array_push($mark_dist_comp, $markdata);
                }
                $data = array(
                        'class_id'   => $this->input->post('class_id'),
                        'subject_id' => $this->input->post('subject_id'),
                        'remark_language' => isset($_POST['subject_remark_lang']) ? trim($_POST['subject_remark_lang']) : '',
                        'mdcid' => json_encode($mark_dist_comp),
                        //'description'  => '',
                        'status'  => 1,
                        
                    );
                $insert_id = insertData('exam_class_subjects_component', $data);
            
                $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
                redirect('admin/exampattern/class_subject_component');
            } else {
                $this->session->set_flashdata('msg', '<div class="alert alert-danger text-left">Invalid input. Please select subject and enter distribution marks.</div>');
                redirect('admin/exampattern/class_subject_component');
            }
            
        }
        //$examgroup_result      = $this->examgroup_model->get();
        $examgroup_result         = get_list('exam_classwise_subjects_mark', array('status' => 1), null, null, 0, 'id', 'ASC');
        $subjects                 = get_list('subjects', array(), null, null, 0, 'id', 'ASC');
        $data['examgrouplist']    = $examgroup_result;
        $data['subjects']         = $subjects;
        $menu_data['selected'] = 'class_subject_component';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        
        //$subject_list = $this->subject_model->get();
        //$data['subjectlist'] = $subject_list;
        $class = $this->class_model->get();
        $data['classlist'] = $class;
        $subjectgroupList = $this->subjectgroup_model->getByID();
        //echo '<pre>';
        //print_r($subjectgroupList);exit;
        $data['subjectgroupList'] = $subjectgroupList;
        
        $mark_dist_components = get_list('exam_mark_distribution_component', array('status' => 1), null, null, 0, 'id', 'ASC');
        $data['mark_dist_components'] = $mark_dist_components;
        $mark_subject_components = get_list('exam_class_subjects_component', array('status' => 1), null, null, 0, 'id', 'ASC');
        $data['mark_subject_components'] = $mark_subject_components;
//        $marks_dist_types         = get_list('exam_marks_distribution_type', array('status' => 1), null, null, 0, 'id', 'ASC');        
//        $data['marks_dist_types'] = $marks_dist_types;

        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/mh/classSubjectComponentList', $data);
        $this->load->view('layout/footer', $data);
    }
    
    public function getClassSubjectMarks()
    {
        $class_id = $this->input->get('class_id');
        $subject_id = $this->input->get('subject_id');
        //$data     = $this->section_model->getClassBySection($class_id);
        $examgroup             = get_single_row('exam_classwise_subjects_mark', array('class_id' => $class_id, 'subject_id' => $subject_id, 'status' => 1));
        if(!valid($examgroup) || empty($examgroup)){
            $array = array('status' => 'fail', 'message' => 'Subject marks not found, please add Subject Marks.');
            echo json_encode($array);
            exit;
        }
        // check if grade mark type
        if(valid($examgroup->subject_mark_type) && $examgroup->subject_mark_type == 2){
            $array = array('status' => 'fail', 'message' => 'Can not add marks distributions for Grade subjects, please select other subject.');
            echo json_encode($array);
            exit;
        }
        $data = array(
            'id' => $examgroup->id,
            'class_id' => $examgroup->class_id,
            'subject_id' => $examgroup->subject_id,
            'subject_mark_type' => $examgroup->subject_mark_type,
            'max_mark' => $examgroup->max_mark,
            'min_mark' => $examgroup->min_mark,
            'aakarik_mark' => $examgroup->aakarik_mark,
            'sankalit_mark' => $examgroup->sankalit_mark
        );
//        echo '<pre>';print_r($examgroup);exit;
        $array = array('status' => 'success', 'message' => '', 'data' => $data);
        echo json_encode($array);
        exit;
    }
    
    public function edit_class_subject_component($id)
    {
        if (!$this->rbac->hasPrivilege('exam', 'can_edit')) {
            access_denied();
        }

        $data['id']            = $id;
        //$examgroup             = $this->examgroup_model->get($id);
        $examgroup             = get_single_row('exam_class_subjects_component', array('id' => $id));
        
        $data['examgroup']     = $examgroup;
        $data['examType']      = $this->exam_type;
        //$examgroup_result      = $this->examgroup_model->get();
        $examgroup_result      = get_list('exam_classwise_subjects_mark', array('status' => 1), null, null, 0, 'id', 'ASC');
        $subjects              = get_list('subjects', array(), null, null, 0, 'id', 'ASC');
        $data['examgrouplist'] = $examgroup_result;
        $data['subjects'] = $subjects;
        
        $class = $this->class_model->get();
        $data['classlist'] = $class;
        $subjectgroupList = $this->subjectgroup_model->getByID();
        $data['subjectgroupList'] = $subjectgroupList;
        
        $mark_dist_components = get_list('exam_mark_distribution_component', array('status' => 1), null, null, 0, 'id', 'ASC');
        $data['mark_dist_components'] = $mark_dist_components;
        $mark_subject_components = get_list('exam_class_subjects_component', array('status' => 1), null, null, 0, 'id', 'ASC');
        $data['mark_subject_components'] = $mark_subject_components;
        $menu_data['selected'] = 'class_subject_component';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        
        //$this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('class_id', "Subject " . $this->lang->line('type'), 'trim|required|xss_clean');
        
        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/exampattern/mh/classSubjectComponentEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            
            $is_active = 0;
//            echo '<pre>';print_r($_POST);exit;
            if(isset($_POST['mark_dist_comp']) && !empty($_POST['mark_dist_comp']))
            {
                $mark_dist_comp = array();
                foreach($_POST['mark_dist_comp'] as $key => $compid)
                {
                    //@todo check for is exist
                    $mdtid = 0;
                    $mark = 0;
                    if(isset($_POST['aakcompmark_'.$compid])){
                        $mdtid = 1;
                        $mark = trim($_POST['aakcompmark_'.$compid]);
                    } elseif (isset($_POST['sankcompmark_'.$compid])) {
                        $mdtid = 3;
                        $mark = trim($_POST['sankcompmark_'.$compid]);
                    }
                    $markdata = array(
                        'mdtid' => $mdtid,
                        'mdcid' => $compid,
                        'mark' => $mark,
                    );
                    array_push($mark_dist_comp, $markdata);
                }
                $data = array(
                        'class_id'   => $this->input->post('class_id'),
                        'subject_id' => $this->input->post('subject_id'),
                        'remark_language' => isset($_POST['subject_remark_lang']) ? trim($_POST['subject_remark_lang']) : '',
                        'mdcid' => json_encode($mark_dist_comp),
                        //'description'  => '',
                        'status'  => 1,
                        
                    );
                $updated_id = updateData('exam_class_subjects_component','id', $id, $data);
            
                $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
                redirect('admin/exampattern/class_subject_component');
            } else {
                $this->session->set_flashdata('msg', '<div class="alert alert-danger text-left">Invalid input. Please select subject and enter distribution marks.</div>');
                redirect('admin/exampattern/class_subject_component');
            }
            
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/exampattern/class_subject_component');
        }
    }
    
    public function delete_class_subject_component($id)
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Delete Batch';
        $updated_id = updateData('exam_class_subjects_component','id', $id, array('status' => 3));
        //$this->examgroup_model->remove($id);
        redirect('admin/exampattern/class_subject_component');
    }
    
    public function scorecard_component()
    {
        //echo '<pre>';print_r($_POST);
        //print_r($_POST['name']);exit;
        if (!$this->rbac->hasPrivilege('exam_group', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'exam_pattern');
        $this->session->set_userdata('sub_menu', 'Examinations/exampattern');
        $data['title']      = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType']   = $this->exam_type;
        $this->form_validation->set_rules('name[]', $this->lang->line('name'), 'trim|required|xss_clean');
        //$this->form_validation->set_rules('mark_dist_type', "Mark distribution " . $this->lang->line('type'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

        } else {
           // echo '<pre>';            print_r($_POST);exit;
            $is_active = 0;
            if(isset($_POST['name']) && !empty($_POST['name']))
            {
                $selgrades = array();
                $selcls = array();
                if(isset($_POST['grades']) && !empty($_POST['grades']))
                {
                    foreach($_POST['grades'] as $grd)
                    {
                        array_push($selgrades,$grd);
                    }
                }
                if(isset($_POST['class']) && !empty($_POST['class']))
                {
                    foreach($_POST['class'] as $cls)
                    {
                        array_push($selcls,$cls);
                    }
                }
                foreach($_POST['name'] as $comp_name)
                {
                    $data = array(
                        'component_name'    => $comp_name,
                        'subject_mark_grade'    => !empty($selgrades) ? json_encode($selgrades) : '',
                        'classes'    => !empty($selcls) ? json_encode($selcls) : '',
                        'status'  => 1,
//                        'description'  => $this->input->post('description'),
                    );
                    $insert_id = insertData('exam_scorecard_component', $data);
                }
            } 
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/exampattern/scorecard_component');
        }
        //$examgroup_result      = $this->examgroup_model->get();
        $examgroup_result         = get_list('exam_scorecard_component', array('status' => 1), null, null, 0, 'id', 'ASC');
        $marks_grades             = get_list('grades', array('is_active' => 'yes', 'exam_type' => 'school_grade_system'), null, null, 0, 'id', 'ASC');
        $data['examgrouplist']    = $examgroup_result;
        
        $class = $this->class_model->get();
        $data['classlist'] = $class;
        $data['grades'] = $marks_grades;
        $menu_data['selected'] = 'scorecard_component';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        
        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/mh/scorecardComponentList', $data);
        $this->load->view('layout/footer', $data);
    }
    
    public function edit_scorecard_component($id)
    {
        if (!$this->rbac->hasPrivilege('exam', 'can_edit')) {
            access_denied();
        }

        $data['id']            = $id;
        //$examgroup             = $this->examgroup_model->get($id);
        $examgroup             = get_single_row('exam_scorecard_component', array('id' => $id));
        $data['examgroup']     = $examgroup;
        $data['examType']      = $this->exam_type;
        //$examgroup_result      = $this->examgroup_model->get();
        $examgroup_result         = get_list('exam_scorecard_component', array('status' => 1), null, null, 0, 'id', 'ASC');
        $marks_grades             = get_list('grades', array('is_active' => 'yes', 'exam_type' => 'school_grade_system'), null, null, 0, 'id', 'ASC');
        $data['examgrouplist']    = $examgroup_result;
        
        $class = $this->class_model->get();
        $data['classlist'] = $class;
        $data['grades'] = $marks_grades;
        
        $menu_data['selected'] = 'scorecard_component';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        
        $this->form_validation->set_rules('name[]', $this->lang->line('name'), 'trim|required|xss_clean');
        //$this->form_validation->set_rules('mark_dist_type', "Mark distribution " . $this->lang->line('type'), 'trim|required|xss_clean');
        
        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/exampattern/mh/scorecardComponentEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $is_active = 1;
            if(isset($_POST['name']) && !empty($_POST['name']))
            {
                $selgrades = array();
                $selcls = array();
                if(isset($_POST['grades']) && !empty($_POST['grades']))
                {
                    foreach($_POST['grades'] as $grd)
                    {
                        array_push($selgrades,$grd);
                    }
                }
                if(isset($_POST['class']) && !empty($_POST['class']))
                {
                    foreach($_POST['class'] as $cls)
                    {
                        array_push($selcls,$cls);
                    }
                }
                foreach($_POST['name'] as $comp_name)
                {
                    $data = array(
                        'component_name'    => $comp_name,
                        'subject_mark_grade'    => !empty($selgrades) ? json_encode($selgrades) : '',
                        'classes'    => !empty($selcls) ? json_encode($selcls) : '',
                        'status'  => 1,
//                        'description'  => $this->input->post('description'),
                    );
                    $updated_id = updateData('exam_scorecard_component','id', $id, $data);
                }
            }
            
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/exampattern/scorecard_component');
        }
    }

    public function getClassExamIdForFinalResult($class_id = 0, $session_id = '')
    {
        // Get class exam Ids by academic session 
        // if(valid($session_id) && !empty($session_id)){
            // $class_exam_ids_by_session = array(
            //     '26' => array(
            //             '24' => array(17,19), // class ID 9th class(ID:24) and Exam IDs term 1&2 for session 23-24(ID:26)
            //         ),
            //     '27' => array(
            //             '34' => array(11),//array(11,21,14,22),// class ID JR. KG and Exam IDs unit test 1&2, term 1&2 for for session 24-25(ID:27)
            //             '35' => array(11),// class ID SR.KG and Exam IDs unit test 1&2, term 1&2
            //             '36' => array(82),// class ID 1st class and Exam IDs unit test 1&2, term 1&2
            //             '37' => array(82),// class ID 2st class and Exam IDs unit test 1&2, term 1&2
                        
            //             '38' => array(61),// class ID 3rd class and Exam IDs unit test 1&2, term 1&2
            //             '39' => array(61),// class ID 4th class and Exam IDs unit test 1&2, term 1&2 
            //             '40' => array(63),// class ID 5th class and Exam IDs unit test 1&2, term 1&2
            //             '41' => array(64),// class ID 6th class and Exam IDs unit test 1&2, term 1&2
            //             '43' => array(64),// class ID 7th class and Exam IDs unit test 1&2, term 1&2
            //             '23' => array(65),// class ID 8th class and Exam IDs unit test 1&2, term 1&2
                        
            //             '24' => array(69),// class ID 9th class and Exam IDs term 1&2
            //             '25' => array(70),// class ID 10th class and Exam IDs Vacation exam
                        
            //         ),  
            //     );
        //     $class_exam_ids_by_session = array();
        //     if(isset($class_exam_ids_by_session[$session_id][$class_id]))
        //     {
        //         return $class_exam_ids_by_session[$session_id][$class_id];
        //     }
        //     return array();
        // }   
        // $class_exam_ids = array(
        //     '34' => array(11),//array(11,21,14,22),// class ID JR. KG and Exam IDs unit test 1&2, term 1&2 
        //     '35' => array(11),// class ID SR.KG and Exam IDs unit test 1&2, term 1&2
        //     '36' => array(82),// class ID 1st class and Exam IDs unit test 1&2, term 1&2
        //     '37' => array(82),// class ID 2st class and Exam IDs unit test 1&2, term 1&2
            
        //     '38' => array(61),// class ID 3rd class and Exam IDs unit test 1&2, term 1&2
        //     '39' => array(61),// class ID 4th class and Exam IDs unit test 1&2, term 1&2 
        //     '40' => array(63),// class ID 5th class and Exam IDs unit test 1&2, term 1&2
        //     '41' => array(64),// class ID 6th class and Exam IDs unit test 1&2, term 1&2
        //     '43' => array(64),// class ID 7th class and Exam IDs unit test 1&2, term 1&2
        //     '23' => array(65),// class ID 8th class and Exam IDs unit test 1&2, term 1&2
            
        //     '24' => array(69),// class ID 9th class and Exam IDs term 1&2
        //     '25' => array(70),// class ID 10th class and Exam IDs Vacation exam
            
        // );
        // if(isset($class_exam_ids[$class_id]))
        // {
        //     return $class_exam_ids[$class_id];
        // }
        return array();
        
    }
    
    public function delete_scorecard_component($id)
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Delete Batch';
        $updated_id = updateData('exam_scorecard_component','id', $id, array('status' => 3));
        //$this->examgroup_model->remove($id);
        redirect('admin/exampattern/scorecard_component');
    }
    
    
}
