<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Exam_cbse_pattern extends Admin_Controller
{

    public $exam_type            = array();
    private $sch_current_session = "";

    public function __construct()
    {
        parent::__construct();
        $this->load->library('encoding_lib');
        $this->load->library('mailsmsconf');
        $this->exam_type           = $this->config->item('exam_type');
        $this->sch_current_session = $this->setting_model->getCurrentSession();
        $this->attendence_exam     = $this->config->item('attendence_exam');
        $this->config_attendance = $this->config->item('attendence');
        $this->sch_setting_detail  = $this->setting_model->getSetting();
        $this->load->model('Class_model');
        $this->load->model('Classteacher_model');
        
        $this->load->model('cbse_examgroup_model');
        $this->load->model('cbse_examstudent_model');
        $this->load->model('cbse_batchsubject_model');
        $this->load->model('cbse_examsubject_model');
        $this->load->model('cbse_examresult_model');
        $this->load->model('cbse_examgroupstudent_model');
        $this->load->model('subject_model');
        $this->load->model('section_model');
        $this->load->model('session_model');
        
        
        
    }

    public function exportformat($class_id, $section_id)
    {
        // Fetch students of this class & section
        $students = $this->student_model->searchByClassSection($class_id, $section_id);
    
        // File name
        $filename = "import_marks_sample_file.csv";
    
        // Force download headers
        header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        header('Pragma: no-cache');
        header('Expires: 0');
    
        // Open output stream AFTER headers
        $fp = fopen('php://output', 'w');
    
        // Set CSV headers
        $header = ['adm_no','student_name','status','marks','note'];
        fputcsv($fp, $header);
    
        // Fill student rows
        foreach ($students as $stu) {
            $row = [
                $stu['admission_no'],
                $stu['firstname'] . ' ' . $stu['lastname'],
                0,
                '',
                '' // keep blank for marks entry
            ];
            fputcsv($fp, $row);
        }
    
        fclose($fp);
        exit;
    }


    public function uploadfile()
    {
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('file', $this->lang->line('image'), 'callback_handle_upload');

        if ($this->form_validation->run() == false) {
            $data = array(
                'file' => form_error('file'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {
            $return_array = array();

            if (isset($_FILES["file"]) && !empty($_FILES['file']['name'])) {

                $fileName = $_FILES["file"]["tmp_name"];
                if ($_FILES["file"]["size"] > 0) {
                    $file = fopen($fileName, "r");

                    // ✅ First row = headers
                    $headers = fgetcsv($file, 10000, ",");
                    $headers = array_map('trim', $headers); // remove spaces
                    $headerIndex = array_flip($headers);   // map header name to column index

                    // Loop rows
                    while (($row = fgetcsv($file, 10000, ",")) !== false) {
                        if (empty($row)) continue;

                        // Access by column name
                        $adm_no     = isset($headerIndex['adm_no']) ? ($row[$headerIndex['adm_no']]) : '';
                        $attendence = isset($headerIndex['status']) ? trim($row[$headerIndex['status']]) : '';
                        $marks      = isset($headerIndex['marks']) ? trim($row[$headerIndex['marks']]) : '';
                        $note       = isset($headerIndex['note']) ? $this->encoding_lib->toUTF8($row[$headerIndex['note']]) : '';

                        if ($adm_no != "" && $attendence != "" && $marks != "") {
                            $return_array[] = json_encode( array(
                                'adm_no'     => $adm_no,
                                'attendence' => $attendence,
                                'marks'      => number_format((float)$marks, 2, '.', ''),
                                'note'       => $note,
                            )
                        );
                        }
                    }
                    fclose($file);
                }

               

                $array = array('status' => '1', 'error' => '', 'student_marks' => $return_array);
                echo json_encode($array);
            }
        }
    }

    public function handle_upload()
    {

        $image_validate = $this->config->item('csv_validate');

        if (isset($_FILES["file"]) && !empty($_FILES['file']['name']) && $_FILES["file"]["size"] > 0) {

            $file_type         = $_FILES["file"]['type'];
            $file_size         = $_FILES["file"]["size"];
            $file_name         = $_FILES["file"]["name"];
            $allowed_extension = $image_validate['allowed_extension'];
            $ext               = pathinfo($file_name, PATHINFO_EXTENSION);
            $allowed_mime_type = $image_validate['allowed_mime_type'];
            $finfo             = finfo_open(FILEINFO_MIME_TYPE);
            $mtype             = finfo_file($finfo, $_FILES['file']['tmp_name']);
            finfo_close($finfo);

            if (!in_array($mtype, $allowed_mime_type)) {
                $this->form_validation->set_message('handle_upload', 'File Type Not Allowed');
                return false;
            }

            if (!in_array($ext, $allowed_extension) || !in_array($file_type, $allowed_mime_type)) {
                $this->form_validation->set_message('handle_upload', 'Extension Not Allowed');
                return false;
            }
            if ($file_size > $image_validate['upload_size']) {
                $this->form_validation->set_message('handle_upload', $this->lang->line('file_size_shoud_be_less_than') . number_format($image_validate['upload_size'] / 1048576, 2) . " MB");
                return false;
            }

            return true;
        } else {
            $this->form_validation->set_message('handle_upload', 'Please choose a file to upload.');
            return false;
        }
    }

    public function index()
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'exam_pattern');
        $this->session->set_userdata('sub_menu', 'Examinations/exam_cbse_pattern');
        $data['title']      = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType']   = $this->exam_type;
        $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_type', $this->lang->line('exam') . " " . $this->lang->line('type'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

        } else {
            $is_active = 0;

            $data = array(
                'name'        => $this->input->post('name'),
                'exam_type'   => $this->input->post('exam_type'),
                'is_active'   => $is_active,
                'description' => $this->input->post('description'),
            );

            $insert_id = insertData('cbse_exam_groups', $data); 

            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/exam_cbse_pattern/index');
        }
        $menu_data['selected'] = 'cbse_exam_terms';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/cbse/topMenuOptions', $menu_data, true);
        $examgroup_result      = $this->cbse_examgroup_model->get();
        $data['examgrouplist'] = $examgroup_result;

        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/cbse/examgroup', $data);
        $this->load->view('layout/footer', $data);
    }

    public function getExamByExamgroup()
    {
        $exam_group_id = $this->input->post('exam_group_id');
        $is_termexam = $this->input->post('is_termexam');
        
        $data          = $this->cbse_examgroup_model->getExamByExamGroup($exam_group_id, $is_termexam);
        // print_r($this->db->last_query()); die();
        echo json_encode($data);
    }

    public function deleteExam()
    {

        $data['title'] = 'deleteExam';
        $id            = $this->input->post('id');
        if (!$this->cbse_examgroup_model->delete_exam($id)) {
            echo json_encode(array('status' => 0, 'message' => $this->lang->line('something_wrong')));
        } else {
            echo json_encode(array('status' => 1, 'message' => $this->lang->line('record_deleted_successfully')));
        }
    }

    public function exam($id)
    {
        $data                    = array();
        $data['examgroupDetail'] = $this->cbse_examgroup_model->getExamByID($id);
        $data['exam_subjects']   = $this->cbse_batchsubject_model->getExamSubjects($id);
        $class                   = $this->class_model->get();
        $data['classlist']       = $class;
        $session                 = $this->session_model->get();
        $data['sessionlist']     = $session;
        $data['current_session'] = $this->sch_current_session;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/examgroup/exam', $data);
        $this->load->view('layout/footer', $data);
    }

    public function examresult($id)
    {
        $data = array();

        $data['id']        = $id;
        $class             = $this->class_model->get();
        $data['classlist'] = $class;
        if ($this->input->server('REQUEST_METHOD') == 'POST') {
            $exam_subject_id                                = $this->input->post('exam_group_class_batch_exam_subject_id');
            $class_id                                       = $this->input->post('class_id');
            $batch_id                                       = $this->input->post('batch_id');
            $data['class_id']                               = $this->input->post('class_id');
            $data['batch_id']                               = $this->input->post('batch_id');
            $data['exam_group_class_batch_exam_subject_id'] = $this->input->post('exam_group_class_batch_exam_subject_id');

            $data['exam_subjects'] = $this->cbse_batchsubject_model->getExamSubjects($id);
            $resultlist            = $this->cbse_batchsubject_model->examGroupExamResult($class_id, $batch_id, $id);

            $data['resultlist'] = $resultlist;
        }

        $this->load->view('layout/header', $data);
        $this->load->view('admin/examgroup/examresult', $data);
        $this->load->view('layout/footer', $data);
    }

    public function addmark($id)
    {
        $data = array();

        $data['exam_subjects'] = $this->cbse_batchsubject_model->getExamSubjects($id);
        $data['id']            = $id;
        $class                 = $this->class_model->get();
        $data['classlist']     = $class;
        $session               = $this->session_model->get();
        $data['sessionlist']   = $session;
        if ($this->input->server('REQUEST_METHOD') == 'POST') {

            $exam_subject_id                                = $this->input->post('exam_group_class_batch_exam_subject_id');
            $data['exam_group_class_batch_exam_subject_id'] = $this->input->post('exam_group_class_batch_exam_subject_id');
            $class_id                                       = $this->input->post('class_id');
            $section_id                                     = $this->input->post('section_id');
            $session_id                                     = $this->input->post('session_id');
            $data['class_id']                               = $this->input->post('class_id');
            $data['section_id']                             = $this->input->post('section_id');
            $data['session_id']                             = $this->input->post('session_id');
            $resultlist                                     = $this->cbse_examgroupstudent_model->examGroupSubjectResult($exam_subject_id, $class_id, $section_id, $session_id);
            $subject_detail                                 = $this->cbse_batchsubject_model->getExamSubject($exam_subject_id);
            $data['subject_detail']                         = $subject_detail;
            $data['attendence_exam']                        = $this->attendence_exam;
            $data['resultlist']                             = $resultlist;
        }

        $this->load->view('layout/header', $data);
        $this->load->view('admin/examgroup/addmark', $data);
        $this->load->view('layout/footer', $data);
    }

    public function delete($id)
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Delete Batch';
        $this->cbse_examgroup_model->remove($id);
        redirect('admin/exam_cbse_pattern');
    }

    public function edit($id)
    {
        if (!$this->rbac->hasPrivilege('exam', 'can_edit')) {
            access_denied();
        }

        $data['id']            = $id;
        $examgroup             = $this->cbse_examgroup_model->get($id);
        $data['examgroup']     = $examgroup;
        $data['examType']      = $this->exam_type;
        $examgroup_result      = $this->cbse_examgroup_model->get();
        $data['examgrouplist'] = $examgroup_result;

        $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/exampattern/cbse/examgroupEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $is_active = 0;

            $data = array(
                'id'          => $this->input->post('id'),
                'name'        => $this->input->post('name'),
                'exam_type'   => $this->input->post('exam_type'),
                'is_active'   => $is_active,
                'description' => $this->input->post('description'),
            );
            $insert_id = $this->cbse_examgroup_model->add($data);

            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/exam_cbse_pattern/index');
        }
    }

    public function getByClassSection()
    {
        $section_id = $this->input->post('section_id');
        $data       = $this->cbse_examgroup_model->getStudentBatch($section_id);
        echo json_encode($data);
    }

    public function addexam($id)
    {

        if (!$this->rbac->hasPrivilege('exam', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Examinations');
        $this->session->set_userdata('sub_menu', 'Examinations/exam_cbse_pattern');
        $data['title']      = 'Add Batch';
        $data['title_list'] = 'Recent Batch';

        $class               = $this->class_model->get();
        $data['classlist']   = $class;
        $data['examType']    = $this->exam_type;
        $session             = $this->session_model->get();
        $data['sessionlist'] = $session;
        $subjectlist         = $this->subject_model->get();
        $data['subjectlist'] = $subjectlist;

        $data['current_session'] = $this->sch_current_session;
        $data['examgroup']       = $this->cbse_examgroup_model->get($id);

        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/cbse/addexam', $data);
        $this->load->view('layout/footer', $data);
    }

    public function getNotAppliedDiscount($student_session_id)
    {
        return $this->feediscount_model->getDiscountNotApplied($student_session_id);
    }

    // public function subjectstudent()
    // {
    //     $this->form_validation->set_error_delimiters('<p>', '</p>');
    //     $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'required|trim|xss_clean');
    //     $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'required|trim|xss_clean');
    //     $this->form_validation->set_rules('subject_id', $this->lang->line('subject'), 'required|trim|xss_clean');
    //     $this->form_validation->set_rules('session_id', $this->lang->line('session'), 'required|trim|xss_clean');
    //     $userdata = $this->customlib->getUserData();
    //     $role_id  = $userdata["role_id"];
    //     $can_edit = 1;
    //     if (isset($role_id) && ($userdata["role_id"] == 2) && ($userdata["class_teacher"] == "yes")) {
    //         $myclasssubjects = $this->subjecttimetable_model->canAddExamMarks($userdata["id"], $this->input->post('class_id'), $this->input->post('section_id'), $this->input->post('teachersubject_id'));
    //         $can_edit        = $myclasssubjects;
    //     }

    //     if ($this->form_validation->run() == false) {
    //         $data = array(
    //             'class_id'   => form_error('class_id'),
    //             'section_id' => form_error('section_id'),
    //             'session_id' => form_error('session_id'),
    //             'subject_id' => form_error('subject_id'),
    //         );
    //         $array = array('status' => 0, 'error' => $data);
    //         echo json_encode($array);
    //     } elseif ($can_edit == 0) {
    //         $msg   = array('lesson' => $this->lang->line('not_authoried'));
    //         $array = array('status' => 0, 'error' => $msg);
    //         echo json_encode($array);
    //     } else {
    //         $exam_subject_id                                = $this->input->post('subject_id');
    //         $data['exam_group_class_batch_exam_subject_id'] = $exam_subject_id;
    //         $class_id                                       = $this->input->post('class_id');
    //         $section_id                                     = $this->input->post('section_id');
    //         $session_id                                     = $this->input->post('session_id');
    //         $data['class_id']                               = $this->input->post('class_id');
    //         $data['section_id']                             = $this->input->post('section_id');
    //         $data['session_id']                             = $this->input->post('session_id');
    //         $resultlist                                     = $this->cbse_examgroupstudent_model->examGroupSubjectResult($exam_subject_id, $class_id, $section_id, $session_id);
    //         $subject_detail = $this->cbse_batchsubject_model->getExamSubject($exam_subject_id);

    //         $data['subject_detail']  = $subject_detail;
    //         $data['attendence_exam'] = $this->attendence_exam;
    //         $data['resultlist']      = $resultlist;
    //         $data['sch_setting']     = $this->sch_setting_detail;
    //         $student_exam_page       = $this->load->view('admin/exampattern/cbse/_partialstudentmarkEntry', $data, true);

    //         $array = array('status' => '1', 'error' => '', 'page' => $student_exam_page);
    //         echo json_encode($array);
    //     }
    // }

    public function subjectstudent()
    {
        $this->form_validation->set_error_delimiters('<p>', '</p>');
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('subject_id', $this->lang->line('subject'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('session_id', $this->lang->line('session'), 'required|trim|xss_clean');
        $userdata = $this->customlib->getUserData();
        $role_id  = $userdata["role_id"];
        $can_edit = 1;
        if (isset($role_id) && ($userdata["role_id"] == 2) && ($userdata["class_teacher"] == "yes")) {
            $myclasssubjects = $this->subjecttimetable_model->canAddExamMarks($userdata["id"], $this->input->post('class_id'), $this->input->post('section_id'), $this->input->post('teachersubject_id'));
            $can_edit        = $myclasssubjects;
        }

        if ($this->form_validation->run() == false) {
            $data = array(
                'class_id'   => form_error('class_id'),
                'section_id' => form_error('section_id'),
                'session_id' => form_error('session_id'),
                'subject_id' => form_error('subject_id'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } elseif ($can_edit == 0) {
            $msg   = array('lesson' => $this->lang->line('not_authoried'));
            $array = array('status' => 0, 'error' => $msg);
            echo json_encode($array);
        } else {
            $exam_subject_id                                = $this->input->post('subject_id');
            $data['exam_group_class_batch_exam_subject_id'] = $exam_subject_id;
            $teachersubject_id                              = $this->input->post('teachersubject_id');
            $class_id                                       = $this->input->post('class_id');
            $section_id                                     = $this->input->post('section_id');
            $session_id                                     = $this->input->post('session_id');
            $data['class_id']                               = $this->input->post('class_id');
            $data['section_id']                             = $this->input->post('section_id');
            $data['session_id']                             = $this->input->post('session_id');
            $data['sch_setting']     = $this->sch_setting_detail;
            $subjectwise_remark         = get_list('exam_subjectwise_remark', array('status' => 1,'subject_id' => $teachersubject_id), null, null, 0, 'id', 'ASC');
            $data['subjectwise_remark'] = $subjectwise_remark;
            $resultlist                                     = $this->cbse_examgroupstudent_model->examGroupSubjectResult($exam_subject_id, $class_id, $section_id, $session_id);
            $subject_detail = $this->cbse_batchsubject_model->getExamSubject($exam_subject_id);
            $exam_group_class_batch_exams_id = $subject_detail->exam_group_class_batch_exams_id;
            $exam_group_class_batch_exams = $this->cbse_examgroup_model->getExamByID($exam_group_class_batch_exams_id);
            // $last_exam_id = $this->cbse_examgroupstudent_model->getLastExamId($exam_group_class_batch_exams->exam_group_id);

            $previous_exam_results = [];
            if ($exam_group_class_batch_exams->is_termexam == "yes") {
                if($data['sch_setting']->multiple_unit_test_in_cbse_term_exam == 1){
                $previous_exam_results = $this->cbse_examgroupstudent_model->getavgPreviousExamMarks($exam_subject_id, $class_id, $section_id, $session_id);
                
                }else{
                $previous_exam_results = $this->cbse_examgroupstudent_model->getPreviousExamMarks($exam_subject_id, $class_id, $section_id, $session_id);
                }
                $is_term1 = $exam_group_class_batch_exams->is_term1; // Extract month as a number (1-12)

                if ($is_term1 == 'yes') { 
                    $from_date = 4;
                    $to_date   = 9;
                } else {
                    $from_date = 10;
                    $to_date   = 3;
                    
                }


                $assessment_data = $this->cbse_examgroupstudent_model->getAssessments($subject_detail->subject_id, $class_id, $section_id, $session_id,$from_date,$to_date);

                $data['assessment_data'] = $assessment_data;
                


                

                // Process data
                $assessment_types = []; // Initialize as an empty array

                foreach ($assessment_data as $row) {
                    // Store assessment types dynamically in an indexed array
                    if (!isset($assessment_types[$row['assessment_type_id']])) {
                        $assessment_types[$row['assessment_type_id']] = [
                            'type' => $row['assessment_type'],
                            'assessment_type_id' => $row['assessment_type_id'],
                            'term_exam_out_of_marks' => $row['term_exam_out_of_marks']
                        ];
                    }
                }

                $data['assessment_types'] = $assessment_types;
                $data['is_termexam'] = $exam_group_class_batch_exams->is_termexam;
               
                // print_r($assessment_data); die();

                
            }
            

            $data['previous_exam_results'] = $previous_exam_results;
            $data['subject_detail']  = $subject_detail;
            $data['attendence_exam'] = $this->attendence_exam;
            $data['resultlist']      = $resultlist;
            
            


            
            $student_exam_page       = $this->load->view('admin/exampattern/cbse/_partialstudentExammarkEntry', $data, true);

            $array = array('status' => '1', 'error' => '', 'page' => $student_exam_page);
            echo json_encode($array);
        }
    }

    public function examstudent()
    {
        $this->form_validation->set_error_delimiters('<li>', '</li>');
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'required|trim|xss_clean');

        $data['adm_auto_insert'] = $this->sch_setting_detail->adm_auto_insert;
        $data['sch_setting']     = $this->sch_setting_detail;
        if ($this->form_validation->run() == false) {
            $msg = array(
                'class_id'   => form_error('class_id'),
                'section_id' => form_error('section_id'),
                // 'exam_id'    => form_error('exam_id'),
            );
            $array = array('status' => 0, 'error' => $msg);
            echo json_encode($array);
        } else {

            $class_id   = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');

            $data['class_id']   = $this->input->post('class_id');
            $data['section_id'] = $this->input->post('section_id');
            $data['exam_id']    = $this->input->post('exam_id');
            $resultlist         = $this->cbse_examstudent_model->searchExamStudents($data['class_id'], $data['section_id'], $data['exam_id']);

            $data['resultlist'] = $resultlist;
            $student_exam_page  = $this->load->view('admin/exampattern/cbse/_partialexamstudent', $data, true);
            $array              = array('status' => '1', 'error' => '', 'page' => $student_exam_page);
            echo json_encode($array);
        }
    }

    public function ajaxaddexam()
    {
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('exam', $this->lang->line('exam'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('session_id', $this->lang->line('session'), 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'exam'       => form_error('exam'),
                'session_id' => form_error('session_id'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {

            $exam_id    = $this->input->post('exam_id');
            $is_active  = $this->input->post('is_active');
            $is_termexam  = $this->input->post('is_termexam');
            $is_publish = $this->input->post('is_publish');

            if (isset($is_active)) {
                $is_active = 1;
            } else {
                $is_active = 0;
            }

            if (isset($is_publish)) {
                $is_publish = 1;
            } else {
                $is_publish = 0;
            }
            if (isset($is_termexam)) {
                $is_termexam = "yes";
            } else {
                $is_termexam = "no";
            }

            $postarray = array(
                'exam'          => $this->input->post('exam'),
                'exam_group_id' => $this->input->post('exam_group_id'),
                'session_id'    => $this->input->post('session_id'),
                'is_active'     => $is_active,
                'is_publish'    => $is_publish,
                'is_termexam'   => $is_termexam,
                'is_term1'      => $this->input->post('is_term1'),
                'description'   => $this->input->post('description'),
                'use_exam_roll_no'   => $this->input->post('use_exam_roll_no')
            );

            if ($exam_id != 0) {
                $postarray['id'] = $exam_id;
            }



            $inserted_id = $this->cbse_examgroup_model->add_exam($postarray);
            $exam_data   = $this->cbse_examgroup_model->getExamByID($exam_id);
            if ($is_publish) {
                $exam_students = $this->cbse_examgroupstudent_model->searchExamStudentsByExam($exam_id);
                // $student_exams = array('exam' => $exam_data, 'exam_result' => $exam_students);
                // $s             = $this->mailsmsconf->mailsms('exam_result', $student_exams);
            }

            if ($exam_id != 0) {
                $array = array('status' => '1', 'error' => '', 'message' => $this->lang->line('update_message'));
            } else {
                $array = array('status' => '1', 'error' => '', 'message' => $this->lang->line('success_message'));
            }

            echo json_encode($array);
        }
    }
    
    public function ajaxcopyexam()
    {
        // error_reporting(E_ALL);
        // ini_set('display_errors', 1);
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('exam', $this->lang->line('exam'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('session_id', $this->lang->line('session'), 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'exam'       => form_error('exam'),
                'session_id' => form_error('session_id'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {

            $exam_id    = $this->input->post('exam_id');
            $copyexam_id    = $this->input->post('copyexam_id');
            $is_active  = $this->input->post('is_active');
            $is_termexam  = $this->input->post('is_termexam');
            $is_publish = $this->input->post('is_publish');

            if (isset($is_active)) {
                $is_active = 1;
            } else {
                $is_active = 0;
            }

            if (isset($is_publish)) {
                $is_publish = 1;
            } else {
                $is_publish = 0;
            }
            if (isset($is_termexam)) {
                $is_termexam = "yes";
            } else {
                $is_termexam = "no";
            }

            $postarray = array(
                'exam'          => $this->input->post('exam'),
                'exam_group_id' => $this->input->post('exam_group_id'),
                'session_id'    => $this->input->post('session_id'),
                'is_active'     => $is_active,
                'is_publish'    => $is_publish,
                'is_termexam'   => $is_termexam,
                'is_term1'      => $this->input->post('is_term1'),
                'description'   => $this->input->post('description'),
                'use_exam_roll_no'   => $this->input->post('use_exam_roll_no')
            );

            if ($exam_id != 0) {
                $postarray['id'] = $exam_id;
            }

            $old_exam_students = $this->cbse_examstudent_model->getstudentsByExam($copyexam_id);
            // print_r($old_exam_students); die;

            $old_exam_subjects = $this->cbse_examsubject_model->get_exam_subjects_byexam($copyexam_id);
            



            $inserted_id = $this->cbse_examgroup_model->add_exam($postarray);

            $insert_student_array = array();
            $insert_subject_array = array();

            foreach ($old_exam_students as $key => $value) {
                $insert_student_array[] = array(
                    'exam_group_class_batch_exam_id' => $inserted_id,
                    'student_id' => $value->student_id,
                    'student_session_id' => $value->student_session_id,
                );
            }

            foreach ($old_exam_subjects as $key => $value) {
                $insert_subject_array[] = array(
                            'exam_group_class_batch_exams_id' => $inserted_id,
                            'subject_id'                      => $value->subject_id,
                            'credit_hours'                    => $value->credit_hours,
                            'date_from'                       => $value->date_from,
                            'time_from'                       => $value->time_from,
                            'duration'                        => $value->duration,
                            'room_no'                         => $value->room_no,
                            'max_marks'                       => $value->max_marks,
                            'min_marks'                       => $value->min_marks,
                        );
            }

            // ✅ Insert into exam student table
            if (!empty($insert_student_array)) {
                $this->db->insert_batch('cbse_exam_group_class_batch_exam_students', $insert_student_array);
            }

            // ✅ Insert into exam subject table
            if (!empty($insert_subject_array)) {
                $this->db->insert_batch('cbse_exam_group_class_batch_exam_subjects', $insert_subject_array);
            }

            $exam_data   = $this->cbse_examgroup_model->getExamByID($exam_id);
            if ($is_publish) {
                $exam_students = $this->cbse_examgroupstudent_model->searchExamStudentsByExam($exam_id);
                // $student_exams = array('exam' => $exam_data, 'exam_result' => $exam_students);
                // $s             = $this->mailsmsconf->mailsms('exam_result', $student_exams);
            }

            

            if ($exam_id != 0) {
                $array = array('status' => '1', 'error' => '', 'message' => $this->lang->line('update_message'));
            } else {
                $array = array('status' => '1', 'error' => '', 'message' => $this->lang->line('success_message'));
            }

            echo json_encode($array);
        }
    }

    public function getExamsByExamGroup()
    {
        $exam_group_id = $this->input->post('exam_group_id');
        $exams         = $this->cbse_examgroup_model->getExamByExamGroup($exam_group_id, true);

        $array = array('status' => '1', 'error' => '', 'result' => $exams);
        echo json_encode($array);
    }

    public function entrymarks()
    {
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('exam_group_class_batch_exam_subject_id', 'Subject', 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'exam_group_class_batch_exam_subject_id' => form_error('exam_group_class_batch_exam_subject_id'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {

            $exam_group_student_id = $this->input->post('exam_group_student_id');
            $previous_exam_id = $this->input->post('previous_exam_id');
            $insert_array          = array();
            $update_array          = array();
            
            

if (!empty($exam_group_student_id)) {
    foreach ($exam_group_student_id as $exam_group_student_key => $exam_group_student_value) {

        $assessment_type_marks = array(); // Reset per student



        if (!empty($_POST['assessment_type_id'])) {
            foreach ($_POST['assessment_type_id'] as $assessment_type_id) {
                $mark_field = 'assessment_type_marks_' . $exam_group_student_value . $assessment_type_id;

                if (isset($_POST[$mark_field])) {
                    $mark = trim($_POST[$mark_field]);

                    if ($mark !== "" && is_numeric($mark)) {
                        $markdata = array(
                            'assessment_type_id' => $assessment_type_id,
                            'assessment_type_mark' => $mark,
                        );
                        $assessment_type_marks[] = $markdata;
                    }
                }
            }
        }



        $previous_exam_marks = array(
            'previous_exam_id' => $previous_exam_id,
            'previous_exam_marks' => $this->input->post('previous_exam_marks_' . $exam_group_student_value), 
        );

        $attendance_post = $this->input->post('exam_group_student_attendance_' . $exam_group_student_value);
        $attendance = isset($attendance_post) ? $attendance_post : 'present';

        $array = array(
            'exam_group_class_batch_exam_subject_id' => $this->input->post('exam_group_class_batch_exam_subject_id'),
            'exam_group_class_batch_exam_student_id' => $exam_group_student_value,
            'assessment_type_marks' => json_encode($assessment_type_marks),
            'previous_exammarks' => json_encode($previous_exam_marks),
            'attendence' => $attendance,
            'get_marks' => $this->input->post('exam_group_student_mark_' . $exam_group_student_value),
            'term_marks' => $this->input->post('exam_group_student_term_exammarks_' . $exam_group_student_value),
            'note' => $this->input->post('exam_group_student_note_' . $exam_group_student_value),
        );

        $insert_array[] = $array;
    }
}


             
            $this->cbse_examgroupstudent_model->add_result($insert_array);
            $array = array('status' => '1', 'error' => '', 'message' => $this->lang->line('success_message'));
            echo json_encode($array);
        }
    }

    public function getexam()
    {
        $examgroup_id     = $this->input->post('examgroup_id');
        $data['examList'] = $this->cbse_examgroup_model->getExamByExamGroup($examgroup_id);

        $data['exam_page'] = $this->load->view('admin/exampattern/cbse/_partialexamList', $data, true);

        echo json_encode($data);
    }

    public function connectexams()
    {
        $examgroup_id         = $this->input->post('examgroup_id');
        $data['examList']     = $this->cbse_examgroup_model->getExamByExamGroupConnection($examgroup_id);
        $data['examgroup_id'] = $examgroup_id;

        $data['exam_page'] = $this->load->view('admin/examgroup/_partialexamListConnection', $data, true);
        echo json_encode($data);
    }

    public function getExamByID()
    {
        $exam_id = $this->input->post('exam_id');
        $result  = $this->cbse_examgroup_model->getExamByID($exam_id);
        if (!empty($result)) {
            $result->date_from = $this->customlib->dateformat($result->date_from);
            $result->date_to   = $this->customlib->dateformat($result->date_to);
        }
        $data['exam'] = $result;
        echo json_encode($data);
    }

    public function getexamSubjects()
    {
      
      
        $exam_id                 = $this->input->post('exam_id');
        $class_batch_id          = $this->input->post('class_batch_id');
        $exam_group_ids          = $this->input->post('exam_group_id');
        $data['examgroupDetail'] = $this->cbse_examgroup_model->getExamByID($exam_id);
        $data['exam_subjects']   = $this->cbse_batchsubject_model->getExamSubjects($exam_id);
        $data['batch_subjects']  = $this->subject_model->get();
        $data['classlist']  = $this->class_model->get(); 

        $data['exam_id']             = $exam_id;
        $data['exam_subjects_count'] = count($data['exam_subjects']);

        $data['batch_subject_dropdown'] = $this->load->view('admin/examgroup/_partialexamSubjectDropdown', $data, true);

        $data['subject_page'] = $this->load->view('admin/exampattern/cbse/_partialexamSubjects', $data, true);

        echo json_encode($data);
    }

    public function getSubjectByExam()
    {
        $data                    = array();
        $id                      = $this->input->post('recordid');
        $data['examgroupDetail'] = $this->cbse_examgroup_model->getExamByID($id);

        $data['exam_subjects'] = $this->cbse_batchsubject_model->getExamSubjects($id);

        $class                   = $this->class_model->get();
        $data['classlist']       = $class;
        $session                 = $this->session_model->get();
        $data['sessionlist']     = $session;
        $data['current_session'] = $this->sch_current_session;
        $data['subject_page']    = $this->load->view('admin/exampattern/cbse/_getSubjectByExam', $data, true);
        echo json_encode($data);
    }

    public function getTeacherRemarkByExam()
    {
        $data                      = array();
        $id                        = $this->input->post('recordid');
        $data['examgroupDetail']   = $this->cbse_examgroup_model->getExamByID($id);
        $data['examgroupStudents'] = $this->cbse_examgroupstudent_model->searchExamStudentsByExam($id);
        $data['sch_setting']       = $this->sch_setting_detail;
        $data['subject_page']      = $this->load->view('admin/exampattern/cbse/_getTeacherRemarkByExam', $data, true);
        echo json_encode($data);
    }

    public function addexamsubject()
    {

        $student_id = '';
        $this->form_validation->set_rules('examgroup_id', $this->lang->line('exam') . " " . $this->lang->line('group'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_group_class_batch_exam_id', $this->lang->line('exam') . " " . $this->lang->line('id'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('rows[]', $this->lang->line('subject'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

            $msg = array(
                'examgroup_id'                   => form_error('examgroup_id'),
                'exam_group_class_batch_exam_id' => form_error('exam_group_class_batch_exam_id'),
                'rows'                           => form_error('rows[]'),
            );

            $array = array('status' => '0', 'error' => $msg, 'message' => '');
        } else {
            $insert_array  = array();
            $update_array  = array();
            $subject_array = array();

            $not_be_del = array();

            $rows = $this->input->post('rows');
            foreach ($rows as $row_key => $row_value) {

                $update_id = $this->input->post('prev_row[' . $row_value . ']');
                if ($update_id == 0) {

                    if ($this->input->post('exam_group_class_batch_exam_id') != "" && $this->input->post('subject_' . $row_value) != "" && $this->input->post('date_from_' . $row_value) != "" && $this->input->post('time_from' . $row_value) != "" && $this->input->post('duration' . $row_value) != "" && $this->input->post('max_marks_' . $row_value) != "" && $this->input->post('min_marks_' . $row_value) != "") {

                        $insert_array[] = array(
                            'exam_group_class_batch_exams_id' => $this->input->post('exam_group_class_batch_exam_id'),
                            'subject_id'                      => $this->input->post('subject_' . $row_value),
                            'credit_hours'                    => $this->input->post('credit_hours' . $row_value),
                            'date_from'                       => date('Y-m-d', $this->customlib->datetostrtotime($this->input->post('date_from_' . $row_value))),
                            'time_from'                       => $this->input->post('time_from' . $row_value),
                            'duration'                        => $this->input->post('duration' . $row_value),
                            'room_no'                         => $this->input->post('room_no_' . $row_value),
                            'max_marks'                       => $this->input->post('max_marks_' . $row_value),
                            'min_marks'                       => $this->input->post('min_marks_' . $row_value),
                        );
                    }
                } else {
                    $not_be_del[]   = $update_id;
                    $update_array[] = array(
                        'id'                              => $update_id,
                        'credit_hours'                    => $this->input->post('credit_hours_' . $row_value),
                        'exam_group_class_batch_exams_id' => $this->input->post('exam_group_class_batch_exam_id'),
                        'subject_id'                      => $this->input->post('subject_' . $row_value),
                        'date_from'                       => date('Y-m-d', $this->customlib->datetostrtotime($this->input->post('date_from_' . $row_value))),
                        'time_from'                       => $this->input->post('time_from' . $row_value),
                        'duration'                        => $this->input->post('duration' . $row_value),
                        'room_no'                         => $this->input->post('room_no_' . $row_value),
                        'max_marks'                       => $this->input->post('max_marks_' . $row_value),
                        'min_marks'                       => $this->input->post('min_marks_' . $row_value),
                    );
                }
            }

            $this->cbse_examsubject_model->add($insert_array, $update_array, $not_be_del, $this->input->post('exam_group_class_batch_exam_id'));

            $array = array('status' => '1', 'error' => '', 'message' => $this->lang->line('success_message'));
        }

        echo json_encode($array);
    }

    public function assign($id)
    {
        if (!$this->rbac->hasPrivilege('fees_group_assign', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Batch');
        $this->session->set_userdata('sub_menu', 'examgroup/index');
        $data['id']        = $id;
        $data['title']     = 'student fees';
        $class             = $this->class_model->get();
        $data['classlist'] = $class;
        $examgroup         = $this->cbse_examgroup_model->getExamGroupDetailByID($id);

        $data['examgroup']   = $examgroup;
        $session_result      = $this->session_model->get();
        $data['sessionlist'] = $session_result;

        if ($this->input->server('REQUEST_METHOD') == 'POST') {

            $data['class_id']     = $this->input->post('class_id');
            $data['section_id']   = $this->input->post('section_id');
            $data['session_id']   = $this->input->post('session_id');
            $data['examgroup_id'] = $this->input->post('examgroup_id');

            $resultlist = $this->cbse_examgroupstudent_model->searchExamGroupStudents($data['examgroup_id'], $data['class_id'], $data['section_id'], $data['session_id']);

            $data['resultlist'] = $resultlist;
        }

        $this->load->view('layout/header', $data);
        $this->load->view('admin/examgroup/assign', $data);
        $this->load->view('layout/footer', $data);
    }

    public function addstudent()
    {
        $this->form_validation->set_rules('exam_group', $this->lang->line('exam') . " " . $this->lang->line('group'), 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'exam_group' => form_error('exam_group'),
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        } else {
            $array_insert = array();
            $array_delete = array();
            $exam_group   = $this->input->post('exam_group');

            $students_id  = $this->input->post('students_id');
            $all_students = $this->input->post('all_students');
            $students     = array();
            if (!isset($students_id)) {
                $students_id = array();
            }
            if (!empty($all_students)) {
                foreach ($all_students as $all_students_key => $all_students_value) {
                    if (in_array($all_students_value, $students_id)) {

                        $array_insert[] = array(
                            'exam_group_id'      => $exam_group,
                            'student_id'         => $all_students_value,
                            'student_session_id' => $all_students_value,
                        );
                    } else {
                        $array_delete[] = $all_students_value;
                    }
                }
            }

            $this->cbse_examgroupstudent_model->add($array_insert, $array_delete, $exam_group);

            $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('success_message'));
            echo json_encode($array);
        }
    }

    public function ajaxConnectForm()
    {
        if (isset($_POST['action'])) {
            if ($this->input->post('action') == "reset") {
                $exam_group_id = $this->input->post('examgroup_id');
                $this->cbse_examgroup_model->deleteExamGroupConnection($exam_group_id);
                $array = array('status' => 1, 'error' => '', 'message' => $this->lang->line('update_message'));
                echo json_encode($array);
            } elseif ($this->input->post('action') == "save") {

                $this->form_validation->set_error_delimiters('', '');
                $this->form_validation->set_rules('examgroup_id', $this->lang->line('exam') . " " . $this->lang->line('group'), 'required|trim|xss_clean');

                if ($this->form_validation->run() == false) {
                    $data = array(
                        'examgroup_id' => form_error('examgroup_id'),
                    );
                    $array = array('status' => 0, 'error' => $data);
                    echo json_encode($array);
                } else {
                    $array      = array();
                    $exam_array = $this->input->post('exam[]');
                    if (!empty($exam_array)) {
                        if (count($exam_array) <= 1) {
                            $array = array('status' => 0, 'error' => '', 'message' => $this->lang->line('please_select_atleast_two_or_more_exams'));
                        } else {

                            $exam_group = $this->cbse_examgroup_model->verifyExamConnection($exam_array);

                            if ($exam_group['no_record']) {
                                if (count($exam_group['exam_subject_array']) != count($exam_array)) {
                                    $array          = array('status' => 0, 'error' => '', 'message' => $this->lang->line('please_check_exam_subjects'));
                                    $insert_success = 0;
                                } else {

                                    reset($exam_group['exam_subject_array']);
                                    $result = key($exam_group['exam_subject_array']);

                                    $insert_success = 1;
                                    foreach ($exam_group['exam_subject_array'] as $exam_subject_key => $exam_subject_value) {

                                        $compair_result = $this->compare_multi_Arrays($exam_group['exam_subject_array'][$result], $exam_group['exam_subject_array'][$exam_subject_key]);

                                        if ($compair_result) {

                                            if (!empty($compair_result['more']) || !empty($compair_result['less']) || !empty($compair_result['diff'])) {
                                                $array          = array('status' => 0, 'error' => '', 'message' => $this->lang->line('please_check_exam_subjects'));
                                                $insert_success = 0;
                                                break;
                                            }
                                        } else {
                                            $array          = array('status' => 0, 'error' => '', 'message' => $this->lang->line('please_check_exam_subjects'));
                                            $insert_success = 0;
                                            break;
                                        }
                                    }
                                }
                            } else {
                                $array          = array('status' => 0, 'error' => '', 'message' => $this->lang->line('exams_subject_may_be_empty_please_check_exam_subjects'));
                                $insert_success = 0;
                            }

                            if ($insert_success) {
                                $insert_array  = array();
                                $exam_group_id = $this->input->post('examgroup_id');
                                if (!empty($exam_array)) {
                                    foreach ($exam_array as $exam_key => $exam_value) {

                                        $insert_array[] = array(
                                            'exam_group_id'                   => $exam_group_id,
                                            'exam_group_class_batch_exams_id' => $exam_value,
                                            'exam_weightage'                  => $this->input->post('exam_' . $exam_value),
                                        );
                                    }
                                }

                                $this->cbse_examgroup_model->connectExam($insert_array, $exam_group_id);
                                $array = array('status' => 1, 'error' => '', 'message' => $this->lang->line('exam_connected_successfully'));
                            }
                        }
                    } else {
                        $array = array('status' => 0, 'error' => '', 'message' => $this->lang->line('no_exams_selected'));
                    }

                    echo json_encode($array);
                }
            }
        }
    }

    public function compare_multi_Arrays($array1, $array2)
    {
        if (!empty($array1) && !empty($array2)) {
            $result = array("more" => array(), "less" => array(), "diff" => array());
            foreach ($array1 as $k => $v) {
                if (is_array($v) && isset($array2[$k]) && is_array($array2[$k])) {
                    $sub_result = compare_multi_Arrays($v, $array2[$k]);

                    foreach (array_keys($sub_result) as $key) {
                        if (!empty($sub_result[$key])) {
                            $result[$key] = array_merge_recursive($result[$key], array($k => $sub_result[$key]));
                        }
                    }
                } else {
                    if (isset($array2[$k])) {
                        if ($v !== $array2[$k]) {
                            $result["diff"][$k] = array("from" => $v, "to" => $array2[$k]);
                        }
                    } else {
                        $result["more"][$k] = $v;
                    }
                }
            }
            foreach ($array2 as $k => $v) {
                if (!isset($array1[$k])) {
                    $result["less"][$k] = $v;
                }
            }
            return $result;
        }
        return false;
    }

    public function getExamGroupByClassSection()
    {
        $exam_group = array();
        $class_id   = $this->input->post('class_id');
        $section_id = $this->input->post('section_id');
        $session_id = $this->input->post('session_id');
        $exam_group = $this->cbse_examgroup_model->getExamGroupByClassSection($class_id, $section_id, $session_id);
        echo json_encode(array('status' => 1, 'exam_group' => $exam_group));
    }

   public function entrystudents()
{
    $this->form_validation->set_error_delimiters('', '');
    $this->form_validation->set_rules('exam_group_class_batch_exam_id', $this->lang->line('exam'), 'required|trim|xss_clean');

    $class_id = $this->input->post('class_id');
    $section_id = $this->input->post('section_id');
    $exam_id = $this->input->post('exam_group_class_batch_exam_id');

//   this code is add by arun start
    // Step 1: Check if exam subjects already inserted for given exam_id, class_id, section_id
    $this->db->where('exam_group_class_batch_exams_id', $exam_id);
    $this->db->where('class_id', $class_id);
    $this->db->where('section_id', $section_id);
    $existing_subjects = $this->db->get('cbse_exam_group_class_batch_exam_subjects');

  if ($existing_subjects->num_rows() > 0) {
    $array = array(
        'status' => 0,
        'message' => 'Exam subjects already added for this class and section.'
    );
    echo json_encode($array);
    return;
}
    $class_sections = $this->classsection_model->getDetailbyClassSection($class_id,$section_id);

    $class_section_id = $class_sections['id'];
    // Step 2: Get subject_group_id for the class & section
    $this->db->select('subject_group_id');
    $this->db->from('subject_group_class_sections');
    $this->db->where('class_section_id', $class_section_id);
    $query = $this->db->get();

    $subject_group_id = null;
    if ($query->num_rows() > 0) {
        $subject_group_id = $query->row()->subject_group_id;
    }

    // Step 3: Determine is_termexam
    $is_termexam = 'no'; // default
    $this->db->select('is_termexam');
    $this->db->from('cbse_exam_group_class_batch_exams');
    $this->db->where('id', $exam_id);
    $exam_query = $this->db->get();

    if ($exam_query->num_rows() > 0) {
        $is_termexam = $exam_query->row()->is_termexam;
    }

    // Step 4: Determine max_marks
    $max_marks = ($is_termexam === 'yes') ? 80 : 30;

    // Step 5: Insert exam subjects if subject_group_id is found
    // if ($subject_group_id) {
    //     $this->db->select('subject_id');
    //     $this->db->from('subject_group_subjects');
    //     $this->db->where('subject_group_id', $subject_group_id);
    //     $subject_query = $this->db->get();

    //     if ($subject_query->num_rows() > 0) {
    //         foreach ($subject_query->result() as $row) {
    //             $subject_id = $row->subject_id;

    //             $data = [
    //                 'exam_group_class_batch_exams_id' => $exam_id,
    //                 'subject_id' => $subject_id,
    //                 'date_from' => date('Y-m-d'),
    //                 'max_marks' => $max_marks,
    //                 'class_id' => $class_id,
    //                 'section_id' => $section_id,
    //             ];

    //             $this->db->insert('cbse_exam_group_class_batch_exam_subjects', $data);
    //         }
    //     }
    // }
//   this code is add by arun end
    // Step 6: Validation and student insert
    if ($this->form_validation->run() == false) {
        $data = array(
            'exam_group_class_batch_exam_id' => form_error('exam_group_class_batch_exam_id'),
        );
        $array = array('status' => 0, 'error' => $data);
        echo json_encode($array);
    } else {
        $check_alreay_inserted_students = array();
        $state = 1;
        $exam_group_class_batch_exam_id = $this->input->post('exam_group_class_batch_exam_id');
        $student_session = $this->input->post('student_session_id');
        $all_students = $this->input->post('all_students');
        $insert_array = array();

        if (isset($student_session) && !empty($student_session)) {
            foreach ($student_session as $student_key => $student_value) {
                $check_alreay_inserted_students[] = $this->input->post('student_' . $student_value);
                $insert_array[] = array(
                    'exam_group_class_batch_exam_id' => $exam_group_class_batch_exam_id,
                    'student_id' => $this->input->post('student_' . $student_value),
                    'exam_seat_no'                   => $this->input->post('examseatno_' . $student_value),
                    'student_session_id' => $student_value,
                );
            }
        }

        $this->cbse_examstudent_model->add_student($insert_array, $exam_group_class_batch_exam_id, $all_students);
        $array = array('status' => '1', 'error' => '', 'message' => $this->lang->line('success_message'));
        echo json_encode($array);
    }
}


    public function saveexamremark()
    {
        $students = $this->input->post('exam_group_class_batch_exam_student');
        if (!empty($students)) {
            $batch_update_array = array();
            foreach ($students as $student_key => $student_value) {
                $update_array = array(
                    'id'             => $student_value,
                    'teacher_remark' => $this->input->post('remark_' . $student_value),
                );
            $batch_update_array[]=$update_array;
            }
            $this->cbse_examgroupstudent_model->updateExamStudent($batch_update_array);
        }
        $array = array('status' => '1', 'error' => '', 'message' => $this->lang->line('success_message'));
        echo json_encode($array);
    }
    
    public function marks_distribution_type()
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'exam_pattern');
        $this->session->set_userdata('sub_menu', 'Examinations/exam_cbse_pattern');
        $data['title']      = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType']   = $this->exam_type;
        $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        //$this->form_validation->set_rules('exam_type', $this->lang->line('exam') . " " . $this->lang->line('type'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

        } else {
            $is_active = 0;
            $data = array(
                'name'        => $this->input->post('name'),
                'status'   => 1,
                'description' => $this->input->post('description'),
            );

            //$insert_id = $this->cbse_examgroup_model->add($data);
            $insert_id = insertData('cbse_exam_marks_distribution_type', $data);

            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/exam_cbse_pattern/marks_distribution_type');
        }
        //$examgroup_result      = $this->cbse_examgroup_model->get();
        $examgroup_result      = get_list('cbse_exam_marks_distribution_type', array('status' => 1), null, null, 0, 'id', 'ASC');
        $data['examgrouplist'] = $examgroup_result;
        
        $menu_data['selected'] = 'marks_distribution_type';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/cbse/topMenuOptions', $menu_data, true);
        
        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/cbse/marksDistributionTypeList', $data);
        $this->load->view('layout/footer', $data);
    }



    
    
    public function edit_marks_distribution_type($id)
    {
        if (!$this->rbac->hasPrivilege('exam', 'can_edit')) {
            access_denied();
        }

        $data['id']            = $id;
        //$examgroup             = $this->cbse_examgroup_model->get($id);
        $examgroup             = get_single_row('cbse_exam_marks_distribution_type', array('id' => $id));
        $data['examgroup']     = $examgroup;
        $data['examType']      = $this->exam_type;
        //$examgroup_result      = $this->cbse_examgroup_model->get();
        $examgroup_result      = get_list('cbse_exam_marks_distribution_type', array('status' => 1), null, null, 0, 'id', 'ASC');
        $data['examgrouplist'] = $examgroup_result;
        $menu_data['selected'] = 'marks_distribution_type';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/cbse/topMenuOptions', $menu_data, true);
        
        $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/exampattern/cbse/marksDistributionTypeEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $is_active = 1;

            $data = array(
                //'mdtid'    => $this->input->post('id'),
                'name'     => $this->input->post('name'),
                'status'   => $is_active,
                'description' => $this->input->post('description'),
            );
            //$insert_id = $this->cbse_examgroup_model->add($data);
            $updated_id = updateData('cbse_exam_marks_distribution_type','id', $id, $data);

            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/exam_cbse_pattern/marks_distribution_type');
        }
    }
    
    public function delete_marks_distribution_type($id)
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Delete Batch';
        $updated_id = updateData('exam_marks_distribution_type','id', $id, array('status' => 3));
        //$this->cbse_examgroup_model->remove($id);
        redirect('admin/exampattern/marks_distribution_type');
    }

    public function assign_assessments_marks()
    {
        $this->form_validation->set_error_delimiters('<p>', '</p>');
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('assessment_id', 'Assessment', 'required|trim|xss_clean');
        $this->form_validation->set_rules('month', 'Month', 'required|trim|xss_clean');
        // $this->form_validation->set_rules('session_id', $this->lang->line('session'), 'required|trim|xss_clean');
        $userdata = $this->customlib->getUserData();
        $role_id  = $userdata["role_id"];
        $can_edit = 1;
        if (isset($role_id) && ($userdata["role_id"] == 2) && ($userdata["class_teacher"] == "yes")) {
            $myclasssubjects = $this->subjecttimetable_model->canAddExamMarks($userdata["id"], $this->input->post('class_id'), $this->input->post('section_id'), $this->input->post('teachersubject_id'));
            $can_edit        = $myclasssubjects;
        }

        if ($this->form_validation->run() == false) {
            $data = array(
                'class_id'   => form_error('class_id'),
                'section_id' => form_error('section_id'),
                'session_id' => form_error('session_id'),
                'subject_id' => form_error('subject_id'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } elseif ($can_edit == 0) {
            $msg   = array('lesson' => $this->lang->line('not_authoried'));
            $array = array('status' => 0, 'error' => $msg);
            echo json_encode($array);
        } else {
            $assessment_id                                = $this->input->post('assessment_id');
            $data['assessment_id'] = $assessment_id;
            $class_id                                       = $this->input->post('class_id');
            $section_id                                     = $this->input->post('section_id');
            // $session_id                                     = $this->input->post('session_id');
            $data['class_id']                               = $this->input->post('class_id');
            $data['section_id']                             = $this->input->post('section_id');
            $data['month']                             = $this->input->post('month');
            $month = $this->input->post('month');
            // $data['session_id']                             = $this->input->post('session_id');
            $resultlist = $this->cbse_examgroup_model->assessmentSubjectResult($assessment_id, $class_id, $section_id, $month);



            // $subject_detail = $this->cbse_batchsubject_model->getExamSubject($exam_subject_id);
            
            
            
            
            $data['attendence_exam'] = $this->attendence_exam;
            $data['resultlist']      = $resultlist;
            $data['sch_setting']     = $this->sch_setting_detail;
            $student_exam_page       = $this->load->view('admin/exampattern/cbse/_partialstudentmarkEntry', $data, true);

            $array = array('status' => '1', 'error' => '', 'page' => $student_exam_page);
            echo json_encode($array);
        }
    }

    public function assessmententrymarks()
    {
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('assessment_id', 'Subject', 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'assessment_id' => form_error('assessment_id'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {

            $assessment_student_id = $this->input->post('assessment_student_id');
            $insert_array          = array();
            $update_array          = array();
            if (!empty($assessment_student_id)) {
                foreach ($assessment_student_id as $assessment_student_key => $assessment_student_value) {
                    $attendance_post = $this->input->post('assessment_student_attendance_' . $assessment_student_value);
                    if (isset($attendance_post)) {
                        $attendance = $this->input->post('assessment_student_attendance_' . $assessment_student_value);
                    } else {
                        $attendance = "present";
                    }
                    $array = array(
                        'assessment_id' => $this->input->post('assessment_id'),
                        'month' => $this->input->post('month'),
                        'student_id' => $assessment_student_value,
                        'attendance'                             => $attendance,
                        'get_marks'                              => isset($_POST['assessment_student_mark_' . $assessment_student_value]) ? $this->input->post('assessment_student_mark_' . $assessment_student_value) : 0,
                        
                    );
                    $insert_array[] = $array;
                }
            }

            $this->cbse_examgroup_model->add_result($insert_array);
            $array = array('status' => '1', 'error' => '', 'message' => $this->lang->line('success_message'));
            echo json_encode($array);
        }
    }

    public function assessment_type()
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'exam_pattern');
        $this->session->set_userdata('sub_menu', 'Examinations/exam_cbse_pattern');
        $data['title']      = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType']   = $this->exam_type;
        $this->form_validation->set_rules('assessment_type', $this->lang->line('type'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('assessment_min_marks', $this->lang->line('assessment'). " " .$this->lang->line('min_marks'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('assessment_max_marks', $this->lang->line('assessment'). " " .$this->lang->line('max_marks'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('term_exam_out_of_marks', $this->lang->line('assessment'). " " .$this->lang->line('min_marks'), 'trim|required|xss_clean');
        //$this->form_validation->set_rules('exam_type', $this->lang->line('exam') . " " . $this->lang->line('type'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

        } else {
            $is_active = 0;
            $data = array(
                'type'                        => $this->input->post('assessment_type'),
                'assessment_min_marks'        => $this->input->post('assessment_min_marks'),
                'assessment_max_marks'        => $this->input->post('assessment_max_marks'),
                'term_exam_out_of_marks'      => $this->input->post('term_exam_out_of_marks'),
                'description' => $this->input->post('description'),
                'status'   => 1,
                
            );

            //$insert_id = $this->cbse_examgroup_model->add($data);
            $insert_id = insertData('assessment_types', $data);

            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/exam_cbse_pattern/assessment_type');
        }
        //$examgroup_result      = $this->cbse_examgroup_model->get();
        $examgroup_result      = get_list('assessment_types', array('status' => 1), null, null, 0, 'id', 'ASC');
        $data['examgrouplist'] = $examgroup_result;
        
        $menu_data['selected'] = 'selected_assessment_type';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/cbse/topMenuOptions', $menu_data, true);
        
        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/cbse/assessmentTypeList', $data);
        $this->load->view('layout/footer', $data);
    }

    public function edit_assessment_type($id)
    {
        if (!$this->rbac->hasPrivilege('exam', 'can_edit')) {
            access_denied();
        }

        $data['id']            = $id;
        //$examgroup             = $this->cbse_examgroup_model->get($id);
        $examgroup             = get_single_row('assessment_types', array('id' => $id));
        $data['examgroup']     = $examgroup;
        $data['examType']      = $this->exam_type;
        //$examgroup_result      = $this->cbse_examgroup_model->get();
        $examgroup_result      = get_list('assessment_types', array('status' => 1), null, null, 0, 'id', 'ASC');
        $data['examgrouplist'] = $examgroup_result;
        $menu_data['selected'] = 'selected_assessment_type';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/cbse/topMenuOptions', $menu_data, true);
        
        $this->form_validation->set_rules('assessment_type', $this->lang->line('type'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('assessment_min_marks', $this->lang->line('assessment'). " " .$this->lang->line('min_marks'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('assessment_max_marks', $this->lang->line('assessment'). " " .$this->lang->line('max_marks'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('term_exam_out_of_marks', $this->lang->line('assessment'). " " .$this->lang->line('min_marks'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/exampattern/cbse/assessmentTypeEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $is_active = 1;

            $data = array(
                //'mdtid'    => $this->input->post('id'),
                'type'                     => $this->input->post('assessment_type'),
                'assessment_min_marks'     => $this->input->post('assessment_min_marks'),
                'assessment_max_marks'     => $this->input->post('assessment_max_marks'),
                'term_exam_out_of_marks'   => $this->input->post('term_exam_out_of_marks'),
                'status'   => $is_active,
                'description' => $this->input->post('description'),
            );
            //$insert_id = $this->cbse_examgroup_model->add($data);
            $updated_id = updateData('assessment_types','id', $id, $data);

            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/exam_cbse_pattern/assessment_type');
        }
    }
    
    public function delete_assessment_type($id)
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Delete Batch';
        $updated_id = updateData('assessment_types','id', $id, array('status' => 3));
        //$this->cbse_examgroup_model->remove($id);
        redirect('admin/exam_cbse_pattern/assessment_type');
    }
    
    public function marks_distribution_component()
    {
        //echo '<pre>';print_r($_POST);exit;
        if (!$this->rbac->hasPrivilege('exam_group', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'exam_pattern');
        $this->session->set_userdata('sub_menu', 'Examinations/exam_cbse_pattern');
        $data['title']      = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType']   = $this->exam_type;
        //$this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('mark_dist_type', "Mark distribution " . $this->lang->line('type'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

        } else {
            $is_active = 0;
            if(isset($_POST['name']) && !empty($_POST['name']))
            {
                foreach($_POST['name'] as $comp_name)
                {
                    $data = array(
                        'name'    => $comp_name,
                        'mdtid'   => $this->input->post('mark_dist_type'),
                        'status'  => 1,
                        'description'  => $this->input->post('description'),
                    );
                    $insert_id = insertData('cbse_exam_mark_distribution_component', $data);
                }
            } 
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/exam_cbse_pattern/marks_distribution_component');
        }
        //$examgroup_result      = $this->cbse_examgroup_model->get();
        $examgroup_result         = get_list('cbse_exam_mark_distribution_component', array('status' => 1), null, null, 0, 'id', 'ASC');
        $marks_dist_types         = get_list('cbse_exam_marks_distribution_type', array('status' => 1), null, null, 0, 'id', 'ASC');
        $data['examgrouplist']    = $examgroup_result;
        $data['marks_dist_types'] = $marks_dist_types;
        $menu_data['selected'] = 'marks_distribution_component';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/cbse/topMenuOptions', $menu_data, true);
        
        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/cbse/marksDistributionComponentList', $data);
        $this->load->view('layout/footer', $data);
    }


    
    public function edit_marks_distribution_component($id)
    {
        if (!$this->rbac->hasPrivilege('exam', 'can_edit')) {
            access_denied();
        }

        $data['id']            = $id;
        //$examgroup             = $this->cbse_examgroup_model->get($id);
        $examgroup             = get_single_row('cbse_exam_mark_distribution_component', array('id' => $id));
        $data['examgroup']     = $examgroup;
        $data['examType']      = $this->exam_type;
        //$examgroup_result      = $this->cbse_examgroup_model->get();
        $examgroup_result         = get_list('cbse_exam_mark_distribution_component', array('status' => 1), null, null, 0, 'id', 'ASC');
        $marks_dist_types         = get_list('cbse_exam_marks_distribution_type', array('status' => 1), null, null, 0, 'id', 'ASC');
        $data['examgrouplist']    = $examgroup_result;
        $data['marks_dist_types'] = $marks_dist_types;
        $menu_data['selected'] = 'marks_distribution_component';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/cbse/topMenuOptions', $menu_data, true);
        

        $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('mark_dist_type', "Mark distribution " . $this->lang->line('type'), 'trim|required|xss_clean');
        
        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/exampattern/cbse/marksDistributionComponentEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $is_active = 1;
            $data = array(
                'mdtid'    => $this->input->post('mark_dist_type'),
                'name'     => $this->input->post('name'),
                'status'   => $is_active,
                'description' => $this->input->post('description'),
            );
            //$insert_id = $this->cbse_examgroup_model->add($data);
            $updated_id = updateData('cbse_exam_mark_distribution_component','id', $id, $data);

            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/exam_cbse_pattern/marks_distribution_component');
        }
    }
    
    public function delete_marks_distribution_component($id)
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Delete Batch';
        $updated_id = updateData('cbse_exam_mark_distribution_component','id', $id, array('status' => 3));
        //$this->cbse_examgroup_model->remove($id);
        redirect('admin/exam_cbse_pattern/marks_distribution_component');
    }


    public function marks_distribution_subcomponent()
    {
        //echo '<pre>';print_r($_POST);exit;
        if (!$this->rbac->hasPrivilege('exam_group', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'exam_pattern');
        $this->session->set_userdata('sub_menu', 'Examinations/exam_cbse_pattern');
        $data['title']      = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType']   = $this->exam_type;
        //$this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('mark_dist_type', "Mark distribution " . $this->lang->line('type'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('mark_comp_id', "Mark distribution Component" , 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

        } else {
            $is_active = 0;
            if(isset($_POST['name']) && !empty($_POST['name']))
            {
                foreach($_POST['name'] as $comp_name)
                {
                    $data = array(
                        'name'    => $comp_name,
                        'mdtid'   => $this->input->post('mark_dist_type'),
                        'mark_comp_id'   => $this->input->post('mark_comp_id'),
                        'status'  => 1,
                        'description'  => $this->input->post('description'),
                    );
                    $insert_id = insertData('cbse_exam_mark_distribution_subcomponent', $data);
                }
            } 
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/exam_cbse_pattern/marks_distribution_subcomponent');
        }
        //$examgroup_result      = $this->cbse_examgroup_model->get();
        $examgroup_result         = get_list('cbse_exam_mark_distribution_subcomponent', array('status' => 1), null, null, 0, 'id', 'ASC');
        $marks_dist_types         = get_list('cbse_exam_marks_distribution_type', array('status' => 1), null, null, 0, 'id', 'ASC');
        $marks_dist_comps         = get_list('cbse_exam_mark_distribution_component', array('status' => 1), null, null, 0, 'id', 'ASC');
        $data['examgrouplist']    = $examgroup_result;
        $data['marks_dist_types'] = $marks_dist_types;
        $data['marks_dist_comps'] = $marks_dist_comps;
        $menu_data['selected'] = 'marks_distribution_subcomponent';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/cbse/topMenuOptions', $menu_data, true);
        
        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/cbse/marksDistributionSubComponentList', $data);
        $this->load->view('layout/footer', $data);
    }
    
    public function edit_marks_distribution_subcomponent($id)
    {
        if (!$this->rbac->hasPrivilege('exam', 'can_edit')) {
            access_denied();
        }

        $data['id']            = $id;
        //$examgroup             = $this->cbse_examgroup_model->get($id);
        $examgroup             = get_single_row('cbse_exam_mark_distribution_subcomponent', array('id' => $id));
        $data['examgroup']     = $examgroup;
        $data['examType']      = $this->exam_type;
        //$examgroup_result      = $this->cbse_examgroup_model->get();
        $examgroup_result         = get_list('cbse_exam_mark_distribution_subcomponent', array('status' => 1), null, null, 0, 'id', 'ASC');
        $marks_dist_types         = get_list('cbse_exam_marks_distribution_type', array('status' => 1), null, null, 0, 'id', 'ASC');
        $data['examgrouplist']    = $examgroup_result;
        $data['marks_dist_types'] = $marks_dist_types;
        $menu_data['selected'] = 'marks_distribution_subcomponent';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/cbse/topMenuOptions', $menu_data, true);
        

        $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('mark_dist_type', "Mark distribution " . $this->lang->line('type'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('mark_comp_id', "Mark distribution Component", 'trim|required|xss_clean');
        
        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/exampattern/cbse/marksDistributionSubComponentEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $is_active = 1;
            $data = array(
                'mdtid'    => $this->input->post('mark_dist_type'),
                'mark_comp_id'    => $this->input->post('mark_comp_id'),
                'name'     => $this->input->post('name'),
                'status'   => $is_active,
                'description' => $this->input->post('description'),
            );
            //$insert_id = $this->cbse_examgroup_model->add($data);
            $updated_id = updateData('cbse_exam_mark_distribution_subcomponent','id', $id, $data);

            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/exam_cbse_pattern/marks_distribution_subcomponent');
        }
    }
    
    public function delete_marks_distribution_subcomponent($id)
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Delete Batch';
        $updated_id = updateData('cbse_exam_mark_distribution_subcomponent','id', $id, array('status' => 3));
        //$this->cbse_examgroup_model->remove($id);
        redirect('admin/exam_cbse_pattern/marks_distribution_subcomponent');
    }

    public function assessment()
    {
        
        if (!$this->rbac->hasPrivilege('exam_group', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'exam_pattern');
        $this->session->set_userdata('sub_menu', 'Examinations/exam_cbse_pattern');
        $data['title']      = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType']   = $this->exam_type;
        //$this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('name[]', "Assessment " . $this->lang->line('name'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('class_id', "Class" , 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', "Section" , 'trim|required|xss_clean');
        $this->form_validation->set_rules('session_id', "Session" , 'trim|required|xss_clean');
        $this->form_validation->set_rules('subject_group_id', "Subject Group" , 'trim|required|xss_clean');
        $this->form_validation->set_rules('subject_id', "Subject" , 'trim|required|xss_clean');
        $this->form_validation->set_rules('assessment_type_id', "Assessment Type" , 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

        } else {
            $is_active = 0;
            if(isset($_POST['name']) && !empty($_POST['name']))
            {
                foreach($_POST['name'] as $comp_name)
                {
                    $data = array(
                        'name'    => $comp_name,
                        'class_id'   => $this->input->post('class_id'),
                        'section_id'   => $this->input->post('section_id'),
                        'session_id' => $this->input->post('session_id'),
                        'subject_group_id'   => $this->input->post('subject_group_id'),
                        'subject_id'   => $this->input->post('subject_id'),
                        'assessment_type_id'   => $this->input->post('assessment_type_id'),
                        'status'  => 1,
                        
                    );
                    $insert_id = insertData('assessments', $data);
                }
            } 
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/exam_cbse_pattern/assessment');
        }
        $class      = $this->class_model->get();
        // $examgroup_result         = get_list('assessments', array('status' => 1), null, null, 0, 'id', 'ASC');
        $examgroup_result      = $this->cbse_examgroup_model->getAssessments();
        $assessment_types         = get_list('assessment_types', array('status' => 1), null, null, 0, 'id', 'ASC');
        
        $data['examgrouplist']    = $examgroup_result;
        $data['classlist']    = $class;
        $session                 = $this->session_model->get();
        $data['sessionlist']     = $session;
        // print_r($session); die();
        $data['assessment_types'] = $assessment_types;
        
        $menu_data['selected'] = 'assessment';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/cbse/topMenuOptions', $menu_data, true);
        
        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/cbse/assessmentList', $data);
        $this->load->view('layout/footer', $data);
    }


    public function edit_assessment($id)
    {
        if (!$this->rbac->hasPrivilege('exam', 'can_edit')) {
            access_denied();
        }

        $data['id']            = $id;
        
        $examgroup      = $this->cbse_examgroup_model->getAssessments($id);
        
        $data['AssessmentData']     = $examgroup;
        
        //$examgroup_result      = $this->cbse_examgroup_model->get();
        $examgroup_result         = $this->cbse_examgroup_model->getAssessments();
        $class      = $this->class_model->get();
        
        $assessment_types         = get_list('assessment_types', array('status' => 1), null, null, 0, 'id', 'ASC');
        
        $data['examgrouplist']    = $examgroup_result;
        $data['classlist']    = $class;
        
        $data['assessment_types'] = $assessment_types;
        
        $menu_data['selected'] = 'assessment';
        $menu_data['selected'] = 'marks_distribution_subcomponent';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/cbse/topMenuOptions', $menu_data, true);
        $session                 = $this->session_model->get();
        $data['sessionlist']     = $session;
        

        $this->form_validation->set_rules('name', "Assessment " . $this->lang->line('name'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('class_id', "Class" , 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', "Section" , 'trim|required|xss_clean');
        $this->form_validation->set_rules('session_id', "Session" , 'trim|required|xss_clean');
        $this->form_validation->set_rules('subject_group_id', "Subject Group" , 'trim|required|xss_clean');
        $this->form_validation->set_rules('subject_id', "Subject" , 'trim|required|xss_clean');
        $this->form_validation->set_rules('assessment_type_id', "Assessment Type" , 'trim|required|xss_clean');
        
        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/exampattern/cbse/assessmentEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $is_active = 1;
            $data = array(
                        'name'    => $this->input->post('name'),
                        'class_id'   => $this->input->post('class_id'),
                        'session_id' => $this->input->post('session_id'),
                        'section_id'   => $this->input->post('section_id'),
                        'subject_group_id'   => $this->input->post('subject_group_id'),
                        'subject_id'   => $this->input->post('subject_id'),
                        'assessment_type_id'   => $this->input->post('assessment_type_id')
                        
                        
                    );
            
            $updated_id = updateData('assessments','id', $id, $data);

            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/exam_cbse_pattern/assessment');
        }
    }


    public function delete_assessment($id)
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Delete Batch';
        $updated_id = updateData('assessments','id', $id, array('status' => 3));
        //$this->cbse_examgroup_model->remove($id);
        redirect('admin/exam_cbse_pattern/assessment');
    }

    public function getSubjectsbySubjectgroup()
    {
        $subject_group_id = $this->input->post('subject_group_id');
        $subject = $this->subjectgroup_model->getGroupsubjects($subject_group_id);

        echo json_encode($subject);
    }


    public function getDistComponentByType()
    {
        $mark_dist_type = $this->input->post('mark_dist_type');

        $query=$this->db->select('*')
        ->from('cbse_exam_mark_distribution_component')
        ->where('mdtid',$mark_dist_type)
        ->where('status',1)
        ->get();

        $data = $query->result_array();

        echo json_encode($data);

    }
    
    public function subjectwise_remark()
    {
        //echo '<pre>';print_r($_POST);exit;
        if (!$this->rbac->hasPrivilege('exam_group', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'exam_pattern');
        $this->session->set_userdata('sub_menu', 'Examinations/exampattern');
        $data['title']      = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType']   = $this->exam_type;
        //$this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('subject_id', "Subject " . $this->lang->line('type'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

        } else {
            $is_active = 0;
            if(isset($_POST['name']) && !empty($_POST['name']))
            {
                foreach($_POST['name'] as $comp_name)
                {
                    $data = array(
                        'remark_name'    => $comp_name,
                        'subject_id'   => $this->input->post('subject_id'),
                        'status'  => 1,
                        'note'  => $this->input->post('description'),
                    );
                    $insert_id = insertData('exam_subjectwise_remark', $data);
                }
            } 
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/exampattern/subjectwise_remark');
        }
        //$examgroup_result      = $this->cbse_examgroup_model->get();
        $examgroup_result         = get_list('exam_subjectwise_remark', array('status' => 1), null, null, 0, 'id', 'ASC');
        $subjects                 = get_list('subjects', array(), null, null, 0, 'id', 'ASC');
        $data['examgrouplist']    = $examgroup_result;
        $data['subjects']         = $subjects;
        $menu_data['selected'] = 'subjectwise_remark';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        

        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/mh/subjectwiseRemarkList', $data);
        $this->load->view('layout/footer', $data);
    }
    
    public function edit_subjectwise_remark($id)
    {
        if (!$this->rbac->hasPrivilege('exam', 'can_edit')) {
            access_denied();
        }

        $data['id']            = $id;
        //$examgroup             = $this->cbse_examgroup_model->get($id);
        $examgroup             = get_single_row('exam_subjectwise_remark', array('id' => $id));
        $data['examgroup']     = $examgroup;
        $data['examType']      = $this->exam_type;
        //$examgroup_result      = $this->cbse_examgroup_model->get();
        $examgroup_result      = get_list('exam_subjectwise_remark', array('status' => 1), null, null, 0, 'id', 'ASC');
        $subjects              = get_list('subjects', array(), null, null, 0, 'id', 'ASC');
        $data['examgrouplist']    = $examgroup_result;
        $data['subjects'] = $subjects;
        $menu_data['selected'] = 'subjectwise_remark';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        
        $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('subject_id', "Subject " . $this->lang->line('type'), 'trim|required|xss_clean');
        
        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/exampattern/mh/subjectwiseRemarkEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $is_active = 1;
            $data = array(
                'subject_id'    => $this->input->post('subject_id'),
                'remark_name'     => $this->input->post('name'),
                'status'   => $is_active,
                'note' => $this->input->post('description'),
            );
            //$insert_id = $this->cbse_examgroup_model->add($data);
            $updated_id = updateData('exam_subjectwise_remark','id', $id, $data);

            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/exampattern/subjectwise_remark');
        }
    }
    
    public function delete_subjectwise_remark($id)
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Delete Batch';
        $updated_id = updateData('exam_subjectwise_remark','id', $id, array('status' => 3));
        //$this->cbse_examgroup_model->remove($id);
        redirect('admin/exampattern/subjectwise_remark');
    }
    
    public function classwise_subject_mark()
    {
        //echo '<pre>';print_r($_POST);exit;
        if (!$this->rbac->hasPrivilege('exam_group', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'exam_pattern');
        $this->session->set_userdata('sub_menu', 'Examinations/exampattern');
        $data['title']      = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType']   = $this->exam_type;
        //$this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('class_id', "Subject " . $this->lang->line('type'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

        } else {
            $is_active = 0;
            if(isset($_POST['subject_id']) && !empty($_POST['subject_id']))
            {
                foreach($_POST['subject_id'] as $key => $sub_name)
                {
                    //@todo check for is exist
                    $data = array(
                        'class_id'   => $this->input->post('class_id'),
                        'subject_id' => $sub_name,
                        'subject_mark_type' => isset($_POST['mark_type'][$key]) ? $_POST['mark_type'][$key] : 0,
                        'max_mark' => isset($_POST['max_mark'][$key]) ? $_POST['max_mark'][$key] : 0,
                        'min_mark' => isset($_POST['min_mark'][$key]) ? $_POST['min_mark'][$key] : 0,
                        'aakarik_mark' => isset($_POST['aakarik_mark'][$key]) ? $_POST['aakarik_mark'][$key] : 0,
                        'sankalit_mark' => isset($_POST['sankalit_mark'][$key]) ? $_POST['sankalit_mark'][$key] : 0,
                        //'description'  => $this->input->post('description'),
                        'description'  => '',
                        'status'  => 1,
                        
                    );
                    $insert_id = insertData('exam_classwise_subjects_mark', $data);
                }
            
                $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
                redirect('admin/exampattern/classwise_subject_mark');
            } else {
                $this->session->set_flashdata('msg', '<div class="alert alert-danger text-left">Invalid input. Please select subjects and enter marks.</div>');
                redirect('admin/exampattern/classwise_subject_mark');
            }
            
        }
        //$examgroup_result      = $this->cbse_examgroup_model->get();
        $examgroup_result         = get_list('exam_classwise_subjects_mark', array('status' => 1), null, null, 0, 'id', 'ASC');
        $subjects                 = get_list('subjects', array(), null, null, 0, 'id', 'ASC');
        $data['examgrouplist']    = $examgroup_result;
        $data['subjects']         = $subjects;
        $menu_data['selected'] = 'classwise_subject_mark';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        
        //$subject_list = $this->subject_model->get();
        //$data['subjectlist'] = $subject_list;
        $class = $this->class_model->get();
        $data['classlist'] = $class;
        $subjectgroupList = $this->subjectgroup_model->getByID();
        //echo '<pre>';
        //print_r($subjectgroupList);exit;
        $data['subjectgroupList'] = $subjectgroupList;

        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/mh/classwiseSubjectMarkList', $data);
        $this->load->view('layout/footer', $data);
    }
    
    public function edit_classwise_subject_mark($id)
    {
        if (!$this->rbac->hasPrivilege('exam', 'can_edit')) {
            access_denied();
        }

        $data['id']            = $id;
        //$examgroup             = $this->cbse_examgroup_model->get($id);
        $examgroup             = get_single_row('exam_classwise_subjects_mark', array('id' => $id));
        $data['examgroup']     = $examgroup;
        $data['examType']      = $this->exam_type;
        //$examgroup_result      = $this->cbse_examgroup_model->get();
        $examgroup_result      = get_list('exam_classwise_subjects_mark', array('status' => 1), null, null, 0, 'id', 'ASC');
        $subjects              = get_list('subjects', array(), null, null, 0, 'id', 'ASC');
        $data['examgrouplist'] = $examgroup_result;
        $data['subjects'] = $subjects;
        $menu_data['selected'] = 'classwise_subject_mark';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        
        
        $class = $this->class_model->get();
        $data['classlist'] = $class;
        $subjectgroupList = $this->subjectgroup_model->getByID();
        $data['subjectgroupList'] = $subjectgroupList;

        //$this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('class_id', "Subject " . $this->lang->line('type'), 'trim|required|xss_clean');
        
        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/exampattern/mh/classwiseSubjectMarkEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            
            $is_active = 0;
            if(isset($_POST['subject_id']) && !empty($_POST['subject_id']))
            {
                foreach($_POST['subject_id'] as $key => $sub_name)
                {
                    //@todo check for is exist
                    $data = array(
                        'class_id'   => $this->input->post('class_id'),
                        'subject_id' => $sub_name,
                        'subject_mark_type' => isset($_POST['mark_type'][$key]) ? $_POST['mark_type'][$key] : 0,
                        'max_mark' => isset($_POST['max_mark'][$key]) ? $_POST['max_mark'][$key] : 0,
                        'min_mark' => isset($_POST['min_mark'][$key]) ? $_POST['min_mark'][$key] : 0,
                        'aakarik_mark' => isset($_POST['aakarik_mark'][$key]) ? $_POST['aakarik_mark'][$key] : 0,
                        'sankalit_mark' => isset($_POST['sankalit_mark'][$key]) ? $_POST['sankalit_mark'][$key] : 0,
                        //'description'  => $this->input->post('description'),
                        'description'  => '',
                        'status'  => 1,
                        
                    );
                    $updated_id = updateData('exam_classwise_subjects_mark','id', $id, $data);
                }
            
                $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
                redirect('admin/exampattern/classwise_subject_mark');
            } else {
                $this->session->set_flashdata('msg', '<div class="alert alert-danger text-left">Invalid input. Please select subject and enter marks.</div>');
                redirect('admin/exampattern/classwise_subject_mark');
            }
            
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/exampattern/classwise_subject_mark');
        }
    }
    
    public function getSubjectByClass()
    {
        $class_id = $this->input->get('class_id');
        //$data     = $this->section_model->getClassBySection($class_id);
        $subjectgroupList = $this->subjectgroup_model->getByID();
        $subjects = array();
        if(valid($subjectgroupList) && !empty($subjectgroupList)){
            foreach($subjectgroupList as $subgrp){
                if(valid($subgrp->sections) && !empty($subgrp->sections)){
                    foreach ($subgrp->sections as $group_section_key => $group_section_value) {
                        if($group_section_value->class_id == $class_id){
                            foreach ($subgrp->group_subject as $group_subject_key => $group_subject_value) {
                                array_push($subjects, array('id' => $group_subject_value->subject_id, 'name' => $group_subject_value->name .' ('. $group_subject_value->type . ')'));
                            }
                            break;
                        }
                    }
                }
            }
        }
        echo json_encode($subjects);
    }
    
    public function delete_classwise_subject_mark($id)
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Delete Batch';
        $updated_id = updateData('exam_classwise_subjects_mark','id', $id, array('status' => 3));
        //$this->cbse_examgroup_model->remove($id);
        redirect('admin/exampattern/classwise_subject_mark');
    }
    
    public function class_subject_component()
    {
        //echo '<pre>';print_r($_POST);exit;
        if (!$this->rbac->hasPrivilege('exam_group', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'exam_pattern');
        $this->session->set_userdata('sub_menu', 'Examinations/exampattern');
        $data['title']      = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType']   = $this->exam_type;
        //$this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('class_id', "Subject " . $this->lang->line('type'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

        } else {
            $is_active = 0;
            //echo '<pre>';print_r($_POST);exit;
            if(isset($_POST['mark_dist_comp']) && !empty($_POST['mark_dist_comp']))
            {
                $mark_subject_components = get_list('exam_class_subjects_component', array('class_id' => $this->input->post('class_id'),'subject_id' => $this->input->post('subject_id'),'status' => 1), null, null, 0, 'id', 'ASC');
                if(valid($mark_subject_components) && !empty($mark_subject_components)){
                    $this->session->set_flashdata('msg', '<div class="alert alert-danger text-left">The marks distribution is already added for selected class & subject.</div>');
                    redirect('admin/exampattern/class_subject_component');
                    exit;
                }
                $mark_dist_comp = array();
                foreach($_POST['mark_dist_comp'] as $key => $compid)
                {
                    //@todo check for is exist
                    $mdtid = 0;
                    $mark = 0;
                    if(isset($_POST['aakcompmark_'.$compid])){
                        $mdtid = 1;
                        $mark = trim($_POST['aakcompmark_'.$compid]);
                    } elseif (isset($_POST['sankcompmark_'.$compid])) {
                        $mdtid = 3;
                        $mark = trim($_POST['sankcompmark_'.$compid]);
                    }
                    $markdata = array(
                        'mdtid' => $mdtid,
                        'mdcid' => $compid,
                        'mark' => $mark,
                    );
                    array_push($mark_dist_comp, $markdata);
                }
                $data = array(
                        'class_id'   => $this->input->post('class_id'),
                        'subject_id' => $this->input->post('subject_id'),
                        'remark_language' => isset($_POST['subject_remark_lang']) ? trim($_POST['subject_remark_lang']) : '',
                        'mdcid' => json_encode($mark_dist_comp),
                        //'description'  => '',
                        'status'  => 1,
                        
                    );
                $insert_id = insertData('exam_class_subjects_component', $data);
            
                $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
                redirect('admin/exampattern/class_subject_component');
            } else {
                $this->session->set_flashdata('msg', '<div class="alert alert-danger text-left">Invalid input. Please select subject and enter distribution marks.</div>');
                redirect('admin/exampattern/class_subject_component');
            }
            
        }
        //$examgroup_result      = $this->cbse_examgroup_model->get();
        $examgroup_result         = get_list('exam_classwise_subjects_mark', array('status' => 1), null, null, 0, 'id', 'ASC');
        $subjects                 = get_list('subjects', array(), null, null, 0, 'id', 'ASC');
        $data['examgrouplist']    = $examgroup_result;
        $data['subjects']         = $subjects;
        $menu_data['selected'] = 'class_subject_component';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        
        //$subject_list = $this->subject_model->get();
        //$data['subjectlist'] = $subject_list;
        $class = $this->class_model->get();
        $data['classlist'] = $class;
        $subjectgroupList = $this->subjectgroup_model->getByID();
        //echo '<pre>';
        //print_r($subjectgroupList);exit;
        $data['subjectgroupList'] = $subjectgroupList;
        
        $mark_dist_components = get_list('exam_mark_distribution_component', array('status' => 1), null, null, 0, 'id', 'ASC');
        $data['mark_dist_components'] = $mark_dist_components;
        $mark_subject_components = get_list('exam_class_subjects_component', array('status' => 1), null, null, 0, 'id', 'ASC');
        $data['mark_subject_components'] = $mark_subject_components;
//        $marks_dist_types         = get_list('exam_marks_distribution_type', array('status' => 1), null, null, 0, 'id', 'ASC');        
//        $data['marks_dist_types'] = $marks_dist_types;

        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/mh/classSubjectComponentList', $data);
        $this->load->view('layout/footer', $data);
    }
    
    public function getClassSubjectMarks()
    {
        $class_id = $this->input->get('class_id');
        $subject_id = $this->input->get('subject_id');
        //$data     = $this->section_model->getClassBySection($class_id);
        $examgroup             = get_single_row('exam_classwise_subjects_mark', array('class_id' => $class_id, 'subject_id' => $subject_id, 'status' => 1));
        if(!valid($examgroup) || empty($examgroup)){
            $array = array('status' => 'fail', 'message' => 'Subject marks not found, please add Subject Marks.');
            echo json_encode($array);
            exit;
        }
        // check if grade mark type
        if(valid($examgroup->subject_mark_type) && $examgroup->subject_mark_type == 2){
            $array = array('status' => 'fail', 'message' => 'Can not add marks distributions for Grade subjects, please select other subject.');
            echo json_encode($array);
            exit;
        }
        $data = array(
            'id' => $examgroup->id,
            'class_id' => $examgroup->class_id,
            'subject_id' => $examgroup->subject_id,
            'subject_mark_type' => $examgroup->subject_mark_type,
            'max_mark' => $examgroup->max_mark,
            'min_mark' => $examgroup->min_mark,
            'aakarik_mark' => $examgroup->aakarik_mark,
            'sankalit_mark' => $examgroup->sankalit_mark
        );
//        echo '<pre>';print_r($examgroup);exit;
        $array = array('status' => 'success', 'message' => '', 'data' => $data);
        echo json_encode($array);
        exit;
    }
    
    public function edit_class_subject_component($id)
    {
        if (!$this->rbac->hasPrivilege('exam', 'can_edit')) {
            access_denied();
        }

        $data['id']            = $id;
        //$examgroup             = $this->cbse_examgroup_model->get($id);
        $examgroup             = get_single_row('exam_class_subjects_component', array('id' => $id));
        
        $data['examgroup']     = $examgroup;
        $data['examType']      = $this->exam_type;
        //$examgroup_result      = $this->cbse_examgroup_model->get();
        $examgroup_result      = get_list('exam_classwise_subjects_mark', array('status' => 1), null, null, 0, 'id', 'ASC');
        $subjects              = get_list('subjects', array(), null, null, 0, 'id', 'ASC');
        $data['examgrouplist'] = $examgroup_result;
        $data['subjects'] = $subjects;
        
        $class = $this->class_model->get();
        $data['classlist'] = $class;
        $subjectgroupList = $this->subjectgroup_model->getByID();
        $data['subjectgroupList'] = $subjectgroupList;
        
        $mark_dist_components = get_list('exam_mark_distribution_component', array('status' => 1), null, null, 0, 'id', 'ASC');
        $data['mark_dist_components'] = $mark_dist_components;
        $mark_subject_components = get_list('exam_class_subjects_component', array('status' => 1), null, null, 0, 'id', 'ASC');
        $data['mark_subject_components'] = $mark_subject_components;
        $menu_data['selected'] = 'class_subject_component';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        
        //$this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('class_id', "Subject " . $this->lang->line('type'), 'trim|required|xss_clean');
        
        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/exampattern/mh/classSubjectComponentEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            
            $is_active = 0;
//            echo '<pre>';print_r($_POST);exit;
            if(isset($_POST['mark_dist_comp']) && !empty($_POST['mark_dist_comp']))
            {
                $mark_dist_comp = array();
                foreach($_POST['mark_dist_comp'] as $key => $compid)
                {
                    //@todo check for is exist
                    $mdtid = 0;
                    $mark = 0;
                    if(isset($_POST['aakcompmark_'.$compid])){
                        $mdtid = 1;
                        $mark = trim($_POST['aakcompmark_'.$compid]);
                    } elseif (isset($_POST['sankcompmark_'.$compid])) {
                        $mdtid = 3;
                        $mark = trim($_POST['sankcompmark_'.$compid]);
                    }
                    $markdata = array(
                        'mdtid' => $mdtid,
                        'mdcid' => $compid,
                        'mark' => $mark,
                    );
                    array_push($mark_dist_comp, $markdata);
                }
                $data = array(
                        'class_id'   => $this->input->post('class_id'),
                        'subject_id' => $this->input->post('subject_id'),
                        'remark_language' => isset($_POST['subject_remark_lang']) ? trim($_POST['subject_remark_lang']) : '',
                        'mdcid' => json_encode($mark_dist_comp),
                        //'description'  => '',
                        'status'  => 1,
                        
                    );
                $updated_id = updateData('exam_class_subjects_component','id', $id, $data);
            
                $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
                redirect('admin/exampattern/class_subject_component');
            } else {
                $this->session->set_flashdata('msg', '<div class="alert alert-danger text-left">Invalid input. Please select subject and enter distribution marks.</div>');
                redirect('admin/exampattern/class_subject_component');
            }
            
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/exampattern/class_subject_component');
        }
    }
    
    public function delete_class_subject_component($id)
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Delete Batch';
        $updated_id = updateData('exam_class_subjects_component','id', $id, array('status' => 3));
        //$this->cbse_examgroup_model->remove($id);
        redirect('admin/exampattern/class_subject_component');
    }
    
    public function scorecard_component()
    {
        //echo '<pre>';print_r($_POST);
        //print_r($_POST['name']);exit;
        if (!$this->rbac->hasPrivilege('exam_group', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'exam_pattern');
        $this->session->set_userdata('sub_menu', 'Examinations/exampattern');
        $data['title']      = 'Add Batch';
        $data['title_list'] = 'Recent Batch';
        $data['examType']   = $this->exam_type;
        $this->form_validation->set_rules('name[]', $this->lang->line('name'), 'trim|required|xss_clean');
        //$this->form_validation->set_rules('mark_dist_type', "Mark distribution " . $this->lang->line('type'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

        } else {
           // echo '<pre>';            print_r($_POST);exit;
            $is_active = 0;
            if(isset($_POST['name']) && !empty($_POST['name']))
            {
                $selgrades = array();
                $selcls = array();
                if(isset($_POST['grades']) && !empty($_POST['grades']))
                {
                    foreach($_POST['grades'] as $grd)
                    {
                        array_push($selgrades,$grd);
                    }
                }
                if(isset($_POST['class']) && !empty($_POST['class']))
                {
                    foreach($_POST['class'] as $cls)
                    {
                        array_push($selcls,$cls);
                    }
                }
                foreach($_POST['name'] as $comp_name)
                {
                    $data = array(
                        'component_name'    => $comp_name,
                        'subject_mark_grade'    => !empty($selgrades) ? json_encode($selgrades) : '',
                        'classes'    => !empty($selcls) ? json_encode($selcls) : '',
                        'status'  => 1,
//                        'description'  => $this->input->post('description'),
                    );
                    $insert_id = insertData('exam_scorecard_component', $data);
                }
            } 
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/exampattern/scorecard_component');
        }
        //$examgroup_result      = $this->cbse_examgroup_model->get();
        $examgroup_result         = get_list('exam_scorecard_component', array('status' => 1), null, null, 0, 'id', 'ASC');
        $marks_grades             = get_list('grades', array('is_active' => 'yes', 'exam_type' => 'school_grade_system'), null, null, 0, 'id', 'ASC');
        $data['examgrouplist']    = $examgroup_result;
        
        $class = $this->class_model->get();
        $data['classlist'] = $class;
        $data['grades'] = $marks_grades;
        $menu_data['selected'] = 'scorecard_component';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        
        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/mh/scorecardComponentList', $data);
        $this->load->view('layout/footer', $data);
    }
    
    public function edit_scorecard_component($id)
    {
        if (!$this->rbac->hasPrivilege('exam', 'can_edit')) {
            access_denied();
        }

        $data['id']            = $id;
        //$examgroup             = $this->cbse_examgroup_model->get($id);
        $examgroup             = get_single_row('exam_scorecard_component', array('id' => $id));
        $data['examgroup']     = $examgroup;
        $data['examType']      = $this->exam_type;
        //$examgroup_result      = $this->cbse_examgroup_model->get();
        $examgroup_result         = get_list('exam_scorecard_component', array('status' => 1), null, null, 0, 'id', 'ASC');
        $marks_grades             = get_list('grades', array('is_active' => 'yes', 'exam_type' => 'school_grade_system'), null, null, 0, 'id', 'ASC');
        $data['examgrouplist']    = $examgroup_result;
        
        $class = $this->class_model->get();
        $data['classlist'] = $class;
        $data['grades'] = $marks_grades;
        
        $menu_data['selected'] = 'scorecard_component';
        $data['top_menu_option'] = $this->load->view('admin/exampattern/mh/topMenuOptions', $menu_data, true);
        
        $this->form_validation->set_rules('name[]', $this->lang->line('name'), 'trim|required|xss_clean');
        //$this->form_validation->set_rules('mark_dist_type', "Mark distribution " . $this->lang->line('type'), 'trim|required|xss_clean');
        
        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/exampattern/mh/scorecardComponentEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $is_active = 1;
            if(isset($_POST['name']) && !empty($_POST['name']))
            {
                $selgrades = array();
                $selcls = array();
                if(isset($_POST['grades']) && !empty($_POST['grades']))
                {
                    foreach($_POST['grades'] as $grd)
                    {
                        array_push($selgrades,$grd);
                    }
                }
                if(isset($_POST['class']) && !empty($_POST['class']))
                {
                    foreach($_POST['class'] as $cls)
                    {
                        array_push($selcls,$cls);
                    }
                }
                foreach($_POST['name'] as $comp_name)
                {
                    $data = array(
                        'component_name'    => $comp_name,
                        'subject_mark_grade'    => !empty($selgrades) ? json_encode($selgrades) : '',
                        'classes'    => !empty($selcls) ? json_encode($selcls) : '',
                        'status'  => 1,
//                        'description'  => $this->input->post('description'),
                    );
                    $updated_id = updateData('exam_scorecard_component','id', $id, $data);
                }
            }
            
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/exampattern/scorecard_component');
        }
    }
    
    public function delete_scorecard_component($id)
    {
        if (!$this->rbac->hasPrivilege('exam_group', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Delete Batch';
        $updated_id = updateData('exam_scorecard_component','id', $id, array('status' => 3));
        //$this->cbse_examgroup_model->remove($id);
        redirect('admin/exampattern/scorecard_component');
    }

    public function homework_report()
    {

        // error_reporting(E_ALL);
        // ini_set('display_errors', 1);


        $this->session->set_userdata('top_menu', 'Reports');
        $this->session->set_userdata('sub_menu', 'Reports/cbse_examinations');
        $this->session->set_userdata('subsub_menu', 'Reports/cbse_examinations/homework_report');
        
        $data['classlist'] = $this->Class_model->get();
        $data['subjectlist'] = $this->subject_model->get();
        $data['sessionlist'] = $this->session_model->get();
        $data['sch_setting'] = $this->sch_setting_detail;

        $this->form_validation->set_rules('class_id', "Class",'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', "Section", 'trim|required|xss_clean');
        $this->form_validation->set_rules('subject_id', "Subject", 'trim|required|xss_clean');
        $this->form_validation->set_rules('month', "Month", 'trim|required|xss_clean');
        $this->form_validation->set_rules('session_id', "Session", 'trim|required|xss_clean');

        if ($this->form_validation->run()) {
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $subject_id = $this->input->post('subject_id');
            $month = $this->input->post('month');
            $session_id = $this->input->post('session_id');
            $data['section_id'] = $section_id;
            $data['session_id'] = $session_id;

            // Fetch assessment results based on selected filters
            // $data['assessment_results'] = $this->cbse_examsubject_model->get_assessment_results($class_id, $section_id, $subject_id, $month,$session_id);
            $data['studentlist'] = $this->cbse_examsubject_model->get_students_by_class_section($class_id, $section_id,$session_id);
            // print_r($data['studentlist']); die();
            $data['post_class_id'] = $class_id;
            $data['post_section_id'] = $section_id;
            $data['post_subject_id'] = $subject_id;
            $data['post_month'] = $month;
            $data['post_session_id'] = $session_id;


            
        }

        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/cbse/homework_report', $data);
        $this->load->view('layout/footer', $data);
    }

    public function print_homeworkreport()
    {
        $post_class_id = $this->input->post('post_class_id');
        $post_section_id = $this->input->post('post_section_id');
        $post_subject_id = $this->input->post('post_subject_id');
        $post_month = $this->input->post('post_month');
        $post_session_id = $this->input->post('post_session_id');
        $select_student_id = $this->input->post('select_student_id');
        $sessionData = $this->session_model->get($post_session_id);
        $data['session_name'] = $sessionData['session'];

        // Form validation
        $this->form_validation->set_rules('post_class_id', $this->lang->line('class'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_section_id', $this->lang->line('section'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_subject_id', $this->lang->line('subject'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_month', $this->lang->line('month'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_session_id', $this->lang->line('session'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('select_student_id[]', $this->lang->line('student'), 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'post_class_id' => form_error('post_class_id'),
                'post_section_id' => form_error('post_section_id'),
                'post_subject_id' => form_error('post_subject_id'),
                'post_month' => form_error('post_month'),
                'post_session_id' => form_error('post_session_id'),
                'select_student_id' => form_error('select_student_id'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {
            // Fetch assessment results for the selected students
            $classData = $this->Class_model->get($post_class_id);
            $sectionData = $this->section_model->get($post_section_id);
            $subjectData = $this->subject_model->get($post_subject_id);
            $data['class_name'] = $classData['class'];
            $data['section_name'] = $sectionData['section'];
            $data['subject_name'] = $subjectData['name'];
            $assessment_results = $this->cbse_examsubject_model->get_assessment_results(
                $post_class_id, 
                $post_section_id, 
                $post_subject_id, 
                $post_month, 
                $post_session_id, 
                $select_student_id
            );

            // Extract unique assessment_type_ids from assessments inside $assessment_results
            $assessment_type_ids = [];

            foreach ($assessment_results as $student) {
                if (!empty($student['assessments'])) {
                    foreach ($student['assessments'] as $assessment) {
                        $assessment_type_ids[] = $assessment['assessment_type_id'];
                    }
                }
            }

            // Remove duplicates
            $assessment_type_ids = array_unique($assessment_type_ids);

            $assessment_types = [];
            $assessments = [];

            if (!empty($assessment_type_ids)) {
                // Fetch only relevant assessment types
                $this->db->where_in('id', $assessment_type_ids);
                $this->db->where('status', 1);
                $query = $this->db->get('assessment_types');
                $assessment_types = $query->result(); // Fetch as array

                // Fetch assessments based on valid assessment_type_ids
                // $this->db->where_in('assessment_type_id', $assessment_type_ids);
                // $query = $this->db->get('assessments');
                // $assessments = $query->result(); // Fetch as array
            }

            $this->db->where('class_id', $post_class_id);
                $this->db->where('section_id', $post_section_id);
                $this->db->where('subject_id', $post_subject_id);
                $this->db->where('session_id', $post_session_id);
                $query = $this->db->get('assessments');
                $assessments = $query->result();


            // print_r($assessments); die();



            $data['assessment_types'] = $assessment_types;
            $data['month'] = $post_month;
            $data['assessments'] = $assessments;
            $data['assessment_results'] = $assessment_results;
            

            $student_exam_page = $this->load->view('admin/exampattern/cbse/_homeworkreport', $data, true);
            $array = array('status' => '1', 'error' => '', 'page' => $student_exam_page);
            echo json_encode($array);
        }
    }


    public function PeriodicTest_report()
    {

        // error_reporting(E_ALL);
        // ini_set('display_errors', 1);


        $this->session->set_userdata('top_menu', 'Reports');
        $this->session->set_userdata('sub_menu', 'Reports/cbse_examinations');
        $this->session->set_userdata('subsub_menu', 'Reports/cbse_examinations/periodictest_report');
        
        $data['classlist'] = $this->Class_model->get();
        $examgroup_result = $this->cbse_examgroup_model->get();

        // print_r($examgroup_result); die();

        $data['examgrouplist'] = $examgroup_result;
        $data['sessionlist'] = $this->session_model->get();
        $data['sch_setting'] = $this->sch_setting_detail;

        $this->form_validation->set_rules('class_id', "Class",'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', "Section", 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_group_id', "Subject", 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_id', "Subject", 'trim|required|xss_clean');
        $this->form_validation->set_rules('session_id', "Session", 'trim|required|xss_clean');

        if ($this->form_validation->run()) {
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $exam_group_id = $this->input->post('exam_group_id');
            $exam_id = $this->input->post('exam_id');
            $session_id = $this->input->post('session_id');
            $data['section_id'] = $section_id;
            $data['session_id'] = $session_id;

            // Fetch assessment results based on selected filters
            // $data['assessment_results'] = $this->cbse_examsubject_model->get_assessment_results($class_id, $section_id, $subject_id, $month,$session_id);
            $data['studentlist'] = $this->cbse_examstudent_model->getExamStudents($class_id, $section_id,$exam_id,$session_id);
            // print_r($data['studentlist']); die();
            $data['post_class_id'] = $class_id;
            $data['post_section_id'] = $section_id;
            $data['post_exam_group_id'] = $exam_group_id;
            $data['post_exam_id'] = $exam_id;
            $data['post_session_id'] = $session_id;


            
        }

        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/cbse/periodictest_report', $data);
        $this->load->view('layout/footer', $data);
    }

    public function print_PeriodicTestreport()
    {
        
        $post_class_id = $this->input->post('post_class_id');
        $post_section_id = $this->input->post('post_section_id');
        $post_exam_group_id = $this->input->post('post_exam_group_id');
        $post_exam_id = $this->input->post('post_exam_id');
        $post_session_id = $this->input->post('post_session_id');
        $select_student_id = $this->input->post('onlineexam_student_id');
        $sessionData = $this->session_model->get($post_session_id);
        $data['session_name'] = $sessionData['session'];


        // Form validation
        $this->form_validation->set_rules('post_class_id', $this->lang->line('class'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_section_id', $this->lang->line('section'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_exam_group_id', $this->lang->line('exam_group'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_exam_id', $this->lang->line('exam'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_session_id', $this->lang->line('session'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('onlineexam_student_id[]', $this->lang->line('student'), 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'post_class_id' => form_error('post_class_id'),
                'post_section_id' => form_error('post_section_id'),
                'post_exam_group_id' => form_error('post_exam_group_id'),
                'post_exam_id' => form_error('post_exam_id'),
                'post_session_id' => form_error('post_session_id'),
                'select_student_id' => form_error('select_student_id'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {
            // Fetch assessment results for the selected students
            $classData = $this->Class_model->get($post_class_id);
            $sectionData = $this->section_model->get($post_section_id);
            $exam_data = $this->cbse_examgroup_model->getExamByID($post_exam_id);
            $data['exam_name'] = $exam_data->exam;
            $data['class_name'] = $classData['class'];
            $data['section_name'] = $sectionData['section'];
            $exam_result = $this->cbse_examresult_model->getStudentResultByGroupExam(
                $post_exam_id, 
                $select_student_id
            );
            $data['class_teacher'] = $this->Classteacher_model->getteacherByClassSection($post_class_id,$post_section_id);
            // print_r($this->db->last_query()); die;
            
            
                
            
            $data['exam_result'] = $exam_result;
            $data['sch_setting'] = $this->sch_setting_detail;
            
            

            $student_exam_page = $this->load->view('admin/exampattern/cbse/_periodictest_report', $data, true);
            $array = array('status' => '1', 'error' => '', 'page' => $student_exam_page);
            echo json_encode($array);
        }
    }



    public function slip_report()
    {

        // error_reporting(E_ALL);
        // ini_set('display_errors', 1);


        $this->session->set_userdata('top_menu', 'Reports');
        $this->session->set_userdata('sub_menu', 'Reports/cbse_examinations');
        $this->session->set_userdata('subsub_menu', 'Reports/cbse_examinations/slip_report');
        
        $data['classlist'] = $this->Class_model->get();
        $examgroup_result = $this->cbse_examgroup_model->get();

        // print_r($examgroup_result); die();

        $data['examgrouplist'] = $examgroup_result;
        $data['sessionlist'] = $this->session_model->get();
        $data['sch_setting'] = $this->sch_setting_detail;

        $this->form_validation->set_rules('class_id', "Class",'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', "Section", 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_group_id', "Subject", 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_id', "Subject", 'trim|required|xss_clean');
        $this->form_validation->set_rules('session_id', "Session", 'trim|required|xss_clean');

        if ($this->form_validation->run()) {
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $exam_group_id = $this->input->post('exam_group_id');
            $exam_id = $this->input->post('exam_id');
            $session_id = $this->input->post('session_id');
            $data['section_id'] = $section_id;
            $data['session_id'] = $session_id;

            // Fetch assessment results based on selected filters
            // $data['assessment_results'] = $this->cbse_examsubject_model->get_assessment_results($class_id, $section_id, $subject_id, $month,$session_id);
            $data['studentlist'] = $this->cbse_examstudent_model->getExamStudents($class_id, $section_id,$exam_id,$session_id);
            // print_r($data['studentlist']); die();
            $data['post_class_id'] = $class_id;
            $data['post_section_id'] = $section_id;
            $data['post_exam_group_id'] = $exam_group_id;
            $data['post_exam_id'] = $exam_id;
            $data['post_session_id'] = $session_id;


            
        }

        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/cbse/slip_report', $data);
        $this->load->view('layout/footer', $data);
    }

    public function print_slip_report()
    {
        $post_class_id = $this->input->post('post_class_id');
        $post_section_id = $this->input->post('post_section_id');
        $post_exam_group_id = $this->input->post('post_exam_group_id');
        $post_exam_id = $this->input->post('post_exam_id');
        $post_session_id = $this->input->post('post_session_id');
        $select_student_id = $this->input->post('onlineexam_student_id');
        $sessionData = $this->session_model->get($post_session_id);
        $data['session_name'] = $sessionData['session'];


        // Form validation
        $this->form_validation->set_rules('post_class_id', $this->lang->line('class'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_section_id', $this->lang->line('section'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_exam_group_id', $this->lang->line('exam_group'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_exam_id', $this->lang->line('exam'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_session_id', $this->lang->line('session'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('onlineexam_student_id[]', $this->lang->line('student'), 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'post_class_id' => form_error('post_class_id'),
                'post_section_id' => form_error('post_section_id'),
                'post_exam_group_id' => form_error('post_exam_group_id'),
                'post_exam_id' => form_error('post_exam_id'),
                'post_session_id' => form_error('post_session_id'),
                'select_student_id' => form_error('select_student_id'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {
            // Fetch assessment results for the selected students
            $classData = $this->Class_model->get($post_class_id);
            $sectionData = $this->section_model->get($post_section_id);
            $exam_data = $this->cbse_examgroup_model->getExamByID($post_exam_id);
            $data['exam_name'] = $exam_data->exam;
            $data['class_name'] = $classData['class'];
            $data['section_name'] = $sectionData['section'];
            $exam_result = $this->cbse_examresult_model->getStudentResultByGroupExam(
                $post_exam_id, 
                $select_student_id
            );
            
                
            
            $data['exam_result'] = $exam_result;
            $data['sch_setting'] = $this->sch_setting_detail;
            // print_r($exam_result); die();
            

            $student_exam_page = $this->load->view('admin/exampattern/cbse/_slip_report', $data, true);
            $array = array('status' => '1', 'error' => '', 'page' => $student_exam_page);
            echo json_encode($array);
        }
    }


    public function Term_report()
    {

        // error_reporting(E_ALL);
        // ini_set('display_errors', 1);


        $this->session->set_userdata('top_menu', 'Reports');
        $this->session->set_userdata('sub_menu', 'Reports/cbse_examinations');
        $this->session->set_userdata('subsub_menu', 'Reports/cbse_examinations/Term_report');
        
        $data['classlist'] = $this->Class_model->get();
        $examgroup_result = $this->cbse_examgroup_model->get();

        // print_r($examgroup_result); die();

        $data['examgrouplist'] = $examgroup_result;
        $data['sessionlist'] = $this->session_model->get();
        $data['sch_setting'] = $this->sch_setting_detail;

        $this->form_validation->set_rules('class_id', "Class",'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', "Section", 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_group_id', "Subject", 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_id', "Subject", 'trim|required|xss_clean');
        $this->form_validation->set_rules('session_id', "Session", 'trim|required|xss_clean');

        if ($this->form_validation->run()) {
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $exam_group_id = $this->input->post('exam_group_id');
            $exam_id = $this->input->post('exam_id');
            $session_id = $this->input->post('session_id');
            $data['section_id'] = $section_id;
            $data['session_id'] = $session_id;

            // Fetch assessment results based on selected filters
            // $data['assessment_results'] = $this->cbse_examsubject_model->get_assessment_results($class_id, $section_id, $subject_id, $month,$session_id);
            $data['studentlist'] = $this->cbse_examstudent_model->getExamStudents($class_id, $section_id,$exam_id,$session_id);
            // print_r($data['studentlist']); die();
            $data['post_class_id'] = $class_id;
            $data['post_section_id'] = $section_id;
            $data['post_exam_group_id'] = $exam_group_id;
            $data['post_exam_id'] = $exam_id;
            $data['post_session_id'] = $session_id;


            
        }

        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/cbse/termreport', $data);
        $this->load->view('layout/footer', $data);
    }


    public function print_term_report()
    {
        $post_class_id = $this->input->post('post_class_id');
        $post_section_id = $this->input->post('post_section_id');
        $post_exam_group_id = $this->input->post('post_exam_group_id');
        $post_exam_id = $this->input->post('post_exam_id');
        $post_session_id = $this->input->post('post_session_id');
        $select_student_id = $this->input->post('onlineexam_student_id');
        $sessionData = $this->session_model->get($post_session_id);
        $data['session_name'] = $sessionData['session'];


        // Form validation
        $this->form_validation->set_rules('post_class_id', $this->lang->line('class'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_section_id', $this->lang->line('section'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_exam_group_id', $this->lang->line('exam_group'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_exam_id', $this->lang->line('exam'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_session_id', $this->lang->line('session'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('onlineexam_student_id[]', $this->lang->line('student'), 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'post_class_id' => form_error('post_class_id'),
                'post_section_id' => form_error('post_section_id'),
                'post_exam_group_id' => form_error('post_exam_group_id'),
                'post_exam_id' => form_error('post_exam_id'),
                'post_session_id' => form_error('post_session_id'),
                'select_student_id' => form_error('select_student_id'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {
            // Fetch assessment results for the selected students
            $classData = $this->Class_model->get($post_class_id);
            $sectionData = $this->section_model->get($post_section_id);
            $exam_data = $this->cbse_examgroup_model->getExamByID($post_exam_id);
            $data['exam_name'] = $exam_data->exam;
            $data['class_name'] = $classData['class'];
            $data['section_name'] = $sectionData['section'];
            $exam_result = $this->cbse_examresult_model->getStudentResultByGroupExam(
                $post_exam_id, 
                $select_student_id
            );
            
                
            
            $data['exam_result'] = $exam_result;
            $data['sch_setting'] = $this->sch_setting_detail;
            // echo '<pre>';
            // print_r($exam_result); die();
            

            $student_exam_page = $this->load->view('admin/exampattern/cbse/_print_termreport', $data, true);
            $array = array('status' => '1', 'error' => '', 'page' => $student_exam_page);
            echo json_encode($array);
        }
    }



    public function Final_report()
    {
        // error_reporting(E_ALL);
        // ini_set('display_errors',1);
        $this->session->set_userdata('top_menu', 'Reports');
        $this->session->set_userdata('sub_menu', 'Reports/cbse_examinations');
        $this->session->set_userdata('subsub_menu', 'Reports/cbse_examinations/Final_report');
        
        $data['classlist'] = $this->Class_model->get();
        $examgroup_result = $this->cbse_examgroup_model->get();

        // print_r($examgroup_result); die();

        $data['examgrouplist'] = $examgroup_result;
        $data['sessionlist'] = $this->session_model->get();
        $data['sch_setting'] = $this->sch_setting_detail;

        
        $this->form_validation->set_rules('section_id', "Section", 'trim|required|xss_clean');
        $this->form_validation->set_rules('exam_group_id[]', "Exam Group", 'trim|required|xss_clean');
        $this->form_validation->set_rules('class_id', "Class", 'trim|required|xss_clean');
        $this->form_validation->set_rules('session_id', "Session", 'trim|required|xss_clean');

        if ($this->form_validation->run()) {
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');

            $exam_group_id = $this->input->post('exam_group_id');
            $session_id = $this->input->post('session_id');
            $data['section_id'] = $section_id;
            $data['session_id'] = $session_id;
            $session_data = $this->session_model->get($session_id);
            $exam_data = $this->cbse_examgroup_model->getExamsByExamGroups($exam_group_id,'yes');
            $exam_ids = [];
            foreach ($exam_data as $exam) {
                $exam_ids[] = $exam->id;
            }
            if(!empty($exam_ids)){
            $data['studentlist'] = $this->cbse_examstudent_model->searchCbseExamStudents($exam_ids,$class_id, $section_id,$session_id);
            }else{
                $data['studentlist'] = array();
            }
            
            $student_present_days = array();
            $sch_working_days = array();
            
            foreach($data['studentlist'] as $student_value){
            
                $student_session_id = $student_value->student_session_id;
            
                $session_year = explode('-',$session_data['session'])[0]; // e.g. 2024
                $start_year   = $session_year;
                $end_year     = $session_year + 1;
            
                // Define session months
                $session_months = [
                    ['month' => 6,  'year' => $start_year],
                    ['month' => 7,  'year' => $start_year],
                    ['month' => 8,  'year' => $start_year],
                    ['month' => 9,  'year' => $start_year],
                    ['month' => 10, 'year' => $start_year],
                    ['month' => 11, 'year' => $start_year],
                    ['month' => 12, 'year' => $start_year],
                    ['month' => 1,  'year' => $end_year],
                    ['month' => 2,  'year' => $end_year],
                    ['month' => 3,  'year' => $end_year],
                    ['month' => 4,  'year' => $end_year],
                    ['month' => 5,  'year' => $end_year],
                ];
            
                // Initialize
                $term1_working_days = $term2_working_days = 0;
                $term1_present_days = $term2_present_days = 0;
            
                foreach ($session_months as $sm) {
                    $month  = $sm['month'];
                    $year   = $sm['year'];
            
                    // Working days for this month
                    $this->db->select('COUNT(DISTINCT date) as total');
                    $this->db->from('student_attendences');
                    $this->db->where('MONTH(date)', $month);
                    $this->db->where('YEAR(date)', $year);
                    $query = $this->db->get();
                    $res = $query->row();
                    $month_working = ($res ? $res->total : 0);
            
                    // Present days for this month
                    $month_present = 0;
                    foreach ($this->config_attendance as $att_key => $att_value) {
                        if(strtolower($att_key) != 'absent'){
                            $month_present += $this->stuattendence_model->count_attendance_obj_total(
                                $month,
                                $year,
                                $student_session_id,
                                $att_value
                            );
                        }
                    }
            
                    // Split into terms
                    if (in_array($month, [6,7,8,9])) {  // Term 1
                        $term1_working_days += $month_working;
                        $term1_present_days += $month_present;
                    } else {                            // Term 2
                        $term2_working_days += $month_working;
                        $term2_present_days += $month_present;
                    }
                }
            
                // Save in arrays (per student)
                $student_present_days[$student_value->student_id] = [
                    'term1' => $term1_present_days,
                    'term2' => $term2_present_days,
                    'total' => $term1_present_days + $term2_present_days
                ];
            
                $sch_working_days[$student_value->student_id] = [
                    'term1' => $term1_working_days,
                    'term2' => $term2_working_days,
                    'total' => $term1_working_days + $term2_working_days
                ];
            }
            
            
            
            $data['student_present_days'] = $student_present_days;
            $data['sch_working_days'] = $sch_working_days;

            
            $data['post_class_id'] = $class_id;
            $data['post_section_id'] = $section_id;
            $data['post_exam_group_id'] = $exam_group_id;
            $data['post_exam_ids'] = $exam_ids;
            $data['post_session_id'] = $session_id;


            
        }

        $this->load->view('layout/header', $data);
        $this->load->view('admin/exampattern/cbse/finalreport', $data);
        $this->load->view('layout/footer', $data);
    }



    public function print_final_report()
    {
        $post_class_id = $this->input->post('post_class_id');
        $post_section_id = $this->input->post('post_section_id');

        // $post_exam_group_id = $this->input->post('post_exam_group_id');
        $post_exam_ids = $this->input->post('post_exam_id');
        $post_session_id = $this->input->post('post_session_id');
        $select_student_id = $this->input->post('select_student_id');
        $sessionData = $this->session_model->get($post_session_id);
        $data['session_name'] = $sessionData['session'];
        

        


        // Form validation
        $this->form_validation->set_rules('post_class_id', $this->lang->line('class'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_section_id', $this->lang->line('section'), 'required|trim|xss_clean');
        // $this->form_validation->set_rules('post_exam_group_id', $this->lang->line('exam_group'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_exam_id', $this->lang->line('exam'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('post_session_id', $this->lang->line('session'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('select_student_id[]', $this->lang->line('student'), 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'post_class_id' => form_error('post_class_id'),
                'post_section_id' => form_error('post_section_id'),
                // 'post_exam_group_id' => form_error('post_exam_group_id'),
                'post_exam_id' => form_error('post_exam_id'),
                'post_session_id' => form_error('post_session_id'),
                'select_student_id' => form_error('select_student_id'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {
            // Fetch assessment results for the selected students
            $classData = $this->Class_model->get($post_class_id);
            $sectionData = $this->section_model->get($post_section_id);

            $assessments = $this->cbse_examgroup_model->getUsedAssessmentTypes($post_class_id,$post_section_id);

            
            // $exam_data = $this->cbse_examgroup_model->getExamByID($post_exam_id);
            // $data['exam_name'] = $exam_data->exam;
            $data['class_name'] = $classData['class'];
            $data['assessment_types'] = $assessments;
            $data['section_name'] = $sectionData['section'];
            $data['sch_term1_working_days'] = $this->input->post('sch_term1_working_days');
        $data['sch_term2_working_days'] = $this->input->post('sch_term2_working_days');
        $data['student_term1_present_days'] = $this->input->post('student_term1_present_days');
        $data['student_term2_present_days'] = $this->input->post('student_term2_present_days');
            
            $exam_result = $this->cbse_examresult_model->getStudentFinalResultByGroupExam(
                $post_exam_ids,
                $select_student_id);

            // print_r($exam_result); die;
                
            
            $data['exam_result'] = $exam_result;

            $exam_grades = $this->grade_model->getByExamType('basic_system');
            $data['exam_grades'] = $exam_grades;
            $data['sch_setting'] = $this->sch_setting_detail;
            // echo '<pre>';
            // print_r($data['sch_setting']); die();
            

            $student_exam_page = $this->load->view('admin/exampattern/cbse/_print_finalreport', $data, true);
            $array = array('status' => '1', 'error' => '', 'page' => $student_exam_page);
            echo json_encode($array);
        }
    }



    
    
}