<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class ChangeLog extends Admin_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('form_validation');

        $this->load->model("ChangeLog_model");
    }

    public function index() {
 
      $developers=   $this->config->item('devoper_name');

    // Get the config item


        
        $this->session->set_userdata('top_menu', 'front_office');
        $this->session->set_userdata('sub_menu', 'admin/gatepass');
        $this->form_validation->set_rules('developerName','Developer Name ', 'required');
        $this->form_validation->set_rules('current_version','Current Version ', 'required');
        $this->form_validation->set_rules('latest_version_name','Latest Version Name', 'required');
        $this->form_validation->set_rules('type','Type ', 'required');
        $this->form_validation->set_rules('status','Status', 'required');
        $this->form_validation->set_rules('note','Description ', 'required');
        
        if ($this->form_validation->run() == FALSE) {
            $data['DispatchList'] = $this->ChangeLog_model->list();
            $this->load->view('layout/header');
            $this->load->view('admin/frontoffice/changeLogview', $data);
            $this->load->view('layout/footer');
        } else {

            $changelogs_arr = array(
                'developerName' => $this->input->post('developerName'),
                'current_version' => $this->input->post('current_version'),
                'latest_version_name' => $this->input->post('latest_version_name'),
                'type' => $this->input->post('type'),
                'status' => $this->input->post('status'),
                'note' => $this->input->post('note'),
               'created_at'=>date('Y-m-d H:i:s'),
                'updated_at'=>date('Y-m-d H:i:s')
            
            );
         

           $this->ChangeLog_model->insert('changelogs', $changelogs_arr);

            $this->session->set_flashdata('msg', '<div class="alert alert-success">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/ChangeLog');
        }
    }


    public function getStaffOrStudents() {
        $type = $this->input->post('type'); // Get the selected type
        
        if ($type == 'student') {
            $data = $this->student_model->get(); 
        } else {
            $data = $this->staff_model->get(); 
        }
        
        echo json_encode($data); // Send the data back as JSON
    }


    function edit($id) {
        

        $this->form_validation->set_rules('developerName','Developer Name ', 'required');
        $this->form_validation->set_rules('current_version','Current Version ', 'required');
        $this->form_validation->set_rules('latest_version_name','Latest Version Name', 'required');
        $this->form_validation->set_rules('type','Type ', 'required');
        $this->form_validation->set_rules('status','Status', 'required');
        $this->form_validation->set_rules('note','Description ', 'required');
        if ($this->form_validation->run() == FALSE) {
            $data['id']=$id;
            $data['DispatchList'] = $this->ChangeLog_model->list();
            $data['Gatepass_data'] = $this->ChangeLog_model->dis_rec_data($id);

            $this->load->view('layout/header');
            $this->load->view('admin/frontoffice/editChangeLogView', $data);
            $this->load->view('layout/footer');
        } else {
            $id;

           $changelogs_arr = array(
                'developerName' => $this->input->post('developerName'),
                'current_version' => $this->input->post('current_version'),
                'latest_version_name' => $this->input->post('latest_version_name'),
                'type' => $this->input->post('type'),
                'status' => $this->input->post('status'),
                'note' => $this->input->post('note'),
                'updated_at'=>date('Y-m-d H:i:s')
            
            );
           

            $this->ChangeLog_model->update('changelogs', $id, $changelogs_arr);

            

            $this->session->set_flashdata('msg', '<div class="alert alert-success">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/changeLog');
        }
    }

    

    public function delete($id) {
     
        $this->ChangeLog_model->delete($id);
    }

    public function getPassDetails()
    {
        $id = $this->input->post('id');
        $data = $this->ChangeLog_model->list($id);

        echo json_encode(['gatepass'=>$data]);

    }

    

}
