<?php 
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Bulletin extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model("classteacher_model");
        $this->load->model("Staff_model");
        $this->load->model("substitute_model");
        $this->load->library('Enc_lib');
        $this->sch_setting_detail = $this->setting_model->getSetting();
    }

    public function substitute_teachers()
    {
        // error_reporting(E_ALL);
        // ini_set('display_errors', 1);
        $day = (date('l')); // Example: "monday"
        $today = date('Y-m-d');

        // Fetch teachers who are on leave today
        $this->db->where("'$today' BETWEEN leave_from AND leave_to", null, false);
        $this->db->join('staff','staff.id = staff_leave_request.staff_id');
        $this->db->join('staff_roles','staff_roles.staff_id = staff.id');
        $this->db->where('staff_roles.role_id', 2);
        $on_leave = $this->db->get('staff_leave_request')->result();
        
        // print_r($on_leave); die;
    
        $substitutes = [];
    
        foreach ($on_leave as $leave) {
            $staff_id = $leave->staff_id;
            
            $teacher = $this->staff_model->get($staff_id);
          
            $leave_teacher_name = $teacher['name'] . ' ' . $teacher['surname'];
    
            // 2. Get this teacher's timetable for the day
            $leave_periods = $this->db
                            ->where('day', $day)
                            ->where('teacher_id', $staff_id)
                            ->where('subject_id >=', 0)
                            ->get('class_timeline')
                            ->result();

    
            foreach ($leave_periods as $period) {
                $start_time = $period->time_from;
                $end_time = $period->time_to;
    
                // 3. Get busy teachers during this time slot (time overlap check)
                $busy_teachers_query = "
                    SELECT DISTINCT teacher_id FROM class_timeline
                    WHERE day = ?
                    AND (
                            (STR_TO_DATE(time_from, '%h:%i %p') < STR_TO_DATE(?, '%h:%i %p')
                            AND STR_TO_DATE(time_to, '%h:%i %p') > STR_TO_DATE(?, '%h:%i %p'))
                    )
                ";
    
                $busy_teachers = $this->db->query($busy_teachers_query, [$day, $end_time, $start_time])->result_array();
                $busy_ids = array_column($busy_teachers, 'teacher_id');
    
                // 4. Get available teachers (not busy)
                $this->db->select('staff.name, staff.surname, staff.id as staff_id');
                $this->db->from('staff');
                $this->db->join('staff_roles','staff_roles.staff_id = staff.id');
                $this->db->where('staff_roles.role_id', 2);
                if (!empty($busy_ids)) {
                    $this->db->where_not_in('staff.id', $busy_ids);
                }
    
                $available_teachers = $this->db->get()->result();

                $class_name = $this->class_model->get($period->class_id);
                $class_section = $this->classsection_model->get_class_section($period->section_id);
                
                $section_name = $class_section->section;
                $subject_name = $this->subjectgroup_model->getsubjectbyid($period->subject_id); 
                
                
                $assignment = $this->db->where([
                    'date' => $today,
                    'class_id' => $period->class_id,
                    'section_id' => $class_section->section_id,
                    'subject_group_subject_id' => $period->subject_id,
                    'period_start' => date('H:i:s', strtotime($start_time)),
                    'period_end' => date('H:i:s', strtotime($end_time)),
                ])->get('substitute_teacher_assignments')->row();
                
                $assigned_teacher = null;
                if ($assignment) {
                    $assigned_teacher = $this->staff_model->get($assignment->substitute_staff_id);
                }

    
                $substitutes[] = [
                    'leave_teacher_name' => $leave_teacher_name,
                    'leave_staff_id' => $staff_id,
                    'class_id' => $period->class_id,
                    'day' => $day,
                    'section_id' => $class_section->section_id,
                    'start_time'         => $start_time,
                    'end_time'           => $end_time,
                    'class'              => $class_name['class'],
                    'section'            => $section_name,
                    'subject'            => $subject_name->name,
                    'subject_group_subject_id' => $period->subject_id,
                    'available_teachers' => $available_teachers,
                    'assigned_teacher'       => $assigned_teacher
                ];
    
               
            }
        }
        
        // print_r($substitutes); die;
        
       
        $data['substitutes'] = $substitutes;
        $menu_data['selected'] = 'bulletin'; 
        $data['top_menu_option'] = $this->load->view('admin/teacher/topMenuOptions', $menu_data, true);
       
         $this->load->view('layout/header', $data);
         $this->load->view('admin/bulletin/index',$data);
         $this->load->view('layout/footer', $data);
    
        
    }
    
    
    
    public function assign_substitute_teacher()
    {
        $data = [
            'date' => $this->input->post('date'),
            'day' => $this->input->post('day'),
            'class_id' => $this->input->post('class_id'),
            'section_id' => $this->input->post('section_id'),
            'subject_group_subject_id' => $this->input->post('subject_group_subject_id'),
            'period_start' => date('H:i:s', strtotime($this->input->post('start_time'))),
            'period_end' => date('H:i:s', strtotime($this->input->post('end_time'))),
            'leave_staff_id' => $this->input->post('leave_staff_id'),
            'substitute_staff_id' => $this->input->post('substitute_staff_id'),
        ];
        
        $classData = $this->class_model->get($this->input->post('class_id'));
        $sectionData = $this->section_model->get($this->input->post('section_id'));
        $staffData = $this->staff_model->get($this->input->post('substitute_staff_id'));
        $leaveData = $this->staff_model->get($this->input->post('leave_staff_id'));
        $date = $this->input->post('date');
        
        
        
        $class_name = $classData['class'];
        $section_name = $sectionData['section'];
        $day = $this->input->post('day');
        $leave_staff = $leaveData['name'] . ' ' . $leaveData['surname'];
        
        
        
        
        $description = "You have been assigned as a substitute teacher for {$leave_staff} on {$date} {$day} for Class {$class_name} - {$section_name} from " . date('h:i A', strtotime($data['period_start'])) . " to " . date('h:i A', strtotime($data['period_end'])) . ".";
        // print_r($description); die;

        $notification_data = [
            'std_id' => $data['substitute_staff_id'],
            'title' => 'Substitute Class Assigned',
            'description' => $description,
            'created_at' => date('Y-m-d H:i:s'),
            'type' => 1, 
        ];
        

        $this->db->insert('student_notifications', $notification_data);

        
    
        // Optional: prevent duplicate
        $exists = $this->db->get_where('substitute_teacher_assignments', $data)->row();
        if (!$exists) {
            $this->db->insert('substitute_teacher_assignments', $data);
        }else{
            $this->db->where('id', $exists->id)->update('substitute_teacher_assignments', $data);

        }
    
        $this->session->set_flashdata('msg', 'Substitute assigned successfully');
        redirect('admin/bulletin/substitute_teachers');
    }
    
    
    public function bulletin_report()
    {
      
        // error_reporting(E_ALL);
        // ini_set('display_errors', 1);
        
        $filters = array(
            'start_date' => '',
            'end_date' => '',
            'leave_teacher_id' => '',
            'substitute_teacher_id' => '',
            'class_id' => '',
            'subject_id' => ''
        );
        
        // Set validation rules
       
        $this->form_validation->set_rules('leave_teacher_id', 'Leave Teacher', 'integer');
        $this->form_validation->set_rules('substitute_teacher_id', 'Substitute Teacher', 'integer');
        
        // Check if form was submitted and validation passed
        if ($this->input->post() && $this->form_validation->run()) {
            
           
       
        $filters = array(
            'start_date' => $this->input->post('date_from'),
            'end_date' => $this->input->post('date_to'),
            'leave_teacher_id' => $this->input->post('leave_teacher_id'),
            'substitute_teacher_id' => $this->input->post('substitute_teacher_id')
        );
        
        }
        
        
        
        $data['teachers'] = $this->staff_model->get();
        
        
    
        $data['substitutes'] = $this->substitute_model->get_substitute_assignments_report($filters);
        
        
        $menu_data['selected'] = 'bulletin_report'; 
        $data['top_menu_option'] = $this->load->view('admin/teacher/topMenuOptions', $menu_data, true);
        
       
         $this->load->view('layout/header');
         $this->load->view('admin/bulletin/report',$data);
         $this->load->view('layout/footer');
    
        
    }



}