<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Bank_account extends Admin_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('BankAccount_model');
    }

    function index() {
        // if (!$this->rbac->hasPrivilege('bank_account', 'can_view')) {
        //     access_denied();
        // }
        $this->session->set_userdata('top_menu', 'Fees Collection');
        $this->session->set_userdata('sub_menu', 'bank_account/index');
        $data['title'] = 'Add Feetype';
        $data['title_list'] = 'Recent FeeType';

        $this->form_validation->set_rules(
                'account_number', $this->lang->line('bank_account_no'), array(
            'required',
            array('check_exists', array($this->BankAccount_model, 'check_exists'))
                )
        );
        $this->form_validation->set_rules('ac_holder_name', $this->lang->line('account_holder'), 'required');

        $this->form_validation->set_rules('ifsc_code', $this->lang->line('ifsc_code'), 'required');
        $this->form_validation->set_rules('bank_name', $this->lang->line('bank_name'), 'required');
        $this->form_validation->set_rules('branch_name', $this->lang->line('bank_branch_name'), 'required');
        $is_primary=$this->input->post('is_primary');

        if ($this->form_validation->run() == FALSE) {
    
        } else {
            $data = array(
                'account_number' => $this->input->post('account_number'),
                'branch_name' => $this->input->post('branch_name'),
                'ac_holder_name' => $this->input->post('ac_holder_name'),
                'ifsc_code' => $this->input->post('ifsc_code'),
                'bank_name' => $this->input->post('bank_name'),
                'is_primary' =>   isset($is_primary) ? $is_primary : '',
                'status' =>   1
            );
            $this->BankAccount_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/Bank_account/index');
        }
        $bank_result = $this->BankAccount_model->get();
        $data['bankList'] = $bank_result;

        $this->load->view('layout/header', $data);
        $this->load->view('admin/bank_account/bankList', $data);
        $this->load->view('layout/footer', $data);
    }

    

    function edit($id) {
        if (!$this->rbac->hasPrivilege('bank_account', 'can_edit')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Fees Collection');
        $this->session->set_userdata('sub_menu', 'bank_account/index');
        $data['id'] = $id;
        $bank = $this->BankAccount_model->get($id);
        $data['bankdetails'] = $bank;
        $bank_result = $this->BankAccount_model->get();
        $data['bankList'] = $bank_result;
        $this->form_validation->set_rules(
                'account_number', $this->lang->line('bank_account_no'), array(
            'required',
            array('check_exists', array($this->BankAccount_model, 'check_exists'))
                )
        );
        $this->form_validation->set_rules('ac_holder_name', $this->lang->line('account_holder'), 'required');

        $this->form_validation->set_rules('ifsc_code', $this->lang->line('ifsc_code'), 'required');
        $this->form_validation->set_rules('bank_name', $this->lang->line('bank_name'), 'required');
        $this->form_validation->set_rules('branch_name', $this->lang->line('bank_branch_name'), 'required');
        if ($this->form_validation->run() == FALSE) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/bank_account/edit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $is_primary=$this->input->post('is_primary');
            $data = array(
                'id' => $id,
                'account_number' => $this->input->post('account_number'),
                'branch_name' => $this->input->post('branch_name'),
                'bank_name' => $this->input->post('bank_name'),
                'ac_holder_name' => $this->input->post('ac_holder_name'),
                'ifsc_code' => $this->input->post('ifsc_code'),
                'is_primary' =>   isset($is_primary) ? $is_primary : '',
            );
            $this->BankAccount_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/bank_account/index');
        }
    }

    public function changeStatus() {

        $id = $this->input->post("id");
        $status = $this->input->post("status");

        if (!empty($id)) {

            $data = array('id' => $id, 'status' => $status);
            $result = $this->BankAccount_model->changeStatus($data);
            $response = array('status' => 1, 'msg' => 'Status change successfully');
            echo json_encode($response);
        }
    }

}

?>