<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Admin extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model("classteacher_model");
        $this->load->model("Staff_model");
        $this->load->library('Enc_lib');
        $this->sch_setting_detail = $this->setting_model->getSetting();
    }

    public function unauthorized()
    {
        $data = array();
        $this->load->view('layout/header', $data);
        $this->load->view('unauthorized', $data);
        $this->load->view('layout/footer', $data);
    }

    public function updateAddonVerify()
    {
        $this->form_validation->set_rules('addon', 'Addon', 'required|trim|xss_clean');
        $this->form_validation->set_rules('addon_check_update_envato_market_purchase_code', 'Purchase Code', 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'addon'                       => form_error('addon'),
                'addon_check_update_envato_market_purchase_code' => form_error('addon_check_update_envato_market_purchase_code'),
            );
            $array = array('status' => '0', 'error' => $data);

            return $this->output
                ->set_content_type('application/json')
                ->set_status_header(200)
                ->set_output(json_encode($array));
        } else {
            //==================
            $response = $this->auth->addon_update_check(); 
        }
    }
    
    public function dashboard()
    {       
        $role            = $this->customlib->getStaffRole();
        $role_id         = json_decode($role)->id;
        $data['role_id'] = $role_id;

        $staffid       = $this->customlib->getStaffID();
        $notifications = $this->notification_model->getUnreadStaffNotification($staffid, $role_id);

        $staff_notification = $this->student_model->getNotification($staffid);

        $data['notifications'] = $notifications;

        $data['staff_notification'] = $staff_notification;
        $input                 = $this->setting_model->getCurrentSessionName();

        list($a, $b)  = explode('-', $input);
        $Current_year = $a;
        if (strlen($b) == 2) {
            $Next_year = substr($a, 0, 2) . $b;
        } else {
            $Next_year = $b;
        }
        $data['mysqlVersion'] = $this->setting_model->getMysqlVersion();
        $data['sqlMode']      = $this->setting_model->getSqlMode();
        //========================== Current Attendence ==========================
        $current_date       = date('Y-m-d');
        $data['title']      = 'Dashboard';
        $Current_start_date = date('01');

        $last_day_this_month        = date($Current_year.'-m-t');  //added
        $total_students_heads       = 0; //added

        $Current_date       = date('d');
        $Current_month      = date('m');
        $month_collection   = 0;
        $month_expense      = 0;
        $total_students     = 0;
        $total_teachers     = 0;
        $ar                 = $this->startmonthandend();
        $year_str_month     = $Current_year . '-' . $ar[0] . '-01';
        $year_end_month     = date("Y-m-t", strtotime($Next_year . '-' . $ar[1] . '-01'));
        $getDepositeAmount  = $this->studentfeemaster_model->getDepositAmountBetweenDate($year_str_month, $year_end_month);
        $student_transport_fee = $this->studenttransportfee_model->getTransportDepositAmountBetweenDate($year_str_month, $year_end_month);
        
        //======================Current Month Collection ==============================
        
        $first_day_this_month     = date('Y-m-01'); //comment
        
        // $current_month_collection = $this->studentfeemaster_model->getDepositAmountBetweenDate($first_day_this_month, $current_date);
        $month_collection         = $this->whatever($getDepositeAmount, $first_day_this_month, $current_date);
        $month_transport_collection         = $this->whatever($student_transport_fee, $first_day_this_month, $current_date);

        $data['month_collection'] = $month_collection+$month_transport_collection;


        $tot_students = $this->studentsession_model->getTotalStudentBySession();
        if (!empty($tot_students)) {
            $total_students = $tot_students->total_student;
        }

        $data['total_students'] = $total_students;
        $tot_roles              = $this->role_model->get();
        foreach ($tot_roles as $key => $value) {

            $count_roles[$value["name"]] = $this->role_model->count_roles($value["id"]);

        }
        $data["roles"] = $count_roles;

        //======================== get collection by month ==========================
        $start_month = strtotime($year_str_month);
        $start       = strtotime($year_str_month);
        $end         = strtotime($year_end_month);
        $coll_month  = array();
        $s           = array();
        $total_month = array();
        while ($start_month <= $end) {
            $total_month[] = $this->lang->line(strtolower(date('F', $start_month)));
            $month_start   = date('Y-m-d', $start_month);
            $month_end     = date("Y-m-t", $start_month);
            $return        = $this->whatever($getDepositeAmount, $month_start, $month_end);
            $tranport_amt      = $this->whatever($student_transport_fee,  $month_start, $month_end);
            
            if (!IsNullOrEmptyString($return) || !IsNullOrEmptyString($tranport_amt)) {
                $s[] = convertBaseAmountCurrencyFormat($return+$tranport_amt);
            } else {
                $s[] = "0.00";
            }

            $start_month = strtotime("+1 month", $start_month);
        }
        //======================== getexpense by month ==============================
        $ex                  = array();
        $start_session_month = strtotime($year_str_month);
        while ($start_session_month <= $end) {

            $month_start = date('Y-m-d', $start_session_month);
            $month_end   = date("Y-m-t", $start_session_month);

            $expense_monthly = $this->expense_model->getTotalExpenseBwdate($month_start, $month_end);

            if (!empty($expense_monthly)) {
                $amt  = 0;
                $ex[] = $amt + convertBaseAmountCurrencyFormat($expense_monthly->amount);
            }

            $start_session_month = strtotime("+1 month", $start_session_month);
        }

        $data['yearly_collection'] = $s;
       
        $data['yearly_expense']    = $ex;
        $data['total_month']       = $total_month;

        //======================= current month collection /expense ===================
     
        // hardcoded '01' for first day
        $startdate       = date('m/01/Y');
        $enddate         = date('m/t/Y');
        $start           = strtotime($startdate);
        $end             = strtotime($enddate);
        $currentdate     = $start;
        $month_days      = array();
        $days_collection = array();
        while ($currentdate <= $end) {
            $cur_date          = date('Y-m-d', $currentdate);
            $month_days[]      = date('d', $currentdate);
            $coll_amt          = $this->whatever($getDepositeAmount, $cur_date, $cur_date);
            $tranport_amt      = $this->whatever($student_transport_fee, $cur_date, $cur_date);
            $days_collection[] = convertBaseAmountCurrencyFormat($coll_amt+$tranport_amt);
            $currentdate       = strtotime('+1 day', $currentdate);
        }
        $data['current_month_days'] = $month_days;
        $data['days_collection']    = $days_collection;


        //======================= current month /expense ==============================
        // hardcoded '01' for first day

        $startdate    = date('m/01/Y');
        $enddate      = date('m/t/Y');
        $start        = strtotime($startdate);
        $end          = strtotime($enddate);
        $currentdate  = $start;
        $days_expense = array();
        while ($currentdate <= $end) {
            $cur_date       = date('Y-m-d', $currentdate);
            $month_days[]   = date('d', $currentdate);
            $currentdate    = strtotime('+1 day', $currentdate);
            $ct             = $this->getExpensebyday($cur_date);
            $days_expense[] = convertBaseAmountCurrencyFormat($ct);
        }

        $data['days_expense']        = $days_expense;
        $student_fee_history         = $this->studentfee_model->getTodayStudentFees();
        $data['student_fee_history'] = $student_fee_history;

        $event_colors         = array("#03a9f4", "#c53da9", "#757575", "#8e24aa", "#d81b60", "#7cb342", "#fb8c00", "#fb3b3b");
        $data["event_colors"] = $event_colors;
        $userdata             = $this->customlib->getUserData();
        $data["role"]         = $userdata["user_type"];
        $start_date           = date('Y-m-01');
        $end_date             = date('Y-m-t');
        $current_month        = date('F');
        $student_due_fee       = $this->studentfeemaster_model->getFeesAwaiting($start_date, $end_date);
        $student_transport_fee = $this->studentfeemaster_model->getTransportFeesByDueDate($start_date, $end_date);
        $data['fees_awaiting'] = $student_due_fee;

        $total_fess    = 0;
        $total_paid    = 0;
        $total_unpaid  = 0;
        $total_partial = 0;

        if (!empty($student_transport_fee)) {

            foreach ($student_transport_fee as $transport_fees_key => $transport_fees_value) {

                $amount_to_be_taken = 0;
                if ($transport_fees_value->fees > 0) {
                    $amount_to_be_taken = $transport_fees_value->fees;
                }

                if ($amount_to_be_taken > 0) {
                    $total_fess++;

                    if (is_string($transport_fees_value->amount_detail) && is_array(json_decode($transport_fees_value->amount_detail, true)) && (json_last_error() == JSON_ERROR_NONE)) {
                        $amount_paid_details = (json_decode($transport_fees_value->amount_detail));
                        $amt_                = 0;
                        foreach ($amount_paid_details as $amount_paid_detail_key => $amount_paid_detail_value) {
                            $amt_ = $amt_ + $amount_paid_detail_value->amount;
                        }

                        if (($amt_ + $amount_paid_detail_value->amount_discount) >= $amount_to_be_taken) {
                            $total_paid++;
                        } elseif (($amt_ + $amount_paid_detail_value->amount_discount) < $amount_to_be_taken) {
                            $total_partial++;
                        }
                    } else {
                        $total_unpaid++;
                    }

                }
            }
        }

        if (!empty($data['fees_awaiting'])) {

            foreach ($data['fees_awaiting'] as $awaiting_key => $awaiting_value) {

                $amount_to_be_taken = 0;
                if ($awaiting_value->is_system) {
                    if ($awaiting_value->amount > 0) {
                        $amount_to_be_taken = $awaiting_value->amount;
                    }
                } elseif ($awaiting_value->is_system == 0) {
                    if ($awaiting_value->fee_amount > 0) {
                        $amount_to_be_taken = $awaiting_value->fee_amount;
                    }
                }

                if ($amount_to_be_taken > 0) {
                    $total_fess++;

                    if (is_string($awaiting_value->amount_detail) && is_array(json_decode($awaiting_value->amount_detail, true)) && (json_last_error() == JSON_ERROR_NONE)) {
                        $amount_paid_details = (json_decode($awaiting_value->amount_detail));
                        $amt_                = 0;
                        foreach ($amount_paid_details as $amount_paid_detail_key => $amount_paid_detail_value) {
                            $amt_ = $amt_ + $amount_paid_detail_value->amount;
                        }

                        if (($amt_ + $amount_paid_detail_value->amount_discount) >= $amount_to_be_taken) {
                            $total_paid++;
                        } elseif (($amt_ + $amount_paid_detail_value->amount_discount) < $amount_to_be_taken) {
                            $total_partial++;
                        }
                    } else {
                        $total_unpaid++;
                    }

                }
            }
        }

        $incomegraph = $this->income_model->getIncomeHeadsData($start_date, $end_date);
        foreach ($incomegraph as $key => $value) {
            $incomegraph[$key]['total'] = convertBaseAmountCurrencyFormat($value['total']);
        }
        $data['incomegraph'] = $incomegraph;

        $expensegraph = $this->expense_model->getExpenseHeadData($start_date, $end_date);
        foreach ($expensegraph as $key => $value) {
            $expensegraph[$key]['total'] = convertBaseAmountCurrencyFormat($value['total']);
            if (!empty($value['total'])) {
                $month_expense = $month_expense + convertBaseAmountCurrencyFormat($value['total']);
            }
        }
        $data['expensegraph']  = $expensegraph;
        $data['month_expense'] = $month_expense;

        $enquiry       = $this->admin_model->getAllEnquiryCount($start_date, $end_date);
        $total_counter = $total_paid + $total_unpaid + $total_partial;

        $data['fees_overview'] = array(
            'total_unpaid'     => $total_unpaid,
            'unpaid_progress'  => ($total_counter > 0) ? (($total_unpaid * 100) / $total_counter) : 0,
            'total_paid'       => $total_paid,
            'paid_progress'    => ($total_counter > 0) ? (($total_paid * 100) / $total_counter) : 0,
            'total_partial'    => $total_partial,
            'partial_progress' => ($total_counter > 0) ? (($total_partial * 100) / $total_counter) : 0,
        );

        $total_enquiry = $enquiry['total'];

        if ($total_enquiry > 0) {

            $data['enquiry_overview'] = array(
                'won'              => $enquiry['complete'],
                'won_progress'     => ($enquiry['complete'] * 100) / $total_enquiry,
                'active'           => $enquiry['active'],
                'active_progress'  => ($enquiry['active'] * 100) / $total_enquiry,
                'passive'          => $enquiry['passive'],
                'passive_progress' => ($enquiry['passive'] * 100) / $total_enquiry,
                'dead'             => $enquiry['dead'],
                'dead_progress'    => ($enquiry['dead'] * 100) / $total_enquiry,
                'lost'             => $enquiry['lost'],
                'lost_progress'    => ($enquiry['lost'] * 100) / $total_enquiry,
            );

        } else {

            $data['enquiry_overview'] = array(
                'won'              => 0,
                'won_progress'     => 0,
                'active'           => 0,
                'active_progress'  => 0,
                'passive'          => 0,
                'passive_progress' => 0,
                'dead'             => 0,
                'dead_progress'    => 0,
                'lost'             => 0,
                'lost_progress'    => 0,
            );

        }

        $data['total_paid'] = $total_paid;
        $data['total_fees'] = $total_fess;
        if ($total_fess > 0) {
            $data['fessprogressbar'] = ($total_paid * 100) / $total_fess;
        } else {
            $data['fessprogressbar'] = 0;
        }

        $data['total_enquiry']  = $total_enquiry  = $enquiry['total'];
        $data['total_complete'] = $complete_enquiry = $enquiry['complete'];
        if ($total_enquiry > 0) {
            $data['fenquiryprogressbar'] = ($complete_enquiry * 100) / $total_enquiry;
        } else {
            $data['fenquiryprogressbar'] = 0;
        }

        $bookoverview      = $this->book_model->bookoverview($start_date, $end_date);
        $bookduereport     = $this->bookissue_model->dueforreturn($start_date, $end_date);
        $forreturndata     = $this->bookissue_model->forreturn($start_date, $end_date);
        $dueforreturn      = $bookduereport[0]['total'];
        $forreturn         = $forreturndata[0]['total'];
        $total_qty         = $bookoverview[0]['qty'];
        $total_issued      = $bookoverview[0]['total_issue'];
        $availble          = '0';
        $availble_progress = 0;
        $issued_progress   = 0;

        if ($total_qty > 0) {
            $availble          = $total_qty - $total_issued;
            $availble_progress = ($availble * 100) / $total_qty;
            $issued_progress   = ($total_issued * 100) / $total_qty;
        }

        $data['book_overview'] = array(
            'total'             => $total_qty,
            'total_progress'    => 100,
            'availble'          => $availble,
            'availble_progress' => round($availble_progress, 2),
            'total_issued'      => $total_issued,
            'issued_progress'   => round($issued_progress, 2),
            'dueforreturn'      => $dueforreturn,
            'forreturn'         => $forreturn,
        );

        $Attendence                   = $this->stuattendence_model->getTodayDayAttendance($total_students);
        $data['attendence_data']      = $Attendence;
        $Staffattendence              = $this->Staff_model->getTodayDayAttendance();
        $data['Staffattendence_data'] = $Staffattendence;
        $getTotalStaff                = $this->Staff_model->getTotalStaff();
        $data['getTotalStaff_data']   = $getTotalStaff;
        if ($getTotalStaff > 0) {$percentTotalStaff_data = ($Staffattendence * 100) / ($getTotalStaff);} else { $percentTotalStaff_data = '0';}
        $data['percentTotalStaff_data'] = $percentTotalStaff_data;
        $data['sch_setting']            = $this->sch_setting_detail;

    // new features code added
        $input_session   = $this->setting_model->getCurrentSessionName();
        list($a, $b)  = explode('-', $input_session);
        $Current_year = $a;
        if(date("m")>=1 && date("m")<=4 ){
            $Current_year = $b;
        }else{
            $Current_year = $a;
        }

        $first_day_this_month  = date("20$Current_year".'-m-01'); //added
        $last_day_this_month  = date("20$Current_year".'-m-t');  //added

        $data['getStudentMonthlyLeave'] = $getStudentMonthlyLeave = count($this->apply_leave_model->getStudentMonthlyLeave($first_day_this_month,$last_day_this_month));
        $data['getStudentApproveMonthlyLeave'] = $getStudentApproveMonthlyLeave =   count($this->apply_leave_model->getStudentApproveMonthlyLeave($first_day_this_month,$last_day_this_month));
 
        if ($getStudentMonthlyLeave > 0) {
            $data['studentapprovemonthlyleave'] = ($getStudentApproveMonthlyLeave * 100) / $getStudentMonthlyLeave;
        } else {
            $data['studentapprovemonthlyleave'] = 0;
        }
        $data['getStaffMonthlyLeave'] = $getStaffMonthlyLeave = count($this->apply_leave_model->getStaffMonthlyLeave($first_day_this_month, $last_day_this_month));
        $data['getStaffApproveMonthlyLeave'] = $getStaffApproveMonthlyLeave =   count($this->apply_leave_model->getStaffApproveMonthlyLeave($first_day_this_month, $last_day_this_month));

        if ($getStaffMonthlyLeave > 0) {
            $data['staffapprovemonthlyleave'] = ($getStaffApproveMonthlyLeave * 100) / $getStaffMonthlyLeave;
        } else {
            $data['staffapprovemonthlyleave'] = 0;
        }

        $tot_head_students = $this->studentsession_model->getTotalHeadCountBySession();
        $tot_students = $this->studentsession_model->getTotalStudentBySession();
        if (!empty($tot_students)) {
            $total_students = $tot_students->total_student;
        }

        if (!empty($tot_head_students)) {
            $total_students_heads = count($tot_head_students);
        } 

        $data['total_students'] = $total_students;
        $data['total_students_heads'] = $total_students_heads;
    // new features code added

        if ($data['sch_setting']->attendence_type == 0) {
            $data['std_graphclass'] = "col-lg-4 col-md-6 col-sm-6";
        } else {
            $data['std_graphclass'] = "col-lg-4 col-md-6 col-sm-6";
        }
        
        
        $upcoming_student_birthdays = $this->student_model->upcoming_birthdays($role_id, $staffid);

        $today_student_birthdays = $this->student_model->today_birthdays($role_id, $staffid);

        $upcoming_staff_birthdays = $this->staff_model->upcoming_staff_birthdays($staffid);

        $today_staff_birthdays    = $this->staff_model->today_staff_birthdays($staffid);



        $upcoming_staff_anniversary = $this->staff_model->upcoming_staff_anniversary($staffid);
        
        
        $data['upcoming_student_birthdays'] = $upcoming_student_birthdays;

        $data['today_staff_birthdays']      = $today_staff_birthdays;
        
       

        $data['today_student_birthdays']      = $today_student_birthdays;

        $data['upcoming_staff_birthdays']   = $upcoming_staff_birthdays;

        $data['upcoming_staff_anniversary'] = $upcoming_staff_anniversary;

        $this->load->view('layout/header', $data);
        $this->load->view('admin/dashboard', $data);
        $this->load->view('layout/footer', $data);
    }
    public function getUserImage()
    {
        $id     = $this->session->userdata["admin"]["id"];
        $result = $this->staff_model->get($id);
    }
    
    
    public function StudentBirthdayWish($id)
    {
        

        $loggedInUser = $this->customlib->getUserData();

        $role            = $this->customlib->getStaffRole();

        $role_name         = json_decode($role)->name;

        $loggedInUserName = $loggedInUser['name'] . ' ' . $loggedInUser['surname'];

        $wishById = $loggedInUser['id'];

        // $wishBy=$loggedInUser['role'];

        $student_info    = $this->student_model->get($id);



        $FullName = $student_info['firstname'] . ' ' . $student_info['middlename'] . ' ' . $student_info['lastname'];







        $msg = 'Wishing You Very Happy Birthday Dear ' . $FullName . ' Wish By: ' . $loggedInUserName . '(' . $role_name . ')';





        $notification_array = array(

            'title' => "Birthday Wish",

            'std_id' => $id,

            'wishBy' => $wishById,

            'description'  => $msg,

        );





        $notifications = $this->notification_model->add_student_notification($notification_array);



        $this->session->set_flashdata('msg', '<div class="alert alert-success">' . $this->lang->line('success_message') . '</div>');



        redirect('admin/admin/dashboard');
    }
    
    
    public function StaffBirthdayWish($id)
    {
        $loggedInUser = $this->customlib->getUserData();
        $role            = $this->customlib->getStaffRole();
        $role_name         = json_decode($role)->name;
        $loggedInUserName = $loggedInUser['name'].' '.$loggedInUser['surname'];
        $wishById=$loggedInUser['id'];
        // $wishBy=$loggedInUser['role'];
        $staff_info    = $this->staff_model->getProfile($id);

        $FullName = $staff_info['name'].' '.$staff_info['surname'];

        
        
        $msg = 'Wishing You Very Happy Birthday Dear ' . $FullName . '<br> Wish By: ' . $loggedInUserName . '(' . $role_name . ')';


        $notification_array = array(
            'title' => "Birthday Wish",
            'std_id' => $id,
            'wishBy' => $wishById,
            'type'   => 1,
            'description'  => $msg,
        );
        

        $notifications=$this->notification_model->add_student_notification($notification_array);

        $this->session->set_flashdata('msg', '<div class="alert alert-success">' . $this->lang->line('success_message') . '</div>');

                redirect('admin/admin/dashboard');
    }

    public function getSession()
    {
        if (!$this->rbac->hasPrivilege('quick_session_change', 'can_view')) {
            access_denied();
        }
        $session             = $this->session_model->getAllSession();
        $data                = array();
        $session_array       = $this->session->has_userdata('session_array');
        $data['sessionData'] = array('session_id' => 0);
        if ($session_array) {
            $data['sessionData'] = $this->session->userdata('session_array');
        } else {
            $setting             = $this->setting_model->get();
            $data['sessionData'] = array('session_id' => $setting[0]['session_id']);
        }
        $data['sessionList'] = $session;
        $this->load->view('admin/partial/_session', $data);
    }

    public function updateSession()
    {
        $session       = $this->input->post('popup_session');
        $session_array = $this->session->has_userdata('session_array');
        if ($session_array) {
            $this->session->unset_userdata('session_array');
        }
        $session       = $this->session_model->get($session);
        $session_array = array('session_id' => $session['id'], 'session' => $session['session']);
        $this->session->set_userdata('session_array', $session_array);
        echo json_encode(array('status' => 1, 'message' => $this->lang->line('session_changed_successfully')));
    }

    public function updatePurchaseCode()
    {
        $this->form_validation->set_rules('email', $this->lang->line('email'), 'required|valid_email|trim|xss_clean');
        $this->form_validation->set_rules('envato_market_purchase_code', $this->lang->line('purchase_code'), 'required|trim|xss_clean');
        if ($this->form_validation->run() == false) {
            $data = array(
                'email'                       => form_error('email'),
                'envato_market_purchase_code' => form_error('envato_market_purchase_code'),
            );
            $array = array('status' => '2', 'error' => $data);

            return $this->output
                ->set_content_type('application/json')
                ->set_status_header(200)
                ->set_output(json_encode($array));
        } else {
            //==================
            $response = $this->auth->app_update();
        }
    }
    
    
    public function getStaffNotificationCount() {
        $userdata = $this->customlib->getUserData();
        $this->db->where('std_id', $userdata['id']);
        $this->db->where('type', 1);
        $this->db->where('is_read', 0);
        $query = $this->db->get('student_notifications');
        $count = $query->num_rows();

        echo json_encode(['count' => $count]); // Return the count as JSON
    }

    public function getStaffNotifications() {
        $userdata = $this->customlib->getUserData();
        $this->db->where('std_id', $userdata['id']);
        $this->db->where('type', 1);
        $this->db->order_by('created_at', 'DESC'); // Order notifications by latest first
        $query = $this->db->get('student_notifications');
        $notifications = $query->result_array();

        echo json_encode($notifications); // Return notifications as JSON
    }

    public function markAsRead() {
        $userdata = $this->customlib->getUserData();
        $this->db->where('std_id', $userdata['id']);
        $this->db->where('type', 1);
        $this->db->set('is_read', 1); // Set is_read to 1 for all notifications
        $this->db->update('student_notifications'); // Update all notifications

        echo json_encode(['status' => 'success']);
    }

    public function backup()
    {
        if (!$this->rbac->hasPrivilege('backup', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'System Settings');
        $this->session->set_userdata('sub_menu', 'admin/backup');
        $this->session->set_userdata('inner_menu', 'admin/backup');
        $data['title'] = $this->lang->line('backup_history');
        if ($this->input->server('REQUEST_METHOD') == "POST") {
            if ($this->input->post('backup') == "upload") {
                $this->form_validation->set_rules('file', $this->lang->line('image'), 'callback_handle_upload');
                if ($this->form_validation->run() == false) {

                } else {
                    if (isset($_FILES["file"]) && !empty($_FILES['file']['name'])) {
                        $fileInfo  = pathinfo($_FILES["file"]["name"]);
                        $file_name = "db-" . date("Y-m-d_H-i-s") . ".sql";
                        move_uploaded_file($_FILES["file"]["tmp_name"], "./backup/temp_uploaded/" . $file_name);
                        $folder_name  = 'temp_uploaded';
                        $path         = './backup/';
                        $filePath     = $path . $folder_name . '/' . $file_name;
                        $file_restore = $this->load->file($path . $folder_name . '/' . $file_name, true);
                        $db           = (array) get_instance()->db;
                        $conn         = mysqli_connect('localhost', $db['username'], $db['password'], $db['database']);

                        $sql   = '';
                        $error = '';

                        if (file_exists($filePath)) {
                            $lines = file($filePath);

                            foreach ($lines as $line) {

                                // Ignoring comments from the SQL script
                                if (substr($line, 0, 2) == '--' || $line == '') {
                                    continue;
                                }

                                $sql .= $line;

                                if (substr(trim($line), -1, 1) == ';') {
                                    $result = mysqli_query($conn, $sql);
                                    if (!$result) {
                                        $error .= mysqli_error($conn) . "\n";
                                    }
                                    $sql = '';
                                }
                            }
                            $msg = $this->lang->line('restored_message');
                        } // end if file exists

                        $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
                        redirect('admin/admin/backup');
                    }
                }
            }
            if ($this->input->post('backup') == "backup") {
                $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
                $this->load->helper('download');
                $this->load->dbutil();
                $version  = $this->customlib->getAppVersion();
                $filename = "db_ver_" . $version . '_' . date("Y-m-d_H-i-s") . ".sql";
                $prefs    = array(
                    'ignore'     => array(),
                    'format'     => 'txt',
                    'filename'   => 'mybackup.sql',
                    'add_drop'   => true,
                    'add_insert' => true,
                    'newline'    => "\n",
                );
                $backup = $this->dbutil->backup($prefs);
                $this->load->helper('file');
                write_file('./backup/database_backup/' . $filename, $backup);
                redirect('admin/admin/backup');
                force_download($filename, $backup);
                $this->session->set_flashdata('feedback', $this->lang->line('success_message_for_client_to_see'));
                redirect('admin/admin/backup');
            } else if ($this->input->post('backup') == "restore") {
                $folder_name  = 'database_backup';
                $file_name    = $this->input->post('filename');
                $path         = './backup/';
                $filePath     = $path . $folder_name . '/' . $file_name;
                $file_restore = $this->load->file($path . $folder_name . '/' . $file_name, true);
                $db           = (array) get_instance()->db;
                $conn         = mysqli_connect('localhost', $db['username'], $db['password'], $db['database']);

                $sql   = '';
                $error = '';

                if (file_exists($filePath)) {
                    $lines = file($filePath);

                    foreach ($lines as $line) {

                        // Ignoring comments from the SQL script
                        if (substr($line, 0, 2) == '--' || $line == '') {
                            continue;
                        }

                        $sql .= $line;

                        if (substr(trim($line), -1, 1) == ';') {
                            $result = mysqli_query($conn, $sql);
                            if (!$result) {
                                $error .= mysqli_error($conn) . "\n";
                            }
                            $sql = '';
                        }
                    }
                    $msg = $this->lang->line('restored_message');
                } // end if file exists
                $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $msg . '</div>');
                redirect('admin/admin/backup');
            }
        }
        $dir    = "./backup/database_backup/";
        $result = array();
        $cdir   = scandir($dir);
        foreach ($cdir as $key => $value) {
            if (!in_array($value, array(".", ".."))) {
                if (is_dir($dir . DIRECTORY_SEPARATOR . $value)) {
                    $result[$value] = dirToArray($dir . DIRECTORY_SEPARATOR . $value);
                } else {
                    $result[] = $value;
                }
            }
        }
        $data['dbfileList']  = $result;
        $setting_result      = $this->setting_model->get();
        $data['settinglist'] = $setting_result;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/backup', $data);
        $this->load->view('layout/footer', $data);
    }

    public function changepass()
    {
        $this->session->set_userdata('top_menu', 'System Settings');
        $this->session->set_userdata('sub_menu', 'changepass/index');
        $data['title'] = 'Change Password';
        $this->form_validation->set_rules('current_pass', $this->lang->line("current_password"), 'trim|required|xss_clean');
        $this->form_validation->set_rules('new_pass', $this->lang->line("new_password"), 'trim|required|xss_clean|matches[confirm_pass]');
        $this->form_validation->set_rules('confirm_pass', $this->lang->line("confirm_password"), 'trim|required|xss_clean');
        if ($this->form_validation->run() == false) {
            $sessionData            = $this->session->userdata('admin');
            $this->data['id']       = $sessionData['id'];
            $this->data['username'] = $sessionData['username'];
            $this->load->view('layout/header', $data);
            $this->load->view('admin/change_password', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $sessionData = $this->session->userdata('admin');
            $userdata    = $this->customlib->getUserData();
            $data_array  = array(
                'current_pass' => $this->input->post('current_pass'),
                'new_pass'     => md5($this->input->post('new_pass')),
                'user_id'      => $sessionData['id'],
                'user_email'   => $sessionData['email'],
                'user_name'    => $sessionData['username'],
            );
            $newdata = array(
                'id'       => $sessionData['id'],
                'password' => $this->enc_lib->passHashEnc($this->input->post('new_pass')),
            );
            $check  = $this->enc_lib->passHashDyc($this->input->post('current_pass'), $userdata["password"]);
            $query1 = $this->admin_model->checkOldPass($data_array);

            if ($query1) {

                if ($check) {
                    $query2 = $this->admin_model->saveNewPass($newdata);
                    if ($query2) {
                        $data['error_message'] = "<div class='alert alert-success'>" . $this->lang->line("password_changed_successfully") . "</div>";
                        $this->load->view('layout/header', $data);
                        $this->load->view('admin/change_password', $data);
                        $this->load->view('layout/footer', $data);
                    }
                } else {
                    $data['error_message'] = "<div class='alert alert-danger'>" . $this->lang->line("invalid_current_password") . "</div>";
                    $this->load->view('layout/header', $data);
                    $this->load->view('admin/change_password', $data);
                    $this->load->view('layout/footer', $data);
                }
            } else {

                $data['error_message'] = "<div class='alert alert-danger'>" . $this->lang->line("invalid_current_password") . "</div>";
                $this->load->view('layout/header', $data);
                $this->load->view('admin/change_password', $data);
                $this->load->view('layout/footer', $data);
            }
        }
    }

    public function pdf_report()
    {
        $data        = array();
        $html        = $this->load->view('reports/students_detail', $data, true);
        $pdfFilePath = "output_pdf_name.pdf";
        $this->load->library('m_pdf');
        $this->m_pdf->pdf->WriteHTML($html);
        $this->m_pdf->pdf->Output($pdfFilePath, "D");
    }

    public function downloadbackup($file)
    {
        $this->load->helper('download');
        $filepath = "./backup/database_backup/" . $file;
        $data     = file_get_contents($filepath);
        $name     = $file;
        force_download($name, $data);
    }

    public function dropbackup($file)
    {
        if (!$this->rbac->hasPrivilege('backup', 'can_delete')) {
            access_denied();
        }
        unlink('./backup/database_backup/' . $file);
        redirect('admin/admin/backup');
    }

    public function search()
    {
        $search_text=$this->input->post('search_text1');
        if(!isset($search_text)){
            $search_text="";
        }

        $data['title']           = 'Search';
        $search_text             = $search_text;
        $data['sch_setting']     = $this->sch_setting_detail;
        $data['search_text']     = trim($search_text);
        $userdata                = $this->customlib->getUserData();
        $data['adm_auto_insert'] = $this->sch_setting_detail->adm_auto_insert;
        $carray                  = array();
        $class                   = $this->class_model->get();
        $data['classlist']       = $class;
        $data['fields']          = $this->customfield_model->get_custom_fields('students', 1);
        $userdata                = $this->customlib->getUserData();
        $carray                  = array();
        $this->load->view('layout/header', $data);
        $this->load->view('admin/search', $data);
        $this->load->view('layout/footer', $data);
    }

    public function getCollectionbymonth()
    {
        $result = $this->admin_model->getMonthlyCollection();
        return $result;
    }

    public function getCollectionbyday($date)
    {
        $result = $this->admin_model->getCollectionbyDay($date);
        if ($result[0]['amount'] == "") {
            $return = 0;
        } else {
            $return = $result[0]['amount'];
        }
        return $return;
    }

    public function getExpensebyday($date)
    {
        $result = $this->admin_model->getExpensebyDay($date);
        if ($result[0]['amount'] == "") {
            $return = 0;
        } else {
            $return = $result[0]['amount'];
        }
        return $return;
    }

    public function getExpensebymonth()
    {
        $result = $this->admin_model->getMonthlyExpense();
        return $result;
    }

    public function whatever($feecollection_array, $start_month_date, $end_month_date)
    {
        $return_amount = 0;
        $st_date       = strtotime($start_month_date);
        $ed_date       = strtotime($end_month_date);
        if (!empty($feecollection_array)) {
            while ($st_date <= $ed_date) {
                $date = date('Y-m-d', $st_date);
                foreach ($feecollection_array as $key => $value) {

                    if ($value['date'] == $date) {

                        $return_amount = $return_amount + $value['amount'] + $value['amount_fine'];
                    }
                }
                $st_date = $st_date + 86400;
            }
        } else {

        }

        return $return_amount;
    }

    public function startmonthandend()
    {
        $startmonth = $this->setting_model->getStartMonth();
        if ($startmonth == 1) {
            $endmonth = 12;
        } else {
            $endmonth = $startmonth - 1;
        }
        return array($startmonth, $endmonth);
    }

    public function handle_upload()
    {
        if (isset($_FILES["file"]) && !empty($_FILES['file']['name'])) {
            $allowedExts = array('sql');
            $temp        = explode(".", $_FILES["file"]["name"]);
            $extension   = end($temp);
            if ($_FILES["file"]["error"] > 0) {
                $error .= "Error opening the file<br />";
            }
            if ($_FILES["file"]["type"] != 'application/octet-stream') {
                $this->form_validation->set_message('handle_upload', $this->lang->line("file_type_not_allowed"));
                return false;
            }
            if (!in_array($extension, $allowedExts)) {
                $this->form_validation->set_message('handle_upload', $this->lang->line("extension_not_allowed"));
                return false;
            }
            if ($_FILES["file"]["size"] > 102400000) {
                $this->form_validation->set_message('handle_upload', $this->lang->line("file_size_shoud_be_less_than") . ' 100 MB');
                return false;
            }
            return true;
        } else {
            $this->form_validation->set_message('handle_upload', $this->lang->line("the_file_field_is_required"));
            return false;
        }
    }

    public function generate_key($length = 12)
    {
        $str        = "";
        $characters = array_merge(range('A', 'Z'), range('a', 'z'), range('0', '9'));
        $max        = count($characters) - 1;
        for ($i = 0; $i < $length; $i++) {
            $rand = mt_rand(0, $max);
            $str .= $characters[$rand];
        }
        return $str;
    }

    public function addCronsecretkey($id)
    {
        $key  = $this->generate_key(25);
        $data = array('cron_secret_key' => $key);
        $this->setting_model->add_cronsecretkey($data, $id);
        redirect('admin/admin/backup');
    }

    public function updateandappCode()
    {
        $this->form_validation->set_rules('app-email', 'Email', 'required|valid_email|trim|xss_clean');
        $this->form_validation->set_rules('app-envato_market_purchase_code', 'Purchase Code', 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'app-email'                       => form_error('app-email'),
                'app-envato_market_purchase_code' => form_error('app-envato_market_purchase_code'),
            );
            $array = array('status' => '2', 'error' => $data);

            return $this->output
                ->set_content_type('application/json')
                ->set_status_header(200)
                ->set_output(json_encode($array));
        } else {
            //==================
            $response = $this->auth->andapp_update();
        }
    }

    public function filetype()
    {
        if (!$this->rbac->hasPrivilege('fees_type', 'can_view')) {
            access_denied();
        }
        
        $data          = array();
        $data['title'] = 'File Type List';
        $this->session->set_userdata('top_menu', 'System Settings');
        $this->session->set_userdata('sub_menu', 'System Settings/filetype');
        $data['filetype'] = $this->filetype_model->get();
        $this->load->view('layout/header', $data);
        $this->load->view('admin/filetype', $data);
        $this->load->view('layout/footer', $data);
    }

    public function addfiletype()
    {
        $this->form_validation->set_rules('file_extension', $this->lang->line('allowed_extension'), 'required|trim|xss_clean|callback_validate_extension');
        $this->form_validation->set_rules('image_extension', $this->lang->line('allowed_extension'), 'required|trim|xss_clean|callback_validate_extension');
        $this->form_validation->set_rules('file_mime', $this->lang->line('allowed_mime_type'), 'required|trim|xss_clean|callback_validate_mime');
        $this->form_validation->set_rules('image_mime', $this->lang->line('allowed_mime_type'), 'required|trim|xss_clean|callback_validate_mime');
        $this->form_validation->set_rules('image_size', $this->lang->line('upload_size_in_bytes'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('file_size', $this->lang->line('upload_size_in_bytes'), 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'file_extension'  => form_error('file_extension'),
                'file_mime'       => form_error('file_mime'),
                'image_extension' => form_error('image_extension'),
                'image_mime'      => form_error('image_mime'),
                'image_size'      => form_error('image_size'),
                'file_size'       => form_error('file_size'),
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        } else {
            $insert_array = array(
                'file_extension'  => $this->input->post('file_extension'),
                'file_mime'       => $this->input->post('file_mime'),
                'image_extension' => $this->input->post('image_extension'),
                'image_mime'      => $this->input->post('image_mime'),
                'file_size'       => $this->input->post('file_size'),
                'image_size'      => $this->input->post('image_size'),
            );

            $inserted_id = $this->filetype_model->add($insert_array);

            $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('success_message'));
            echo json_encode($array);
        }
    }

    public function validate_extension($extension)
    {
        if (preg_match('/^([A-Za-z0-9]+)(,\s[A-Za-z0-9]+)*$/', $extension)) {
            return true;
        } else {
            $this->form_validation->set_message('validate_extension', 'The %s field must be like jpg, jpeg');
            return false;
        }
    }

    public function validate_mime($mime)
    {
        if (preg_match('/^([A-Za-z0-9-.+\/]+)(,\s[A-Za-z0-9-.+\/]+)*$/', $mime)) {
            return true;
        } else {
            $this->form_validation->set_message('validate_mime', 'The %s field must be like audio/mp4, video/mp4');
            return false;
        }
    }

    public function updateaddon()
    {
        $this->form_validation->set_rules('app-email', $this->lang->line('email'), 'required|valid_email|trim|xss_clean');
        $this->form_validation->set_rules('app-envato_market_purchase_code', $this->lang->line('purchase_code'), 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {

            $data = array(
                'app-email'                       => form_error('app-email'),
                'app-envato_market_purchase_code' => form_error('app-envato_market_purchase_code'),
            );

            $array = array('status' => '2', 'error' => $data);

            return $this->output
                ->set_content_type('application/json')
                ->set_status_header(200)
                ->set_output(json_encode($array));
        } else {
            //==================
            $response = $this->auth->addon_update();
        }
    }

    public function searchvalidation()
    {
        $search_text1 = $this->input->post('search_text1');
        $params       = array('search_text1' => $search_text1);
        $array        = array('status' => 1, 'error' => '', 'params' => $params);
        echo json_encode($array);
    }

    public function search_text()
    {
        $search_text1 = $this->input->post('search_text');
        $params       = array('search_text' => $search_text1);
        $array        = array('status' => 1, 'error' => '', 'params' => $params);
        echo json_encode($array);
    }

    public function dtstudentlist()
    {
        $search_text     = $this->input->post('search_text');
        $sch_setting     = $this->sch_setting_detail;
        $currency_symbol = $this->customlib->getSchoolCurrencyFormat();
        $classlist       = $this->class_model->get();
        $classlist       = $classlist;
        $carray          = array();
        if (!empty($classlist)) {
            foreach ($classlist as $ckey => $cvalue) {
                $carray[] = $cvalue["id"];
            }
        }
        $search=$this->input->post('search');

        $resultlist      = $this->student_model->searchFullText($search_text, $carray);
        $start           = $this->input->post('start');
        $length          = $this->input->post('length');
     
        $resultlist_view = $this->student_model->getSearchFullView($search_text, $start, $length,$search, $carray);

        $data = array(
            'resultlist'      => $resultlist_view,
            'sch_setting'     => $this->sch_setting_detail,
            'adm_auto_insert' => $this->sch_setting_detail->adm_auto_insert,
            'currency_symbol' => $this->customlib->getSchoolCurrencyFormat(),
        );

        $resultlist_view = $this->load->view('admin/resultlist_view', $data, true);

        $fields   = $this->customfield_model->get_custom_fields('students', 1);
        $students = json_decode($resultlist);
        $dt_data  = array();
        if (!empty($students->data)) {
            foreach ($students->data as $student_key => $student) {

                $editbtn    = '';
                $deletebtn  = '';
                $viewbtn    = '';
                $collectbtn = "";
                $viewbtn    = "<a href='" . base_url() . "student/view/" . $student->id . "'   class='btn btn-default btn-xs'  data-toggle='tooltip' title='" . $this->lang->line('show') . "'><i class='fa fa-reorder'></i></a>";

                if ($this->rbac->hasPrivilege('student', 'can_edit')) {
                    $editbtn = "<a href='" . base_url() . "student/edit/" . $student->id . "'   class='btn btn-default btn-xs'  data-toggle='tooltip' title='" . $this->lang->line('edit') . "'><i class='fa fa-pencil'></i></a>";
                }
                if ($this->module_lib->hasActive('fees_collection') && $this->rbac->hasPrivilege('collect_fees', 'can_add')) {

                    $collectbtn = "<a href='" . base_url() . "studentfee/addfee/" . $student->student_session_id . "'   class='btn btn-default btn-xs'  data-toggle='tooltip' title='" . $this->lang->line('add_fees') . "'><span >" . $currency_symbol . "</a>";
                }

                $row   = array();
                $row[] = $student->admission_no;
                $row[] = "<a href='" . base_url() . "student/view/" . $student->id . "'>" . $this->customlib->getFullName($student->firstname, $student->middlename, $student->lastname, $sch_setting->middlename, $sch_setting->lastname) . "</a>";
                $row[] = $student->roll_no;
                $row[] = $student->class . "(" . $student->section . ")";
                if ($sch_setting->father_name) {
                    $row[] = $student->father_name;
                }

                $row[] = $this->customlib->dateformat($student->dob);

                $row[] = $this->lang->line(strtolower($student->gender));
                if ($sch_setting->category) {
                    $row[] = $student->category;
                }
                if ($sch_setting->mobile_no) {
                    $row[] = $student->mobileno;
                }

                foreach ($fields as $fields_key => $fields_value) {

                    $custom_name   = $fields_value->name;
                    $display_field = $student->$custom_name;
                    if ($fields_value->type == "link") {
                        $display_field = "<a href=" . $student->$custom_name . " target='_blank'>" . $student->$custom_name . "</a>";
                    }
                    $row[] = $display_field;
                }
                $row[] = $viewbtn . '' . $editbtn . '' . $collectbtn;
                $dt_data[] = $row;
            }

        }
        $json_data = array(
            "draw"            => intval($students->draw),
            "recordsTotal"    => intval($students->recordsTotal),
            "recordsFiltered" => intval($students->recordsFiltered),
            "data"            => $dt_data,
            "resultlist_view" => $resultlist_view,
        );
        echo json_encode($json_data);

    }

  // add system setting in certificate setting = anil start
    
    public function certificateSetting()

    {

        if (!$this->rbac->hasPrivilege('general_setting', 'can_edit')) {

            access_denied();
        }

        $this->session->set_userdata('top_menu', 'System Settings');

        $this->session->set_userdata('sub_menu', 'smsconfig/index');

        $data['title'] = 'Online Meeting Config List';

        //        $sms_result = $this->smsconfig_model->get();

        //        $meeting_result = get_list('meeting_config', array('ctid' => 1), null, null, 0, 'state', 'ASC');

        //$meetingList = get_list('meeting_config', array());

        $certList = get_list('cert_settings', array(), null, null, 0, 'cert_type', 'ASC');

        //echo '<pre>';print_r($certList);exit;

        $data['statuslist'] = $this->customlib->getStatus();

        $data['certList'] = $certList;

        $this->load->view('layout/header', $data);

        $this->load->view('admin/certificate/certificateSettingList', $data);

        $this->load->view('layout/footer', $data);
    }

    public function updatecertificate()

    {


            $certtype = trim($this->input->post('cert_type'));
            // if($certtype != 'fees_entry')
            // {

        // $this->form_validation->set_error_delimiters('', '');
            //    $this->form_validation->set_rules('inst_type', 'School Type', 'required');
            // }
         
        // $this->form_validation->set_rules('inst_type', 'School Type', 'required');

        //        $this->form_validation->set_rules('text_localpassword', 'Password', 'required');

        //        $this->form_validation->set_rules('text_localsenderid', 'Sender ID', 'required');

        if ($this->form_validation->run() or $certtype ='fees_entry') {

            $certtype = trim($this->input->post('cert_type'));
            $certty = '';

            switch ($certtype) {

                case 'cert_leaving':

                    $certty = 'cert_leaving';

                    break;

                case 'cert_bonafide':

                    $certty = 'cert_bonafide';

                    break;

                case 'cert_entry':

                    $certty = 'cert_entry';

                    break;

                case 'fees_entry':

                    $certty = 'fees_entry';

                    break;

                default:

                    break;
            }

            $staffid = $this->customlib->getStaffID();

          $data = array(
    'cert_type'        => $certty,
    'inst_type'        => trim($this->input->post('inst_type', true)) ?? '',
    'cert_auto_insert' => trim($this->input->post('sn_auto_insert', true)) ?? '',
    'cert_prefix'      => trim($this->input->post('sn_prefix', true)) ?? '',
    'cert_start_from'  => trim($this->input->post('sn_start_from', true)) ?? '',
    'cert_no_digit'    => trim($this->input->post('sn_no_digit', true)) ?? '',
    'created_by'       => $staffid,
);

            //$setting_result = $this->setting_model->getSetting();

            $inst_type = trim($this->input->post('inst_type'));

            $setting_result = get_single_row('cert_settings', array('cert_type' => $certty, 'inst_type' => $inst_type));



            $data['cert_update_status'] = 1;

            if (valid($setting_result) && !empty($setting_result) && $this->input->post('sn_auto_insert')) {

                if (
                    $setting_result->cert_prefix != $this->input->post('sn_prefix') ||

                    $setting_result->cert_start_from != $this->input->post('sn_start_from') ||

                    $setting_result->cert_no_digit != $this->input->post('sn_no_digit')

                ) {

                    $data['cert_update_status'] = 0;
                }
            }



            //            if ($this->input->post('staffid_auto_insert'))

            //            {

            //                if ($setting_result->staffid_prefix != $this->input->post('staffid_prefix') ||

            //                        $setting_result->staffid_start_from != $this->input->post('staffid_start_from') ||

            //                        $setting_result->staffid_no_digit != $this->input->post('staffid_no_digit')

            //                )

            //                {

            //                    $data['staffid_update_status'] = 0;

            //                }

            //            }



            $this->smsconfig_model->addCertficate($data);

            echo json_encode(array('st' => 0, 'msg' => "Certificate Setting Updated Successfully."));
        } else {



            $data = array(

                'inst_type' => form_error('inst_type'),

                //                'text_localpassword' => form_error('text_localpassword'),

                //                'text_localsenderid' => form_error('text_localsenderid'),

            );

            echo json_encode(array('st' => 1, 'msg' => $data));
        }
    }
    
    
    public function bonafied_certificate($stdid = '', $serial_no = '')

    {



        if (!valid($stdid))

        {

            redirect('student/search');

        }
         $staffid  = $this->customlib->getStaffID();
        $created_at = date('d-m-Y'); // Format: 14-05-2025
       $sessionid = $this->setting_model->getCurrentSession();
        $tccount = array(
            'student_id'  => $stdid,
            'created_at'  => $created_at,
            'certificate' => 'Bonafied',
            'user_id' => $staffid,
             'sessionid' => $sessionid
        );

        $this->db->insert('certificatecounts', $tccount);
        $cert_lang = $this->language_model->getCertificateEnable_language();

        if(valid($cert_lang) && !empty($cert_lang))

        {

            $cert_lang = current($cert_lang);

            if($cert_lang['short_code'] !== 'en')

            {

                $this->bonafied_certificate_lang($stdid, $serial_no, '', $cert_lang);

            }

            

            if($cert_lang['short_code'] == 'en')

            {

                $this->bonafied_certificate_lang($stdid, $serial_no, '', $cert_lang);

            }

        }

        $std_end_session = $this->student_model->getStudentAlumniSession($stdid);

        if (isset($std_end_session["student_session_id"]) && valid($std_end_session["student_session_id"]))

        {

            $student = $this->student_model->get($stdid, $std_end_session["student_session_id"]);

        }

        else

        {

            $student = $this->student_model->get($stdid);

        }

        //$student = $this->student_model->get($stdid);

        //        $gradeList = $this->grade_model->get();

        $gradeList = '';

        $studentSession = $this->student_model->getStudentSession($stdid);

        $student_session_id = $studentSession["student_session_id"];



        $student_session = $studentSession["session"];

        // $data["session"] = $student_session;       

        $current_student_session = $this->student_model->get_studentsession($student['student_session_id']);



        $data = array();

        $data["session"] = $current_student_session["session"];



        $data['student_doc_id'] = $stdid;

        //        $category_list = $this->category_model->get();

        $category_list = '';

        $data['category_list'] = $category_list;

        $data['gradeList'] = $gradeList;

        $data['student'] = $student;

        $class_section = $this->student_model->getClassSection($student["class_id"]);

        $data["class_section"] = $class_section;

        $session = $this->setting_model->getCurrentSession();



        $setting_result = $this->setting_model->get();

        $data['settinglist'] = $setting_result;

        $settinglist = $setting_result;

        $clsname = (int) filter_var(trim($student['class']), FILTER_SANITIZE_NUMBER_INT);

        if ($clsname < 8)

        {

            $schoolname = valid($settinglist[0]['sch_name_primary']) ? $settinglist[0]['sch_name_primary'] : '-';

            $schoolrecogno = valid($settinglist[0]['sch_recog_primary']) ? $settinglist[0]['sch_recog_primary'] : '-';

            $UDISENumber = valid($settinglist[0]['sch_udise_primary']) ? $settinglist[0]['sch_udise_primary'] : '-';

        }

        elseif ($clsname >= 8 && $clsname <= 10)

        {

            $schoolname = valid($settinglist[0]['sch_name_secondary']) ? $settinglist[0]['sch_name_secondary'] : '-';

            $schoolrecogno = valid($settinglist[0]['sch_recog_secondary']) ? $settinglist[0]['sch_recog_secondary'] : '-';

            $UDISENumber = valid($settinglist[0]['sch_udise_secondary']) ? $settinglist[0]['sch_udise_secondary'] : '-';

        }

        else

        {

            $schoolname = valid($settinglist[0]['sch_name_high_secondary']) ? $settinglist[0]['sch_name_high_secondary'] : '-';

            $schoolrecogno = valid($settinglist[0]['sch_recog_high_secondary']) ? $settinglist[0]['sch_recog_high_secondary'] : '-';

            $UDISENumber = valid($settinglist[0]['sch_udise_high_secondary']) ? $settinglist[0]['sch_udise_high_secondary'] : '-';

        //    $schoolname = 'TIMES PUBLIC SCHOOL';

        //    $schoolrecogno = 'NAMASHA 2009/(152/09)/Secondary-1';

        //    $UDISENumber = getSecondaryUDISENumber();

        }

        // serial number

        if (!valid($serial_no) || empty($serial_no))

        {

            $serial_no = str_pad($student['id'], 4, "0", STR_PAD_LEFT);

        //        $serial_no = strtotime(date('Y-m-d h:i:s'));

            $schtype = getSchoolTypeByClass($student['class']);

            $schtypelower = strtolower($schtype);

            $cert_result = get_single_row('cert_settings', array('cert_type' => 'cert_bonafide', 'inst_type' => $schtypelower));

            if (valid($cert_result) && !empty($cert_result))

            {

                //$setting_result->cert_auto_insert

                //$setting_result->cert_prefix

                //$setting_result->cert_start_from

                //$setting_result->cert_no_digit

                if ($cert_result->cert_auto_insert)

                {

                    //$serial_no = $setting_result->cert_prefix . $setting_result->cert_start_from;

                    $serial_no = $cert_result->cert_prefix . sprintf("%0" . $cert_result->cert_no_digit . "d", $cert_result->cert_start_from);

                    $classIds = $this->class_model->getClassIdBySchoolType($schtype);

                    $stdDetails = $this->student_model->studentCertificateDetails($classIds, 'CERT_BONAFIDE');

                    if (valid($stdDetails) && !empty($stdDetails))

                    {

                        $stddata = current($stdDetails);

                        $snleavingcert = trim($stddata['sn_cert_bonafide']);

                        if (valid($snleavingcert))

                        {

                            $last_serial_no = str_replace($cert_result->cert_prefix, "", $snleavingcert);

                            $serial_no = $cert_result->cert_prefix . sprintf("%0" . $cert_result->cert_no_digit . "d", $last_serial_no + 1);

                        }

                    }

                }

            }

        }

        // update bonafide serial number

        $this->student_model->add(array('id' => $stdid, 'sn_cert_bonafide' => (int) filter_var(trim($serial_no), FILTER_SANITIZE_NUMBER_INT)));

        // end of serial number

        //$html = $this->load->view('reports/bonafiedCertificate', $data, true);

       


        // loading fpdf library

        $this->load->library('Pdf');



        // create new PDF document

        $pdf = new FPDF();

        $pdf->AddPage();

        $pdf->SetFont('Arial', '', 10);

        //if($student['schoolType']=="primary"){

        $clsname = (int) filter_var(trim($student['class']), FILTER_SANITIZE_NUMBER_INT);

        if ($clsname < 8)

        {

//            $pdf->Image(base_url() . '/uploads/certificate/BONAFIDEPrimary.jpg', 1, 1, 210, 0);

//            $pdf->Image(base_url() . '/uploads/certificate/BonafideCertificatePrimary.jpg', 1, 1, 210, 0);

            $pdf->Image(base_url() . '/uploads/certificate/BonafideCertificatePrimary-2.jpg', -3, 16, 200, 0);

        }

        else

        {

//            $pdf->Image(base_url() . '/uploads/certificate/BonafideCertificateSecondary.jpg', 1, 1, 210, 0);

            //$pdf->Image(base_url() . '/uploads/certificate/BonafideCertificateSecondary-2.jpg', -3, 16, 200, 0);

            $pdf->Image(base_url() . '/uploads/certificate/BonafideCertificatePrimary-2.jpg', -3, 16, 200, 0);

        }



        //$qrimage="../assets/qrImage/".$stdid.".png";

        $qrimage = base_url() . "/uploads/qr_image/$stdid.png";

        //$pdf->Image($qrimage, 166, 51, 26, 26);// tps

        $pdf->Image($qrimage, 165, 57, 26, 26);





        $curDate = date('F Y');

        $monthNum = date("m", strtotime($student['admission_date']));

        $monthName = date("F", mktime(0, 0, 0, $monthNum, 10)) . ' ' . date('Y -', strtotime($student['admission_date']));

        $duration = $monthName . ' ' . $curDate;



        //$duration = $this->setting_model->getCurrentSessionName(); // current session name

        $duration = $data["session"]; // std class session name

        $fullname = $student['firstname'] . ' ' . '' . '' . $student['father_name'] . ' ' . $student['lastname'];

        //$no=$no+$id;

        $joinyear = date('Y', strtotime('2068-06-15'));

        $curYear = date('Y');

        $year = date('Y', strtotime($student['admission_date'])) . '-' . date('Y');





        $pdf->Ln(42);

        $pdf->SetFont('Arial', '', 10);

        $pdf->SetFillColor(255, 255, 255); //filling bg color (0,0,0-black; 255,255,255-white)

        //$pdf->Cell(116, 10, '', 0, 0);//tps

        $pdf->Cell(100, 10, '', 0, 0);

        //$pdf->Cell(30, 7, $UDISENumber, 0, 0, "L", true); //udise no.// tps

        $pdf->Cell(22, 7, $UDISENumber, 0, 0, "L", true); //udise no.

        //$pdf->Ln(69);

        $pdf->Ln(5);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(14, 40, '', 0, 0);

        $pdf->Cell(70, 40, $serial_no, 0, 0);

        //$pdf->Cell(55, 40, $student['admission_no'], 0, 0, "L");// tps

        $pdf->Cell(45, 40, $student['admission_no'], 0, 0, "L");

        $pdf->Cell(30, 40, date('d-m-Y'), 0, 0, "L");



        $pdf->Ln(16);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(80, 10, '', 0, 0);

        $pdf->Cell(100, 25, $fullname, 0, 0, "L");

        $pdf->Ln(1);

        $pdf->SetFont('Times', 'BI', 14);

        $pdf->Cell(180, 10, ' ', 0, 0, "R");



        $pdf->Ln(10);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(110, 10, '', 0, 0);

        //$pdf->Cell(60,10,$student['nowstudyingclass'],0,0,"L");

        $pdf->Cell(60, 25, $student['class'], 0, 0, "L");

        $pdf->Ln(1);

        $pdf->SetFont('Times', 'BI', 10);

        $pdf->Cell(180, 10, '', 0, 0, "R");



        $pdf->Ln(4);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(16, 10, '', 0, 0);

        $pdf->Cell(20, 28, $duration, 0, 0, "C");

        $pdf->Ln(1);

        $pdf->SetFont('Times', 'BI', 14);

        $pdf->Cell(100, 12, '', 0, 0, "R");



        //$pdf->Ln(9);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(40, 20, '', 0, 0);

        $pdf->Cell(50, 26, valid($student['dob']) ? date('d-m-Y', strtotime($student['dob'])) : '', 0, 0, "L");

        $dobWord = '-';

        if (valid($student['dob']))

        {

            $new_birth_date = explode('-', trim($student['dob']));

            $year = $new_birth_date[0];

            $monthWord = date('F', strtotime($student['dob']));

            $day = $new_birth_date[2];

            $dobWord = ucwords(getIndianCurrencyInWord($day, '', '') . ' ' . $monthWord . ' ' . getIndianCurrencyInWord($year, '', ''));

        }



        $pdf->Ln(8);

        //$pdf->Cell(140,10,$student['birthdayinwords'],0,0,"C");

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(120, 22, $dobWord, 0, 0, "C");

        $pdf->Ln(8);

        $pdf->Cell(20, 22, '', 0, 0, "C");

        $subcas = valid(trim($student['subcas'])) ? '(' . ucwords($student['subcas']) . ')' : '';

        $religion = valid(trim($student['religion'])) ? ' (' . ucwords($student['religion']) . ')' : '';

        $pdf->Cell(60, 18, $student['cast'] . $subcas . $religion, 0, 0, "L");



        $pdf->Ln(1);

        $pdf->SetFont('Times', 'BI', 14);

        $pdf->Cell(180, 10, '', 0, 0, "R");



        if ($clsname < 8)

        {

            $pdf->Ln(34);

        }

        else

        {

//            $pdf->Ln(39);

            $pdf->Ln(34);

        }

        $pdf->SetFont('Times', 'BI', 14);

        $pdf->Cell(170, 10, '  ', 0, 0, "L");





        $pdf->Ln(46);

        $pdf->SetFont('Arial', '', 10);

        $pdf->SetFillColor(255, 255, 255); //filling bg color (0,0,0-black; 255,255,255-white)

        //$pdf->Cell(111, 10, '', 0, 0);//tps

        $pdf->Cell(101, 10, '', 0, 0);

        //$pdf->Cell(60, 7, $UDISENumber, 0, 0, "L", true); //udise no.//tps

        $pdf->Cell(22, 8, $UDISENumber, 0, 0, "L", true); //udise no.

        //$pdf->Ln(69);

        $pdf->Ln(6);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(14, 40, '', 0, 0);

        $pdf->Cell(70, 40, $serial_no, 0, 0);

        $pdf->Cell(55, 40, $student['admission_no'], 0, 0, "L");

        $pdf->Cell(30, 40, date('d-m-Y'), 0, 0, "L");



        $pdf->Ln(16);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(80, 10, '', 0, 0);

        $pdf->Cell(100, 25, $fullname, 0, 0, "L");

        $pdf->Ln(1);

        $pdf->SetFont('Times', 'BI', 14);

        $pdf->Cell(180, 10, ' ', 0, 0, "R");



        $pdf->Ln(10);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(110, 10, '', 0, 0);

        //$pdf->Cell(60,10,$student['nowstudyingclass'],0,0,"L");

        $pdf->Cell(60, 25, $student['class'], 0, 0, "L");

        $pdf->Ln(1);

        $pdf->SetFont('Times', 'BI', 10);

        $pdf->Cell(180, 10, '', 0, 0, "R");



        $pdf->Ln(4);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(16, 10, '', 0, 0);

        $pdf->Cell(20, 28, $duration, 0, 0, "C");

        $pdf->Ln(1);

        $pdf->SetFont('Times', 'BI', 14);

        $pdf->Cell(100, 12, '', 0, 0, "R");



        //$pdf->Ln(9);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(40, 20, '', 0, 0);

        $pdf->Cell(50, 26, valid($student['dob']) ? date('d-m-Y', strtotime($student['dob'])) : '', 0, 0, "L");

        $dobWord = '-';

        if (valid($student['dob']))

        {

            $new_birth_date = explode('-', trim($student['dob']));

            $year = $new_birth_date[0];

            $monthWord = date('F', strtotime($student['dob']));

            $day = $new_birth_date[2];

            $dobWord = ucwords(getIndianCurrencyInWord($day, '', '') . ' ' . $monthWord . ' ' . getIndianCurrencyInWord($year, '', ''));

        }



        $pdf->Ln(8);

        //$pdf->Cell(140,10,$student['birthdayinwords'],0,0,"C");

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(120, 22, $dobWord, 0, 0, "C");

        $pdf->Ln(9);

        $pdf->Cell(20, 22, '', 0, 0, "C");

        $subcas = valid(trim($student['subcas'])) ? '(' . ucwords($student['subcas']) . ')' : '';

        $pdf->Cell(60, 18, $student['cast'] . $subcas, 0, 0, "L");





        //$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);   

        // ---------------------------------------------------------    

        // Close and output PDF document

        // This method has several options, check the source code documentation for more information.

        $pdf->Output($fullname . '.pdf', 'I');

    }



    public function leaving_certificate($stdid = '', $serial_no = '', $formatedName = '')

    {
        
        //   ini_set('display_errors', 1);
        //     error_reporting(E_ALL);


        if (!valid($stdid))

        {

            redirect('student/search');

        }

        
           $statusdata = array(
            'is_active' => 'no',
            'dis_reason' => '1',
            'dis_note' => 'Moved to another school',
            'disable_at'  => date('Y-m-d')
        );
         $this->db->where('id', $stdid);
        $this->db->update('students', $statusdata);
         $staffid  = $this->customlib->getStaffID();
            $sessionid = $this->setting_model->getCurrentSession();
         $created_at = date('d-m-Y'); // Format: 14-05-2025

         $tccount = array(
          'student_id'  => $stdid,
            'created_at'  => $created_at,
            'certificate' => 'Leaving',
            'user_id' => $staffid,
             'sessionid' => $sessionid
        );

        $this->db->insert('certificatecounts', $tccount);
        $cert_lang = $this->language_model->getCertificateEnable_language();
        

        if(valid($cert_lang) && !empty($cert_lang))

        {

            $cert_lang = current($cert_lang);
            
           

            if($cert_lang['short_code'] !== 'en')

            {

                $this->leaving_certificate_lang($stdid, $serial_no, $formatedName, $cert_lang);

            }

            if($cert_lang['short_code'] == 'en')

            {

                $this->leaving_certificate_lang($stdid, $serial_no, $formatedName, $cert_lang);

            }

        }

        

        $date = date('Y-m-d H:i:s');

        $stdid = $stdid;

        $std_end_session = $this->student_model->getStudentAlumniSession($stdid);

        if (isset($std_end_session["student_session_id"]) && valid($std_end_session["student_session_id"]))

        {

            $student = $this->student_model->get($stdid, $std_end_session["student_session_id"]);

        }

        else

        {

            $student = $this->student_model->get($stdid);

        }

        //$student_bal_fees = $this->studentfeemaster_model->getStudentBalanceFees($student['student_session_id']);

        $student_bal_fees = 0;

        if ($student_bal_fees > 0)

        {

            //$this->session->set_flashdata('msg', '<div class="alert alert-success">Student added Successfully</div>');

            //error("Could not print the Certificate since the student having the balance fees of Rs. " . number_format($student_bal_fees));

            //access_denied();

        }

        //echo '<pre>';print_r($student);exit;

//        $gradeList = $this->grade_model->get();

        $gradeList = '';

        $studentSession = $this->student_model->getStudentSession($stdid);

        $student_session_id = $studentSession["student_session_id"];



        $student_session = $studentSession["session"];

        // $data["session"] = $student_session;       

        $current_student_session = $this->student_model->get_studentsession($student['student_session_id']);



        $data = array();

        $data["session"] = $current_student_session["session"];



        $data['student_doc_id'] = $stdid;

        $category_list = $this->category_model->get();

        //$category_list = '';

        $data['category_list'] = $category_list;

        $data['gradeList'] = $gradeList;

        $data['student'] = $student;

        $class_section = $this->student_model->getClassSection($student["class_id"]);

        $data["class_section"] = $class_section;

        $session = $this->setting_model->getCurrentSession();

        $setting_result = $this->setting_model->get();

        $data['settinglist'] = $setting_result;



        $clsname = (int) filter_var(trim($student['class']), FILTER_SANITIZE_NUMBER_INT);

        $settinglist = $setting_result;

        if ($clsname < 8)

        {

            $schoolname = valid($settinglist[0]['sch_name_primary']) ? $settinglist[0]['sch_name_primary'] : '-';

            $schoolrecogno = valid($settinglist[0]['sch_recog_primary']) ? $settinglist[0]['sch_recog_primary'] : '-';

            $UDISENumber = valid($settinglist[0]['sch_udise_primary']) ? $settinglist[0]['sch_udise_primary'] : '-';

        }

        elseif ($clsname >= 8 && $clsname <= 10)

        {

            $schoolname = valid($settinglist[0]['sch_name_secondary']) ? $settinglist[0]['sch_name_secondary'] : '-';

            $schoolrecogno = valid($settinglist[0]['sch_recog_secondary']) ? $settinglist[0]['sch_recog_secondary'] : '-';

            $UDISENumber = valid($settinglist[0]['sch_udise_secondary']) ? $settinglist[0]['sch_udise_secondary'] : '-';

        }

        else

        {

            $schoolname = valid($settinglist[0]['sch_name_high_secondary']) ? $settinglist[0]['sch_name_high_secondary'] : '-';

            $schoolrecogno = valid($settinglist[0]['sch_recog_high_secondary']) ? $settinglist[0]['sch_recog_high_secondary'] : '-';

            $UDISENumber = valid($settinglist[0]['sch_udise_high_secondary']) ? $settinglist[0]['sch_udise_high_secondary'] : '-';

//    $schoolname = 'TIMES PUBLIC SCHOOL';

//    $schoolrecogno = 'NAMASHA 2009/(152/09)/Secondary-1';

//    $UDISENumber = getSecondaryUDISENumber();

        }

        // serial number

        if (!valid($serial_no) || empty($serial_no))

        {

            $serial_no = str_pad($student['id'], 4, "0", STR_PAD_LEFT);

//        $serial_no = strtotime(date('Y-m-d h:i:s'));

            $schtype = getSchoolTypeByClass($student['class']);

            $schtypelower = strtolower($schtype);

            $cert_result = get_single_row('cert_settings', array('cert_type' => 'cert_leaving', 'inst_type' => $schtypelower));

            if (valid($cert_result) && !empty($cert_result))

            {

                //$setting_result->cert_auto_insert

                //$setting_result->cert_prefix

                //$setting_result->cert_start_from

                //$setting_result->cert_no_digit

                if ($cert_result->cert_auto_insert)

                {

                    //$serial_no = $setting_result->cert_prefix . $setting_result->cert_start_from;

                    $serial_no = $cert_result->cert_prefix . sprintf("%0" . $cert_result->cert_no_digit . "d", $cert_result->cert_start_from);

                    $classIds = $this->class_model->getClassIdBySchoolType($schtype);

                    $stdDetails = $this->student_model->studentCertificateDetails($classIds, 'CERT_LEAVING');

                    if (valid($stdDetails) && !empty($stdDetails))

                    {

                        $stddata = current($stdDetails);

                        $snleavingcert = trim($stddata['sn_cert_leaving']);

                        if (valid($snleavingcert))

                        {

                            $last_serial_no = str_replace($cert_result->cert_prefix, "", $snleavingcert);

                            $serial_no = $cert_result->cert_prefix . sprintf("%0" . $cert_result->cert_no_digit . "d", $last_serial_no + 1);

                        }

                    }

                }

            }

        }

        // update bonafide serial number

        $this->student_model->add(array('id' => $stdid, 'sn_cert_leaving' => (int) filter_var(trim($serial_no), FILTER_SANITIZE_NUMBER_INT)));

        // end of serial number

        //$html = $this->load->view('reports/bonafiedCertificate', $data, true);

        // loading QR code library

        $this->load->library('QRCode');

        $qr = new BarcodeQR();

        $schoolName = $setting_result[0]['name'];

        $fullname = $student['firstname'] . ' ' . $student['father_name'] . ' ' . $student['lastname'];

        $text = $schoolName . "  , UDISE Number:-" . $UDISENumber . " , Rollno:- " . $student['roll_no'] . " , name:- " . $fullname . " , class:- " . $student['class'];

        $qr->text($text);

//        $image = "../assets/qrImage/" . $stdid . ".png";

        $image = "./uploads/qr_image/" . $stdid . ".png";

//        move_uploaded_file($_FILES["file"]["tmp_name"], "./uploads/student_images/" . $img_name);

        $qr->draw(150, $image);



        // loading fpdf library

        $this->load->library('Pdf');



        // create new PDF document

//        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        $pdf = new FPDF();

        $pdf->AddPage();

        $pdf->SetFont('Arial', '', 10);

        //if($student['schoolType']=="primary"){

        $clss = intval($student['class']);

//        if ($clss < 8)

        if ($clsname < 8)

        {

            //$pdf->Image(base_url() . '/uploads/certificate/LeavingCertificatePrimary.jpg', -1, 13, 205, 0);//tps

            $pdf->Image(base_url() . '/uploads/certificate/LeavingCertificatePrimary.jpg', -1, 12, 205, 0);

        }

        else

        {

//            $pdf->Image(base_url() . '/uploads/certificate/LeavingCertificateSecondary.jpg', 1, 3, 210, 0);

            //$pdf->Image(base_url() . '/uploads/certificate/LeavingCertificateSecondary.jpg', -1, 13, 205, 0);//TPS

            $pdf->Image(base_url() . '/uploads/certificate/LeavingCertificatePrimary.jpg', -1, 12, 205, 0);

        }





        $curDate = date('d-m-y');

        $monthNum = date("m", strtotime($curDate));

        $monthName = date("F", mktime(0, 0, 0, $monthNum, 8));

        $fullname = $student['firstname'] . ' ' . $student['father_name'] . ' ' . $student['lastname'];
        $qrimage = '';
        if(file_exists(base_url() . "/uploads/qr_image/$stdid.png"))
        {

        $qrimage = base_url() . "/uploads/qr_image/$stdid.png";
      


        $pdf->Image($qrimage, 183, 3, 22, 22);

  }

        $pdf->Ln(43);

        $pdf->SetFont('Arial', '', 10);

        $pdf->SetTextColor(0, 0, 0);

        $pdf->Cell(25, 8, '', 0, 0);

        $pdf->Cell(40, 10, $serial_no, 0, 0);

        $pdf->Cell(90, 8, '', 0, 0);

        $pdf->Cell(35, 10, $student['admission_no'], 0, 0);



        $pdf->Ln(13);

        $pdf->SetFont('Arial', '', 10);

        $pdf->SetFillColor(255, 255, 255); //filling bg color (0,0,0-black; 255,255,255-white)

//        $pdf->SetFillColor(0,0,0);//filling bg color (0,0,0-black; 255,255,255-white)

        $pdf->Cell(22, 10, '', 0, 0);

        $pdf->Cell(50, 5, $UDISENumber, 0, 0, "L", true); //udise no.

//        $pdf->Ln(23);

        if ($clsname < 8)

        {

            $pdf->Ln(23);

        }

        else

        {

            $pdf->Ln(26);

        }

        $pdf->SetFont('Arial', '', 11);

        $pdf->SetTextColor(0, 0, 0);

        $pdf->Cell(66, 8, '', 0, 0);

        $pdf->Cell(135, -6, $student['std_global_id'], 0, 0);



        $pdf->Ln(7);

        $pdf->Cell(66, 8, '', 0, 0);

        $pdf->Cell(135, -8, $student['adhar_no'], 0, 0);

        $pdf->Ln(10);

        

        $pdf->Cell(65, 8, '', 0, 0);

        

        $formatedName = urldecode($formatedName);

        if(valid($formatedName) && !empty($formatedName))

        {

            $pdf->SetFillColor(255, 255, 255);

            $pdf->Cell(117, -11, strtoupper($formatedName), 0, 0, '',true);

        }

        else

        {

            $pdf->Cell(49, -8, strtoupper($student['firstname']), 0, 0);

            $pdf->Cell(44, -8, strtoupper($student['father_name']), 0, 0);

            $pdf->Cell(45, -8, strtoupper($student['lastname']), 0, 0);



        }

        $pdf->Ln(12);

        

        $pdf->Cell(66, 8, '', 0, 0);

        $pdf->Cell(135, -8, strtoupper($student['mother_name']), 0, 0);

        $pdf->Ln(7);

        $pdf->Cell(66, 8, '', 0, 0);

        $pdf->Cell(35, -9, strtoupper($student['nationality']), 0, 0, 'L');



        $pdf->Cell(43, 8, '', 0, 0);

        $pdf->Cell(55, -9, strtoupper($student['mother_tongue']), 0, 0, 'L');

        $pdf->Ln(5);

        $pdf->Cell(66, 8, '', 0, 0);

        $pdf->Cell(43, -7, strtoupper($student['religion']), 0, 0, 'L');

        $pdf->Cell(20, -7, '', 0, 0);

        $pdf->Cell(60, -7, strtoupper($student['cast']), 0, 0, 'L');

        $catName = '';

        foreach ($category_list as $value)

        {

            if ($student['category_id'] == $value['id'])

            {

                $catName = $value['category'];

                break;

            }

        }

        $pdf->Ln(6);

        $pdf->Cell(130, 8, '', 0, 0);

        $pdf->Cell(100, -8, strtoupper($student['subcas']), 0, 0, 'L');

//        $pdf->Cell(98, -8, '', 0, 0, 'C');



        $pdf->Ln(6);

        $pdf->Cell(66, 8, '', 0, 0);

        $pdf->Cell(50, -7, strtoupper($student['place_of_birth']), 0, 0, 'L');

        $pdf->Ln(6);

        $pdf->Cell(84, 8, '', 0, 0);

        $pdf->Cell(50, -7, strtoupper($student['birth_taluka']), 0, 0, 'L');

        $pdf->Cell(12, -7, '', 0, 0);

        $pdf->Cell(40, -7, strtoupper($student['birth_district']), 0, 0, 'L');

        $pdf->Ln(6);

        $pdf->Cell(75, 8, '', 0, 0);

        $pdf->Cell(4, -7, '', 0, 0);

        $pdf->Cell(40, -7, strtoupper($student['state']), 0, 0, 'L');



        $pdf->Ln(6);

        $pdf->Cell(66, 8, '', 0, 0);

        $pdf->Cell(60, -7, valid($student['dob']) ? date('d-m-Y', strtotime($student['dob'])) : '', 0, 0);

        $dobWord = '-';

        if (valid($student['dob']))

        {

            $new_birth_date = explode('-', trim($student['dob']));

            $year = $new_birth_date[0];

            $monthWord = date('F', strtotime($student['dob']));

            $day = $new_birth_date[2];

            $dobWord = ucwords(getIndianCurrencyInWord($day, '', '') . ' ' . $monthWord . ' ' . getIndianCurrencyInWord($year, '', ''));

        }



        $pdf->Ln(6);

        $pdf->Cell(66, 8, '', 0, 0);

        $pdf->Cell(60, -7, strtoupper($dobWord), 0, 0);

        $pdf->Ln(6);

        $pdf->Cell(66, 8, '', 0, 0);

        $pdf->Cell(130, -8, strtoupper($student['prev_school_name']), 0, 0);

        $pdf->Ln(6);

        $pdf->Cell(66, 8, '', 0, 0);

        //$pdf->Cell(130,8,$student['standardattened'],0,0);

        $pdf->Cell(130, -8, strtoupper($student['prev_school_standard_covered']), 0, 0);

        $pdf->Ln(10);

        $pdf->Cell(66, 8, '', 0, 0);

        $pdf->Cell(135, -8, valid($student['admission_date']) ? date('d-m-Y', strtotime($student['admission_date'])) : '', 0, 0);

        $pdf->Ln(10);

        $pdf->Cell(66, 8, '', 0, 0);

        //$pdf->Cell(135,7,$student['nowstudyingclass'],0,0);

        $pdf->Cell(135, -7, strtoupper($student['class_studing_since_when']), 0, 0);

        $pdf->Ln(10);

        $pdf->Cell(66, 8, '', 0, 0);

        //$pdf->Cell(135,7,$student['academicperforence'],0,0);

        $pdf->Cell(82, -9, strtoupper($student['academic_preference']), 0, 0);

        $pdf->Cell(65, -9, strtoupper($student['academic_conduct']), 0, 0);

        $pdf->Ln(6);

        $dolWord = '-';

        if (valid($student['date_of_leaving']))

        {

            if (strpos($student['date_of_leaving'], '-') != false)

            {

                $new_birth_date = explode('-', trim($student['date_of_leaving']));

                $day = $new_birth_date[0];

            }

            else

            {

                $new_birth_date = explode('/', trim($student['date_of_leaving']));

                $day = $new_birth_date[1];

            }



            $year = $new_birth_date[2];

            $monthWord = date('F', strtotime($student['date_of_leaving']));



            $dolWord = ucwords(getIndianCurrencyInWord($day, '', '') . ' ' . $monthWord . ' ' . getIndianCurrencyInWord($year, '', ''));

            

        }

        $pdf->Cell(66, 8, '', 0, 0);

        $pdf->Cell(135, -7, valid($student['date_of_leaving']) ? date('d-m-Y', strtotime($student['date_of_leaving'])) . '' : '', 0, 0);

        $pdf->Ln(5);

        $pdf->Cell(66, 8, '', 0, 0);

        $pdf->Cell(135, -7, strtoupper($dolWord), 0, 0);



        $pdf->Ln(6);

        $pdf->Cell(66, 8, '', 0, 0);

        $pdf->Cell(135, -7, strtoupper(substr($student['reason_of_leaving'], 0, 52)), 0, 0);



        $pdf->Ln(6);

        $pdf->Cell(66, 8, '', 0, 0);

        $pdf->Cell(135, -7, '-' . strtoupper(substr($student['reason_of_leaving'], 52, strlen($student['reason_of_leaving']))), 0, 0);



        $pdf->Ln(6);

        $pdf->Cell(66, 8, '', 0, 0);

        $pdf->Cell(135, -7, strtoupper(substr($student['remarks'], 0, 52)), 0, 0);

        $pdf->Ln(6);

        $pdf->Cell(66, 8, '', 0, 0);

        $pdf->Cell(135, -7, '-' . strtoupper(substr($student['remarks'], 52, strlen($student['remarks']))), 0, 0);



        $pdf->Ln(14);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(10, 8, '', 0, 0);

        $pdf->Cell(80, -7, date('d-m-Y'), 0, 0); // current date

        

        //$pdf->Image($qrimage, 170, 246, 32, 32);

        //

        //$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);   

        // ---------------------------------------------------------    

        // Close and output PDF document

        // This method has several options, check the source code documentation for more information.

        $pdf->Output($fullname . '.pdf', 'I');

    }



    public function entry_certificate($stdid = '', $serial_no = '')

    {



        if (!valid($stdid))

        {

            redirect('student/search');

        }
        $staffid  = $this->customlib->getStaffID();

        $created_at = date('d-m-Y'); // Format: 14-05-2025

       $sessionid = $this->setting_model->getCurrentSession();
        $entry_certificatecount = array(
            'student_id'  => $stdid,
            'created_at'  => $created_at,
            'certificate' => 'Entry',
            'user_id' => $staffid,
             'sessionid' => $sessionid
        );

        $this->db->insert('certificatecounts', $entry_certificatecount);

        $cert_lang = $this->language_model->getCertificateEnable_language();

        if(valid($cert_lang) && !empty($cert_lang))

        {

            $cert_lang = current($cert_lang);

            if($cert_lang['short_code'] !== 'en' || 1)

            {

                $this->entry_certificate_lang($stdid, $serial_no, '', $cert_lang);

            }

        }

        $std_end_session = $this->student_model->getStudentAlumniSession($stdid);

        if (isset($std_end_session["student_session_id"]) && valid($std_end_session["student_session_id"]))

        {

            $student = $this->student_model->get($stdid, $std_end_session["student_session_id"]);

        }

        else

        {

            $student = $this->student_model->get($stdid);

        }

        //$student = $this->student_model->get($stdid);

//        $gradeList = $this->grade_model->get();

        $gradeList = '';

        $studentSession = $this->student_model->getStudentSession($stdid);

        $student_session_id = $studentSession["student_session_id"];



        $student_session = $studentSession["session"];

        // $data["session"] = $student_session;       

        $current_student_session = $this->student_model->get_studentsession($student['student_session_id']);



        $data = array();

        $data["session"] = $current_student_session["session"];



        $data['student_doc_id'] = $stdid;

//        $category_list = $this->category_model->get();

        $category_list = '';

        $data['category_list'] = $category_list;

        $data['gradeList'] = $gradeList;

        $data['student'] = $student;

        $class_section = $this->student_model->getClassSection($student["class_id"]);

        $data["class_section"] = $class_section;

        $session = $this->setting_model->getCurrentSession();

        $setting_result = $this->setting_model->get();

        $data['settinglist'] = $setting_result;

        $settinglist = $setting_result;

        $clsname = (int) filter_var(trim($student['class']), FILTER_SANITIZE_NUMBER_INT);

        if ($clsname < 8)

        {

            $schoolname = valid($settinglist[0]['sch_name_primary']) ? $settinglist[0]['sch_name_primary'] : '-';

            $schoolrecogno = valid($settinglist[0]['sch_recog_primary']) ? $settinglist[0]['sch_recog_primary'] : '-';

            $UDISENumber = valid($settinglist[0]['sch_udise_primary']) ? $settinglist[0]['sch_udise_primary'] : '-';

        }

        elseif ($clsname >= 8 && $clsname <= 10)

        {

            $schoolname = valid($settinglist[0]['sch_name_secondary']) ? $settinglist[0]['sch_name_secondary'] : '-';

            $schoolrecogno = valid($settinglist[0]['sch_recog_secondary']) ? $settinglist[0]['sch_recog_secondary'] : '-';

            $UDISENumber = valid($settinglist[0]['sch_udise_secondary']) ? $settinglist[0]['sch_udise_secondary'] : '-';

        }

        else

        {

            $schoolname = valid($settinglist[0]['sch_name_high_secondary']) ? $settinglist[0]['sch_name_high_secondary'] : '-';

            $schoolrecogno = valid($settinglist[0]['sch_recog_high_secondary']) ? $settinglist[0]['sch_recog_high_secondary'] : '-';

            $UDISENumber = valid($settinglist[0]['sch_udise_high_secondary']) ? $settinglist[0]['sch_udise_high_secondary'] : '-';

//    $schoolname = 'TIMES PUBLIC SCHOOL';

//    $schoolrecogno = 'NAMASHA 2009/(152/09)/Secondary-1';

//    $UDISENumber = getSecondaryUDISENumber();

        }

        // serial number

        if (!valid($serial_no) || empty($serial_no))

        {

            $serial_no = str_pad($student['id'], 4, "0", STR_PAD_LEFT);

//        $serial_no = strtotime(date('Y-m-d h:i:s'));

            $schtype = getSchoolTypeByClass($student['class']);

            $schtypelower = strtolower($schtype);

            $cert_result = get_single_row('cert_settings', array('cert_type' => 'cert_entry', 'inst_type' => $schtypelower));

            if (valid($cert_result) && !empty($cert_result))

            {

                //$setting_result->cert_auto_insert

                //$setting_result->cert_prefix

                //$setting_result->cert_start_from

                //$setting_result->cert_no_digit

                if ($cert_result->cert_auto_insert)

                {

                    //$serial_no = $setting_result->cert_prefix . $setting_result->cert_start_from;

                    $serial_no = $cert_result->cert_prefix . sprintf("%0" . $cert_result->cert_no_digit . "d", $cert_result->cert_start_from);

                    $classIds = $this->class_model->getClassIdBySchoolType($schtype);

                    $stdDetails = $this->student_model->studentCertificateDetails($classIds, 'CERT_ENTRY');

                    if (valid($stdDetails) && !empty($stdDetails))

                    {

                        $stddata = current($stdDetails);

                        $snleavingcert = trim($stddata['sn_cert_entry']);

                        if (valid($snleavingcert))

                        {

                            $last_serial_no = str_replace($cert_result->cert_prefix, "", $snleavingcert);

                            $serial_no = $cert_result->cert_prefix . sprintf("%0" . $cert_result->cert_no_digit . "d", $last_serial_no + 1);

                        }

                    }

                }

            }

        }

        // update bonafide serial number

        $this->student_model->add(array('id' => $stdid, 'sn_cert_entry' => (int) filter_var(trim($serial_no), FILTER_SANITIZE_NUMBER_INT)));



        // end of serial number

        //$html = $this->load->view('reports/bonafiedCertificate', $data, true);

        // loading QR code library

        $this->load->library('QRCode');

        $qr = new BarcodeQR();

        $schoolName = $setting_result[0]['name'];

        $fullname = $student['firstname'] . ' ' . $student['father_name'] . ' ' . $student['lastname'];

        $text = $schoolName . "  , UDISE Number:-" . $UDISENumber . " , Rollno:- " . $student['roll_no'] . " , name:- " . $fullname . " , class:- " . $student['class'];

        $qr->text($text);

//        $image = "../assets/qrImage/" . $stdid . ".png";

        $image = "./uploads/qr_image/" . $stdid . ".png";

//        move_uploaded_file($_FILES["file"]["tmp_name"], "./uploads/student_images/" . $img_name);

        $qr->draw(150, $image);



        // loading fpdf library

        $this->load->library('Pdf');



        // create new PDF document

//        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        $pdf = new FPDF();

        $pdf->AddPage();

        $pdf->SetFont('Arial', '', 10);

        //if($student['schoolType']=="primary"){

        $curDate = date('F-y');

        $monthNum = date("m", strtotime($curDate));

        $monthName = date("F", mktime(0, 0, 0, $monthNum, 10));

//        if ($row['schoolType'] == "primary")

        if ($clsname < 8)

        {

//            $pdf->Image(base_url() . '/uploads/certificate/NirgamaPrimary.jpg', 1, 1, 210, 0);

//            $pdf->Image(base_url() . '/uploads/certificate/EntryCertificatePrimary.jpg', 1, 1, 210, 0);

            //$pdf->Image(base_url() . '/uploads/certificate/EntryCertificatePrimary-2.jpg', 1, 12, 200, 0);

            $pdf->Image(base_url() . '/uploads/certificate/entry_certificate_k-1.jpg', 1, 12, 200, 0);

        }

        else

        {

//            $pdf->Image(base_url() . '/uploads/certificate/NirgamaSecondary.jpg', 1, 1, 210, 0);

//            $pdf->Image(base_url() . '/uploads/certificate/EntryCertificateSecondary.jpg', 1, 1, 210, 0);

            $pdf->Image(base_url() . '/uploads/certificate/EntryCertificateSecondary-2.jpg', 1, 12, 200, 0);

        }

//            $qrimage = base_url() . "/uploads/certificate/qrImage/" . $stdid . ".png";

        $qrimage = base_url() . "/uploads/qr_image/$stdid.png";

        // $pdf->Image($qrimage, 183, 3, 22, 22);  // commenting for temporary QR issue



        $pdf->Ln(0);

        $pdf->SetFont('Arial', '', 8);

        $pdf->SetTextColor(0, 0, 0);

        $pdf->Cell(6, 8, '', 0, 0);

        $pdf->Cell(100, 82, 'No.: ' . $serial_no, 0, 0, "L");



        //$pdf->Ln(65);

        $pdf->Ln(74);

        $pdf->SetFont('Arial', '', 10);

        $pdf->SetTextColor(0, 0, 0);

        $pdf->Cell(75, 8, '', 0, 0);

        $pdf->Cell(70, -4, $student['admission_no'], 0, 0, "L");



        $pdf->Ln(10);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(60, 8, '', 0, 0);

        $pdf->Cell(40, 8, $student['firstname'], 0, 0, "L");

        $pdf->Cell(42, 8, $student['father_name'], 0, 0, "L");

        $pdf->Cell(40, 8, $student['lastname'], 0, 0, "L");



        $pdf->Ln(8);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(40, 8, '', 0, 0);

        $pdf->Cell(53, 7, $student['mother_name'], 0, 0, "C");

        //$pdf->Ln(5);

        //$pdf->Cell(67, 10, $student['roll_no'], 0, 0, 'R');

        //$pdf->Cell(90, 8, $student['adhar_no'], 0, 0, "L");







        $pdf->Ln(7);

        $pdf->Cell(60, 8, '', 0, 0);

//        $pdf->Cell(90, 7, $student['nationality'], 0, 0, 'L');

        $pdf->Cell(90, 7, '', 0, 0, 'L');

//        $pdf->Cell(40, 7, $student['mother_tongue'], 0, 0, 'L');

        $pdf->Cell(40, 7, '', 0, 0, 'L');



        $pdf->Ln(6);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(45, 8, '', 0, 0);

        $pdf->Cell(55, 5, $student['religion'], 0, 0, 'C');

        $subcas = valid(trim($student['subcas'])) ? '(' . ucwords($student['subcas']) . ')' : '';

        $pdf->Cell(55, 5, $student['cast'] . $subcas, 0, 0, 'L');

//        $pdf->Cell(40, 7, $student['subcaste'], 0, 0, 'L');

        $pdf->Cell(40, 7, ' ', 0, 0, 'L');





        //$pdf->Ln(6);

        //$pdf->Cell(105, 8, '', 0, 0);

        //$pdf->Cell(40, 7, $student['state'], 0, 0);

        // $pdf->Cell(40, 7, 'Maharashtra', 0, 0);



        $pdf->Ln(6);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(40, 8, '', 0, 0);

        $pdf->Cell(120, 8, valid($student['dob']) ? date('d-m-Y', strtotime($student['dob'])) : '-', 0, 0, 'C');

        $pdf->Ln(10);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(66, 8, '', 0, 0);

        $dobWord = '-';

        if (valid($student['dob']))

        {

            $new_birth_date = explode('-', trim($student['dob']));

            $year = $new_birth_date[0];

            $monthWord = date('F', strtotime($student['dob']));

            $day = $new_birth_date[2];

            $dobWord = ucwords(getIndianCurrencyInWord($day, '', '') . ' ' . $monthWord . ' ' . getIndianCurrencyInWord($year, '', ''));

        }

        $pdf->Cell(100, 17, strtoupper($dobWord), 0, 0, 'R');



        $pdf->Ln(8);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(68, 27, '', 0, 0);

        $place_of_birth = $student['place_of_birth'];

        if (valid($student['birth_taluka']))

        {

            $place_of_birth .= ', Taluka-' . $student['birth_taluka'];

        }

        if (valid($student['birth_district']))

        {

            //$place_of_birth .= ', District-'.$student['birth_district'];

        }

        $pdf->Cell(55, 20, strtoupper($place_of_birth), 0, 0, 'L');

        //$pdf->Cell(55, 17, $student['place_of_birth'], 0, 0, 'L');

        //$pdf->Cell(37, 17, $student['birth_taluka'], 0, 0, 'L');

        //$pdf->Cell(40, 17, $student['birth_district'], 0, 0, 'C');



        $pdf->Ln(8);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(90, 8, '', 0, 0);

        $pdf->Cell(140, 22, strtoupper($student['prev_school_name']), 0, 0, 'L');

        $pdf->Ln(10);

        $pdf->Cell(90, 8, '', 0, 0);

//        $pdf->Cell(130, 8, $student['prev_school_standard_covered'], 0, 0);

        $pdf->Cell(80, 19, strtoupper($student['prev_school_standard_covered']), 0, 0);

        $pdf->Ln(2);

        $pdf->Cell(90, 8, '', 0, 0);

        $pdf->Cell(40, 28, strtoupper($student['prev_school_tcnumber']), 0, 0, 'L');

        $pdf->Ln(12);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(76, 8, '', 0, 0);

        $pdf->Cell(140, 19, valid($student['admission_date']) ? date('d-m-Y', strtotime($student['admission_date'])) : '', 0, 0, 'L');



        $pdf->Ln(12);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(75, 8, '', 0, 0);

        $pdf->Cell(77, 10, $student['std_global_id'], 0, 0, 'L');



        $pdf->Ln(2);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(75, 8, '', 0, 0);

        $pdf->Cell(20, 20, $student['adhar_no'], 0, 0, "L");



        $pdf->Ln(12);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(75, 8, '', 0, 0);

        $pdf->Cell(100, 15, $student['fillbyoffice_admittedto'], 0, 0, 'L');

        $pdf->Ln(20);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(75, 8, '', 0, 0);

        $pdf->Cell(135, -8, $student['prev_school_dateofleaving'], 0, 0, 'L');

        $pdf->Ln(0);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(75, 15, '', 0, 0);

        $pdf->Cell(135, 25, strtoupper($student['prev_school_standard_covered']), 0, 0, 'L');

        //$pdf->Cell(135, 7, '-', 0, 0);

        

        $pdf->Ln(20);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(60, 8, '', 0, 0);

        $pdf->Cell(135, -1,  strtoupper($student['prev_school_reasonofleaving']), 0, 0);



        $pdf->Ln(6);

        $pdf->Cell(75, 8, '', 0, 0);

        $pdf->Cell(40, 10, strtoupper($student['prev_school_tcnumber']), 0, 0, 'L');



        $pdf->Ln(10);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(75, 8, '', 0, 0);

        $pdf->Cell(135, 0, strtoupper($student['mother_tongue']), 0, 0);



        $pdf->Ln(12);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(60, 8, '', 0, 0);

        $pdf->Cell(130, -12, strtoupper($student['remarks']), 0, 0);



        //$pdf->Ln(10);

        $pdf->Ln(2);

        $pdf->SetFont('Arial', '', 10);

        $pdf->Cell(25, 8, '', 0, 0);

        $pdf->Cell(80, 8, date('d-m-Y'), 0, 0); // current date

        //$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);   

        // ---------------------------------------------------------    

        // Close and output PDF document

        // This method has several options, check the source code documentation for more information.

        $pdf->Output($fullname . '.pdf', 'I');

    }

    

    

public function admission_form($stdid = '')
{
    
   
    // Get student data
    $student = $this->student_model->get($stdid);
     $duration = $this->setting_model->getCurrentSessionName(); // current session name
    // Get settings data
    $setting_result = $this->setting_model->get();
      $category_list = $this->category_model->get();
    
    // Load the admission form HTML view and pass both student and settings
    $html = $this->load->view('reports/admissionform', [
        'student' => $student,
        'settinglist' => $setting_result,
           'currentsession' => $duration,
            'category_list' => $category_list
    ], true);

    // Load mPDF library
    $this->load->library('MPdf_instance');

    // Create new mPDF instance
    $mpdf = new \Mpdf\Mpdf();

    // Write HTML content
    $mpdf->WriteHTML($html);

    // Set file name (e.g., Student Name + Admission Form)
    $filename = 'AdmissionForm_' 
              . $student['firstname'] . '_' 
              . $student['father_name'] . '_' 
              . $student['lastname'] . '.pdf';

    // Output to browser (inline view in browser)
    $mpdf->Output($filename, 'I');  // 'I' = Inline, 'D' = Force Download
}
    
    
    public function leaving_certificate_lang($stdid = '', $serial_no = '', $formatedName = '', $cert_lang = array())

    {
        
     

        if(valid($cert_lang) && !empty($cert_lang)){

            $cert_lang['short_code'] = $cert_lang['short_code'];

        }

        else {

            $cert_lang['short_code'] = 'mr';    

        }

        

        if (!valid($stdid))

        {

            redirect('student/search');

        }

        $loggedInUser = $this->customlib->getUserData();

        $loggedInUserName = $loggedInUser['name'].' '.$loggedInUser['surname'];

        $formatedName = valid($formatedName) && !empty($formatedName) ? urldecode($formatedName) : '';//urldecode($formatedName)

        $date = date('Y-m-d H:i:s');

        $stdid = $stdid;

        $std_end_session = $this->student_model->getStudentAlumniSession($stdid);

        if (isset($std_end_session["student_session_id"]) && valid($std_end_session["student_session_id"]))

        {

            $student = $this->student_model->get($stdid, $std_end_session["student_session_id"]);

        }

        else

        {

            $student = $this->student_model->get($stdid);

        }

        //$student_bal_fees = $this->studentfeemaster_model->getStudentBalanceFees($student['student_session_id']);

        $student_bal_fees = 0;

        if ($student_bal_fees > 0)

        {

            //$this->session->set_flashdata('msg', '<div class="alert alert-success">Student added Successfully</div>');

            //error("Could not print the Certificate since the student having the balance fees of Rs. " . number_format($student_bal_fees));

            //access_denied();

        }

        //echo '<pre>';print_r($student);exit;

//        $gradeList = $this->grade_model->get();

        $gradeList = '';

        $studentSession = $this->student_model->getStudentSession($stdid);

        $student_session_id = $studentSession["student_session_id"];



        $student_session = $studentSession["session"];

        // $data["session"] = $student_session;       

        $current_student_session = $this->student_model->get_studentsession($student['student_session_id']);



        $data = array();

        $data["login_username"] = $loggedInUserName;

        $data["session"] = $current_student_session["session"];



        $data['student_doc_id'] = $stdid;

        $category_list = $this->category_model->get();

        //$category_list = '';

        $data['category_list'] = $category_list;

        $data['gradeList'] = $gradeList;

        $data['student'] = $student;

        $class_section = $this->student_model->getClassSection($student["class_id"]);

        $data["class_section"] = $class_section;

        $session = $this->setting_model->getCurrentSession();

        $setting_result = $this->setting_model->get();
        
        

        $data['settinglist'] = $setting_result;



        $clsname = (int) filter_var(trim($student['class']), FILTER_SANITIZE_NUMBER_INT);

        $data['clsname'] = $clsname;

        $settinglist = $setting_result;

        if ($clsname < 8)

        {

            $schoolname = valid($settinglist[0]['sch_name_primary']) ? $settinglist[0]['sch_name_primary'] : '-';

            $schoolrecogno = valid($settinglist[0]['sch_recog_primary']) ? $settinglist[0]['sch_recog_primary'] : '-';

            $UDISENumber = valid($settinglist[0]['sch_udise_primary']) ? $settinglist[0]['sch_udise_primary'] : '-';

        }

        elseif ($clsname >= 8 && $clsname <= 10)

        {

            $schoolname = valid($settinglist[0]['sch_name_secondary']) ? $settinglist[0]['sch_name_secondary'] : '-';

            $schoolrecogno = valid($settinglist[0]['sch_recog_secondary']) ? $settinglist[0]['sch_recog_secondary'] : '-';

            $UDISENumber = valid($settinglist[0]['sch_udise_secondary']) ? $settinglist[0]['sch_udise_secondary'] : '-';

        }

        else

        {

            $schoolname = valid($settinglist[0]['sch_name_high_secondary']) ? $settinglist[0]['sch_name_high_secondary'] : '-';

            $schoolrecogno = valid($settinglist[0]['sch_recog_high_secondary']) ? $settinglist[0]['sch_recog_high_secondary'] : '-';

            $UDISENumber = valid($settinglist[0]['sch_udise_high_secondary']) ? $settinglist[0]['sch_udise_high_secondary'] : '-';

//    $schoolname = 'TIMES PUBLIC SCHOOL';

//    $schoolrecogno = 'NAMASHA 2009/(152/09)/Secondary-1';

//    $UDISENumber = getSecondaryUDISENumber();

        }

        $data['schoolname'] = $schoolname;

        $data['schoolrecogno'] = $schoolrecogno;

        $data['UDISENumber'] = $UDISENumber;

        $data['cert_fields'] = $this->lang->line('cert_field_lang');

        // serial number

        if (!valid($serial_no) || empty($serial_no))

        {

            $serial_no = str_pad($student['id'], 4, "0", STR_PAD_LEFT);

//        $serial_no = strtotime(date('Y-m-d h:i:s'));

            $schtype = getSchoolTypeByClass($student['class']);

            $schtypelower = strtolower($schtype);

            $cert_result = get_single_row('cert_settings', array('cert_type' => 'cert_leaving', 'inst_type' => $schtypelower));

            if (valid($cert_result) && !empty($cert_result))

            {

                //$setting_result->cert_auto_insert

                //$setting_result->cert_prefix

                //$setting_result->cert_start_from

                //$setting_result->cert_no_digit

                if ($cert_result->cert_auto_insert)

                {

                    //$serial_no = $setting_result->cert_prefix . $setting_result->cert_start_from;

                    $serial_no = $cert_result->cert_prefix . sprintf("%0" . $cert_result->cert_no_digit . "d", $cert_result->cert_start_from);

                    $classIds = $this->class_model->getClassIdBySchoolType($schtype);

                    $stdDetails = $this->student_model->studentCertificateDetails($classIds, 'CERT_LEAVING');

                    if (valid($stdDetails) && !empty($stdDetails))

                    {

                        $stddata = current($stdDetails);

                        $snleavingcert = trim($stddata['sn_cert_leaving']);

                        if (valid($snleavingcert))

                        {

                            $last_serial_no = str_replace($cert_result->cert_prefix, "", $snleavingcert);

                            $serial_no = $cert_result->cert_prefix . sprintf("%0" . $cert_result->cert_no_digit . "d", $last_serial_no + 1);

                        }

                    }

                }

            }

        }

        

        $serial_no = valid(trim($student['sn_cert_leaving'])) ? trim($student['sn_cert_leaving']) : $serial_no;

        $data['sn_leaving_date'] = valid(trim($student['sn_leaving_date'])) ? trim($student['sn_leaving_date']) : '';

        $data['serial_no'] = $serial_no;

        // update bonafide serial number

        $this->student_model->add(array('id' => $stdid, 'sn_cert_leaving' => (int) filter_var(trim($serial_no), FILTER_SANITIZE_NUMBER_INT), 'sn_leaving_date' => date('Y-m-d')));

        // end of serial number

        //$html = $this->load->view('reports/bonafiedCertificate', $data, true);

        


        // create new PDF document

        //if($student['schoolType']=="primary"){

        $clss = intval($student['class']);

        

        $curDate = date('d-m-y');

        $monthNum = date("m", strtotime($curDate));

        $monthName = date("F", mktime(0, 0, 0, $monthNum, 8));

        $fullname = $student['firstname'] . ' ' . $student['father_name'] . ' ' . $student['lastname'];

        $std_dob = valid($student['dob']) ? date('d-m-Y', strtotime($student['dob'])) : '';

        $dobWord = '-';

        

        if (valid($std_dob))

        {

            $new_birth_date = explode('-', trim($std_dob));

            $year = $new_birth_date[2];

            $monthWord = date('F', strtotime($std_dob));

            $day = $new_birth_date[0];

            $dobWord = ucwords(getNumberInWordWithOrdinalSpellout($day) . ' ' . $monthWord . ' ' . getIndianCurrencyInWord($year, '', ''));

        }

        

        $date_of_leaving = valid($student['date_of_leaving']) ? date('d-m-Y', strtotime($student['date_of_leaving'])) : '';

        $dolWord = '-';

        if (valid($date_of_leaving))

        {

            if (strpos($date_of_leaving, '-') != false)

            {

                $new_birth_date = explode('-', trim($date_of_leaving));

                $day = $new_birth_date[0];

            }

            else

            {

                $new_birth_date = explode('/', trim($date_of_leaving));

                $day = $new_birth_date[1];

            }



            $year = $new_birth_date[2];

            $monthWord = date('F', strtotime($date_of_leaving));

            $dolWord = ucwords(getIndianCurrencyInWord($day, '', '') . ' ' . $monthWord . ' ' . getIndianCurrencyInWord($year, '', ''));

        }

        $date_of_admission = valid($student['admission_date']) ? date('d-m-Y', strtotime($student['admission_date'])) : '';

        

        $qrimage = base_url() . "/uploads/qr_image/$stdid.png";

        $data['qrimage'] = $qrimage;

        

        // convert text using google translater

        $lang_num = $this->customlib->getLocalLanguageNumber($cert_lang['short_code']);

        //echo str_replace($lang_num['english'], $lang_num['local'], $std_dob);

        $q_var = '&q=';

        if($cert_lang['short_code'] != 'en')

        {

            $text = $q_var.rawurlencode($formatedName).$q_var.rawurlencode($student['firstname']).$q_var.rawurlencode($student['father_name']).$q_var.rawurlencode($student['lastname']).$q_var.rawurlencode($student['mother_name']);

            $text = $text.$q_var.rawurlencode($student['nationality']).$q_var.rawurlencode($student['mother_tongue']).$q_var.rawurlencode($student['religion']).$q_var.rawurlencode($student['cast']).$q_var.rawurlencode($student['subcas']);

            $text = $text.$q_var.rawurlencode($student['place_of_birth']).$q_var.rawurlencode($student['birth_taluka']).$q_var.rawurlencode($student['birth_district']).$q_var.rawurlencode($student['state']).$q_var.rawurlencode($dobWord);

            $text = $text.$q_var.rawurlencode($student['prev_school_name']).$q_var.rawurlencode($student['prev_school_standard_covered']).$q_var.rawurlencode($student['class_studing_since_when']).$q_var.rawurlencode($student['academic_preference']).$q_var.rawurlencode($student['academic_conduct']);

            $text = $text.$q_var.rawurlencode($dolWord).$q_var.rawurlencode($student['reason_of_leaving']).$q_var.rawurlencode($student['remarks']);

           

            $translated_text = $this->customlib->google_translate_text($text, 'en', $cert_lang['short_code']);

            //echo '<pre>';print_r($translated_text);exit;

            if((!valid($translated_text) || empty($translated_text) || isset($translated_text['error'])) && $cert_lang['short_code'] != 'en')

            {

                $this->session->set_flashdata('msg', '<div class="alert alert-warning text-left">Something went wrong, try again later!</div>');

                redirect('student/search');

            }

        

        }

        

        //echo '<pre>';print_r($translated_text);exit;

        $formatedName           = ($cert_lang['short_code'] == 'en') ? $formatedName : $translated_text[0]['translatedText'];

        $student['firstname']   = ($cert_lang['short_code'] == 'en') ? $student['firstname'] : $translated_text[1]['translatedText'];

        $student['father_name'] = ($cert_lang['short_code'] == 'en') ? $student['father_name'] : $translated_text[2]['translatedText'];

        $student['lastname']    = ($cert_lang['short_code'] == 'en') ? $student['lastname'] : $translated_text[3]['translatedText'];

        $student['mother_name'] = ($cert_lang['short_code'] == 'en') ? $student['mother_name'] : $translated_text[4]['translatedText'];

        $student['nationality'] = ($cert_lang['short_code'] == 'en') ? $student['nationality'] : $translated_text[5]['translatedText'];

        $student['mother_tongue']   = ($cert_lang['short_code'] == 'en') ? $student['mother_tongue'] : $translated_text[6]['translatedText'];

        $student['religion']        = ($cert_lang['short_code'] == 'en') ? $student['religion'] : $translated_text[7]['translatedText'];

        $student['cast']            = ($cert_lang['short_code'] == 'en') ? $student['cast'] : $translated_text[8]['translatedText'];

        $student['subcas']          = ($cert_lang['short_code'] == 'en') ? $student['subcas'] : $translated_text[9]['translatedText'];

        $student['place_of_birth']  = ($cert_lang['short_code'] == 'en') ? $student['place_of_birth'] : $translated_text[10]['translatedText'];

        $student['birth_taluka']    = ($cert_lang['short_code'] == 'en') ? $student['birth_taluka'] : $translated_text[11]['translatedText'];

        $student['birth_district']  = ($cert_lang['short_code'] == 'en') ? $student['birth_district'] : $translated_text[12]['translatedText'];

        $student['state']           = ($cert_lang['short_code'] == 'en') ? $student['state'] : $translated_text[13]['translatedText'];

        $dobWord                    = ($cert_lang['short_code'] == 'en') ? $dobWord : $translated_text[14]['translatedText'];

        $student['prev_school_name'] = ($cert_lang['short_code'] == 'en') ? $student['prev_school_name'] : $translated_text[15]['translatedText'];

        $student['prev_school_standard_covered'] = ($cert_lang['short_code'] == 'en') ? $student['prev_school_standard_covered'] : $translated_text[16]['translatedText'];

        $student['class_studing_since_when']    = ($cert_lang['short_code'] == 'en') ? $student['class_studing_since_when'] : $translated_text[17]['translatedText'];

        $student['academic_preference']         = ($cert_lang['short_code'] == 'en') ? $student['academic_preference'] : $translated_text[18]['translatedText'];

        $student['academic_conduct']            = ($cert_lang['short_code'] == 'en') ? $student['academic_conduct'] : $translated_text[19]['translatedText'];

        $dolWord                                = ($cert_lang['short_code'] == 'en') ? $dolWord : $translated_text[20]['translatedText'];

        $student['reason_of_leaving']           = ($cert_lang['short_code'] == 'en') ? $student['reason_of_leaving'] : $translated_text[21]['translatedText'];

        $student['remarks']                     = ($cert_lang['short_code'] == 'en') ? $student['remarks'] : $translated_text[22]['translatedText'];

        $student['dob']                         = $std_dob;

        $student['dobWord']                     = $dobWord;

        $student['date_of_leaving']             = $date_of_leaving;

        $student['dolWord']                    = $dolWord;

        $student['admission_date']                    = $date_of_admission;

        

        

        $data['student_data'] = $student;

        

        // loading MPDF library

        $this->load->library('MPdf_instance');

        //$mpdf = new MPdf_instance();

        $stylesheet = '<style>p, td { font-family: freesans; }</style>' ; // file_get_contents('css/style.css');

        if(isset($cert_lang['short_code']))

        {

            switch ($cert_lang['short_code'])

            {

                case 'mr':

                case 'hi':

                    $template_data = $this->load->view('reports/lang/leavingCertificate-mr', $data, true);

                    break;

                default:

                    $template_data = $this->load->view('reports/lang/leavingCertificate-en', $data, true); // default english

                    break;

            }

        }

//        $mpdf = new \Mpdf\Mpdf(['utf-8', 'A4-C']);

        $mpdf = new MPdf_instance(['utf-8', 'A4-C']);

        /**

        $mpdf->SetHTMLHeader('

        <div style="text-align: right; font-weight: bold;">

            My document

        </div>');

        $mpdf->SetHTMLFooter('

        <table width="100%">

            <tr>

                <td width="33%">{DATE j-m-Y}</td>

                <td width="33%" align="center">{PAGENO}/{nbpg}</td>

                <td width="33%" style="text-align: right;">My document</td>

            </tr>

        </table>');

        */
    
       
       
        //        $mpdf = new \Mpdf\Mpdf(['utf-8', 'A4-C']);

        $mpdf = new MPdf_instance(['utf-8', 'A4-C']);
        $logo_filename = isset($settinglist[0]['certificate_logo']) ? $settinglist[0]['certificate_logo'] : 'default_logo.jpg';
$watermark_path = base_url('uploads/school_content/logo/logo/' . $logo_filename);
    
        $mpdf->SetWatermarkImage($watermark_path);
        $mpdf->showWatermarkImage = true; // Enable watermark

        
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($template_data);

        
        $mpdf->Output("leaving-certificate" . $student['firstname'] . "-" . $student['lastname'] . ".pdf", 'I');
        exit;
        

    }

    
    
    

    public function bonafied_certificate_lang($stdid = '', $serial_no = '', $formatedName = '', $cert_lang = array())

    {

        if(valid($cert_lang) && !empty($cert_lang)){

            $cert_lang['short_code'] = $cert_lang['short_code'];

        }

        else {

            $cert_lang['short_code'] = 'mr';    

        }

        

        //$cert_lang['short_code'] = 'mr';

        if (!valid($stdid))

        {

            redirect('student/search');

        }

        $formatedName = urldecode($formatedName);

        $date = date('Y-m-d H:i:s');

        $stdid = $stdid;

        $std_end_session = $this->student_model->getStudentAlumniSession($stdid);

        if (isset($std_end_session["student_session_id"]) && valid($std_end_session["student_session_id"]))

        {

            $student = $this->student_model->get($stdid, $std_end_session["student_session_id"]);

        }

        else

        {

            $student = $this->student_model->get($stdid);

        }

        //$student_bal_fees = $this->studentfeemaster_model->getStudentBalanceFees($student['student_session_id']);

        $student_bal_fees = 0;

        if ($student_bal_fees > 0)

        {

            //$this->session->set_flashdata('msg', '<div class="alert alert-success">Student added Successfully</div>');

            //error("Could not print the Certificate since the student having the balance fees of Rs. " . number_format($student_bal_fees));

            //access_denied();

        }

        //echo '<pre>';print_r($student);exit;

//        $gradeList = $this->grade_model->get();

        $gradeList = '';

        $studentSession = $this->student_model->getStudentSession($stdid);

        $student_session_id = $studentSession["student_session_id"];



        $student_session = $studentSession["session"];

        // $data["session"] = $student_session;       

        $current_student_session = $this->student_model->get_studentsession($student['student_session_id']);



        $data = array();

        $data["session"] = $current_student_session["session"];



        $data['student_doc_id'] = $stdid;

        $category_list = $this->category_model->get();

        //$category_list = '';

        $data['category_list'] = $category_list;

        $data['gradeList'] = $gradeList;

        $data['student'] = $student;

        $class_section = $this->student_model->getClassSection($student["class_id"]);

        $data["class_section"] = $class_section;

        $session = $this->setting_model->getCurrentSession();

        $setting_result = $this->setting_model->get();

        $data['settinglist'] = $setting_result;



        $clsname = (int) filter_var(trim($student['class']), FILTER_SANITIZE_NUMBER_INT);

        $data['clsname'] = $clsname;

        $settinglist = $setting_result;

        if ($clsname < 8)

        {

            $schoolname = valid($settinglist[0]['sch_name_primary']) ? $settinglist[0]['sch_name_primary'] : '-';

            $schoolrecogno = valid($settinglist[0]['sch_recog_primary']) ? $settinglist[0]['sch_recog_primary'] : '-';

            $UDISENumber = valid($settinglist[0]['sch_udise_primary']) ? $settinglist[0]['sch_udise_primary'] : '-';

        }

        elseif ($clsname >= 8 && $clsname <= 10)

        {

            $schoolname = valid($settinglist[0]['sch_name_secondary']) ? $settinglist[0]['sch_name_secondary'] : '-';

            $schoolrecogno = valid($settinglist[0]['sch_recog_secondary']) ? $settinglist[0]['sch_recog_secondary'] : '-';

            $UDISENumber = valid($settinglist[0]['sch_udise_secondary']) ? $settinglist[0]['sch_udise_secondary'] : '-';

        }

        else

        {

            $schoolname = valid($settinglist[0]['sch_name_high_secondary']) ? $settinglist[0]['sch_name_high_secondary'] : '-';

            $schoolrecogno = valid($settinglist[0]['sch_recog_high_secondary']) ? $settinglist[0]['sch_recog_high_secondary'] : '-';

            $UDISENumber = valid($settinglist[0]['sch_udise_high_secondary']) ? $settinglist[0]['sch_udise_high_secondary'] : '-';

//    $schoolname = 'TIMES PUBLIC SCHOOL';

//    $schoolrecogno = 'NAMASHA 2009/(152/09)/Secondary-1';

//    $UDISENumber = getSecondaryUDISENumber();

        }

        $data['schoolname'] = $schoolname;

        $data['schoolrecogno'] = $schoolrecogno;

        $data['UDISENumber'] = $UDISENumber;

        $data['cert_fields'] = $this->lang->line('cert_field_lang');

        // serial number

        if (!valid($serial_no) || empty($serial_no))

        {

            $serial_no = str_pad($student['id'], 4, "0", STR_PAD_LEFT);

//        $serial_no = strtotime(date('Y-m-d h:i:s'));

            $schtype = getSchoolTypeByClass($student['class']);

            $schtypelower = strtolower($schtype);

            $cert_result = get_single_row('cert_settings', array('cert_type' => 'cert_bonafide', 'inst_type' => $schtypelower));

            if (valid($cert_result) && !empty($cert_result))

            {

                //$setting_result->cert_auto_insert

                //$setting_result->cert_prefix

                //$setting_result->cert_start_from

                //$setting_result->cert_no_digit

                if ($cert_result->cert_auto_insert)

                {

                    //$serial_no = $setting_result->cert_prefix . $setting_result->cert_start_from;

                    $serial_no = $cert_result->cert_prefix . sprintf("%0" . $cert_result->cert_no_digit . "d", $cert_result->cert_start_from);

                    $classIds = $this->class_model->getClassIdBySchoolType($schtype);

                    $stdDetails = $this->student_model->studentCertificateDetails($classIds, 'CERT_BONAFIDE');

                    if (valid($stdDetails) && !empty($stdDetails))

                    {

                        $stddata = current($stdDetails);

                        $snleavingcert = trim($stddata['sn_cert_bonafide']);

                        if (valid($snleavingcert))

                        {

                            $last_serial_no = str_replace($cert_result->cert_prefix, "", $snleavingcert);

                            $serial_no = $cert_result->cert_prefix . sprintf("%0" . $cert_result->cert_no_digit . "d", $last_serial_no + 1);

                        }

                    }

                }

            }

        }

        $data['serial_no'] = $serial_no;

        // update bonafide serial number

        $this->student_model->add(array('id' => $stdid, 'sn_cert_bonafide' => (int) filter_var(trim($serial_no), FILTER_SANITIZE_NUMBER_INT)));

        // end of serial number

        //$html = $this->load->view('reports/bonafiedCertificate', $data, true);

        





        // create new PDF document

        //if($student['schoolType']=="primary"){

        $clss = intval($student['class']);

        

        $curDate = date('d-m-y');

        $monthNum = date("m", strtotime($curDate));

        $monthName = date("F", mktime(0, 0, 0, $monthNum, 8));

        $fullname = $student['firstname'] . ' ' . $student['father_name'] . ' ' . $student['lastname'];

        $std_dob = valid($student['dob']) ? date('d-m-Y', strtotime($student['dob'])) : '';

        $dobWord = '-';

        

        if (valid($std_dob))

        {

            $new_birth_date = explode('-', trim($std_dob));

            $year = $new_birth_date[2];

            $monthWord = date('F', strtotime($std_dob));

            $day = $new_birth_date[0];

            $dobWord = ucwords(getNumberInWordWithOrdinalSpellout($day) . ' ' . $monthWord . ' ' . getIndianCurrencyInWord($year, '', ''));

        }

        

        $date_of_leaving = valid($student['date_of_leaving']) ? date('d-m-Y', strtotime($student['date_of_leaving'])) : '';

        $dolWord = '-';

        if (valid($date_of_leaving))

        {

            if (strpos($date_of_leaving, '-') != false)

            {

                $new_birth_date = explode('-', trim($date_of_leaving));

                $day = $new_birth_date[0];

            }

            else

            {

                $new_birth_date = explode('/', trim($date_of_leaving));

                $day = $new_birth_date[1];

            }



            $year = $new_birth_date[2];

            $monthWord = date('F', strtotime($date_of_leaving));

            $dolWord = ucwords(getIndianCurrencyInWord($day, '', '') . ' ' . $monthWord . ' ' . getIndianCurrencyInWord($year, '', ''));

        }

        $date_of_admission = valid($student['admission_date']) ? date('d-m-Y', strtotime($student['admission_date'])) : '';

        

        $qrimage = base_url() . "/uploads/qr_image/$stdid.png";

        $data['qrimage'] = $qrimage;

        // convert text using google translater

        $lang_num = $this->customlib->getLocalLanguageNumber($cert_lang['short_code']);

        //echo str_replace($lang_num['english'], $lang_num['local'], $std_dob);

        $q_var = '&q=';

        if($cert_lang['short_code'] != 'en')

        {

            $text = $q_var.rawurlencode($formatedName).$q_var.rawurlencode($student['firstname']).$q_var.rawurlencode($student['father_name']).$q_var.rawurlencode($student['lastname']).$q_var.rawurlencode($student['mother_name']);

            $text = $text.$q_var.rawurlencode($student['nationality']).$q_var.rawurlencode($student['mother_tongue']).$q_var.rawurlencode($student['religion']).$q_var.rawurlencode($student['cast']).$q_var.rawurlencode($student['subcas']);

            $text = $text.$q_var.rawurlencode($student['place_of_birth']).$q_var.rawurlencode($student['birth_taluka']).$q_var.rawurlencode($student['birth_district']).$q_var.rawurlencode($student['state']).$q_var.rawurlencode($dobWord);

            $text = $text.$q_var.rawurlencode($student['class']);

           

            $translated_text = $this->customlib->google_translate_text($text, 'en', $cert_lang['short_code']);

            if(!valid($translated_text) || empty($translated_text) || isset($translated_text['error']))

            {

                $this->session->set_flashdata('msg', '<div class="alert alert-warning text-left">Something went wrong, try again later!</div>');

                redirect('student/search');

            }

        }

        //echo '<pre>';print_r($translated_text);exit;

        $formatedName           = ($cert_lang['short_code'] == 'en') ? $formatedName : $translated_text[0]['translatedText'];

        $student['firstname']   = ($cert_lang['short_code'] == 'en') ? $student['firstname'] : $translated_text[1]['translatedText'];

        $student['father_name'] = ($cert_lang['short_code'] == 'en') ? $student['father_name'] : $translated_text[2]['translatedText'];

        $student['lastname']    = ($cert_lang['short_code'] == 'en') ? $student['lastname'] : $translated_text[3]['translatedText'];

        $student['mother_name'] = ($cert_lang['short_code'] == 'en') ? $student['mother_name'] : $translated_text[4]['translatedText'];

        $student['nationality'] = ($cert_lang['short_code'] == 'en') ? $student['nationality'] : $translated_text[5]['translatedText'];

        $student['mother_tongue']   = ($cert_lang['short_code'] == 'en') ? $student['mother_tongue'] : $translated_text[6]['translatedText'];

        $student['religion']        = ($cert_lang['short_code'] == 'en') ? $student['religion'] : $translated_text[7]['translatedText'];

        $student['cast']            = ($cert_lang['short_code'] == 'en') ? $student['cast'] : $translated_text[8]['translatedText'];

        $student['subcas']          = ($cert_lang['short_code'] == 'en') ? $student['subcas'] : $translated_text[9]['translatedText'];

        $student['place_of_birth']  = ($cert_lang['short_code'] == 'en') ? $student['place_of_birth'] : $translated_text[10]['translatedText'];

        $student['birth_taluka']    = ($cert_lang['short_code'] == 'en') ? $student['birth_taluka'] : $translated_text[11]['translatedText'];

        $student['birth_district']  = ($cert_lang['short_code'] == 'en') ? $student['birth_district'] : $translated_text[12]['translatedText'];

        $student['state']           = ($cert_lang['short_code'] == 'en') ? $student['state'] : $translated_text[13]['translatedText'];

        $dobWord                    = ($cert_lang['short_code'] == 'en') ? $dobWord : $translated_text[14]['translatedText'];

        $student['class']                     = ($cert_lang['short_code'] == 'en') ? $student['class'] : $translated_text[15]['translatedText'];

        $student['dob']                         = $std_dob;

        $student['dobWord']                     = $dobWord;

        $student['date_of_leaving']             = $date_of_leaving;

        $student['dolWord']                    = $dolWord;

        $student['admission_date']                    = $date_of_admission;

        

        $curDate = date('F Y');

        $monthNum = date("m", strtotime($student['admission_date']));

        $monthName = date("F", mktime(0, 0, 0, $monthNum, 10)) . ' ' . date('Y -', strtotime($student['admission_date']));

        $duration = $monthName . ' ' . $curDate;

        $duration = $this->setting_model->getCurrentSessionName(); // current session name

        //$student['duration'] = $duration;

        $student['duration'] = $data["session"]; // std class session name

        

        $data['student_data'] = $student;

        

        // loading MPDF library

        $this->load->library('MPdf_instance');

        //$mpdf = new MPdf_instance();

        $stylesheet = '<style>p, td { font-family: freesans; }</style>' ; // file_get_contents('css/style.css');

        if(isset($cert_lang['short_code']))

        {

            switch ($cert_lang['short_code'])

            {

                case 'mr':

                case 'hi':

                    $template_data = $this->load->view('reports/lang/bonafiedCertificate-mr', $data, true);

                    break;

                default:

                   // echo 'fsfsf';exit;

                    $template_data = $this->load->view('reports/lang/bonafiedCertificate-en', $data, true);

                    break;

            }

        }

//        $mpdf = new \Mpdf\Mpdf(['utf-8', 'A4-C']);

        $mpdf = new MPdf_instance(['utf-8', 'A4-C']);

        /**

        $mpdf->SetHTMLHeader('

        <div style="text-align: right; font-weight: bold;">

            My document

        </div>');

        $mpdf->SetHTMLFooter('

        <table width="100%">

            <tr>

                <td width="33%">{DATE j-m-Y}</td>

                <td width="33%" align="center">{PAGENO}/{nbpg}</td>

                <td width="33%" style="text-align: right;">My document</td>

            </tr>

        </table>');

        */

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->AddPage();

        $mpdf->WriteHTML($template_data);



        //call watermark content aand image

        //$mpdf->SetWatermarkText('phpflow.COM');

        //$mpdf->showWatermarkText = true;

        //$mpdf->watermarkTextAlpha = 0.1;

//        $mpdf->Output("phpflow.pdf", 'F');

        $mpdf->Output("bonafide-certificate-".$student['firstname']."-".$student['lastname'].".pdf", 'I');

        //$mpdf->Output("bonafide-certificate-".$student['firstname']."-".$student['lastname'].".pdf", 'D');

//        $mpdf->Output("phpflow.pdf", 'D');

        $mpdf->Output();

        exit;

        

    }

    

    public function entry_certificate_lang($stdid = '', $serial_no = '', $formatedName = '', $cert_lang = array())

    {

        if(valid($cert_lang) && !empty($cert_lang)){

            $cert_lang['short_code'] = $cert_lang['short_code'];

        }

        else {

            $cert_lang['short_code'] = 'mr';    

        }

        //$cert_lang['short_code'] = 'mr';

        if (!valid($stdid))

        {

            redirect('student/search');

        }

        $formatedName = urldecode($formatedName);

        $date = date('Y-m-d H:i:s');

        $stdid = $stdid;

        $std_end_session = $this->student_model->getStudentAlumniSession($stdid);

        if (isset($std_end_session["student_session_id"]) && valid($std_end_session["student_session_id"]))

        {

            $student = $this->student_model->get($stdid, $std_end_session["student_session_id"]);

        }

        else

        {

            $student = $this->student_model->get($stdid);

        }

        //$student_bal_fees = $this->studentfeemaster_model->getStudentBalanceFees($student['student_session_id']);

        $student_bal_fees = 0;

        if ($student_bal_fees > 0)

        {

            //$this->session->set_flashdata('msg', '<div class="alert alert-success">Student added Successfully</div>');

            //error("Could not print the Certificate since the student having the balance fees of Rs. " . number_format($student_bal_fees));

            //access_denied();

        }

        //echo '<pre>';print_r($student);exit;

//        $gradeList = $this->grade_model->get();

        $gradeList = '';

        $studentSession = $this->student_model->getStudentSession($stdid);

        $student_session_id = $studentSession["student_session_id"];



        $student_session = $studentSession["session"];

        // $data["session"] = $student_session;       

        $current_student_session = $this->student_model->get_studentsession($student['student_session_id']);



        $data = array();

        $data["session"] = $current_student_session["session"];



        $data['student_doc_id'] = $stdid;

        $category_list = $this->category_model->get();

        //$category_list = '';

        $data['category_list'] = $category_list;

        $data['gradeList'] = $gradeList;

        $data['student'] = $student;

        $class_section = $this->student_model->getClassSection($student["class_id"]);

        $data["class_section"] = $class_section;

        $session = $this->setting_model->getCurrentSession();

        $setting_result = $this->setting_model->get();

        $data['settinglist'] = $setting_result;



        $clsname = (int) filter_var(trim($student['class']), FILTER_SANITIZE_NUMBER_INT);

        $data['clsname'] = $clsname;

        $settinglist = $setting_result;

        if ($clsname < 8)

        {

            $schoolname = valid($settinglist[0]['sch_name_primary']) ? $settinglist[0]['sch_name_primary'] : '-';

            $schoolrecogno = valid($settinglist[0]['sch_recog_primary']) ? $settinglist[0]['sch_recog_primary'] : '-';

            $UDISENumber = valid($settinglist[0]['sch_udise_primary']) ? $settinglist[0]['sch_udise_primary'] : '-';

        }

        elseif ($clsname >= 8 && $clsname <= 10)

        {

            $schoolname = valid($settinglist[0]['sch_name_secondary']) ? $settinglist[0]['sch_name_secondary'] : '-';

            $schoolrecogno = valid($settinglist[0]['sch_recog_secondary']) ? $settinglist[0]['sch_recog_secondary'] : '-';

            $UDISENumber = valid($settinglist[0]['sch_udise_secondary']) ? $settinglist[0]['sch_udise_secondary'] : '-';

        }

        else

        {

            $schoolname = valid($settinglist[0]['sch_name_high_secondary']) ? $settinglist[0]['sch_name_high_secondary'] : '-';

            $schoolrecogno = valid($settinglist[0]['sch_recog_high_secondary']) ? $settinglist[0]['sch_recog_high_secondary'] : '-';

            $UDISENumber = valid($settinglist[0]['sch_udise_high_secondary']) ? $settinglist[0]['sch_udise_high_secondary'] : '-';

//    $schoolname = 'TIMES PUBLIC SCHOOL';

//    $schoolrecogno = 'NAMASHA 2009/(152/09)/Secondary-1';

//    $UDISENumber = getSecondaryUDISENumber();

        }

        $data['schoolname'] = $schoolname;

        $data['schoolrecogno'] = $schoolrecogno;

        $data['UDISENumber'] = $UDISENumber;

        $data['cert_fields'] = $this->lang->line('cert_field_lang');

        // serial number

        if (!valid($serial_no) || empty($serial_no))

        {

            $serial_no = str_pad($student['id'], 4, "0", STR_PAD_LEFT);

//        $serial_no = strtotime(date('Y-m-d h:i:s'));

            $schtype = getSchoolTypeByClass($student['class']);

            $schtypelower = strtolower($schtype);

            $cert_result = get_single_row('cert_settings', array('cert_type' => 'cert_entry', 'inst_type' => $schtypelower));

            if (valid($cert_result) && !empty($cert_result))

            {

                //$setting_result->cert_auto_insert

                //$setting_result->cert_prefix

                //$setting_result->cert_start_from

                //$setting_result->cert_no_digit

                if ($cert_result->cert_auto_insert)

                {

                    //$serial_no = $setting_result->cert_prefix . $setting_result->cert_start_from;

                    $serial_no = $cert_result->cert_prefix . sprintf("%0" . $cert_result->cert_no_digit . "d", $cert_result->cert_start_from);

                    $classIds = $this->class_model->getClassIdBySchoolType($schtype);

                    $stdDetails = $this->student_model->studentCertificateDetails($classIds, 'CERT_ENTRY');

                    if (valid($stdDetails) && !empty($stdDetails))

                    {

                        $stddata = current($stdDetails);

                        $snleavingcert = trim($stddata['sn_cert_entry']);

                        if (valid($snleavingcert))

                        {

                            $last_serial_no = str_replace($cert_result->cert_prefix, "", $snleavingcert);

                            $serial_no = $cert_result->cert_prefix . sprintf("%0" . $cert_result->cert_no_digit . "d", $last_serial_no + 1);

                        }

                    }

                }

            }

        }

        $data['serial_no'] = $serial_no;

        // update bonafide serial number

        $this->student_model->add(array('id' => $stdid, 'sn_cert_entry' => (int) filter_var(trim($serial_no), FILTER_SANITIZE_NUMBER_INT)));

        // end of serial number

        //$html = $this->load->view('reports/bonafiedCertificate', $data, true);

       


        // create new PDF document

        //if($student['schoolType']=="primary"){

        $clss = intval($student['class']);

        

        $curDate = date('d-m-y');

        $monthNum = date("m", strtotime($curDate));

        $monthName = date("F", mktime(0, 0, 0, $monthNum, 8));

        $fullname = $student['firstname'] . ' ' . $student['father_name'] . ' ' . $student['lastname'];

        $std_dob = valid($student['dob']) ? date('d-m-Y', strtotime($student['dob'])) : '';

        $dobWord = '-';

        

        if (valid($std_dob))

        {

            $new_birth_date = explode('-', trim($std_dob));

            $year = $new_birth_date[2];

            $monthWord = date('F', strtotime($std_dob));

            $day = $new_birth_date[0];

            $dobWord = ucwords(getIndianCurrencyInWord($day, '', '') . ' ' . $monthWord . ' ' . getIndianCurrencyInWord($year, '', ''));

        }

        

        $date_of_leaving = valid($student['prev_school_dateofleaving']) ? date('d-m-Y', strtotime($student['prev_school_dateofleaving'])) : '';

        $dolWord = '-';

        if (valid($date_of_leaving))

        {

            if (strpos($date_of_leaving, '-') != false)

            {

                $new_birth_date = explode('-', trim($date_of_leaving));

                $day = $new_birth_date[0];

            }

            else

            {

                $new_birth_date = explode('/', trim($date_of_leaving));

                $day = $new_birth_date[1];

            }



            $year = $new_birth_date[2];

            $monthWord = date('F', strtotime($date_of_leaving));

            $dolWord = ucwords(getIndianCurrencyInWord($day, '', '') . ' ' . $monthWord . ' ' . getIndianCurrencyInWord($year, '', ''));

        }

        $date_of_admission = valid($student['admission_date']) ? date('d-m-Y', strtotime($student['admission_date'])) : '';

        

        $qrimage = base_url() . "/uploads/qr_image/$stdid.png";

        $data['qrimage'] = $qrimage;

        // convert text using google translater

        $lang_num = $this->customlib->getLocalLanguageNumber($cert_lang['short_code']);

        //echo str_replace($lang_num['english'], $lang_num['local'], $std_dob);

        $data['local_lang_num'] = $lang_num['local'];

        $q_var = '&q=';

        if($cert_lang['short_code'] != 'en')

        {

            $text = $q_var.rawurlencode($formatedName).$q_var.rawurlencode($student['firstname']).$q_var.rawurlencode($student['father_name']).$q_var.rawurlencode($student['lastname']).$q_var.rawurlencode($student['mother_name']);

            $text = $text.$q_var.rawurlencode($student['nationality']).$q_var.rawurlencode($student['mother_tongue']).$q_var.rawurlencode($student['religion']).$q_var.rawurlencode($student['cast']).$q_var.rawurlencode($student['subcas']);

            $text = $text.$q_var.rawurlencode($student['place_of_birth']).$q_var.rawurlencode($student['birth_taluka']).$q_var.rawurlencode($student['birth_district']).$q_var.rawurlencode($student['state']).$q_var.rawurlencode($dobWord);

            $text = $text.$q_var.rawurlencode($student['prev_school_name']).$q_var.rawurlencode($student['prev_school_standard_covered']).$q_var.rawurlencode($student['fillbyoffice_admittedto']).$q_var.rawurlencode($student['prev_school_reasonofleaving']).$q_var.rawurlencode($student['academic_conduct']);

            $text = $text.$q_var.rawurlencode($dolWord).$q_var.rawurlencode($student['reason_of_leaving']).$q_var.rawurlencode($student['remarks']);

           

            $translated_text = $this->customlib->google_translate_text($text, 'en', $cert_lang['short_code']);

            if(!valid($translated_text) || empty($translated_text) || isset($translated_text['error']))

            {

                $this->session->set_flashdata('msg', '<div class="alert alert-warning text-left">Something went wrong, try again later!</div>');

                redirect('student/search');

            }

        }

        

        //echo '<pre>';print_r($translated_text);exit;

        $formatedName           = ($cert_lang['short_code'] == 'en') ? $formatedName : $translated_text[0]['translatedText'];

        $student['firstname']   = ($cert_lang['short_code'] == 'en') ? $student['firstname'] : $translated_text[1]['translatedText'];

        $student['father_name'] = ($cert_lang['short_code'] == 'en') ? $student['father_name'] : $translated_text[2]['translatedText'];

        $student['lastname']    = ($cert_lang['short_code'] == 'en') ? $student['lastname'] : $translated_text[3]['translatedText'];

        $student['mother_name'] = ($cert_lang['short_code'] == 'en') ? $student['mother_name'] : $translated_text[4]['translatedText'];

        $student['nationality'] = ($cert_lang['short_code'] == 'en') ? $student['nationality'] : $translated_text[5]['translatedText'];

        $student['mother_tongue']   = ($cert_lang['short_code'] == 'en') ? $student['mother_tongue'] : $translated_text[6]['translatedText'];

        $student['religion']        = ($cert_lang['short_code'] == 'en') ? $student['religion'] : $translated_text[7]['translatedText'];

        $student['cast']            = ($cert_lang['short_code'] == 'en') ? $student['cast'] : $translated_text[8]['translatedText'];

        $student['subcas']          = ($cert_lang['short_code'] == 'en') ? $student['subcas'] : $translated_text[9]['translatedText'];

        $student['place_of_birth']  = ($cert_lang['short_code'] == 'en') ? $student['place_of_birth'] : $translated_text[10]['translatedText'];

        $student['birth_taluka']    = ($cert_lang['short_code'] == 'en') ? $student['birth_taluka'] : $translated_text[11]['translatedText'];

        $student['birth_district']  = ($cert_lang['short_code'] == 'en') ? $student['birth_district'] : $translated_text[12]['translatedText'];

        $student['state']           = ($cert_lang['short_code'] == 'en') ? $student['state'] : $translated_text[13]['translatedText'];

        $dobWord                    = ($cert_lang['short_code'] == 'en') ? $dobWord : $translated_text[14]['translatedText'];

        $student['prev_school_name'] = ($cert_lang['short_code'] == 'en') ? $student['prev_school_name'] : $translated_text[15]['translatedText'];

        $student['prev_school_standard_covered'] = ($cert_lang['short_code'] == 'en') ? $student['prev_school_standard_covered'] : $translated_text[16]['translatedText'];

        $student['fillbyoffice_admittedto']    = ($cert_lang['short_code'] == 'en') ? $student['fillbyoffice_admittedto'] : $translated_text[17]['translatedText'];

        $student['prev_school_reasonofleaving'] = ($cert_lang['short_code'] == 'en') ? $student['prev_school_reasonofleaving'] : $translated_text[18]['translatedText'];

        $student['academic_conduct']            = ($cert_lang['short_code'] == 'en') ? $student['academic_conduct'] : $translated_text[19]['translatedText'];

        $dolWord                                = ($cert_lang['short_code'] == 'en') ? $dolWord : $translated_text[20]['translatedText'];

        $student['reason_of_leaving']           = ($cert_lang['short_code'] == 'en') ? $student['reason_of_leaving'] : $translated_text[21]['translatedText'];

        $student['remarks']                     = ($cert_lang['short_code'] == 'en') ? $student['remarks'] : $translated_text[22]['translatedText'];

        $student['dob']                         = $std_dob;

        $student['dobWord']                     = $dobWord;

        $student['date_of_leaving']             = $date_of_leaving;

        $student['dolWord']                    = $dolWord;

        $student['admission_date']                    = $date_of_admission;

        

        $data['student_data'] = $student;

        

        // loading MPDF library

        $this->load->library('MPdf_instance');

        //$mpdf = new MPdf_instance();

        $stylesheet = '<style>p, td { font-family: freesans; }</style>' ; // file_get_contents('css/style.css');

        if(isset($cert_lang['short_code']))

        {

            switch ($cert_lang['short_code'])

            {

                case 'mr':

                case 'hi':

                    $template_data = $this->load->view('reports/lang/entryCertificate-mr', $data, true);

                    break;

                default:

                    $template_data = $this->load->view('reports/lang/entryCertificate-en', $data, true);  // default english

                    break;

            }

        }

//        $mpdf = new \Mpdf\Mpdf(['utf-8', 'A4-C']);

        $mpdf = new MPdf_instance(['utf-8', 'A4-C']);

        /**

        $mpdf->SetHTMLHeader('

        <div style="text-align: right; font-weight: bold;">

            My document

        </div>');

        $mpdf->SetHTMLFooter('

        <table width="100%">

            <tr>

                <td width="33%">{DATE j-m-Y}</td>

                <td width="33%" align="center">{PAGENO}/{nbpg}</td>

                <td width="33%" style="text-align: right;">My document</td>

            </tr>

        </table>');

        */

        $mpdf->WriteHTML($stylesheet, 1);

        $mpdf->AddPage();

        $mpdf->WriteHTML($template_data);



        //call watermark content aand image

        //$mpdf->SetWatermarkText('phpflow.COM');

        //$mpdf->showWatermarkText = true;

        //$mpdf->watermarkTextAlpha = 0.1;

//        $mpdf->Output("phpflow.pdf", 'F');

        $mpdf->Output("entry-certificate-".$student['firstname']."-".$student['lastname'].".pdf", 'I');

//        $mpdf->Output("phpflow.pdf", 'D');

        $mpdf->Output();

        exit;

        

    }




    // add system setting in certificate setting = anil end
    
    public function studyCertificate_form($stdid = '')
{
    // Get student data
    $student = $this->student_model->get($stdid);
     $duration = $this->setting_model->getCurrentSessionName(); // current session name
    // Get settings data
    $setting_result = $this->setting_model->get();
    
  
   
    
    // Load the admission form HTML view and pass both student and settings
    $html = $this->load->view('reports/studyCertificateprint', [
        'student' => $student,
        'settinglist' => $setting_result,
           'currentsession' => $duration
         
    ], true);

    // Load mPDF library
    $this->load->library('MPdf_instance');

    // Create new mPDF instance
    $mpdf = new \Mpdf\Mpdf();

    // Write HTML content
    $mpdf->WriteHTML($html);

    // Set file name (e.g., Student Name + Admission Form)
    $filename = 'StudyCertificate_' 
              . $student['firstname'] . '_' 
              . $student['father_name'] . '_' 
              . $student['lastname'] . '.pdf';

    // Output to browser (inline view in browser)
    $mpdf->Output($filename, 'I');  // 'I' = Inline, 'D' = Force Download
}
    
    
}
