<?php



if (!defined('BASEPATH')) {

    exit('No direct script access allowed');

}



class Student extends Admin_Controller

{



    public $sch_setting_detail = array();



    public function __construct()

    {

        parent::__construct();

        $this->load->library('SaasValidation');

        $this->load->library('media_storage');

        $this->config->load('app-config');

        $this->config->load("payroll");

        $this->load->library('smsgateway');

        $this->load->library('mailsmsconf');

        $this->load->library('encoding_lib');

        $this->load->model("classteacher_model");
        
        

        $this->load->model(array("timeline_model", "student_edit_field_model", 'transportfee_model', 'marksdivision_model', 'module_model'));

        $this->blood_group        = $this->config->item('bloodgroup');

        $this->sch_setting_detail = $this->setting_model->getSetting();

        $this->role;

        $this->staff_attendance = $this->config->item('staffattendance');

    }



    public function index()

    {

        $data['title']       = 'Student List';

        $student_result      = $this->student_model->get();

        $data['studentlist'] = $student_result;

        $this->load->view('layout/header', $data);

        $this->load->view('student/studentList', $data);

        $this->load->view('layout/footer', $data);

    }



    public function multiclass()

    {

        if (!$this->rbac->hasPrivilege('multi_class_student', 'can_view')) {

            access_denied();

        }

        $this->session->set_userdata('top_menu', 'Student Information');

        $this->session->set_userdata('sub_menu', 'student/multiclass');

        $data['title']       = 'student fees';

        $data['title']       = 'student fees';

        $class               = $this->class_model->get();

        $data['classlist']   = $class;

        $data['sch_setting'] = $this->sch_setting_detail;



        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');



        if ($this->form_validation->run() == false) {

        } else {

            $class                   = $this->class_model->get();

            $data['classlist']       = $class;

            $data['student_due_fee'] = array();

            $class_id                = $this->input->post('class_id');

            $section_id              = $this->input->post('section_id');

            $data['classes']         = $this->classsection_model->allClassSections();

            $students                = $this->studentsession_model->searchMultiStudentByClassSection($class_id, $section_id);

            $data['students']        = $students;

        }

        $this->load->view('layout/header', $data);

        $this->load->view('student/multiclass', $data);

        $this->load->view('layout/footer', $data);

    }



    public function download($student_id, $doc_id)

    {

        $this->load->helper('download');

        $doc_details = $this->student_model->studentdocbyid($doc_id);

        $this->media_storage->filedownload($doc_details['doc'], "uploads/student_documents/" . $student_id);

    }



    public function view($id)
    {
        
        if (!$this->rbac->hasPrivilege('student', 'can_view')) {

            access_denied();

        }



        $userdata        = $this->customlib->getUserData();

        $data['role_id'] = $userdata["role_id"];



        $data['marks_division'] = $this->marksdivision_model->get();



        $data['title']     = $this->lang->line('student_details');

        $student= $this->student_model->get($id);
         
        

        $data['gradeList'] = $this->grade_model->get();

        $studentSession    = $this->student_model->getStudentSession($id);



        $data["timeline_list"] = $this->timeline_model->getStudentTimeline($id, $status = '');



        $data['sch_setting'] = $this->sch_setting_detail;



        $data['adm_auto_insert']      = $this->sch_setting_detail->adm_auto_insert;

        $data['student_timeline']     = $this->sch_setting_detail->student_timeline;

        $data["session"]              = $studentSession["session"];

        $student_due_fee              = $this->studentfeemaster_model->getStudentFees($student['student_session_id']);

        $student_discount_fee         = $this->feediscount_model->getStudentFeesDiscount($student['student_session_id']);

        $data['student_discount_fee'] = $student_discount_fee;

        $data['student_due_fee']      = $student_due_fee;

        $data['siblings']             = $this->student_model->getMySiblings($student['parent_id'], $student['id']);
        
        $data['hostel_details'] = $this->student_model->student_hostel_details($student['id']);
   



        $data['student_doc'] = $this->student_model->getstudentdoc($id);



        $transport_fees = [];



        $data['superadmin_visible'] = $this->customlib->superadmin_visible();



        $getStaffRole       = $this->customlib->getStaffRole();

        $data['staffrole']         = json_decode($getStaffRole);



        if ($this->module_lib->hasModule('behaviour_records')) {

            //------- Behaviour Report Start--------



            $this->load->model("studentincidents_model");



            // This is used to get assign incident record of student by student id

            $data['assignstudent'] = $this->studentincidents_model->studentbehaviour($id);



            // This is used to get total points of student by student id

            $total_points            = $this->studentincidents_model->totalpoints($id);

            $student['total_points'] = $total_points['totalpoints'];



            //------- Behaviour Report End----------

        }



        // ------------- CBSE Exam Start ---------------------

        if ($this->module_lib->hasModule('cbseexam')) {



            $this->load->model("cbseexam/cbseexam_exam_model");

            $this->load->model("cbseexam/cbseexam_grade_model");

            $this->load->model("cbseexam/cbseexam_assessment_model");





            $exam_list = $this->cbseexam_exam_model->getStudentExamByStudentSession($student['student_session_id']);



            $student_exams = [];

            if (!empty($exam_list)) {

                foreach ($exam_list as $exam_key => $exam_value) {



                    $exam_subjects = $this->cbseexam_exam_model->getexamsubjects($exam_value->cbse_exam_id);

                    $exam_value->{"subjects"} = $exam_subjects;

                    $exam_value->{"grades"} = $this->cbseexam_grade_model->getGraderangebyGradeID($exam_value->cbse_exam_grade_id);

                    $exam_value->{"exam_assessments"} = $this->cbseexam_assessment_model->getWithAssessmentTypeByAssessmentID($exam_value->cbse_exam_assessment_id);



                    $exam_value->{"exam_subject_assessments"} = $this->cbseexam_assessment_model->getSubjectAssessmentsByExam($exam_subjects);



                    $cbse_exam_result = $this->cbseexam_exam_model->getStudentResultByExamId($exam_value->cbse_exam_id, [$exam_value->student_session_id]);



                    $students = [];

                    $student_rank = "";



                    if (!empty($cbse_exam_result)) {



                        foreach ($cbse_exam_result as $student_key => $student_value) {

                            $student_rank = $student_value->rank;



                            if (!empty($students)) {



                                if (!array_key_exists($student_value->subject_id, $students['subjects'])) {



                                    $new_subject = [

                                        'subject_id' => $student_value->subject_id,

                                        'subject_name' => $student_value->subject_name,

                                        'subject_code' => $student_value->subject_code,

                                        'exam_assessments' => [

                                            $student_value->cbse_exam_assessment_type_id => [

                                                'cbse_exam_assessment_type_name' => $student_value->cbse_exam_assessment_type_name,

                                                'cbse_exam_assessment_type_id' => $student_value->cbse_exam_assessment_type_id,

                                                'cbse_exam_assessment_type_code' => $student_value->cbse_exam_assessment_type_code,

                                                'maximum_marks' => $student_value->maximum_marks,

                                                'cbse_student_subject_marks_id' => $student_value->cbse_student_subject_marks_id,

                                                'marks' => $student_value->marks,

                                                'note' => $student_value->note,

                                                'is_absent' => $student_value->is_absent,

                                            ],

                                        ],

                                    ];



                                    $students['subjects'][$student_value->subject_id] = $new_subject;

                                } elseif (!array_key_exists($student_value->cbse_exam_assessment_type_id, $students['subjects'][$student_value->subject_id]['exam_assessments'])) {



                                    $new_assesment = [

                                        'cbse_exam_assessment_type_name' => $student_value->cbse_exam_assessment_type_name,

                                        'cbse_exam_assessment_type_id' => $student_value->cbse_exam_assessment_type_id,

                                        'cbse_exam_assessment_type_code' => $student_value->cbse_exam_assessment_type_code,

                                        'maximum_marks' => $student_value->maximum_marks,

                                        'cbse_student_subject_marks_id' => $student_value->cbse_student_subject_marks_id,

                                        'marks' => $student_value->marks,

                                        'note' => $student_value->note,

                                        'is_absent' => $student_value->is_absent,

                                    ];



                                    $students['subjects'][$student_value->subject_id]['exam_assessments'][$student_value->cbse_exam_assessment_type_id] = $new_assesment;

                                }

                            } else {



                                $students['subjects'] = [

                                    $student_value->subject_id => [

                                        'subject_id' => $student_value->subject_id,

                                        'subject_name' => $student_value->subject_name,

                                        'subject_code' => $student_value->subject_code,

                                        'exam_assessments' => [

                                            $student_value->cbse_exam_assessment_type_id => [

                                                'cbse_exam_assessment_type_name' => $student_value->cbse_exam_assessment_type_name,

                                                'cbse_exam_assessment_type_id' => $student_value->cbse_exam_assessment_type_id,

                                                'cbse_exam_assessment_type_code' => $student_value->cbse_exam_assessment_type_code,

                                                'maximum_marks' => $student_value->maximum_marks,

                                                'cbse_student_subject_marks_id' => $student_value->cbse_student_subject_marks_id,

                                                'marks' => $student_value->marks,

                                                'note' => $student_value->note,

                                                'is_absent' => $student_value->is_absent,



                                            ],



                                        ],

                                    ],

                                ];

                            }

                        }

                    }

                    $exam_value->{"rank"} = $student_rank;

                    $exam_value->{"exam_data"} = $students;

                }

            }



            $data['exams'] = $exam_list;

        }

        // ------------- CBSE Exam End---------------------



        $module = $this->module_model->getPermissionByModulename('transport');

        if ($module['is_active']) {



            $transport_fees = $this->studentfeemaster_model->getStudentTransportFeesByStudentSessionId($student['student_session_id'], $student['route_pickup_point_id']);

        }



        $data['transport_fees'] = $transport_fees;



        $data['student_doc_id'] = $id;

        $data['category_list']  = $this->category_model->get();



        $data['student'] = $student;


        $data['stateList'] = get_list('state', array('ctid' => 1), null, null, 0, 'state', 'ASC');

        $data["class_section"] = $this->student_model->getClassSection($student["class_id"]);

        $session               = $this->setting_model->getCurrentSession();



        $data["studentlistbysection"] = $this->student_model->getStudentClassSection($student["class_id"], $session);



        $data['guardian_credential'] = $this->student_model->guardian_credential($student['parent_id']);



        $data['reason'] = $this->disable_reason_model->get();



        if ($student['is_active'] = 'no') {

            $data['reason_data'] = $this->disable_reason_model->get($student['dis_reason']);

        }



        $data['exam_result'] = $this->examgroupstudent_model->searchStudentExams($student['student_session_id'], true, true);

        $data['exam_grade']  = $this->grade_model->getGradeDetails();



        $data['yearlist'] = $this->stuattendence_model->attendanceYearCount();



        $startmonth        = $this->setting_model->getStartMonth();

        $monthlist         = $this->customlib->getMonthDropdown($startmonth);

        $data["monthlist"] = $monthlist;



        $data['attendencetypeslist'] = $this->attendencetype_model->get();



        $year = date("Y");



        $input       = $this->setting_model->getCurrentSessionName();

        list($a, $b) = explode('-', $input);

        $start_year  = $a;

        if (strlen($b) == 2) {

            $Next_year = substr($a, 0, 2) . $b;

        } else {

            $Next_year = $b;

        }



        $start_end_month = $this->startmonthandend();



        $session_year_start = date("Y-m-01", strtotime($start_year . '-' . $start_end_month[0] . '-01'));

        $session_year_end   = date("Y-m-t", strtotime($Next_year . '-' . $start_end_month[1] . '-01'));



        $data["countAttendance"] = $this->countAttendance($session_year_start, $student['student_session_id']);



        foreach ($monthlist as $key => $value) {



            $datemonth       = date("m", strtotime($key));

            // $date_each_month = date('Y-' . $datemonth . '-01');



            $date_each_month = date($start_year . '-' . $datemonth . '-01');



            $date_end        = date('t', strtotime($date_each_month));

            for ($n = 1; $n <= $date_end; $n++) {

                $att_date           = sprintf("%02d", $n);

                $attendence_array[] = $att_date;

                $datemonth          = date("m", strtotime($key));

                $att_dates          = $start_year . "-" . $datemonth . "-" . sprintf("%02d", $n);



                $date_array[]    = $att_dates;

                $res[$att_dates] = $this->stuattendence_model->studentattendance($att_dates, $student['student_session_id']);

            }



            $start_year = ($datemonth == 12) ? $Next_year : $start_year;

        }



        $data["session_year_start"] = $session_year_start;

        $data["session_year_end"]   = $session_year_end;

        $data["resultlist"]         = $res;



        $this->load->view('layout/header', $data);

        $this->load->view('student/studentShow', $data);

        $this->load->view('layout/footer', $data);

    }



    public function exportformat()

    {

        $this->load->helper('download');

        $filepath = "./backend/import/sample_students.csv";

        $data     = file_get_contents($filepath);

        $name     = 'sample_students.csv';



        force_download($name, $data);

    }



    public function delete($id)

    {

        if (!$this->rbac->hasPrivilege('student', 'can_delete')) {

            access_denied();

        }

        $this->student_model->remove($id);

        $this->session->set_flashdata('msg', '<i class="fa fa-check-square-o" aria-hidden="true"></i> ' . $this->lang->line('delete_message') . '');

        redirect('student/search');

    }



    public function doc_delete($id, $student_id)

    {

        $this->student_model->doc_delete($id);

        $this->session->set_flashdata('msg', $this->lang->line('delete_message'));

        redirect('student/view/' . $student_id);

    }



    public function validateStorage($input, $storage_params_json)

    {

        $uploaded_size = 0;

        // Decode the JSON string to an array

        $storage_params = json_decode($storage_params_json);



        $fields   = explode(',', ($storage_params->fields));  // e.g., ['file', 'father_pic', ...]



        foreach ($fields as $field_key => $field_value) {

            if (isset($_FILES[$field_value]) && !empty($_FILES[$field_value]['name']) && $_FILES[$field_value]['size'] > 0) {



                $file_size = $_FILES[$field_value]['size'];

                if ($file_size > 0) {

                    // Convert size to KB or MB for easier reading if needed

                    $file_size_kb = $file_size / 1024; // Size in KB

                    $file_size_mb = $file_size_kb / 1024; // Size in MB

                    $uploaded_size += $file_size_mb;

                }

            }

        }

        

        if ($uploaded_size >= 0) {

            try {

                $limit_status=$this->saasvalidation->getStorageLimit('storage',$uploaded_size);

                if(!$limit_status){ // if limit is remaining 

                    $this->form_validation->set_message('validateStorage',"The Storage limit has reached.");

                    return FALSE;

                }

            } catch (Exception $e) {

                // Print the exception message for debugging or logging purposes       

                $this->form_validation->set_message('validateStorage','Error: ' . $e->getMessage());

                return FALSE;

              

            }

        }

        return TRUE;

    }



    public function validateResource($input, $resource_params_json)

    {

        try {

            $limit_status=$this->saasvalidation->getResourceLimit('no_of_student',1);

                if(!$limit_status){ // if limit is remaining 

                    $this->form_validation->set_message('validateResource',"The Resource limit has reached.");

                    return FALSE;

                }

        } catch (Exception $e) {

            // Print the exception message for debugging or logging purposes       

            $this->form_validation->set_message('validateResource','Error: ' . $e->getMessage());

            return FALSE;

          

        }



       return TRUE; 

   

    }



  public function create()

    {   
       
        
        $this->load->library('ciqrcode');
       $name = $this->input->post('firstnamem');
     
          
        if (!$this->rbac->hasPrivilege('student', 'can_add')) {

            access_denied();

        }



        $data["month"] = $this->customlib->getMonthDropdown();

        $this->session->set_userdata('top_menu', 'Student Information');

        $this->session->set_userdata('sub_menu', 'student/create');

        $genderList                    = $this->customlib->getGender();

        $data['genderList']            = $genderList;

        $data['sch_setting']           = $this->sch_setting_detail;

        $data['title']                 = 'Add Student';

        $data['title_list']            = 'Recently Added Student';

        $data['adm_auto_insert']       = $this->sch_setting_detail->adm_auto_insert;

        $data["student_categorize"]    = 'class';

        $session                       = $this->setting_model->getCurrentSession();

        $data['feesessiongroup_model'] = $this->feesessiongroup_model->getFeesByGroup();

        $data['transport_fees']        = $this->transportfee_model->getSessionFees($session);

        $student_result                = $this->student_model->getRecentRecord();

        $data['studentlist']           = $student_result;

        $class                         = $this->class_model->get('', $classteacher = 'yes');
        

        $data['stateList'] = get_list('state', array('ctid' => 1), null, null, 0, 'state', 'ASC');

        $data['classlist']       = $class;

        $userdata                = $this->customlib->getUserData();

        $category                = $this->category_model->get();

        $data['categorylist']    = $category;

        $houses                  = $this->student_model->gethouselist();

        $data['houses']          = $houses;

        $data["bloodgroup"]      = $this->blood_group;

        $hostelList              = $this->hostel_model->get();

        $data['hostelList']      = $hostelList;

        $vehroute_result         = $this->vehroute_model->getRouteVehiclesList();

        $data['vehroutelist']    = $vehroute_result;



        //fees discount

        $feesdiscount_result     = $this->feediscount_model->get();

        $data['feediscountList'] = $feesdiscount_result;

        //fees discount



        $custom_fields           = $this->customfield_model->getByBelong('students');



        foreach ($custom_fields as $custom_fields_key => $custom_fields_value) {

            if ($custom_fields_value['validation']) {

                $custom_fields_id   = $custom_fields_value['id'];

                $custom_fields_name = $custom_fields_value['name'];

                $this->form_validation->set_rules("custom_fields[students][" . $custom_fields_id . "]", $custom_fields_name, 'trim|required');

            }

        }

        

        // $resource_params = ['resource' => 'no_of_student'];

        // $storage_params = [

            // 'resource' => 'storage',

            // 'fields'   => 'file,father_pic,mother_pic,guardian_pic,first_doc,second_doc,fourth_doc,fifth_doc'

        // ];



        // $this->form_validation->set_rules('validate_student', "validate_student", "callback_validateResource[" . json_encode($resource_params) . "]");

        // $this->form_validation->set_rules('validate_storage', "validate_storage", "callback_validateStorage[" . json_encode($storage_params) . "]");





        $this->form_validation->set_rules('file', $this->lang->line('image'), 'callback_handle_upload[file]');



        $this->form_validation->set_rules('first_doc', $this->lang->line('image'), 'callback_handle_uploadfordoc[first_doc]');

        $this->form_validation->set_rules('second_doc', $this->lang->line('image'), 'callback_handle_uploadfordoc[second_doc]');

        $this->form_validation->set_rules('fourth_doc', $this->lang->line('image'), 'callback_handle_uploadfordoc[fourth_doc]');

        $this->form_validation->set_rules('fifth_doc', $this->lang->line('image'), 'callback_handle_uploadfordoc[fifth_doc]');

        $this->form_validation->set_rules('firstname', $this->lang->line('first_name'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('gender', $this->lang->line('gender'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('dob', $this->lang->line('date_of_birth'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');



        // if ($this->sch_setting_detail->guardian_name) {

        //     $this->form_validation->set_rules('guardian_name', $this->lang->line('guardian_name'), 'trim|required|xss_clean');

        //     $this->form_validation->set_rules('guardian_is', $this->lang->line('guardian'), 'trim|required|xss_clean');

        // }



        // if ($this->sch_setting_detail->guardian_phone) {

        //     $this->form_validation->set_rules('guardian_phone', $this->lang->line('guardian_phone'), 'trim|required|xss_clean');

        // }



        // $this->form_validation->set_rules(

        //     'email',

        //     $this->lang->line('email'),

        //     array(

        //         'valid_email',

        //         array('check_student_email_exists', array($this->student_model, 'check_student_email_exists')),

        //     )

        // );



        // $this->form_validation->set_rules(

        //     'mobileno',

        //     $this->lang->line('mobile_no'),

        //     array(

        //         'xss_clean',

        //         array('check_student_mobile_exists', array($this->student_model, 'check_student_mobile_no_exists')),

        //     )

        // );



        $sibling_id         = $this->input->post('sibling_id');

        if ($sibling_id > 0) {

        } else {

            $this->form_validation->set_rules(

                'guardian_email',

                $this->lang->line('guardian_email'),

                array(

                    'valid_email',

                    array('check_guardian_email_exists', array($this->student_model, 'check_guardian_email_exists')),

                )

            );

        }



        if (!$this->sch_setting_detail->adm_auto_insert) {

            $this->form_validation->set_rules('admission_no', $this->lang->line('admission_no'), 'trim|required|xss_clean|is_unique[students.admission_no]');

        }



        $transport_feemaster_id = $this->input->post('transport_feemaster_id');

        if (!empty($transport_feemaster_id)) {

            $this->form_validation->set_rules('vehroute_id', $this->lang->line('route_list'), 'trim|required|xss_clean');

            $this->form_validation->set_rules('route_pickup_point_id', $this->lang->line('pickup_point'), 'trim|required|xss_clean');

            $this->form_validation->set_rules('transport_feemaster_id[]', $this->lang->line('fees_month'), 'trim|required|xss_clean');

        }



        if ($this->form_validation->run() == false) {



            $this->load->view('layout/header', $data);

            $this->load->view('student/studentCreate', $data);

            $this->load->view('layout/footer', $data);

        } else {

            

            // try {

                

                // $saas_response=$this->saasvalidation->updateResouceQuota('no_of_student', 1);

                // if($saas_response){          

        

                    $custom_field_post  = $this->input->post("custom_fields[students]");

                    $custom_value_array = array();

                    if (!empty($custom_field_post)) {

        

                        foreach ($custom_field_post as $key => $value) {

                            $check_field_type = $this->input->post("custom_fields[students][" . $key . "]");

                            $field_value      = is_array($check_field_type) ? implode(",", $check_field_type) : $check_field_type;

                            $array_custom     = array(

                                'belong_table_id' => 0,

                                'custom_field_id' => $key,

                                'field_value'     => $field_value,

                            );

                            $custom_value_array[] = $array_custom;

                        }

                    }



                    $class_id              = $this->input->post('class_id');

                    $section_id            = $this->input->post('section_id');

                    $fees_discount         = $this->input->post('fees_discount');

                    $route_pickup_point_id = $this->input->post('route_pickup_point_id');

                    $vehroute_id           = $this->input->post('vehroute_id');

                    

                    if (empty($vehroute_id)) {

                        $vehroute_id = null;

                    }

                    $hostel_room_id = $this->input->post('hostel_room_id');
                    
                    $hostel_id = $this->input->post('hostel_id');

        

                    if (empty($route_pickup_point_id)) {

                        $route_pickup_point_id = null;

                    }

        

                    if (empty($hostel_room_id)) {

                        $hostel_room_id = 0;

                    }
                    
                    if (empty($hostel_id)) {
                        $hostel_id = 0;
                    }



                    $data_insert = array(

                        'firstname'         => $this->input->post('firstname'),
                        'penno'         => $this->input->post('penno'),
                        'firstnamem'         => $this->input->post('firstnamem'),
                        'lastnamem'         => $this->input->post('lastnamem'),
                        'father_namem'         => $this->input->post('father_namem'),
                        'mother_namem'         => $this->input->post('mother_namem'),
                        'cast'         => $this->input->post('cast'),
                        'subcas'         => $this->input->post('subcas'),
                'std_global_id' => $this->input->post('std_global_id'),
                'nationality' => $this->input->post('nationality'),
                'nationality' => $this->input->post('nationality'),
            'admission_enquiry_no' => $this->input->post('admission_enquiry_no'),
             'blood_group' => $this->input->post('blood_group'),
            






             'school_house_id' => $this->input->post('school_house_id'),
             'prev_school_name' => $this->input->post('prev_school_name'),
              'prev_school_standard_covered' => $this->input->post('prev_school_standard_covered'),
             'prev_school_standard_covered' => $this->input->post('prev_school_standard_covered'),
              'prev_school_dateofleaving' => $this->input->post('prev_school_dateofleaving'),
               'prev_school_reasonofleaving' => $this->input->post('prev_school_reasonofleaving'),
                'fitness_cert' => $this->input->post('fitness_cert'),
                     'note' => $this->input->post('note'),
             
             'birth_taluka' => $this->input->post('birth_taluka'),
            'stu_udise_id' => $this->input->post('stu_udise_id'), 
            'apaar_id' => $this->input->post('apaar_id'),
            'birth_district' => $this->input->post('birth_district'),
            'mother_tongue' => $this->input->post('mother_tongue'),
         'other_language_spoken' => $this->input->post('other_language_spoken'),
                      
            // 'dobword' => $this->input->post('dobword'),
         'place_of_birth'   => $this->input->post('place_of_birth'),
         
         
             
        'prev_school_tcnumber' => $this->input->post('prev_school_tcnumber'),
             'fitness_cert'               => $this->input->post('fitness_cert'),
             'academic_preference' => $this->input->post('academic_preference'),
             'academic_conduct' => $this->input->post('academic_conduct'),
              'class_studing_since_when' => $this->input->post('class_studing_since_when'),
             'reason_of_leaving' => $this->input->post('reason_of_leaving'),
             'date_of_leaving' => $this->input->post('date_of_leaving'),
             'remarks' => $this->input->post('remarks'),
            'date_produced_last_school_leaving_certificate'  => $this->input->post('date_produced_last_school_leaving_certificate'),
            
            'father_edu_qualification' => $this->input->post('father_edu_qualification'),
            
            'mother_occupation' => $this->input->post('mother_occupation'),
            
            'mother_edu_qualification' => $this->input->post('mother_edu_qualification'),
             'num_of_brother' => $this->input->post('num_of_brother'),
              'elder_brother' => $this->input->post('elder_brother'),
                'younger_brother' => $this->input->post('younger_brother'),
                 'num_of_sister' => $this->input->post('num_of_sister'),
                'elder_sister' => $this->input->post('elder_sister'),
                 'younger_sister' => $this->input->post('younger_sister'),
                 'vaccinations' => $this->input->post('vaccinations'),
                'languages_studied' => $this->input->post('languages_studied'),
               'medium_of_instruction_in_last_school' => $this->input->post('medium_of_instruction_in_last_school'),
               'if_pupil_produced_last_school_leaving_certificate' => $this->input->post('if_pupil_produced_last_school_leaving_certificate'),
               
                
                'fillbyoffice_admittedto'  => $this->input->post('fillbyoffice_admittedto'),
                'fillbyoffice_onpaymentfees'  => $this->input->post('fillbyoffice_onpaymentfees'),
                'fillbyoffice_paymentfeesreceiptno'  => $this->input->post('fillbyoffice_paymentfeesreceiptno'),
                'fillbyoffice_anycomment'  => $this->input->post('fillbyoffice_anycomment'),
                'prev_school_scholarship'  => $this->input->post('prev_school_scholarship'),
                    
                   'parent_annual_income'  => $this->input->post('parent_annual_income'), 
                    
                  'number_of_dependent'  => $this->input->post('number_of_dependent'),  
                      'if_pupil_living_with_parent'  => $this->input->post('if_pupil_living_with_parent'), 
                    
                    
                    
                    
                        'rte'               => $this->input->post('rte'),

                        'state'             => $this->input->post('state'),

                        'city'              => $this->input->post('city'),

                        'pincode'           => $this->input->post('pincode'),

                        'cast'              => $this->input->post('cast'),

                        'previous_school'   => $this->input->post('previous_school'),

                        'dob'  => $this->customlib->dateFormatToYYYYMMDD($this->input->post('dob')),

                        'current_address'   => $this->input->post('current_address'),

                        'permanent_address' => $this->input->post('permanent_address'),

                        'adhar_no'          => $this->input->post('adhar_no'),

                        'samagra_id'        => $this->input->post('samagra_id'),

                        'bank_account_no'   => $this->input->post('bank_account_no'),

                        'bank_name'         => $this->input->post('bank_name'),

                        'ifsc_code'         => $this->input->post('ifsc_code'),

                        'guardian_email'    => $this->input->post('guardian_email'),

                        'gender'            => $this->input->post('gender'),

                        'guardian_name'     => $this->input->post('guardian_name'),

                        'guardian_relation' => $this->input->post('guardian_relation'),

                        'guardian_phone'    => $this->input->post('guardian_phone'),

                        'guardian_address'  => $this->input->post('guardian_address'),

                        'hostel_room_id'    => $hostel_room_id,
                        
                        'hostel_id'         => $hostel_id,

                        'note'              => $this->input->post('note'),

                        'is_active'         => 'yes',

                    );

        

                    if ($this->sch_setting_detail->guardian_occupation) {

                        $data_insert['guardian_occupation'] = $this->input->post('guardian_occupation');

                    }



                    $house             = $this->input->post('house');

                    $blood_group       = $this->input->post('blood_group');

                    $measurement_date  = $this->input->post('measure_date');

                    $roll_no           = $this->input->post('roll_no');

                    $lastname          = $this->input->post('lastname');

                    $middlename        = $this->input->post('middlename');

                    $category_id       = $this->input->post('category_id');

                    $religion          = $this->input->post('religion');

                    $mobileno          = $this->input->post('mobileno');

                    $email             = $this->input->post('email');

                    $admission_date    = $this->input->post('admission_date');

                    $height            = $this->input->post('height');

                    $weight            = $this->input->post('weight');

                    $father_name       = $this->input->post('father_name');

                    $father_phone      = $this->input->post('father_phone');

                    $father_occupation = $this->input->post('father_occupation');

                    $mother_name       = $this->input->post('mother_name');

                    $mother_phone      = $this->input->post('mother_phone');

                    $mother_occupation = $this->input->post('mother_occupation');



                    if ($this->sch_setting_detail->guardian_name) {

                        $data_insert['guardian_is'] = $this->input->post('guardian_is');

                    }

                    if (isset($measurement_date)) {

                        $data_insert['measurement_date'] = $this->customlib->dateFormatToYYYYMMDD($this->input->post('measure_date'));

                    }

                    if (isset($house)) {

                        $data_insert['school_house_id'] = $this->input->post('house');

                    }

                    if (isset($blood_group)) {

                        $data_insert['blood_group'] = $this->input->post('blood_group');

                    }

                    if (isset($roll_no)) {

                        $data_insert['roll_no'] = $this->input->post('roll_no');

                    }

                    if (isset($lastname)) {

                        $data_insert['lastname'] = $this->input->post('lastname');

                    }

                    if (isset($middlename)) {

                        $data_insert['middlename'] = $this->input->post('middlename');

                    }

                    if (isset($category_id)) {

                        $data_insert['category_id'] = $this->input->post('category_id');

                    }

                    if (isset($religion)) {

                        $data_insert['religion'] = $this->input->post('religion');

                    }

                    if (isset($mobileno)) {

                        $data_insert['mobileno'] = $this->input->post('mobileno');

                    }

                    if (isset($email)) {

                        $data_insert['email'] = $this->input->post('email');

                    }

                    if (isset($admission_date)) {

                        $data_insert['admission_date'] = $this->customlib->dateFormatToYYYYMMDD($this->input->post('admission_date'));

                    }

                    if (isset($height)) {

                        $data_insert['height'] = $this->input->post('height');

                    }

                    if (isset($weight)) {

                        $data_insert['weight'] = $this->input->post('weight');

                    }

                    if (isset($father_name)) {

                        $data_insert['father_name'] = $this->input->post('father_name');

                    }

                    if (isset($father_phone)) {

                        $data_insert['father_phone'] = $this->input->post('father_phone');

                    }

                    if (isset($father_occupation)) {

                        $data_insert['father_occupation'] = $this->input->post('father_occupation');

                    }

                    if (isset($mother_name)) {

                        $data_insert['mother_name'] = $this->input->post('mother_name');

                    }

                    if (isset($mother_phone)) {

                        $data_insert['mother_phone'] = $this->input->post('mother_phone');

                    }

                    if (isset($mother_occupation)) {

                        $data_insert['mother_occupation'] = $this->input->post('mother_occupation');

                    }

        

                    $fee_session_group_id = $this->input->post('fee_session_group_id');

        

                    $insert                            = true;

                    $data_setting                      = array();

                    $data_setting['id']                = $this->sch_setting_detail->id;

                    $data_setting['adm_auto_insert']   = $this->sch_setting_detail->adm_auto_insert;

                    $data_setting['adm_update_status'] = $this->sch_setting_detail->adm_update_status;

                    $admission_no                      = 0;

        

                    if ($this->sch_setting_detail->adm_auto_insert) {

                        if ($this->sch_setting_detail->adm_update_status) {

        

                            $admission_no = $this->sch_setting_detail->adm_prefix . $this->sch_setting_detail->adm_start_from;

        

                            $last_student = $this->student_model->lastRecord();

                            if (!empty($last_student)) {

        

                                $last_admission_digit = str_replace($this->sch_setting_detail->adm_prefix, "", $last_student->admission_no);

        

                                $admission_no                = $this->sch_setting_detail->adm_prefix . sprintf("%0" . $this->sch_setting_detail->adm_no_digit . "d", $last_admission_digit + 1);

                                $data_insert['admission_no'] = $admission_no;

                            } else {

                                $admission_no                = $this->sch_setting_detail->adm_prefix . $this->sch_setting_detail->adm_start_from;

                                $data_insert['admission_no'] = $admission_no;

                            }

                        } else {

                            $admission_no                = $this->sch_setting_detail->adm_prefix . $this->sch_setting_detail->adm_start_from;

                            $data_insert['admission_no'] = $admission_no;

                        }

        

                        $admission_no_exists = $this->student_model->check_adm_exists($admission_no);

                        if ($admission_no_exists) {

                            $insert = false;

                        }

                    } else {

                        $data_insert['admission_no'] = $this->input->post('admission_no');

                    }



                    if (empty($_FILES["file"])) {

                        if ($this->input->post('gender') == 'Female') {

                            $data_insert['image'] = 'uploads/student_images/default_female.jpg';

                        } else {

                            $data_insert['image'] = 'uploads/student_images/default_male.jpg';

                        }

                    }



                    if (isset($_FILES['file']) && !empty($_FILES['file']['name'])) {
    $file     = $_FILES['file'];
    $filename = time() . '_' . preg_replace('/\s+/', '_', $file['name']); // Clean filename
    $upload_path = './uploads/student_images/';
    $full_path   = $upload_path . $filename;

    // Make sure directory exists
    if (!is_dir($upload_path)) {
        mkdir($upload_path, 0755, true);
    }

    // Move the uploaded file
    if (move_uploaded_file($file['tmp_name'], $full_path)) {
        $data_insert['image'] = "uploads/student_images/" . $filename;
    } else {
        // Handle error if upload fails
        $data_insert['image'] = null; // or return error message
    }
}


        

                  if (isset($_FILES["father_pic"]) && !empty($_FILES['father_pic']['name'])) {

    $target_dir  = "./uploads/student_images/";
    $filename    = basename($_FILES["father_pic"]["name"]);
    $target_file = $target_dir . time() . "_" . $filename; // optional: prepend time to avoid filename collisions

    // Create the uploads directory if it doesn't exist
    if (!is_dir($target_dir)) {
        mkdir($target_dir, 0755, true);
    }

    if (move_uploaded_file($_FILES["father_pic"]["tmp_name"], $target_file)) {
        $data_insert['father_pic'] = $target_file;
    } else {
        // Optional: handle error
        $data_insert['father_pic'] = ''; // or handle error message
    }
}


        
         if (isset($_FILES["mother_pic"]) && !empty($_FILES['mother_pic']['name'])) {

    $target_dir  = "./uploads/student_images/";
    $filename    = basename($_FILES["mother_pic"]["name"]);
    $new_name    = time() . "_" . $filename; // prevent overwriting existing files
    $target_file = $target_dir . $new_name;

    // Ensure the directory exists
    if (!is_dir($target_dir)) {
        mkdir($target_dir, 0755, true);
    }

    // Move the uploaded file
    if (move_uploaded_file($_FILES["mother_pic"]["tmp_name"], $target_file)) {
        $data_insert['mother_pic'] = "uploads/student_images/" . $new_name;
    } else {
        // Optional: handle upload failure
        $data_insert['mother_pic'] = '';
    }
}

        

                   if (isset($_FILES["guardian_pic"]) && !empty($_FILES['guardian_pic']['name'])) {

    $target_dir  = "./uploads/student_images/";
    $filename    = basename($_FILES["guardian_pic"]["name"]);
    $new_name    = time() . "_" . $filename; // Add timestamp to avoid filename conflicts
    $target_file = $target_dir . $new_name;

    // Create the directory if it doesn't exist
    if (!is_dir($target_dir)) {
        mkdir($target_dir, 0755, true);
    }

    // Move the uploaded file
    if (move_uploaded_file($_FILES["guardian_pic"]["tmp_name"], $target_file)) {
        $data_insert['guardian_pic'] = "uploads/student_images/" . $new_name;
    } else {
        // Optional: log or handle the error
        $data_insert['guardian_pic'] = '';
    }
}




                    if ($insert) {

                        $data_insert['created_by'] = $this->session->userdata['admin']['id'];



                        $insert_id = $this->student_model->add($data_insert, $data_setting);

                        if (!empty($custom_value_array)) {

                            $this->customfield_model->insertRecord($custom_value_array, $insert_id);

                        }



                        $data_new = array(

                            'student_id'            => $insert_id,

                            'class_id'              => $class_id,

                            'section_id'            => $section_id,

                            'session_id'            => $session,

                            'fees_discount'         => $fees_discount,

                            'route_pickup_point_id' => $route_pickup_point_id,

                            'vehroute_id'           => $vehroute_id,

                        );

                        $student_session_id     = $this->student_model->add_student_session($data_new);

                        $transport_feemaster_id = $this->input->post('transport_feemaster_id');

        

                        if ($fee_session_group_id) {

                            $this->studentfeemaster_model->assign_bulk_fees($fee_session_group_id, $student_session_id, array());

                        }

        

                        //*** assign fees discount ***//

                        $discount_id = $this->input->post('discount_id[]');

                        if (!empty($discount_id)) {

                            foreach ($discount_id as $key => $value) {

                                $insert_array = array(

                                    'student_session_id' => $student_session_id,

                                    'fees_discount_id'   => $value,

                                );

                                $this->feediscount_model->allotdiscount($insert_array);

                            }

                        }

                        //*** assign fees discount ***//



                        if (!empty($transport_feemaster_id)) {

                            $trns_data_insert = array();

                            foreach ($transport_feemaster_id as $transport_feemaster_key => $transport_feemaster_value) {

                                $trns_data_insert[] = array(

                                    'student_session_id'     => $student_session_id,

                                    'route_pickup_point_id'  => $route_pickup_point_id,

                                    'transport_feemaster_id' => $transport_feemaster_value,

                                );

                            }

        

                            $student_session_is = $this->studenttransportfee_model->add($trns_data_insert, $student_session_id, array(), $route_pickup_point_id);

                        }



                        $user_password = '123456';
        

                        $sibling_id         = $this->input->post('sibling_id');

                        $data_student_login = array(

                            'username' => $this->student_login_prefix . $insert_id,

                            'password' => $user_password,

                            'user_id'  => $insert_id,

                            'role'     => 'student',

                            'lang_id'  => $this->sch_setting_detail->lang_id,

                        );

        

                        $this->user_model->add($data_student_login);



                        if ($sibling_id > 0) {

                            $student_sibling = $this->student_model->get($sibling_id);

                            $update_student  = array(

                                'id'        => $insert_id,

                                'parent_id' => $student_sibling['parent_id'],

                            );

                            $student_sibling = $this->student_model->add($update_student);

                        } else {

                            $parent_password  = '123456';

                            $temp              = $insert_id;

                            $data_parent_login = array(

                                'username' => $this->parent_login_prefix . $insert_id,

                                'password' => $parent_password,

                                'user_id'  => 0,

                                'role'     => 'parent',

                                'childs'   => $temp,

                            );

                            $ins_parent_id  = $this->user_model->add($data_parent_login);

                            $update_student = array(

                                'id'        => $insert_id,

                                'parent_id' => $ins_parent_id,

                            );

                            $this->student_model->add($update_student);

                        }

                        

                        $upload_directory = 'uploads/student_documents/' . $insert_id . '/';
$upload_dir_path  = FCPATH . $upload_directory;

if (!is_dir($upload_dir_path) && !mkdir($upload_dir_path, 0777, true)) {
    die("Error creating folder $upload_dir_path");
}



                        if (isset($_FILES["first_doc"]) && !empty($_FILES['first_doc']['name'])) {

        

                            $first_title = $this->input->post('first_title');

                            $imp         = $this->media_storage->fileupload("first_doc", $upload_directory);

                            $data_img    = array('student_id' => $insert_id, 'title' => $first_title, 'doc' => $imp);

                            $this->student_model->adddoc($data_img);

                        }

        

                        if (isset($_FILES["second_doc"]) && !empty($_FILES['second_doc']['name'])) {

                            $second_title = $this->input->post('second_title');

                            $imp          = $this->media_storage->fileupload("second_doc", $upload_directory);

                            $data_img     = array('student_id' => $insert_id, 'title' => $second_title, 'doc' => $imp);

                            $this->student_model->adddoc($data_img);

                        }

        

                        if (isset($_FILES["fourth_doc"]) && !empty($_FILES['fourth_doc']['name'])) {

                            $fourth_title = $this->input->post('fourth_title');

                            $imp          = $this->media_storage->fileupload("fourth_doc", $upload_directory);

                            $data_img     = array('student_id' => $insert_id, 'title' => $fourth_title, 'doc' => $imp);

                            $this->student_model->adddoc($data_img);

                        }

        

                        if (isset($_FILES["fifth_doc"]) && !empty($_FILES['fifth_doc']['name'])) {

                            $fifth_title = $this->input->post('fifth_title');

                            $imp         = $this->media_storage->fileupload("fifth_doc", $upload_directory);

                            $data_img    = array('student_id' => $insert_id, 'title' => $fifth_title, 'doc' => $imp);

                            $this->student_model->adddoc($data_img);

                        }



                        $sender_details = array('student_id' => $insert_id, 'student_phone' => $this->input->post('mobileno'), 'guardian_phone' => $this->input->post('guardian_phone'), 'student_email' => $this->input->post('email'), 'guardian_email' => $this->input->post('guardian_email'), 'student_session_id' => $student_session_id);

        

                        // $this->mailsmsconf->mailsms('student_admission', $sender_details);

        

                        $student_login_detail = array('id' => $insert_id, 'credential_for' => 'student', 'first_name' => $this->input->post('firstname'), 'last_name' => $this->input->post('lastname'), 'username' => $this->student_login_prefix . $insert_id, 'password' => $user_password, 'contact_no' => $this->input->post('mobileno'), 'email' => $this->input->post('email'), 'admission_no' => $data_insert['admission_no'], 'student_session_id' => $student_session_id);

        

                        // $this->mailsmsconf->mailsms('student_login_credential', $student_login_detail);



                        if ($sibling_id > 0) {

                        } else {

                            $parent_login_detail = array('id' => $insert_id, 'credential_for' => 'parent', 'username' => $this->parent_login_prefix . $insert_id, 'password' => $parent_password, 'contact_no' => $this->input->post('guardian_phone'), 'email' => $this->input->post('guardian_email'), 'admission_no' => $data_insert['admission_no'], 'student_session_id' => $student_session_id);

                            // $this->mailsmsconf->mailsms('student_login_credential', $parent_login_detail);

                        }

        

                        //generate student id card

                        $student_details  = $this->student_model->get($insert_id);

                        $scan_type = $this->sch_setting_detail->scan_code_type;

                        // $this->customlib->generatebarcode($student_details['admission_no'], $student_details['id'], $scan_type);

                        //generate student id card
                        
                        // Get input data
    $data = $student_details['admission_no'];

    // Hex encode for filename
    $hex_data  = bin2hex($data);
    $save_name = $hex_data . '.png';

    // QR Code File Directory Initialize
      $dir = 'uploads/student_id_card/qrcode/';
    if (!file_exists($dir)) {
        mkdir($dir, 0775, true);
    }

    // QR Configuration
    $config['cacheable'] = true;
    $config['imagedir']  = $dir;
    $config['quality']   = true;
    $config['size']      = '1024';
    $config['black']     = array(255, 255, 255);
    $config['white']     = array(255, 255, 255);
    $this->ciqrcode->initialize($config);

    // QR Generate Parameters
    $params['data']     = $data;
    $params['level']    = 'L';
    $params['size']     = 10;
    $params['savename'] = FCPATH . $dir . $save_name;

    // Generate QR Code
    $this->ciqrcode->generate($params);

    // Prepare data for DB insertion
    $update_data = array(
    'student_qr' => $dir . $save_name // Save relative path
);

// Update student record based on $insert_id
$this->db->where('id', $insert_id); // Assuming 'id' is your PK column
$this->db->update('students', $update_data);


     $this->load->library('Zend');
$this->zend->load('Zend/Barcode');

// Generate barcode text (e.g., admission number)
$code = $student_details['admission_no'];

// Define folder path
$folder_path = FCPATH . 'uploads/student_id_card/barcodes/';

// Create folder if it doesn't exist
if (!file_exists($folder_path)) {
    mkdir($folder_path, 0777, true);
}

// Define filename and full file path
$filename   = $code . '.png';
$file_path  = $folder_path . $filename;

// Barcode generation options
$barcodeOptions   = ['text' => $code];
$rendererOptions  = [];

// Generate barcode image
$imageResource = Zend_Barcode::factory('code128', 'image', $barcodeOptions, $rendererOptions)->draw();
imagepng($imageResource, $file_path);
imagedestroy($imageResource); // Free memory

// Prepare data for update
$updatedata = array(
    'student_barcode' => 'uploads/student_id_card/barcodes/' . $filename
);

// Update student record
$this->db->where('id', $insert_id); // Assuming $insert_id is the student ID
$this->db->update('students', $updatedata);



            $this->session->set_flashdata('msg', '<div class="alert alert-success">' . $this->lang->line('success_message') . '</div>');

                        redirect('student/create');

                    } else {

        

                        $data['error_message'] = $this->lang->line('admission_no') . ' ' . $admission_no . ' ' . $this->lang->line('already_exists');

                        $this->load->view('layout/header', $data);

                        $this->load->view('student/studentCreate', $data);

                        $this->load->view('layout/footer', $data);

                    }

                // }

                 

            // } catch (Exception $e) {

                      // Print the exception message for debugging or logging purposes

                        // echo 'Error: ' . $e->getMessage();

              

            // }

        }

    }



    public function create_doc()

    {

        $this->form_validation->set_rules('first_title', $this->lang->line('title'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('first_doc', $this->lang->line('document'), 'callback_handle_uploadcreate_doc');



        if ($this->form_validation->run() == false) {

            $msg = array(

                'first_title' => form_error('first_title'),

                'first_doc'   => form_error('first_doc'),

            );

            $array = array('status' => 'fail', 'error' => $msg, 'message' => '');

        } else {

            $student_id = $this->input->post('student_id');

            if (isset($_FILES["first_doc"]) && !empty($_FILES['first_doc']['name'])) {

                $upload_dir_path = $this->customlib->getFolderPath() . './uploads/student_documents/' . $student_id . '/';



                if (!is_dir($upload_dir_path) && !mkdir($upload_dir_path)) {

                    die("Error creating folder $upload_dir_path");

                }



                $fileInfo    = pathinfo($_FILES["first_doc"]["name"]);

                $first_title = $this->input->post('first_title');

                $imp         = $this->media_storage->fileupload("first_doc", './uploads/student_documents/' . $student_id . '/');

                $data_img    = array('student_id' => $student_id, 'title' => $first_title, 'doc' => $imp);

                $this->student_model->adddoc($data_img);

            }



            $msg   = $this->lang->line('success_message');

            $array = array('status' => 'success', 'error' => '', 'message' => $msg);

        }

        echo json_encode($array);

    }



    public function handle_uploadcreate_doc()

    {

        $image_validate = $this->config->item('file_validate');

        $result         = $this->filetype_model->get();

        if (isset($_FILES["first_doc"]) && !empty($_FILES['first_doc']['name'])) {



            $file_type = $_FILES["first_doc"]['type'];

            $file_size = $_FILES["first_doc"]["size"];

            $file_name = $_FILES["first_doc"]["name"];



            $allowed_extension = array_map('trim', array_map('strtolower', explode(',', $result->file_extension)));

            $allowed_mime_type = array_map('trim', array_map('strtolower', explode(',', $result->file_mime)));

            $ext               = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));



            $finfo = finfo_open(FILEINFO_MIME_TYPE);

            $mtype = finfo_file($finfo, $_FILES['first_doc']['tmp_name']);

            finfo_close($finfo);



            if (!in_array($mtype, $allowed_mime_type)) {

                $this->form_validation->set_message('handle_uploadcreate_doc', $this->lang->line('file_type_not_allowed'));

                return false;

            }



            if (!in_array($ext, $allowed_extension) || !in_array($file_type, $allowed_mime_type)) {

                $this->form_validation->set_message('handle_uploadcreate_doc', $this->lang->line('extension_not_allowed'));

                return false;

            }

            if ($file_size > $result->file_size) {

                $this->form_validation->set_message('handle_uploadcreate_doc', $this->lang->line('file_size_shoud_be_less_than') . number_format($result->file_size / 1048576, 2) . " MB");

                return false;

            }



            return true;

        } else {

            $this->form_validation->set_message('handle_uploadcreate_doc', $this->lang->line('the_document_field_is_required'));

            return false;

        }

        return true;

    }



    public function handle_father_upload()

    {

        $image_validate = $this->config->item('image_validate');

        $result         = $this->filetype_model->get();

        if (isset($_FILES["father_pic"]) && !empty($_FILES['father_pic']['name'])) {



            $file_type = $_FILES["father_pic"]['type'];

            $file_size = $_FILES["father_pic"]["size"];

            $file_name = $_FILES["father_pic"]["name"];



            $allowed_extension = array_map('trim', array_map('strtolower', explode(',', $result->image_extension)));

            $allowed_mime_type = array_map('trim', array_map('strtolower', explode(',', $result->image_mime)));

            $ext               = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));



            if ($files = @getimagesize($_FILES['father_pic']['tmp_name'])) {



                if (!in_array($files['mime'], $allowed_mime_type)) {

                    $this->form_validation->set_message('handle_father_upload', $this->lang->line('file_type_not_allowed'));

                    return false;

                }

                if (!in_array($ext, $allowed_extension) || !in_array($file_type, $allowed_mime_type)) {

                    $this->form_validation->set_message('handle_father_upload', $this->lang->line('extension_not_allowed'));

                    return false;

                }

                if ($file_size > $result->image_size) {

                    $this->form_validation->set_message('handle_father_upload', $this->lang->line('file_size_shoud_be_less_than') . number_format($result->image_size / 1048576, 2) . " MB");

                    return false;

                }

            } else {

                $this->form_validation->set_message('handle_father_upload', $this->lang->line('file_type_extension_error_uploading_image'));

                return false;

            }



            return true;

        }

        return true;

    }



    public function handle_mother_upload()

    {

        $image_validate = $this->config->item('image_validate');

        $result         = $this->filetype_model->get();

        if (isset($_FILES["mother_pic"]) && !empty($_FILES['mother_pic']['name'])) {



            $file_type = $_FILES["mother_pic"]['type'];

            $file_size = $_FILES["mother_pic"]["size"];

            $file_name = $_FILES["mother_pic"]["name"];



            $allowed_extension = array_map('trim', array_map('strtolower', explode(',', $result->image_extension)));

            $allowed_mime_type = array_map('trim', array_map('strtolower', explode(',', $result->image_mime)));

            $ext               = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));



            if ($files = @getimagesize($_FILES['mother_pic']['tmp_name'])) {



                if (!in_array($files['mime'], $allowed_mime_type)) {

                    $this->form_validation->set_message('handle_mother_upload', $this->lang->line('file_type_not_allowed'));

                    return false;

                }

                if (!in_array($ext, $allowed_extension) || !in_array($file_type, $allowed_mime_type)) {

                    $this->form_validation->set_message('handle_mother_upload', $this->lang->line('extension_not_allowed'));

                    return false;

                }

                if ($file_size > $result->image_size) {

                    $this->form_validation->set_message('handle_mother_upload', $this->lang->line('file_size_shoud_be_less_than') . number_format($result->image_size / 1048576, 2) . " MB");

                    return false;

                }

            } else {

                $this->form_validation->set_message('handle_mother_upload', $this->lang->line('file_type_extension_error_uploading_image'));

                return false;

            }



            return true;

        }

        return true;

    }



    public function handle_guardian_upload()

    {

        $image_validate = $this->config->item('image_validate');

        $result         = $this->filetype_model->get();

        if (isset($_FILES["guardian_pic"]) && !empty($_FILES['guardian_pic']['name'])) {



            $file_type = $_FILES["guardian_pic"]['type'];

            $file_size = $_FILES["guardian_pic"]["size"];

            $file_name = $_FILES["guardian_pic"]["name"];



            $allowed_extension = array_map('trim', array_map('strtolower', explode(',', $result->image_extension)));

            $allowed_mime_type = array_map('trim', array_map('strtolower', explode(',', $result->image_mime)));

            $ext               = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));



            if ($files = @getimagesize($_FILES['guardian_pic']['tmp_name'])) {



                if (!in_array($files['mime'], $allowed_mime_type)) {

                    $this->form_validation->set_message('handle_guardian_upload', $this->lang->line('file_type_not_allowed'));

                    return false;

                }

                if (!in_array($ext, $allowed_extension) || !in_array($file_type, $allowed_mime_type)) {

                    $this->form_validation->set_message('handle_guardian_upload', $this->lang->line('extension_not_allowed'));

                    return false;

                }

                if ($file_size > $result->image_size) {

                    $this->form_validation->set_message('handle_guardian_upload', $this->lang->line('file_size_shoud_be_less_than') . number_format($result->image_size / 1048576, 2) . " MB");

                    return false;

                }

            } else {

                $this->form_validation->set_message('handle_guardian_upload', $this->lang->line('file_type_extension_error_uploading_image'));

                return false;

            }



            return true;

        }

        return true;

    }



    public function sendpassword()

    {

        $student_login_detail = array('id' => $this->input->post('student_id'), 'credential_for' => 'student', 'username' => $this->input->post('username'), 'password' => $this->input->post('password'), 'contact_no' => $this->input->post('contact_no'), 'email' => $this->input->post('email'), 'admission_no' => $this->input->post('admission_no'), 'student_session_id' => $this->input->post('student_session_id'));



        $msg = $this->mailsmsconf->mailsms('student_login_credential', $student_login_detail);

    }



    public function send_parent_password()

    {

        $parent_login_detail = array('id' => $this->input->post('student_id'), 'credential_for' => 'parent', 'username' => $this->input->post('username'), 'password' => $this->input->post('password'), 'contact_no' => $this->input->post('contact_no'), 'email' => $this->input->post('email'), 'admission_no' => $this->input->post('admission_no'), 'student_session_id' => $this->input->post('student_session_id'));



        $msg = $this->mailsmsconf->mailsms('student_login_credential', $parent_login_detail);

    }




public function import()
{
    if (!$this->rbac->hasPrivilege('import_student', 'can_view')) {
        access_denied();
    }

    $data['title'] = $this->lang->line('import_student');
    $data['title_list'] = $this->lang->line('recently_added_student');
    $session = $this->setting_model->getCurrentSession();
    $class = $this->class_model->get('', $classteacher = 'yes');
    $data['classlist'] = $class;
    $category = $this->category_model->get();
    $data['categorylist'] = $category;

    $fields = array(
        'admission_no', 'roll_no', 'firstname', 'middlename', 'lastname', 'gender', 'religion', 'father_phone', 'email',
        'admission_date', 'father_name', 'mother_name', 'guardian_is', 'guardian_name', 'guardian_relation',
        'guardian_phone', 'stu_udise_id', 'dob', 'rte', 'category_id', 'adhar_no', 'apaar_id', 'penno', 'guardian_address'
    );
    $data["fields"] = $fields;

    $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
    $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
    $this->form_validation->set_rules('file', $this->lang->line('image'), 'callback_handle_csv_upload');

    if ($this->form_validation->run() == false) {
        $this->load->view('layout/header', $data);
        $this->load->view('student/import', $data);
        $this->load->view('layout/footer', $data);
    } else {
        $class_id = $this->input->post('class_id');
        $section_id = $this->input->post('section_id');

        if (isset($_FILES["file"]) && !empty($_FILES['file']['name'])) {
            $ext = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
            if (strtolower($ext) == 'csv') {
                $file = $_FILES['file']['tmp_name'];
                $this->load->library('CSVReader');
                $result = $this->csvreader->parse_file($file);

                if (!empty($result)) {
                    $rowcount = 0;

                    foreach ($result as $row) {
                        $student_data = [];

                        foreach ($row as $key => $value) {
                            if (in_array($key, $fields)) {
                                $student_data[$key] = $this->encoding_lib->toUTF8($value);
                            }
                        }

                        $student_data['is_active'] = 'yes';

                        // Format date fields
                        foreach (['dob', 'admission_date'] as $field) {
                            if (!empty($student_data[$field]) && strtotime($student_data[$field])) {
                                $student_data[$field] = date('Y-m-d', strtotime($student_data[$field]));
                            } else {
                                $student_data[$field] = null;
                            }
                        }

                        $student_data['category_id'] = $this->getCategoryIdByName($row['category_id'] ?? '');
                        $student_data['stu_udise_id'] = $row['stu_udise_id'] ?? '';
                        $student_data['rte'] = $row['rte'] ?? '';
                         $student_data['mobileno'] = $row['father_phone'] ?? '';

                        $adm_no = $student_data["admission_no"] ?? '';
                        $mobile_no = $student_data["mobileno"] ?? '';
                        $email = $student_data["email"] ?? '';
                        $guardian_phone = $student_data["guardian_phone"] ?? '';
                        $guardian_email = $student_data["guardian_email"] ?? '';

                        $data_setting = [
                            'id' => $this->sch_setting_detail->id,
                            'adm_auto_insert' => $this->sch_setting_detail->adm_auto_insert,
                            'adm_update_status' => $this->sch_setting_detail->adm_update_status
                        ];

                        $insert_id = null;

                        if ($this->sch_setting_detail->adm_auto_insert) {
                            if ($this->sch_setting_detail->adm_update_status) {
                                $last_student = $this->student_model->lastRecord();
                                $last_adm_no = (int) str_replace($this->sch_setting_detail->adm_prefix, '', $last_student->admission_no);
                                $admission_no = $this->sch_setting_detail->adm_prefix . sprintf("%0" . $this->sch_setting_detail->adm_no_digit . "d", $last_adm_no + 1);
                            } else {
                                $admission_no = $this->sch_setting_detail->adm_prefix . $this->sch_setting_detail->adm_start_from;
                            }

                            $student_data['admission_no'] = $admission_no;

                            if (!$this->student_model->check_adm_exists($admission_no)) {
                                $insert_id = $this->student_model->add($student_data, $data_setting);
                            }
                        } else {
                            if ($this->form_validation->is_unique($adm_no, 'students.admission_no')) {
                                $insert_id = $this->student_model->add($student_data, $data_setting);
                            }
                        }

                        if (!empty($insert_id)) {
                            // Add student session
                            $this->student_model->add_student_session([
                                'student_id' => $insert_id,
                                'class_id' => $class_id,
                                'section_id' => $section_id,
                                'session_id' => $session,
                            ]);

                            // Student login
                            $user_password = '123456';
                            $this->user_model->add([
                                'username' => $this->student_login_prefix . $insert_id,
                                'password' => $user_password,
                                'user_id' => $insert_id,
                                'role' => 'student',
                            ]);

                            // Parent login
                            $parent_password = '123456';
                            $parent_login_id = $this->user_model->add([
                                'username' => $this->parent_login_prefix . $insert_id,
                                'password' => $parent_password,
                                'user_id' => $insert_id,
                                'role' => 'parent',
                                'childs' => $insert_id,
                            ]);

                            $this->student_model->add([
                                'id' => $insert_id,
                                'parent_id' => $parent_login_id,
                            ]);

                            $rowcount++;
                        }
                    }

                    $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">' .
                        $this->lang->line('total') . ' ' . count($result) . ' ' .
                        $this->lang->line('records_found_in_csv_file_total') . ' ' . $rowcount . ' ' .
                        $this->lang->line('records_imported_successfully') . '</div>');

                } else {
                    $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">' . $this->lang->line('no_record_found') . '</div>');
                }
            } else {
                $this->session->set_flashdata('msg', '<div class="alert alert-danger text-center">' . $this->lang->line('please_upload_csv_file_only') . '</div>');
            }
        }

        redirect('student/import');
        exit;
    }
}



private function getCategoryIdByName($name)
{
    $category = $this->category_model->get();
    foreach ($category as $cat) {
        if (strcasecmp(trim($cat['category']), trim($name)) == 0) {
            return (int)$cat['id'];
        }
    }
    return null; // Return null if not found
}


    public function handle_csv_upload()

    {

        $error = "";

        if (isset($_FILES["file"]) && !empty($_FILES['file']['name'])) {

            $allowedExts = array('csv');

            $mimes       = array(

                'text/csv',

                'text/plain',

                'application/csv',

                'text/comma-separated-values',

                'application/excel',

                'application/vnd.ms-excel',

                'application/vnd.msexcel',

                'text/anytext',

                'application/octet-stream',

                'application/txt'

            );

            $temp      = explode(".", $_FILES["file"]["name"]);

            $extension = end($temp);

            if ($_FILES["file"]["error"] > 0) {

                $error .= "Error opening the file<br />";

            }

            if (!in_array($_FILES['file']['type'], $mimes)) {

                $error .= "Error opening the file<br />";

                $this->form_validation->set_message('handle_csv_upload', $this->lang->line('file_type_not_allowed'));

                return false;

            }

            if (!in_array($extension, $allowedExts)) {

                $error .= "Error opening the file<br />";

                $this->form_validation->set_message('handle_csv_upload', $this->lang->line('extension_not_allowed'));

                return false;

            }

            if ($error == "") {

                return true;

            }

        } else {

            $this->form_validation->set_message('handle_csv_upload', $this->lang->line('please_select_file'));

            return false;

        }

    }



     public function edit($id)

    {



        if (!$this->rbac->hasPrivilege('student', 'can_edit')) {

            access_denied();

        }

        $data['title']                 = $this->lang->line('edit_student');
        $data['stateList'] = get_list('state', array('ctid' => 1), null, null, 0, 'state', 'ASC');

        $data['id']                    = $id;

        $student                       = $this->student_model->get($id);
        
     
        
        
        
        
      

        $genderList                    = $this->customlib->getGender();

        $data['student']               = $student;

        $data["month"]                 = $this->customlib->getMonthDropdown();

        $data['feesessiongroup_model'] = $this->feesessiongroup_model->getFeesByGroupByStudent($student['student_session_id']);



        $data['adm_auto_insert'] = $this->sch_setting_detail->adm_auto_insert;

        $data['genderList']      = $genderList;

        $session                 = $this->setting_model->getCurrentSession();

        $data['transport_fees']  = $this->studenttransportfee_model->getTransportFeeByStudentSession($student['student_session_id'], $student['route_pickup_point_id']);

        $vehroute_result         = $this->vehroute_model->getRouteVehiclesList();

        $data['vehroutelist']    = $vehroute_result;

        $class                   = $this->class_model->get();

        $setting_result          = $this->setting_model->get();



        $data["student_categorize"] = 'class';

        $data['classlist']          = $class;

        $category                   = $this->category_model->get();

        $data['categorylist']       = $category;

        $hostelList                 = $this->hostel_model->get();

        $data['hostelList']         = $hostelList;

        $houses                     = $this->student_model->gethouselist();

        $data['houses']             = $houses;

        $data["bloodgroup"]         = $this->blood_group;

        $siblings                   = $this->student_model->getMySiblings($student['parent_id'], $student['id']);

        $data['siblings']           = $siblings;

        $data['siblings_counts']    = count($siblings);

        $custom_fields              = $this->customfield_model->getByBelong('students');

        $data['sch_setting']        = $this->sch_setting_detail;
         
       


        //***fees discount***//

        $data['student_fees_discount']  = $this->feediscount_model->getStudentFeesDiscount($student['student_session_id']); //edit

        $feesdiscount_result            = $this->feediscount_model->get();

        $data['feediscountList']        = $feesdiscount_result;

        //***fees discount***//



        foreach ($custom_fields as $custom_fields_key => $custom_fields_value) {

            if ($custom_fields_value['validation']) {

                $custom_fields_id   = $custom_fields_value['id'];

                $custom_fields_name = $custom_fields_value['name'];

                $this->form_validation->set_rules("custom_fields[students][" . $custom_fields_id . "]", $custom_fields_name, 'trim|required');

            }

        }



        $this->form_validation->set_rules('firstname', $this->lang->line('first_name'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('dob', $this->lang->line('date_of_birth'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('gender', $this->lang->line('gender'), 'trim|required|xss_clean');



        // if ($this->sch_setting_detail->guardian_name) {

        //     $this->form_validation->set_rules('guardian_name', $this->lang->line('guardian_name'), 'trim|required|xss_clean');

        //     $this->form_validation->set_rules('guardian_is', $this->lang->line('guardian'), 'trim|required|xss_clean');

        // }



        // if ($this->sch_setting_detail->guardian_phone) {

        //     $this->form_validation->set_rules('guardian_phone', $this->lang->line('guardian_phone'), 'trim|required|xss_clean');

        // }



        // $this->form_validation->set_rules(

        //     'email',

        //     $this->lang->line('email'),

        //     array(

        //         'valid_email',

        //         array('check_student_email_exists', array($this->student_model, 'check_student_email_exists')),

        //     )

        // );



        // $this->form_validation->set_rules(

        //     'mobileno',

        //     $this->lang->line('mobile_no'),

        //     array(

        //         'xss_clean',

        //         array('check_student_mobile_exists', array($this->student_model, 'check_student_mobile_no_exists')),

        //     )

        // );



        if (!$this->sch_setting_detail->adm_auto_insert) {



            $this->form_validation->set_rules('admission_no', $this->lang->line('admission_no'), array('required', array('check_admission_no_exists', array($this->student_model, 'valid_student_admission_no'))));

        }



        $this->form_validation->set_rules('file', $this->lang->line('image'), 'callback_handle_upload[file]');



        $this->form_validation->set_rules('father_pic', $this->lang->line('image'), 'callback_handle_father_upload[father_pic]');

        $this->form_validation->set_rules('mother_pic', $this->lang->line('image'), 'callback_handle_mother_upload[mother_pic]');

        $this->form_validation->set_rules('guardian_pic', $this->lang->line('image'), 'callback_handle_guardian_upload[guardian_pic]');



        $transport_feemaster_id = $this->input->post('transport_feemaster_id');



        if (!empty($transport_feemaster_id)) {

            $this->form_validation->set_rules('vehroute_id', $this->lang->line('route_list'), 'trim|required|xss_clean');

            $this->form_validation->set_rules('route_pickup_point_id', $this->lang->line('pickup_point'), 'trim|required|xss_clean');

            $this->form_validation->set_rules('transport_feemaster_id[]', $this->lang->line('fees_month'), 'trim|required|xss_clean');

        }



        if ($this->form_validation->run() == false) {

            $this->load->view('layout/header', $data);

            $this->load->view('student/studentEdit', $data);

            $this->load->view('layout/footer', $data);

        } else {

            $prev_fees_group   = array();

            $fee_session_group = array();



            $custom_field_post = $this->input->post("custom_fields[students]");

            if (isset($custom_field_post)) {

                $custom_value_array = array();

                foreach ($custom_field_post as $key => $value) {

                    $check_field_type = $this->input->post("custom_fields[students][" . $key . "]");

                    $field_value      = is_array($check_field_type) ? implode(",", $check_field_type) : $check_field_type;

                    $array_custom     = array(

                        'belong_table_id' => $id,

                        'custom_field_id' => $key,

                        'field_value'     => $field_value,

                    );

                    $custom_value_array[] = $array_custom;

                }

                $this->customfield_model->updateRecord($custom_value_array, $id, 'students');

            }

            $student_id = $this->input->post('student_id');

            $student    = $this->student_model->get($student_id);



            $sibling_id            = $this->input->post('sibling_id');

            $siblings_counts       = $this->input->post('siblings_counts');

            $siblings              = $this->student_model->getMySiblings($student['parent_id'], $student_id);

            $total_siblings        = count($siblings);

            $class_id              = $this->input->post('class_id');

            $section_id            = $this->input->post('section_id');

            $hostel_room_id        = $this->input->post('hostel_room_id');

            $fees_discount         = $this->input->post('fees_discount');

            $route_pickup_point_id = $this->input->post('route_pickup_point_id');



            if (empty($route_pickup_point_id)) {

                $route_pickup_point_id = null;

            }



            if (empty($hostel_room_id)) {

                $hostel_room_id = 0;

            }

            $vehroute_id = $this->input->post('vehroute_id');

            if (empty($vehroute_id)) {

                $vehroute_id = null;

            }

            $data = array(

                'id'                => $id,

                'firstname'         => $this->input->post('firstname'),
                'firstnamem'         => $this->input->post('firstnamem'),
                 'lastname'         => $this->input->post('lastname'),
                  'lastnamem'         => $this->input->post('lastnamem'),
                  'father_namem'         => $this->input->post('father_namem'),
                 'mother_namem'         => $this->input->post('mother_namem'),
                 
                  'apaar_id'         => $this->input->post('apaar_id'),
                  'stu_udise_id'         => $this->input->post('stu_udise_id'),
                  'cast'         => $this->input->post('cast'),
                   'subcas' => $this->input->post('subcas'),
                    'place_of_birth'=> $this->input->post('place_of_birth'),
            
            'birth_taluka'  => $this->input->post('birth_taluka'),
            
             'birth_district'  => $this->input->post('birth_district'),
            
             'state'  => $this->input->post('state'),
             'dobword'  => $this->input->post('dobword'),
             'std_global_id'  => $this->input->post('std_global_id'),
             
             'admission_enquiry_no'  => $this->input->post('admission_enquiry_no'),
             
             'penno'  => $this->input->post('penno'),
             'nationality'  => $this->input->post('nationality'),
             'mother_tongue'  => $this->input->post('mother_tongue'),
             'other_language_spoken'  => $this->input->post('other_language_spoken'),
             'prev_school_dateofleaving'  => $this->input->post('prev_school_dateofleaving'),
             
        'prev_school_tcnumber' => $this->input->post('prev_school_tcnumber'),
             'fitness_cert'               => $this->input->post('fitness_cert'),
             'academic_preference' => $this->input->post('academic_preference'),
             'academic_conduct' => $this->input->post('academic_conduct'),
              'class_studing_since_when' => $this->input->post('class_studing_since_when'),
             'reason_of_leaving' => $this->input->post('reason_of_leaving'),
             'date_of_leaving' => $this->input->post('date_of_leaving'),
             'remarks' => $this->input->post('remarks'),
            'date_produced_last_school_leaving_certificate'  => $this->input->post('date_produced_last_school_leaving_certificate'),
            
            'father_edu_qualification' => $this->input->post('father_edu_qualification'),
            
            'mother_occupation' => $this->input->post('mother_occupation'),
             'prev_school_name' => $this->input->post('prev_school_name'),
              'prev_school_standard_covered' => $this->input->post('prev_school_standard_covered'),
               'prev_school_reasonofleaving' => $this->input->post('prev_school_reasonofleaving'),
               

            'mother_edu_qualification' => $this->input->post('mother_edu_qualification'),
             'num_of_brother' => $this->input->post('num_of_brother'),
              'elder_brother' => $this->input->post('elder_brother'),
                'younger_brother' => $this->input->post('younger_brother'),
                 'num_of_sister' => $this->input->post('num_of_sister'),
                'elder_sister' => $this->input->post('elder_sister'),
                 'younger_sister' => $this->input->post('younger_sister'),
                 'vaccinations' => $this->input->post('vaccinations'),
                'languages_studied' => $this->input->post('languages_studied'),
               'medium_of_instruction_in_last_school' => $this->input->post('medium_of_instruction_in_last_school'),
               'if_pupil_produced_last_school_leaving_certificate' => $this->input->post('if_pupil_produced_last_school_leaving_certificate'),
               
                
                'fillbyoffice_admittedto'  => $this->input->post('fillbyoffice_admittedto'),
                'fillbyoffice_onpaymentfees'  => $this->input->post('fillbyoffice_onpaymentfees'),
                'fillbyoffice_paymentfeesreceiptno'  => $this->input->post('fillbyoffice_paymentfeesreceiptno'),
                'fillbyoffice_anycomment'  => $this->input->post('fillbyoffice_anycomment'),
                'prev_school_scholarship'  => $this->input->post('prev_school_scholarship'),
                'parent_annual_income'  => $this->input->post('parent_annual_income'),
                
                 'number_of_dependent'  => $this->input->post('number_of_dependent'),
                  'if_pupil_living_with_parent'  => $this->input->post('if_pupil_living_with_parent'),
                
                
                
                'rte'               => $this->input->post('rte'),

                'state'             => $this->input->post('state'),

                'city'              => $this->input->post('city'),

                'pincode'           => $this->input->post('pincode'),

                'cast'              => $this->input->post('cast'),

                'previous_school'   => $this->input->post('previous_school'),

                'dob'               => $this->customlib->dateFormatToYYYYMMDD($this->input->post('dob')),

                'current_address'   => $this->input->post('current_address'),

                'permanent_address' => $this->input->post('permanent_address'),

                'adhar_no'          => $this->input->post('adhar_no'),

                'samagra_id'        => $this->input->post('samagra_id'),

                'bank_account_no'   => $this->input->post('bank_account_no'),

                'bank_name'         => $this->input->post('bank_name'),

                'ifsc_code'         => $this->input->post('ifsc_code'),

                'guardian_email'    => $this->input->post('guardian_email'),

                'gender'            => $this->input->post('gender'),

                'guardian_name'     => $this->input->post('guardian_name'),

                'guardian_relation' => $this->input->post('guardian_relation'),

                'guardian_phone'    => $this->input->post('guardian_phone'),

                'guardian_address'  => $this->input->post('guardian_address'),

                'hostel_room_id'    => $hostel_room_id,

                'note'              => $this->input->post('note'),

                'is_active'         => 'yes',

            );

            if ($this->sch_setting_detail->guardian_occupation) {

                $data['guardian_occupation'] = $this->input->post('guardian_occupation');

            }

            $house             = $this->input->post('house');

            $blood_group       = $this->input->post('blood_group');

            $measurement_date  = $this->input->post('measure_date');

            $roll_no           = $this->input->post('roll_no');

            $lastname          = $this->input->post('lastname');

            $middlename        = $this->input->post('middlename');

            $category_id       = $this->input->post('category_id');

            $religion          = $this->input->post('religion');

            $mobileno          = $this->input->post('mobileno');

            $email             = $this->input->post('email');

            $admission_date    = $this->input->post('admission_date');

            $height            = $this->input->post('height');

            $weight            = $this->input->post('weight');

            $father_name       = $this->input->post('father_name');

            $father_phone      = $this->input->post('father_phone');

            $father_occupation = $this->input->post('father_occupation');

            $mother_name       = $this->input->post('mother_name');

            $mother_phone      = $this->input->post('mother_phone');

            $mother_occupation = $this->input->post('mother_occupation');



            if ($this->sch_setting_detail->guardian_name) {

                $data['guardian_is'] = $this->input->post('guardian_is');

            }



            if (isset($measurement_date)) {

                $data['measurement_date'] = $this->customlib->dateFormatToYYYYMMDD($this->input->post('measure_date'));

            }



            if (isset($house)) {

                $data['school_house_id'] = $this->input->post('house');

            }



            if (isset($blood_group)) {

                $data['blood_group'] = $this->input->post('blood_group');

            }



            if (isset($roll_no)) {

                $data['roll_no'] = $this->input->post('roll_no');

            }



            if (isset($lastname)) {

                $data['lastname'] = $this->input->post('lastname');

            }



            if (isset($middlename)) {

                $data['middlename'] = $this->input->post('middlename');

            }



            if (isset($category_id)) {

                $data['category_id'] = $this->input->post('category_id');

            }



            if (isset($religion)) {

                $data['religion'] = $this->input->post('religion');

            }



            if (isset($mobileno)) {

                $data['mobileno'] = $this->input->post('mobileno');

            }



            if (isset($email)) {

                $data['email'] = $this->input->post('email');

            }



            if (isset($admission_date)) {

                $data['admission_date'] = $this->customlib->dateFormatToYYYYMMDD($this->input->post('admission_date'));

            }



            if (isset($height)) {

                $data['height'] = $this->input->post('height');

            }



            if (isset($weight)) {

                $data['weight'] = $this->input->post('weight');

            }



            if (isset($father_name)) {

                $data['father_name'] = $this->input->post('father_name');

            }



            if (isset($father_phone)) {

                $data['father_phone'] = $this->input->post('father_phone');

            }



            if (isset($father_occupation)) {

                $data['father_occupation'] = $this->input->post('father_occupation');

            }



            if (isset($mother_name)) {

                $data['mother_name'] = $this->input->post('mother_name');

            }



            if (isset($mother_phone)) {

                $data['mother_phone'] = $this->input->post('mother_phone');

            }



            if (isset($mother_occupation)) {

                $data['mother_occupation'] = $this->input->post('mother_occupation');

            }



            if (empty($_FILES["file"])) {

                if ($this->input->post('gender') == 'Female') {

                    $data['image'] = 'uploads/student_images/default_female.jpg';

                } else {

                    $data['image'] = 'uploads/student_images/default_male.jpg';

                }

            }



            if (isset($_FILES["file"]) && !empty($_FILES['file']['name'])) {
    $uploadPath = "./uploads/student_images/";
    $fileName   = time() . '_' . basename($_FILES["file"]["name"]);
    $targetFile = $uploadPath . $fileName;

    // Ensure the directory exists
    if (!is_dir($uploadPath)) {
        mkdir($uploadPath, 0755, true);
    }

    if (move_uploaded_file($_FILES["file"]["tmp_name"], $targetFile)) {
        $data['image'] = "uploads/student_images/" . $fileName;
    } else {
        // Handle upload failure
        $data['image'] = null; // or handle error message
    }
}




           if (isset($_FILES["father_pic"]) && !empty($_FILES['father_pic']['name'])) {
    $uploadPath = "./uploads/student_images/";
    $fileName   = time() . '_' . basename($_FILES["father_pic"]["name"]);
    $targetFile = $uploadPath . $fileName;

    // Ensure the directory exists
    if (!is_dir($uploadPath)) {
        mkdir($uploadPath, 0755, true);
    }

    if (move_uploaded_file($_FILES["father_pic"]["tmp_name"], $targetFile)) {
        $data['father_pic'] = "uploads/student_images/" . $fileName;
    } else {
        $data['father_pic'] = null; // or set error handling
    }
}




            if (isset($_FILES["mother_pic"]) && !empty($_FILES['mother_pic']['name'])) {
    $uploadPath = "./uploads/student_images/";
    $fileName   = time() . '_' . basename($_FILES["mother_pic"]["name"]);
    $targetFile = $uploadPath . $fileName;

    // Ensure the directory exists
    if (!is_dir($uploadPath)) {
        mkdir($uploadPath, 0755, true);
    }

    if (move_uploaded_file($_FILES["mother_pic"]["tmp_name"], $targetFile)) {
        $data['mother_pic'] = "uploads/student_images/" . $fileName;
    } else {
        $data['mother_pic'] = null; // handle upload failure if needed
    }
}




            if (isset($_FILES["guardian_pic"]) && !empty($_FILES['guardian_pic']['name'])) {
    $uploadPath = "./uploads/student_images/";
    $fileName   = time() . '_' . basename($_FILES["guardian_pic"]["name"]);
    $targetFile = $uploadPath . $fileName;

    // Ensure the directory exists
    if (!is_dir($uploadPath)) {
        mkdir($uploadPath, 0755, true);
    }

    if (move_uploaded_file($_FILES["guardian_pic"]["tmp_name"], $targetFile)) {
        $data['guardian_pic'] = "uploads/student_images/" . $fileName;
    } else {
        $data['guardian_pic'] = null; // handle failure if needed
    }
}




            if (!$this->sch_setting_detail->adm_auto_insert) {

                $data['admission_no'] = $this->input->post('admission_no');

            }



             $data['created_by'] = $this->session->userdata['admin']['id'];



            $this->student_model->add($data);

            $data_new = array(

                'student_id'            => $id,

                'class_id'              => $class_id,

                'section_id'            => $section_id,

                'session_id'            => $session,

                'fees_discount'         => $fees_discount,

                'route_pickup_point_id' => $route_pickup_point_id,

                'vehroute_id'           => $vehroute_id,

            );



            $insert_id = $this->student_model->add_student_session($data_new);



            if ($this->input->post('prev_fees_group')) {

                $prev_fees_group = $this->input->post('prev_fees_group');

            }



            if ($this->input->post('fee_session_group_id')) {

                $fee_session_group = $this->input->post('fee_session_group_id');

            }



            $delete_fee_session_group = array_diff($prev_fees_group, $fee_session_group);

            $add_fee_session_group    = array_diff($fee_session_group, $prev_fees_group);



            $student_session_id     = $this->input->post('student_session_id');

            $transport_feemaster_id = $this->input->post('transport_feemaster_id');

            $this->studentfeemaster_model->assign_bulk_fees($add_fee_session_group, $student_session_id, $delete_fee_session_group);



            if (!empty($transport_feemaster_id)) {

                $trns_data_insert = array();

                foreach ($transport_feemaster_id as $transport_feemaster_key => $transport_feemaster_value) {

                    $trns_data_insert[] = array(

                        'student_session_id'     => $student_session_id,

                        'route_pickup_point_id'  => $route_pickup_point_id,

                        'transport_feemaster_id' => $transport_feemaster_value,



                    );

                }



                $student_session_is = $this->studenttransportfee_model->update($trns_data_insert, $student_session_id);

            } else {

                $student_session_is = $this->studenttransportfee_model->update([], $student_session_id);

            }



            if (isset($siblings_counts) && ($total_siblings == $siblings_counts)) {

                //if there is no change in sibling

            } else if (!isset($siblings_counts) && $sibling_id == 0 && $total_siblings > 0) {

                // add for new parent

                $parent_password = $this->role->get_random_password($chars_min = 6, $chars_max = 6, $use_upper_case = false, $include_numbers = true, $include_special_chars = false);



                $data_parent_login = array(

                    'username' => $this->parent_login_prefix . $student_id . "_1",

                    'password' => $parent_password,

                    'user_id'  => "",

                    'role'     => 'parent',

                );



                $update_student = array(

                    'id'        => $student_id,

                    'parent_id' => 0,

                );

                $ins_id = $this->user_model->addNewParent($data_parent_login, $update_student);

            } else if ($sibling_id != 0) {

                //join to student with new parent

                $student_sibling = $this->student_model->get($sibling_id);

                $update_student  = array(

                    'id'        => $student_id,

                    'parent_id' => $student_sibling['parent_id'],

                );

                $student_sibling = $this->student_model->add($update_student);

            } else {

            }



            //delete feed discount//

            $this->feediscount_model->delete_assigned_discount($student_session_id);

            //delete feed discount//



            //*** assign fees discount ***//

            $discount_id = $this->input->post('discount_id[]');

            if (!empty($discount_id)) {

                foreach ($discount_id as $key => $value) {

                    $insert_array = array(

                        'student_session_id' => $student_session_id,

                        'fees_discount_id'   => $value,

                    );



                    $this->feediscount_model->allotdiscount($insert_array);

                }

            }

            //*** assign fees discount ***//  



            //generate student id card

            $student_details  = $this->student_model->get($id);

            // Only generate QR code if not exists
if (empty($student_details['student_qr'])) {
    $data = $student_details['admission_no'];
    $hex_data  = bin2hex($data);
    $save_name = $hex_data . '.png';
    $qr_dir = 'uploads/student_id_card/qrcode/';

    if (!file_exists(FCPATH . $qr_dir)) {
        mkdir(FCPATH . $qr_dir, 0775, true);
    }

    $this->load->library('ciqrcode');
    $config['cacheable'] = true;
    $config['imagedir']  = $qr_dir;
    $config['quality']   = true;
    $config['size']      = '1024';
    $config['black']     = [255, 255, 255];
    $config['white']     = [255, 255, 255];
    $this->ciqrcode->initialize($config);

    $params['data']     = $data;
    $params['level']    = 'L';
    $params['size']     = 10;
    $params['savename'] = FCPATH . $qr_dir . $save_name;

    if ($this->ciqrcode->generate($params)) {
        $this->db->where('id', $id);
        $this->db->update('students', ['student_qr' => $qr_dir . $save_name]);
    }
}

// Only generate Barcode if not exists
if (empty($student_details['student_barcode'])) {
    $code = $student_details['admission_no'];
    $barcode_dir = 'uploads/student_id_card/barcodes/';
    $file_path = FCPATH . $barcode_dir . $code . '.png';

    if (!file_exists(FCPATH . $barcode_dir)) {
        mkdir(FCPATH . $barcode_dir, 0777, true);
    }

    $this->load->library('Zend');
    $this->zend->load('Zend/Barcode');

    $barcodeOptions  = ['text' => $code];
    $rendererOptions = [];

    $imageResource = Zend_Barcode::factory('code128', 'image', $barcodeOptions, $rendererOptions)->draw();

    if ($imageResource) {
        imagepng($imageResource, $file_path);
        imagedestroy($imageResource);

        $this->db->where('id', $id);
        $this->db->update('students', ['student_barcode' => $barcode_dir . $code . '.png']);
    }
}



            $this->session->set_flashdata('msg', '<div student="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');

            redirect('student/search');

        }

    }



    public function bulkdelete()

    {

        $this->session->set_userdata('top_menu', 'Student Information');

        $this->session->set_userdata('sub_menu', 'bulkdelete');

        $class                   = $this->class_model->get();

        $data['classlist']       = $class;

        $data['adm_auto_insert'] = $this->sch_setting_detail->adm_auto_insert;

        $data['sch_setting']     = $this->sch_setting_detail;

        $data['fields']          = $this->customfield_model->get_custom_fields('students', 1);

        if ($this->input->server('REQUEST_METHOD') == 'POST') {

            $class   = $this->input->post('class_id');

            $section = $this->input->post('section_id');

            $search  = $this->input->post('search');



            $data['searchby']    = "filter";

            $data['class_id']    = $this->input->post('class_id');

            $data['section_id']  = $this->input->post('section_id');

            $data['search_text'] = $this->input->post('search_text');

            $resultlist          = $this->student_model->searchByClassSection($class, $section);

            $data['resultlist']  = $resultlist;

        }

        $this->load->view('layout/header', $data);

        $this->load->view('student/bulkdelete', $data);

        $this->load->view('layout/footer', $data);

    }



    public function search()

    {

        if (!$this->rbac->hasPrivilege('student', 'can_view')) {

            access_denied();

        }
        
        



        $this->session->set_userdata('top_menu', 'Student Information');

        $this->session->set_userdata('sub_menu', 'student/search');

        $data['title']           = 'Student Search';

        $data['adm_auto_insert'] = $this->sch_setting_detail->adm_auto_insert;

        $data['sch_setting']     = $this->sch_setting_detail;

        $data['fields']          = $this->customfield_model->get_custom_fields('students', 1);

        $class                   = $this->class_model->get();

        $data['classlist']       = $class;



        $this->load->view('layout/header', $data);

        $this->load->view('student/studentSearch', $data);

        $this->load->view('layout/footer', $data);

    }



    public function ajaxsearch()

    {

        $search_type = $this->input->post('search_type');

        if ($search_type == "search_filter") {

            $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');

        }



        if ($this->form_validation->run() == false && $search_type == "search_filter") {

            $error = array();

            if ($search_type == "search_filter") {

                $error['class_id'] = form_error('class_id');

            }



            $array = array('status' => 0, 'error' => $error);

            echo json_encode($array);

        } else {

            $search_type = $this->input->post('search_type');

            $search_text = $this->input->post('search_text');

            $class_id    = $this->input->post('class_id');

            $section_id  = $this->input->post('section_id');

            $params      = array('class_id' => $class_id, 'section_id' => $section_id, 'search_type' => $search_type, 'search_text' => $search_text);

            $array       = array('status' => 1, 'error' => '', 'params' => $params);

            echo json_encode($array);

        }

    }



    public function getByClassAndSection()

    {

        $class      = $this->input->get('class_id');

        $section    = $this->input->get('section_id');

        $resultlist = $this->student_model->searchByClassSection($class, $section);

        foreach ($resultlist as $key => $value) {

            $resultlist[$key]['full_name'] = $this->customlib->getFullName($value['firstname'], $value['middlename'], $value['lastname'], $this->sch_setting_detail->middlename, $this->sch_setting_detail->lastname);

            # code...

        }

        echo json_encode($resultlist);

    }



    public function getByClassAndSectionExcludeMe()

    {

        $class      = $this->input->get('class_id');

        $section    = $this->input->get('section_id');

        $student_id = $this->input->get('current_student_id');

        $resultlist = $this->student_model->searchByClassSectionWithoutCurrent($class, $section, $student_id);



        foreach ($resultlist as $key => $value) {

            $resultlist[$key]['full_name'] = $this->customlib->getFullName($value['firstname'], $value['middlename'], $value['lastname'], $this->sch_setting_detail->middlename, $this->sch_setting_detail->lastname);

            # code...

        }



        echo json_encode($resultlist);

    }



    public function getStudentRecordByID()

    {

        $student_id = $this->input->get('student_id');

        $resultlist = $this->student_model->get($student_id);



        foreach ($resultlist as $key => $value) {



            $resultlist['full_name'] = $this->customlib->getFullName($resultlist['firstname'], $resultlist['middlename'], $resultlist['lastname'], $this->sch_setting_detail->middlename, $this->sch_setting_detail->lastname);

        }



        echo json_encode($resultlist);

    }



    public function uploadimage($id)

    {

        $data['title'] = 'Add Image';

        $data['id']    = $id;

        $this->load->view('layout/header', $data);

        $this->load->view('student/uploadimage', $data);

        $this->load->view('layout/footer', $data);

    }



    public function doupload($id)

    {

        $config = array(

            'upload_path'   => "./uploads/student_images/",

            'allowed_types' => "gif|jpg|png|jpeg|df",

            'overwrite'     => true,

        );

        $config['file_name'] = $id . ".jpg";

        $this->upload->initialize($config);

        $this->load->library('upload', $config);

        if ($this->upload->do_upload()) {

            $data        = array('upload_data' => $this->upload->data());

            $upload_data = $this->upload->data();

            $data_record = array('id' => $id, 'image' => $upload_data['file_name']);

            $this->setting_model->add($data_record);

            $this->load->view('upload_success', $data);

        } else {

            $error = array('error' => $this->upload->display_errors());



            $this->load->view('file_view', $error);

        }

    }



    public function getlogindetail()

    {

        if (!$this->rbac->hasPrivilege('student_login_credential_report', 'can_view')) {

            access_denied();

        }

        $student_id   = $this->input->post('student_id');

        $examSchedule = $this->user_model->getStudentLoginDetails($student_id);



        foreach ($examSchedule as $key => $value) {

            $examSchedule[$key]->role = $this->lang->line(strtolower($value->role));

        }

        echo json_encode($examSchedule);

    }



    public function getUserLoginDetails()

    {

        $studentid = $this->input->post("student_id");

        $result    = $this->user_model->getUserLoginDetails($studentid);

        echo json_encode($result);

    }



    // public function disablestudentslist()

    // {

    //     if (!$this->rbac->hasPrivilege('disable_student', 'can_view')) {

    //         access_denied();

    //     }



    //     $this->session->set_userdata('top_menu', 'Student Information');

    //     $this->session->set_userdata('sub_menu', 'student/disablestudentslist');

    //     $class                   = $this->class_model->get();

    //     $data['classlist']       = $class;

    //     $data["resultlist"]      = array();

    //     $data['adm_auto_insert'] = $this->sch_setting_detail->adm_auto_insert;

    //     $data['sch_setting']     = $this->sch_setting_detail;

    //     $userdata                = $this->customlib->getUserData();

    //     $carray                  = array();

    //     $reason_list             = array();

    //     if (!empty($data["classlist"])) {

    //         foreach ($data["classlist"] as $ckey => $cvalue) {



    //             $carray[] = $cvalue["id"];

    //         }

    //     }



    //     $button = $this->input->post('search');

    //     if ($this->input->server('REQUEST_METHOD') == "GET") {

    //     } else {

    //         $class       = $this->input->post('class_id');

    //         $section     = $this->input->post('section_id');

    //         $search      = $this->input->post('search');

    //         $search_text = $this->input->post('search_text');

    //         if (isset($search)) {

    //             if ($search == 'search_filter') {

    //                 $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');

    //                 if ($this->form_validation->run() == false) {

    //                 } else {

    //                     $data['searchby']   = "filter";

    //                     $data['class_id']   = $this->input->post('class_id');

    //                     $data['section_id'] = $this->input->post('section_id');



    //                     $data['search_text'] = $this->input->post('search_text');

    //                     $resultlist          = $this->student_model->disablestudentByClassSection($class, $section);

    //                     $data['resultlist']  = $resultlist;

    //                 }

    //             } else if ($search == 'search_full') {

    //                 $data['searchby'] = "text";



    //                 $data['search_text'] = trim($this->input->post('search_text'));

    //                 $resultlist          = $this->student_model->disablestudentFullText($search_text);

    //                 $data['resultlist']  = $resultlist;

    //             }

    //         }

    //     }



    //     $disable_reason = $this->disable_reason_model->get();



    //     foreach ($disable_reason as $key => $value) {

    //         $id               = $value['id'];

    //         $reason_list[$id] = $value;

    //     }



    //     $data['disable_reason'] = $reason_list;



    //     $this->load->view("layout/header", $data);

    //     $this->load->view("student/disablestudents", $data);

    //     $this->load->view("layout/footer", $data);

    // }

 public function disablestudentslist()

    {

        if (!$this->rbac->hasPrivilege('disable_student', 'can_view')) {

            access_denied();

        }



        $this->session->set_userdata('top_menu', 'Student Information');

        $this->session->set_userdata('sub_menu', 'student/disable_student');

        $data['title']           = 'Student Search';

        $data['adm_auto_insert'] = $this->sch_setting_detail->adm_auto_insert;

        $data['sch_setting']     = $this->sch_setting_detail;

        $data['fields']          = $this->customfield_model->get_custom_fields('students', 1);

        $class                   = $this->class_model->get();

        $data['classlist']       = $class;



        $this->load->view('layout/header', $data);

        $this->load->view('student/disable_studentlist', $data);

        $this->load->view('layout/footer', $data);

    }

    public function disablestudent($id)

    {

        $data = array('is_active' => "no", 'disable_at' => date("Y-m-d"));

        $this->student_model->disableStudent($id, $data);

        redirect("student/view/" . $id);

    }



    public function enablestudent($id)

    {

        $data = array('is_active' => "yes");

        $this->student_model->disableStudent($id, $data);

        echo "0";

    }



    public function savemulticlass()

    {

        $student_id       = '';

        $message          = "";

        $duplicate_record = 0;

        $this->form_validation->set_error_delimiters('', '');

        $this->form_validation->set_rules('student_id', $this->lang->line('student_id'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('row_count[]', 'row_count[]', 'trim|required|xss_clean');



        if ($this->input->server('REQUEST_METHOD') == 'POST') {

            $total_rows = $this->input->post('row_count[]');

            if (!empty($total_rows)) {



                foreach ($total_rows as $key_rowcount => $row_count) {

                    $this->form_validation->set_rules('class_id_' . $row_count, $this->lang->line('class'), 'trim|required|xss_clean');

                    $this->form_validation->set_rules('section_id_' . $row_count, $this->lang->line('section'), 'trim|required|xss_clean');

                }

            }

        }



        if ($this->form_validation->run() == false) {



            $msg = array(

                'student_id'  => form_error('student_id'),

                'row_count[]' => form_error('row_count[]'),

            );



            if ($this->input->server('REQUEST_METHOD') == 'POST') {

                if (!empty($total_rows)) {



                    $total_rows = $this->input->post('row_count[]');

                    foreach ($total_rows as $key_rowcount => $row_count) {



                        $msg['class_id_' . $row_count]   = form_error('class_id_' . $row_count);

                        $msg['section_id_' . $row_count] = form_error('section_id_' . $row_count);

                    }

                }

            }

            if (!empty($msg)) {

                $message = $this->lang->line('something_went_wrong');

            }



            $array = array('status' => '0', 'error' => $msg, 'message' => $message);

        } else {



            $rowcount            = $this->input->post('row_count[]');

            $class_section_array = array();

            $duplicate_array     = array();

            foreach ($rowcount as $key_rowcount => $value_rowcount) {



                $array = array(

                    'class_id'   => $this->input->post('class_id_' . $value_rowcount),

                    'session_id' => $this->setting_model->getCurrentSession(),

                    'student_id' => $this->input->post('student_id'),

                    'section_id' => $this->input->post('section_id_' . $value_rowcount),

                );



                $class_section_array[] = $array;

                $duplicate_array[]     = $this->input->post('class_id_' . $value_rowcount) . "-" . $this->input->post('section_id_' . $value_rowcount);

            }



            foreach (array_count_values($duplicate_array) as $val => $c) {



                if ($c > 1) {

                    $duplicate_record = 1;

                    break;

                }

            }

            if ($duplicate_record) {

                $array = array('status' => 0, 'error' => '', 'message' => $this->lang->line('duplicate_entry'));

            } else {

                $this->studentsession_model->add($class_section_array, $this->input->post('student_id'));

                $array = array('status' => 1, 'error' => '', 'message' => $this->lang->line('success_message'));

            }

        }

        echo json_encode($array);

    }



    // public function disable_reason()

    // {

    //     $this->form_validation->set_rules('reason', $this->lang->line('reason'), 'trim|required|xss_clean');

    //     $this->form_validation->set_rules('disable_date', $this->lang->line('date'), 'trim|required|xss_clean');



    //     if ($this->form_validation->run() == false) {



    //         $msg = array(

    //             'reason'       => form_error('reason'),

    //             'disable_date' => form_error('disable_date'),

    //         );



    //         $array = array('status' => 'fail', 'error' => $msg, 'message' => '');

    //     } else {



    //         $data = array(

    //             'dis_reason' => $this->input->post('reason'),

    //             'dis_note'   => $this->input->post('note'),

    //             'id'         => $this->input->post('student_id'),

    //             'disable_at' => $this->customlib->dateFormatToYYYYMMDD($this->input->post('disable_date')),

    //             'is_active'  => 'no',

    //         );



    //         $this->student_model->add($data);



    //         $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('success_message'));

    //     }

    //     echo json_encode($array);

    // }


// public function disable_reason()
// {
//     $this->form_validation->set_rules('reason', $this->lang->line('reason'), 'trim|required|xss_clean');
//     $this->form_validation->set_rules('disable_date', $this->lang->line('date'), 'trim|required|xss_clean');

//     if ($this->form_validation->run() == false) {
//         $msg = array(
//             'reason'       => form_error('reason'),
//             'disable_date' => form_error('disable_date'),
//         );

//         $array = array('status' => 'fail', 'error' => $msg, 'message' => '');
//     } else {
//         $student_id = $this->input->post('student_id');

//         // Get current image file names from DB
//         $student = $this->student_model->get($student_id);

//         $image_fields = ['image', 'father_pic', 'mother_pic', 'guardian_pic'];
//         $upload_path = FCPATH . 'uploads/student_images/';

//         foreach ($image_fields as $field) {
//             if (!empty($student[$field])) {
//                 $filepath = $upload_path . $student[$field];
//                 if (file_exists($filepath)) {
//                     @unlink($filepath); // Suppress errors and delete file
//                 }
//             }
//         }

//         // Update student record
//         $data = array(
//             'dis_reason' => $this->input->post('reason'),
//             'dis_note'   => $this->input->post('note'),
//             'id'         => $student_id,
//             'disable_at' => $this->customlib->dateFormatToYYYYMMDD($this->input->post('disable_date')),
//             'is_active'  => 'no',
//         );

//         $this->student_model->add($data);

//         $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('success_message'));
//     }

//     echo json_encode($array);
// }


public function disable_reason()
{
    $this->form_validation->set_rules('reason', $this->lang->line('reason'), 'trim|required|xss_clean');
    $this->form_validation->set_rules('disable_date', $this->lang->line('date'), 'trim|required|xss_clean');

    if ($this->form_validation->run() == false) {
        $msg = array(
            'reason'       => form_error('reason'),
            'disable_date' => form_error('disable_date'),
        );

        $array = array('status' => 'fail', 'error' => $msg, 'message' => '');
    } else {
        $student_id = $this->input->post('student_id');

        // Get student record with image paths
        $student = $this->student_model->get($student_id);

        $image_fields = ['image', 'father_pic', 'mother_pic', 'guardian_pic'];

        foreach ($image_fields as $field) {
            if (!empty($student[$field])) {
                $relative_path = $student[$field]; // e.g., uploads/student_images/1.png
                $full_path = FCPATH . $relative_path; // Convert to full path

                if (file_exists($full_path)) {
                    @unlink($full_path); // Delete the image
                }
            }
        }

        // Update student record with disable info
        $data = array(
            'dis_reason' => $this->input->post('reason'),
            'dis_note'   => $this->input->post('note'),
            'id'         => $student_id,
            'disable_at' => $this->customlib->dateFormatToYYYYMMDD($this->input->post('disable_date')),
            'is_active'  => 'no',
        );

        $this->student_model->add($data);

        $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('success_message'));
    }

    echo json_encode($array);
}

    public function ajax_delete()

    {

        $this->form_validation->set_error_delimiters('', '');

        $this->form_validation->set_rules('student[]', $this->lang->line('student'), 'trim|required|xss_clean');



        if ($this->form_validation->run() == false) {



            $msg = array(

                'student[]' => form_error('student[]'),

            );

            $array = array('status' => 0, 'error' => $msg, 'message' => '');

        } else {

            $students = $this->input->post('student');



            foreach ($students as $student_key => $student_value) {

            }



            $this->student_model->bulkdelete($students);



            $array = array('status' => 1, 'error' => '', 'message' => $this->lang->line('delete_message'));

        }

        echo json_encode($array);

    }



    public function profilesetting()

    {

        if (!$this->rbac->hasPrivilege('student_profile_update', 'can_view')) {

            access_denied();

        }

        $this->session->set_userdata('top_menu', 'System Settings');

        $this->session->set_userdata('sub_menu', 'System Settings/profilesetting');

        $data                    = array();

        $data['result']          = $this->setting_model->getSetting();

        $data['fields']          = get_student_editable_fields();

        $data['inserted_fields'] = $this->student_edit_field_model->get();

        $data['result']          = $this->setting_model->getSetting();

        $this->form_validation->set_rules('student_profile_edit', $this->lang->line('student_profile_update'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == true) {

            $data_record = array(

                'id'                   => $this->input->post('sch_id'),

                'student_profile_edit' => $this->input->post('student_profile_edit'),

            );

            $this->setting_model->add($data_record);

            $this->session->set_flashdata('msg', '<div class="alert alert-left">' . $this->lang->line('update_message') . '</div>');

            redirect('student/profilesetting');

        }



        $data['sch_setting_detail'] = $this->sch_setting_detail;

        $data['custom_fields']      = $this->onlinestudent_model->getcustomfields();



        //setting enable disable fields//

        $data["studentpermissionList"]   =   $this->student_model->get_module_status();

        //setting enable disable fields//



        $this->load->view("layout/header");

        $this->load->view("student/profilesetting", $data);

        $this->load->view("layout/footer");

    }

    

    //***student dashboard setting***//

    public function save_student_dashboard_settings()

    {

        $this->form_validation->set_rules('name', $this->lang->line('student'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('status', $this->lang->line('status'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('status_type', $this->lang->line('status_type'), 'trim|required|xss_clean');



        if ($this->form_validation->run() == false) {

            $msg = array(

                'status'        => form_error('status'),

                'name'          => form_error('name'),

                'status_type'   => form_error('status_type'),

            );

            $array = array('status' => '0', 'error' => $msg, 'msg' => $this->lang->line('something_went_wrong'));

        } else {

            $status_type = $this->input->post('status_type');



            if ($status_type == 'student') {

                $insert = array(

                    'name'          => $this->input->post('name'),

                    'is_student'    => $this->input->post('status'),

                );

            } else if ($status_type == 'parent') {

                $insert = array(

                    'name'          => $this->input->post('name'),

                    'is_parent'     => $this->input->post('status'),

                );

            }



            $this->student_model->save_student_dashboard_settings($insert);

            $array = array('status' => '1', 'error' => '', 'msg' => $this->lang->line('success_message'));

        }

        echo json_encode($array);

    }



    public function changeprofilesetting()

    {

        $this->form_validation->set_rules('name', $this->lang->line('student'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('status', $this->lang->line('status'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {



            $msg = array(

                'status' => form_error('status'),

                'name'   => form_error('name'),

            );



            $array = array('status' => '0', 'error' => $msg, 'msg' => $this->lang->line('something_went_wrong'));

        } else {

            $insert = array(

                'name'   => $this->input->post('name'),

                'status' => $this->input->post('status'),

            );

            $this->student_edit_field_model->add($insert);

            $array = array('status' => '1', 'error' => '', 'msg' => $this->lang->line('success_message'));

        }



        echo json_encode($array);

    }



    /**

     * This function is used to view bulk mail page

     */

    public function bulkmail()

    {

        if (!$this->rbac->hasPrivilege('login_credentials_send', 'can_view')) {

            access_denied();

        }



        $this->session->set_userdata('top_menu', 'Communicate');

        $this->session->set_userdata('sub_menu', 'bulk_mail');

        $class                    = $this->class_model->get();

        $data['classlist']        = $class;

        $data['sch_setting']      = $this->sch_setting_detail;

        $data['bulkmailto']       = $this->customlib->bulkmailto();

        $data['notificationtype'] = $this->customlib->bulkmailnotificationtype();

        $data['fields']           = $this->customfield_model->get_custom_fields('students', 1);

        if ($this->input->server('REQUEST_METHOD') == "GET") {

            $this->load->view('layout/header', $data);

            $this->load->view('student/bulkmail', $data);

            $this->load->view('layout/footer', $data);

        } else {

            $class   = $this->input->post('class_id');

            $section = $this->input->post('section_id');



            $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');

            if ($this->form_validation->run() == false) {

            } else {

                $data['class_id']   = $this->input->post('class_id');

                $data['section_id'] = $this->input->post('section_id');

                $resultlist         = $this->student_model->searchByClassSection($class, $section);

                $data['resultlist'] = $resultlist;

            }



            $this->load->view('layout/header', $data);

            $this->load->view('student/bulkmail', $data);

            $this->load->view('layout/footer', $data);

        }

    }



    /**

     * This function is used to send bulk mail to student and Parent

     */

    public function sendbulkmail()

    {

        $this->form_validation->set_rules('student[]', $this->lang->line('student'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('message_to', $this->lang->line('message_to'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('notification_type', $this->lang->line('notification_type'), 'trim|required|xss_clean');



        if ($this->form_validation->run() == false) {

            $msg = array(

                'student[]'         => form_error('student[]'),

                'message_to'        => form_error('message_to'),

                'notification_type' => form_error('notification_type'),

            );

            $array = array('status' => 0, 'error' => $msg, 'message' => '');

        } else {

            $students          = $this->input->post('student');

            $message_to        = $this->input->post('message_to');

            $notification_type = $this->input->post('notification_type');



            foreach ($students as $students_value) {



                $student_detail = $this->user_model->student_information($students_value);



                if (($message_to == 1 && $notification_type == 1) || ($message_to == 1 && $notification_type == 3) || ($message_to == 3 && $notification_type == 3)) {



                    $sender_details = array('student_id' => $students_value, 'contact_no' => $student_detail[0]->mobileno, 'email' => $student_detail[0]->email, 'student_session_id' => $student_detail[0]->student_session_id);



                    $this->mailsmsconf->bulkmailsms('student_admission', $sender_details);

                }



                if (($message_to == 1 && $notification_type == 2) || ($message_to == 1 && $notification_type == 3) || ($message_to == 3 && $notification_type == 3) || ($message_to == 3 && $notification_type == 2)) {



                    $student_login_detail = array('display_name' => $student_detail[0]->firstname . ' ' . $student_detail[0]->lastname, 'id' => $students_value, 'credential_for' => 'student', 'username' => $student_detail[0]->username, 'password' => $student_detail[0]->password, 'contact_no' => $student_detail[0]->mobileno, 'email' => $student_detail[0]->email, 'student_session_id' => $student_detail[0]->student_session_id, 'admission_no' => $student_detail[0]->admission_no);



                    $this->mailsmsconf->bulkmailsms('student_login_credential', $student_login_detail);

                }



                if (($message_to == 2 && $notification_type == 1) || ($message_to == 2 && $notification_type == 3) || ($message_to == 3 && $notification_type == 3) || ($message_to == 3 && $notification_type == 1)) {



                    $sender_details = array('student_id' => $students_value, 'contact_no' => $student_detail[0]->guardian_phone, 'email' => $student_detail[0]->guardian_email, 'student_session_id' => $student_detail[0]->student_session_id);



                    $this->mailsmsconf->bulkmailsms('student_admission', $sender_details);

                }



                if (($message_to == 2 && $notification_type == 2) || ($message_to == 2 && $notification_type == 3) || ($message_to == 3 && $notification_type == 3) || ($message_to == 3 && $notification_type == 2)) {



                    $parent_detail = $this->user_model->read_single_child($student_detail[0]->parent_id);



                    $parent_login_detail = array('display_name' => $student_detail[0]->firstname . ' ' . $student_detail[0]->lastname, 'id' => $students_value, 'credential_for' => 'parent', 'username' => $parent_detail->username, 'password' => $parent_detail->password, 'contact_no' => $student_detail[0]->guardian_phone, 'email' => $student_detail[0]->guardian_email, 'student_session_id' => $student_detail[0]->student_session_id, 'admission_no' => $student_detail[0]->admission_no);



                    $this->mailsmsconf->bulkmailsms('student_login_credential', $parent_login_detail);

                }

            }



            $array = array('status' => 1, 'error' => '', 'message' => $this->lang->line('message_sent_successfully'));

        }

        echo json_encode($array);

    }



    public function dtstudentlist()
    {

        $currency_symbol = $this->customlib->getSchoolCurrencyFormat();

        $class           = $this->input->post('class_id');

        $section         = $this->input->post('section_id');

        $search_text = trim($this->input->post('search_text'));

        $search_type     = $this->input->post('srch_type');

        $classlist       = $this->class_model->get();

        $classlist       = $classlist;

        $carray          = array();

        if (!empty($classlist)) {

            foreach ($classlist as $ckey => $cvalue) {

                $carray[] = $cvalue["id"];

            }

        }



        $sch_setting = $this->sch_setting_detail;



        if ($search_type == "search_filter") {



            $resultlist = $this->student_model->searchdtByClassSection($class, $section);

        } elseif ($search_type == "search_full") {



            $resultlist = $this->student_model->searchFullText($search_text, $carray);

        }



        $students = array();

        $students = json_decode($resultlist);



        $dt_data = array();

        $fields  = $this->customfield_model->get_custom_fields('students', 1);



        if (!empty($students->data)) {

            foreach ($students->data as $student_key => $student) {
                
                
                $pre_student_due_fee_system = array();
                $setting_result = $this->setting_model->get();
                $current_session = $setting_result[0]['session_id'];
                $data['current_session'] = $current_session;
                $pre_session = $this->session_model->getPreSession($current_session);
                if(valid($pre_session) && !empty($pre_session))
                {
                    $pre_student_session = $this->studentsession_model->getPrevStudentSession($pre_session->id, $student->id);
                    if(valid($pre_student_session) && !empty($pre_student_session))
                    {
                        $student_prev_due_fee      = $this->studentfeemaster_model->getStudentFees($pre_student_session->id);
                        if(valid($student_prev_due_fee) && !empty($student_prev_due_fee))
                        {
                            foreach($student_prev_due_fee as $duefee){
                                if($duefee->is_system == 1 && intval($duefee->amount) > 0){
                                    array_push($pre_student_due_fee_system, $duefee);
                                }
                            }
                        }
        
                    }
        
                }
                // end of get prev std session fess
        
        
                $student_due_fee      = $this->studentfeemaster_model->getStudentFees($student->student_session_id);
        
                if(!valid($student_due_fee) || empty($student_due_fee))
                {
                    $student_due_fee = $pre_student_due_fee_system;
                }
                else
                {
                    if(valid($student_due_fee) && !empty($student_due_fee) && valid($pre_student_due_fee_system) && !empty($pre_student_due_fee_system))
                    {
                        $student_due_fee = array_merge($student_due_fee, $pre_student_due_fee_system);
                    }
                }


                $total_amount = 0;
                $total_deposite_amount = 0;
                $total_fine_amount = 0;
                $total_fees_fine_amount = 0;
                
                $total_discount_amount = 0;
                $total_balance_amount = 0;
                $alot_fee_discount = 0;
                
                    foreach ($student_due_fee as $key => $fee)
                    {
                
                    foreach ($fee->fees as $fee_key => $fee_value)
                    {
                    $fee_paid = 0;
                    $fee_discount = 0;
                    $fee_fine = 0;
                    $fees_fine_amount = 0;
                    if (!empty($fee_value->amount_detail))
                    {
                $fee_deposits = json_decode(($fee_value->amount_detail));
                
                foreach ($fee_deposits as $fee_deposits_key => $fee_deposits_value)
                {
                $fee_paid = $fee_paid + $fee_deposits_value->amount;
                $fee_discount = $fee_discount + $fee_deposits_value->amount_discount;
                $fee_fine = $fee_fine + $fee_deposits_value->amount_fine;
                }
                }
                if (($fee_value->due_date != "0000-00-00" && $fee_value->due_date != null) && (strtotime($fee_value->due_date) < strtotime(date('Y-m-d'))))
                {
                $fees_fine_amount = $fee_value->fine_amount;
                $total_fees_fine_amount = $total_fees_fine_amount + $fee_value->fine_amount;
                }
                
                $total_amount = $total_amount + $fee_value->amount;
                $total_discount_amount = $total_discount_amount + $fee_discount;
                $total_deposite_amount = $total_deposite_amount + $fee_paid;
                $total_fine_amount = $total_fine_amount + $fee_fine;
                $feetype_balance = $fee_value->amount - ($fee_paid + $fee_discount);
                $total_balance_amount = $total_balance_amount + $feetype_balance;
                
                }
                }



                $editbtn    = '';

                $deletebtn  = '';

                $viewbtn    = '';

                $collectbtn = '';

                $print_button="";
                $cert_btn="";
                $photo_btn='';



                $viewbtn = "<div class='white-space-nowrap'><a href='" . base_url() . "student/view/" . $student->id . "'   class='btn btn-default btn-xs'  data-toggle='tooltip' title='" . $this->lang->line('view') . "'><i class='fa fa-reorder'></i></a>";



                if ($this->rbac->hasPrivilege('student', 'can_edit')) {

                    $editbtn = "<a href='" . base_url() . "student/edit/" . $student->id . "'   class='btn btn-default btn-xs'  data-toggle='tooltip' title='" . $this->lang->line('edit') . "'><i class='fa fa-pencil'></i></a>";

                }

                if ($this->module_lib->hasActive('fees_collection') && $this->rbac->hasPrivilege('collect_fees', 'can_add')) {



                    $collectbtn = "<a href='" . base_url() . "studentfee/addfee/" . $student->student_session_id . "'   class='btn btn-default btn-xs'  data-toggle='tooltip' title='" . $this->lang->line('add_fees') . "'><span >" . $currency_symbol . "</a>";

                }



                $loading="<i class='fa fa-circle-o-notch fa-spin'></i>";

                $print_button='<a type="button" class="btn btn-default btn-xs print_student_details shadow-none" data-student_id="'.$student->id.'" data-student_name="'.$this->customlib->getFullName($student->firstname, $student->middlename, $student->lastname, $sch_setting->middlename, $sch_setting->lastname).'" data-admission_no="'.$student->admission_no.'" data-action="download" data-placement="bottom" data-toggle="tooltip" 

                        data-original-title="print"  data-loading-text="'.$loading.'" ><i class="fa fa-print"></i></a></div>';
                    // $cert_btn = "<a href='javascript:void(0);' class='btn btn-default btn-xs show-certificate-modal' data-url='". base_url() ."admin/admin' data-stdid='". $student->id ."' data-toggle='tooltip' data-placement='left' title='' data-original-title='Print Certificate'><i class='fa fa-certificate'></i></a>";
    $cert_btn = "<a href='javascript:void(0);' class='btn btn-default btn-xs show-certificate-modal' data-url='". base_url() ."admin/admin' data-stdid='". $student->id ."' data-toggle='tooltip' data-placement='left' title='' data-original-title='Print Certificate'><i class='fa fa-certificate'></i></a>";

                    $cert_btn .= "<a href='javascript:void(0);' class='btn btn-default btn-xs show-blank_certificate-modal' data-url='". base_url() ."admin/admin' data-stdid='". $student->id ."' data-toggle='tooltip' data-placement='left' title='' data-original-title='Print Certificate Without Header'><i class='fa fa-certificate'></i></a>";
                    $photo_btn = "<a href='javascript:void(0);' class='btn btn-default btn-xs show-uploadphoto-modal' data-name='". $student->firstname .' '. $student->lastname ."' data-stdid='". $student->id ."' data-toggle='tooltip' data-placement='left' title='' data-original-title='Upload Photo'><i class='fa fa-camera'></i></a>";

                $row   = array();

               
                $row[] = $student->admission_no;
                 $row[] = $student->roll_no;

                $row[] = "<a href='" . base_url() . "student/view/" . $student->id . "'>" . 
         $student->firstname . 
         (!empty($student->father_name) ? ' ' . $student->father_name : '') . 
         ' ' . $student->lastname . 
         "</a>";



                $row[] = $student->class . "(" . $student->section . ")";

                if ($sch_setting->father_name) {

                    $row[] = $student->father_name;

                }
                if ($sch_setting->mother_name) {

                    $row[] = $student->mother_name;

                }



                $row[] = $this->customlib->dateformat($student->dob);



                if (!empty($student->gender)) {

                    $row[] = $this->lang->line(strtolower($student->gender));

                } else {

                    $row[] = '';

                }



                if ($sch_setting->category) {

                    $row[] = $student->category;

                }

                if ($sch_setting->mobile_no) {

                    $row[] = $student->mobileno;

                }



                foreach ($fields as $fields_key => $fields_value) {



                    $custom_name   = $fields_value->name;

                    $display_field = $student->$custom_name;

                    if ($fields_value->type == "link") {

                        $display_field = "<a href=" . $student->$custom_name . " target='_blank'>" . $student->$custom_name . "</a>";

                    }

                    $row[] = $display_field;

                }
                
                $row[] = $currency_symbol . $total_balance_amount;



                $row[] = $viewbtn . '' . $editbtn . '' . $collectbtn.''.$print_button.''.$cert_btn.''.$photo_btn;



                $dt_data[] = $row;

            }

        }

        $sch_setting         = $this->sch_setting_detail;

        $student_detail_view = $this->load->view('student/_searchDetailView', array('sch_setting' => $sch_setting, 'students' => $students), true);

        $json_data           = array(

            "draw"                => intval($students->draw),

            "recordsTotal"        => intval($students->recordsTotal),

            "recordsFiltered"     => intval($students->recordsFiltered),

            "data"                => $dt_data,

            "student_detail_view" => $student_detail_view,

        );



        echo json_encode($json_data);

    }


    public function dtstudentdisablestudentlist()
    {

        $currency_symbol = $this->customlib->getSchoolCurrencyFormat();

        $class           = $this->input->post('class_id');

        $section         = $this->input->post('section_id');

        $search_text     = $this->input->post('search_text');

        $search_type     = $this->input->post('srch_type');

        $classlist       = $this->class_model->get();

        $classlist       = $classlist;

        $carray          = array();

        if (!empty($classlist)) {

            foreach ($classlist as $ckey => $cvalue) {

                $carray[] = $cvalue["id"];

            }

        }



        $sch_setting = $this->sch_setting_detail;



        if ($search_type == "search_filter") {



    $resultlist = $this->student_model->searchdtByClassSectiondisablestudent($class, $section);
    

        } elseif ($search_type == "search_full") {



            $resultlist = $this->student_model->searchFullText($search_text, $carray);

        }



        $students = array();

        $students = json_decode($resultlist);
        
        $students_tc_requests = $this->student_model->get_tc_requests();



        $dt_data = array();

        $fields  = $this->customfield_model->get_custom_fields('students', 1);



        if (!empty($students->data)) {

            foreach ($students->data as $student_key => $student) {
                
                
                $pre_student_due_fee_system = array();
                $setting_result = $this->setting_model->get();
                $current_session = $setting_result[0]['session_id'];
                $data['current_session'] = $current_session;
                $pre_session = $this->session_model->getPreSession($current_session);
                if(valid($pre_session) && !empty($pre_session))
                {
                    $pre_student_session = $this->studentsession_model->getPrevStudentSession($pre_session->id, $student->id);
                    if(valid($pre_student_session) && !empty($pre_student_session))
                    {
                        $student_prev_due_fee      = $this->studentfeemaster_model->getStudentFees($pre_student_session->id);
                        if(valid($student_prev_due_fee) && !empty($student_prev_due_fee))
                        {
                            foreach($student_prev_due_fee as $duefee){
                                if($duefee->is_system == 1 && intval($duefee->amount) > 0){
                                    array_push($pre_student_due_fee_system, $duefee);
                                }
                            }
                        }
        
                    }
        
                }
                // end of get prev std session fess
        
        
                $student_due_fee      = $this->studentfeemaster_model->getStudentFees($student->student_session_id);
        
                if(!valid($student_due_fee) || empty($student_due_fee))
                {
                    $student_due_fee = $pre_student_due_fee_system;
                }
                else
                {
                    if(valid($student_due_fee) && !empty($student_due_fee) && valid($pre_student_due_fee_system) && !empty($pre_student_due_fee_system))
                    {
                        $student_due_fee = array_merge($student_due_fee, $pre_student_due_fee_system);
                    }
                }


                $total_amount = 0;
                $total_deposite_amount = 0;
                $total_fine_amount = 0;
                $total_fees_fine_amount = 0;
                
                $total_discount_amount = 0;
                $total_balance_amount = 0;
                $alot_fee_discount = 0;
                
                    foreach ($student_due_fee as $key => $fee)
                    {
                
                    foreach ($fee->fees as $fee_key => $fee_value)
                    {
                    $fee_paid = 0;
                    $fee_discount = 0;
                    $fee_fine = 0;
                    $fees_fine_amount = 0;
                    if (!empty($fee_value->amount_detail))
                    {
                $fee_deposits = json_decode(($fee_value->amount_detail));
                
                foreach ($fee_deposits as $fee_deposits_key => $fee_deposits_value)
                {
                $fee_paid = $fee_paid + $fee_deposits_value->amount;
                $fee_discount = $fee_discount + $fee_deposits_value->amount_discount;
                $fee_fine = $fee_fine + $fee_deposits_value->amount_fine;
                }
                }
                if (($fee_value->due_date != "0000-00-00" && $fee_value->due_date != null) && (strtotime($fee_value->due_date) < strtotime(date('Y-m-d'))))
                {
                $fees_fine_amount = $fee_value->fine_amount;
                $total_fees_fine_amount = $total_fees_fine_amount + $fee_value->fine_amount;
                }
                
                $total_amount = $total_amount + $fee_value->amount;
                $total_discount_amount = $total_discount_amount + $fee_discount;
                $total_deposite_amount = $total_deposite_amount + $fee_paid;
                $total_fine_amount = $total_fine_amount + $fee_fine;
                $feetype_balance = $fee_value->amount - ($fee_paid + $fee_discount);
                $total_balance_amount = $total_balance_amount + $feetype_balance;
                
                }
                }



                $editbtn    = '';

                $deletebtn  = '';

                $viewbtn    = '';

                $collectbtn = '';

                $print_button="";
                $cert_btn="";
                $photo_btn='';



                $viewbtn = "<div class='white-space-nowrap'><a href='" . base_url() . "student/view/" . $student->id . "'   class='btn btn-default btn-xs'  data-toggle='tooltip' title='" . $this->lang->line('view') . "'><i class='fa fa-reorder'></i></a>";



                if ($this->rbac->hasPrivilege('student', 'can_edit')) {

                    $editbtn = "<a href='" . base_url() . "student/edit/" . $student->id . "'   class='btn btn-default btn-xs'  data-toggle='tooltip' title='" . $this->lang->line('edit') . "'><i class='fa fa-pencil'></i></a>";

                }

                if ($this->module_lib->hasActive('fees_collection') && $this->rbac->hasPrivilege('collect_fees', 'can_add')) {



                    $collectbtn = "<a href='" . base_url() . "studentfee/addfee/" . $student->student_session_id . "'   class='btn btn-default btn-xs'  data-toggle='tooltip' title='" . $this->lang->line('add_fees') . "'><span >" . $currency_symbol . "</a>";

                }



                $loading="<i class='fa fa-circle-o-notch fa-spin'></i>";

                $print_button='<a type="button" class="btn btn-default btn-xs print_student_details shadow-none" data-student_id="'.$student->id.'" data-student_name="'.$this->customlib->getFullName($student->firstname, $student->middlename, $student->lastname, $sch_setting->middlename, $sch_setting->lastname).'" data-admission_no="'.$student->admission_no.'" data-action="download" data-placement="bottom" data-toggle="tooltip" 

                        data-original-title="print"  data-loading-text="'.$loading.'" ><i class="fa fa-print"></i></a></div>';
                    // $cert_btn = "<a href='javascript:void(0);' class='btn btn-default btn-xs show-certificate-modal' data-url='". base_url() ."admin/admin' data-stdid='". $student->id ."' data-toggle='tooltip' data-placement='left' title='' data-original-title='Print Certificate'><i class='fa fa-certificate'></i></a>";
                    // Check if student has TC request with status 1
                    $has_tc_request = false;
                    foreach ($students_tc_requests as $tc_request) {
                        if ($tc_request['student_id'] == $student->id && $tc_request['status'] == 1) {
                            $has_tc_request = true;
                            break;
                        }
                    }
                    
                    $cert_btn = "";
                    if ($has_tc_request) {
                        // Show print certificate buttons if TC request is approved (status 1)
                        $cert_btn = "<a href='javascript:void(0);' class='btn btn-default btn-xs show-certificate-modal' data-url='". base_url() ."admin/admin' data-stdid='". $student->id ."' data-toggle='tooltip' data-placement='left' title='' data-original-title='Print Certificate'><i class='fa fa-certificate'></i></a>";
                        $cert_btn .= "<a href='javascript:void(0);' class='btn btn-default btn-xs show-blank_certificate-modal' data-url='". base_url() ."admin/admin' data-stdid='". $student->id ."' data-toggle='tooltip' data-placement='left' title='' data-original-title='Print Certificate Without Header'><i class='fa fa-certificate'></i></a>";
                    } else {
                        // Show request certificate button if no approved TC request exists
                        $cert_btn = "<a href='javascript:void(0);' class='btn btn-default btn-xs request-certificate' data-stdid='". $student->id ."' data-studentname='".$this->customlib->getFullName($student->firstname, $student->middlename, $student->lastname, $sch_setting->middlename, $sch_setting->lastname)."' data-toggle='tooltip' data-placement='left' title='' data-original-title='Request Certificate'><i class='fa fa-file-text'></i></a>";
                    }
                    
                    $photo_btn = "<a href='javascript:void(0);' class='btn btn-default btn-xs show-uploadphoto-modal' data-name='". $student->firstname .' '. $student->lastname ."' data-stdid='". $student->id ."' data-toggle='tooltip' data-placement='left' title='' data-original-title='Upload Photo'><i class='fa fa-camera'></i></a>";
                $row   = array();

                $row[] = $student->roll_no;
                $row[] = $student->admission_no;

                $row[] = "<a href='" . base_url() . "student/view/" . $student->id . "'>" . $this->customlib->getFullName($student->firstname, $student->middlename, $student->lastname, $sch_setting->middlename, $sch_setting->lastname) . "</a>";


                $row[] = $student->class . "(" . $student->section . ")";

                if ($sch_setting->father_name) {

                    $row[] = $student->father_name;

                }
                if ($sch_setting->mother_name) {

                    $row[] = $student->mother_name;

                }



                $row[] = $this->customlib->dateformat($student->dob);



                if (!empty($student->gender)) {

                    $row[] = $this->lang->line(strtolower($student->gender));

                } else {

                    $row[] = '';

                }
               
            
                $row[] = $student->disable_reason;

                if ($sch_setting->category) {

                    $row[] = $student->category;

                }

                if ($sch_setting->mobile_no) {

                    $row[] = $student->mobileno;

                }



                foreach ($fields as $fields_key => $fields_value) {



                    $custom_name   = $fields_value->name;

                    $display_field = $student->$custom_name;

                    if ($fields_value->type == "link") {

                        $display_field = "<a href=" . $student->$custom_name . " target='_blank'>" . $student->$custom_name . "</a>";

                    }

                    $row[] = $display_field;

                }
                
                $row[] = $currency_symbol . $total_balance_amount;



                $row[] = $viewbtn . '' . $editbtn . '' . $collectbtn.''.$print_button.''.$cert_btn.''.$photo_btn;



                $dt_data[] = $row;

            }

        }

        $sch_setting         = $this->sch_setting_detail;

        $student_detail_view = $this->load->view('student/_searchDetailView', array('sch_setting' => $sch_setting, 'students' => $students), true);

        $json_data           = array(

            "draw"                => intval($students->draw),

            "recordsTotal"        => intval($students->recordsTotal),

            "recordsFiltered"     => intval($students->recordsFiltered),

            "data"                => $dt_data,

            "student_detail_view" => $student_detail_view,

        );



        echo json_encode($json_data);

    }
    
    
    public function request_certificate() {
        // Check if user has permission
        if (!$this->rbac->hasPrivilege('student', 'can_edit')) {
            echo json_encode(array('status' => 'error', 'message' => 'You do not have permission to request certificates.'));
            return;
        }
    
        $student_id = $this->input->post('student_id');
        
        if (empty($student_id)) {
            echo json_encode(array('status' => 'error', 'message' => 'Student ID is required.'));
            return;
        }
    
        // Check if request already exists
        $existing_request = $this->db->get_where('duplicate_tc_request', array(
            'student_id' => $student_id,
            'status' => 0 // Pending request
        ))->row();
    
        if ($existing_request) {
            echo json_encode(array('status' => 'error', 'message' => 'A certificate request is already pending for this student.'));
            return;
        }
    
        // Get current user ID
        $user_id = $this->session->userdata('admin')['id'];
    
        // Create new request
        $data = array(
            'student_id' => $student_id,
            'request_by' => $user_id,
            
        );
    
        $this->db->insert('duplicate_tc_request', $data);
        $request_id = $this->db->insert_id();
    
        if ($request_id) {
        
            echo json_encode(array(
                'status' => 'success',
                'message' => 'Certificate request submitted successfully. It will be processed shortly.'
            ));
        } else {
            echo json_encode(array(
                'status' => 'error',
                'message' => 'Failed to submit certificate request. Please try again.'
            ));
        }
    }
    
    
    public function certificate_request_list() {
        // Check permission
        if (!$this->rbac->hasPrivilege('certificate_requests', 'can_view')) {
            access_denied();
        }
    
        $this->session->set_userdata('top_menu', 'Certificate Requests');
        $this->session->set_userdata('sub_menu', 'certificate/request_list');
        
        $data['title'] = 'Certificate Requests';
        
        // Get all pending requests
        $data['request_list'] = $this->db->select('r.*, CONCAT(s.firstname, " ", s.lastname) as student_name , s.admission_no, s.roll_no, s.gender, c.class, sec.section, CONCAT(u.name, " ", u.surname) as request_by')
                                    ->from('duplicate_tc_request r')
                                    ->join('students s', 's.id = r.student_id')
                                    ->join('student_session ss', 'ss.student_id = s.id AND ss.session_id = (SELECT session_id FROM sch_settings LIMIT 1)')
                                    ->join('classes c', 'c.id = ss.class_id')
                                    ->join('sections sec', 'sec.id = ss.section_id', 'left')
                                    ->join('staff u', 'u.id = r.request_by')
                                    ->order_by('r.id', 'desc')
                                    ->get()
                                    ->result_array();
        
        $this->load->view('layout/header', $data);
        $this->load->view('student/certificate_requests', $data);
        $this->load->view('layout/footer', $data);
    }
    
    
    public function changeStatus() {
        // Check permission
        if (!$this->rbac->hasPrivilege('certificate_requests', 'can_edit')) {
            echo json_encode(['status' => 'error', 'message' => 'Permission denied']);
            return;
        }
    
        $id = $this->input->post('id');
        
        $user_id = $this->session->userdata('admin')['id'];
    
       
    
        
    
        // Update request status
        $update_data = [
            'status' => 1,
            'approved_by' => $user_id,
            'updated_at' => date('Y-m-d H:i:s')
        ];
    
        $this->db->where('id', $id)
                 ->update('duplicate_tc_request', $update_data);
    
       
        // Prepare response
        $response = [
            'status' => 'success',
            'message' => "Certificate request has been approved"
        ];
    
        
    
        echo json_encode($response);
    }

    //datatable function to check search parameter validation

    public function searchvalidation()

    {

        $class_id   = $this->input->post('class_id');

        $section_id = $this->input->post('section_id');



        $srch_type   = $this->input->post('search_type');

        $search_text = $this->input->post('search_text');



        if ($srch_type == 'search_filter') {



            $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');

            if ($this->form_validation->run() == true) {



                $params = array('srch_type' => $srch_type, 'class_id' => $class_id, 'section_id' => $section_id);

                $array  = array('status' => 1, 'error' => '', 'params' => $params);

                echo json_encode($array);

            } else {



                $error             = array();

                $error['class_id'] = form_error('class_id');

                $array             = array('status' => 0, 'error' => $error);

                echo json_encode($array);

            }

        } else {

            $params = array('srch_type' => 'search_full', 'class_id' => $class_id, 'section_id' => $section_id, 'search_text' => $search_text);

            $array  = array('status' => 1, 'error' => '', 'params' => $params);

            echo json_encode($array);

        }

    }



    public function getStudentByClassSection()

    {

        $data                 = array();

        $cls_section_id       = $this->input->post('cls_section_id');

        $data['fields']       = $this->customfield_model->get_custom_fields('students', 1);

        $student_list         = $this->student_model->getStudentBy_class_section_id($cls_section_id);

        $data['student_list'] = $student_list;

        $data['sch_setting']  = $this->sch_setting_detail;

        $page                 = $this->load->view('reports/_getStudentByClassSection', $data, true);

        echo json_encode(array('status' => 1, 'page' => $page));

    }



    public function handle_upload($str, $var)

    {

        $image_validate = $this->config->item('image_validate');

        $result         = $this->filetype_model->get();



        if (isset($_FILES[$var]) && !empty($_FILES[$var]['name'])) {



            $file_type = $_FILES[$var]['type'];

            $file_size = $_FILES[$var]["size"];

            $file_name = $_FILES[$var]["name"];



            $allowed_extension = array_map('trim', array_map('strtolower', explode(',', $result->image_extension)));

            $allowed_mime_type = array_map('trim', array_map('strtolower', explode(',', $result->image_mime)));

            $ext               = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));



            if ($files = @getimagesize($_FILES[$var]['tmp_name'])) {



                if (!in_array($files['mime'], $allowed_mime_type)) {

                    $this->form_validation->set_message('handle_upload', $this->lang->line('file_type_not_allowed'));

                    return false;

                }



                if (!in_array($ext, $allowed_extension) || !in_array($file_type, $allowed_mime_type)) {

                    $this->form_validation->set_message('handle_upload', $this->lang->line('extension_not_allowed'));

                    return false;

                }



                if ($file_size > $result->image_size) {

                    $this->form_validation->set_message('handle_upload', $this->lang->line('file_size_shoud_be_less_than') . number_format($result->image_size / 1048576, 2) . " MB");

                    return false;

                }

            } else {



                $this->form_validation->set_message('handle_upload', $this->lang->line('file_type_not_allowed_or_extension_not_allowed'));

                return false;

            }



            return true;

        }



        return true;

    }



    public function handle_uploadfordoc($str, $var)

    {

        $image_validate = $this->config->item('file_validate');

        $result         = $this->filetype_model->get();

        if (isset($_FILES[$var]) && !empty($_FILES[$var]['name'])) {



            $file_type = $_FILES[$var]['type'];

            $file_size = $_FILES[$var]["size"];

            $file_name = $_FILES[$var]["name"];



            $allowed_extension = array_map('trim', array_map('strtolower', explode(',', $result->file_extension)));

            $allowed_mime_type = array_map('trim', array_map('strtolower', explode(',', $result->file_mime)));

            $ext               = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));



            $finfo = finfo_open(FILEINFO_MIME_TYPE);

            $mtype = finfo_file($finfo, $_FILES[$var]['tmp_name']);

            finfo_close($finfo);



            if (!in_array($mtype, $allowed_mime_type)) {

                $this->form_validation->set_message('handle_uploadfordoc', $this->lang->line('file_type_not_allowed'));

                return false;

            }



            if (!in_array($ext, $allowed_extension) || !in_array($file_type, $allowed_mime_type)) {

                $this->form_validation->set_message('handle_uploadfordoc', $this->lang->line('extension_not_allowed'));

                return false;

            }



            if ($file_size > $result->file_size) {

                $this->form_validation->set_message('handle_uploadfordoc', $this->lang->line('file_size_shoud_be_less_than') . number_format($result->file_size / 1048576, 2) . " MB");

                return false;

            }



            return true;

        }

    }



    public function countAttendance($session_year_start, $student_session_id)

    {

        $attendencetypes = $this->attendencetype_model->getAttType();



        $record = array();

        foreach ($attendencetypes as $type_key => $type_value) {

            $record[$type_value['id']] = 0;

        }



        for ($i = 1; $i <= 12; $i++) {

            $start_month        = date('Y-m-d', strtotime($session_year_start));

            $end_month          = date('Y-m-t', strtotime($session_year_start));

            $session_year_start = date('Y-m-d', strtotime('+1 month', strtotime($session_year_start)));



            $attendences = $this->stuattendence_model->student_attendence_bw_date($start_month, $end_month, $student_session_id);

            if (!empty($attendences)) {

                foreach ($attendences as $attendence_key => $attendence_value) {

                    $record[$attendence_value->attendence_type_id] += 1;

                }

            }

        }



        return $record;

    }



    public function startmonthandend()

    {

        $startmonth = $this->setting_model->getStartMonth();

        if ($startmonth == 1) {

            $endmonth = 12;

        } else {

            $endmonth = $startmonth - 1;

        }

        return array($startmonth, $endmonth);

    }



    public function getAdmissionNoByGuardianEmail()

    {

        $student_id =   $_POST['student_id'];

        $guardian_email =   $_POST['guardian_email'];



        $student_admission_no = $this->student_model->getAdmissionNoByGuardianEmail($student_id, $guardian_email);



        if (!empty($student_admission_no['guardian_email'])) {            

            

            echo $this->lang->line('this_guardian_email_is_already_exists_for_an_existing_student_and_their_siblings_guardian_email_if_this_student_is_also_sibling_then_add_as_sibling').' - '.$this->lang->line('student').': '.$student_admission_no['firstname'] . " " . $student_admission_no['middlename'] . " " . $student_admission_no['lastname'] . " (" . $student_admission_no['admission_no'] . ")";

            

        } else {

            echo "";

        }

    }



    public function getAdmissionNoByGuardianPhone()

    {

        $student_id =   $_POST['student_id'];

        $guardian_phone =   $_POST['guardian_phone'];



        $student_admission_no = $this->student_model->getAdmissionNoByGuardianPhone($student_id, $guardian_phone);



        if (!empty($student_admission_no['guardian_phone'])) {



            echo $this->lang->line('this_guardian_phone_is_already_exists_for_an_existing_student_and_their_siblings_guardian_phone_if_this_student_is_also_sibling_then_add_as_sibling').' - '.$this->lang->line('student').': '.$student_admission_no['firstname'] . " " . $student_admission_no['middlename'] . " " . $student_admission_no['lastname'] . " (" . $student_admission_no['admission_no'] . ")";

            

        } else {

            echo "";

        }

    }



    public function printStudentDetails()

    {

        $student_id  = $_POST['student_id'];

        $result      = $this->student_model->getRecentRecord($student_id);

        $data['student']  = $this->student_model->getStudentByClassSectionID($result['class_id'], $result['section_id'], $student_id);

        $data['sch_setting']    =    $this->sch_setting_detail;

        $data['category_list']  = $this->category_model->get();

        $html  =  $this->load->view('print/printStudentDetails', $data, true);

        $this->load->library('m_pdf');

        $mpdf       = $this->m_pdf->load();

        $stylesheet = file_get_contents(base_url() . 'backend/dist/css/ss-print.css'); // external css        

        $mpdf->WriteHTML($stylesheet, 1); // Writing style to pdf         

        $mpdf->SetWatermarkText("", .2); // add watermark text to be show in marksheet

        $mpdf->SetDisplayMode('fullpage');

        $mpdf->showWatermarkText = true;

        $mpdf->autoScriptToLang  = true;

        $mpdf->baseScript        = 1;

        $mpdf->autoLangToFont    = true;

        $mpdf->WriteHTML($html, \Mpdf\HTMLParserMode::HTML_BODY);

        $content = $mpdf->Output(random_string() . '.pdf', 'I');

        return $content;

    }

// ANIL KANZARIYA - New added function Student details in photo upload function start
      public function upload_student_photo()

    {

        //echo '<pre>';print_r($_POST);exit;

        if (!$this->rbac->hasPrivilege('homework', 'can_add')) {

            access_denied();

        }

        if(isset($_POST['image_data']) && valid($_POST['image_data']))

        {

            $data = $_POST['image_data'];

            $id = $this->input->post("student_photo_id");

            if (!valid($id) || empty($id)) {

                $array = array('status' => 'fail', 'error' => array('studentphoto' => 'Invlid student, try again later..'), 'message' => '');

                echo json_encode($array);

                exit;

            }

            ////data:image/png;base64,iVBORw0KGgoAAAA

            $image_array_1 = explode(";", $data);

            //base64,iVBORw0KGgoAAAANSUhEUgAAAZAAAA

            $image_array_2 = explode(",", $image_array_1[1]);

            //iVBORw0KGgoAAAANSUhEUgAAAZAAAA

            $data = base64_decode($image_array_2[1]);

            $image_name = 'uploads/student_images/' . $id . '.png';


if (file_exists($image_name)) {
    unlink($image_name);
}

             //@todo - Check if image exists and Remove existing image from folder/directory

            file_put_contents($image_name, $data);

            //echo $image_name;

            $data_img = array('id' => $id, 'image' => $image_name);

            $this->student_model->add($data_img);

            $msg   = 'Photo uploaded successfully..';

            $array = array('status' => 'success', 'error' => '', 'message' => $msg);

            echo json_encode($array);

            exit();

        }

        $data["title"]      = "Create Homework";

        $class              = $this->class_model->get();

        $data['classlist']  = $class;

        $data['class_id']   = "";

        $data['section_id'] = "";

        $userdata           = $this->customlib->getUserData();

        $this->form_validation->set_rules('student_photo_id', $this->lang->line('student_photo_id'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('studentphoto', $this->lang->line('image'), 'callback_handle_upload');

        if ($this->form_validation->run() == false) {



            $msg = array(

                'student_photo_id'              => form_error('student_photo_id'),

                'studentphoto'               => form_error('studentphoto'),

            );



            $array = array('status' => 'fail', 'error' => $msg, 'message' => '');



        } else {

            if (!isset($_FILES["studentphoto"]) || empty($_FILES['studentphoto']['name'])) {

                $array = array('status' => 'fail', 'error' => array('studentphoto' => 'Please upload photo..'), 'message' => '');

                echo json_encode($array);

                exit;

            }

            

            $id = $this->input->post("student_photo_id");

            if (isset($_FILES["studentphoto"]) && !empty($_FILES['studentphoto']['name'])) {

                $fileInfo = pathinfo($_FILES["studentphoto"]["name"]);

                $img_name = $id . '.' . $fileInfo['extension'];

                move_uploaded_file($_FILES["studentphoto"]["tmp_name"], "./uploads/student_images/" . $img_name);

                $data_img = array('id' => $id, 'image' => 'uploads/student_images/' . $img_name);

                $this->student_model->add($data_img);

            }

            $msg   = 'Photo uploaded successfully..';

            $array = array('status' => 'success', 'error' => '', 'message' => $msg);

        }



        echo json_encode($array);

    }
//Start ANIL KANZARIYA - New added function Student Idcard for - Shri Bankatlal Lahoti English School 
    

//     function studentidcards() {

//         if (!$this->rbac->hasPrivilege('student_attendance', 'can_view')) {

//             access_denied(); 

//         }



//         $this->session->set_userdata('top_menu', 'Student Information');

//         $this->session->set_userdata('sub_menu', 'student/studentidcards');

//         $data['title'] = 'Add Fees Type';

//         $data['title_list'] = 'Fees Type List';

//         $sch_setting = $this->setting_model->getSchoolDetail();

//         $data['sch_setting'] = $this->sch_setting_detail;

//         $class = $this->class_model->get();

//         //$class = $this->class_model->get('', $classteacher = 'yes');

//         $userdata = $this->customlib->getUserData();

//         $carray = array();



//         if (!empty($data["classlist"])) {

//             foreach ($data["classlist"] as $ckey => $cvalue) {



//                 $carray[] = $cvalue["id"];

//             }

//         }

//         /**

//         $userdata = $this->customlib->getUserData();

//         $role_id = $userdata["role_id"];

//         if (isset($role_id) && ($userdata["role_id"] == 2) && ($userdata["class_teacher"] == "yes")) {

//             if ($userdata["class_teacher"] == 'yes') {

//                 $carray = array();

//                 $class = array();

//                 $class = $this->teacher_model->get_daywiseattendanceclass($userdata["id"]);

//             }

//         }

//         **/

//         $data['classlist'] = $class;

//         $data['class_id'] = "";

//         $data['section_id'] = "";

//         $data['date'] = "";

//         $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');

//         $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');

//         if ($this->form_validation->run() == FALSE) {

//             $this->load->view('layout/header', $data);

//             // $this->load->view('admin/stuattendence/attendenceList', $data);

//             $this->load->view('student/studentIdCards', $data);

//             $this->load->view('layout/footer', $data);

//         } else {

            

//             $class = $this->input->post('class_id');

//             $section = $this->input->post('section_id');

//             //$student_list = $this->stuattendence_model->get();

//             //$data['studentlist'] = $student_list;

//             $data['class_id'] = $class;

//             $data['section_id'] = $section;

//             //echo '<pre>sdsffds11...';exit;

//             //$resultlist = $this->student_model->searchdtByClassSection($class, $section);

//             $resultlist = $this->student_model->searchByClassSection($class, $section);

// //            echo '<pre>';print_r($resultlist);exit;

//             $data['resultlist'] = $resultlist;

//             $setting_result = $this->setting_model->get();

//             $data['settinglist'] = $setting_result;

//             $this->load->view('layout/header', $data);

//             // $this->load->view('admin/stuattendence/attendenceList', $data);

//             $this->load->view('student/studentIdCards', $data);

//             $this->load->view('layout/footer', $data);

//         }

//     }


    // code updated by ashok singh

       
public function studentidcards()
{
    if (!$this->rbac->hasPrivilege('student_attendance', 'can_view')) {
        access_denied();
    }

    $search_type = $this->input->post('srch_type');
    $search_text = $this->input->post('search_text');
    $data['search_text'] = $search_text;

    $this->session->set_userdata('top_menu', 'Student Information');
    $this->session->set_userdata('sub_menu', 'student/studentidcards');

    $data['title'] = 'Add Fees Type';
    $data['title_list'] = 'Fees Type List';

    $sch_setting = $this->setting_model->getSchoolDetail();
    $data['sch_setting'] = $this->sch_setting_detail;

    $class = $this->class_model->get();
    $userdata = $this->customlib->getUserData();
    $carray = [];

    if (!empty($class)) {
        foreach ($class as $ckey => $cvalue) {
            $carray[] = $cvalue["id"];
        }
    }

    $data['classlist'] = $class;
    $data['class_id'] = "";
    $data['section_id'] = "";
    $data['date'] = "";
    $data['resultlist'] = []; // ✅ default empty result list

    // Only run search logic if form is submitted
    if ($this->input->server('REQUEST_METHOD') == 'POST') {
        $class = $this->input->post('class_id');
        $section = $this->input->post('section_id');

        $data['class_id'] = $class;
        $data['section_id'] = $section;

        if ($search_type == "search") {
            $resultlist = $this->student_model->searchByClassSection($class, $section);
        } elseif ($search_type == "search_full") {
            $resultlist = $this->student_model->searchFullTextIDcard($search_text, $carray);
        } else {
            $resultlist = $this->student_model->searchByClassSection($class, $section);
        }

        $data['resultlist'] = $resultlist;
    }

    $setting_result = $this->setting_model->get();
    $data['settinglist'] = $setting_result;

    $this->load->view('layout/header', $data);
    $this->load->view('student/studentIdCards', $data);
    $this->load->view('layout/footer', $data);
}


//End ANIL KANZARIYA - New added function Student Idcard for - Shri Bankatlal Lahoti English School 
// ANIL KANZARIYA - New added function Student Idcard for -
// ANIL KANZARIYA - New added function Student details in photo upload function end
// ANIL KANZARIYA - New added function Student details in Get Certificate modelopen  upload function Start 
    
    // public function getCertificatePreviewdetail($stdid = '')

    // {

    //     if (!$this->rbac->hasPrivilege('student_report', 'can_view'))

    //     {

    //         access_denied();

    //     }

    //     $student_sessionid = trim($this->input->post('student_sessionid'));

    //     if (valid($student_sessionid) && !empty($student_sessionid))

    //     {

    //         $student = $this->student_model->get($stdid, $student_sessionid);

    //     }

    //     else

    //     {

    //         $student = $this->student_model->get($stdid);

    //     }

    //   // echo '<pre>';print_r($student);exit;

    //     //$student = $this->student_model->get($stdid);

    //     //        $gradeList = $this->grade_model->get();

    //     $gradeList = '';

    //     $studentSession = $this->student_model->getStudentSession($stdid);

    //     $student_session_id = $studentSession["student_session_id"];



    //     $student_session = $studentSession["session"];

    //     // $data["session"] = $student_session;       

    //     $current_student_session = $this->student_model->get_studentsession($student['student_session_id']);



    //     $data = array();

    //     $data["session"] = $current_student_session["session"];



    //     $data['student_doc_id'] = $stdid;

    //     $category_list = $this->category_model->get();

    //     //   $category_list = '';

    //     $data['category_list'] = $category_list;

    //     $data['gradeList'] = $gradeList;

    //     $data['student'] = $row = $student;

    //     $class_section = $this->student_model->getClassSection($student["class_id"]);

    //     $data["class_section"] = $class_section;

    //     $session = $this->setting_model->getCurrentSession();

    //     $setting_result = $this->setting_model->get();

    //     $data['settinglist'] = $setting_result;

    //     $certType = trim($this->input->post('certType'));

    //     // serial number

    //     $cert_type = '';

    //     switch ($certType)

    //     {

    //         case 'leaving':

    //             $cert_type = 'cert_leaving';

    //             break;

    //         case 'bonafide':

    //             $cert_type = 'cert_bonafide';

    //             break;

    //         case 'entry':

    //             $cert_type = 'cert_entry';

    //             break;

    //     }

    //     $serial_no = str_pad($student['id'], 4, "0", STR_PAD_LEFT);

    // //        $serial_no = strtotime(date('Y-m-d h:i:s'));

    //     if (in_array($certType, array('leaving', 'bonafide', 'entry')))

    //     {

    //         $schtype = getSchoolTypeByClass($student['class']);

    //         $schtypelower = strtolower($schtype);

    //         $cert_result = get_single_row('cert_settings', array('cert_type' => $cert_type, 'inst_type' => $schtypelower));

    //         if (valid($cert_result) && !empty($cert_result))

    //         {

    //             if ($cert_result->cert_auto_insert)

    //             {

    //                 //$serial_no = $setting_result->cert_prefix . $setting_result->cert_start_from;

    //                 $serial_no = $cert_result->cert_prefix . sprintf("%0" . $cert_result->cert_no_digit . "d", $cert_result->cert_start_from);

    //                 $classIds = $this->class_model->getClassIdBySchoolType($schtype);

    //                 $stdDetails = $this->student_model->studentCertificateDetails($classIds, strtoupper($cert_type));

                    

    //                 if (valid($stdDetails) && !empty($stdDetails))

    //                 {

    //                     $stddata = current($stdDetails);

    //                     switch ($certType)

    //                     {

    //                         case 'leaving':

    //                             $snleavingcert = trim($stddata['sn_cert_leaving']);

    //                             break;

    //                         case 'bonafide':

    //                             $snleavingcert = trim($stddata['sn_cert_bonafide']);

    //                             break;

    //                         case 'entry':

    //                             $snleavingcert = trim($stddata['sn_cert_entry']);

    //                             break;

    //                         default :

    //                             $snleavingcert = '';

    //                             break;

    //                     }

    //                     if (valid($snleavingcert))

    //                     {

    //                         $last_serial_no = str_replace($cert_result->cert_prefix, "", $snleavingcert);

    //                         $serial_no = $cert_result->cert_prefix . sprintf("%0" . $cert_result->cert_no_digit . "d", $last_serial_no + 1);

    //                 //echo '<pre>'.$cert_type;

    //                 //print_r($snleavingcert);

    //                 //exit;

    //                     }

    //                 }

    //             }

    //         }

    //     }

    //     $data['serial_no'] = $serial_no;

    //     // end of serial number

    //     //        echo '<pre>';print_r($setting_result);

    //     $folder_name = strtolower($setting_result[0]['system_name']);

    //     switch ($certType)

    //     {

    //         case 'bonafide':

    //             $filePath = './application/views/reports/' . $folder_name . '/' . 'bonafiedCertificate.php';

    //             if (@file_exists($filePath))

    //             {

    //                 $html = $this->load->view('reports/' . $folder_name . '/bonafiedCertificate', $data, true);

    //             }

    //             else

    //             {

    //                 $html = $this->load->view('reports/bonafiedCertificate', $data, true);

    //             }

    //             break;

    //         case 'leaving':

    //             $data['serial_no'] = valid(trim($student['sn_cert_leaving'])) ? trim($student['sn_cert_leaving']) : $serial_no;

    //             $data['sn_leaving_date'] = valid(trim($student['sn_leaving_date'])) ? trim($student['sn_leaving_date']) : '';

    //             $filePath = './application/views/reports/' . $folder_name . '/' . 'leavingCertificate.php';

    //             if (@file_exists($filePath))

    //             {

    //                 $html = $this->load->view('reports/' . $folder_name . '/leavingCertificate', $data, true);

    //             }

    //             else

    //             {

    //                 $html = $this->load->view('reports/leavingCertificate', $data, true);

    //             }

    //             break;

    //         case 'entry':

    //             $filePath = './application/views/reports/' . $folder_name . '/' . 'entryCertificate.php';

    //             if (@file_exists($filePath))

    //             {

    //                 $html = $this->load->view('reports/' . $folder_name . '/entryCertificate', $data, true);

    //             }

    //             else

    //             {

    //                 $html = $this->load->view('reports/entryCertificate', $data, true);

    //             }

    //             break;

    //         case 'admissionform':

    //             $filePath = './application/views/reports/' . $folder_name . '/' . 'admissionApplicationForm.php';

    //             if (@file_exists($filePath))

    //             {

    //                 $html = $this->load->view('reports/' . $folder_name . '/admissionApplicationForm', $data, true);

    //             }

    //             else

    //             {

    //                 $html = $this->load->view('reports/admissionApplicationForm', $data, true);

    //             }

    //     //                $html = $this->load->view('reports/admissionApplicationForm', $data, true);

    //             break;

    //         case 'studentidcard':

    //             $this->load->library('QRCode');

    //             $qr = new BarcodeQR();

    //             $schoolName = $setting_result[0]['name'];

    //             $fullname = $student['firstname'] . ' ' . $student['father_name'] . ' ' . $student['lastname'];

    //             $UDISENumber = isset($UDISENumber) ? $UDISENumber : '';

    //             $text = $schoolName . "  , UDISE Number:-" . $UDISENumber . " , Rollno:- " . $student['roll_no'] . " , name:- " . $fullname . " , class:- " . $student['class'];

    //             $qr->text($text);

    //             $image = "./uploads/qr_image/idcard-" . $stdid . ".png";

    //     //        move_uploaded_file($_FILES["file"]["tmp_name"], "./uploads/student_images/" . $img_name);

    //             $qr->draw(150, $image);

    //             $qrimage = base_url() . "/uploads/qr_image/idcard-".$stdid.".png";

    //             $data['qrimage'] = $qrimage;

    //             $idcard_type = isset($_POST['idcard_type']) ? trim($_POST['idcard_type']) : 'verticle';

    //             $studentIdCard = ($idcard_type == 'horizontal') ? 'studentIdCard_horizontal' : 'studentIdCard';

                

    //             $filePath = './application/views/reports/' . $folder_name . '/' . $studentIdCard . '.php';

    //             if($idcard_type == 'horizontal')

    //             {

    //                 $filePath = './application/views/reports/' . $folder_name . '/' . $studentIdCard . '.php';

    //             }

    //             if (@file_exists($filePath))

    //             {

    //                 $html = $this->load->view("reports/" . $folder_name . "/$studentIdCard", $data, true);

    //             }

    //             else

    //             {

    //                 $html = $this->load->view("reports/$studentIdCard", $data, true);

    //             }

    //             break;

    //         case 'parentidcard':

    //             $filePath = './application/views/reports/' . $folder_name . '/' . 'parentIdCard.php';

    //             if (@file_exists($filePath))

    //             {

    //                 $html = $this->load->view('reports/' . $folder_name . '/parentIdCard', $data, true);

    //             }

    //             else

    //             {

    //                 $html = $this->load->view('reports/parentIdCard', $data, true);

    //             }

    //             break;

    //         default:

    //             break;

    //     }

    //     echo json_encode(array('data' => $html));

    //     exit;

    //     //        $student_id = $this->input->post('student_id');

    //     //        $examSchedule = $this->user_model->getStudentLoginDetails($student_id);

    //     //        echo json_encode($examSchedule);

    // }
    
    
    function parentidcards()
    {

        if (!$this->rbac->hasPrivilege('student', 'can_view')) {

            access_denied();
        }



        $this->session->set_userdata('top_menu', 'Student Information');

        $this->session->set_userdata('sub_menu', 'student/parentidcards');

        $data['title'] = 'Add Fees Type';

        $data['title_list'] = 'Fees Type List';

        $sch_setting = $this->setting_model->getSchoolDetail();

        $data['sch_setting'] = $this->sch_setting_detail;

        $class = $this->class_model->get();

        //$class = $this->class_model->get('', $classteacher = 'yes');

        $userdata = $this->customlib->getUserData();

        $carray = array();



        if (!empty($data["classlist"])) {

            foreach ($data["classlist"] as $ckey => $cvalue) {



                $carray[] = $cvalue["id"];
            }
        }

        /**

        $userdata = $this->customlib->getUserData();

        $role_id = $userdata["role_id"];

        if (isset($role_id) && ($userdata["role_id"] == 2) && ($userdata["class_teacher"] == "yes")) {

            if ($userdata["class_teacher"] == 'yes') {

                $carray = array();

                $class = array();

                $class = $this->teacher_model->get_daywiseattendanceclass($userdata["id"]);

            }

        }

         **/

        $data['classlist'] = $class;

        $data['class_id'] = "";

        $data['section_id'] = "";

        $data['date'] = "";

        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == FALSE) {

            $this->load->view('layout/header', $data);

            // $this->load->view('admin/stuattendence/attendenceList', $data);

            $this->load->view('student/parentIdCards', $data);

            $this->load->view('layout/footer', $data);
        } else {



            $class = $this->input->post('class_id');

            $section = $this->input->post('section_id');

            //$student_list = $this->stuattendence_model->get();

            //$data['studentlist'] = $student_list;

            $data['class_id'] = $class;

            $data['section_id'] = $section;

            //echo '<pre>sdsffds11...';exit;

            //$resultlist = $this->student_model->searchdtByClassSection($class, $section);

            $resultlist = $this->student_model->searchByClassSection($class, $section);

            // echo '<pre>';print_r($resultlist);exit;

            $data['resultlist'] = $resultlist;

            $setting_result = $this->setting_model->get();

            $data['settinglist'] = $setting_result;

            $this->load->view('layout/header', $data);

            // $this->load->view('admin/stuattendence/attendenceList', $data);

            $this->load->view('student/parentIdCards', $data);

            $this->load->view('layout/footer', $data);
        }
    }
    
    public function getCertificatePreviewdetail($stdid = '')
{
    
   
    if (!$this->rbac->hasPrivilege('student_report', 'can_view')) {
        access_denied();
    }

    $student_sessionid = trim($this->input->post('student_sessionid'));
    
    

    if (valid($student_sessionid) && !empty($student_sessionid)) {
        $student = $this->student_model->get($stdid, $student_sessionid);
    } else {
        $student = $this->student_model->get($stdid);
    }
   
   
  
    $gradeList = '';
    $studentSession = $this->student_model->getStudentSession($stdid);
    $student_session_id = $studentSession["student_session_id"];
    $student_session = $studentSession["session"];
    $current_student_session = $this->student_model->get_studentsession($student['student_session_id']);
    
    $data = array();
    $data["session"] = $current_student_session["session"];
    $data['student_doc_id'] = $stdid;
    $category_list = $this->category_model->get();
    $data['category_list'] = $category_list;
    $data['gradeList'] = $gradeList;
    $data['student'] = $row = $student;

    $class_section = $this->student_model->getClassSection($student["class_id"]);
    $data["class_section"] = $class_section;

    $session = $this->setting_model->getCurrentSession();
    $setting_result = $this->setting_model->get();
    $data['settinglist'] = $setting_result;
    
   

    $certType = trim($this->input->post('certType'));

    // Determine cert_type string
    $cert_type = '';
    switch ($certType) {
        case 'leaving':
            $cert_type = 'cert_leaving';
            break;
        case 'bonafide':
            $cert_type = 'cert_bonafide';
            break;
        case 'entry':
            $cert_type = 'cert_entry';
            break;
        case 'study':
            $cert_type = 'cert_study';
            break;
    }

    $serial_no = str_pad($student['id'], 4, "0", STR_PAD_LEFT);

    if (in_array($certType, array('leaving', 'bonafide', 'entry', 'study'))) {
        $schtype = getSchoolTypeByClass($student['class']);
        $schtypelower = strtolower($schtype);
        $cert_result = get_single_row('cert_settings', array('cert_type' => $cert_type, 'inst_type' => $schtypelower));

        if (valid($cert_result) && !empty($cert_result)) {
            if ($cert_result->cert_auto_insert) {
                $serial_no = $cert_result->cert_prefix . sprintf("%0" . $cert_result->cert_no_digit . "d", $cert_result->cert_start_from);
                $classIds = $this->class_model->getClassIdBySchoolType($schtype);
                $stdDetails = $this->student_model->studentCertificateDetails($classIds, strtoupper($cert_type));

                if (valid($stdDetails) && !empty($stdDetails)) {
                    $stddata = current($stdDetails);
                    switch ($certType) {
                        case 'leaving':
                            $snleavingcert = trim($stddata['sn_cert_leaving']);
                            break;
                        case 'bonafide':
                            $snleavingcert = trim($stddata['sn_cert_bonafide']);
                            break;
                        case 'entry':
                            $snleavingcert = trim($stddata['sn_cert_entry']);
                            break;
                        case 'study':
                            $snleavingcert = trim($stddata['sn_cert_study']);
                            break;
                        default:
                            $snleavingcert = '';
                            break;
                    }

                    if (valid($snleavingcert)) {
                        $last_serial_no = str_replace($cert_result->cert_prefix, "", $snleavingcert);
                        $serial_no = $cert_result->cert_prefix . sprintf("%0" . $cert_result->cert_no_digit . "d", $last_serial_no + 1);
                    }
                }
            }
        }
    }

    $data['serial_no'] = $serial_no;
    $folder_name = strtolower($setting_result[0]['system_name']);

    switch ($certType) {
        case 'bonafide':
            $filePath = './application/views/reports/' . $folder_name . '/bonafiedCertificate.php';
            $html = @file_exists($filePath)
                ? $this->load->view('reports/' . $folder_name . '/bonafiedCertificate', $data, true)
                : $this->load->view('reports/bonafiedCertificate', $data, true);
            break;

        case 'leaving':
            $data['serial_no'] = valid(trim($student['sn_cert_leaving'])) ? trim($student['sn_cert_leaving']) : $serial_no;
            $data['sn_leaving_date'] = valid(trim($student['sn_leaving_date'])) ? trim($student['sn_leaving_date']) : '';
            $filePath = './application/views/reports/' . $folder_name . '/leavingCertificate.php';
            $html = @file_exists($filePath)
                ? $this->load->view('reports/' . $folder_name . '/leavingCertificate', $data, true)
                : $this->load->view('reports/leavingCertificate', $data, true);
            break;

        case 'entry':
            $filePath = './application/views/reports/' . $folder_name . '/entryCertificate.php';
            $html = @file_exists($filePath)
                ? $this->load->view('reports/' . $folder_name . '/entryCertificate', $data, true)
                : $this->load->view('reports/entryCertificate', $data, true);
            break;

        case 'study':
            $filePath = './application/views/reports/' . $folder_name . '/studyCertificate.php';
            $html = @file_exists($filePath)
                ? $this->load->view('reports/' . $folder_name . '/studyCertificate', $data, true)
                : $this->load->view('reports/studyCertificate', $data, true);
            break;

        case 'admissionform':
            $filePath = './application/views/reports/' . $folder_name . '/admissionApplicationForm.php';
            $html = @file_exists($filePath)
                ? $this->load->view('reports/' . $folder_name . '/admissionApplicationForm', $data, true)
                : $this->load->view('reports/admissionApplicationForm', $data, true);
            break;

        case 'studentidcard':
            
            $schoolName = $setting_result[0]['name'];
            $fullname = $student['firstname'] . ' ' . $student['father_name'] . ' ' . $student['lastname'];
            $UDISENumber = isset($UDISENumber) ? $UDISENumber : '';
            $text = $schoolName . "  , UDISE Number:-" . $UDISENumber . " , Rollno:- " . $student['roll_no'] . " , name:- " . $fullname . " , class:- " . $student['class'];
           
            $idcard_type = isset($_POST['idcard_type']) ? trim($_POST['idcard_type']) : 'verticle';
            $studentIdCard = ($idcard_type == 'horizontal') ? 'studentIdCard_horizontal' : 'studentIdCard';
            $filePath = './application/views/reports/' . $folder_name . '/' . $studentIdCard . '.php';
            $html = @file_exists($filePath)
                ? $this->load->view("reports/" . $folder_name . "/$studentIdCard", $data, true)
                : $this->load->view("reports/$studentIdCard", $data, true);
            break;

        case 'parentidcard':
            $filePath = './application/views/reports/' . $folder_name . '/parentIdCard.php';
            $html = @file_exists($filePath)
                ? $this->load->view('reports/' . $folder_name . '/parentIdCard', $data, true)
                : $this->load->view('reports/parentIdCard', $data, true);
            break;

        default:
            $html = '';
            break;
    }

    echo json_encode(array('data' => $html));
    exit;
}

// ANIL KANZARIYA - New added function Student details in Get Certificate modelopen  upload function end









// Arun Rajput - New added function for  montlyAttendence record  start 
 public function montlyAttendence()

    {

     
        if (!$this->rbac->hasPrivilege('student', 'can_view')) {

            access_denied();

        }



        $this->session->set_userdata('top_menu', 'Reports');

        $this->session->set_userdata('sub_menu', 'student/montlyAttendence');

        $data['title']           = 'Student Search';

        $data['adm_auto_insert'] = $this->sch_setting_detail->adm_auto_insert;

        $data['sch_setting']     = $this->sch_setting_detail;

        $data['fields']          = $this->customfield_model->get_custom_fields('students', 1);

        $class                   = $this->class_model->get();

        $data['classlist']       = $class;



        $this->load->view('layout/header', $data);

        $this->load->view('student/montlyattendence', $data);

        $this->load->view('layout/footer', $data);



    }
    
    
    
    
    
    
    public function dtstudentlistforattendence()

    {

        $currency_symbol = $this->customlib->getSchoolCurrencyFormat();

        $class           = $this->input->post('class_id');

        $section         = $this->input->post('section_id');

        $search_text     = $this->input->post('search_text');

        $search_type     = $this->input->post('srch_type');

        $classlist       = $this->class_model->get();

        $classlist       = $classlist;

        $carray          = array();

        if (!empty($classlist)) {

            foreach ($classlist as $ckey => $cvalue) {

                $carray[] = $cvalue["id"];

            }

        }



        $sch_setting = $this->sch_setting_detail;



        if ($search_type == "search_filter") {



            $resultlist = $this->student_model->searchdtByClassSection($class, $section);

        } elseif ($search_type == "search_full") {



            $resultlist = $this->student_model->searchFullText($search_text, $carray);

        }



        $students = array();

        $students = json_decode($resultlist);



        $dt_data = array();

        $fields  = $this->customfield_model->get_custom_fields('students', 1);



        if (!empty($students->data)) {

            foreach ($students->data as $student_key => $student) {



                $editbtn    = '';

                $deletebtn  = '';

                $viewbtn    = '';

                $collectbtn = '';

                $print_button="";
                $cert_btn="";
                $photo_btn='';



                 $viewbtn = "<a href='" . base_url() . "student/printMontlyAttendence/" . $student->id . "'   class='btn btn-default btn-xs'  data-toggle='tooltip' data-placement='left' title='print'><i class='fa fa-print'></i></a>";

                $row   = array();

                $row[] = $student->roll_no;
                $row[] = $student->admission_no;

                $row[] = "<a href='" . base_url() . "student/view/" . $student->id . "'>" . $this->customlib->getFullName($student->firstname, $student->middlename, $student->lastname, $sch_setting->middlename, $sch_setting->lastname) . "</a>";


                $row[] = $student->class . "(" . $student->section . ")";

                if ($sch_setting->father_name) {

                    $row[] = $student->father_name;

                }
                if ($sch_setting->mother_name) {

                    $row[] = $student->mother_name;

                }



                $row[] = $this->customlib->dateformat($student->dob);



                if (!empty($student->gender)) {

                    $row[] = $this->lang->line(strtolower($student->gender));

                } else {

                    $row[] = '';

                }



                if ($sch_setting->category) {

                    $row[] = $student->category;

                }

                if ($sch_setting->mobile_no) {

                    $row[] = $student->mobileno;

                }



                foreach ($fields as $fields_key => $fields_value) {



                    $custom_name   = $fields_value->name;

                    $display_field = $student->$custom_name;

                    if ($fields_value->type == "link") {

                        $display_field = "<a href=" . $student->$custom_name . " target='_blank'>" . $student->$custom_name . "</a>";

                    }

                    $row[] = $display_field;

                }



                $row[] = $viewbtn . '' . $editbtn . '' . $collectbtn.''.$print_button.''.$cert_btn.''.$photo_btn;



                $dt_data[] = $row;

            }

        }

        $sch_setting         = $this->sch_setting_detail;

        $student_detail_view = $this->load->view('student/_searchDetailView', array('sch_setting' => $sch_setting, 'students' => $students), true);

        $json_data           = array(

            "draw"                => intval($students->draw),

            "recordsTotal"        => intval($students->recordsTotal),

            "recordsFiltered"     => intval($students->recordsFiltered),

            "data"                => $dt_data,

            "student_detail_view" => $student_detail_view,

        );



        echo json_encode($json_data);

    }
    
    
      // Arun Rajput - New added function for  montlyAttendence record  start
   public function printMontlyAttendence($studentid)
{
    $student = $studentid;
    $currentSessionId = $this->setting_model->getCurrentSession();

    $sql = "SELECT 
        m.month_display AS month_name,
        m.total_month_days,
        IFNULL(a.sunday_count, 0) AS sunday_count,
        IFNULL(a.holiday, 0) AS holiday_type_count,
        (IFNULL(a.sunday_count, 0) + IFNULL(a.holiday, 0)) AS total_holidays,
        (m.total_month_days - (IFNULL(a.sunday_count, 0) + IFNULL(a.holiday, 0))) AS working_days,

        IFNULL(a.present, 0) AS present,
        IFNULL(a.late_with_excuse, 0) AS late_with_excuse,
        IFNULL(a.late, 0) AS late,
        IFNULL(a.absent, 0) AS absent,
        IFNULL(a.half_day, 0) AS half_day,

        (
            IFNULL(a.present, 0) +
            IFNULL(a.late_with_excuse, 0) +
            IFNULL(a.late, 0) +
            IFNULL(a.absent, 0) +
            IFNULL(a.holiday, 0) +
            IFNULL(a.half_day, 0)
        ) AS marked_days,

        (m.total_month_days -
            (
                IFNULL(a.present, 0) +
                IFNULL(a.late_with_excuse, 0) +
                IFNULL(a.late, 0) +
                IFNULL(a.absent, 0) +
                IFNULL(a.holiday, 0) +
                IFNULL(a.half_day, 0)
            )
        ) AS unmarked_days

    FROM (
        SELECT 
            DATE_FORMAT(d.month_start, '%m') AS month_str,
            DATE_FORMAT(d.month_start, '%b-%Y') AS month_display,
            DAY(LAST_DAY(d.month_start)) AS total_month_days,
            d.month_start AS sort_date
        FROM (
            SELECT DATE_ADD('2025-06-01', INTERVAL n MONTH) AS month_start
            FROM (
                SELECT 0 AS n UNION ALL SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 3
                UNION ALL SELECT 4 UNION ALL SELECT 5 UNION ALL SELECT 6 UNION ALL SELECT 7
                UNION ALL SELECT 8 UNION ALL SELECT 9 UNION ALL SELECT 10
            ) AS nums
        ) AS d
        WHERE d.month_start BETWEEN '2025-06-01' AND '2026-04-30'
    ) AS m

    LEFT JOIN (
        SELECT 
            DATE_FORMAT(sa.date, '%m') AS month_str,
            SUM(CASE WHEN sa.attendence_type_id = 1 THEN 1 ELSE 0 END) AS present,
            SUM(CASE WHEN sa.attendence_type_id = 2 THEN 1 ELSE 0 END) AS late_with_excuse,
            SUM(CASE WHEN sa.attendence_type_id = 3 THEN 1 ELSE 0 END) AS late,
            SUM(CASE WHEN sa.attendence_type_id = 4 THEN 1 ELSE 0 END) AS absent,
            SUM(CASE WHEN sa.attendence_type_id = 5 THEN 1 ELSE 0 END) AS holiday,
            SUM(CASE WHEN sa.attendence_type_id = 6 THEN 1 ELSE 0 END) AS half_day,
            SUM(CASE WHEN DAYOFWEEK(sa.date) = 1 THEN 1 ELSE 0 END) AS sunday_count
        FROM 
            student_attendences sa
        JOIN 
            student_session ss ON sa.student_session_id = ss.id
        WHERE 
            ss.session_id = '" . $currentSessionId . "'
            AND ss.student_id = '" . $student . "'
            AND sa.date BETWEEN '2025-06-06' AND '2026-04-30'
        GROUP BY 
            DATE_FORMAT(sa.date, '%m')
    ) AS a ON m.month_str = a.month_str

    ORDER BY m.sort_date";

    $query = $this->db->query($sql);
    $data['attendaceDataByStudentID'] = $query->result_array();
    $data['currentSessionName'] = $this->setting_model->getCurrentSessionName();
    $data['studentDetails'] = $this->student_model->getStudentDetailsWithSession($studentid, $currentSessionId);

    $this->load->view('student/printattendence', $data);
}

   // Arun Rajput - New added function for  montlyAttendence record  end  
   
   
   
    // Arun Rajput - New added function for  certificatecountlist record  start 
   
    
    public function certificatecountlist()
{
   
    $sessionid = $this->setting_model->getCurrentSession();

    $this->session->set_userdata('top_menu', 'Reports');
    $this->session->set_userdata('sub_menu', 'Student/certificatecountlist');
    $data['title'] = 'Certificate count list';

    // Build the query with joins
    $this->db->select('
        certificatecounts.*,
        students.firstname,
        students.lastname,
        students.middlename,
         students.father_name,
        students.admission_no,
        students.gender,
        student_session.class_id,
        student_session.section_id,
        classes.class as class_name,
        sections.section as section_name,
        staff.name as staff_name
    ');
    $this->db->from('certificatecounts');
    $this->db->join('students', 'students.id = certificatecounts.student_id');
    $this->db->join('student_session', 'student_session.student_id = students.id');
    $this->db->join('classes', 'classes.id = student_session.class_id');
    $this->db->join('sections', 'sections.id = student_session.section_id');
    $this->db->join('staff', 'staff.id = certificatecounts.user_id', 'left'); // join with staff table
    $this->db->where('certificatecounts.sessionid', $sessionid);

    $query = $this->db->get();
    $data['certificatecounts'] = $query->result();


    // Load views
     $data['leaving_count'] = $this->setting_model->get_certificate_count_by_type('Leaving');
   $data['bonafide_count'] = $this->setting_model->get_certificate_count_by_type('Bonafied');

   $data['entry_count']   = $this->setting_model->get_certificate_count_by_type('Entry');
    $this->load->view('layout/header', $data);
    $this->load->view('student/certificatecountlist', $data);
    $this->load->view('layout/footer', $data);
}

    // Arun Rajput - New added function for  certificatecountlist record  start

    // Arun Rajput - New added function for  updateStudentDetails record  start

public function updateStudentDetails() {
  
  $student_id = $this->input->post('student_id');
    
    if (empty($student_id)) {
        echo json_encode(['status' => 'error', 'message' => 'Student ID is missing.']);
        return;
    }

    // List of all expected fields
    $fields = [
        'adhar_no', 'mother_name',
        'nationality', 'mother_tongue', 'religion', 'cast', 'subcas',
        'place_of_birth', 'birth_taluka', 'birth_district',
        'prev_school_name', 'prev_school_standard_covered','admission_date',
        'class_studing_since_when', 'academic_preference', 'academic_conduct',
        'reason_of_leaving', 'remarks', 'studentapaarId','prev_school_tcnumber','dob','date_of_leaving','prev_school_dateofleaving'
    ];

    $updateData = [];

    // Add only non-null and non-empty fields
    foreach ($fields as $field) {
        $value = $this->input->post($field);
        if ($value !== null && $value !== '') {
            $updateData[$field] = $value;
        }
    }

    // Update DB
    $this->db->where('id', $student_id);
    $result = $this->db->update('students', $updateData);

    if ($result) {
        echo json_encode(['status' => 'success']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update student details.']);
    }
}

  // Arun Rajput - New added function for  updateStudentDetails record  end
  
  
  public function formalstudent()
{
    $this->session->set_userdata('top_menu', 'alumni');
    $this->session->set_userdata('sub_menu', 'Student/formalstudent');

    $this->load->database();

    $query = $this->db->get('generalcertificate');
    $data['certificates'] = $query->result(); // Make sure it's result(), not result_array()

    $this->load->view('layout/header');
    $this->load->view('student/formalstudent', $data); // Must pass $data
    $this->load->view('layout/footer');
}


public function showformalstudent($id)
{
    // Fetch single record based on ID
    $this->db->where('id', $id);
    $query = $this->db->get('generalcertificate');

    // Check if record exists
    if ($query->num_rows() > 0) {
        $data['student'] = $query->row(); // Fetch as object
    } else {
        show_404(); // Record not found
        return;
    }

    // Load different view based on the 'type' field
    if (strtolower($data['student']->type) == 'exit') {
        $this->load->view('student/formalstudentshow', $data);
    } else {
        $this->load->view('student/formalstudentshowenrty', $data);
    }
}




// this code is add by ARUN for sequentially based on alphabetical order  start
public function arrange_section()
{
    $class_id = $this->input->post('class_id');
    $section_id = $this->input->post('section_id');
    $currentsessionid = $this->setting_model->getCurrentSession();

    // Step 1: Get female students first, then male students, all ordered by firstname
    $students = $this->db->select('students.id, students.firstname, students.gender')
        ->from('student_session')
        ->join('students', 'students.id = student_session.student_id')
        ->where('student_session.class_id', $class_id)
        ->where('student_session.section_id', $section_id)
        ->where('student_session.session_id', $currentsessionid)
        ->order_by("FIELD(students.gender, 'Female', 'Male')", '', false) // Female first
        ->order_by('students.firstname', 'ASC')
        ->get()
        ->result();

    if (empty($students)) {
        echo json_encode([
            'status' => 'error',
            'message' => 'No students found for the selected class and section.'
        ]);
        return;
    }

    // Step 2: Assign roll numbers
    $roll_no = 1;
    foreach ($students as $student) {
        $this->db->where('id', $student->id);
        $this->db->update('students', ['roll_no' => $roll_no]);
        $roll_no++;
    }

    echo json_encode([
        'status' => 'success',
        'message' => 'Roll numbers updated successfully for ' . count($students) . ' students.',
        'total_updated' => count($students)
    ]);
}
// this code is add by ARUN for sequentially based on alphabetical order end



public function genaralRegister()

    {

        if (!$this->rbac->hasPrivilege('student', 'can_view')) {

            access_denied();

        }


        $this->session->set_userdata('top_menu', 'Student Information');

        $this->session->set_userdata('sub_menu', 'student/genaralRegister');

        $data['title']           = 'Genaral Register';

        

        $data ['students'] = $this->student_model->get_all_students();
        

        $this->load->view('layout/header', $data);

        $this->load->view('student/genaralregister', $data);

        $this->load->view('layout/footer', $data);





    }
    
   public function genaralRegisterprint()
    
    

    {

        if (!$this->rbac->hasPrivilege('student', 'can_view')) {

            access_denied();

        }



        $this->session->set_userdata('top_menu', 'Student Information');

        $this->session->set_userdata('sub_menu', 'student/genaralRegister');

        $data['title']           = 'Genaral Register';

        $data['setting_result'] = $this->setting_model->get();
          $data['currentSessionName'] = $this->setting_model->getCurrentSessionName();




      
         $data ['student'] = $this->student_model->get_all_students();
        

        

        $this->load->view('student/genaralRegisterprint', $data);

  





    }
    
    
    
public function get_name_suggestions() {
    $keyword = $this->input->post('keyword');
    $target_field = $this->input->post('target_field');

    if (empty($keyword)) {
        echo '<div class="suggestion-item">Please enter a keyword</div>';
        return;
    }

    $translated = $this->google_translate_text($keyword, 'en', 'mr');

    if (!empty($translated) && isset($translated[0]['translatedText'])) {
        $marathi = htmlspecialchars($translated[0]['translatedText']);
        echo '<div class="suggestion-item" data-english="' . htmlspecialchars($keyword) . '" data-marathi="' . $marathi . '" data-target="' . $target_field . '">'
            . htmlspecialchars($keyword) . ' → ' . $marathi .
            '</div>';
    } else {
        echo '<div class="suggestion-item">Translation failed or no suggestions found</div>';
    }
}



public function google_translate_text($text = '', $source = 'en', $target = 'mr') {
    if (empty($text)) return null;

    $apiKey = 'AIzaSyAOSTQg0ry5bzwoxPTjdkciH1G_RFIOHy4'; // Replace with your actual API key
    $url = 'https://translation.googleapis.com/language/translate/v2';

    $fields = [
        'q' => $text,
        'source' => $source,
        'target' => $target,
        'format' => 'text',
        'key' => $apiKey
    ];

    $handle = curl_init();
    curl_setopt($handle, CURLOPT_URL, $url);
    curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($handle, CURLOPT_POST, true);
    curl_setopt($handle, CURLOPT_POSTFIELDS, http_build_query($fields));
    curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, 0);

    $response = curl_exec($handle);
    if (curl_errno($handle)) {
        log_message('error', 'cURL error: ' . curl_error($handle));
    }

    $responseDecoded = json_decode($response, true);
    $responseCode = curl_getinfo($handle, CURLINFO_HTTP_CODE);
    curl_close($handle);

    if ($responseCode != 200 || !isset($responseDecoded['data']['translations'][0]['translatedText'])) {
        log_message('error', 'Google Translate API error: ' . $response);
        return null;
    }

    return $responseDecoded['data']['translations'];
}



public function get_castes_by_category()
{
    $category_id = $this->input->post('category_id');
    
    
   
    $castes = $this->student_model->get_castes_by_category($category_id);
    
    // echo "Total records found: " . count($castes);
    // print_r($castes);
    // die();
    
    

    echo json_encode($castes);
}


    
public function updateStudentData()
{
    $session = $this->setting_model->getCurrentSession();
    $id = $this->input->post('id');

    $admission_no = $this->input->post('admission_no');

    // Check if admission_no already exists for another student
    $this->db->where('admission_no', $admission_no);
    $this->db->where('id !=', $id); // exclude current student
    $query = $this->db->get('students');

    if ($query->num_rows() > 0) {
        echo json_encode(['status' => false, 'message' => 'Admission number already exists.']);
        return;
    }

    // Prepare updated student data
    $data = array(
        'firstname'        => $this->input->post('first_name'),
        'lastname'         => $this->input->post('last_name'),
        'father_name'      => $this->input->post('father_name'),
        'mobileno'         => $this->input->post('mobileno'),
        'father_phone'     => $this->input->post('father_phone'),
        'dob'              => $this->input->post('dob'),
        'current_address'  => $this->input->post('current_address'),
        'admission_no'     => $admission_no,
    );

    $this->student_model->update_student_by_id($id, $data);

    $class_id = $this->input->post('class_id');
    $section_id = $this->input->post('section_id');

    $this->db->where('student_id', $id);
    $this->db->where('session_id', $session);
    $this->db->update('student_session', [
        'class_id'   => $class_id,
        'section_id' => $section_id
    ]);

    // Get updated student details
    $student_details = $this->student_model->get($id);

    // QR Code Generation (if not exists)
    if (empty($student_details['student_qr'])) {
        $hex_data  = bin2hex($admission_no);
        $save_name = $hex_data . '.png';
        $qr_dir = 'uploads/student_id_card/qrcode/';

        if (!file_exists(FCPATH . $qr_dir)) {
            mkdir(FCPATH . $qr_dir, 0775, true);
        }

        $this->load->library('ciqrcode');
        $config = [
            'cacheable' => true,
            'imagedir'  => $qr_dir,
            'quality'   => true,
            'size'      => 1024,
            'black'     => [255, 255, 255],
            'white'     => [255, 255, 255],
        ];
        $this->ciqrcode->initialize($config);

        $params = [
            'data'     => $admission_no,
            'level'    => 'L',
            'size'     => 10,
            'savename' => FCPATH . $qr_dir . $save_name
        ];

        if ($this->ciqrcode->generate($params)) {
            $this->db->where('id', $id);
            $this->db->update('students', ['student_qr' => $qr_dir . $save_name]);
        }
    }

    // Barcode Generation (if not exists)
    if (empty($student_details['student_barcode'])) {
        $barcode_dir = 'uploads/student_id_card/barcodes/';
        $file_path = FCPATH . $barcode_dir . $admission_no . '.png';

        if (!file_exists(FCPATH . $barcode_dir)) {
            mkdir(FCPATH . $barcode_dir, 0777, true);
        }

        $this->load->library('Zend');
        $this->zend->load('Zend/Barcode');

        $barcodeOptions  = ['text' => $admission_no];
        $rendererOptions = [];

        $imageResource = Zend_Barcode::factory('code128', 'image', $barcodeOptions, $rendererOptions)->draw();

        if ($imageResource) {
            imagepng($imageResource, $file_path);
            imagedestroy($imageResource);

            $this->db->where('id', $id);
            $this->db->update('students', ['student_barcode' => $barcode_dir . $admission_no . '.png']);
        }
    }

    // Return success
    echo json_encode(['status' => true]);
}



 function getStudentData($student_id)
{
    $this->load->model('Student_model');
    $student = $this->student_model->get($student_id);

    // Format DOB
    if (!empty($student['dob']) && $student['dob'] != '0000-00-00') {
        $student['dob'] = date(
            $this->customlib->getSchoolDateFormat(),
            strtotime($student['dob'])
        );
    } else {
        $student['dob'] = ''; // empty if invalid
    }

    echo json_encode($student);
}
    
    function idCarddateStudentData()
    {
        $id = $this->input->post('id');
        $data = array(
            'firstname' => $this->input->post('first_name'),
            'lastname' => $this->input->post('last_name'),
            'father_name' => $this->input->post('father_name'),
            'mobileno' => $this->input->post('mobileno'),
              'blood_group' => $this->input->post('blood_group'),
            'father_phone' => $this->input->post('father_phone'),
     'dob'  => $this->customlib->dateFormatToYYYYMMDD($this->input->post('dob')),
            'current_address' => $this->input->post('current_address')   // Add other fields
                    );
                    
                    
                    // Get updated student details
    $student_details = $this->student_model->get($id);

    // QR Code Generation (if not exists)
    if (empty($student_details['student_qr'])) {
        $hex_data  = bin2hex($admission_no);
        $save_name = $hex_data . '.png';
        $qr_dir = 'uploads/student_id_card/qrcode/';

        if (!file_exists(FCPATH . $qr_dir)) {
            mkdir(FCPATH . $qr_dir, 0775, true);
        }

        $this->load->library('ciqrcode');
        $config = [
            'cacheable' => true,
            'imagedir'  => $qr_dir,
            'quality'   => true,
            'size'      => 1024,
            'black'     => [255, 255, 255],
            'white'     => [255, 255, 255],
        ];
        $this->ciqrcode->initialize($config);

        $params = [
            'data'     => $admission_no,
            'level'    => 'L',
            'size'     => 10,
            'savename' => FCPATH . $qr_dir . $save_name
        ];

        if ($this->ciqrcode->generate($params)) {
            $this->db->where('id', $id);
            $this->db->update('students', ['student_qr' => $qr_dir . $save_name]);
        }
    }

    // Barcode Generation (if not exists)
    if (empty($student_details['student_barcode'])) {
        $barcode_dir = 'uploads/student_id_card/barcodes/';
        $file_path = FCPATH . $barcode_dir . $admission_no . '.png';

        if (!file_exists(FCPATH . $barcode_dir)) {
            mkdir(FCPATH . $barcode_dir, 0777, true);
        }

        $this->load->library('Zend');
        $this->zend->load('Zend/Barcode');

        $barcodeOptions  = ['text' => $admission_no];
        $rendererOptions = [];

        $imageResource = Zend_Barcode::factory('code128', 'image', $barcodeOptions, $rendererOptions)->draw();

        if ($imageResource) {
            imagepng($imageResource, $file_path);
            imagedestroy($imageResource);

            $this->db->where('id', $id);
            $this->db->update('students', ['student_barcode' => $barcode_dir . $admission_no . '.png']);
        }
    }

    
        $this->student_model->update_student_by_id($id, $data);
       echo json_encode(['status' => true]);
    }

}

