<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Smsconfig extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        if (!$this->rbac->hasPrivilege('sms_setting', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'System Settings');
        $this->session->set_userdata('sub_menu', 'smsconfig/index');
        $data['title']      = 'SMS Config List';
        $sms_result         = $this->smsconfig_model->get();
        $data['statuslist'] = $this->customlib->getStatus();
        $data['smslist']    = $sms_result;
        $this->load->view('layout/header', $data);
        $this->load->view('smsconfig/smsList', $data);
        $this->load->view('layout/footer', $data);
    }

    public function clickatell()
    {
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('clickatell_user', $this->lang->line('username'), 'required');
        $this->form_validation->set_rules('clickatell_password', $this->lang->line('password'), 'required');
        $this->form_validation->set_rules('clickatell_api_id', $this->lang->line('api_id'), 'required');
        $this->form_validation->set_rules('clickatell_status', $this->lang->line('status'), 'required');
        if ($this->form_validation->run()) {

            $data = array(
                'type'      => 'clickatell',
                'username'  => $this->input->post('clickatell_user'),
                'password'  => $this->input->post('clickatell_password'),
                'api_id'    => $this->input->post('clickatell_api_id'),
                'is_active' => $this->input->post('clickatell_status'),
            );
            $this->smsconfig_model->add($data);
            echo json_encode(array('st' => 0, 'msg' => $this->lang->line('update_message')));
        } else {

            $data = array(
                'clickatell_user'     => form_error('clickatell_user'),
                'clickatell_password' => form_error('clickatell_password'),
                'clickatell_api_id'   => form_error('clickatell_api_id'),
                'clickatell_status'   => form_error('clickatell_status'),
            );

            echo json_encode(array('st' => 1, 'msg' => $data));
        }
    }

    public function twilio()
    {
        $this->form_validation->set_error_delimiters('', '');

        $this->form_validation->set_rules('twilio_account_sid', $this->lang->line('twilio_account_sid'), 'required');
        $this->form_validation->set_rules('twilio_auth_token', $this->lang->line('authentication_token'), 'required');
        $this->form_validation->set_rules('twilio_sender_phone_number', $this->lang->line('registered_phone_number'), 'required');
        $this->form_validation->set_rules('twilio_status', $this->lang->line('status'), 'required');

        if ($this->form_validation->run()) {

            $data = array(
                'type'      => 'twilio',
                'api_id'    => $this->input->post('twilio_account_sid'),
                'password'  => $this->input->post('twilio_auth_token'),
                'contact'   => $this->input->post('twilio_sender_phone_number'),
                'is_active' => $this->input->post('twilio_status'),
            );
            $this->smsconfig_model->add($data);
            echo json_encode(array('st' => 0, 'msg' => $this->lang->line('update_message')));
        } else {

            $data = array(
                'twilio_account_sid'         => form_error('twilio_account_sid'),
                'twilio_auth_token'          => form_error('twilio_auth_token'),
                'twilio_sender_phone_number' => form_error('twilio_sender_phone_number'),
                'twilio_status'              => form_error('twilio_status'),
            );

            echo json_encode(array('st' => 1, 'msg' => $data));
        }
    }

    public function custom()
    {
        $this->form_validation->set_error_delimiters('', '');

        $this->form_validation->set_rules('name', $this->lang->line('name'), 'required');
        $this->form_validation->set_rules('custom_status', $this->lang->line('status'), 'required');

        if ($this->form_validation->run()) {

            $data = array(
                'type'      => 'custom',
                'name'      => $this->input->post('name'),
                'is_active' => $this->input->post('custom_status'),
            );
            $this->smsconfig_model->add($data);
            echo json_encode(array('st' => 0, 'msg' => $this->lang->line('update_message')));
        } else {

            $data = array(
                'name'          => form_error('name'),
                'custom_status' => form_error('custom_status'),
            );

            echo json_encode(array('st' => 1, 'msg' => $data));
        }
    }

    public function msgnineone()
    {
        $this->form_validation->set_error_delimiters('', '');

        $this->form_validation->set_rules('authkey', $this->lang->line('auth_key'), 'required');
        $this->form_validation->set_rules('senderid', $this->lang->line('sender_id'), 'required');
        $this->form_validation->set_rules('msg_nineone_status', $this->lang->line('status'), 'required');

        if ($this->form_validation->run()) {

            $data = array(
                'type'      => 'msg_nineone',
                'authkey'   => $this->input->post('authkey'),
                'senderid'  => $this->input->post('senderid'),
                'is_active' => $this->input->post('msg_nineone_status'),
            );
            $this->smsconfig_model->add($data);
            echo json_encode(array('st' => 0, 'msg' => $this->lang->line('update_message')));
        } else {

            $data = array(
                'authkey'            => form_error('authkey'),
                'senderid'           => form_error('senderid'),
                'msg_nineone_status' => form_error('msg_nineone_status'),
            );

            echo json_encode(array('st' => 1, 'msg' => $data));
        }
    }

    public function smscountry()
    {
        $this->form_validation->set_error_delimiters('', '');

        $this->form_validation->set_rules('smscountry', $this->lang->line('username'), 'required');
        $this->form_validation->set_rules('smscountrypassword', $this->lang->line('password'), 'required');
        $this->form_validation->set_rules('smscountrysenderid', $this->lang->line('sender_id'), 'required');
        $this->form_validation->set_rules('smscountry_status', $this->lang->line('status'), 'required');
        $this->form_validation->set_rules('smscountryauthKey', $this->lang->line('auth_Key'), 'required');
        $this->form_validation->set_rules('smscountryauthtoken', $this->lang->line('authentication_token'), 'required');

        if ($this->form_validation->run()) {

            $data = array(
                'type'      => 'smscountry',
                'username'  => $this->input->post('smscountry'),
                'password'  => $this->input->post('smscountrypassword'),
                'senderid'  => $this->input->post('smscountrysenderid'),
                'is_active' => $this->input->post('smscountry_status'),
                'authkey'   => $this->input->post('smscountryauthKey'),
                'api_id'    => $this->input->post('smscountryauthtoken'),
            );
            $this->smsconfig_model->add($data);
            echo json_encode(array('st' => 0, 'msg' => $this->lang->line('update_message')));
        } else {

            $data = array(
                'smscountry'            => form_error('smscountry'),
                'smscountrypassword'    => form_error('smscountrypassword'),
                'smscountrysenderid'    => form_error('smscountrysenderid'),
                'smscountry_status'     => form_error('smscountry_status'),
                'smscountryauthKey'     => form_error('smscountryauthKey'),
                'smscountryauthtoken'   => form_error('smscountryauthtoken'),
            );

            echo json_encode(array('st' => 1, 'msg' => $data));
        }
    }

    public function textlocal()
    {
        $this->form_validation->set_error_delimiters('', '');

        $this->form_validation->set_rules('text_local', $this->lang->line('username'), 'required');
        $this->form_validation->set_rules('text_localpassword', $this->lang->line('password'), 'required');
        $this->form_validation->set_rules('text_localsenderid', $this->lang->line('sender_id'), 'required');
        $this->form_validation->set_rules('text_local_status', $this->lang->line('status'), 'required');

        if ($this->form_validation->run()) {

            $data = array(
                'type'      => 'text_local',
                'username'  => $this->input->post('text_local'),
                'password'  => $this->input->post('text_localpassword'),
                'senderid'  => $this->input->post('text_localsenderid'),
                'is_active' => $this->input->post('text_local_status'),
            );
            $this->smsconfig_model->add($data);
            echo json_encode(array('st' => 0, 'msg' => $this->lang->line('update_message')));
        } else {

            $data = array(
                'text_local'         => form_error('text_local'),
                'text_localpassword' => form_error('text_localpassword'),
                'text_localsenderid' => form_error('text_localsenderid'),
                'text_local_status'  => form_error('text_local_status'),
            );

            echo json_encode(array('st' => 1, 'msg' => $data));
        }
    }

    public function bulk_sms()
    {
        $this->form_validation->set_error_delimiters('', '');

        $this->form_validation->set_rules('bulk_sms_user_name', $this->lang->line('username'), 'required');
        $this->form_validation->set_rules('bulk_sms_user_password', $this->lang->line('password'), 'required');
        $this->form_validation->set_rules('bulk_sms_status', $this->lang->line('status'), 'required');

        if ($this->form_validation->run()) {

            $data = array(
                'type'      => 'bulk_sms',
                'username'  => $this->input->post('bulk_sms_user_name'),
                'password'  => $this->input->post('bulk_sms_user_password'),
                'is_active' => $this->input->post('bulk_sms_status'),
            );
            $this->smsconfig_model->add($data);
            echo json_encode(array('st' => 0, 'msg' => $this->lang->line('update_message')));
        } else {

            $data = array(
                'bulk_sms_user_name'     => form_error('bulk_sms_user_name'),
                'bulk_sms_user_password' => form_error('bulk_sms_user_password'),
                'bulk_sms_status'        => form_error('bulk_sms_status'),
            );

            echo json_encode(array('st' => 1, 'msg' => $data));
        }
    }

    public function mobireach()
    {
        $this->form_validation->set_error_delimiters('', '');

        $this->form_validation->set_rules('mobireach_auth_key', $this->lang->line('auth_Key'), 'required');
        $this->form_validation->set_rules('mobireach_sender_id', $this->lang->line('sender_id'), 'required');
        $this->form_validation->set_rules('mobireach_route_id', $this->lang->line('route_id'), 'required');
        $this->form_validation->set_rules('mobireach_status', $this->lang->line('status'), 'required');

        if ($this->form_validation->run()) {

            $data = array(
                'type'      => 'mobireach',
                'authkey'   => $this->input->post('mobireach_auth_key'),
                'senderid'  => $this->input->post('mobireach_sender_id'),
                'api_id'    => $this->input->post('mobireach_route_id'),
                'is_active' => $this->input->post('mobireach_status'),
            );
            $this->smsconfig_model->add($data);
            echo json_encode(array('st' => 0, 'msg' => $this->lang->line('update_message')));

        } else {

            $data = array(
                'mobireach_auth_key'  => form_error('mobireach_auth_key'),
                'mobireach_sender_id' => form_error('mobireach_sender_id'),
                'mobireach_route_id'  => form_error('mobireach_route_id'),
                'mobireach_status'    => form_error('mobireach_status'),
            );

            echo json_encode(array('st' => 1, 'msg' => $data));
        }
    }

     public function nexmo()
     {      
        $this->form_validation->set_error_delimiters('', '');

        $this->form_validation->set_rules('nexmo_api_key', $this->lang->line('nexmo_api_key'), 'required');
        $this->form_validation->set_rules('nexmo_api_secret', $this->lang->line('nexmo_api_secret'), 'required');
        $this->form_validation->set_rules('nexmo_registered_phone_number', $this->lang->line('nexmo_registered_phone_number'), 'required');
        $this->form_validation->set_rules('nexmo_status', $this->lang->line('status'), 'required');

        if ($this->form_validation->run()) {

            $data = array(
                'type'      => 'nexmo',
                'authkey'   => $this->input->post('nexmo_api_secret'),
                'senderid'  => $this->input->post('nexmo_registered_phone_number'),
                'api_id'    => $this->input->post('nexmo_api_key'),
                'is_active' => $this->input->post('nexmo_status'),
            );
            $this->smsconfig_model->add($data);
            echo json_encode(array('st' => 0, 'msg' => $this->lang->line('update_message')));

        } else { 

            $data = array(
                'nexmo_api_secret'  => form_error('nexmo_api_secret'),
                'nexmo_registered_phone_number' => form_error('nexmo_registered_phone_number'),
                'nexmo_api_key'  => form_error('nexmo_api_key'),
                'nexmo_status'    => form_error('nexmo_status'),
            );

            echo json_encode(array('st' => 1, 'msg' => $data));
        }
     }

      public function africastalking()
      {      
        $this->form_validation->set_error_delimiters('', '');

        $this->form_validation->set_rules('africastalking_username', $this->lang->line('africastalking_username'), 'required');
        $this->form_validation->set_rules('africastalking_apikey', $this->lang->line('africastalking_apikey'), 'required');
        $this->form_validation->set_rules('africastalking_status', $this->lang->line('status'), 'required');

        if ($this->form_validation->run()) {

            $data = array(
                'type'      => 'africastalking',
                'username'   => $this->input->post('africastalking_username'),
                'api_id'  => $this->input->post('africastalking_apikey'),
                'senderid'    => $this->input->post('africastalking_short_code'),
                'is_active' => $this->input->post('africastalking_status'),
            );
            $this->smsconfig_model->add($data);
            echo json_encode(array('st' => 0, 'msg' => $this->lang->line('update_message')));

        } else {

            $data = array(
                'africastalking_username'  => form_error('africastalking_username'),
                'africastalking_apikey' => form_error('africastalking_apikey'),
                'africastalking_status'    => form_error('africastalking_status'),
            );

            echo json_encode(array('st' => 1, 'msg' => $data));
        }
     }

    public function smseg()
    {      
        $this->form_validation->set_error_delimiters('', '');

        $this->form_validation->set_rules('smseg_username', $this->lang->line('username'), 'required');
        $this->form_validation->set_rules('smseg_password', $this->lang->line('password'), 'required');
        $this->form_validation->set_rules('smseg_sender_id', $this->lang->line('sender_id'), 'required');
        $this->form_validation->set_rules('smseg_type', $this->lang->line('type'), 'required');

        $this->form_validation->set_rules('smseg_status', $this->lang->line('status'), 'required');

        if ($this->form_validation->run()) {
            $url=$this->input->post('smseg_type');

            $data = array(
                'type'      => 'smseg',
                'username'   => $this->input->post('smseg_username'),
                'password'  => $this->input->post('smseg_password'),
                'senderid'    => $this->input->post('smseg_sender_id'),
                'is_active' => $this->input->post('smseg_status'),
                'url'=>$url,
            );
            $this->smsconfig_model->add($data);
            echo json_encode(array('st' => 0, 'msg' => $this->lang->line('update_message')));

        } else {

            $data = array(
                'smseg_username'  => form_error('smseg_username'),
                'smseg_password' => form_error('smseg_password'),
                'smseg_sender_id'    => form_error('smseg_sender_id'),
                'smseg_status'    => form_error('smseg_status'),
                'smseg_type'    => form_error('smseg_type'),
            );

            echo json_encode(array('st' => 1, 'msg' => $data));
        }
     }
  // add system setting in certificate setting = anil start

        public function addCertficate($data)
    {
        $this->db->where('cert_type', $data['cert_type']);
        $this->db->where('inst_type', $data['inst_type']);
        $q = $this->db->get('cert_settings');

        if ($q->num_rows() > 0)
        {
            $this->db->where('cert_type', $data['cert_type']);
            $this->db->where('inst_type', $data['inst_type']);
            $data['updated_ts'] = date('Y-m-d h:i:s');
            $this->db->update('cert_settings', $data);
        }
        else
        {
            $this->db->insert('cert_settings', $data);
        }
        //if ($data['is_active'] == "enabled") {
        //$this->changeStatus($data['type']);
        //}
    }
    
     public function joinmeeting()
    {
        if (!$this->rbac->hasPrivilege('join_meeting', 'can_view'))
        {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'onlinemeeting');
        $this->session->set_userdata('sub_menu', 'smsconfig/joinmeeting');
        $data['title'] = 'Online Meeting Config List';
//        $sms_result = $this->smsconfig_model->get();
//        $meeting_result = get_list('meeting_config', array('ctid' => 1), null, null, 0, 'state', 'ASC');

        $meetingList = get_list('meeting_config', array('meet_attendee' => 'staff', 'is_active' => 'enabled'), null, null, 0, 'meetdate', 'desc');
        $data['statuslist'] = $this->customlib->getStatus();
        $data['SMSCreditBalance'] = 0;
        $data['smslist'] = $meetingList;
        $userdata = $this->customlib->getUserData();
        $data['userid'] = isset($userdata['id']) ? $userdata['id'] : 0;
        $data['attendee'] = 'staff';
        $this->load->view('layout/header', $data);
        $this->load->view('smsconfig/join_meeting', $data);
        $this->load->view('layout/footer', $data);
    }

    public function getMeetingMembers($data = '')
    {
        $attendee = $this->input->post('attendee');
        if (!valid($attendee) || empty($attendee))
        {
//            $d = array(array("id"=> "1","name"=>"mmmm"));
            $d = ''; //no result
            $aa = array("success" => false, "data" => json_encode($d));
            echo json_encode($aa);
//            echo '{"success":false,"data":"[{\"id\":\"43\",\"name\":\"banglore\"}]"}';
            //echo '{"success":false,"data":"'.  json_encode($d).'"}';
            exit();
        }
        $search_text = $this->input->post('name');
        $searchdata = array();
        if ($attendee == 'student')
        {
            $class = $this->class_model->get();
            $carray = array();
            if (!empty($class))
            {
                foreach ($class as $ckey => $cvalue)
                {

                    $carray[] = $cvalue["id"];
                }
            }
            $resultlist = $this->student_model->searchFullText($search_text, $carray);
            if (valid($resultlist) && !empty($resultlist))
            {
                foreach ($resultlist as $student)
                {
                    array_push($searchdata, array("id" => $student['id'], "name" => $student['firstname'] . " " . $student['lastname']));
                }
            }
        }
        elseif ($attendee == 'staff')
        {
            $resultlist = $this->staff_model->searchFullText($search_text, 1);
            if (valid($resultlist) && !empty($resultlist))
            {
                foreach ($resultlist as $stf)
                {
                    array_push($searchdata, array("id" => $stf['id'], "name" => $stf['name'] . " " . $stf['surname']));
                }
            }
        }
        $aa = array("success" => true, "data" => json_encode($searchdata));
        echo json_encode($aa);
        exit;
    }
     function meetingsetup()
    {
        if (!$this->rbac->hasPrivilege('general_setting', 'can_edit'))
        {
            //access_denied();
        }
        $this->session->set_userdata('top_menu', 'onlinemeeting');
        $this->session->set_userdata('sub_menu', 'smsconfig/meetingsetup');
        $data['title'] = 'Online Meeting Config List';
//        $sms_result = $this->smsconfig_model->get();
//        $meeting_result = get_list('meeting_config', array('ctid' => 1), null, null, 0, 'state', 'ASC');

        $current_session = $this->setting_model->getCurrentSession();
        $meetingList = get_list('meeting_config', array('session_id' => $current_session));
        $data['statuslist'] = $this->customlib->getStatus();
        $data['SMSCreditBalance'] = 0;
        $class = $this->class_model->get('', $classteacher = 'yes');
        $data['classlist'] = $class;

        $section_result = $this->section_model->get();
        $data['sectionlist'] = $section_result;
//echo '<pre>';print_r($class);print_r($section_result);exit;
        $data['smslist'] = $meetingList;
        $this->load->view('layout/header', $data);
        $this->load->view('smsconfig/meetingList', $data);
        $this->load->view('layout/footer', $data);
    }

    function editmeetingsetup($id = '')
    {
        if (!$this->rbac->hasPrivilege('general_setting', 'can_edit'))
        {
            //access_denied();
        }
        $this->session->set_userdata('top_menu', 'onlinemeeting');
        $this->session->set_userdata('sub_menu', 'smsconfig/meetingsetup');
        $data['title'] = 'Online Meeting Config List';
//        $sms_result = $this->smsconfig_model->get();
//        $meeting_result = get_list('meeting_config', array('ctid' => 1), null, null, 0, 'state', 'ASC');

        $current_session = $this->setting_model->getCurrentSession();
        $meetingList = get_list('meeting_config', array('session_id' => $current_session));
        $single_meeting = get_list('meeting_config', array('id' => $id, 'session_id' => $current_session));
        if (!valid($single_meeting) || empty($single_meeting))
        {
            redirect('smsconfig/meetingsetup');
        }
        //echo '<pre>';print_r($single_meeting);exit;
        $data['statuslist'] = $this->customlib->getStatus();
        $data['SMSCreditBalance'] = 0;
        $class = $this->class_model->get('', $classteacher = 'yes');
        $data['classlist'] = $class;

        $section_result = $this->section_model->get();
        $data['sectionlist'] = $section_result;
        $meetexcdsArr = array();
        if (valid($single_meeting[0]->meet_excludes) && !empty($single_meeting[0]->meet_excludes))
        {
            $meetexc = explode(',', trim($single_meeting[0]->meet_excludes));
            if ($single_meeting[0]->meet_attendee == 'staff')
            {
                $meetexcds = $this->staff_model->get($meetexc);
                if (!empty($meetexcds))
                {
                    foreach ($meetexcds as $dt)
                    {
                        array_push($meetexcdsArr, array("id" => $dt['id'], "name" => $dt['name'] . " " . $dt['surname']));
                    }
                }
            }
            elseif ($single_meeting[0]->meet_attendee == 'student')
            {
                $meetexcds = $this->student_model->get($meetexc);
                if (!empty($meetexcds))
                {
                    foreach ($meetexcds as $dt)
                    {
                        array_push($meetexcdsArr, array("id" => $dt['id'], "name" => $dt['firstname'] . " " . $dt['lastname']));
                    }
                }
            }
        }
        $data['smslist'] = $meetingList;
        $data['meetexcludes'] = $meetexcdsArr;
        $data['one_meeting'] = $single_meeting[0];
        $this->load->view('layout/header', $data);
        $this->load->view('smsconfig/editmeetingList', $data);
        $this->load->view('layout/footer', $data);
    }

    public function addmeeting()
    {
        
        print_r('dsds');
        die();

        $this->form_validation->set_error_delimiters('', '');

        $this->form_validation->set_rules('name', 'Meeting name', 'required');
        $this->form_validation->set_rules('meet_type', 'Meeting type', 'required');
        $this->form_validation->set_rules('meetdate', 'Meeting Date', 'required');
//        $this->form_validation->set_rules('text_localpassword', 'Password', 'required');
//        $this->form_validation->set_rules('text_localsenderid', 'Sender ID', 'required');
        if ($this->form_validation->run())
        {
            if ($this->input->post('meet_attendee') == 'student' && !valid($this->input->post('std_class_id')))
            {
                echo json_encode(array('st' => 1, 'msg' => array('Please select student class.')));
                exit;
            }
            if ($this->input->post('meet_attendee') == 'student' && !valid($this->input->post('section_id')))
            {
                echo json_encode(array('st' => 1, 'msg' => array('Please select student section.')));
                exit;
            }
            $secid = array();
            if ($this->input->post('meet_attendee') == 'student')
            {
                $secid = $this->input->post('section_id');
                if (!valid($secid) || empty($secid))
                {
                    echo json_encode(array('st' => 1, 'msg' => array('Please select student section.')));
                    exit;
                }
            }
            $sec_id = !empty($secid) ? json_encode($secid) : '';
            $meettype = trim($this->input->post('meet_type'));
            $meetty = '';
            switch ($meettype)
            {
                case 'zoom':
                    $meetty = 'zoom';
                    break;
                case 'google_hangout':
                    $meetty = 'google_hangout';
                    break;
                case 'microsoft_team':
                    $meetty = 'microsoft_team';
                    break;
                default:
                    break;
            }
            $frmtime = trim($this->input->post('fromtime'));
            $totime = trim($this->input->post('totime'));
            if (!valid($frmtime) || empty($frmtime))
            {
                $frmtime = 'null';
            }
            if (!valid($totime) || empty($totime))
            {
                $totime = 'null';
            }
            $current_session = $this->setting_model->getCurrentSession();
            $userdata = $this->customlib->getUserData();

            $data = array(
                'type' => $meetty,
                'name' => $this->input->post('name'),
                'meetdate' => $this->input->post('meetdate'),
                'meettime' => $frmtime . '-' . $totime,
                'senderid' => $this->input->post('senderid'),
                'authkey' => $this->input->post('authkey'),
                'url' => $this->input->post('url'),
                'note' => $this->input->post('note'),
                'meet_attendee' => $this->input->post('meet_attendee'),
                'std_class_id' => $this->input->post('std_class_id'),
//                'std_sec_id' => $this->input->post('section_id'),
                'std_sec_id' => $sec_id,
                'meet_excludes' => $this->input->post('meet_excludes'),
                'session_id' => $current_session,
                'created_by' => isset($userdata['id']) ? $userdata['id'] : 0,
                'is_active' => $this->input->post('custom_status')
            );
            $succ_msg = 'Meeting Submitted Successfully';
            if (valid($this->input->post('meetid')) && !empty($this->input->post('meetid')))
            {
                $data['id'] = $this->input->post('meetid');
                $succ_msg = 'Meeting Updated Successfully';
            }
            $this->smsconfig_model->addMeeting($data);
            echo json_encode(array('st' => 0, 'msg' => "$succ_msg"));
        }
        else
        {

            $data = array(
                'name' => form_error('name'),
                'meet_type' => form_error('meet_type'),
                'meetdate' => form_error('meetdate'),
//                'text_localpassword' => form_error('text_localpassword'),
//                'text_localsenderid' => form_error('text_localsenderid'),
            );
            echo json_encode(array('st' => 1, 'msg' => $data));
        }
    }

  
}