<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Schsettings extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('media_storage');
        $this->load->library('upload');
        
        $this->load->model(array('class_section_time_model','sidebarmenu_model','staffAttendaceSetting_model','attendencetype_model','studentAttendaceSetting_model'));
    }

    public function index()
    { 
       
        if (!$this->rbac->hasPrivilege('general_setting', 'can_view')) {
            access_denied();
        }

        $this->session->set_userdata('top_menu', 'System Settings');
        $this->session->set_userdata('sub_menu', 'schsettings/index');
        $this->session->set_userdata('subsub_menu', 'schsettings/index');

        $timezoneList             = $this->customlib->timezone_list();
        $session_result           = $this->session_model->get();
        $data['sessionlist']      = $session_result;
        $currency_formats         = $this->customlib->currency_format();
        $language_result        = $this->language_model->getEnable_languages();
        $data['states'] = $this->setting_model->get_all_states();
       
        $data['languagelist']   = $language_result;
       
        $month_list               = $this->customlib->getMonthList();
        $days_list                = $this->customlib->getDayList();
        $data['currency_formats'] = $currency_formats;
        $data['daysList']         = $days_list;
        $data['timezoneList']     = $timezoneList;
        $data['monthList']        = $month_list;
        $dateFormat               = $this->customlib->getDateFormat();
        $currency                 = $this->customlib->getCurrency();
        $data['dateFormatList']   = $dateFormat;
        $data['currencyList']     = $currency;
        $currencyPlace            = $this->customlib->getCurrencyPlace();
        $data['currencyPlace']    = $currencyPlace;
        $setting                  = $this->setting_model->getSetting();
        
      
        $setting->base_url        = ($setting->base_url == "") ? base_url() : $setting->base_url;
        $setting->folder_path     = ($setting->folder_path == "") ? FCPATH : $setting->folder_path;
        $data['result']           = $setting;
        
      
     
        $this->load->view('layout/header', $data);
        $this->load->view('setting/settingList', $data);
        $this->load->view('layout/footer', $data);
    }

    // public function ajax_editlogo()
    // {
    //     $this->form_validation->set_rules('id', $this->lang->line('id'), 'trim|required|xss_clean');
    //     $this->form_validation->set_rules('file', $this->lang->line('image'), 'callback_handle_upload');
    //     if ($this->form_validation->run() == false) {
    //         $data = array(
    //             'file' => form_error('file'),
    //         );
    //         $array = array('success' => false, 'error' => $data);
    //         echo json_encode($array);
    //     } else {
    //         $id = $this->input->post('id');

    //         $setting = $this->setting_model->getSetting();

    //         if (isset($_FILES["file"]) && $_FILES['file']['name'] != '' && (!empty($_FILES['file']['name']))) {

    //             $img_name = $this->media_storage->fileupload("file", "./uploads/school_content/logo/");
    //         } else {
    //             $img_name = $setting->image;
    //         }
    //         if (isset($_FILES["file"]) && $_FILES['file']['name'] != '' && (!empty($_FILES['file']['name']))) {

    //             $this->media_storage->filedelete($setting->image, "uploads/school_content/logo");
    //         }

    //         $data_record = array('id' => $id, 'image' => $img_name);
    //         $this->setting_model->add($data_record);
    //         $array = array('success' => true, 'error' => '', 'message' => $this->lang->line('success_message'));
    //         echo json_encode($array);
    //     }
    // }



public function ajax_editlogo()
{
    $this->form_validation->set_rules('id', $this->lang->line('id'), 'trim|required|xss_clean');

    if ($this->form_validation->run() == false) {
        $data = array(
            'file' => form_error('file'),
        );
        $array = array('success' => false, 'error' => $data);
        echo json_encode($array);
        return;
    }

    $id = $this->input->post('id');
    $logo_type = $this->input->post('logo_type');
    
  

    $setting = $this->setting_model->get($id);
    if (!$setting) {
        echo json_encode(['success' => false, 'message' => 'Setting not found']);
        return;
    }

    $img_name = '';
    $data_record = ['id' => $id];

    if (isset($_FILES["file"]) && !empty($_FILES['file']['name'])) {
        $fileInfo = pathinfo($_FILES["file"]["name"]);
        $extension = strtolower($fileInfo['extension']);

        switch ($logo_type) {
            case "logo":
                $img_name = uniqid('logo_', true) . '.' . $extension;
                $upload_path = "./uploads/school_content/logo/";
                if (!empty($setting->image) && file_exists($upload_path . $setting->image)) {
                    unlink($upload_path . $setting->image);
                }
                move_uploaded_file($_FILES["file"]["tmp_name"], $upload_path . $img_name);
                $data_record['image'] = $img_name;
                break;

            case "app_logo":
                $img_name = uniqid('app_logo_', true) . '.' . $extension;
                $upload_path = "./uploads/school_content/logo/app_logo/";
                if (!empty($setting->app_logo) && file_exists($upload_path . $setting->app_logo)) {
                    unlink($upload_path . $setting->app_logo);
                }
                move_uploaded_file($_FILES["file"]["tmp_name"], $upload_path . $img_name);
                $data_record['app_logo'] = $img_name;
                break;

            case "certificate":
                $img_name = uniqid('cert_', true) . '.' . $extension;
                $upload_path = "./uploads/school_content/logo/logo/";
                if (!empty($setting->certificate_logo) && file_exists($upload_path . $setting->certificate_logo)) {
                    unlink($upload_path . $setting->certificate_logo);
                }
                move_uploaded_file($_FILES["file"]["tmp_name"], $upload_path . $img_name);
                $data_record['certificate_logo'] = $img_name;
                break;

            case "pricipal-sign":
                $img_name = uniqid('pricipal_sign_', true) . '.' . $extension;
                $upload_path = "./uploads/school_content/logo/";
                if (!empty($setting->principal_sign) && file_exists($upload_path . $setting->principal_sign)) {
                    unlink($upload_path . $setting->principal_sign);
                }
                move_uploaded_file($_FILES["file"]["tmp_name"], $upload_path . $img_name);
                $data_record['principal_sign'] = $img_name;
                break;

            case "clerk-sign":
                $img_name = uniqid('clerk_sign_', true) . '.' . $extension;
                $upload_path = "./uploads/school_content/logo/";
                if (!empty($setting->clerk_sign) && file_exists($upload_path . $setting->clerk_sign)) {
                    unlink($upload_path . $setting->clerk_sign);
                }
                move_uploaded_file($_FILES["file"]["tmp_name"], $upload_path . $img_name);
                $data_record['clerk_sign'] = $img_name;
                break;

            case "examiner-sign":
                $img_name = uniqid('examiner_sign_', true) . '.' . $extension;
                $upload_path = "./uploads/school_content/logo/";
                if (!empty($setting->examiner_sign) && file_exists($upload_path . $setting->examiner_sign)) {
                    unlink($upload_path . $setting->examiner_sign);
                }
                move_uploaded_file($_FILES["file"]["tmp_name"], $upload_path . $img_name);
                $data_record['examiner_sign'] = $img_name;
                break;

            default:
                echo json_encode(['success' => false, 'error' => '', 'message' => 'Logo type is invalid. Try again later']);
                return;
        }
    } else {
        echo json_encode(['success' => false, 'error' => '', 'message' => 'No file selected.']);
        return;
    }

    $this->setting_model->add($data_record);
    echo json_encode(['success' => true, 'error' => '', 'message' => $this->lang->line('success_message')]);
}



   public function ajax_editadmin_smalllogo()
{
    $this->form_validation->set_rules('id', $this->lang->line('id'), 'trim|required|xss_clean');
    $this->form_validation->set_rules('file', $this->lang->line('image'), 'callback_handle_upload');

    if ($this->form_validation->run() == false) {
        $data = array(
            'file' => form_error('file'),
        );
        $array = array('success' => false, 'error' => $data);
        echo json_encode($array);
    } else {
        $id = $this->input->post('id');
        $setting = $this->setting_model->getSetting();

        $upload_path = "./uploads/school_content/admin_small_logo/";
        if (!is_dir($upload_path)) {
            mkdir($upload_path, 0777, true);
        }

        if (isset($_FILES["file"]) && !empty($_FILES['file']['name'])) {
            $fileInfo = pathinfo($_FILES["file"]["name"]);
            $extension = strtolower($fileInfo['extension']);

            // Generate a unique random filename
            $img_name = uniqid('admin_small_logo_', true) . '.' . $extension;
            $destination = $upload_path . $img_name;

            // Delete old admin small logo if it exists
            if (!empty($setting->admin_small_logo) && file_exists($upload_path . $setting->admin_small_logo)) {
                unlink($upload_path . $setting->admin_small_logo);
            }

            // Move uploaded file
            if (!move_uploaded_file($_FILES["file"]["tmp_name"], $destination)) {
                $array = array('success' => false, 'error' => ['file' => 'Failed to upload image.']);
                echo json_encode($array);
                return;
            }
        } else {
            $img_name = $setting->admin_small_logo; // Use existing image if no file uploaded
        }

        $data_record = array(
            'id' => $id,
            'admin_small_logo' => $img_name
        );

        $this->setting_model->add($data_record);

        $array = array(
            'success' => true,
            'error' => '',
            'message' => $this->lang->line('success_message')
        );
        echo json_encode($array);
    }
}


  public function ajax_editadmin_adminlogo()
{
    $this->form_validation->set_rules('id', $this->lang->line('id'), 'trim|required|xss_clean');
    $this->form_validation->set_rules('file', $this->lang->line('image'), 'callback_handle_upload');

    if ($this->form_validation->run() == false) {
        $data = array(
            'file' => form_error('file'),
        );
        $array = array('success' => false, 'error' => $data);
        echo json_encode($array);
    } else {
        $id = $this->input->post('id');
        $setting = $this->setting_model->getSetting();

        $upload_path = "./uploads/school_content/admin_logo/";
        if (!is_dir($upload_path)) {
            mkdir($upload_path, 0777, true);
        }

        if (isset($_FILES["file"]) && !empty($_FILES['file']['name'])) {
            $fileInfo = pathinfo($_FILES["file"]["name"]);
            $extension = strtolower($fileInfo['extension']);

            // Generate a unique random filename
            $img_name = uniqid('admin_logo_', true) . '.' . $extension;
            $destination = $upload_path . $img_name;

            // Delete old admin logo if it exists
            if (!empty($setting->admin_logo) && file_exists($upload_path . $setting->admin_logo)) {
                unlink($upload_path . $setting->admin_logo);
            }

            // Move uploaded file
            move_uploaded_file($_FILES["file"]["tmp_name"], $destination);
        } else {
            $img_name = $setting->admin_logo;
        }

        $data_record = array('id' => $id, 'admin_logo' => $img_name);
        $this->setting_model->add($data_record);

        $array = array('success' => true, 'error' => '', 'message' => $this->lang->line('success_message'));
        echo json_encode($array);
    }
}



    public function editLogo($id)
    {
        $data['title']       = 'School Logo';
        $setting_result      = $this->setting_model->get();
        $data['settinglist'] = $setting_result;
        $data['id']          = $id;
        $this->form_validation->set_rules('file', $this->lang->line('image'), 'callback_handle_upload');
        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('setting/editLogo', $data);
            $this->load->view('layout/footer', $data);
        } else {
            if (isset($_FILES["file"]) && !empty($_FILES['file']['name'])) {
                $fileInfo = pathinfo($_FILES["file"]["name"]);
                $img_name = $id . '.' . $fileInfo['extension'];
                move_uploaded_file($_FILES["file"]["tmp_name"], "./uploads/school_content/logo/" . $img_name);
            }
            $data_record = array('id' => $id, 'image' => $img_name);
            $this->setting_model->add($data_record);
            $this->session->set_flashdata('msg', '<div class="alert alert-left">' . $this->lang->line('update_message') . '</div>');
            redirect('schsettings/index');
        }
    }

    public function handle_upload()
    {   
        if (isset($_FILES["file"]) && !empty($_FILES['file']['name'])) {
            $allowedExts = array('jpg', 'jpeg', 'png');
            $temp        = explode(".", $_FILES["file"]["name"]);
            $extension   = end($temp);            
            
            if ($_FILES["file"]["error"] > 0) {
                
                $error .= "Error opening the file<br />";
                
            }
            if ($_FILES["file"]["type"] != 'image/gif' &&
                $_FILES["file"]["type"] != 'image/jpeg' &&
                $_FILES["file"]["type"] != 'image/png') {
                
                $this->form_validation->set_message('handle_upload', $this->lang->line('file_type_not_allowed'));
                return false;
            }
            if (!in_array($extension, $allowedExts)) {
               
                $this->form_validation->set_message('handle_upload', $this->lang->line('extension_not_allowed'));
                return false;
            }
            if ($_FILES["file"]["size"] > 1024000) {
                
                $this->form_validation->set_message('handle_upload', $this->lang->line('file_size_shoud_be_less_than') . " 1MB");
                return false;
            }
            return true;
        } else {
            $this->form_validation->set_message('handle_upload', $this->lang->line('logo_file_is_required'));
            return false;
        }
    }

    public function view($id)
    {
        $data['title']   = 'Setting List';
        $setting         = $this->setting_model->get($id);
        $data['setting'] = $setting;
        $this->load->view('layout/header', $data);
        $this->load->view('setting/settingShow', $data);
        $this->load->view('layout/footer', $data);
    }

    public function getSchsetting()
    {
        $data = $this->setting_model->getSetting();
        echo json_encode($data);
    }

    public function generalsetting()
    {
        $this->form_validation->set_rules('currency_format', $this->lang->line('currency_format'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('sch_session_id', $this->lang->line('session'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('sch_name', $this->lang->line('school_name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('sch_phone', $this->lang->line('phone'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('sch_start_month', $this->lang->line('start_month'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('sch_address', $this->lang->line('address'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('sch_email', $this->lang->line('email'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('sch_timezone', $this->lang->line('timezone'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('currency_place', $this->lang->line('currency_place'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('sch_date_format', $this->lang->line('date_format'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('sch_start_week', $this->lang->line('start_day_of_week'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('base_url', $this->lang->line('url'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('folder_path', $this->lang->line('folder_path'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'sch_session_id'  => form_error('sch_session_id'),
                'sch_name'        => form_error('sch_name'),
                'sch_phone'       => form_error('sch_phone'),
                'sch_start_month' => form_error('sch_start_month'),
                'sch_start_week'  => form_error('sch_start_week'),
                'sch_address'     => form_error('sch_address'),
                'sch_email'       => form_error('sch_email'),
                'sch_timezone'    => form_error('sch_timezone'),
                'currency_place'  => form_error('currency_place'),
                'currency_format' => form_error('currency_format'),
                'sch_date_format' => form_error('sch_date_format'),
                'base_url'        => form_error('base_url'),
                'folder_path'     => form_error('folder_path'),
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        } else {

            $data = array(
                'id'              => $this->input->post('sch_id'),
                'session_id'      => $this->input->post('sch_session_id'),
                'name'            => $this->input->post('sch_name'),
                'phone'           => $this->input->post('sch_phone'),
                'dise_code'       => $this->input->post('sch_dise_code'),
                'start_month'     => $this->input->post('sch_start_month'),
                'start_week'      => $this->input->post('sch_start_week'),
                'address'         => $this->input->post('sch_address'),
                'email'           => $this->input->post('sch_email'),
                'timezone'        => $this->input->post('sch_timezone'),
                'date_format'     => $this->input->post('sch_date_format'),
                'currency_format' => $this->input->post('currency_format'),
                'currency_place'  => $this->input->post('currency_place'),
                'base_url'        => $this->input->post('base_url'),
                'folder_path'     => $this->input->post('folder_path'),
                'sch_soc_name'     => $this->input->post('sch_soc_name'),
            'sch_name_primary'     => $this->input->post('sch_name_primary'),
            'sch_name_secondary'     => $this->input->post('sch_name_secondary'),
             'sch_name_high_secondary'     => $this->input->post('sch_name_high_secondary'),
              'sch_udise_primary'  => $this->input->post('sch_udise_primary'),
            'sch_udise_secondary'  => $this->input->post('sch_udise_secondary'),
            'sch_udise_high_secondary'  => $this->input->post('sch_udise_high_secondary'),
               'sch_establish'  => $this->input->post('sch_establish'),
                'sch_city'  => $this->input->post('sch_city'),
                
                'principalname'     => $this->input->post('principalname'),
                'viceprincipalname'     => $this->input->post('viceprincipalname'),
                'clerkname' => $this->input->post('clerkname'),
             'certificate_print_lang'  => $this->input->post('certificate_print_lang'),
             'sch_state'  => $this->input->post('sch_state'),
            'sch_recog_primary'     => $this->input->post('sch_recog_primary'),
             'sch_recog_high_secondary'     => $this->input->post('sch_recog_high_secondary'),
             'sch_recog_secondary'  => $this->input->post('sch_recog_secondary'),
             'bonafiedcopy'  => $this->input->post('bonafiedcopy'),
             'sch_medium'  => json_encode($this->input->post('sch_medium')),

          'sch_board'  => json_encode($this->input->post('sch_board')),
             'alt_email'  => $this->input->post('alt_email'),
             'alt_phone'  => $this->input->post('alt_phone'),
             'lang_id'  => $this->input->post('lang_id'),
              'is_rtl'  => $this->input->post('is_rtl'),
              'multiple_unit_test_in_term_exam'  => $this->input->post('multiple_unit_test_in_term_exam'),
              'multiple_unit_test_in_cbse_term_exam'  => $this->input->post('multiple_unit_test_in_cbse_term_exam'),
               'sch_sunday_leave'  => $this->input->post('sch_sunday_leave'),
               'show_admitcard_mh'  => $this->input->post('show_admitcard_mh'),
               'term1_min_fee_percentage'  => $this->input->post('term1_min_fee_percentage'),
               'term2_min_fee_percentage'  => $this->input->post('term2_min_fee_percentage')
            );
            
           

            $this->setting_model->add($data);

            $this->session->userdata['admin']['base_url']        = $this->input->post('base_url');
            $this->session->userdata['admin']['folder_path']     = $this->input->post('folder_path');
            $this->session->userdata['admin']['currency_format'] = $this->input->post('currency_format');
            $this->session->userdata['admin']['date_format']     = $this->input->post('sch_date_format');
            $this->session->userdata['admin']['start_week']      = date("w", strtotime($this->input->post('sch_start_week')));
            $this->session->userdata['admin']['timezone']        = $this->input->post('sch_timezone');
            $this->session->userdata['admin']['currency_place']  = $this->input->post('currency_place');
            $array                                               = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('success_message'));
            echo json_encode($array);
        }
    }
    
    
    
    // this function add by arun for uploadSignature start
 public function uploadSignature()
{
    $role = $this->input->post('role');
    $allowed_roles = ['principal', 'viceprincipal', 'clerk'];

    if (!in_array($role, $allowed_roles)) {
        echo json_encode(['status' => 'fail', 'message' => 'Invalid role.']);
        return;
    }

    if (isset($_FILES['signature']) && $_FILES['signature']['error'] === 0) {
        $file_name = $_FILES['signature']['name'];
        $file_tmp = $_FILES['signature']['tmp_name'];
        $ext = pathinfo($file_name, PATHINFO_EXTENSION);
        $new_name = $role . '_' . time() . '.' . $ext;
        $upload_path = FCPATH . 'uploads/signatures/';
        $destination_file = $upload_path . $new_name;

        if (!is_dir($upload_path)) {
            mkdir($upload_path, 0777, true);
        }

        if (move_uploaded_file($file_tmp, $destination_file)) {
            // Save filename to DB
            $this->load->model('Setting_model');
            $this->Setting_model->updateSignature($role, $new_name);

            echo json_encode(['status' => 'success', 'filename' => $new_name]);
        } else {
            echo json_encode(['status' => 'fail', 'message' => 'Failed to upload image.']);
        }
    } else {
        echo json_encode(['status' => 'fail', 'message' => 'No file uploaded or error in upload.']);
    }
}
   // this function add by arun for uploadSignature end

   public function ajax_applogo()
{
    $this->form_validation->set_rules('id', $this->lang->line('id'), 'trim|required|xss_clean');
    $this->form_validation->set_rules('file', $this->lang->line('image'), 'callback_handle_upload');

    if ($this->form_validation->run() == false) {
        $data = array(
            'file' => form_error('file'),
        );
        $array = array('success' => false, 'error' => $data);
        echo json_encode($array);
    } else {
        $id = $this->input->post('id');
        $setting = $this->setting_model->getSetting();

        $upload_path = "./uploads/school_content/logo/app_logo/";
        if (!is_dir($upload_path)) {
            mkdir($upload_path, 0777, true);
        }

        if (isset($_FILES["file"]) && !empty($_FILES['file']['name'])) {
            $fileInfo = pathinfo($_FILES["file"]["name"]);
            $extension = strtolower($fileInfo['extension']);

            // Generate a unique random file name
            $img_name = uniqid('app_logo_', true) . '.' . $extension;
            $destination = $upload_path . $img_name;

            // Delete old app logo if it exists
            if (!empty($setting->app_logo) && file_exists($upload_path . $setting->app_logo)) {
                unlink($upload_path . $setting->app_logo);
            }

            // Move uploaded file
            move_uploaded_file($_FILES["file"]["tmp_name"], $destination);
        } else {
            $img_name = $setting->app_logo;
        }

        $data_record = array('id' => $id, 'app_logo' => $img_name);
        $this->setting_model->add($data_record);

        $array = array('success' => true, 'error' => '', 'message' => $this->lang->line('update_message'));
        echo json_encode($array);
    }
}



    public function check_admission_digit()
    {
        $adm_start_from = $this->input->post('adm_start_from');
        $adm_no_digit   = $this->input->post('adm_no_digit');
        if ($adm_no_digit != "") {
            if (strlen($adm_start_from) == $adm_no_digit) {
                return true;
            }
            $this->form_validation->set_message('check_admission_digit', $this->lang->line('admission_start_from') . ' ' . $adm_no_digit . ' ' . $this->lang->line('digit_long'));
            return false;
        }
        return true;
    }

    public function check_staff_id_digit()
    {
        $adm_start_from   = $this->input->post('staffid_start_from');
        $staffid_no_digit = $this->input->post('staffid_no_digit');
        if ($staffid_no_digit != "") {
            if (strlen($adm_start_from) == $staffid_no_digit) {
                return true;
            }
            $this->form_validation->set_message('check_staff_id_digit', $this->lang->line('staff_id_start_from_must_be') . ' ' . strlen($adm_start_from) . ' ' . $this->lang->line('digit_long'));
            return false;
        }
        return true;
    }

    public function logo()
    {        
        $this->session->set_userdata('top_menu', 'System Settings');
        $this->session->set_userdata('sub_menu', 'schsettings/index');
        $this->session->set_userdata('subsub_menu', 'schsettings/logo');
    
        $setting              = $this->setting_model->getSetting();
        
        
        $data['result']       = $setting;
        
        
        
        $this->load->view('layout/header');
        $this->load->view('setting/logo', $data);
        $this->load->view('layout/footer');
    }

    public function miscellaneous()
    {
        $this->session->set_userdata('top_menu', 'System Settings');
        $this->session->set_userdata('sub_menu', 'schsettings/index');
        $this->session->set_userdata('subsub_menu', 'schsettings/miscellaneous');
        $setting              = $this->setting_model->getSetting();
        $setting->base_url    = ($setting->base_url == "") ? base_url() : $setting->base_url;
        $setting->folder_path = ($setting->folder_path == "") ? FCPATH : $setting->folder_path;
        $data['result']       = $setting;
        $this->load->view('layout/header');
        $this->load->view('setting/miscellaneous', $data);
        $this->load->view('layout/footer');
    }

    public function savemiscellaneous()
    {
        $event_reminder = $this->input->post('event_reminder');
        if ($event_reminder == 'enabled') {
            $calendar_event_reminder = $this->input->post('calendar_event_reminder');
        } else {
            $calendar_event_reminder = '0';
        }

        $data = array(
            'id'                       => $this->input->post('sch_id'),
            'my_question'              => $this->input->post('my_question'),
            'exam_result'              => $this->input->post('exam_result'),
            'class_teacher'            => $this->input->post('class_teacher'),
            'superadmin_restriction'   => $this->input->post('superadmin_restriction_mode'),
            'calendar_event_reminder'  => $calendar_event_reminder,
            'event_reminder'           => $this->input->post('event_reminder'),
            'staff_notification_email' => $this->input->post('staff_notification_email'),
            'scan_code_type'           => $this->input->post('scan_code_type'),
            'download_admit_card'      => $this->input->post('download_admit_card'),
        );

        $this->setting_model->add($data);
        $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('success_message'));
        echo json_encode($array);

    }

    public function backendtheme()
    {
        $this->session->set_userdata('top_menu', 'System Settings');
        $this->session->set_userdata('sub_menu', 'schsettings/index');
        $this->session->set_userdata('subsub_menu', 'schsettings/backendtheme');
        $setting              = $this->setting_model->getSetting();
        $setting->base_url    = ($setting->base_url == "") ? base_url() : $setting->base_url;
        $setting->folder_path = ($setting->folder_path == "") ? FCPATH : $setting->folder_path;
        $data['result']       = $setting;
        $this->load->view('layout/header');
        $this->load->view('setting/backendtheme', $data);
        $this->load->view('layout/footer');
    }

    public function savebackendtheme()
    {
        $this->form_validation->set_rules('theme', $this->lang->line('theme'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'theme' => form_error('theme'),
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        } else {

            $data = array(
                'id'    => $this->input->post('sch_id'),
                'theme' => $this->input->post('theme'),
            );

            $this->setting_model->add($data);
            $this->session->userdata['admin']['theme'] = $this->input->post('theme');
            $array                                     = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('success_message'));
            echo json_encode($array);
        }
    }

    public function mobileapp()
    {
        $app_ver = $this->config->item('app_ver');
        $this->session->set_userdata('top_menu', 'System Settings');
        $this->session->set_userdata('sub_menu', 'schsettings/index');
        $this->session->set_userdata('subsub_menu', 'schsettings/mobileapp');
        $setting              = $this->setting_model->getSetting();
        $setting->base_url    = ($setting->base_url == "") ? base_url() : $setting->base_url;
        $setting->folder_path = ($setting->folder_path == "") ? FCPATH : $setting->folder_path;
        $data['result']       = $setting;
        $data['app_response'] = $this->auth->andapp_validate();
        $this->load->view('layout/header');
        $this->load->view('setting/mobileapp', $data);
        $this->load->view('layout/footer');
    }

    public function savemobileapp()
    {
        $data = array(
            'id'                             => $this->input->post('sch_id'),
            'mobile_api_url'                 => $this->input->post('mobile_api_url'),
            'app_primary_color_code'         => $this->input->post('app_primary_color_code'),
            'app_secondary_color_code'       => $this->input->post('app_secondary_color_code'),
            'admin_app_primary_color_code'   => $this->input->post('admin_app_primary_color_code'),
            'admin_app_secondary_color_code' => $this->input->post('admin_app_secondary_color_code'),
            'admin_mobile_api_url'           => $this->input->post('admin_mobile_api_url'),
        );

        $this->setting_model->add($data);
        $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('success_message'));
        echo json_encode($array);
    }

    public function studentguardianpanel()
    {
        $this->session->set_userdata('top_menu', 'System Settings');
        $this->session->set_userdata('sub_menu', 'schsettings/index');
        $this->session->set_userdata('subsub_menu', 'schsettings/studentguardianpanel');
        $setting              = $this->setting_model->getSetting();
        $setting->base_url    = ($setting->base_url == "") ? base_url() : $setting->base_url;
        $setting->folder_path = ($setting->folder_path == "") ? FCPATH : $setting->folder_path;
        $data['result']       = $setting;
        $this->load->view('layout/header');
        $this->load->view('setting/studentguardianpanel', $data);
        $this->load->view('layout/footer');
    }

    public function studentguardian()
    {
        $parent_panel_login  = 0;
        $student_panel_login = 0;

        if(isset($_POST['student_panel_login'])) {
            $student_panel_login = 1;
        }
        if(isset($_POST['parent_panel_login'])) {
            $parent_panel_login = 1;
        }

        $data = array(
            'id'                  => $this->input->post('sch_id'),
            'student_timeline'    => $this->input->post('student_timeline'),
            'student_login'       => json_encode($this->input->post('student_login')),
            'parent_login'        => json_encode($this->input->post('parent_login')),
            'student_panel_login' => $student_panel_login,
            'parent_panel_login'  => $parent_panel_login,
        );

        $this->setting_model->add($data);

        $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('success_message'));
        echo json_encode($array);
    }

    public function fees()
    {
        $this->session->set_userdata('top_menu', 'System Settings');
        $this->session->set_userdata('sub_menu', 'schsettings/index');
        $this->session->set_userdata('subsub_menu', 'schsettings/fees');

        $setting                        = $this->setting_model->getSetting();
        $setting->base_url              = ($setting->base_url == "") ? base_url() : $setting->base_url;
        $setting->folder_path           = ($setting->folder_path == "") ? FCPATH : $setting->folder_path;
        $data['result']                 = $setting;
        // print_r($setting); die;
        $data['duplicate_fees_invoice'] = explode(",", $setting->is_duplicate_fees_invoice);
        $this->load->view('layout/header');
        $this->load->view('setting/fees', $data);
        $this->load->view('layout/footer');
    }

    public function savefees()
    {
        $this->form_validation->set_rules('is_student_feature_lock', $this->lang->line('is_student_feature_lock'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('is_offline_fee_payment', $this->lang->line('offline_bank_payment_in_student_panel'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('is_duplicate_fees_invoice[]', $this->lang->line('print_fees_receipt_for'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('lock_grace_period', $this->lang->line('fees_payment_grace_period'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('fee_due_days', $this->lang->line('carry_forward_fees_due_days'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('single_page_print', $this->lang->line('single_page_print'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'is_duplicate_fees_invoice' => form_error('is_duplicate_fees_invoice[]'),
                'single_page_print'         => form_error('single_page_print'),
                'fee_due_days'              => form_error('fee_due_days'),
                'lock_grace_period'         => form_error('lock_grace_period'),
                'is_student_feature_lock'   => form_error('is_student_feature_lock'),
                'is_offline_fee_payment'    => form_error('is_offline_fee_payment'),
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        } else {

            $is_duplicate_fees_invoice = implode(",", $this->input->post('is_duplicate_fees_invoice'));
            $data                      = array(
                'id'                                => $this->input->post('sch_id'),
                'is_duplicate_fees_invoice'         => $is_duplicate_fees_invoice,
                'single_page_print'                 => $this->input->post('single_page_print'),
                'fee_due_days'                      => $this->input->post('fee_due_days'),
                'fees_receipt_no_prefix'             => $this->input->post('fees_receipt_no_prefix'),
                'lock_grace_period'                 => $this->input->post('lock_grace_period'),
                'collect_back_date_fees'            => $this->input->post('collect_back_date_fees'),
                'is_student_feature_lock'           => $this->input->post('is_student_feature_lock'),
                'is_offline_fee_payment'            => $this->input->post('is_offline_fee_payment'),
                'offline_bank_payment_instruction'  => $this->input->post('offline_bank_payment_instruction'),               
                'fees_discount'                     => $this->input->post('fees_discount'),               
            );

            $this->setting_model->add($data);
            $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('success_message'));
            echo json_encode($array);
        }
    }

    public function idautogeneration()
    {
        $this->session->set_userdata('top_menu', 'System Settings');
        $this->session->set_userdata('sub_menu', 'schsettings/index');
        $this->session->set_userdata('subsub_menu', 'schsettings/idautogeneration');

        $digit                = $this->customlib->getDigits();
        $data['digitList']    = $digit;
        $setting              = $this->setting_model->getSetting();
        $setting->base_url    = ($setting->base_url == "") ? base_url() : $setting->base_url;
        $setting->folder_path = ($setting->folder_path == "") ? FCPATH : $setting->folder_path;
        $data['result']       = $setting;
        $this->load->view('layout/header');
        $this->load->view('setting/idautogeneration', $data);
        $this->load->view('layout/footer');
    }

    public function saveidautogeneration()
    {
        $this->form_validation->set_rules('sch_id', 'Id', 'trim|required|xss_clean');

        if ($this->input->post('adm_auto_insert')) {
            $this->form_validation->set_rules('adm_prefix', $this->lang->line('admission_no_prefix'), 'trim|required|xss_clean');
            $this->form_validation->set_rules('adm_start_from', $this->lang->line('admission_start_from'), 'trim|integer|required|xss_clean');
            $this->form_validation->set_rules('adm_no_digit', $this->lang->line('admission_no_digit'), 'trim|integer|required|xss_clean|callback_check_admission_digit');
        }
        if ($this->input->post('staffid_auto_insert')) {

            $this->form_validation->set_rules('staffid_prefix', $this->lang->line('staff_id_prefix'), 'trim|required|xss_clean');
            $this->form_validation->set_rules('staffid_start_from', $this->lang->line('staff_id_start_from'), 'trim|integer|required|xss_clean');
            $this->form_validation->set_rules('staffid_no_digit', $this->lang->line('staff_id_digit'), 'trim|integer|required|xss_clean|callback_check_staff_id_digit');
        }

        if ($this->form_validation->run() == false) {
            $data = array(
                'adm_start_from'     => form_error('adm_start_from'),
                'adm_prefix'         => form_error('adm_prefix'),
                'adm_no_digit'       => form_error('adm_no_digit'),
                'staffid_start_from' => form_error('staffid_start_from'),
                'staffid_prefix'     => form_error('staffid_prefix'),
                'staffid_no_digit'   => form_error('staffid_no_digit'),
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        } else {
            $setting_result = $this->setting_model->getSetting();

            $data = array(
                'id'                  => $this->input->post('sch_id'),
                'adm_start_from'      => $this->input->post('adm_start_from'),
                'adm_prefix'          => $this->input->post('adm_prefix'),
                'adm_no_digit'        => $this->input->post('adm_no_digit'),
                'adm_auto_insert'     => $this->input->post('adm_auto_insert'),
                'staffid_start_from'  => $this->input->post('staffid_start_from'),
                'staffid_prefix'      => $this->input->post('staffid_prefix'),
                'staffid_no_digit'    => $this->input->post('staffid_no_digit'),
                'staffid_auto_insert' => $this->input->post('staffid_auto_insert'),
            );

            $data['adm_update_status']     = 1;
            $data['staffid_update_status'] = 1;
            if ($this->input->post('adm_auto_insert')) {
                if ($setting_result->adm_prefix != $this->input->post('adm_prefix') ||
                    $setting_result->adm_start_from != $this->input->post('adm_start_from') ||
                    $setting_result->adm_no_digit != $this->input->post('adm_no_digit')
                ) {
                    $data['adm_update_status'] = 0;
                }
            }

            if ($this->input->post('staffid_auto_insert')) {
                if ($setting_result->staffid_prefix != $this->input->post('staffid_prefix') ||
                    $setting_result->staffid_start_from != $this->input->post('staffid_start_from') ||
                    $setting_result->staffid_no_digit != $this->input->post('staffid_no_digit')
                ) {
                    $data['staffid_update_status'] = 0;
                }
            }

            $data['adm_update_status'];
            $this->setting_model->add($data);

            $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('success_message'));
            echo json_encode($array);
        }
    }

    public function attendancetype()
    {
        $this->session->set_userdata('top_menu', 'System Settings');
        $this->session->set_userdata('sub_menu', 'schsettings/index');
        $this->session->set_userdata('subsub_menu', 'schsettings/attendancetype');
        
        $data['classid']=$classid=$this->input->post('class_id');
        if(isset($classid)==false){
            $data['classid']=0;
        }
        
        $class_list=$this->class_section_time_model->allClassSections();
        $data['class_list']=$class_list;

        $setting              = $this->setting_model->getSetting();
        $setting->base_url    = ($setting->base_url == "") ? base_url() : $setting->base_url;
        $setting->folder_path = ($setting->folder_path == "") ? FCPATH : $setting->folder_path;
        $data['result']       = $setting;

        //staff attedance settings
        $staff_attendance_data   = $this->staffAttendaceSetting_model->getRoleAttendanceSetting();  
        $attendance_type         = $this->attendencetype_model->getScheduleTypeStaffAttendance();
        $user_roles              = $this->staff_model->getStaffRole();
        $data['user_roles']      = $user_roles;    
        $data['attendance_type'] = $attendance_type;
        $new_list_attendance     = array();

        foreach ($staff_attendance_data as $key => $value) {
            if (array_key_exists($value->id, $new_list_attendance)) {
                $new_list_attendance[$value->id]['schedule'][] = $value;
            } else {
                $new_list_attendance[$value->id] = [
                    'role_id' => $value->id,
                    'role' => $value->role_name,
                    'schedule' => array($value)
                ];
            }
        }
        $data['list_attendance'] = $new_list_attendance;     
        // staff attedance settings

        //student attedance settings
        $student_class_section_data = $this->studentAttendaceSetting_model->getClassWiseAttendanceSetting($classid);
        $student_attendance_type            = $this->attendencetype_model->getScheduleTypeAttendance();
        // $data = array();
        $data['student_attendance_type'] = $student_attendance_type;
        $student_new_list_attendance = array();

        foreach ($student_class_section_data as $student_class_key => $student_class_value) {
            if (array_key_exists($student_class_value->class_id, $student_new_list_attendance)) {

                if (array_key_exists($student_class_value->section_id, $student_new_list_attendance[$student_class_value->class_id]['sections'])) {

                    $student_new_list_attendance[$student_class_value->class_id]['sections'][$student_class_value->section_id]['student_schedule'][] = $student_class_value;
                } else {

                    $student_new_list_attendance[$student_class_value->class_id]['sections'][$student_class_value->section_id] = array(
                        'class_section_id' => $student_class_value->id,
                        'section_id' => $student_class_value->section_id,
                        'section' => $student_class_value->section,
                        'student_schedule' => array($student_class_value)
                    );
                }
            } else {
                $student_new_list_attendance[$student_class_value->class_id] = [
                    'class_id' => $student_class_value->class_id,
                    'class' => $student_class_value->class,
                    'sections' => array($student_class_value->section_id =>
                    array(
                        'class_section_id' => $student_class_value->id,
                        'section_id' => $student_class_value->section_id,
                        'section' => $student_class_value->section,
                        'student_schedule' => array($student_class_value)
                    ))
                ];
            }
        }
        $data['student_list_attendance'] = $student_new_list_attendance;
        //student attedance settings

        $class                   = $this->class_model->get();
        $data['classlist']       = $class;

        $this->load->view('layout/header', $data);
        $this->load->view('setting/attendancetype', $data);
        $this->load->view('layout/footer', $data);
    }

    public function maintenance()
    {
        $this->session->set_userdata('top_menu', 'System Settings');
        $this->session->set_userdata('sub_menu', 'schsettings/index');
        $this->session->set_userdata('subsub_menu', 'schsettings/maintenance');

        $setting              = $this->setting_model->getSetting();
        $setting->base_url    = ($setting->base_url == "") ? base_url() : $setting->base_url;
        $setting->folder_path = ($setting->folder_path == "") ? FCPATH : $setting->folder_path;
        $data['result']       = $setting;
        $this->load->view('layout/header', $data);
        $this->load->view('setting/maintenance', $data);
        $this->load->view('layout/footer', $data);
    }

    public function saveattendancetype()
    {
        $this->form_validation->set_rules('attendence_type', $this->lang->line('attendance_type'), 'trim|required|xss_clean');        

        if ($this->form_validation->run() == false) {
            $data = array(
                'attendence_type' => form_error('attendence_type'),
                 
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        } else {
            $data = array(
                'id'               => $this->input->post('sch_id'),
                'attendence_type'  => $this->input->post('attendence_type'),
                'biometric_device' => $this->input->post('biometric_device'),
                'biometric'        => $this->input->post('biometric'),
                'low_attendance_limit' => $this->input->post('low_attendance_limit'),
            );
            
            $this->setting_model->add($data);
                    $period_attendance=0;
                    $student_attendance=1;
                     if($this->input->post('attendence_type')){
                          $period_attendance=1;
                          $student_attendance=0;
                     }

              $this->sidebarmenu_model->update_submenu_by_key(
                  [
                      ['key'=>'period_attendance_by_date','is_active'=>$period_attendance],
                      ['key'=>'period_attendance','is_active'=>$period_attendance],
                      ['key'=>'student_attendance','is_active'=>$student_attendance],
                      ['key'=>'attendance_by_date','is_active'=>$student_attendance]
                  ]
                );

            $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('success_message'));
            echo json_encode($array);
        }
    }

    public function save_maintenance()
    {
        $this->form_validation->set_rules('maintenance_mode', $this->lang->line('maintenance_mode'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'maintenance_mode' => form_error('maintenance_mode'),
            );
            $array = array('status' => 0, 'error' => $data);
            echo json_encode($array);
        } else {
            $data = array(
                'id'               => $this->input->post('sch_id'),
                'maintenance_mode' => $this->input->post('maintenance_mode'),
            );
            $this->setting_model->add($data);

            $array = array('status' => 1, 'error' => '', 'message' => $this->lang->line('success_message'));
            echo json_encode($array);
        }
    }
    
    public function login_page_background()
    {        
        // echo '123';die;
        $this->session->set_userdata('top_menu', 'System Settings');
        $this->session->set_userdata('sub_menu', 'schsettings/index');
        $this->session->set_userdata('subsub_menu', 'schsettings/login_page_background');
    
        $setting              = $this->setting_model->getSetting();
        $data['result']       = $setting;
       
        $this->load->view('layout/header');
        $this->load->view('setting/login_page_background', $data);
        $this->load->view('layout/footer');
    }
    
    public function add_admin_login_background()
    {
        // echo '123';die;
        $this->form_validation->set_rules('id', $this->lang->line('id'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('file', $this->lang->line('image'), 'callback_handle_upload');
        // if ($this->form_validation->run() == false) {
        //     $data = array(
        //         'file' => form_error('file'),
        //     );
        //     $array = array('success' => false, 'error' => $data);
        //     echo json_encode($array);
        // } 
            $id = $this->input->post('id');
            $logo_type = $this->input->post('logo_type');
 
            $setting = $this->setting_model->getSetting();
            if($logo_type != 'admin_logo'){                
                $background =   $setting->user_login_page_background;
            }else {
                $background =   $setting->admin_login_page_background;
            }
            $upload_path = "./uploads/school_content/login_image/";

            // agar folder nahi hai to bana do
            if (!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true); // true = nested folders ke liye
            }

            if (isset($_FILES["file"]) && !empty($_FILES['file']['name'])) {
                $img_name = $this->media_storage->fileupload("file", $upload_path);
            } else {
                $img_name = $background;
            }

            // if (isset($_FILES["file"]) && $_FILES['file']['name'] != '' && (!empty($_FILES['file']['name']))) {
            //     $img_name = $this->media_storage->fileupload("file", "./uploads/school_content/login_image/");
            // } else {
            //     $img_name = $background;
            // }
            
            if (isset($background)) {
                $this->media_storage->filedelete($background, "uploads/school_content/login_image");
            }
            
            if($logo_type != 'admin_logo'){                
                $data_record = array('id' => $id, 'user_login_page_background' => $img_name);
            }else {                 
                $data_record = array('id' => $id, 'admin_login_page_background' => $img_name);
            }          
            
            $this->setting_model->add($data_record);
            $array = array('success' => true, 'error' => '', 'message' => $this->lang->line('success_message'));
            echo json_encode($array);
        
    }

    //****staff attendance settings****//
    public function savestaffsetting(){
        $this->form_validation->set_rules('row[]', $this->lang->line('row'), 'trim|required|xss_clean');
        $row = $this->input->post('row');
        $time_valid = true;

        if (!empty($row) && isset($row)) {
            foreach ($row as $row_key => $row_value) {
                $attendance_type      = $this->input->post('attendance_type_id_' . $row_value);
                $class_section        = $this->input->post('role_id_' . $row_value);
                $entry_time_from      = $this->input->post('entry_time_from_' . $row_value);
                $entry_time_to        = $this->input->post('entry_time_to_' . $row_value);
                $total_institute_hour = $this->input->post('total_institute_hour_' . $row_value);
             
                if ($class_section == "" || $entry_time_from == "" || $entry_time_to == "" || $total_institute_hour == "" || $attendance_type == "") {
                    $this->form_validation->set_rules(
                        'fields',
                        'fields --r',
                        'trim|required|xss_clean',
                        array('required' => $this->lang->line('fields_values_required'))
                    );
                    $time_valid = false;
                    break;
                }
            }
        }

        if ($this->form_validation->run() == false){
            $msg = array(
                'row' => form_error('row'),
                'fields' => form_error('fields')
            );
            $array = array('status' => 0, 'error' => $msg, 'message' => '');
        } else {
            $insert_array = array();
            $role_array = array();
            foreach ($row as $row_key => $row_value) {
                $role_array[] = ($this->input->post('role_id_' . $row_value));
                $role_id = $this->input->post('role_id_' . $row_value);
                $attendance_type = $this->input->post('attendance_type_id_' . $row_value);
                $entry_time_from = $this->input->post('entry_time_from_' . $row_value);
                $entry_time_to = $this->input->post('entry_time_to_' . $row_value);
                $total_institute_hour = $this->input->post('total_institute_hour_' . $row_value);
       
                $insert_array[] = array(
                    'staff_attendence_type_id' => $attendance_type,
                    'role_id'                  => $class_section,
                    'entry_time_from'          => $entry_time_from,
                    'entry_time_to'            => $entry_time_to,
                    'total_institute_hour'     => ($total_institute_hour)
                );
            }

            $this->staffAttendaceSetting_model->add($insert_array, $role_array);
            $array = array('status' => 1, 'message' => $this->lang->line('update_message'));
        }
        echo json_encode($array);
    }

    public function whatsappsettings()
    {
        $this->session->set_userdata('top_menu', 'System Settings');
        $this->session->set_userdata('sub_menu', 'schsettings/index');
        $this->session->set_userdata('subsub_menu', 'schsettings/whatsappsettings');
        $setting              = $this->setting_model->getSetting();
        
        $data['result']       = $setting;
        $this->load->view('layout/header');
        $this->load->view('setting/whatsappsettings', $data);
        $this->load->view('layout/footer');
    }

    public function savewhatsappsettings()
    {
        $this->form_validation->set_rules('sch_id', ('sch_id'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('time_to', $this->lang->line('time_to'), 'callback_time_check');          
        
        $whatsapp_fields = [
            'front_side_whatsapp' => 'front_side_whatsapp_mobile',
            'admin_panel_whatsapp' => 'admin_panel_whatsapp_mobile',
            'student_panel_whatsapp' => 'student_panel_whatsapp_mobile'
        ];

        foreach ($whatsapp_fields as $input_name => $field_name) {
            
            $this->form_validation->set_rules($input_name, $this->lang->line('whatsapp_link'), 'trim|required|xss_clean');
            
            if ($this->input->post($input_name)) {
                $this->form_validation->set_rules($field_name, $this->lang->line('mobile_no'), 'trim|required|xss_clean');
            }
            
            // Check time fields
            $from_field = "{$input_name}_from";
            $to_field = "{$input_name}_to";
            
            if (empty($this->input->post($from_field)) && !empty($this->input->post($to_field))) {
                $this->form_validation->set_rules($from_field, $this->lang->line('time_from'), 'trim|required|xss_clean');
            }
            
            if (!empty($this->input->post($from_field)) && empty($this->input->post($to_field))) {
                $this->form_validation->set_rules($to_field, $this->lang->line('time_to'), 'trim|required|xss_clean');
            }
        }
        
        if ($this->form_validation->run() == false) {            
            
            $fields = ['sch_id', 'front_side_whatsapp', 'admin_panel_whatsapp', 'student_panel_whatsapp', 'front_side_whatsapp_mobile', 'admin_panel_whatsapp_mobile', 'student_panel_whatsapp_mobile',  'front_side_whatsapp_from', 'front_side_whatsapp_to', 'admin_panel_whatsapp_from', 'admin_panel_whatsapp_to', 'student_panel_whatsapp_from', 'student_panel_whatsapp_to', 'time_to'];

            $error = array();
            
            foreach ($fields as $field) {
                $error[$field] = form_error($field);
            }           
            
            $array = array('status' => 'fail', 'error' => $error);
            echo json_encode($array);
        } else {            
            
            $fields = ['front_side_whatsapp_from', 'front_side_whatsapp_to', 'admin_panel_whatsapp_from', 'admin_panel_whatsapp_to', 'student_panel_whatsapp_from', 'student_panel_whatsapp_to'];

            foreach ($fields as $field) {
                $$field = $this->input->post($field) ?: null;
            }
            
            $data = array(
                'id'                            => $this->input->post('sch_id'),
                'front_side_whatsapp'           => $this->input->post('front_side_whatsapp'),
                'front_side_whatsapp_mobile'    => $this->input->post('front_side_whatsapp_mobile'),
                'front_side_whatsapp_from'      => $front_side_whatsapp_from,
                'front_side_whatsapp_to'        => $front_side_whatsapp_to,             
                'admin_panel_whatsapp'          => $this->input->post('admin_panel_whatsapp'),             
                'admin_panel_whatsapp_mobile'   => $this->input->post('admin_panel_whatsapp_mobile'),             
                'admin_panel_whatsapp_from'     => $admin_panel_whatsapp_from,             
                'admin_panel_whatsapp_to'       => $admin_panel_whatsapp_to,             
                'student_panel_whatsapp'        => $this->input->post('student_panel_whatsapp'),             
                'student_panel_whatsapp_mobile' => $this->input->post('student_panel_whatsapp_mobile'),             
                'student_panel_whatsapp_from'   => $student_panel_whatsapp_from,             
                'student_panel_whatsapp_to'     => $student_panel_whatsapp_to,             
            );
            
            $this->setting_model->add($data);       
            
            $this->session->userdata['admin']['admin_panel_whatsapp'] = $this->input->post('admin_panel_whatsapp');
            $this->session->userdata['admin']['admin_panel_whatsapp_mobile'] = $this->input->post('admin_panel_whatsapp_mobile');
            $this->session->userdata['admin']['admin_panel_whatsapp_from'] = $admin_panel_whatsapp_from;
            $this->session->userdata['admin']['admin_panel_whatsapp_to'] = $admin_panel_whatsapp_to;    

            $array = array('status' => 1, 'error' => '', 'message' => $this->lang->line('success_message'));
            echo json_encode($array);
        }
    }
    
    function time_check()
    {
        $fields = [
            'front_side_whatsapp',
            'admin_panel_whatsapp',
            'student_panel_whatsapp'
        ];
    
        foreach ($fields as $field) {
            $from = strtotime($this->input->post("{$field}_from"));
            $to = strtotime($this->input->post("{$field}_to"));
            
            if (!empty($from) && !empty($to) && $from >= $to) {
                $this->form_validation->set_message('time_check', '%s cannot less than from time %s');
                return FALSE;
            }
        }
    
        return TRUE;
    }
    
    
    
    public function ajax_edit_id_right_logo()
{
//     ini_set('display_errors', 1);
// error_reporting(E_ALL);
    $this->form_validation->set_rules('id', $this->lang->line('id'), 'trim|required|xss_clean');
    $this->form_validation->set_rules('file', $this->lang->line('image'), 'callback_handle_upload');

    if ($this->form_validation->run() == false) {
        $data = array(
            'file' => form_error('file'),
        );
        $array = array('success' => false, 'error' => $data);
        echo json_encode($array);
    } else {
        $id = $this->input->post('id');
        $setting = $this->setting_model->getSetting();  // or $this->schsettings_model->getSetting();

        $upload_path = "./uploads/school_content/id_right_logo/";
        if (!is_dir($upload_path)) {
            mkdir($upload_path, 0777, true);
        }

        if (isset($_FILES["file"]) && !empty($_FILES['file']['name'])) {
            $fileInfo = pathinfo($_FILES["file"]["name"]);
            $extension = strtolower($fileInfo['extension']);

            // Generate a unique filename
            $img_name = uniqid('id_right_', true) . '.' . $extension;
            $destination = $upload_path . $img_name;

            // Delete old logo if exists
            if (!empty($setting->id_right_logo) && file_exists($upload_path . $setting->id_right_logo)) {
                unlink($upload_path . $setting->id_right_logo);
            }

            // Move uploaded file to destination
            move_uploaded_file($_FILES["file"]["tmp_name"], $destination);
        } else {
            $img_name = $setting->id_right_logo;
        }

        // Update record
        $data_record = array('id' => $id, 'id_right_logo' => $img_name);
        $this->setting_model->add($data_record); // Use 'add' to update existing setting

        $array = array('success' => true, 'error' => '', 'message' => $this->lang->line('update_message'));
        echo json_encode($array);
    }
}

     public function timetable_setting()
    {
        $this->session->set_userdata('top_menu', 'System Settings');
        $this->session->set_userdata('sub_menu', 'schsettings/index');
        $this->session->set_userdata('subsub_menu', 'schsettings/timetable_setting');
        $data['title'] = 'Timetable Setting';

        
        $data['periods_data'] = $this->teachersubject_model->get_periods_time();
        if ($this->input->server('REQUEST_METHOD') == "POST") {
            $school_start_time = $this->input->post('school_start_time');
            $school_end_time = $this->input->post('school_end_time');
            $lunch_start_time = $this->input->post('lunch_break_start_time');
            $lunch_end_time = $this->input->post('lunch_break_end_time');
            $short_break_start_time = $this->input->post('short_break_start_time');
            $short_break_end_time = $this->input->post('short_break_end_time');

            // Capture period times
            $first_period = $this->input->post('first_period');
            $second_period = $this->input->post('second_period');
            $third_period = $this->input->post('third_period');
            $fourth_period = $this->input->post('fourth_period');
            $fifth_period = $this->input->post('fifth_period');
            $sixth_period = $this->input->post('sixth_period');
            $seventh_period = $this->input->post('seventh_period');
            $eighth_period = $this->input->post('eighth_period');

            // Data array
            $data = array(
                'school_start_time'   => $school_start_time,
                'school_end_time'     => $school_end_time,
                'lunch_break_start_time'    => $lunch_start_time,
                'lunch_break_end_time'      => $lunch_end_time,
                'short_break_start_time' => $short_break_start_time,
                'short_break_end_time'   => $short_break_end_time,
                'first_period'        => $first_period,
                'second_period'       => $second_period,
                'third_period'        => $third_period,
                'fourth_period'       => $fourth_period,
                'fifth_period'        => $fifth_period,
                'sixth_period'        => $sixth_period,
                'seventh_period'      => $seventh_period,
                'eight_period'       => $eighth_period
            );

            // Insert or update
            $this->teachersubject_model->insert_or_update_periods_time($data);

            // Redirect with message
            $this->session->set_flashdata('msg', 'Periods time saved successfully.');
            redirect('admin/teacher/periods_time');
        }

        $menu_data['selected'] = 'periods_time';
        $data['top_menu_option'] = $this->load->view('admin/teacher/topMenuOptions', $menu_data, true);
        $this->load->view('layout/header', $data);
        $this->load->view('admin/timetable/timetable_setting', $data);
        $this->load->view('layout/footer', $data);
    }

    
}
