<?php
/**
 * 
 */
class Notification extends Student_Controller
{
	
	

	public function __construct()
    {
        parent::__construct();
        $this->load->model("classteacher_model");
        $this->load->model("Staff_model");
        $this->load->library('Enc_lib');
        $this->sch_setting_detail = $this->setting_model->getSetting();

    }
    
    public function getNotificationCount() {
        $userdata = $this->customlib->getLoggedInUserData();
        $this->db->where('std_id', $userdata['student_id']);
        $this->db->where('is_read', 0);
         // Fetch only unread notifications
        $query = $this->db->get('student_notifications');
        $count = $query->num_rows();

        echo json_encode(['count' => $count]); // Return the count as JSON
    }

    // Fetch all notifications (read and unread)
    public function getNotifications() {
        $userdata = $this->customlib->getLoggedInUserData();
        $this->db->where('std_id', $userdata['student_id']);
        $this->db->order_by('created_at', 'DESC'); // Order notifications by latest first
        $query = $this->db->get('student_notifications');
        $notifications = $query->result_array();

        echo json_encode($notifications); // Return notifications as JSON
    }

    // Mark all notifications as read
    public function markAsRead() {
        $userdata = $this->customlib->getLoggedInUserData();
        $this->db->where('std_id', $userdata['student_id']);
        $this->db->set('is_read', 1); // Set is_read to 1 for all notifications
        $this->db->update('student_notifications'); // Update all notifications

        echo json_encode(['status' => 'success']);
    }
}
