<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Category extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        if (!$this->rbac->hasPrivilege('student_categories', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Student Information');
        $this->session->set_userdata('sub_menu', 'category/index');
        $data['title']        = $this->lang->line('category_list');
        $category_result      = $this->category_model->get();
        $data['categorylist'] = $category_result;
        $this->load->view('layout/header', $data);
        $this->load->view('category/categoryList', $data);
        $this->load->view('layout/footer', $data);
    }

    public function view($id)
    {
        if (!$this->rbac->hasPrivilege('student_categories', 'can_view')) {
            access_denied();
        }
        $data['title']    = $this->lang->line('category_list');
        $category         = $this->category_model->get($id);
        $data['category'] = $category;
        $this->load->view('layout/header', $data);
        $this->load->view('category/categoryShow', $data);
        $this->load->view('layout/footer', $data);
    }

    public function delete($id)
    {
        if (!$this->rbac->hasPrivilege('student_categories', 'can_delete')) {
            access_denied();
        }
        $data['title'] = $this->lang->line('category_list');
        $this->category_model->remove($id);
        $this->session->set_flashdata('msgdelete', '<div class="alert alert-success text-left">' . $this->lang->line('delete_message') . '</div>');
        redirect('category/index');
    }

    public function create()
    {
        if (!$this->rbac->hasPrivilege('student_categories', 'can_add')) {
            access_denied();
        }
        $data['title']        = $this->lang->line('add_category');
        $category_result      = $this->category_model->get();
        $data['categorylist'] = $category_result;
        $this->form_validation->set_rules('category', $this->lang->line('category'), 'trim|required|xss_clean');
        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('category/categoryList', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $data = array(
                'category' => $this->input->post('category'),
            );
            $this->category_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('category/index');
        }
    }

    public function edit($id)
    {
        if (!$this->rbac->hasPrivilege('student_categories', 'can_edit')) {
            access_denied();
        }
        $data['title']        = $this->lang->line('edit_category');
        $category_result      = $this->category_model->get();
        $data['categorylist'] = $category_result;
        $data['id']           = $id;
        $category             = $this->category_model->get($id);
        $data['category']     = $category;
        $this->form_validation->set_rules('category', $this->lang->line('category'), 'trim|required|xss_clean');
        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('category/categoryEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $data = array(
                'id'       => $id,
                'category' => $this->input->post('category'),
            );
            $this->category_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            redirect('category/index');
        }
    }
    
    
    
    
    
    
   public function castmanagement()
{
    $this->session->set_userdata('top_menu', 'Student Information');
    $this->session->set_userdata('sub_menu', 'category/castmanagement');

    $data['title'] = $this->lang->line('Castmanagement');

    $category_result = $this->category_model->get();

    $this->db->select('categories.id as category_id, categories.category as category_name, cast_management.castname,cast_management.id');
    $this->db->from('cast_management');
    $this->db->join('categories', 'cast_management.category_id = categories.id');
    $this->db->order_by('categories.category', 'ASC');
    $this->db->order_by('cast_management.castname', 'ASC');
    $query = $this->db->get();

    $data['result'] = $query->result_array();
    $data['categorylist'] = $category_result;

    $this->load->view('layout/header', $data);
    $this->load->view('category/castList', $data);
    $this->load->view('layout/footer', $data);
}

    
    
    
    public function castcreate()
{
    // Validate required category field
    $this->form_validation->set_rules('category', 'Category', 'required');

    if ($this->form_validation->run() == false) {
        // Validation failed: reload the view
        $data['categorylist'] = $this->category_model->get(); // adjust as per your model
        $this->load->view('category/castList', $data);
    } else {
        // Get selected category ID
        $category_id = $this->input->post('category');

        // Get cast array
        $casts = $this->input->post('cast');

      

        // Prepare and insert each non-empty cast
        foreach ($casts as $cast) {
            $cast = trim($cast); // sanitize input
            if (!empty($cast)) {
                $data = array(
                    'category_id' => $category_id,
                    'castname'   => $cast
                );

                $this->db->insert('cast_management', $data);
            }
        }

        // Optionally, set success message and redirect
        $this->session->set_flashdata('msg', '<div class="alert alert-success">Cast added successfully.</div>');
        redirect('category/castmanagement');
    }
}



public function editcast($id)
{
    
    
    $data['title'] = $this->lang->line('editcast');
    $data['id'] = $id;

    // Get all categories for dropdown
    $data['categorylist'] = $this->category_model->get();

    // Get cast data by ID from cast_management
    $this->db->where('id', $id);
    $cast = $this->db->get('cast_management')->row_array();

    if (!$cast) {
        show_404(); // If ID not found
    }

    $data['cast'] = $cast;

    // Validation rules
    $this->form_validation->set_rules('category', $this->lang->line('category'), 'trim|required|xss_clean');
    $this->form_validation->set_rules('castname', $this->lang->line('cast'), 'trim|required|xss_clean');

    if ($this->form_validation->run() == false) {
        $this->load->view('layout/header', $data);
        $this->load->view('category/editcast', $data);
        $this->load->view('layout/footer', $data);
    } else {
        $update_data = array(
            'id'          => $id,
            'category_id' => $this->input->post('category'),
            'castname'    => $this->input->post('castname')
        );

        $this->db->where('id', $id);
        $this->db->update('cast_management', $update_data);

        $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
        redirect('category/castmanagement');
    }
}


    
    
    public function deletecast($id)
{
    $this->db->where('id', $id);
    $this->db->delete('cast_management');
    $this->session->set_flashdata('msg', '<div class="alert alert-success">Cast deleted successfully.</div>');
    redirect('category/castmanagement');
}
    
    
    

}
