#
# TABLE STRUCTURE FOR: OLDlanguages
#

DROP TABLE IF EXISTS `OLDlanguages`;

CREATE TABLE `OLDlanguages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(50) DEFAULT NULL,
  `short_code` varchar(255) NOT NULL,
  `country_code` varchar(255) NOT NULL,
  `is_rtl` int(11) NOT NULL,
  `is_deleted` varchar(10) NOT NULL DEFAULT 'yes',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=95 DEFAULT CHARSET=utf8;

INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Azerbaijan', 'az', 'az', 0, 'no', 'no', '2019-11-20 16:53:12', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Albanian', 'sq', 'al', 0, 'no', 'no', '2019-11-20 17:12:42', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Amharic', 'am', 'am', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'English', 'en', 'us', 0, 'no', 'yes', '2019-11-20 17:08:50', '2025-05-25 12:41:40');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Arabic', 'ar', 'sa', 0, 'no', 'no', '2019-11-20 17:17:28', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'Afrikaans', 'af', 'af', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Basque', 'eu', 'es', 0, 'no', 'no', '2019-11-20 17:24:10', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'Bengali', 'bn', 'in', 0, 'no', 'no', '2019-11-20 17:11:53', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'Bosnian', 'bs', 'bs', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'Welsh', 'cy', 'cy', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'Hungarian', 'hu', 'hu', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'Vietnamese', 'vi', 'vi', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'Haitian', 'ht', 'ht', 0, 'no', 'no', '2021-01-23 12:39:32', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'Galician', 'gl', 'gl', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'Dutch', 'nl', 'nl', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'Greek', 'el', 'gr', 0, 'no', 'no', '2019-11-20 17:42:08', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'Georgian', 'ka', 'ge', 0, 'no', 'no', '2019-11-20 17:41:40', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'Gujarati', 'gu', 'in', 0, 'no', 'no', '2019-11-20 17:09:16', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'Danish', 'da', 'dk', 0, 'no', 'no', '2019-11-20 17:33:25', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'Hebrew', 'he', 'il', 0, 'no', 'no', '2019-11-20 17:43:50', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'Yiddish', 'yi', 'il', 0, 'no', 'no', '2019-11-20 17:55:33', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'Indonesian', 'id', 'id', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'Irish', 'ga', 'ga', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'Italian', 'it', 'it', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'Icelandic', 'is', 'is', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'Spanish', 'es', 'es', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'Kannada', 'kn', 'in', 0, 'no', 'no', '2019-11-20 16:54:23', '2025-04-16 02:16:44');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'Catalan', 'ca', 'ca', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'Chinese', 'zh', 'cn', 0, 'no', 'no', '2019-11-20 17:31:48', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'Korean', 'ko', 'kr', 0, 'no', 'no', '2019-11-20 17:49:09', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'Xhosa', 'xh', 'ls', 0, 'no', 'no', '2019-11-20 17:54:39', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'Latin', 'la', 'it', 0, 'no', 'no', '2021-01-23 12:39:32', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'Latvian', 'lv', 'lv', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'Lithuanian', 'lt', 'lt', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'Malagasy', 'mg', 'mg', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'Malay', 'ms', 'ms', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'Malayalam', 'ml', 'ml', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'Maltese', 'mt', 'mt', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'Macedonian', 'mk', 'mk', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'Maori', 'mi', 'nz', 0, 'no', 'no', '2019-11-20 17:50:27', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'Marathi', 'mr', 'in', 0, 'no', 'no', '2019-11-20 17:09:51', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'Mongolian', 'mn', 'mn', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'German', 'de', 'de', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'Nepali', 'ne', 'ne', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'Norwegian', 'no', 'no', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'Punjabi', 'pa', 'in', 0, 'no', 'no', '2019-11-20 17:10:16', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'Persian', 'fa', 'ir', 0, 'no', 'no', '2019-11-20 17:51:17', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'Portuguese', 'pt', 'pt', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'Romanian', 'ro', 'ro', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'Russian', 'ru', 'ru', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'Cebuano', 'ceb', 'ph', 0, 'no', 'no', '2019-11-20 17:29:12', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'Sinhala', 'si', 'lk ', 0, 'no', 'no', '2021-01-23 12:39:32', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'Slovakian', 'sk', 'sk', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'Slovenian', 'sl', 'sl', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'Swahili', 'sw', 'ke', 0, 'no', 'no', '2019-11-20 17:51:57', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'Sundanese', 'su', 'sd', 0, 'no', 'no', '2019-12-03 16:36:57', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'Thai', 'th', 'th', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'Tagalog', 'tl', 'tl', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'Tamil', 'ta', 'in', 0, 'no', 'no', '2019-11-20 17:10:53', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'Telugu', 'te', 'in', 0, 'no', 'no', '2019-11-20 17:11:15', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'Turkish', 'tr', 'tr', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'Uzbek', 'uz', 'uz', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (79, 'Urdu', 'ur', 'pk', 0, 'no', 'no', '2019-11-20 17:53:57', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (80, 'Finnish', 'fi', 'fi', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (81, 'French', 'fr', 'fr', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (82, 'Hindi', 'hi', 'in', 0, 'no', 'no', '2019-11-20 17:06:34', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (84, 'Czech', 'cs', 'cz', 0, 'no', 'no', '2019-11-20 17:32:36', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (85, 'Swedish', 'sv', 'sv', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (86, 'Scottish', 'gd', 'gd', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (87, 'Estonian', 'et', 'et', 0, 'no', 'no', '2019-11-20 16:54:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (88, 'Esperanto', 'eo', 'br', 0, 'no', 'no', '2019-11-21 10:19:18', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (89, 'Javanese', 'jv', 'id', 0, 'no', 'no', '2019-11-20 17:48:29', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (90, 'Japanese', 'ja', 'jp', 0, 'no', 'no', '2019-11-20 17:44:39', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (91, 'Polish', 'pl', 'pl', 0, 'no', 'no', '2020-06-15 08:55:27', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (92, 'Kurdish', 'ku', 'iq', 0, 'no', 'no', '2020-12-21 05:45:31', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (93, 'Lao', 'lo', 'la', 0, 'no', 'no', '2020-12-21 05:45:36', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (94, 'Croatia', 'hr', 'hr', 0, 'no', 'no', '2022-06-07 17:18:21', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: QR_code_settings
#

DROP TABLE IF EXISTS `QR_code_settings`;

CREATE TABLE `QR_code_settings` (
  `id` int(11) NOT NULL,
  `camera_type` varchar(15) DEFAULT NULL,
  `auto_attendance` int(11) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `QR_code_settings` (`id`, `camera_type`, `auto_attendance`, `created_at`) VALUES (1, 'environment', 1, '2025-09-19 15:04:16');


#
# TABLE STRUCTURE FOR: addon_versions
#

DROP TABLE IF EXISTS `addon_versions`;

CREATE TABLE `addon_versions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `addon_id` int(11) DEFAULT NULL,
  `version` varchar(10) DEFAULT NULL,
  `version_order` int(11) DEFAULT NULL,
  `folder_path` text,
  `sort_description` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `addon_id` (`addon_id`),
  CONSTRAINT `addon_versions_ibfk_1` FOREIGN KEY (`addon_id`) REFERENCES `addons` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: addons
#

DROP TABLE IF EXISTS `addons`;

CREATE TABLE `addons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `image` text NOT NULL,
  `name` varchar(500) DEFAULT NULL,
  `config_name` varchar(200) NOT NULL DEFAULT '',
  `short_name` varchar(100) NOT NULL,
  `directory` varchar(500) NOT NULL,
  `description` text,
  `price` float(10,2) NOT NULL DEFAULT '0.00',
  `current_version` varchar(50) DEFAULT NULL,
  `article_link` text NOT NULL,
  `installation_by` int(11) DEFAULT NULL,
  `uninstall_version` varchar(50) DEFAULT NULL,
  `unistall_by` int(11) DEFAULT NULL,
  `addon_prod` text,
  `addon_ver` text,
  `last_update` datetime DEFAULT NULL,
  `current_stage` int(11) NOT NULL DEFAULT '0' COMMENT '0 for buy addon,1 for folder available ready to install,2 for folder addon installed',
  `product_order` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (1, 47443722, 'uploads/addon_images/sscbse_images.jpg', 'Do Little Tech CBSE Examination    ', 'cbse-config', 'sscbse', 'cbse_examination', 'CBSE Examination addon adds CBSE Examination module in Do Little Tech. Using this module teacher/staff can create and print marksheets with advance features.', '0.00', '', '#', NULL, NULL, NULL, NULL, NULL, '2024-09-03 16:04:58', 0, 4, '2024-09-03 21:34:58', '2025-05-10 02:20:50');
INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (2, 44278049, 'uploads/addon_images/sstfa_images.jpg', 'Do Little Tech Two Factor Authentication', 'google-authenticate-config', 'sstfa', 'two_factor_authentication', 'Two Factor Authentication addon adds Two Factor Authentication module in Do Little Tech. Using this module you can enhance login security of your Do Little Tech users.', '0.00', NULL, '#', NULL, NULL, NULL, NULL, NULL, '2025-01-29 11:16:14', 0, 5, '2024-09-07 16:15:18', '2025-05-10 02:24:01');
INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (3, 44277916, 'uploads/addon_images/ssmb_images.jpg', 'Do Little Tech Multi Branch', 'multibranch-config', 'ssmb', 'multi_branch', 'Multi Branch addon adds Multi Branch module in Do Little Tech. Using this module Superadmin user can add other any number of schools/branches.', '0.00', NULL, '#', NULL, NULL, NULL, NULL, NULL, '2025-01-29 11:16:15', 0, 6, '2024-09-07 16:15:18', '2025-05-10 02:20:50');
INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (4, 44247532, 'uploads/addon_images/ssbr_images.jpg', 'Do Little Tech Behaviour Records', 'behaviour-report-config', 'ssbr', 'behavior_records', 'Behaviour Records addon adds Behaviour Records module in Do Little Tech. Using this module teacher/staff can create different incidents with positive/negative marks and then assign these incidents on students.', '0.00', '3.0', '#', NULL, '1.0', NULL, NULL, NULL, '2025-01-29 11:16:19', 0, 7, '2024-09-07 16:15:42', '2025-05-10 02:20:50');
INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (5, 33101540, 'uploads/addon_images/ssoclc_images.jpg', 'Do Little Tech Online Course', 'onlinecourse-config', 'ssoclc', 'online_course', 'Online Course addon adds Online Course module in Do Little Tech. Using this module teacher/staff can create free or paid online course with their study material based on video, audio or in document content format.', '0.00', '4.0', '#', NULL, '1.0', NULL, NULL, NULL, '2025-01-29 11:16:19', 0, 8, '2024-09-07 16:15:42', '2025-05-10 02:24:01');
INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (6, 27492043, 'uploads/addon_images/sszlc_images.jpg', 'Do Little Tech Zoom Live Classes', 'zoom-config', 'sszlc', 'zoom_live_class', 'Zoom Live Class addon adds Zoom Live Class module in Do Little Tech. Using this module teacher/staff can create live online classes using Zoom.us service. Further students can join these classes.', '0.00', NULL, '#', NULL, NULL, NULL, NULL, NULL, '2025-01-29 11:16:17', 0, 10, '2024-09-07 16:16:10', '2025-05-10 02:24:01');
INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (7, 28941973, 'uploads/addon_images/ssglc_images.jpg', 'Do Little Tech  Gmeet Live Class', 'gmeet-config', 'ssglc', 'gmeet_live_class', 'Gmeet Live Class addon adds Gmeet Live Class module in Do Little Tech. Using this module teacher/staff can create live online classes using http://meet.google.com service. Further students can join these classes.', '0.00', NULL, '#', NULL, NULL, NULL, NULL, NULL, '2025-01-29 11:16:24', 0, 9, '2024-09-07 16:16:10', '2025-05-10 02:24:01');
INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (8, 50336584, 'uploads/addon_images/ssqra_images.jpg', 'Do Little Tech QR Code Attendance', 'qrattendance-config', 'ssqra', 'qr_code_attendance', 'QR Code Attendance addon adds automated Student/Staff attendance using QR/Barcode module in Do Little Tech. Using this module Student/Staff can submit their attendance by just scanning their ID Card.', '0.00', '2.0', '#', NULL, '1.0', NULL, NULL, NULL, '2025-01-28 22:28:58', 0, 3, '2025-01-13 18:40:06', '2025-05-10 02:24:01');
INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (9, 57220011, 'uploads/addon_images/ssqfc_images.jpg', 'Do Little Tech Quick Fees Create', 'quickfees-config', 'ssqfc', 'quick_fees_create', 'Quick Fees Create addon adds one click fees create feature in Do Little Tech Fees Collection module. Using this you can create and assign fees on students in just few seconds and all Fees Category, Fees Groups, Fees Masters will be create automatically in your Do Little Tech.', '0.00', NULL, '#', NULL, NULL, NULL, NULL, NULL, '2025-01-28 22:28:58', 0, 2, '2025-01-13 18:40:06', '2025-05-10 02:24:28');
INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (10, 57219905, 'uploads/addon_images/sstpa_images.jpg', 'Do Little Tech Thermal Print', 'thermalprint-config', 'sstpa', 'thermal_print', 'Thermal Print addon adds Thermal Printer compatible small size fees receipt print capability in Do Little Tech. Using this module you can utilize modern cost effective fees receipt printing in Do Little Tech.', '0.00', NULL, '#\r\n', NULL, NULL, NULL, NULL, NULL, '2025-01-30 10:28:42', 0, 1, '2025-01-13 18:40:06', '2025-05-10 02:24:28');


#
# TABLE STRUCTURE FOR: alumni_events
#

DROP TABLE IF EXISTS `alumni_events`;

CREATE TABLE `alumni_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `session_id` int(11) DEFAULT NULL,
  `class_id` int(11) DEFAULT NULL,
  `section` varchar(255) NOT NULL,
  `from_date` datetime NOT NULL,
  `to_date` datetime NOT NULL,
  `note` text NOT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `is_active` int(11) NOT NULL,
  `event_notification_message` text NOT NULL,
  `show_onwebsite` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  KEY `class_id` (`class_id`),
  CONSTRAINT `alumni_events_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `alumni_events_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `alumni_events` (`id`, `title`, `event_for`, `session_id`, `class_id`, `section`, `from_date`, `to_date`, `note`, `photo`, `is_active`, `event_notification_message`, `show_onwebsite`, `created_at`, `updated_at`) VALUES (1, 'annual school', 'all', NULL, NULL, 'null', '2025-06-04 00:00:00', '2025-06-10 23:59:00', '', '', 0, '', 0, '2025-06-13 18:49:06', '2025-06-13 18:49:06');


#
# TABLE STRUCTURE FOR: alumni_students
#

DROP TABLE IF EXISTS `alumni_students`;

CREATE TABLE `alumni_students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `current_email` varchar(255) NOT NULL,
  `current_phone` varchar(255) NOT NULL,
  `occupation` text NOT NULL,
  `address` text NOT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `alumni_students_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: annual_calendar
#

DROP TABLE IF EXISTS `annual_calendar`;

CREATE TABLE `annual_calendar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) DEFAULT NULL,
  `holiday_type` int(11) NOT NULL,
  `from_date` datetime DEFAULT NULL,
  `to_date` datetime DEFAULT NULL,
  `description` text NOT NULL,
  `is_active` int(11) NOT NULL DEFAULT '1',
  `holiday_color` varchar(200) NOT NULL,
  `front_site` int(11) NOT NULL DEFAULT '0',
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `annual_calendar_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `annual_calendar` (`id`, `session_id`, `holiday_type`, `from_date`, `to_date`, `description`, `is_active`, `holiday_color`, `front_site`, `created_by`, `created_at`, `updated_at`) VALUES (1, 19, 1, '2025-04-27 00:00:00', '2025-04-27 23:59:00', 'Sunday', 1, '#008000', 1, 2, '2025-04-26 14:00:16', '2025-04-26 15:00:16');
INSERT INTO `annual_calendar` (`id`, `session_id`, `holiday_type`, `from_date`, `to_date`, `description`, `is_active`, `holiday_color`, `front_site`, `created_by`, `created_at`, `updated_at`) VALUES (2, 19, 1, '2025-06-02 00:00:00', '2025-06-04 23:59:00', 'civil holiday', 1, '#008000', 0, 1, '2025-06-13 11:26:44', '2025-06-13 12:26:44');
INSERT INTO `annual_calendar` (`id`, `session_id`, `holiday_type`, `from_date`, `to_date`, `description`, `is_active`, `holiday_color`, `front_site`, `created_by`, `created_at`, `updated_at`) VALUES (3, 19, 2, '2025-06-03 00:00:00', '2025-06-12 23:59:00', 'eid holiday', 1, '#008000', 0, 1, '2025-06-13 11:27:48', '2025-06-13 12:27:48');
INSERT INTO `annual_calendar` (`id`, `session_id`, `holiday_type`, `from_date`, `to_date`, `description`, `is_active`, `holiday_color`, `front_site`, `created_by`, `created_at`, `updated_at`) VALUES (4, 19, 3, '2025-05-22 00:00:00', '2025-06-29 23:59:00', 'diwali holiday', 1, '#008000', 0, 1, '2025-06-13 11:28:23', '2025-06-13 12:28:23');


#
# TABLE STRUCTURE FOR: assessment_results
#

DROP TABLE IF EXISTS `assessment_results`;

CREATE TABLE `assessment_results` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `assessment_id` int(11) NOT NULL,
  `attendance` varchar(255) NOT NULL,
  `get_marks` varchar(255) NOT NULL,
  `month` varchar(255) NOT NULL,
  `created_at` int(11) NOT NULL,
  `updated_at` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=965 DEFAULT CHARSET=utf8mb4;

INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (1, 91, 1, 'present', '3', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (2, 69, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (3, 97, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (4, 84, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (5, 76, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (6, 70, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (7, 98, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (8, 83, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (9, 75, 1, 'present', '3', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (10, 1518, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (11, 1512, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (12, 1509, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (13, 88, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (14, 93, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (15, 74, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (16, 79, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (17, 96, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (18, 94, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (19, 72, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (20, 82, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (21, 85, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (22, 92, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (23, 86, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (24, 89, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (25, 67, 1, 'present', '2', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (26, 80, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (27, 90, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (28, 78, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (29, 87, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (30, 71, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (31, 73, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (32, 81, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (33, 77, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (34, 68, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (35, 1515, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (36, 1519, 1, 'present', '4', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (37, 1516, 1, 'absent', '0', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (38, 1520, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (39, 1510, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (40, 1513, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (41, 95, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (42, 1514, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (43, 1511, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (44, 1508, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (45, 1517, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (46, 91, 1, 'present', '8', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (47, 69, 1, 'present', '12', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (48, 97, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (49, 84, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (50, 76, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (51, 70, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (52, 98, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (53, 83, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (54, 75, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (55, 1518, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (56, 1512, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (57, 1509, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (58, 88, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (59, 93, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (60, 74, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (61, 79, 1, 'present', '12', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (62, 96, 1, 'present', '13', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (63, 94, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (64, 72, 1, 'present', '16', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (65, 82, 1, 'present', '17', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (66, 85, 1, 'present', '11', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (67, 92, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (68, 86, 1, 'present', '18', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (69, 89, 1, 'present', '12', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (70, 67, 1, 'present', '20', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (71, 80, 1, 'present', '12', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (72, 90, 1, 'present', '14', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (73, 78, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (74, 87, 1, 'present', '16', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (75, 71, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (76, 73, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (77, 81, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (78, 77, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (79, 68, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (80, 1515, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (81, 1521, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (82, 1519, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (83, 1516, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (84, 1520, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (85, 1510, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (86, 1513, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (87, 95, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (88, 1514, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (89, 1511, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (90, 1508, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (91, 1517, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (92, 91, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (93, 69, 2, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (94, 97, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (95, 84, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (96, 76, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (97, 70, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (98, 98, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (99, 83, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (100, 75, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (101, 1518, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (102, 1512, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (103, 1509, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (104, 88, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (105, 93, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (106, 74, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (107, 79, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (108, 96, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (109, 94, 2, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (110, 72, 2, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (111, 82, 2, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (112, 85, 2, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (113, 92, 2, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (114, 86, 2, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (115, 89, 2, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (116, 67, 2, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (117, 80, 2, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (118, 90, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (119, 78, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (120, 87, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (121, 71, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (122, 73, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (123, 81, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (124, 77, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (125, 68, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (126, 1515, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (127, 1521, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (128, 1519, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (129, 1516, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (130, 1520, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (131, 1510, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (132, 1513, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (133, 95, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (134, 1514, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (135, 1511, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (136, 1508, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (137, 1517, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (138, 91, 3, 'absent', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (139, 69, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (140, 97, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (141, 84, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (142, 76, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (143, 70, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (144, 98, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (145, 83, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (146, 75, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (147, 1518, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (148, 1512, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (149, 1509, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (150, 88, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (151, 93, 3, 'absent', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (152, 74, 3, 'absent', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (153, 79, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (154, 96, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (155, 94, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (156, 72, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (157, 82, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (158, 85, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (159, 92, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (160, 86, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (161, 89, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (162, 67, 3, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (163, 80, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (164, 90, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (165, 78, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (166, 87, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (167, 71, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (168, 73, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (169, 81, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (170, 77, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (171, 68, 3, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (172, 1515, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (173, 1521, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (174, 1519, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (175, 1516, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (176, 1520, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (177, 1510, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (178, 1513, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (179, 95, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (180, 1514, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (181, 1511, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (182, 1508, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (183, 1517, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (184, 91, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (185, 69, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (186, 97, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (187, 84, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (188, 76, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (189, 70, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (190, 98, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (191, 83, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (192, 75, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (193, 1518, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (194, 1512, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (195, 1509, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (196, 88, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (197, 93, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (198, 74, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (199, 79, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (200, 96, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (201, 94, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (202, 72, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (203, 82, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (204, 85, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (205, 92, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (206, 86, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (207, 89, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (208, 67, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (209, 80, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (210, 90, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (211, 78, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (212, 87, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (213, 71, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (214, 73, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (215, 81, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (216, 77, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (217, 68, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (218, 1515, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (219, 1521, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (220, 1519, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (221, 1516, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (222, 1520, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (223, 1510, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (224, 1513, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (225, 95, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (226, 1514, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (227, 1511, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (228, 1508, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (229, 1517, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (230, 91, 6, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (231, 69, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (232, 97, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (233, 84, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (234, 76, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (235, 70, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (236, 98, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (237, 83, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (238, 75, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (239, 1518, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (240, 1512, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (241, 1509, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (242, 88, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (243, 93, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (244, 74, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (245, 79, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (246, 96, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (247, 94, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (248, 72, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (249, 82, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (250, 85, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (251, 92, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (252, 86, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (253, 89, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (254, 67, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (255, 80, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (256, 90, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (257, 78, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (258, 87, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (259, 71, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (260, 73, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (261, 81, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (262, 77, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (263, 68, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (264, 1515, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (265, 1521, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (266, 1519, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (267, 1516, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (268, 1520, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (269, 1510, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (270, 1513, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (271, 95, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (272, 1514, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (273, 1511, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (274, 1508, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (275, 1517, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (276, 91, 7, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (277, 69, 7, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (278, 97, 7, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (279, 84, 7, 'absent', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (280, 76, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (281, 70, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (282, 98, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (283, 83, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (284, 75, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (285, 1518, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (286, 1512, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (287, 1509, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (288, 88, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (289, 93, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (290, 74, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (291, 79, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (292, 96, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (293, 94, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (294, 72, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (295, 82, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (296, 85, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (297, 92, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (298, 86, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (299, 89, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (300, 67, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (301, 80, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (302, 90, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (303, 78, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (304, 87, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (305, 71, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (306, 73, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (307, 81, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (308, 77, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (309, 68, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (310, 1515, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (311, 1521, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (312, 1519, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (313, 1516, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (314, 1520, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (315, 1510, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (316, 1513, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (317, 95, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (318, 1514, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (319, 1511, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (320, 1508, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (321, 1517, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (322, 91, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (323, 69, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (324, 97, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (325, 84, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (326, 76, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (327, 70, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (328, 98, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (329, 83, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (330, 75, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (331, 1518, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (332, 1512, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (333, 1509, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (334, 88, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (335, 93, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (336, 74, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (337, 79, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (338, 96, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (339, 94, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (340, 72, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (341, 82, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (342, 85, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (343, 92, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (344, 86, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (345, 89, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (346, 67, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (347, 80, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (348, 90, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (349, 78, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (350, 87, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (351, 71, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (352, 73, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (353, 81, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (354, 77, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (355, 68, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (356, 1515, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (357, 1521, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (358, 1519, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (359, 1516, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (360, 1520, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (361, 1510, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (362, 1513, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (363, 95, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (364, 1514, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (365, 1511, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (366, 1508, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (367, 1517, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (368, 91, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (369, 69, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (370, 97, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (371, 84, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (372, 76, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (373, 70, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (374, 98, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (375, 83, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (376, 75, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (377, 1518, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (378, 1512, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (379, 1509, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (380, 88, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (381, 93, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (382, 74, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (383, 79, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (384, 96, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (385, 94, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (386, 72, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (387, 82, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (388, 85, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (389, 92, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (390, 86, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (391, 89, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (392, 67, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (393, 80, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (394, 90, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (395, 78, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (396, 87, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (397, 71, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (398, 73, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (399, 81, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (400, 77, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (401, 68, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (402, 1515, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (403, 1521, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (404, 1519, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (405, 1516, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (406, 1520, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (407, 1510, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (408, 1513, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (409, 95, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (410, 1514, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (411, 1511, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (412, 1508, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (413, 1517, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (414, 91, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (415, 69, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (416, 97, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (417, 84, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (418, 76, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (419, 70, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (420, 98, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (421, 83, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (422, 75, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (423, 1518, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (424, 1512, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (425, 1509, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (426, 88, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (427, 93, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (428, 74, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (429, 79, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (430, 96, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (431, 94, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (432, 72, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (433, 82, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (434, 85, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (435, 92, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (436, 86, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (437, 89, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (438, 67, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (439, 80, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (440, 90, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (441, 78, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (442, 87, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (443, 71, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (444, 73, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (445, 81, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (446, 77, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (447, 68, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (448, 1515, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (449, 1521, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (450, 1519, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (451, 1516, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (452, 1520, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (453, 1510, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (454, 1513, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (455, 95, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (456, 1514, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (457, 1511, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (458, 1508, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (459, 1517, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (460, 91, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (461, 69, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (462, 97, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (463, 84, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (464, 76, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (465, 70, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (466, 98, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (467, 83, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (468, 75, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (469, 1518, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (470, 1512, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (471, 1509, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (472, 88, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (473, 93, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (474, 74, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (475, 79, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (476, 96, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (477, 94, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (478, 72, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (479, 82, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (480, 85, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (481, 92, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (482, 86, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (483, 89, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (484, 67, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (485, 80, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (486, 90, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (487, 78, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (488, 87, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (489, 71, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (490, 73, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (491, 81, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (492, 77, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (493, 68, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (494, 1515, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (495, 1521, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (496, 1519, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (497, 1516, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (498, 1520, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (499, 1510, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (500, 1513, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (501, 95, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (502, 1514, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (503, 1511, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (504, 1508, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (505, 1517, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (506, 91, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (507, 69, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (508, 97, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (509, 84, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (510, 76, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (511, 70, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (512, 98, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (513, 83, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (514, 75, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (515, 1518, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (516, 1512, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (517, 1509, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (518, 88, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (519, 93, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (520, 74, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (521, 79, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (522, 96, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (523, 94, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (524, 72, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (525, 82, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (526, 85, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (527, 92, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (528, 86, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (529, 89, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (530, 67, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (531, 80, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (532, 90, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (533, 78, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (534, 87, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (535, 71, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (536, 73, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (537, 81, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (538, 77, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (539, 68, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (540, 1515, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (541, 1521, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (542, 1519, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (543, 1516, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (544, 1520, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (545, 1510, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (546, 1513, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (547, 95, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (548, 1514, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (549, 1511, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (550, 1508, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (551, 1517, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (552, 91, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (553, 69, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (554, 97, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (555, 84, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (556, 76, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (557, 70, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (558, 98, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (559, 83, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (560, 75, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (561, 1518, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (562, 1512, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (563, 1509, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (564, 88, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (565, 93, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (566, 74, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (567, 79, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (568, 96, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (569, 94, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (570, 72, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (571, 82, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (572, 85, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (573, 92, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (574, 86, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (575, 89, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (576, 67, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (577, 80, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (578, 90, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (579, 78, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (580, 87, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (581, 71, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (582, 73, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (583, 81, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (584, 77, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (585, 68, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (586, 1515, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (587, 1521, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (588, 1519, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (589, 1516, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (590, 1520, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (591, 1510, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (592, 1513, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (593, 95, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (594, 1514, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (595, 1511, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (596, 1508, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (597, 1517, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (598, 91, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (599, 69, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (600, 97, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (601, 84, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (602, 76, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (603, 70, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (604, 98, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (605, 83, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (606, 75, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (607, 1518, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (608, 1512, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (609, 1509, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (610, 88, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (611, 93, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (612, 74, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (613, 79, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (614, 96, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (615, 94, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (616, 72, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (617, 82, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (618, 85, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (619, 92, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (620, 86, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (621, 89, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (622, 67, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (623, 80, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (624, 90, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (625, 78, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (626, 87, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (627, 71, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (628, 73, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (629, 81, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (630, 77, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (631, 68, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (632, 1515, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (633, 1521, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (634, 1519, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (635, 1516, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (636, 1520, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (637, 1510, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (638, 1513, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (639, 95, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (640, 1514, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (641, 1511, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (642, 1508, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (643, 1517, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (644, 91, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (645, 69, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (646, 97, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (647, 84, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (648, 76, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (649, 70, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (650, 98, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (651, 83, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (652, 75, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (653, 1518, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (654, 1512, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (655, 1509, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (656, 88, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (657, 93, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (658, 74, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (659, 79, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (660, 96, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (661, 94, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (662, 72, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (663, 82, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (664, 85, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (665, 92, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (666, 86, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (667, 89, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (668, 67, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (669, 80, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (670, 90, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (671, 78, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (672, 87, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (673, 71, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (674, 73, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (675, 81, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (676, 77, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (677, 68, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (678, 1515, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (679, 1521, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (680, 1519, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (681, 1516, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (682, 1520, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (683, 1510, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (684, 1513, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (685, 95, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (686, 1514, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (687, 1511, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (688, 1508, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (689, 1517, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (690, 91, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (691, 69, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (692, 97, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (693, 84, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (694, 76, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (695, 70, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (696, 98, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (697, 83, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (698, 75, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (699, 1518, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (700, 1512, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (701, 1509, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (702, 88, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (703, 93, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (704, 74, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (705, 79, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (706, 96, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (707, 94, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (708, 72, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (709, 82, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (710, 85, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (711, 92, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (712, 86, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (713, 89, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (714, 67, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (715, 80, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (716, 90, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (717, 78, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (718, 87, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (719, 71, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (720, 73, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (721, 81, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (722, 77, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (723, 68, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (724, 1515, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (725, 1521, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (726, 1519, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (727, 1516, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (728, 1520, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (729, 1510, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (730, 1513, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (731, 95, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (732, 1514, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (733, 1511, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (734, 1508, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (735, 1517, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (736, 91, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (737, 69, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (738, 97, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (739, 84, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (740, 76, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (741, 70, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (742, 98, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (743, 83, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (744, 75, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (745, 1518, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (746, 1512, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (747, 1509, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (748, 88, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (749, 93, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (750, 74, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (751, 79, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (752, 96, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (753, 94, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (754, 72, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (755, 82, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (756, 85, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (757, 92, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (758, 86, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (759, 89, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (760, 67, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (761, 80, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (762, 90, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (763, 78, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (764, 87, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (765, 71, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (766, 73, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (767, 81, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (768, 77, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (769, 68, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (770, 1515, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (771, 1521, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (772, 1519, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (773, 1516, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (774, 1520, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (775, 1510, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (776, 1513, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (777, 95, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (778, 1514, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (779, 1511, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (780, 1508, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (781, 1517, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (782, 91, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (783, 69, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (784, 97, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (785, 84, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (786, 76, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (787, 70, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (788, 98, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (789, 83, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (790, 75, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (791, 1518, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (792, 1512, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (793, 1509, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (794, 88, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (795, 93, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (796, 74, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (797, 79, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (798, 96, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (799, 94, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (800, 72, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (801, 82, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (802, 85, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (803, 92, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (804, 86, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (805, 89, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (806, 67, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (807, 80, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (808, 90, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (809, 78, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (810, 87, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (811, 71, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (812, 73, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (813, 81, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (814, 77, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (815, 68, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (816, 1515, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (817, 1521, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (818, 1519, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (819, 1516, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (820, 1520, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (821, 1510, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (822, 1513, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (823, 95, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (824, 1514, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (825, 1511, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (826, 1508, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (827, 1517, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (828, 1603, 17, 'present', '5', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (829, 1591, 17, 'present', '5', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (830, 1659, 17, 'present', '5', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (831, 2307, 17, 'present', '5', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (832, 1642, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (833, 1611, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (834, 2305, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (835, 1597, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (836, 1645, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (837, 1576, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (838, 1662, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (839, 1544, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (840, 2314, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (841, 1551, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (842, 1589, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (843, 1588, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (844, 1602, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (845, 2348, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (846, 2319, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (847, 1598, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (848, 1593, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (849, 1644, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (850, 2313, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (851, 1594, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (852, 2369, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (853, 2315, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (854, 1599, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (855, 2367, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (856, 1569, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (857, 2317, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (858, 1595, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (859, 1608, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (860, 2162, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (861, 2356, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (862, 1618, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (863, 1649, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (864, 1613, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (865, 2325, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (866, 1546, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (867, 2312, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (868, 1605, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (869, 1555, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (870, 1543, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (871, 1654, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (872, 1564, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (873, 1545, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (874, 1391, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (875, 2318, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (876, 2350, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (877, 1647, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (878, 1606, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (879, 2346, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (880, 2379, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (881, 1658, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (882, 1600, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (883, 2321, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (884, 1388, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (885, 1641, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (886, 1643, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (887, 2372, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (888, 2340, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (889, 2330, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (890, 2297, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (891, 1412, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (892, 1612, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (893, 1559, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (894, 2309, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (895, 1607, 17, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (896, 1575, 18, 'present', '20', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (897, 2062, 18, 'present', '17', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (898, 2239, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (899, 1514, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (900, 1560, 18, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (901, 2223, 18, 'absent', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (902, 1567, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (903, 2219, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (904, 1572, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (905, 1587, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (906, 1592, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (907, 2284, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (908, 2227, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (909, 1585, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (910, 1577, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (911, 2233, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (912, 1557, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (913, 1536, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (914, 1531, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (915, 1565, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (916, 1583, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (917, 2113, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (918, 2667, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (919, 2237, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (920, 2143, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (921, 1519, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (922, 2286, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (923, 2085, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (924, 1512, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (925, 2228, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (926, 2055, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (927, 1522, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (928, 1518, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (929, 2224, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (930, 1563, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (931, 1520, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (932, 2238, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (933, 1517, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (934, 1570, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (935, 2235, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (936, 2243, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (937, 1509, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (938, 2065, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (939, 2234, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (940, 1553, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (941, 2059, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (942, 1556, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (943, 2080, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (944, 2240, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (945, 2226, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (946, 2117, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (947, 2074, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (948, 1568, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (949, 1505, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (950, 1504, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (951, 1579, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (952, 1573, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (953, 2069, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (954, 2668, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (955, 1513, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (956, 1549, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (957, 2072, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (958, 2089, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (959, 1574, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (960, 1584, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (961, 1539, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (962, 2482, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (963, 1578, 18, 'present', '0', '07', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (964, 2094, 18, 'present', '0', '07', 0, 0);


#
# TABLE STRUCTURE FOR: assessment_types
#

DROP TABLE IF EXISTS `assessment_types`;

CREATE TABLE `assessment_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `assessment_min_marks` varchar(255) NOT NULL,
  `assessment_max_marks` varchar(255) NOT NULL,
  `term_exam_out_of_marks` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4;

INSERT INTO `assessment_types` (`id`, `type`, `assessment_min_marks`, `assessment_max_marks`, `term_exam_out_of_marks`, `description`, `status`, `created_at`, `updated_at`) VALUES (1, 'test', '', '', '', 'testing', 3, '2024-10-01 14:27:03', '2024-10-01 14:46:49');
INSERT INTO `assessment_types` (`id`, `type`, `assessment_min_marks`, `assessment_max_marks`, `term_exam_out_of_marks`, `description`, `status`, `created_at`, `updated_at`) VALUES (2, 'Homework', '7', '20', '5', '', 1, '2024-10-01 14:54:43', '2025-03-13 14:54:40');
INSERT INTO `assessment_types` (`id`, `type`, `assessment_min_marks`, `assessment_max_marks`, `term_exam_out_of_marks`, `description`, `status`, `created_at`, `updated_at`) VALUES (3, 'Class Test', '7', '20', '5', 'Worksheet', 1, '2025-03-06 13:44:52', '2025-07-05 14:31:30');
INSERT INTO `assessment_types` (`id`, `type`, `assessment_min_marks`, `assessment_max_marks`, `term_exam_out_of_marks`, `description`, `status`, `created_at`, `updated_at`) VALUES (4, 'SEA', '1', '5', '5', 'SEA', 3, '2025-03-06 13:57:10', '2025-10-21 19:05:33');
INSERT INTO `assessment_types` (`id`, `type`, `assessment_min_marks`, `assessment_max_marks`, `term_exam_out_of_marks`, `description`, `status`, `created_at`, `updated_at`) VALUES (5, 'N-Book', '1', '5', '5', 'N-Book', 1, '2025-03-06 13:57:30', '2025-07-01 14:43:30');
INSERT INTO `assessment_types` (`id`, `type`, `assessment_min_marks`, `assessment_max_marks`, `term_exam_out_of_marks`, `description`, `status`, `created_at`, `updated_at`) VALUES (6, 'Class Work', '7', '20', '5', '', 1, '2025-03-06 13:57:40', '2025-03-31 00:57:48');
INSERT INTO `assessment_types` (`id`, `type`, `assessment_min_marks`, `assessment_max_marks`, `term_exam_out_of_marks`, `description`, `status`, `created_at`, `updated_at`) VALUES (7, 'test', '45', '54', '100', '', 3, '2025-06-16 10:20:16', '2025-07-01 14:42:25');
INSERT INTO `assessment_types` (`id`, `type`, `assessment_min_marks`, `assessment_max_marks`, `term_exam_out_of_marks`, `description`, `status`, `created_at`, `updated_at`) VALUES (8, 'HOME WORK', '10', '20', '20', '', 1, '2025-10-28 11:24:19', NULL);


#
# TABLE STRUCTURE FOR: assessments
#

DROP TABLE IF EXISTS `assessments`;

CREATE TABLE `assessments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `subject_group_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `assessment_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `status` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4;

INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (1, 6, 18, 20, 1, 1, 2, 'HW1', 1, '2024-10-02 15:50:00', '2025-03-12 12:28:26');
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (2, 6, 18, 20, 1, 1, 2, 'HW2', 1, '2024-10-02 15:50:00', '2025-03-12 12:28:59');
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (3, 6, 18, 20, 1, 1, 3, 'WS-1', 1, '2025-03-29 16:02:50', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (4, 6, 18, 20, 1, 1, 3, 'WS-2', 1, '2025-03-29 16:02:50', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (7, 6, 18, 20, 1, 2, 2, 'HW3', 1, '2025-04-08 15:17:27', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (8, 6, 18, 20, 1, 2, 2, 'HW4', 1, '2025-04-08 15:17:27', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (9, 6, 18, 20, 1, 2, 3, 'HW5', 1, '2025-04-08 15:18:34', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (10, 6, 18, 20, 1, 2, 3, 'HW6', 1, '2025-04-08 15:18:34', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (13, 6, 18, 20, 1, 4, 2, 'HW7', 1, '2025-04-08 15:21:11', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (14, 6, 18, 20, 1, 4, 2, 'HW8', 1, '2025-04-08 15:21:11', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (15, 6, 18, 20, 1, 4, 3, 'WS3', 1, '2025-04-08 15:22:03', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (16, 6, 18, 20, 1, 4, 3, 'WS4', 1, '2025-04-08 15:22:03', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (17, 37, 28, 24, 2, 1, 2, 'HW', 1, '2025-07-05 14:21:57', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (18, 36, 28, 23, 1, 1, 2, 'HW1', 1, '2025-09-14 16:32:42', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (19, 29, 28, 36, 1, 1, 8, 'MONTHLY', 1, '2025-10-28 11:25:01', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (20, 29, 28, 36, 1, 2, 8, 'MONTLY', 1, '2025-10-28 11:25:41', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (21, 29, 28, 36, 1, 2, 8, 'MONTLY', 1, '2025-10-28 11:25:43', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (22, 29, 28, 36, 1, 2, 8, 'MONTLY', 1, '2025-10-28 11:25:44', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (23, 29, 28, 36, 1, 19, 8, 'MONTHLY', 1, '2025-10-28 11:27:30', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (24, 29, 28, 36, 1, 27, 8, 'HOME WORK', 1, '2025-10-28 11:34:18', NULL);


#
# TABLE STRUCTURE FOR: attendence_type
#

DROP TABLE IF EXISTS `attendence_type`;

CREATE TABLE `attendence_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `key_value` varchar(50) NOT NULL,
  `long_lang_name` varchar(250) DEFAULT NULL,
  `long_name_style` varchar(250) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `for_qr_attendance` int(11) NOT NULL DEFAULT '1',
  `for_schedule` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `for_schedule`, `created_at`, `updated_at`) VALUES (1, 'Present', '<b class=\"text text-success\">P</b>', 'present', 'label label-success', 'yes', 1, 1, '2023-12-13 13:23:10', '0000-00-00 00:00:00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `for_schedule`, `created_at`, `updated_at`) VALUES (2, 'Late With Excuse', '<b class=\"text text-warning\">E</b>', 'late_with_excuse', 'label label-warning text-dark', 'no', 0, 0, '2023-12-13 13:21:03', '0000-00-00 00:00:00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `for_schedule`, `created_at`, `updated_at`) VALUES (3, 'Late', '<b class=\"text text-warning\">L</b>', 'late', 'label label-warning text-dark', 'yes', 1, 1, '2023-12-13 13:21:09', '0000-00-00 00:00:00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `for_schedule`, `created_at`, `updated_at`) VALUES (4, 'Absent', '<b class=\"text text-danger\">A</b>', 'absent', 'label label-danger', 'yes', 0, 0, '2023-12-15 11:48:05', '0000-00-00 00:00:00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `for_schedule`, `created_at`, `updated_at`) VALUES (5, 'Holiday', 'H', 'holiday', 'label label-info', 'yes', 0, 0, '2023-12-14 18:27:13', '0000-00-00 00:00:00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `for_schedule`, `created_at`, `updated_at`) VALUES (6, 'Half Day', '<b class=\"text text-warning\">F</b>', 'half_day', 'label label-warning text-dark', 'yes', 1, 1, '2023-12-15 11:48:37', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: aws_s3_settings
#

DROP TABLE IF EXISTS `aws_s3_settings`;

CREATE TABLE `aws_s3_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `api_key` varchar(250) DEFAULT NULL,
  `api_secret` varchar(250) DEFAULT NULL,
  `bucket_name` varchar(250) DEFAULT NULL,
  `region` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `aws_s3_settings` (`id`, `api_key`, `api_secret`, `bucket_name`, `region`) VALUES (1, '34', 'attu', '112', '12');


#
# TABLE STRUCTURE FOR: bank_details
#

DROP TABLE IF EXISTS `bank_details`;

CREATE TABLE `bank_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_number` varchar(255) NOT NULL,
  `bank_name` varchar(255) NOT NULL,
  `branch_name` varchar(255) NOT NULL,
  `ac_holder_name` varchar(255) NOT NULL,
  `ifsc_code` varchar(255) NOT NULL,
  `is_primary` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

INSERT INTO `bank_details` (`id`, `account_number`, `bank_name`, `branch_name`, `ac_holder_name`, `ifsc_code`, `is_primary`, `status`, `created_at`, `updated_at`) VALUES (1, '032411011003', 'bank of india', 'BODA', 'Dummy', 'BKID009959', '', '1', '2024-07-19 23:02:19', '2025-06-24 13:32:28');
INSERT INTO `bank_details` (`id`, `account_number`, `bank_name`, `branch_name`, `ac_holder_name`, `ifsc_code`, `is_primary`, `status`, `created_at`, `updated_at`) VALUES (2, '03211100023', '', 'bkid009969', 'Ashok Singh Rajput', 'bkid009969', 'on', '0', '2024-07-19 23:04:02', '2025-06-24 13:32:33');
INSERT INTO `bank_details` (`id`, `account_number`, `bank_name`, `branch_name`, `ac_holder_name`, `ifsc_code`, `is_primary`, `status`, `created_at`, `updated_at`) VALUES (3, '098765433', '', 'india', 'ashok', 'bkdir3435', '', '0', '2024-07-19 23:04:45', '2025-06-24 13:32:38');


#
# TABLE STRUCTURE FOR: behaviour_settings
#

DROP TABLE IF EXISTS `behaviour_settings`;

CREATE TABLE `behaviour_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `comment_option` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `behaviour_settings` (`id`, `comment_option`, `created_at`) VALUES (1, '[\"student\",\"parent\"]', '2022-12-31 11:49:38');


#
# TABLE STRUCTURE FOR: book_issues
#

DROP TABLE IF EXISTS `book_issues`;

CREATE TABLE `book_issues` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `book_id` int(11) NOT NULL,
  `member_id` int(11) DEFAULT NULL,
  `duereturn_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `is_returned` int(11) DEFAULT '0',
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `book_id` (`book_id`),
  KEY `member_id` (`member_id`),
  CONSTRAINT `book_issues_ibfk_1` FOREIGN KEY (`book_id`) REFERENCES `books` (`id`) ON DELETE CASCADE,
  CONSTRAINT `book_issues_ibfk_2` FOREIGN KEY (`member_id`) REFERENCES `libarary_members` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: books
#

DROP TABLE IF EXISTS `books`;

CREATE TABLE `books` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `book_title` varchar(100) NOT NULL,
  `book_no` varchar(50) NOT NULL,
  `isbn_no` varchar(100) NOT NULL,
  `subject` varchar(100) DEFAULT NULL,
  `rack_no` varchar(100) NOT NULL,
  `publish` varchar(100) DEFAULT NULL,
  `author` varchar(100) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `perunitcost` float(10,2) DEFAULT NULL,
  `postdate` date DEFAULT NULL,
  `description` text,
  `available` varchar(10) DEFAULT 'yes',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: captcha
#

DROP TABLE IF EXISTS `captcha`;

CREATE TABLE `captcha` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`, `updated_at`) VALUES (1, 'userlogin', 0, '2021-01-19 13:40:29', '2025-04-10 03:22:05');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`, `updated_at`) VALUES (2, 'login', 0, '2021-01-19 13:40:31', '2025-04-10 03:22:05');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`, `updated_at`) VALUES (3, 'admission', 0, '2021-01-19 10:18:11', '2025-04-10 03:22:05');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`, `updated_at`) VALUES (4, 'complain', 0, '2021-01-19 10:18:13', '2025-04-10 03:22:05');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`, `updated_at`) VALUES (5, 'contact_us', 0, '2021-01-19 10:18:15', '2025-04-10 03:22:05');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`, `updated_at`) VALUES (6, 'guest_login_signup', 0, '2022-12-07 07:11:31', '2025-04-10 03:33:30');


#
# TABLE STRUCTURE FOR: cast_management
#

DROP TABLE IF EXISTS `cast_management`;

CREATE TABLE `cast_management` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) DEFAULT NULL,
  `castname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=785 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (1, 1, 'Rajput');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (3, 1, 'Parmar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (4, 1, 'Bhati');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (5, 2, 'julha');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (6, 6, 'Berad');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (7, 6, 'Bestar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (8, 6, 'Bhamta');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (9, 6, 'Kaikadi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (10, 6, 'Kanjarbhat');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (11, 6, 'Katabu');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (12, 6, 'Banjara');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (13, 6, 'Raj Pardhi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (14, 6, 'Rajput Bhamta');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (15, 6, 'Ramoshi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (16, 6, 'Vadar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (17, 6, 'Vaghari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (18, 6, 'Chhapparband');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (19, 7, 'Gosavi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (20, 7, 'Beldar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (21, 7, 'Bharadi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (22, 7, 'Bhute');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (23, 7, 'Chitrakathi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (24, 7, 'Garudi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (25, 7, 'Lohar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (26, 7, 'Golla');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (27, 7, 'Gondhali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (28, 7, 'Gopal');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (29, 7, 'Helve');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (30, 7, 'Joshi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (31, 7, 'Kashi Kapadi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (32, 7, 'Kolhati');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (33, 7, 'Mairal');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (34, 7, 'Masanjogi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (35, 7, 'Nandiwale');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (36, 7, 'Pangul');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (37, 7, 'Raval');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (38, 7, 'Sikkalgar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (39, 7, 'Vaidu');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (40, 7, 'Vasudeo');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (41, 7, 'Bhoi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (42, 7, 'Bahurupi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (43, 7, 'Otari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (44, 7, 'Mariaiwale');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (45, 7, 'Kadaklaxmiwale');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (46, 7, 'Margammawale');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (47, 7, 'Gihara');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (48, 7, 'Gusai');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (49, 7, 'Muslim Madari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (50, 7, 'Gahara');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (51, 7, 'Gosai');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (52, 7, 'Gaarudi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (53, 7, 'Saapwale');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (54, 7, 'Jadoogar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (55, 7, 'Indian Irani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (56, 7, 'Indian Irani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (57, 7, 'Muslim Gawli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (58, 7, 'Gavlaan');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (59, 7, 'Gvalvansh');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (60, 7, 'Gopal Gawli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (61, 7, 'Gawli Gopal');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (62, 7, 'Darwesi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (63, 7, 'Vaghwale Shah');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (64, 7, 'Aswalwale');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (65, 7, 'Bagdi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (66, 8, 'Thelari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (67, 8, 'Gadariya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (68, 8, 'Gadariya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (69, 8, 'Dongri Dhangar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (70, 8, 'Dangedhangar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (71, 8, 'Gadhari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (72, 8, 'Gadri');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (73, 8, 'Gadariya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (74, 8, 'Dhanwar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (75, 8, 'Sangar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (76, 8, 'Ladse');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (77, 8, 'Mahure');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (78, 8, 'Kurmar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (79, 8, 'Zende');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (80, 8, 'Zade');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (81, 8, 'Varhade Dhangar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (82, 8, 'Kanade');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (83, 8, 'Kokni- Dhangar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (84, 8, 'Tellari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (85, 8, 'Telangi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (86, 8, 'Khutekar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (87, 8, 'Segar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (88, 8, 'Sagar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (89, 8, 'Shegar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (90, 8, 'Haatkar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (91, 8, 'Hatkar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (92, 8, 'Telwar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (93, 8, 'Hande');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (94, 8, 'Gatari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (95, 8, 'Dange');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (96, 8, 'Dhangar Ahir');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (97, 8, 'Ahir');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (98, 8, 'Dhangar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (99, 9, 'Vanjari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (100, 9, 'Vanjar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (101, 9, 'Vanjara');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (102, 9, 'Lad Vanjari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (103, 2, 'Gurav');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (104, 2, 'Lingayat Gurav');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (105, 2, 'Gavandi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (106, 2, 'Gurjar-Kadiya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (107, 2, 'Halepaik');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (108, 2, 'Jagiasi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (109, 2, 'Jajak');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (110, 2, 'Jatiya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (111, 2, 'Jatigar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (112, 2, 'Javeri');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (113, 2, 'Parjiya Soni');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (114, 2, 'Jogin');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (115, 2, 'Johari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (116, 2, 'Julaha');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (117, 2, 'Ansari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (118, 2, 'Jangam');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (119, 2, 'Malajangam (Virbhadra)');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (120, 2, 'Lingayat Jangam');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (121, 2, 'Chitari-Jingar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (122, 2, 'Jadi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (123, 2, 'Kammi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (124, 2, 'Kapdi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (125, 2, 'Khati');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (126, 2, 'Kongadi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (127, 2, 'Korchar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (128, 2, 'Kachora');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (129, 2, 'Kadera');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (130, 2, 'Kasbi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (131, 2, 'Kuchbandh');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (132, 2, 'Kuchhria');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (133, 2, 'Kumbhar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (134, 2, 'Kumhar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (135, 2, 'Kumbara');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (136, 2, 'Kumbhara');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (137, 2, 'Kulala');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (138, 2, 'Mulya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (139, 2, 'Lingayat Kumbhar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (140, 2, 'Kunbi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (141, 2, 'Lewa Kunbi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (142, 2, 'Lewa Patil');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (143, 2, 'Lewa Patidar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (144, 2, 'Maratha Kunbi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (145, 2, 'Kunbi Maratha');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (146, 2, 'Tilori Kunbi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (147, 2, 'Tillori Kunbi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (148, 2, 'Ti.Kunbi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (149, 2, 'Kachi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (150, 2, 'Kachhi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (151, 2, 'Kachhia');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (152, 2, 'Koiri');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (153, 2, 'Koeeri');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (154, 2, 'Koyari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (155, 2, 'Kushvaha');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (156, 2, 'Alitkar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (157, 2, 'Badia');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (158, 2, 'Bajania');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (159, 2, 'Bajigar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (160, 2, 'Buttal');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (161, 2, 'Bhand');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (162, 2, 'Chhapparbhand');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (163, 2, 'Muslim Bhand');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (164, 2, 'Bhavaiya or Targala');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (165, 2, 'Bhavin');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (166, 2, 'Bhisti or Pakhali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (167, 2, 'Sakka');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (168, 2, 'Bari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (169, 2, 'Barai');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (170, 2, 'Baria');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (171, 2, 'Basdewa');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (172, 2, 'Bhadbhunja');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (173, 2, 'Bhujwa');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (174, 2, 'Bhurjawa');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (175, 2, 'Bhurji');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (176, 2, 'Bharadbhunga');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (177, 2, 'Bhuranji');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (178, 2, 'Bhunj');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (179, 2, 'Bhanta');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (180, 2, 'Bhat');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (181, 2, 'Bhaat');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (182, 2, 'Chamtha');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (183, 2, 'Chandalgada');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (184, 2, 'Charan or Gadhavi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (185, 2, 'Charodi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (186, 2, 'Chippa, Chhipa');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (187, 2, 'Das or Dangdidas');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (188, 2, 'Davgar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (189, 2, 'Depala');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (190, 2, 'Devli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (191, 2, 'Devdig');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (192, 2, 'Dewadiga');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (193, 2, 'Sherigar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (194, 2, 'Moili');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (195, 2, 'Dholi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (196, 2, 'Hashmi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (197, 2, 'Dafali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (198, 2, 'Gandharap');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (199, 2, 'Gujrath Baori');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (200, 2, 'Gadhavi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (201, 2, 'Gochaki');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (202, 2, 'Patkar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (203, 2, 'Somwanshiy Sahastrarjun Kshatriya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (204, 2, 'Patwekari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (205, 2, 'Patwegar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (206, 2, 'Pategar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (207, 2, 'Pattegar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (208, 2, 'Patwi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (209, 2, 'Kshtriya Patkar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (210, 2, 'Khatri');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (211, 2, 'Kshatriya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (212, 2, 'Phulari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (213, 2, 'Lingayat Phulari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (214, 2, 'Rachevar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (215, 2, 'Raikari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (216, 2, 'Rayikar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (217, 2, 'Bandi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (218, 2, 'Rachbandhia');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (219, 2, 'Raot');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (220, 2, 'Rawt');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (221, 2, 'Rautia');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (222, 2, 'Sanjogi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (223, 2, 'Sarania');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (224, 2, 'Suppaling');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (225, 2, 'Saplig');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (226, 2, 'Sapliga');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (227, 2, 'Sapaliga');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (228, 2, 'sapalig');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (229, 2, 'Suplig');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (230, 2, 'Suppalig');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (231, 2, 'Suppaliga');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (232, 2, 'suppalig');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (233, 2, 'sappaliga');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (234, 2, 'Sutharia');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (235, 2, 'Sahis');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (236, 2, 'Sais');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (237, 2, 'Shis');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (238, 2, 'Sapera');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (239, 2, 'Shilavat');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (240, 2, 'Shimpi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (241, 2, 'Idrisi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (242, 2, 'Kachhi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (243, 2, 'Kushvah');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (244, 2, 'Shakya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (245, 2, 'Mourya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (246, 2, 'Murai');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (247, 2, 'Saini');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (248, 2, 'Kathi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (249, 2, 'Kasar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (250, 2, 'Kanchar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (251, 2, 'Kachari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (252, 2, 'Labha');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (253, 2, 'Ladia');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (254, 2, 'Ladhia');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (255, 2, 'Laria');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (256, 2, 'Ladaff');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (257, 2, 'Laiddaf');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (258, 2, 'Lakheria');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (259, 2, 'Hadad');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (260, 2, 'Mistri');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (261, 2, 'Luhar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (262, 2, 'Luvar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (263, 2, 'Manbhav');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (264, 2, 'Manbhav');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (265, 2, 'Bhopi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (266, 2, 'Manbhav Bhopi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (267, 2, 'Marwar Bori');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (268, 2, 'Me');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (269, 2, 'Mina');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (270, 2, 'Mahli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (271, 2, 'Medar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (272, 2, 'Mhali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (273, 2, 'Mitha');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (274, 2, 'Mathura');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (275, 2, 'Namdhari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (276, 2, 'Namdhari Paik');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (277, 2, 'Nirshikari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (278, 2, 'Navi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (279, 2, 'Nhavi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (280, 2, 'Salmani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (281, 2, 'Hajam');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (282, 2, 'varik');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (283, 2, 'Nabhik');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (284, 2, 'Napit');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (285, 2, 'Mhali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (286, 2, 'valand');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (287, 2, 'Hadpad');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (288, 2, 'Hajjam');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (289, 2, 'Navisen');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (290, 2, 'Salmaniya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (291, 2, 'Lingayat Nhavi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (292, 2, 'Nethura');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (293, 2, 'Nonia');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (294, 2, 'Lonia');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (295, 2, 'Luniya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (296, 2, 'Nuniya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (297, 2, 'Nakkashi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (298, 2, 'Neeli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (299, 2, 'Neelkanti');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (300, 2, 'Nekar Jada');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (301, 2, 'Padharia');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (302, 2, 'Padiar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (303, 2, 'Patradavaru');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (304, 2, 'Phasechari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (305, 2, 'Phudgi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (306, 2, 'Pakhali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (307, 2, 'Sakka');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (308, 2, 'Panchal');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (309, 2, 'Panka');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (310, 2, 'Perki');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (311, 2, 'Perkewad');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (312, 2, 'Perika');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (313, 2, 'Perike');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (314, 2, 'Perka');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (315, 2, 'Putaligar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (316, 2, 'Pareet');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (317, 2, 'Dhobi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (318, 2, 'Telgu Madelvar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (319, 2, 'Madwal');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (320, 2, 'Vatti');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (321, 2, 'Vatas');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (322, 2, 'Rajak');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (323, 2, 'Darji');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (324, 2, 'Saisutar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (325, 2, 'Jain Shimpi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (326, 2, 'Shravak Shimpi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (327, 2, 'Shetwal');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (328, 2, 'Shetwal');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (329, 2, 'Saitwal');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (330, 2, 'Saitwal');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (331, 2, 'Meru Shimpi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (332, 2, 'Meru Kshatriya Shimpi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (333, 2, 'Telgu Darji');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (334, 2, 'Telgu Shimpi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (335, 2, 'Namdev Shimpi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (336, 2, 'Sonar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (337, 2, 'Marwadi Sonar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (338, 2, 'Marwadi Sunar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (339, 2, 'Marwadi Swarnkar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (340, 2, 'Tandel');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (341, 2, 'Targala');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (342, 2, 'Thetwar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (343, 2, 'Thoria');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (344, 2, 'Tambat');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (345, 2, 'Twashta Kasar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (346, 2, 'Kasar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (347, 2, 'Thogti');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (348, 2, 'wadi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (349, 2, 'Wansfoda');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (350, 2, 'Hindu Dharkar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (351, 2, 'Yerkula');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (352, 2, 'Agri');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (353, 2, 'Agale or Kalan');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (354, 2, 'Bhawasar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (355, 2, 'Rangari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (356, 2, 'Bhawsar Kshatriya Shimpi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (357, 2, 'Rangrez');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (358, 2, 'Rangrej');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (359, 2, 'Kurhinshetty');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (360, 2, 'Nilgar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (361, 2, 'Nili');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (362, 2, 'Nirali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (363, 2, 'Koskanti Devanga');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (364, 2, 'Sutar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (365, 2, 'Suthar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (366, 2, 'Lingayat Pareet');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (367, 2, 'Lingayat Dhobi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (368, 2, 'Warthi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (369, 2, 'Ghadshi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (370, 2, 'Tamboli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (371, 2, 'Muslim Religious Panpharosh');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (372, 2, 'Christians');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (373, 2, 'Lanzad');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (374, 2, 'Lazad');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (375, 2, 'Yadav');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (376, 2, 'Ahir');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (377, 2, 'Ladsi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (378, 2, 'Atar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (379, 2, 'Audhiya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (380, 2, 'Badak');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (381, 2, 'Barav');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (382, 2, 'Baglu');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (383, 2, 'Marvar Baori');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (384, 2, 'Marbar vaghari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (385, 2, 'Udasi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (386, 2, 'Balsanthanam');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (387, 2, 'Mathura Banjara');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (388, 2, 'Shingade Banjara');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (389, 2, 'Lambade');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (390, 2, 'Fanade Banjara');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (391, 2, 'Sunar Banjara');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (392, 2, 'Dhalia Banjara');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (393, 2, 'Shingadya Banjara');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (394, 2, 'Baoriya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (395, 2, 'Koli Bariya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (396, 2, 'Bathini');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (397, 2, 'Wadhai');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (398, 2, 'Badhi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (399, 2, 'Wadhai');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (400, 2, 'Baadhai');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (401, 2, 'Badhai');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (402, 2, 'wadhi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (403, 2, 'Wadi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (404, 2, 'Wadhai');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (405, 2, 'Zade Sutar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (406, 2, 'Panchal Sutar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (407, 2, 'Lingayat Sutar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (408, 2, 'Futgudi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (409, 2, 'Pinjara');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (410, 2, 'Pinjari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (411, 2, 'Mansoori');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (412, 2, 'Bhilala');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (413, 2, 'Teli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (414, 2, 'Tilvan Teli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (415, 2, 'Maratha Teli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (416, 2, 'Tarane Teli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (417, 2, 'Deshkar Teli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (418, 2, 'Erandel  Teli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (419, 2, 'Lingayat Teli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (420, 2, 'Ekbail Teli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (421, 2, 'Don Bail Teli Savteli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (422, 2, 'Ek bahiya teli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (423, 2, 'Ghaunchi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (424, 2, 'Mali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (425, 2, 'Phulmali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (426, 2, 'Phule');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (427, 2, 'Halade');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (428, 2, 'Kacha');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (429, 2, 'Kadu');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (430, 2, 'Bawane');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (431, 2, 'Adhprabhu');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (432, 2, 'Adhsheti');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (433, 2, 'Jire');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (434, 2, 'Begari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (435, 2, 'Pardeshi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (436, 2, 'Pong');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (437, 2, 'Dasar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (438, 2, 'Uchila');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (439, 2, 'Bhandura');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (440, 2, 'Billava');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (441, 2, 'Thiya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (442, 2, 'Belchheda');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (443, 2, 'Kharvi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (444, 2, 'Dheewar Bhoi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (445, 2, 'Bindali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (446, 2, 'Burbuk');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (447, 2, 'Chadar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (448, 2, 'Chakravadya-Dasar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (449, 2, 'Chandal');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (450, 2, 'Chenvu');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (451, 2, 'Chenvavar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (452, 2, 'Chimur');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (453, 2, 'Chintala');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (454, 2, 'Dakaleru');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (455, 2, 'Darji');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (456, 2, 'Kurba');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (457, 2, 'Kurubar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (458, 2, 'Harkantra');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (459, 2, 'Mangeli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (460, 2, 'Mangele');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (461, 2, 'Page');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (462, 2, 'Sanduri');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (463, 2, 'Dommara');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (464, 2, 'Gadaba');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (465, 2, 'Godba');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (466, 2, 'Gangani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (467, 2, 'Garodi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (468, 2, 'Goller');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (469, 2, 'Godala');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (470, 2, 'Habura');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (471, 2, 'Harani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (472, 2, 'Hil-Redidas');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (473, 2, 'Deveri');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (474, 2, 'Vinakar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (475, 2, 'vanya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (476, 2, 'Banakar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (477, 2, 'Bunkar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (478, 2, 'Kachhiya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (479, 2, 'Korach');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (480, 2, 'Padlor');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (481, 2, 'Kalal');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (482, 2, 'Kalar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (483, 2, 'Lad');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (484, 2, 'Ladvak');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (485, 2, 'Gaud');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (486, 2, 'Shivhare');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (487, 2, 'Jain Kalar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (488, 2, 'Lad Bramhan');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (489, 2, 'Kandel');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (490, 2, 'Kasera');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (491, 2, 'Kasai');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (492, 2, 'Kasab');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (493, 2, 'Qureshi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (494, 2, 'Katipamula');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (495, 2, 'Kirar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (496, 2, 'Christian Koli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (497, 2, 'Unde');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (498, 2, 'Lingayat Mali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (499, 2, 'Bagwan');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (500, 2, 'Bharat Bagwan');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (501, 2, 'Marar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (502, 2, 'Maral');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (503, 2, 'Kosare');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (504, 2, 'Gase');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (505, 2, 'Vanmali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (506, 2, 'Savtamali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (507, 2, 'Pachkalshi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (508, 2, 'Chaukalshi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (509, 2, 'Vadval');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (510, 2, 'Rain (Bagwan)');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (511, 2, 'Kunjada  (Muslim Religious)');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (512, 2, 'Somvanshiya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (513, 2, 'Pathare Kshatriya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (514, 2, 'Pathare-Kshatriya Pachkalshi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (515, 2, 'Pathare Kshatriya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (516, 2, 'Sutar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (517, 2, 'Sastikar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (518, 2, 'Ghodekhau');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (519, 2, 'S.K.P.');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (520, 2, 'Lonari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (521, 2, 'Talwar-Kanade/Kanadi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (522, 2, 'Raghavi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (523, 2, 'Bhandari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (524, 2, 'Bawarchi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (525, 2, 'Bhatiara');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (526, 2, 'Ganali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (527, 2, 'Gandali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (528, 2, 'Powar or Pawar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (529, 2, 'Bhoyar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (530, 2, 'Bhoir');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (531, 2, 'Bhoyeer');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (532, 2, 'Kathar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (533, 2, 'Kathar Wani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (534, 2, 'Kanthahar Wani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (535, 2, 'Vaishyawani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (536, 2, 'Vaishya Wani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (537, 2, 'Vai.Wani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (538, 2, 'Vaishya Wani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (539, 2, 'Korachar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (540, 2, 'Korve');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (541, 2, 'Kodaku sah Korva');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (542, 2, 'Kondu');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (543, 2, 'Komakapu');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (544, 2, 'Lakhari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (545, 2, 'Lohar-Gada');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (546, 2, 'Dodi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (547, 2, 'Khatawali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (548, 2, 'Paanchal');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (549, 2, 'Panchal');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (550, 2, 'Chunari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (551, 2, 'Chenewala');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (552, 2, 'Chunewale');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (553, 2, 'Mahil');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (554, 2, 'Maidasi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (555, 2, 'Mazvar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (556, 2, 'Matiyara');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (557, 2, 'Matihara');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (558, 2, 'Mankar Khalu');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (559, 2, 'Mondivar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (560, 2, 'Mondivara');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (561, 2, 'Munda');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (562, 2, 'Hajam');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (563, 2, 'Kalseru');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (564, 2, 'Navliga');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (565, 2, 'Kanshi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (566, 2, 'Nabhik');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (567, 2, 'Nai');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (568, 2, 'Valand');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (569, 2, 'Pachbhotla');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (570, 2, 'Pachbotla');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (571, 2, 'Padampari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (572, 2, 'Bhisti');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (573, 2, 'Pamula');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (574, 2, 'V.Wani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (575, 2, 'Panari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (576, 2, 'Kulvant Wani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (577, 2, 'Ku.Wani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (578, 2, 'Wani (Kulvant)');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (579, 2, 'Kulvant-Wani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (580, 2, 'Kunbi Wani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (581, 2, 'Ladshakhiy  Wani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (582, 2, 'Nevi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (583, 2, 'Dhakad');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (584, 2, 'Mitkari Wani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (585, 2, 'Wani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (586, 2, 'Boral');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (587, 2, 'Boraal');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (588, 2, 'Borul');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (589, 2, 'Borad');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (590, 2, 'Tamboli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (591, 2, 'Lingayat Wani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (592, 2, 'Lingayat Tamboli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (593, 2, 'Momin');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (594, 2, 'Fakir Bandarwala');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (595, 2, 'Hanbar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (596, 2, 'Dode Gujar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (597, 2, 'Gujar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (598, 2, 'Leve Gujar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (599, 2, 'Reve Gujar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (600, 2, 'Reva Gujar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (601, 2, 'Suryavanshi Gujar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (602, 2, 'Badgujar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (603, 2, 'Londhari/ Pendhari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (604, 2, 'Pahad / Pahadi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (605, 2, 'Panchama');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (606, 2, 'Pancham');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (607, 2, 'Panda');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (608, 2, 'Phar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (609, 2, 'Pinjari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (610, 2, 'Purwali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (611, 2, 'Rachbhoya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (612, 2, 'Rautiya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (613, 2, 'Sangari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (614, 2, 'Santal');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (615, 2, 'Saunta');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (616, 2, 'Sonta');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (617, 2, 'Savteli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (618, 2, 'Sare');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (619, 2, 'Bhavgar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (620, 2, 'Shiv Shimpi,');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (621, 2, 'Namdev');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (622, 2, 'Shingdav');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (623, 2, 'Shingadya');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (624, 2, 'Sindhur');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (625, 2, 'Soren');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (626, 2, 'Sunna');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (627, 2, 'Sunnai');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (628, 2, 'Bhadai');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (629, 2, 'Ganiga');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (630, 2, 'Ganig');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (631, 2, 'Ganchi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (632, 2, 'Thotevadu');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (633, 2, 'Timali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (634, 2, 'Walwai');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (635, 2, 'Wadder');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (636, 2, 'Kalawader');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (637, 2, 'Pathroad');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (638, 2, 'Vanadi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (639, 2, 'Yenadivadas');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (640, 2, 'Yergolawad');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (641, 2, 'Thella Pamalvadas');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (642, 2, 'Odevar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (643, 2, 'Manyar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (644, 2, 'Bangadeewala');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (645, 2, 'Manyar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (646, 2, 'Maniyaar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (647, 2, 'Maneri');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (648, 2, 'Jaatgaar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (649, 2, 'Karadi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (650, 2, 'Kunkuwale');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (651, 2, 'Khatwadhai');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (652, 2, 'Kohli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (653, 2, 'Khatik');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (654, 2, 'Qureshi Khatik');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (655, 2, 'Kasai');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (656, 2, 'Dangari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (657, 2, 'Vedu');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (658, 2, 'Waaghari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (659, 2, 'Dhawad');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (660, 2, 'Nirhali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (661, 2, 'Nirali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (662, 2, 'Chitrakathi Hardas');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (663, 2, 'Besta');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (664, 2, 'Besti');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (665, 2, 'Bestallu');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (666, 2, 'Parivar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (667, 2, 'Savkalar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (668, 2, 'Kanadi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (669, 2, 'Kanodi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (670, 2, 'Gawada');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (671, 2, 'Gawade');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (672, 2, 'GAWADA');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (673, 2, 'GAVADA');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (674, 2, 'GAWADE');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (675, 2, 'GAVADE');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (676, 2, 'Gurdi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (677, 2, 'Gurdi-Kapewar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (678, 2, 'Guradi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (679, 2, 'Gurda-Kapewar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (680, 2, 'Gurad-Kapu');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (681, 2, 'Gurdi-reddy');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (682, 2, 'Marvadi Nhavi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (683, 2, 'Rathod');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (684, 2, 'Machhimar (Daldi)');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (685, 2, 'Bhaldar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (686, 2, 'Alakari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (687, 2, 'Pendhari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (688, 2, 'Yalam / Yelam / Yallam');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (689, 2, 'Mahat/ Mahoot, Mahawat');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (690, 2, 'Fakir');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (691, 2, 'Lodh');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (692, 2, 'Lodha');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (693, 2, 'Lodhi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (694, 2, 'Nalband');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (695, 2, 'Kulekadagi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (696, 2, 'Kullekadgi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (697, 2, 'Kulakadgi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (698, 2, 'Kullakadagi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (699, 2, 'Lingayat Kullakadagi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (700, 2, 'Mujawar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (701, 2, 'Mulana');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (702, 2, 'Mulani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (703, 2, 'Mulane');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (704, 2, 'East Indian');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (705, 2, 'East Indian Christian');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (706, 2, 'East Indian Catholic');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (707, 2, 'Nevewani');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (708, 2, 'Muslim religious Kakar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (709, 2, 'Dorik');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (710, 2, 'Patva');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (711, 5, 'Govari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (712, 5, 'Gawari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (713, 5, 'Koshti');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (714, 5, 'Hadgar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (715, 5, 'Halba koshti');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (716, 5, 'Sali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (717, 5, 'Swakul Sali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (718, 5, 'Ladkoshti');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (719, 5, 'Gadhewal Koshti');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (720, 5, 'Deshkar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (721, 5, 'Padmashali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (722, 5, 'salewar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (723, 5, 'chenewar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (724, 5, 'chanewar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (725, 5, 'channewar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (726, 5, 'Devang');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (727, 5, 'Kachi bandhe');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (728, 5, 'Patwis');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (729, 5, 'Satsale');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (730, 5, 'Sade');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (731, 5, 'Jainkoshti');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (732, 5, 'Jainkoshti koshti');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (733, 5, 'Lingayat Devang');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (734, 5, 'Lingayat Sali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (735, 5, 'Koli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (736, 5, 'Machhimar koli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (737, 5, 'Ahir koli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (738, 5, 'Khandeshi koli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (739, 5, 'Pan koli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (740, 5, 'Christian koli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (741, 5, 'Chumble koli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (742, 5, 'Panbhare koli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (743, 5, 'Koli suryavanshi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (744, 5, 'Mangela');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (745, 5, 'sonkoli');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (746, 5, 'Vaiti');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (747, 5, 'Kharva, kharvi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (748, 5, 'Machhi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (749, 5, 'Mitna');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (750, 5, 'Machhi - Mitna');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (751, 5, 'Munnerwar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (752, 5, 'Munnurwar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (753, 5, 'Munnur');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (754, 5, 'Telgu munnur');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (755, 5, 'Munnurwar telgu');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (756, 5, 'Telgu kapewar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (757, 5, 'Munnarwad');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (758, 5, 'Telgu Phulmali');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (759, 5, 'Gabit');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (760, 5, 'Muslim Religious Bhangi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (761, 5, 'Mehtar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (762, 5, 'Lalbeg');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (763, 5, 'Halalkhor');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (764, 5, 'Khakrob');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (765, 1, 'Maratha');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (766, 1, 'Brahmin');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (767, 1, 'Muslim');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (768, 1, 'Lingayat');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (769, 3, 'Mang');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (770, 1, 'Marwadi');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (771, 6, 'vanjari');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (772, 2, 'Yalam');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (773, 2, 'Yelam');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (774, 2, 'Yallam');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (775, 3, 'Mahar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (776, 1, 'Komati');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (777, 2, 'Parit');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (778, 11, 'Jain');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (779, 11, 'Jain');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (780, 3, 'Vadar');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (781, 4, 'Koli Mahadev');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (782, 1, 'kushal');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (783, 1, 'Patel');
INSERT INTO `cast_management` (`id`, `category_id`, `castname`) VALUES (784, 1, 'Patel');


#
# TABLE STRUCTURE FOR: categories
#

DROP TABLE IF EXISTS `categories`;

CREATE TABLE `categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(100) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'GENERAL', 'no', '2025-04-16 00:53:40', '2025-04-16 00:53:40');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'OBC', 'no', '2025-04-16 00:53:45', '2025-04-16 00:53:45');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'SC', 'no', '2025-04-16 00:53:48', '2025-04-16 00:53:48');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'ST', 'no', '2025-04-16 00:53:52', '2025-04-16 00:53:52');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'SBC', 'no', '2025-04-16 00:53:54', '2025-04-16 00:53:54');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'VJNT', 'no', '2025-04-16 00:53:57', '2025-04-16 00:53:57');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'NT-B', 'no', '2025-04-16 00:54:00', '2025-04-16 00:54:00');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'NT-C', 'no', '2025-04-16 00:54:02', '2025-04-16 00:54:02');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'NT-D', 'no', '2025-04-16 00:54:07', '2025-04-16 00:54:07');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'NBC', 'no', '2025-04-16 00:54:11', '2025-04-16 00:54:11');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'MINORITY', 'no', '2025-04-16 00:54:14', '2025-04-16 00:54:14');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'OPEN', 'no', '2025-04-16 00:55:01', '2025-04-16 00:55:01');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'ibc', 'no', '2025-06-11 19:31:52', '2025-06-11 19:31:52');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'Navboudh', 'no', '2025-06-30 11:45:01', NULL);


#
# TABLE STRUCTURE FOR: cbse_exam_assessment_types
#

DROP TABLE IF EXISTS `cbse_exam_assessment_types`;

CREATE TABLE `cbse_exam_assessment_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_assessment_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `code` varchar(100) NOT NULL,
  `maximum_marks` float NOT NULL,
  `pass_percentage` float NOT NULL,
  `description` mediumtext NOT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `cbse_exam_assessment_id` (`cbse_exam_assessment_id`),
  KEY `idx_name` (`name`),
  KEY `idx_code` (`code`),
  CONSTRAINT `cbse_exam_assessment_types_ibfk_1` FOREIGN KEY (`cbse_exam_assessment_id`) REFERENCES `cbse_exam_assessments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `cbse_exam_assessment_types` (`id`, `cbse_exam_assessment_id`, `name`, `code`, `maximum_marks`, `pass_percentage`, `description`, `created_by`, `created_at`) VALUES (1, 1, 'Homework', 'HW01', '5', '0', 'Homework', 1, '2025-06-27 15:11:54');
INSERT INTO `cbse_exam_assessment_types` (`id`, `cbse_exam_assessment_id`, `name`, `code`, `maximum_marks`, `pass_percentage`, `description`, `created_by`, `created_at`) VALUES (2, 1, 'Class Work', 'CW02', '5', '0', 'Class Work', 1, '2025-06-27 15:12:55');
INSERT INTO `cbse_exam_assessment_types` (`id`, `cbse_exam_assessment_id`, `name`, `code`, `maximum_marks`, `pass_percentage`, `description`, `created_by`, `created_at`) VALUES (3, 1, 'Class Test', 'CT03', '5', '0', 'Class Test', 1, '2025-06-27 15:12:55');


#
# TABLE STRUCTURE FOR: cbse_exam_assessments
#

DROP TABLE IF EXISTS `cbse_exam_assessments`;

CREATE TABLE `cbse_exam_assessments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: cbse_exam_class_sections
#

DROP TABLE IF EXISTS `cbse_exam_class_sections`;

CREATE TABLE `cbse_exam_class_sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_id` int(11) NOT NULL,
  `class_section_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `class_section_id` (`class_section_id`),
  KEY `cbse_exam_id` (`cbse_exam_id`),
  CONSTRAINT `cbse_exam_class_sections_ibfk_1` FOREIGN KEY (`class_section_id`) REFERENCES `class_sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_exam_class_sections_ibfk_2` FOREIGN KEY (`cbse_exam_id`) REFERENCES `cbse_exams` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: cbse_exam_grades
#

DROP TABLE IF EXISTS `cbse_exam_grades`;

CREATE TABLE `cbse_exam_grades` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `cbse_exam_grades` (`id`, `name`, `description`, `created_at`) VALUES (1, 'All the Grade', 'A+', '2025-06-27 15:16:16');


#
# TABLE STRUCTURE FOR: cbse_exam_grades_range
#

DROP TABLE IF EXISTS `cbse_exam_grades_range`;

CREATE TABLE `cbse_exam_grades_range` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_grade_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `minimum_percentage` float NOT NULL,
  `maximum_percentage` float NOT NULL,
  `description` mediumtext NOT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `cbse_exam_grade_id` (`cbse_exam_grade_id`),
  KEY `idx_name` (`name`),
  CONSTRAINT `cbse_exam_grades_range_ibfk_1` FOREIGN KEY (`cbse_exam_grade_id`) REFERENCES `cbse_exam_grades` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `cbse_exam_grades_range` (`id`, `cbse_exam_grade_id`, `name`, `minimum_percentage`, `maximum_percentage`, `description`, `created_by`, `created_at`) VALUES (1, 1, 'A+', '95', '100', 'Excellent', 1, '2025-06-27 15:16:16');
INSERT INTO `cbse_exam_grades_range` (`id`, `cbse_exam_grade_id`, `name`, `minimum_percentage`, `maximum_percentage`, `description`, `created_by`, `created_at`) VALUES (2, 1, 'A', '94.5', '90', 'Good', 1, '2025-06-27 15:16:16');
INSERT INTO `cbse_exam_grades_range` (`id`, `cbse_exam_grade_id`, `name`, `minimum_percentage`, `maximum_percentage`, `description`, `created_by`, `created_at`) VALUES (3, 1, 'B+', '89.58', '75', '', 1, '2025-06-27 15:16:16');


#
# TABLE STRUCTURE FOR: cbse_exam_group_class_batch_exam_students
#

DROP TABLE IF EXISTS `cbse_exam_group_class_batch_exam_students`;

CREATE TABLE `cbse_exam_group_class_batch_exam_students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_class_batch_exam_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `student_session_id` int(11) NOT NULL,
  `roll_no` varchar(255) NOT NULL DEFAULT '0',
  `teacher_remark` text CHARACTER SET utf8 NOT NULL,
  `is_active` int(11) NOT NULL DEFAULT '0',
  `exam_seat_no` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `student_session_id` (`student_session_id`),
  KEY `student_id` (`student_id`),
  KEY `exam_group_class_batch_exam_id` (`exam_group_class_batch_exam_id`)
) ENGINE=InnoDB AUTO_INCREMENT=135 DEFAULT CHARSET=utf8mb4;

INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (1, 1, 2062, 3579, '0', '', 0, NULL, '2025-09-14 15:52:43', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (2, 1, 1514, 3566, '0', '', 0, NULL, '2025-09-14 15:52:43', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (3, 2, 2062, 3579, '0', '', 0, NULL, '2025-09-14 16:42:27', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (4, 2, 1514, 3566, '0', '', 0, NULL, '2025-09-14 16:42:27', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (5, 3, 2062, 3579, '0', 'good keep it up', 0, NULL, '2025-09-14 17:48:45', '2025-09-15 01:01:55');
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (6, 3, 1514, 3566, '0', 'need to improve', 0, NULL, '2025-09-14 17:48:45', '2025-09-15 01:01:55');
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (7, 4, 2062, 3579, '0', 'need to improve', 0, NULL, '2025-09-14 17:50:40', '2025-09-15 01:02:19');
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (8, 4, 1514, 3566, '0', 'need to improve', 0, NULL, '2025-09-14 17:50:40', '2025-09-15 01:02:19');
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (9, 5, 2539, 4445, '0', '', 0, '', '2025-10-28 11:35:07', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (10, 5, 2552, 4458, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (11, 5, 2558, 4464, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (12, 5, 2531, 4437, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (13, 5, 2532, 4438, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (14, 5, 2516, 4422, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (15, 5, 2523, 4429, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (16, 5, 2620, 4526, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (17, 5, 2534, 4440, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (18, 5, 2528, 4434, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (19, 5, 2536, 4442, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (20, 5, 2538, 4444, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (21, 5, 2526, 4432, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (22, 5, 2527, 4433, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (23, 5, 2525, 4431, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (24, 5, 2533, 4439, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (25, 5, 2621, 4527, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (26, 5, 2537, 4443, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (27, 5, 2554, 4460, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (28, 5, 2619, 4525, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (29, 5, 2553, 4459, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (30, 5, 2541, 4447, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (31, 5, 2561, 4467, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (32, 5, 2542, 4448, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (33, 5, 2550, 4456, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (34, 5, 2624, 4530, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (35, 5, 2617, 4523, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (36, 5, 2522, 4428, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (37, 5, 2524, 4430, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (38, 5, 2549, 4455, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (39, 5, 2547, 4453, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (40, 5, 2548, 4454, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (41, 5, 2543, 4449, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (42, 5, 2544, 4450, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (43, 5, 2618, 4524, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (44, 5, 2530, 4436, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (45, 5, 2529, 4435, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (46, 5, 2623, 4529, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (47, 5, 2616, 4522, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (48, 5, 2622, 4528, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (49, 5, 2535, 4441, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (50, 5, 2557, 4463, '0', '', 0, '', '2025-10-28 11:35:08', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (51, 6, 2539, 4445, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (52, 6, 2552, 4458, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (53, 6, 2558, 4464, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (54, 6, 2531, 4437, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (55, 6, 2532, 4438, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (56, 6, 2516, 4422, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (57, 6, 2523, 4429, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (58, 6, 2620, 4526, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (59, 6, 2534, 4440, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (60, 6, 2528, 4434, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (61, 6, 2536, 4442, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (62, 6, 2538, 4444, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (63, 6, 2526, 4432, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (64, 6, 2527, 4433, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (65, 6, 2525, 4431, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (66, 6, 2533, 4439, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (67, 6, 2621, 4527, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (68, 6, 2537, 4443, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (69, 6, 2554, 4460, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (70, 6, 2619, 4525, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (71, 6, 2553, 4459, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (72, 6, 2541, 4447, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (73, 6, 2561, 4467, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (74, 6, 2542, 4448, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (75, 6, 2550, 4456, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (76, 6, 2624, 4530, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (77, 6, 2617, 4523, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (78, 6, 2522, 4428, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (79, 6, 2524, 4430, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (80, 6, 2549, 4455, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (81, 6, 2547, 4453, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (82, 6, 2548, 4454, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (83, 6, 2543, 4449, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (84, 6, 2544, 4450, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (85, 6, 2618, 4524, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (86, 6, 2530, 4436, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (87, 6, 2529, 4435, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (88, 6, 2623, 4529, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (89, 6, 2616, 4522, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (90, 6, 2622, 4528, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (91, 6, 2535, 4441, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (92, 6, 2557, 4463, '0', '', 0, '', '2025-10-28 11:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (93, 7, 2539, 4445, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (94, 7, 2552, 4458, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (95, 7, 2558, 4464, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (96, 7, 2531, 4437, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (97, 7, 2532, 4438, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (98, 7, 2516, 4422, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (99, 7, 2523, 4429, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (100, 7, 2620, 4526, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (101, 7, 2534, 4440, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (102, 7, 2528, 4434, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (103, 7, 2536, 4442, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (104, 7, 2538, 4444, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (105, 7, 2526, 4432, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (106, 7, 2527, 4433, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (107, 7, 2525, 4431, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (108, 7, 2533, 4439, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (109, 7, 2621, 4527, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (110, 7, 2537, 4443, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (111, 7, 2554, 4460, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (112, 7, 2619, 4525, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (113, 7, 2553, 4459, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (114, 7, 2541, 4447, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (115, 7, 2561, 4467, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (116, 7, 2542, 4448, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (117, 7, 2550, 4456, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (118, 7, 2624, 4530, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (119, 7, 2617, 4523, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (120, 7, 2522, 4428, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (121, 7, 2524, 4430, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (122, 7, 2549, 4455, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (123, 7, 2547, 4453, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (124, 7, 2548, 4454, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (125, 7, 2543, 4449, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (126, 7, 2544, 4450, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (127, 7, 2618, 4524, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (128, 7, 2530, 4436, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (129, 7, 2529, 4435, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (130, 7, 2623, 4529, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (131, 7, 2616, 4522, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (132, 7, 2622, 4528, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (133, 7, 2535, 4441, '0', '', 0, '', '2025-10-28 11:35:39', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (134, 7, 2557, 4463, '0', '', 0, '', '2025-10-28 11:35:39', NULL);


#
# TABLE STRUCTURE FOR: cbse_exam_group_class_batch_exam_subjects
#

DROP TABLE IF EXISTS `cbse_exam_group_class_batch_exam_subjects`;

CREATE TABLE `cbse_exam_group_class_batch_exam_subjects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_class_batch_exams_id` int(11) DEFAULT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `class_id` int(11) DEFAULT NULL,
  `section_id` int(11) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `time_from` time DEFAULT NULL,
  `duration` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `room_no` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `mark_entry_type` int(11) DEFAULT NULL,
  `max_marks` float(10,2) DEFAULT NULL,
  `min_marks` float(10,2) DEFAULT NULL,
  `credit_hours` float(10,2) DEFAULT NULL,
  `date_to` datetime DEFAULT NULL,
  `is_active` int(11) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `exam_group_class_batch_exams_id` (`exam_group_class_batch_exams_id`),
  KEY `subject_id` (`subject_id`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4;

INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (1, 1, 1, 23, 1, '2025-09-14', '00:00:00', '', '', NULL, '30.00', '10.00', '0.00', NULL, 0, '2025-09-14 15:52:43', '2025-09-14 15:53:44');
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (2, 1, 2, 23, 1, '2025-09-14', '00:00:00', '', '', NULL, '30.00', '10.00', '0.00', NULL, 0, '2025-09-14 15:52:43', '2025-09-14 15:53:44');
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (15, 2, 1, 23, 1, '2025-09-14', '00:00:00', '', '', NULL, '100.00', '35.00', '0.00', NULL, 0, '2025-09-14 16:42:27', '2025-09-14 17:43:04');
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (16, 2, 2, 23, 1, '2025-09-14', '00:00:00', '', '', NULL, '100.00', '35.00', '0.00', NULL, 0, '2025-09-14 16:42:27', '2025-09-14 17:43:04');
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (29, 3, 1, 23, 1, '2025-09-14', '00:00:00', '', '', NULL, '40.00', '13.00', '0.00', NULL, 0, '2025-09-14 17:48:45', '2025-09-14 17:49:23');
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (30, 3, 2, 23, 1, '2025-09-14', '00:00:00', '', '', NULL, '40.00', '13.00', '0.00', NULL, 0, '2025-09-14 17:48:45', '2025-09-14 17:49:23');
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (43, 4, 1, 23, 1, '2025-09-14', '00:00:00', '', '', NULL, '100.00', '35.00', '0.00', NULL, 0, '2025-09-14 17:50:40', '2025-09-14 17:51:15');
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (44, 4, 2, 23, 1, '2025-09-14', '00:00:00', '', '', NULL, '100.00', '35.00', '0.00', NULL, 0, '2025-09-14 17:50:40', '2025-09-14 17:51:15');
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (45, 6, 1, NULL, NULL, '2025-08-01', '08:00:00', '0', '', NULL, '40.00', '14.00', '0.00', NULL, 0, '2025-10-28 10:54:20', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (46, 6, 2, NULL, NULL, '2025-08-02', '08:00:00', '0', '', NULL, '40.00', '14.00', '0.00', NULL, 0, '2025-10-28 10:54:20', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (47, 6, 19, NULL, NULL, '2025-08-04', '08:00:00', '0', '', NULL, '40.00', '14.00', '0.00', NULL, 0, '2025-10-28 10:54:20', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (48, 6, 21, NULL, NULL, '2025-08-05', '08:00:00', '0', '', NULL, '40.00', '14.00', '0.00', NULL, 0, '2025-10-28 10:54:20', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (49, 7, 1, NULL, NULL, '2025-09-01', '08:00:00', '0', '', NULL, '40.00', '14.00', '0.00', NULL, 0, '2025-10-28 11:07:26', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (50, 7, 2, NULL, NULL, '2025-09-02', '08:00:00', '0', '', NULL, '40.00', '14.00', '0.00', NULL, 0, '2025-10-28 11:07:26', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (51, 7, 19, NULL, NULL, '2025-09-03', '08:00:00', '0', '', NULL, '40.00', '14.00', '0.00', NULL, 0, '2025-10-28 11:07:26', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (52, 7, 21, NULL, NULL, '2025-09-04', '08:00:00', '0', '', NULL, '40.00', '14.00', '0.00', NULL, 0, '2025-10-28 11:07:26', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (53, 5, 1, NULL, NULL, '2025-10-01', '08:00:00', '0', '', NULL, '100.00', '35.00', '0.00', NULL, 0, '2025-10-28 11:17:26', '2025-10-28 11:21:44');
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (54, 5, 2, NULL, NULL, '2025-10-02', '08:00:00', '0', '', NULL, '100.00', '35.00', '0.00', NULL, 0, '2025-10-28 11:17:27', '2025-10-28 11:21:44');
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (55, 5, 19, NULL, NULL, '2025-10-03', '08:00:00', '0', '', NULL, '100.00', '35.00', '0.00', NULL, 0, '2025-10-28 11:17:27', '2025-10-28 11:21:44');
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (56, 5, 21, NULL, NULL, '2025-10-04', '08:00:00', '0', '', NULL, '100.00', '35.00', '0.00', NULL, 0, '2025-10-28 11:17:27', '2025-10-28 11:21:44');


#
# TABLE STRUCTURE FOR: cbse_exam_group_class_batch_exams
#

DROP TABLE IF EXISTS `cbse_exam_group_class_batch_exams`;

CREATE TABLE `cbse_exam_group_class_batch_exams` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam` varchar(255) DEFAULT NULL,
  `session_id` int(11) NOT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `description` text,
  `exam_group_id` int(11) NOT NULL,
  `use_exam_roll_no` varchar(255) NOT NULL DEFAULT '1',
  `is_termexam` varchar(255) DEFAULT 'no',
  `is_term1` varchar(100) DEFAULT 'no',
  `is_publish` int(11) NOT NULL DEFAULT '0',
  `is_active` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `exam_group_id` (`exam_group_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4;

INSERT INTO `cbse_exam_group_class_batch_exams` (`id`, `exam`, `session_id`, `date_from`, `date_to`, `description`, `exam_group_id`, `use_exam_roll_no`, `is_termexam`, `is_term1`, `is_publish`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Unit Test 1', 28, NULL, NULL, 'unit test 1', 13, '1', 'no', 'no', 0, 1, '2025-09-14 14:15:42', NULL);
INSERT INTO `cbse_exam_group_class_batch_exams` (`id`, `exam`, `session_id`, `date_from`, `date_to`, `description`, `exam_group_id`, `use_exam_roll_no`, `is_termexam`, `is_term1`, `is_publish`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Term 1', 28, NULL, NULL, '', 13, '1', 'yes', 'no', 0, 1, '2025-09-14 16:41:12', NULL);
INSERT INTO `cbse_exam_group_class_batch_exams` (`id`, `exam`, `session_id`, `date_from`, `date_to`, `description`, `exam_group_id`, `use_exam_roll_no`, `is_termexam`, `is_term1`, `is_publish`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Unit test 2', 28, NULL, NULL, '', 3, '1', 'no', 'no', 0, 1, '2025-09-14 17:47:55', NULL);
INSERT INTO `cbse_exam_group_class_batch_exams` (`id`, `exam`, `session_id`, `date_from`, `date_to`, `description`, `exam_group_id`, `use_exam_roll_no`, `is_termexam`, `is_term1`, `is_publish`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'Term 2', 28, NULL, NULL, '', 3, '1', 'yes', 'no', 0, 1, '2025-09-14 17:48:14', NULL);
INSERT INTO `cbse_exam_group_class_batch_exams` (`id`, `exam`, `session_id`, `date_from`, `date_to`, `description`, `exam_group_id`, `use_exam_roll_no`, `is_termexam`, `is_term1`, `is_publish`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'TERM1 CLASS 1', 28, NULL, NULL, 'TERM1 CLASS 1', 14, '0', 'yes', 'yes', 1, 1, '2025-10-28 10:32:52', NULL);
INSERT INTO `cbse_exam_group_class_batch_exams` (`id`, `exam`, `session_id`, `date_from`, `date_to`, `description`, `exam_group_id`, `use_exam_roll_no`, `is_termexam`, `is_term1`, `is_publish`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'TERM1 CLASS PT 1', 28, NULL, NULL, 'TERM1 CLASS PT 1', 14, '0', 'no', NULL, 1, 1, '2025-10-28 10:33:23', '2025-10-28 10:44:04');
INSERT INTO `cbse_exam_group_class_batch_exams` (`id`, `exam`, `session_id`, `date_from`, `date_to`, `description`, `exam_group_id`, `use_exam_roll_no`, `is_termexam`, `is_term1`, `is_publish`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'TERM1 CLASS PT 2', 28, NULL, NULL, 'TERM1 CLASS PT 2', 14, '1', 'no', NULL, 1, 1, '2025-10-28 10:33:39', '2025-10-28 10:46:06');


#
# TABLE STRUCTURE FOR: cbse_exam_group_exam_results
#

DROP TABLE IF EXISTS `cbse_exam_group_exam_results`;

CREATE TABLE `cbse_exam_group_exam_results` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_class_batch_exam_student_id` int(11) NOT NULL,
  `exam_group_class_batch_exam_subject_id` int(11) NOT NULL,
  `attendence` varchar(100) CHARACTER SET utf8 NOT NULL,
  `get_marks` float(10,2) DEFAULT '0.00',
  `term_marks` varchar(255) DEFAULT NULL,
  `get_grade` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `assessment_type_marks` text,
  `previous_exammarks` varchar(255) DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  `is_active` int(11) NOT NULL DEFAULT '0',
  `exam_group_student_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `exam_group_class_batch_exam_student_id` (`exam_group_class_batch_exam_student_id`),
  KEY `exam_group_class_batch_exam_subject_id` (`exam_group_class_batch_exam_subject_id`),
  KEY `exam_group_student_id` (`exam_group_student_id`)
) ENGINE=InnoDB AUTO_INCREMENT=521 DEFAULT CHARSET=utf8mb4;

INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (1, 1, 1, 'present', '30.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-09-14 15:54:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (2, 2, 1, 'present', '25.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-09-14 15:54:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (3, 1, 2, 'present', '27.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-09-14 15:54:39', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (4, 2, 2, 'present', '28.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-09-14 15:54:39', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (5, 3, 15, 'present', '90.00', '80', NULL, '[]', '{\"previous_exam_id\":\"1\",\"previous_exam_marks\":\"10.00\"}', '', 0, 0, '2025-09-14 16:44:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (6, 4, 15, 'present', '92.08', '80', NULL, '[{\"assessment_type_id\":\"2\",\"assessment_type_mark\":\"3.75\"}]', '{\"previous_exam_id\":\"1\",\"previous_exam_marks\":\"8.33\"}', '', 0, 0, '2025-09-14 16:44:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (7, 3, 16, 'present', '89.00', '80', NULL, '[]', '{\"previous_exam_id\":\"1\",\"previous_exam_marks\":\"9.00\"}', '', 0, 0, '2025-09-14 16:45:11', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (8, 4, 16, 'present', '84.33', '75', NULL, '[]', '{\"previous_exam_id\":\"1\",\"previous_exam_marks\":\"9.33\"}', '', 0, 0, '2025-09-14 16:45:11', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (9, 5, 29, 'present', '40.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-09-14 17:49:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (10, 6, 29, 'present', '35.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-09-14 17:49:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (11, 5, 30, 'present', '39.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-09-14 17:50:12', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (12, 6, 30, 'present', '40.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-09-14 17:50:12', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (13, 7, 43, 'present', '85.00', '75', NULL, '[]', '{\"previous_exam_id\":\"3\",\"previous_exam_marks\":\"10.00\"}', '', 0, 0, '2025-09-14 17:51:58', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (14, 8, 43, 'present', '92.50', '80', NULL, '[{\"assessment_type_id\":\"2\",\"assessment_type_mark\":\"3.75\"}]', '{\"previous_exam_id\":\"3\",\"previous_exam_marks\":\"8.75\"}', '', 0, 0, '2025-09-14 17:51:58', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (15, 7, 44, 'present', '89.75', '80', NULL, '[]', '{\"previous_exam_id\":\"3\",\"previous_exam_marks\":\"9.75\"}', '', 0, 0, '2025-09-14 17:52:23', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (16, 8, 44, 'present', '88.00', '78', NULL, '[]', '{\"previous_exam_id\":\"3\",\"previous_exam_marks\":\"10.00\"}', '', 0, 0, '2025-09-14 17:52:23', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (17, 9, 53, 'present', '44.00', '40', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"4.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (18, 10, 53, 'present', '50.00', '50', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (19, 11, 53, 'present', '50.00', '50', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (20, 12, 53, 'present', '50.00', '50', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (21, 13, 53, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (22, 14, 53, 'present', '50.00', '50', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (23, 15, 53, 'present', '50.00', '50', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (24, 16, 53, 'present', '50.00', '50', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (25, 17, 53, 'present', '50.00', '50', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (26, 18, 53, 'present', '50.00', '50', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (27, 19, 53, 'present', '50.00', '50', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (28, 20, 53, 'present', '50.00', '50', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (29, 21, 53, 'present', '50.00', '50', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (30, 22, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (31, 23, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (32, 24, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (33, 25, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (34, 26, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (35, 27, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (36, 28, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (37, 29, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (38, 30, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (39, 31, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (40, 32, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (41, 33, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (42, 34, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (43, 35, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (44, 36, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (45, 37, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (46, 38, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (47, 39, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (48, 40, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (49, 41, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (50, 42, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (51, 43, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (52, 44, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (53, 45, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (54, 46, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (55, 47, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (56, 48, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (57, 49, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (58, 50, 53, 'present', '70.00', '70', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 11:56:26', '2025-10-28 12:06:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (59, 9, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:16', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (60, 10, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:16', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (61, 11, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:16', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (62, 12, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:16', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (63, 13, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:16', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (64, 14, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:16', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (65, 15, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:16', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (66, 16, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:16', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (67, 17, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:16', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (68, 18, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:16', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (69, 19, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:16', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (70, 20, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:16', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (71, 21, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:16', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (72, 22, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:16', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (73, 23, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (74, 24, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (75, 25, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (76, 26, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (77, 27, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (78, 28, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (79, 29, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (80, 30, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (81, 31, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (82, 32, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (83, 33, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (84, 34, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (85, 35, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (86, 36, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (87, 37, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (88, 38, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (89, 39, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (90, 40, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (91, 41, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (92, 42, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (93, 43, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (94, 44, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (95, 45, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (96, 46, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (97, 47, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (98, 48, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (99, 49, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (100, 50, 54, 'present', '75.00', '75', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:08:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (101, 9, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:26');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (102, 10, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:26');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (103, 11, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:26');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (104, 12, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:26');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (105, 13, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:26');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (106, 14, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:26');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (107, 15, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:26');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (108, 16, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:26');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (109, 17, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:26');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (110, 18, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:26');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (111, 19, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:26');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (112, 20, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:26');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (113, 21, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:26');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (114, 22, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:26');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (115, 23, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:26');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (116, 24, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:26');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (117, 25, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:26');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (118, 26, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:26');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (119, 27, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:26');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (120, 28, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (121, 29, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (122, 30, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (123, 31, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (124, 32, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (125, 33, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (126, 34, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (127, 35, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (128, 36, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (129, 37, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (130, 38, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (131, 39, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (132, 40, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (133, 41, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (134, 42, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (135, 43, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (136, 44, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (137, 45, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (138, 46, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (139, 47, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (140, 48, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (141, 49, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (142, 50, 55, 'present', '55.00', '55', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"5.50\"}', '', 0, 0, '2025-10-28 12:13:43', '2025-10-28 12:15:27');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (143, 9, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (144, 10, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (145, 11, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (146, 12, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (147, 13, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (148, 14, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (149, 15, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (150, 16, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (151, 17, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (152, 18, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (153, 19, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (154, 20, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (155, 21, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (156, 22, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (157, 23, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (158, 24, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (159, 25, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (160, 26, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (161, 27, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (162, 28, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (163, 29, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (164, 30, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (165, 31, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (166, 32, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (167, 33, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (168, 34, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (169, 35, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (170, 36, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (171, 37, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (172, 38, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (173, 39, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (174, 40, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (175, 41, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (176, 42, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (177, 43, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (178, 44, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (179, 45, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (180, 46, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (181, 47, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (182, 48, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (183, 49, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (184, 50, 56, 'present', '60.00', '60', NULL, '[]', '{\"previous_exam_id\":\"5\",\"previous_exam_marks\":\"0.00\"}', '', 0, 0, '2025-10-28 12:17:41', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (185, 51, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (186, 52, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (187, 53, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (188, 54, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (189, 55, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (190, 56, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (191, 57, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (192, 58, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (193, 59, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (194, 60, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (195, 61, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (196, 62, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (197, 63, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (198, 64, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (199, 65, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (200, 66, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (201, 67, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (202, 68, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (203, 69, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (204, 70, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (205, 71, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (206, 72, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (207, 73, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (208, 74, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (209, 75, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:24', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (210, 76, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:25', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (211, 77, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:25', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (212, 78, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:25', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (213, 79, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:25', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (214, 80, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:25', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (215, 81, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:25', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (216, 82, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:25', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (217, 83, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:25', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (218, 84, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:25', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (219, 85, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:25', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (220, 86, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:25', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (221, 87, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:25', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (222, 88, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:25', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (223, 89, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:25', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (224, 90, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:25', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (225, 91, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:25', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (226, 92, 45, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:21:25', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (227, 51, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (228, 52, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (229, 53, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (230, 54, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (231, 55, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (232, 56, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (233, 57, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (234, 58, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (235, 59, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (236, 60, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (237, 61, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (238, 62, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (239, 63, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (240, 64, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (241, 65, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (242, 66, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (243, 67, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (244, 68, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (245, 69, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (246, 70, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (247, 71, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (248, 72, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (249, 73, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (250, 74, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (251, 75, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (252, 76, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (253, 77, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (254, 78, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (255, 79, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (256, 80, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (257, 81, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (258, 82, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (259, 83, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (260, 84, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (261, 85, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (262, 86, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (263, 87, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (264, 88, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (265, 89, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (266, 90, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (267, 91, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (268, 92, 46, 'present', '17.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:24:22', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (269, 51, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (270, 52, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (271, 53, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (272, 54, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (273, 55, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (274, 56, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (275, 57, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (276, 58, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (277, 59, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (278, 60, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (279, 61, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (280, 62, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (281, 63, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (282, 64, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (283, 65, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (284, 66, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (285, 67, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (286, 68, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (287, 69, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (288, 70, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (289, 71, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (290, 72, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (291, 73, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (292, 74, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (293, 75, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (294, 76, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (295, 77, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (296, 78, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (297, 79, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (298, 80, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (299, 81, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (300, 82, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (301, 83, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (302, 84, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (303, 85, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (304, 86, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (305, 87, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (306, 88, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (307, 89, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (308, 90, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (309, 91, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (310, 92, 47, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:26:42', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (311, 51, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (312, 52, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (313, 53, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (314, 54, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (315, 55, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (316, 56, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (317, 57, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (318, 58, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (319, 59, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (320, 60, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (321, 61, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (322, 62, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (323, 63, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (324, 64, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (325, 65, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (326, 66, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (327, 67, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (328, 68, 48, 'absent', '0.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (329, 69, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (330, 70, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (331, 71, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (332, 72, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (333, 73, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (334, 74, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (335, 75, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (336, 76, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (337, 77, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (338, 78, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (339, 79, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (340, 80, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (341, 81, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (342, 82, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (343, 83, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (344, 84, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (345, 85, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (346, 86, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (347, 87, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (348, 88, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (349, 89, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (350, 90, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (351, 91, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (352, 92, 48, 'present', '20.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:29:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (353, 93, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (354, 94, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (355, 95, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (356, 96, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (357, 97, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (358, 98, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (359, 99, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (360, 100, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (361, 101, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (362, 102, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (363, 103, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (364, 104, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (365, 105, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (366, 106, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (367, 107, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (368, 108, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (369, 109, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (370, 110, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (371, 111, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (372, 112, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (373, 113, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (374, 114, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (375, 115, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (376, 116, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (377, 117, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (378, 118, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (379, 119, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (380, 120, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (381, 121, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (382, 122, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (383, 123, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (384, 124, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (385, 125, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (386, 126, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (387, 127, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (388, 128, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (389, 129, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (390, 130, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (391, 131, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (392, 132, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (393, 133, 49, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (394, 134, 49, 'absent', '0.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:38:55', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (395, 93, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (396, 94, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (397, 95, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (398, 96, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (399, 97, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (400, 98, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (401, 99, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (402, 100, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (403, 101, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (404, 102, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (405, 103, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (406, 104, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (407, 105, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (408, 106, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (409, 107, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (410, 108, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (411, 109, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (412, 110, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (413, 111, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (414, 112, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (415, 113, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (416, 114, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (417, 115, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (418, 116, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (419, 117, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (420, 118, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (421, 119, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (422, 120, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (423, 121, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (424, 122, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (425, 123, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (426, 124, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (427, 125, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (428, 126, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (429, 127, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (430, 128, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (431, 129, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (432, 130, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (433, 131, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (434, 132, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (435, 133, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (436, 134, 50, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:42:28', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (437, 93, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:29', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (438, 94, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:29', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (439, 95, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:29', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (440, 96, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:29', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (441, 97, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:29', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (442, 98, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:29', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (443, 99, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:29', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (444, 100, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:29', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (445, 101, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:29', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (446, 102, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (447, 103, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (448, 104, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (449, 105, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (450, 106, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (451, 107, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (452, 108, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (453, 109, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (454, 110, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (455, 111, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (456, 112, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (457, 113, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (458, 114, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (459, 115, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (460, 116, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (461, 117, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (462, 118, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (463, 119, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (464, 120, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (465, 121, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (466, 122, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (467, 123, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (468, 124, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (469, 125, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (470, 126, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (471, 127, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (472, 128, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (473, 129, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (474, 130, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (475, 131, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (476, 132, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (477, 133, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (478, 134, 51, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:47:30', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (479, 93, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (480, 94, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (481, 95, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (482, 96, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (483, 97, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (484, 98, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (485, 99, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (486, 100, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (487, 101, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (488, 102, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (489, 103, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (490, 104, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (491, 105, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (492, 106, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (493, 107, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (494, 108, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (495, 109, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (496, 110, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (497, 111, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (498, 112, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (499, 113, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (500, 114, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (501, 115, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (502, 116, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (503, 117, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (504, 118, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (505, 119, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (506, 120, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (507, 121, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (508, 122, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (509, 123, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (510, 124, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (511, 125, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (512, 126, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (513, 127, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (514, 128, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (515, 129, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (516, 130, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (517, 131, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (518, 132, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (519, 133, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (520, 134, 52, 'present', '21.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-10-28 12:50:00', NULL);


#
# TABLE STRUCTURE FOR: cbse_exam_groups
#

DROP TABLE IF EXISTS `cbse_exam_groups`;

CREATE TABLE `cbse_exam_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `exam_type` varchar(255) NOT NULL,
  `description` varchar(1000) DEFAULT NULL,
  `is_active` int(11) DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4;

INSERT INTO `cbse_exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'TERM1 CLASS 1', 'basic_system', '', 0, '2025-10-28 10:29:53', '2025-10-28 10:31:32');


#
# TABLE STRUCTURE FOR: cbse_exam_observations
#

DROP TABLE IF EXISTS `cbse_exam_observations`;

CREATE TABLE `cbse_exam_observations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `description` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `cbse_exam_observations` (`id`, `name`, `description`, `created_at`) VALUES (1, 'A+', 'A+', '2025-06-27 15:18:06');


#
# TABLE STRUCTURE FOR: cbse_exam_student_subject_rank
#

DROP TABLE IF EXISTS `cbse_exam_student_subject_rank`;

CREATE TABLE `cbse_exam_student_subject_rank` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_template_id` int(11) DEFAULT NULL,
  `student_session_id` int(11) DEFAULT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `rank` int(11) DEFAULT NULL,
  `rank_percentage` float(10,2) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `cbse_template_id` (`cbse_template_id`),
  KEY `student_session_id` (`student_session_id`),
  KEY `subject_id` (`subject_id`),
  KEY `idx_rank` (`rank`),
  CONSTRAINT `cbse_exam_student_subject_rank_ibfk_1` FOREIGN KEY (`cbse_template_id`) REFERENCES `cbse_template` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_exam_student_subject_rank_ibfk_2` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_exam_student_subject_rank_ibfk_3` FOREIGN KEY (`subject_id`) REFERENCES `subjects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: cbse_exam_students
#

DROP TABLE IF EXISTS `cbse_exam_students`;

CREATE TABLE `cbse_exam_students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_id` int(11) NOT NULL,
  `student_session_id` int(11) NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `roll_no` varchar(20) DEFAULT NULL,
  `remark` text,
  `total_present_days` int(11) DEFAULT NULL,
  `delete_student_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `cbse_exam_id` (`cbse_exam_id`),
  KEY `student_session_id` (`student_session_id`),
  CONSTRAINT `cbse_exam_students_ibfk_1` FOREIGN KEY (`cbse_exam_id`) REFERENCES `cbse_exams` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_exam_students_ibfk_2` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: cbse_exam_timetable
#

DROP TABLE IF EXISTS `cbse_exam_timetable`;

CREATE TABLE `cbse_exam_timetable` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_id` int(11) DEFAULT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `date` date NOT NULL,
  `time_from` time NOT NULL,
  `time_to` time NOT NULL,
  `duration` int(11) NOT NULL,
  `room_no` varchar(255) NOT NULL,
  `is_written` int(1) NOT NULL DEFAULT '1',
  `written_maximum_marks` float NOT NULL,
  `is_practical` int(1) NOT NULL,
  `practical_maximum_mark` float DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `cbse_exam_id` (`cbse_exam_id`),
  KEY `subject_id` (`subject_id`),
  CONSTRAINT `cbse_exam_timetable_ibfk_1` FOREIGN KEY (`cbse_exam_id`) REFERENCES `cbse_exams` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_exam_timetable_ibfk_2` FOREIGN KEY (`subject_id`) REFERENCES `subjects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: cbse_exam_timetable_assessment_types
#

DROP TABLE IF EXISTS `cbse_exam_timetable_assessment_types`;

CREATE TABLE `cbse_exam_timetable_assessment_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_timetable_id` int(11) DEFAULT NULL,
  `cbse_exam_assessment_type_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `cbse_exam_timetable_id` (`cbse_exam_timetable_id`),
  KEY `cbse_exam_assessment_type_id` (`cbse_exam_assessment_type_id`),
  CONSTRAINT `cbse_exam_timetable_assessment_types_ibfk_1` FOREIGN KEY (`cbse_exam_timetable_id`) REFERENCES `cbse_exam_timetable` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_exam_timetable_assessment_types_ibfk_2` FOREIGN KEY (`cbse_exam_assessment_type_id`) REFERENCES `cbse_exam_assessment_types` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: cbse_exams
#

DROP TABLE IF EXISTS `cbse_exams`;

CREATE TABLE `cbse_exams` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `total_working_days` int(11) DEFAULT '0',
  `cbse_term_id` int(11) DEFAULT NULL,
  `cbse_exam_assessment_id` int(11) DEFAULT NULL,
  `cbse_exam_grade_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `exam_code` varchar(200) DEFAULT NULL,
  `session_id` int(11) NOT NULL,
  `description` mediumtext NOT NULL,
  `is_publish` int(1) NOT NULL,
  `is_active` int(1) NOT NULL,
  `created_by` int(11) DEFAULT NULL,
  `use_exam_roll_no` int(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `cbse_term_id` (`cbse_term_id`),
  KEY `cbse_exam_grade_id` (`cbse_exam_grade_id`),
  KEY `cbse_exam_assessment_id` (`cbse_exam_assessment_id`),
  KEY `session_id` (`session_id`),
  KEY `idx_name` (`name`),
  KEY `idx_exam_code` (`exam_code`),
  CONSTRAINT `cbse_exams_ibfk_1` FOREIGN KEY (`cbse_term_id`) REFERENCES `cbse_terms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_exams_ibfk_2` FOREIGN KEY (`cbse_exam_grade_id`) REFERENCES `cbse_exam_grades` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_exams_ibfk_3` FOREIGN KEY (`cbse_exam_assessment_id`) REFERENCES `cbse_exam_assessments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_exams_ibfk_4` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: cbse_marksheet_type
#

DROP TABLE IF EXISTS `cbse_marksheet_type`;

CREATE TABLE `cbse_marksheet_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `short_code` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`),
  KEY `idx_short_code` (`short_code`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `cbse_marksheet_type` (`id`, `name`, `short_code`) VALUES (1, 'All Terms', 'all_term');
INSERT INTO `cbse_marksheet_type` (`id`, `name`, `short_code`) VALUES (2, 'Term Wise', 'term_wise');
INSERT INTO `cbse_marksheet_type` (`id`, `name`, `short_code`) VALUES (3, 'Single Exam Without Term', 'exam_wise');
INSERT INTO `cbse_marksheet_type` (`id`, `name`, `short_code`) VALUES (4, 'Multiple Exams Without Term', 'without_term');


#
# TABLE STRUCTURE FOR: cbse_observation_class_section
#

DROP TABLE IF EXISTS `cbse_observation_class_section`;

CREATE TABLE `cbse_observation_class_section` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_observation_parameter_id` int(11) NOT NULL,
  `class_section_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: cbse_observation_parameters
#

DROP TABLE IF EXISTS `cbse_observation_parameters`;

CREATE TABLE `cbse_observation_parameters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `cbse_observation_parameters` (`id`, `name`, `description`, `created_at`) VALUES (1, 'Good', '', '2025-06-27 15:17:02');
INSERT INTO `cbse_observation_parameters` (`id`, `name`, `description`, `created_at`) VALUES (2, 'Excellect', '', '2025-06-27 15:17:13');


#
# TABLE STRUCTURE FOR: cbse_observation_subparameter
#

DROP TABLE IF EXISTS `cbse_observation_subparameter`;

CREATE TABLE `cbse_observation_subparameter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_observation_id` int(11) NOT NULL,
  `cbse_observation_parameter_id` int(11) NOT NULL,
  `maximum_marks` float NOT NULL,
  `description` mediumtext,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `cbse_observation_parameter_id_ibfk_1` (`cbse_observation_parameter_id`),
  KEY `cbse_exam_observation_id_ibfk_1` (`cbse_exam_observation_id`),
  CONSTRAINT `cbse_exam_observation_id_ibfk_1` FOREIGN KEY (`cbse_exam_observation_id`) REFERENCES `cbse_exam_observations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_observation_parameter_id_ibfk_1` FOREIGN KEY (`cbse_observation_parameter_id`) REFERENCES `cbse_observation_parameters` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `cbse_observation_subparameter` (`id`, `cbse_exam_observation_id`, `cbse_observation_parameter_id`, `maximum_marks`, `description`, `created_by`, `created_at`) VALUES (1, 1, 2, '100', NULL, NULL, '2025-06-27 15:18:06');
INSERT INTO `cbse_observation_subparameter` (`id`, `cbse_exam_observation_id`, `cbse_observation_parameter_id`, `maximum_marks`, `description`, `created_by`, `created_at`) VALUES (2, 1, 1, '94', NULL, NULL, '2025-06-27 15:18:06');


#
# TABLE STRUCTURE FOR: cbse_observation_term_student_subparameter
#

DROP TABLE IF EXISTS `cbse_observation_term_student_subparameter`;

CREATE TABLE `cbse_observation_term_student_subparameter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_ovservation_term_id` int(11) DEFAULT NULL,
  `cbse_observation_subparameter_id` int(11) DEFAULT NULL,
  `student_session_id` int(11) DEFAULT NULL,
  `obtain_marks` float(10,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `cbse_observation_term_student_subparameter_ibfk_1` (`cbse_ovservation_term_id`),
  KEY `cbse_observation_subparameter_id` (`cbse_observation_subparameter_id`),
  KEY `student_session_id` (`student_session_id`),
  CONSTRAINT `cbse_observation_term_student_subparameter_ibfk_1` FOREIGN KEY (`cbse_ovservation_term_id`) REFERENCES `cbse_observation_terms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_observation_term_student_subparameter_ibfk_2` FOREIGN KEY (`cbse_observation_subparameter_id`) REFERENCES `cbse_observation_subparameter` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_observation_term_student_subparameter_ibfk_3` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: cbse_observation_terms
#

DROP TABLE IF EXISTS `cbse_observation_terms`;

CREATE TABLE `cbse_observation_terms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_observation_id` int(11) NOT NULL,
  `cbse_term_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `description` text,
  PRIMARY KEY (`id`),
  KEY `cbse_term_id` (`cbse_term_id`),
  KEY `cbse_ovservation_terms_ibfk_3` (`session_id`),
  KEY `cbse_exam_observations_ibfk_1` (`cbse_exam_observation_id`),
  CONSTRAINT `cbse_exam_observations_ibfk_1` FOREIGN KEY (`cbse_exam_observation_id`) REFERENCES `cbse_exam_observations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_observation_terms_ibfk_2` FOREIGN KEY (`cbse_term_id`) REFERENCES `cbse_terms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_observation_terms_ibfk_3` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `cbse_observation_terms` (`id`, `cbse_exam_observation_id`, `cbse_term_id`, `session_id`, `description`) VALUES (1, 1, 1, 28, 'Excellent');


#
# TABLE STRUCTURE FOR: cbse_student_exam_ranks
#

DROP TABLE IF EXISTS `cbse_student_exam_ranks`;

CREATE TABLE `cbse_student_exam_ranks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_id` int(11) NOT NULL,
  `student_session_id` int(11) DEFAULT NULL,
  `rank` int(11) DEFAULT NULL,
  `rank_percentage` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `cbse_exam_id` (`cbse_exam_id`),
  KEY `student_session_id` (`student_session_id`),
  KEY `idx_rank` (`rank`),
  KEY `idx_rank_percentage` (`rank_percentage`),
  CONSTRAINT `cbse_student_exam_ranks_ibfk_1` FOREIGN KEY (`cbse_exam_id`) REFERENCES `cbse_exams` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_student_exam_ranks_ibfk_2` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: cbse_student_subject_marks
#

DROP TABLE IF EXISTS `cbse_student_subject_marks`;

CREATE TABLE `cbse_student_subject_marks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_timetable_assessment_type_id` int(11) NOT NULL,
  `cbse_exam_timetable_id` int(11) DEFAULT NULL,
  `cbse_exam_student_id` int(11) DEFAULT NULL,
  `cbse_exam_assessment_type_id` int(11) DEFAULT NULL,
  `is_absent` int(1) NOT NULL DEFAULT '0',
  `marks` float(10,2) DEFAULT '0.00',
  `note` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `cbse_exam_timetable_id` (`cbse_exam_timetable_id`),
  KEY `cbse_exam_student_id` (`cbse_exam_student_id`),
  KEY `cbse_exam_assessment_type_id` (`cbse_exam_assessment_type_id`),
  KEY `cbse_exam_timetable_assessment_type_ibfk_4` (`cbse_exam_timetable_assessment_type_id`),
  CONSTRAINT `cbse_exam_timetable_assessment_type_ibfk_4` FOREIGN KEY (`cbse_exam_timetable_assessment_type_id`) REFERENCES `cbse_exam_timetable_assessment_types` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_student_subject_marks_ibfk_1` FOREIGN KEY (`cbse_exam_timetable_id`) REFERENCES `cbse_exam_timetable` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_student_subject_marks_ibfk_2` FOREIGN KEY (`cbse_exam_student_id`) REFERENCES `cbse_exam_students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_student_subject_marks_ibfk_3` FOREIGN KEY (`cbse_exam_assessment_type_id`) REFERENCES `cbse_exam_assessment_types` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: cbse_student_subject_result
#

DROP TABLE IF EXISTS `cbse_student_subject_result`;

CREATE TABLE `cbse_student_subject_result` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_timetable_id` int(11) DEFAULT NULL,
  `cbse_exam_student_id` int(11) DEFAULT NULL,
  `note` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: cbse_student_template_rank
#

DROP TABLE IF EXISTS `cbse_student_template_rank`;

CREATE TABLE `cbse_student_template_rank` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_template_id` int(11) DEFAULT NULL,
  `student_session_id` int(11) DEFAULT NULL,
  `rank` int(20) DEFAULT NULL,
  `rank_percentage` float(10,2) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `student_session_id` (`student_session_id`),
  KEY `cbse_template_id` (`cbse_template_id`),
  KEY `idx_rank` (`rank`),
  KEY `idx_rank_percentage` (`rank_percentage`),
  CONSTRAINT `cbse_student_template_rank_ibfk_1` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_student_template_rank_ibfk_2` FOREIGN KEY (`cbse_template_id`) REFERENCES `cbse_template` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: cbse_template
#

DROP TABLE IF EXISTS `cbse_template`;

CREATE TABLE `cbse_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `orientation` varchar(1) NOT NULL DEFAULT 'P',
  `description` varchar(255) NOT NULL,
  `gradeexam_id` int(11) DEFAULT NULL,
  `remarkexam_id` int(11) DEFAULT NULL,
  `is_weightage` varchar(10) NOT NULL,
  `marksheet_type` varchar(50) NOT NULL,
  `created_by` int(11) NOT NULL,
  `header_image` varbinary(500) DEFAULT NULL,
  `title` text,
  `left_logo` varchar(200) DEFAULT NULL,
  `right_logo` varchar(200) DEFAULT NULL,
  `exam_name` varchar(200) DEFAULT NULL,
  `school_name` varchar(200) DEFAULT NULL,
  `exam_center` varchar(200) DEFAULT NULL,
  `session_id` int(11) NOT NULL,
  `left_sign` varchar(200) DEFAULT NULL,
  `middle_sign` varchar(200) DEFAULT NULL,
  `right_sign` varchar(200) DEFAULT NULL,
  `background_img` varchar(200) DEFAULT NULL,
  `content` text,
  `content_footer` text,
  `date` date DEFAULT NULL,
  `is_name` int(1) DEFAULT '1',
  `is_father_name` int(1) DEFAULT '1',
  `is_mother_name` int(1) DEFAULT '1',
  `exam_session` int(1) DEFAULT '1',
  `is_admission_no` int(1) DEFAULT '1',
  `is_division` int(1) NOT NULL DEFAULT '1',
  `is_roll_no` int(1) DEFAULT '1',
  `is_photo` int(1) DEFAULT '1',
  `is_class` int(1) NOT NULL DEFAULT '0',
  `is_section` int(1) NOT NULL DEFAULT '0',
  `is_dob` int(1) DEFAULT '1',
  `is_remark` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `cbse_template_ibfk_3` (`session_id`),
  KEY `cbse_template_ibfk_1` (`gradeexam_id`),
  KEY `cbse_template_ibfk_2` (`remarkexam_id`),
  KEY `idx_name` (`name`),
  KEY `idx_marksheet_type` (`marksheet_type`),
  KEY `idx_exam_name` (`exam_name`),
  KEY `idx_school_name` (`school_name`),
  CONSTRAINT `cbse_template_ibfk_1` FOREIGN KEY (`gradeexam_id`) REFERENCES `cbse_exams` (`id`) ON DELETE SET NULL,
  CONSTRAINT `cbse_template_ibfk_2` FOREIGN KEY (`remarkexam_id`) REFERENCES `cbse_exams` (`id`) ON DELETE SET NULL,
  CONSTRAINT `cbse_template_ibfk_3` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `cbse_template` (`id`, `name`, `orientation`, `description`, `gradeexam_id`, `remarkexam_id`, `is_weightage`, `marksheet_type`, `created_by`, `header_image`, `title`, `left_logo`, `right_logo`, `exam_name`, `school_name`, `exam_center`, `session_id`, `left_sign`, `middle_sign`, `right_sign`, `background_img`, `content`, `content_footer`, `date`, `is_name`, `is_father_name`, `is_mother_name`, `exam_session`, `is_admission_no`, `is_division`, `is_roll_no`, `is_photo`, `is_class`, `is_section`, `is_dob`, `is_remark`) VALUES (1, 'Exam Report1', 'L', '', NULL, NULL, '', '', 1, NULL, NULL, NULL, NULL, NULL, 'Bankalal School ', '001', 28, NULL, NULL, NULL, NULL, NULL, '', '2025-07-01', 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1);


#
# TABLE STRUCTURE FOR: cbse_template_class_sections
#

DROP TABLE IF EXISTS `cbse_template_class_sections`;

CREATE TABLE `cbse_template_class_sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_template_id` int(11) NOT NULL,
  `class_section_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `cbse_template_id` (`cbse_template_id`),
  KEY `class_section_id` (`class_section_id`),
  CONSTRAINT `cbse_template_class_sections_ibfk_1` FOREIGN KEY (`cbse_template_id`) REFERENCES `cbse_template` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_template_class_sections_ibfk_2` FOREIGN KEY (`class_section_id`) REFERENCES `class_sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `cbse_template_class_sections` (`id`, `cbse_template_id`, `class_section_id`, `created_at`) VALUES (1, 1, 62, '2025-06-27 15:10:34');
INSERT INTO `cbse_template_class_sections` (`id`, `cbse_template_id`, `class_section_id`, `created_at`) VALUES (2, 1, 63, '2025-06-27 15:10:34');


#
# TABLE STRUCTURE FOR: cbse_template_term_exams
#

DROP TABLE IF EXISTS `cbse_template_term_exams`;

CREATE TABLE `cbse_template_term_exams` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_template_term_id` int(11) DEFAULT NULL,
  `cbse_exam_id` int(11) NOT NULL,
  `cbse_template_id` int(11) NOT NULL,
  `weightage` float NOT NULL DEFAULT '100',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `cbse_template_term_id` (`cbse_template_term_id`),
  KEY `cbse_template_term_exams_ibfk_3` (`cbse_exam_id`),
  KEY `cbse_template_term_exams_ibfk_4` (`cbse_template_id`),
  KEY `idx_weightage` (`weightage`),
  CONSTRAINT `cbse_template_term_exams_ibfk_1` FOREIGN KEY (`cbse_exam_id`) REFERENCES `cbse_exams` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_template_term_exams_ibfk_2` FOREIGN KEY (`cbse_template_term_id`) REFERENCES `cbse_template_terms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_template_term_exams_ibfk_4` FOREIGN KEY (`cbse_template_id`) REFERENCES `cbse_template` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: cbse_template_terms
#

DROP TABLE IF EXISTS `cbse_template_terms`;

CREATE TABLE `cbse_template_terms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_template_id` int(11) NOT NULL,
  `cbse_term_id` int(11) NOT NULL,
  `weightage` float NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `cbse_template_id` (`cbse_template_id`),
  KEY `cbse_term_id` (`cbse_term_id`),
  KEY `idx_weightage` (`weightage`),
  CONSTRAINT `cbse_template_terms_ibfk_1` FOREIGN KEY (`cbse_template_id`) REFERENCES `cbse_template` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_template_terms_ibfk_2` FOREIGN KEY (`cbse_term_id`) REFERENCES `cbse_terms` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: cbse_terms
#

DROP TABLE IF EXISTS `cbse_terms`;

CREATE TABLE `cbse_terms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `term_code` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`),
  KEY `idx_term_code` (`term_code`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `cbse_terms` (`id`, `name`, `term_code`, `description`, `created_by`, `created_at`) VALUES (1, 'Unit 1', 'Unit1', 'Unit 1', 1, '2025-06-27 15:11:01');


#
# TABLE STRUCTURE FOR: cert_settings
#

DROP TABLE IF EXISTS `cert_settings`;

CREATE TABLE `cert_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cert_type` varchar(200) DEFAULT NULL,
  `inst_type` varchar(200) DEFAULT NULL,
  `cert_auto_insert` varchar(200) DEFAULT NULL,
  `cert_prefix` varchar(200) DEFAULT NULL,
  `cert_start_from` varchar(200) DEFAULT NULL,
  `cert_no_digit` varchar(200) DEFAULT NULL,
  `cert_update_status` varchar(200) DEFAULT NULL,
  `created_by` int(10) DEFAULT NULL,
  `created_ts` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_ts` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

INSERT INTO `cert_settings` (`id`, `cert_type`, `inst_type`, `cert_auto_insert`, `cert_prefix`, `cert_start_from`, `cert_no_digit`, `cert_update_status`, `created_by`, `created_ts`, `updated_ts`) VALUES (1, 'cert_leaving', 'primary', '1', '2324', '1', '4', '1', 1, '2020-06-27 15:54:13', '2024-05-22 12:23:43');
INSERT INTO `cert_settings` (`id`, `cert_type`, `inst_type`, `cert_auto_insert`, `cert_prefix`, `cert_start_from`, `cert_no_digit`, `cert_update_status`, `created_by`, `created_ts`, `updated_ts`) VALUES (2, 'cert_leaving', 'secondary', '1', '2324', '0001', '4', '0', 1, '2020-07-02 18:00:58', '2024-06-12 01:52:10');
INSERT INTO `cert_settings` (`id`, `cert_type`, `inst_type`, `cert_auto_insert`, `cert_prefix`, `cert_start_from`, `cert_no_digit`, `cert_update_status`, `created_by`, `created_ts`, `updated_ts`) VALUES (3, 'cert_bonafide', 'primary', '1', '2324', '0001', '4', '1', 1, '2023-10-22 16:40:27', '2023-10-22 04:40:51');
INSERT INTO `cert_settings` (`id`, `cert_type`, `inst_type`, `cert_auto_insert`, `cert_prefix`, `cert_start_from`, `cert_no_digit`, `cert_update_status`, `created_by`, `created_ts`, `updated_ts`) VALUES (4, 'cert_bonafide', 'secondary', '1', '2324', '0001', '4', '1', 1, '2023-10-22 16:41:09', '2023-10-22 04:43:32');
INSERT INTO `cert_settings` (`id`, `cert_type`, `inst_type`, `cert_auto_insert`, `cert_prefix`, `cert_start_from`, `cert_no_digit`, `cert_update_status`, `created_by`, `created_ts`, `updated_ts`) VALUES (5, 'cert_bonafide', 'higher_secondary', '1', '2324', '0001', '4', '1', 1, '2023-10-22 16:41:26', '2023-10-22 04:43:41');
INSERT INTO `cert_settings` (`id`, `cert_type`, `inst_type`, `cert_auto_insert`, `cert_prefix`, `cert_start_from`, `cert_no_digit`, `cert_update_status`, `created_by`, `created_ts`, `updated_ts`) VALUES (6, 'cert_entry', 'primary', '1', '2324', '0001', '4', '1', 1, '2023-10-22 16:41:45', NULL);
INSERT INTO `cert_settings` (`id`, `cert_type`, `inst_type`, `cert_auto_insert`, `cert_prefix`, `cert_start_from`, `cert_no_digit`, `cert_update_status`, `created_by`, `created_ts`, `updated_ts`) VALUES (7, 'cert_entry', 'secondary', '1', '2324', '0001', '4', '1', 1, '2023-10-22 16:42:06', NULL);
INSERT INTO `cert_settings` (`id`, `cert_type`, `inst_type`, `cert_auto_insert`, `cert_prefix`, `cert_start_from`, `cert_no_digit`, `cert_update_status`, `created_by`, `created_ts`, `updated_ts`) VALUES (8, 'cert_leaving', 'higher_secondary', '1', '2324', '0001', '4', '1', 1, '2023-10-22 16:42:52', NULL);
INSERT INTO `cert_settings` (`id`, `cert_type`, `inst_type`, `cert_auto_insert`, `cert_prefix`, `cert_start_from`, `cert_no_digit`, `cert_update_status`, `created_by`, `created_ts`, `updated_ts`) VALUES (9, 'fees_entry', '', '1', '202425', '001', '3', '1', 1, '2025-05-17 06:04:13', NULL);


#
# TABLE STRUCTURE FOR: certificatecounts
#

DROP TABLE IF EXISTS `certificatecounts`;

CREATE TABLE `certificatecounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `certificate` varchar(100) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `sessionid` varchar(255) NOT NULL,
  `created_at` varchar(40) DEFAULT NULL,
  `updated_at` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

#
# TABLE STRUCTURE FOR: certificates
#

DROP TABLE IF EXISTS `certificates`;

CREATE TABLE `certificates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `certificate_name` varchar(100) NOT NULL,
  `certificate_text` text NOT NULL,
  `left_header` varchar(100) NOT NULL,
  `center_header` varchar(100) NOT NULL,
  `right_header` varchar(100) NOT NULL,
  `left_footer` varchar(100) NOT NULL,
  `right_footer` varchar(100) NOT NULL,
  `center_footer` varchar(100) NOT NULL,
  `background_image` varchar(100) DEFAULT NULL,
  `created_for` tinyint(1) NOT NULL COMMENT '1 = staff, 2 = students',
  `status` tinyint(1) NOT NULL,
  `header_height` int(11) NOT NULL,
  `content_height` int(11) NOT NULL,
  `footer_height` int(11) NOT NULL,
  `content_width` int(11) NOT NULL,
  `enable_student_image` tinyint(1) NOT NULL COMMENT '0=no,1=yes',
  `enable_image_height` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_student_image`, `enable_image_height`, `created_at`, `updated_at`) VALUES (1, 'Sample Transfer Certificate', 'This is certify that <b>[name]</b> has born on [dob]  <br> and have following details [present_address] [guardian] [created_at] [admission_no] [roll_no] [class] [section] [gender] [admission_date] [category] [cast] [father_name] [mother_name] [religion] [email] [phone] .<br>We wish best of luck for future endeavors.', 'Reff. No.....1111111.........', 'To Whomever It May Concern', 'Date: _10__/_10__/__2019__', '.................................<br>admin', '.................................<br>principal', '.................................<br>admin', 'sampletc121.png', 2, 1, 360, 400, 480, 810, 1, 230, '2019-12-21 20:44:34', '0000-00-00 00:00:00');
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_student_image`, `enable_image_height`, `created_at`, `updated_at`) VALUES (2, 'testing certifiacate', 'manual', '', '', '', '', '', '', 'error', 2, 1, 0, 0, 0, 0, 0, 0, '2025-06-13 18:23:36', '2025-06-13 18:23:36');


#
# TABLE STRUCTURE FOR: changelogs
#

DROP TABLE IF EXISTS `changelogs`;

CREATE TABLE `changelogs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `developerName` varchar(255) NOT NULL,
  `latest_version_name` varchar(255) NOT NULL,
  `current_version` varchar(255) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `status` varchar(255) NOT NULL,
  `note` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4;

INSERT INTO `changelogs` (`id`, `developerName`, `latest_version_name`, `current_version`, `type`, `status`, `note`, `created_at`, `updated_at`) VALUES (1, 'anil', 'Version 7.1.0.1', 'Version 7.1.0', 'Bug Fixes', 'Devops Done', 'ewrew', '2025-06-04 01:41:16', '2025-06-04 02:31:36');
INSERT INTO `changelogs` (`id`, `developerName`, `latest_version_name`, `current_version`, `type`, `status`, `note`, `created_at`, `updated_at`) VALUES (3, 'arun', 'Version 7.1.0 DLT 0.0.1', 'Version 7.1.0 ', 'General Changes', 'Deployement Live', '1.Transport fees now working as session wise\n2. In Student Id Card roll number and house name added\n3. In balance fees report mobile number added\n4. Download centre shared content public page design updated\n5. Student and staff barcode/qrcode generate', '2025-06-05 12:38:07', '2025-06-05 12:38:07');
INSERT INTO `changelogs` (`id`, `developerName`, `latest_version_name`, `current_version`, `type`, `status`, `note`, `created_at`, `updated_at`) VALUES (4, 'ashok', 'Version 7.1.0 DLT 0.0.1', 'Version 7.1.0 DLT 0.0.1', 'Feature Enhancement', 'Devops Done', 'Fees Module\r\n\r\n1. Added a new module of College Fees Master\r\n2. Add bank account functionality\r\n3. Added Revert Fees functionality\r\n4. Income head income list and income voucher functionality \r\n5. Expense head expense list and expense voucher functionalit', '2025-06-05 12:47:07', '2025-06-05 12:47:32');
INSERT INTO `changelogs` (`id`, `developerName`, `latest_version_name`, `current_version`, `type`, `status`, `note`, `created_at`, `updated_at`) VALUES (5, 'arun', 'Version 7.1.0 DLT 0.0.1', 'Version 7.1.0', 'Feature Enhancement', 'DeployementLive', '1 Attendance moduel. Added a new module hostal module\n 2 Attendance Report.Added a new moduel for show hostal attendance  \nrecord \n3 Student Deatils :In disabled student show reason of disabled in list why student disabled\n 4 Alumni . Show designation', '2025-06-05 17:43:37', '2025-06-05 17:46:25');
INSERT INTO `changelogs` (`id`, `developerName`, `latest_version_name`, `current_version`, `type`, `status`, `note`, `created_at`, `updated_at`) VALUES (6, 'arun', 'Version 7.1.0 DLT 0.0.1', 'Version 7.1.0', 'Feature Enhancement', 'Devops Done', ' 1 In hostal attendance they want to take student attendance three time   in a day \r\n morning shift  \r\n afternoon shift  \r\n  night shift  \r\n2 also there attendance report according to there shift ', '2025-06-09 18:02:28', '2025-06-09 18:02:28');


#
# TABLE STRUCTURE FOR: chat_connections
#

DROP TABLE IF EXISTS `chat_connections`;

CREATE TABLE `chat_connections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `chat_user_one` int(11) NOT NULL,
  `chat_user_two` int(11) NOT NULL,
  `ip` varchar(30) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_one` (`chat_user_one`),
  KEY `chat_user_two` (`chat_user_two`),
  CONSTRAINT `chat_connections_ibfk_1` FOREIGN KEY (`chat_user_one`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_connections_ibfk_2` FOREIGN KEY (`chat_user_two`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: chat_messages
#

DROP TABLE IF EXISTS `chat_messages`;

CREATE TABLE `chat_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text,
  `chat_user_id` int(11) NOT NULL,
  `ip` varchar(30) NOT NULL,
  `time` int(11) NOT NULL,
  `is_first` int(11) DEFAULT '0',
  `is_read` int(11) NOT NULL DEFAULT '0',
  `chat_connection_id` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `chat_user_id` (`chat_user_id`),
  KEY `chat_connection_id` (`chat_connection_id`),
  CONSTRAINT `chat_messages_ibfk_1` FOREIGN KEY (`chat_user_id`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_messages_ibfk_2` FOREIGN KEY (`chat_connection_id`) REFERENCES `chat_connections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: chat_users
#

DROP TABLE IF EXISTS `chat_users`;

CREATE TABLE `chat_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_type` varchar(20) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `create_staff_id` int(11) DEFAULT NULL,
  `create_student_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `student_id` (`student_id`),
  KEY `create_staff_id` (`create_staff_id`),
  KEY `create_student_id` (`create_student_id`),
  CONSTRAINT `chat_users_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_3` FOREIGN KEY (`create_staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_4` FOREIGN KEY (`create_student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: class_section_times
#

DROP TABLE IF EXISTS `class_section_times`;

CREATE TABLE `class_section_times` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_section_id` int(11) DEFAULT NULL,
  `time` time DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `class_section_id` (`class_section_id`),
  CONSTRAINT `class_section_times_ibfk_1` FOREIGN KEY (`class_section_id`) REFERENCES `class_sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (1, 1, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (2, 2, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (3, 3, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (4, 4, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (5, 5, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (6, 6, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (7, 7, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (8, 8, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (9, 9, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (10, 10, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (11, 11, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (12, 12, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (13, 13, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (14, 14, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (15, 15, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (16, 16, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (17, 17, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (18, 18, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (19, 19, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (20, 20, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (21, 21, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (22, 22, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (23, 23, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (24, 24, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (25, 25, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (26, 26, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (27, 27, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (28, 28, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (29, 29, '00:00:00', '2025-04-18 00:27:47', '2025-04-18 00:27:47');


#
# TABLE STRUCTURE FOR: class_sections
#

DROP TABLE IF EXISTS `class_sections`;

CREATE TABLE `class_sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) DEFAULT NULL,
  `section_id` int(11) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `class_id` (`class_id`),
  KEY `section_id` (`section_id`)
) ENGINE=InnoDB AUTO_INCREMENT=139 DEFAULT CHARSET=utf8;

INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (56, 23, 1, 'no', '2020-01-29 05:58:47', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (57, 23, 2, 'no', '2020-01-29 05:58:47', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (59, 24, 1, 'no', '2020-01-29 05:58:58', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (60, 24, 2, 'no', '2020-01-29 05:58:58', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (62, 25, 1, 'no', '2020-01-29 05:59:08', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (63, 25, 2, 'no', '2020-01-29 05:59:08', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (87, 23, 6, 'no', '2023-08-08 01:50:55', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (88, 23, 7, 'no', '2023-08-08 01:50:55', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (91, 24, 6, 'no', '2023-08-08 01:51:13', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (102, 36, 1, 'no', '2024-03-09 11:32:21', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (103, 36, 2, 'no', '2024-03-09 11:32:21', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (104, 37, 1, 'no', '2024-03-09 11:32:49', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (105, 37, 2, 'no', '2024-03-09 11:32:49', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (106, 38, 1, 'no', '2024-03-09 11:33:18', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (107, 38, 2, 'no', '2024-03-09 11:33:18', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (108, 39, 1, 'no', '2024-03-09 11:33:27', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (109, 39, 2, 'no', '2024-03-09 11:33:27', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (110, 39, 3, 'no', '2024-03-09 11:33:27', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (111, 40, 1, 'no', '2024-03-09 11:33:52', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (112, 40, 2, 'no', '2024-03-09 11:33:52', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (113, 40, 3, 'no', '2024-03-09 11:33:52', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (114, 41, 1, 'no', '2024-03-09 11:34:05', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (115, 41, 2, 'no', '2024-03-09 11:34:05', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (116, 41, 3, 'no', '2024-03-09 11:34:05', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (117, 36, 3, 'no', '2024-03-11 08:10:56', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (123, 43, 1, 'no', '2024-03-20 09:37:50', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (124, 43, 2, 'no', '2024-03-20 09:37:50', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (125, 37, 3, 'no', '2024-04-08 10:12:50', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (133, 38, 3, 'no', '2024-07-03 12:22:44', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (134, 24, 3, 'no', '2024-09-02 13:53:02', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (136, 23, 3, 'no', '2024-09-02 13:53:25', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (137, 43, 3, 'no', '2024-09-02 13:53:32', NULL);
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (138, 25, 3, 'no', '2025-08-04 11:54:54', NULL);


#
# TABLE STRUCTURE FOR: class_subject_periods
#

DROP TABLE IF EXISTS `class_subject_periods`;

CREATE TABLE `class_subject_periods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_section_id` int(11) NOT NULL,
  `subject_group_subject_id` int(11) NOT NULL,
  `periods` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=372 DEFAULT CHARSET=utf8mb4;

INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (1, 1, 1, '10', '2025-05-17 19:16:30', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (2, 1, 2, '10', '2025-05-17 19:16:30', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (3, 1, 3, '10', '2025-05-17 19:16:30', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (4, 1, 4, '10', '2025-05-17 19:16:30', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (5, 1, 5, '8', '2025-05-17 19:16:30', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (6, 60, 398, '7', '2025-07-03 17:13:00', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (7, 60, 405, '3', '2025-07-03 17:13:00', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (8, 60, 406, '3', '2025-07-03 17:13:00', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (9, 60, 407, '4', '2025-07-03 17:13:00', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (10, 60, 426, '8', '2025-07-03 17:13:00', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (11, 60, 427, '5', '2025-07-03 17:13:00', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (12, 60, 428, '3', '2025-07-03 17:13:00', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (13, 60, 429, '6', '2025-07-03 17:13:00', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (14, 60, 430, '2', '2025-07-03 17:13:00', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (15, 60, 431, '3', '2025-07-03 17:13:00', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (16, 60, 432, '2', '2025-07-03 17:13:00', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (17, 60, 433, '2', '2025-07-03 17:13:00', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (18, 56, 387, '6', '2025-07-11 12:34:52', '2025-07-12 12:43:19');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (19, 56, 388, '4', '2025-07-11 12:34:52', '2025-07-12 12:43:19');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (20, 56, 396, '3', '2025-07-11 12:34:52', '2025-07-12 12:43:19');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (21, 56, 397, '7', '2025-07-11 12:34:52', '2025-07-12 12:43:19');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (22, 56, 434, '7', '2025-07-11 12:34:52', '2025-07-12 12:43:19');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (23, 56, 435, '6', '2025-07-11 12:34:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (24, 56, 436, '1', '2025-07-11 12:34:52', '2025-07-29 16:04:59');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (25, 56, 437, '4', '2025-07-11 12:34:52', '2025-07-12 12:43:19');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (26, 56, 438, '1', '2025-07-11 12:34:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (27, 56, 439, '1', '2025-07-11 12:34:52', '2025-07-29 16:04:59');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (28, 56, 440, '1', '2025-07-11 12:34:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (29, 56, 441, '2', '2025-07-11 12:34:52', '2025-07-12 12:43:19');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (30, 56, 442, '1', '2025-07-11 12:34:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (31, 56, 443, '4', '2025-07-11 12:34:52', '2025-07-29 16:04:59');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (32, 102, 346, '8', '2025-07-11 14:07:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (33, 102, 347, '5', '2025-07-11 14:07:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (34, 102, 348, '5', '2025-07-11 14:07:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (35, 102, 349, '8', '2025-07-11 14:07:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (36, 102, 350, '4', '2025-07-11 14:07:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (37, 102, 541, '7', '2025-07-11 14:07:12', '2025-07-11 14:22:55');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (38, 102, 542, '2', '2025-07-11 14:07:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (39, 102, 543, '1', '2025-07-11 14:07:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (40, 102, 544, '1', '2025-07-11 14:07:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (41, 102, 545, '1', '2025-07-11 14:07:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (42, 102, 546, '3', '2025-07-11 14:07:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (43, 102, 547, '2', '2025-07-11 14:07:12', '2025-07-11 14:22:55');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (44, 102, 548, '1', '2025-07-11 14:07:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (45, 104, 352, '8', '2025-07-11 14:13:42', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (46, 104, 353, '5', '2025-07-11 14:13:42', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (47, 104, 354, '5', '2025-07-11 14:13:42', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (48, 104, 532, '7', '2025-07-11 14:13:42', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (49, 104, 533, '4', '2025-07-11 14:13:42', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (50, 104, 534, '2', '2025-07-11 14:13:42', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (51, 104, 535, '1', '2025-07-11 14:13:42', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (52, 104, 536, '1', '2025-07-11 14:13:42', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (53, 104, 537, '3', '2025-07-11 14:13:42', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (54, 104, 538, '2', '2025-07-11 14:13:42', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (55, 104, 539, '1', '2025-07-11 14:13:42', '2025-07-12 11:58:14');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (56, 104, 540, '8', '2025-07-11 14:13:42', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (57, 105, 352, '8', '2025-07-11 14:15:07', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (58, 105, 353, '5', '2025-07-11 14:15:07', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (59, 105, 354, '5', '2025-07-11 14:15:07', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (60, 105, 532, '7', '2025-07-11 14:15:07', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (61, 105, 533, '4', '2025-07-11 14:15:07', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (62, 105, 534, '2', '2025-07-11 14:15:07', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (63, 105, 535, '1', '2025-07-11 14:15:07', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (64, 105, 536, '1', '2025-07-11 14:15:07', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (65, 105, 537, '3', '2025-07-11 14:15:07', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (66, 105, 538, '2', '2025-07-11 14:15:07', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (67, 105, 539, '1', '2025-07-11 14:15:07', '2025-07-12 11:58:37');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (68, 105, 540, '8', '2025-07-11 14:15:07', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (69, 103, 346, '8', '2025-07-11 14:23:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (70, 103, 347, '5', '2025-07-11 14:23:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (71, 103, 348, '5', '2025-07-11 14:23:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (72, 103, 349, '8', '2025-07-11 14:23:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (73, 103, 350, '4', '2025-07-11 14:23:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (74, 103, 541, '7', '2025-07-11 14:23:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (75, 103, 542, '2', '2025-07-11 14:23:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (76, 103, 543, '1', '2025-07-11 14:23:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (77, 103, 544, '1', '2025-07-11 14:23:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (78, 103, 545, '1', '2025-07-11 14:23:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (79, 103, 546, '3', '2025-07-11 14:23:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (80, 103, 547, '2', '2025-07-11 14:23:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (81, 103, 548, '1', '2025-07-11 14:23:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (82, 117, 346, '8', '2025-07-11 14:26:58', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (83, 117, 347, '5', '2025-07-11 14:26:58', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (84, 117, 348, '5', '2025-07-11 14:26:58', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (85, 117, 349, '8', '2025-07-11 14:26:58', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (86, 117, 350, '4', '2025-07-11 14:26:58', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (87, 117, 541, '7', '2025-07-11 14:26:58', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (88, 117, 542, '2', '2025-07-11 14:26:58', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (89, 117, 543, '1', '2025-07-11 14:26:58', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (90, 117, 544, '1', '2025-07-11 14:26:58', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (91, 117, 545, '1', '2025-07-11 14:26:58', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (92, 117, 546, '3', '2025-07-11 14:26:58', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (93, 117, 547, '2', '2025-07-11 14:26:58', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (94, 117, 548, '1', '2025-07-11 14:26:58', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (95, 57, 444, '6', '2025-07-11 17:27:02', '2025-07-12 12:43:59');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (96, 57, 445, '4', '2025-07-11 17:27:02', '2025-07-12 11:10:08');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (97, 57, 446, '7', '2025-07-11 17:27:02', '2025-07-12 11:10:08');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (98, 57, 447, '6', '2025-07-11 17:27:02', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (99, 57, 448, '3', '2025-07-11 17:27:02', '2025-07-12 11:10:08');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (100, 57, 449, '1', '2025-07-11 17:27:02', '2025-07-12 11:10:08');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (101, 57, 450, '1', '2025-07-11 17:27:02', '2025-07-12 11:10:08');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (102, 57, 451, '7', '2025-07-11 17:27:02', '2025-07-12 11:10:08');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (103, 57, 452, '4', '2025-07-11 17:27:02', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (104, 57, 453, '1', '2025-07-11 17:27:02', '2025-07-12 11:10:08');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (105, 57, 454, '1', '2025-07-11 17:27:02', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (106, 57, 455, '1', '2025-07-11 17:27:02', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (107, 57, 456, '2', '2025-07-11 17:27:02', '2025-07-12 12:43:59');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (108, 57, 457, '4', '2025-07-11 17:27:02', '2025-07-12 11:10:08');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (109, 104, 549, '1', '2025-07-12 11:58:14', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (110, 105, 549, '1', '2025-07-12 11:58:37', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (111, 125, 352, '8', '2025-07-12 12:00:28', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (112, 125, 353, '5', '2025-07-12 12:00:28', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (113, 125, 354, '5', '2025-07-12 12:00:28', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (114, 125, 532, '7', '2025-07-12 12:00:28', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (115, 125, 533, '4', '2025-07-12 12:00:28', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (116, 125, 534, '2', '2025-07-12 12:00:28', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (117, 125, 535, '1', '2025-07-12 12:00:28', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (118, 125, 536, '1', '2025-07-12 12:00:28', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (119, 125, 537, '3', '2025-07-12 12:00:28', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (120, 125, 538, '2', '2025-07-12 12:00:28', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (121, 125, 539, '1', '2025-07-12 12:00:28', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (122, 125, 540, '8', '2025-07-12 12:00:28', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (123, 125, 549, '1', '2025-07-12 12:00:28', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (124, 106, 355, '7', '2025-07-12 12:06:29', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (125, 106, 356, '4', '2025-07-12 12:06:29', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (126, 106, 357, '4', '2025-07-12 12:06:29', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (127, 106, 519, '7', '2025-07-12 12:06:29', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (128, 106, 520, '6', '2025-07-12 12:06:29', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (129, 106, 521, '3', '2025-07-12 12:06:29', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (130, 106, 522, '1', '2025-07-12 12:06:29', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (131, 106, 523, '1', '2025-07-12 12:06:29', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (132, 106, 524, '6', '2025-07-12 12:06:29', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (133, 106, 525, '1', '2025-07-12 12:06:29', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (134, 106, 526, '2', '2025-07-12 12:06:29', '2025-07-15 16:13:27');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (135, 106, 527, '2', '2025-07-12 12:06:29', '2025-07-15 16:13:27');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (136, 106, 528, '2', '2025-07-12 12:06:29', '2025-07-15 16:13:27');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (137, 106, 529, '2', '2025-07-12 12:06:29', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (138, 107, 355, '7', '2025-07-12 12:07:49', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (139, 107, 356, '4', '2025-07-12 12:07:49', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (140, 107, 357, '4', '2025-07-12 12:07:49', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (141, 107, 519, '7', '2025-07-12 12:07:49', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (142, 107, 520, '6', '2025-07-12 12:07:49', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (143, 107, 521, '3', '2025-07-12 12:07:49', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (144, 107, 522, '1', '2025-07-12 12:07:49', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (145, 107, 523, '1', '2025-07-12 12:07:49', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (146, 107, 524, '6', '2025-07-12 12:07:49', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (147, 107, 525, '1', '2025-07-12 12:07:49', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (148, 107, 526, '1', '2025-07-12 12:07:49', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (149, 107, 527, '1', '2025-07-12 12:07:49', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (150, 107, 528, '4', '2025-07-12 12:07:49', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (151, 107, 529, '2', '2025-07-12 12:07:49', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (152, 133, 355, '7', '2025-07-12 12:09:39', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (153, 133, 356, '4', '2025-07-12 12:09:39', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (154, 133, 357, '4', '2025-07-12 12:09:39', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (155, 133, 519, '7', '2025-07-12 12:09:39', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (156, 133, 520, '6', '2025-07-12 12:09:39', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (157, 133, 521, '3', '2025-07-12 12:09:39', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (158, 133, 522, '1', '2025-07-12 12:09:39', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (159, 133, 523, '1', '2025-07-12 12:09:39', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (160, 133, 524, '6', '2025-07-12 12:09:39', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (161, 133, 525, '1', '2025-07-12 12:09:39', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (162, 133, 526, '1', '2025-07-12 12:09:39', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (163, 133, 527, '1', '2025-07-12 12:09:39', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (164, 133, 528, '4', '2025-07-12 12:09:39', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (165, 133, 529, '2', '2025-07-12 12:09:39', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (166, 108, 358, '8', '2025-07-12 12:18:21', '2025-07-23 19:09:53');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (167, 108, 359, '4', '2025-07-12 12:18:21', '2025-07-23 23:51:06');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (168, 108, 360, '4', '2025-07-12 12:18:21', '2025-07-23 23:51:06');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (169, 108, 361, '8', '2025-07-12 12:18:21', '2025-07-23 23:51:06');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (170, 108, 362, '6', '2025-07-12 12:18:21', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (171, 108, 363, '1', '2025-07-12 12:18:21', '2025-07-23 23:51:06');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (172, 108, 364, '6', '2025-07-12 12:18:21', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (173, 108, 365, '1', '2025-07-12 12:18:21', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (174, 108, 512, '1', '2025-07-12 12:18:21', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (175, 108, 513, '4', '2025-07-12 12:18:21', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (176, 108, 514, '2', '2025-07-12 12:18:21', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (177, 108, 516, '1', '2025-07-12 12:18:21', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (178, 108, 517, '1', '2025-07-12 12:18:21', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (179, 108, 550, '1', '2025-07-12 12:18:21', '2025-07-23 23:51:06');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (180, 109, 358, '7', '2025-07-12 12:32:54', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (181, 109, 359, '4', '2025-07-12 12:32:54', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (182, 109, 360, '4', '2025-07-12 12:32:54', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (183, 109, 361, '7', '2025-07-12 12:32:54', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (184, 109, 362, '6', '2025-07-12 12:32:54', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (185, 109, 363, '3', '2025-07-12 12:32:54', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (186, 109, 364, '6', '2025-07-12 12:32:54', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (187, 109, 365, '1', '2025-07-12 12:32:54', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (188, 109, 512, '1', '2025-07-12 12:32:54', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (189, 109, 513, '4', '2025-07-12 12:32:54', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (190, 109, 514, '2', '2025-07-12 12:32:54', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (191, 109, 516, '1', '2025-07-12 12:32:54', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (192, 109, 517, '1', '2025-07-12 12:32:54', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (193, 109, 550, '1', '2025-07-12 12:32:54', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (194, 110, 358, '7', '2025-07-12 12:33:36', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (195, 110, 359, '4', '2025-07-12 12:33:36', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (196, 110, 360, '4', '2025-07-12 12:33:36', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (197, 110, 361, '7', '2025-07-12 12:33:36', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (198, 110, 362, '6', '2025-07-12 12:33:36', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (199, 110, 363, '3', '2025-07-12 12:33:36', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (200, 110, 364, '6', '2025-07-12 12:33:36', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (201, 110, 365, '1', '2025-07-12 12:33:36', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (202, 110, 512, '1', '2025-07-12 12:33:36', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (203, 110, 513, '4', '2025-07-12 12:33:36', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (204, 110, 514, '2', '2025-07-12 12:33:36', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (205, 110, 516, '1', '2025-07-12 12:33:36', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (206, 110, 517, '1', '2025-07-12 12:33:36', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (207, 110, 550, '1', '2025-07-12 12:33:36', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (208, 111, 366, '7', '2025-07-12 12:34:55', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (209, 111, 367, '4', '2025-07-12 12:34:55', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (210, 111, 368, '4', '2025-07-12 12:34:55', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (211, 111, 370, '7', '2025-07-12 12:34:55', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (212, 111, 371, '3', '2025-07-12 12:34:55', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (213, 111, 372, '6', '2025-07-12 12:34:55', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (214, 111, 504, '6', '2025-07-12 12:34:55', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (215, 111, 505, '1', '2025-07-12 12:34:55', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (216, 111, 506, '1', '2025-07-12 12:34:55', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (217, 111, 507, '1', '2025-07-12 12:34:55', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (218, 111, 508, '1', '2025-07-12 12:34:55', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (219, 111, 509, '1', '2025-07-12 12:34:55', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (220, 111, 510, '2', '2025-07-12 12:34:55', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (221, 111, 511, '4', '2025-07-12 12:34:55', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (222, 112, 366, '7', '2025-07-12 12:35:32', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (223, 112, 367, '4', '2025-07-12 12:35:32', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (224, 112, 368, '4', '2025-07-12 12:35:32', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (225, 112, 370, '7', '2025-07-12 12:35:32', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (226, 112, 371, '3', '2025-07-12 12:35:32', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (227, 112, 372, '6', '2025-07-12 12:35:32', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (228, 112, 504, '6', '2025-07-12 12:35:32', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (229, 112, 505, '1', '2025-07-12 12:35:32', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (230, 112, 506, '1', '2025-07-12 12:35:32', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (231, 112, 507, '1', '2025-07-12 12:35:32', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (232, 112, 508, '1', '2025-07-12 12:35:32', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (233, 112, 509, '1', '2025-07-12 12:35:32', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (234, 112, 510, '2', '2025-07-12 12:35:32', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (235, 112, 511, '4', '2025-07-12 12:35:32', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (236, 113, 366, '7', '2025-07-12 12:36:23', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (237, 113, 367, '4', '2025-07-12 12:36:23', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (238, 113, 368, '4', '2025-07-12 12:36:23', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (239, 113, 370, '7', '2025-07-12 12:36:23', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (240, 113, 371, '3', '2025-07-12 12:36:23', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (241, 113, 372, '6', '2025-07-12 12:36:23', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (242, 113, 504, '6', '2025-07-12 12:36:23', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (243, 113, 505, '1', '2025-07-12 12:36:23', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (244, 113, 506, '1', '2025-07-12 12:36:23', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (245, 113, 507, '1', '2025-07-12 12:36:23', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (246, 113, 508, '1', '2025-07-12 12:36:23', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (247, 113, 509, '1', '2025-07-12 12:36:23', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (248, 113, 510, '2', '2025-07-12 12:36:23', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (249, 113, 511, '4', '2025-07-12 12:36:23', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (250, 114, 373, '7', '2025-07-12 12:37:13', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (251, 114, 374, '4', '2025-07-12 12:37:13', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (252, 114, 377, '7', '2025-07-12 12:37:13', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (253, 114, 378, '3', '2025-07-12 12:37:13', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (254, 114, 379, '6', '2025-07-12 12:37:13', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (255, 114, 481, '6', '2025-07-12 12:37:13', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (256, 114, 482, '1', '2025-07-12 12:37:13', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (257, 114, 483, '1', '2025-07-12 12:37:13', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (258, 114, 484, '4', '2025-07-12 12:37:13', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (259, 114, 485, '1', '2025-07-12 12:37:13', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (260, 114, 486, '1', '2025-07-12 12:37:13', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (261, 114, 487, '1', '2025-07-12 12:37:13', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (262, 114, 488, '2', '2025-07-12 12:37:13', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (263, 114, 489, '4', '2025-07-12 12:37:13', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (264, 115, 490, '7', '2025-07-12 12:37:59', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (265, 115, 491, '4', '2025-07-12 12:37:59', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (266, 115, 492, '7', '2025-07-12 12:37:59', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (267, 115, 493, '6', '2025-07-12 12:37:59', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (268, 115, 494, '3', '2025-07-12 12:37:59', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (269, 115, 495, '1', '2025-07-12 12:37:59', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (270, 115, 496, '1', '2025-07-12 12:37:59', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (271, 115, 497, '6', '2025-07-12 12:37:59', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (272, 115, 498, '4', '2025-07-12 12:37:59', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (273, 115, 499, '1', '2025-07-12 12:37:59', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (274, 115, 500, '1', '2025-07-12 12:37:59', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (275, 115, 501, '1', '2025-07-12 12:37:59', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (276, 115, 502, '2', '2025-07-12 12:37:59', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (277, 115, 503, '4', '2025-07-12 12:37:59', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (278, 116, 490, '7', '2025-07-12 12:38:44', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (279, 116, 491, '4', '2025-07-12 12:38:44', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (280, 116, 492, '7', '2025-07-12 12:38:44', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (281, 116, 493, '6', '2025-07-12 12:38:44', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (282, 116, 494, '3', '2025-07-12 12:38:44', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (283, 116, 495, '1', '2025-07-12 12:38:44', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (284, 116, 496, '1', '2025-07-12 12:38:44', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (285, 116, 497, '6', '2025-07-12 12:38:44', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (286, 116, 498, '4', '2025-07-12 12:38:44', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (287, 116, 499, '1', '2025-07-12 12:38:44', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (288, 116, 500, '1', '2025-07-12 12:38:44', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (289, 116, 501, '1', '2025-07-12 12:38:44', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (290, 116, 502, '2', '2025-07-12 12:38:44', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (291, 116, 503, '4', '2025-07-12 12:38:44', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (292, 123, 380, '7', '2025-07-12 12:39:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (293, 123, 381, '4', '2025-07-12 12:39:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (294, 123, 384, '7', '2025-07-12 12:39:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (295, 123, 385, '3', '2025-07-12 12:39:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (296, 123, 386, '6', '2025-07-12 12:39:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (297, 123, 458, '6', '2025-07-12 12:39:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (298, 123, 459, '1', '2025-07-12 12:39:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (299, 123, 460, '1', '2025-07-12 12:39:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (300, 123, 461, '4', '2025-07-12 12:39:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (301, 123, 462, '1', '2025-07-12 12:39:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (302, 123, 463, '1', '2025-07-12 12:39:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (303, 123, 464, '2', '2025-07-12 12:39:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (304, 123, 465, '4', '2025-07-12 12:39:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (305, 123, 466, '1', '2025-07-12 12:39:52', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (306, 124, 467, '7', '2025-07-12 12:40:51', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (307, 124, 468, '4', '2025-07-12 12:40:51', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (308, 124, 469, '7', '2025-07-12 12:40:51', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (309, 124, 470, '6', '2025-07-12 12:40:51', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (310, 124, 471, '3', '2025-07-12 12:40:51', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (311, 124, 472, '1', '2025-07-12 12:40:51', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (312, 124, 473, '1', '2025-07-12 12:40:51', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (313, 124, 474, '6', '2025-07-12 12:40:51', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (314, 124, 475, '4', '2025-07-12 12:40:51', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (315, 124, 476, '1', '2025-07-12 12:40:51', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (316, 124, 477, '1', '2025-07-12 12:40:51', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (317, 124, 478, '1', '2025-07-12 12:40:51', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (318, 124, 479, '2', '2025-07-12 12:40:51', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (319, 124, 480, '4', '2025-07-12 12:40:51', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (320, 137, 467, '7', '2025-07-12 12:42:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (321, 137, 468, '4', '2025-07-12 12:42:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (322, 137, 469, '7', '2025-07-12 12:42:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (323, 137, 470, '6', '2025-07-12 12:42:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (324, 137, 471, '3', '2025-07-12 12:42:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (325, 137, 472, '1', '2025-07-12 12:42:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (326, 137, 473, '1', '2025-07-12 12:42:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (327, 137, 474, '6', '2025-07-12 12:42:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (328, 137, 475, '4', '2025-07-12 12:42:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (329, 137, 476, '1', '2025-07-12 12:42:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (330, 137, 477, '1', '2025-07-12 12:42:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (331, 137, 478, '1', '2025-07-12 12:42:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (332, 137, 479, '2', '2025-07-12 12:42:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (333, 137, 480, '4', '2025-07-12 12:42:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (334, 136, 444, '6', '2025-07-12 12:45:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (335, 136, 445, '4', '2025-07-12 12:45:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (336, 136, 446, '7', '2025-07-12 12:45:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (337, 136, 447, '6', '2025-07-12 12:45:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (338, 136, 448, '3', '2025-07-12 12:45:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (339, 136, 449, '1', '2025-07-12 12:45:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (340, 136, 450, '1', '2025-07-12 12:45:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (341, 136, 451, '7', '2025-07-12 12:45:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (342, 136, 452, '4', '2025-07-12 12:45:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (343, 136, 453, '1', '2025-07-12 12:45:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (344, 136, 454, '1', '2025-07-12 12:45:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (345, 136, 455, '1', '2025-07-12 12:45:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (346, 136, 456, '2', '2025-07-12 12:45:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (347, 136, 457, '4', '2025-07-12 12:45:12', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (348, 59, 398, '7', '2025-07-12 12:47:09', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (349, 59, 405, '3', '2025-07-12 12:47:09', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (350, 59, 406, '3', '2025-07-12 12:47:09', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (351, 59, 407, '4', '2025-07-12 12:47:09', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (352, 59, 426, '8', '2025-07-12 12:47:09', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (353, 59, 427, '5', '2025-07-12 12:47:09', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (354, 59, 428, '3', '2025-07-12 12:47:09', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (355, 59, 429, '6', '2025-07-12 12:47:09', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (356, 59, 430, '2', '2025-07-12 12:47:09', '2025-07-12 12:48:52');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (357, 59, 431, '3', '2025-07-12 12:47:09', '2025-07-12 12:48:52');
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (358, 59, 432, '2', '2025-07-12 12:47:09', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (359, 59, 433, '2', '2025-07-12 12:47:09', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (360, 134, 398, '7', '2025-07-12 12:50:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (361, 134, 405, '3', '2025-07-12 12:50:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (362, 134, 406, '3', '2025-07-12 12:50:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (363, 134, 407, '4', '2025-07-12 12:50:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (364, 134, 426, '8', '2025-07-12 12:50:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (365, 134, 427, '5', '2025-07-12 12:50:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (366, 134, 428, '3', '2025-07-12 12:50:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (367, 134, 429, '6', '2025-07-12 12:50:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (368, 134, 430, '3', '2025-07-12 12:50:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (369, 134, 431, '2', '2025-07-12 12:50:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (370, 134, 432, '2', '2025-07-12 12:50:01', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (371, 134, 433, '2', '2025-07-12 12:50:01', NULL);


#
# TABLE STRUCTURE FOR: class_teacher
#

DROP TABLE IF EXISTS `class_teacher`;

CREATE TABLE `class_teacher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `class_id` (`class_id`),
  KEY `section_id` (`section_id`),
  KEY `session_id` (`session_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `class_teacher_ibfk_1` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `class_teacher_ibfk_2` FOREIGN KEY (`section_id`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `class_teacher_ibfk_3` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `class_teacher_ibfk_4` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8;

INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (1, 20, 1, 1, 3);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (2, 20, 1, 2, 3);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (3, 20, 10, 1, 3);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (4, 25, 1, 1, 3);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (5, 25, 1, 2, 3);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (6, 25, 10, 1, 3);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (7, 19, 1, 1, 3);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (8, 24, 1, 1, 3);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (9, 24, 1, 1, 3);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (10, 19, 7, 1, 3);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (11, 19, 4, 2, 3);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (12, 28, 36, 2, 146);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (13, 28, 25, 1, 85);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (14, 28, 41, 3, 86);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (15, 28, 41, 2, 87);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (16, 28, 43, 2, 88);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (17, 28, 24, 3, 89);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (18, 28, 40, 1, 90);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (19, 28, 25, 2, 94);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (20, 28, 23, 1, 145);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (22, 28, 36, 3, 109);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (23, 28, 37, 1, 135);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (25, 28, 37, 3, 99);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (26, 28, 38, 2, 103);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (27, 28, 38, 1, 144);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (28, 28, 38, 3, 104);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (29, 28, 39, 1, 105);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (30, 28, 39, 2, 101);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (31, 28, 39, 3, 133);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (32, 28, 40, 3, 100);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (33, 28, 41, 1, 138);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (34, 28, 43, 1, 139);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (35, 28, 23, 2, 97);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (36, 28, 23, 3, 142);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (37, 28, 24, 2, 102);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (38, 28, 37, 2, 116);


#
# TABLE STRUCTURE FOR: class_timeline
#

DROP TABLE IF EXISTS `class_timeline`;

CREATE TABLE `class_timeline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `day` varchar(20) DEFAULT NULL,
  `period_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `teacher_id` int(11) NOT NULL,
  `time_from` varchar(100) NOT NULL,
  `time_to` varchar(100) NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=841 DEFAULT CHARSET=utf8mb4;

INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (121, 23, 136, 'Tuesday', 1, 456, 126, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (122, 23, 136, 'Wednesday', 1, 444, 89, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (123, 23, 136, 'Monday', 1, 451, 139, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (124, 23, 136, 'Friday', 1, 447, 97, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (125, 23, 136, 'Saturday', 1, 454, 147, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (126, 23, 136, 'Thursday', 1, 444, 89, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (127, 23, 136, 'Saturday', 2, 447, 97, '09:55 AM', '10:35 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (128, 23, 136, 'Thursday', 2, 450, 113, '09:55 AM', '10:35 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (129, 23, 136, 'Friday', 2, 457, 0, '09:55 AM', '10:35 AM', 1, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (130, 23, 136, 'Monday', 2, 455, 163, '09:55 AM', '10:35 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (131, 23, 136, 'Wednesday', 2, 457, 0, '09:55 AM', '10:35 AM', 1, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (132, 23, 136, 'Tuesday', 2, 451, 139, '09:55 AM', '10:35 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (133, 23, 136, 'Tuesday', 3, 457, 0, '10:35 AM', '11:15 AM', 1, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (134, 23, 136, 'Thursday', 3, 451, 139, '10:35 AM', '11:15 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (135, 23, 136, 'Wednesday', 3, 446, 145, '10:35 AM', '11:15 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (136, 23, 136, 'Monday', 3, 457, 0, '10:35 AM', '11:15 AM', 1, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (137, 23, 136, 'Friday', 3, 446, 145, '10:35 AM', '11:15 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (138, 23, 136, 'Saturday', 3, 444, 89, '10:35 AM', '11:15 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (139, 23, 136, 'Monday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (140, 23, 136, 'Tuesday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (141, 23, 136, 'Wednesday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (142, 23, 136, 'Thursday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (143, 23, 136, 'Friday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (144, 23, 136, 'Saturday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (145, 23, 136, 'Monday', 5, 447, 97, '11:40 AM', '12:20 PM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (146, 23, 136, 'Saturday', 5, 456, 126, '11:40 AM', '12:20 PM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (147, 23, 136, 'Tuesday', 5, 446, 145, '11:40 AM', '12:20 PM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (148, 23, 136, 'Thursday', 5, 453, 124, '11:40 AM', '12:20 PM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (149, 23, 136, 'Wednesday', 5, 451, 139, '11:40 AM', '12:20 PM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (150, 23, 136, 'Friday', 5, 451, 139, '11:40 AM', '12:20 PM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (151, 23, 136, 'Friday', 6, 444, 89, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (152, 23, 136, 'Monday', 6, 444, 89, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (153, 23, 136, 'Thursday', 6, 446, 145, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (154, 23, 136, 'Tuesday', 6, 447, 97, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (155, 23, 136, 'Saturday', 6, 446, 145, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (156, 23, 136, 'Wednesday', 6, 447, 97, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (157, 23, 136, 'Friday', 7, 452, 115, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (158, 23, 136, 'Wednesday', 7, 452, 115, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (159, 23, 136, 'Tuesday', 7, 444, 89, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (160, 23, 136, 'Monday', 7, 446, 145, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (161, 23, 136, 'Thursday', 7, 447, 97, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (162, 23, 136, 'Saturday', 7, 451, 139, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (163, 23, 136, 'Monday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (164, 23, 136, 'Tuesday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (165, 23, 136, 'Wednesday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (166, 23, 136, 'Thursday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (167, 23, 136, 'Friday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (168, 23, 136, 'Saturday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (169, 23, 136, 'Saturday', 9, 448, 95, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (170, 23, 136, 'Friday', 9, 449, 110, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (171, 23, 136, 'Thursday', 9, 445, 93, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (172, 23, 136, 'Monday', 9, 452, 115, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (173, 23, 136, 'Tuesday', 9, 445, 93, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (174, 23, 136, 'Wednesday', 9, 445, 93, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (175, 23, 136, 'Monday', 10, 448, 95, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (176, 23, 136, 'Thursday', 10, 452, 115, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (177, 23, 136, 'Saturday', 10, 445, 93, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (178, 23, 136, 'Tuesday', 10, 448, 95, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (179, 23, 136, 'Wednesday', 10, 446, 145, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (180, 23, 136, 'Friday', 10, 451, 139, '09:15 AM', '09:55 AM', 0, '2025-07-29 01:52:39');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (361, 23, 57, 'Tuesday', 1, 447, 97, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (362, 23, 57, 'Monday', 1, 447, 97, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (363, 23, 57, 'Friday', 1, 447, 97, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (364, 23, 57, 'Wednesday', 1, 447, 97, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (365, 23, 57, 'Thursday', 1, 447, 97, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (366, 23, 57, 'Saturday', 1, 447, 97, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (367, 23, 57, 'Friday', 2, 457, 0, '09:55', '10:35', 1, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (368, 23, 57, 'Monday', 2, 446, 145, '09:55', '10:35', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (369, 23, 57, 'Tuesday', 2, 450, 113, '09:55', '10:35', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (370, 23, 57, 'Thursday', 2, 444, 89, '09:55', '10:35', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (371, 23, 57, 'Wednesday', 2, 455, 163, '09:55', '10:35', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (372, 23, 57, 'Saturday', 2, 453, 124, '09:55', '10:35', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (373, 23, 57, 'Tuesday', 3, 446, 145, '10:35', '11:15', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (374, 23, 57, 'Monday', 3, 445, 93, '10:35', '11:15', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (375, 23, 57, 'Friday', 3, 454, 147, '10:35', '11:15', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (376, 23, 57, 'Thursday', 3, 451, 139, '10:35', '11:15', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (377, 23, 57, 'Saturday', 3, 457, 0, '10:35', '11:15', 1, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (378, 23, 57, 'Wednesday', 3, 444, 89, '10:35', '11:15', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (379, 23, 57, 'Monday', 4, -2, 0, '11:10', '11:40', 1, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (380, 23, 57, 'Tuesday', 4, -2, 0, '11:10', '11:40', 1, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (381, 23, 57, 'Wednesday', 4, -2, 0, '11:10', '11:40', 1, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (382, 23, 57, 'Thursday', 4, -2, 0, '11:10', '11:40', 1, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (383, 23, 57, 'Friday', 4, -2, 0, '11:10', '11:40', 1, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (384, 23, 57, 'Saturday', 4, -2, 0, '11:10', '11:40', 1, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (385, 23, 57, 'Monday', 5, 444, 89, '11:40', '12:20', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (386, 23, 57, 'Thursday', 5, 446, 145, '11:40', '12:20', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (387, 23, 57, 'Saturday', 5, 456, 126, '11:40', '12:20', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (388, 23, 57, 'Friday', 5, 451, 139, '11:40', '12:20', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (389, 23, 57, 'Wednesday', 5, 457, 0, '11:40', '12:20', 1, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (390, 23, 57, 'Tuesday', 5, 448, 95, '11:40', '12:20', 1, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (391, 23, 57, 'Wednesday', 6, 451, 139, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (392, 23, 57, 'Friday', 6, 444, 89, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (393, 23, 57, 'Monday', 6, 451, 139, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (394, 23, 57, 'Tuesday', 6, 451, 139, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (395, 23, 57, 'Saturday', 6, 444, 89, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (396, 23, 57, 'Thursday', 6, 448, 95, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (397, 23, 57, 'Tuesday', 7, 444, 89, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (398, 23, 57, 'Saturday', 7, 451, 139, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (399, 23, 57, 'Monday', 7, 452, 119, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (400, 23, 57, 'Wednesday', 7, 446, 145, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (401, 23, 57, 'Friday', 7, 446, 145, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (402, 23, 57, 'Thursday', 7, 449, 110, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (403, 23, 57, 'Monday', 8, -1, 0, '13:40', '13:50', 1, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (404, 23, 57, 'Tuesday', 8, -1, 0, '13:40', '13:50', 1, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (405, 23, 57, 'Wednesday', 8, -1, 0, '13:40', '13:50', 1, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (406, 23, 57, 'Thursday', 8, -1, 0, '13:40', '13:50', 1, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (407, 23, 57, 'Friday', 8, -1, 0, '13:40', '13:50', 1, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (408, 23, 57, 'Saturday', 8, -1, 0, '13:40', '13:50', 1, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (409, 23, 57, 'Friday', 9, 448, 95, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (410, 23, 57, 'Saturday', 9, 446, 145, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (411, 23, 57, 'Wednesday', 9, 452, 119, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (412, 23, 57, 'Tuesday', 9, 457, 0, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (413, 23, 57, 'Thursday', 9, 452, 119, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (414, 23, 57, 'Monday', 9, 452, 119, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (415, 23, 57, 'Friday', 10, 445, 93, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (416, 23, 57, 'Thursday', 10, 445, 93, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (417, 23, 57, 'Tuesday', 10, 457, 0, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (418, 23, 57, 'Monday', 10, 456, 126, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (419, 23, 57, 'Wednesday', 10, 451, 139, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (420, 23, 57, 'Saturday', 10, 446, 145, '09:15', '09:55', 0, '2025-07-29 16:31:57');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (481, 23, 56, 'Friday', 1, 434, 145, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (482, 23, 56, 'Thursday', 1, 434, 145, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (483, 23, 56, 'Wednesday', 1, 434, 145, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (484, 23, 56, 'Tuesday', 1, 434, 145, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (485, 23, 56, 'Saturday', 1, 434, 145, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (486, 23, 56, 'Monday', 1, 434, 145, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (487, 23, 56, 'Saturday', 2, 435, 83, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (488, 23, 56, 'Wednesday', 2, 441, 122, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (489, 23, 56, 'Friday', 2, 440, 163, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (490, 23, 56, 'Tuesday', 2, 438, 124, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (491, 23, 56, 'Thursday', 2, 387, 88, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (492, 23, 56, 'Monday', 2, 443, 122, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (493, 23, 56, 'Thursday', 3, 439, 147, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (494, 23, 56, 'Tuesday', 3, 397, 139, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (495, 23, 56, 'Saturday', 3, 442, 113, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (496, 23, 56, 'Friday', 3, 435, 83, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (497, 23, 56, 'Wednesday', 3, 443, 122, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (498, 23, 56, 'Monday', 3, 397, 139, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (499, 23, 56, 'Monday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (500, 23, 56, 'Tuesday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (501, 23, 56, 'Wednesday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (502, 23, 56, 'Thursday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (503, 23, 56, 'Friday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (504, 23, 56, 'Saturday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (505, 23, 56, 'Tuesday', 5, 435, 83, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (506, 23, 56, 'Wednesday', 5, 435, 83, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (507, 23, 56, 'Friday', 5, 387, 88, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (508, 23, 56, 'Thursday', 5, 435, 83, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (509, 23, 56, 'Saturday', 5, 397, 139, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (510, 23, 56, 'Monday', 5, 387, 88, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (511, 23, 56, 'Saturday', 6, 443, 122, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (512, 23, 56, 'Wednesday', 6, 387, 88, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (513, 23, 56, 'Monday', 6, 435, 83, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (514, 23, 56, 'Thursday', 6, 397, 139, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (515, 23, 56, 'Tuesday', 6, 443, 122, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (516, 23, 56, 'Friday', 6, 397, 139, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (517, 23, 56, 'Wednesday', 7, 397, 139, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (518, 23, 56, 'Monday', 7, 441, 122, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (519, 23, 56, 'Friday', 7, 437, 119, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (520, 23, 56, 'Tuesday', 7, 387, 88, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (521, 23, 56, 'Saturday', 7, 387, 88, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (522, 23, 56, 'Thursday', 7, 388, 93, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (523, 23, 56, 'Monday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (524, 23, 56, 'Tuesday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (525, 23, 56, 'Wednesday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (526, 23, 56, 'Thursday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (527, 23, 56, 'Friday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (528, 23, 56, 'Saturday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (529, 23, 56, 'Tuesday', 9, 437, 119, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (530, 23, 56, 'Saturday', 9, 436, 110, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (531, 23, 56, 'Friday', 9, 397, 139, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (532, 23, 56, 'Thursday', 9, 434, 145, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (533, 23, 56, 'Monday', 9, 388, 93, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (534, 23, 56, 'Wednesday', 9, 396, 95, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (535, 23, 56, 'Friday', 10, 396, 95, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (536, 23, 56, 'Tuesday', 10, 437, 119, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (537, 23, 56, 'Thursday', 10, 396, 95, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (538, 23, 56, 'Saturday', 10, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (539, 23, 56, 'Wednesday', 10, 388, 93, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (540, 23, 56, 'Monday', 10, 437, 119, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:49:34');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (541, 39, 104, 'Saturday', 1, 535, 124, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (542, 39, 104, 'Tuesday', 1, 532, 109, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (543, 39, 104, 'Monday', 1, 536, 159, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (544, 39, 104, 'Friday', 1, 532, 109, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (545, 39, 104, 'Wednesday', 1, 352, 135, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (546, 39, 104, 'Thursday', 1, 549, 0, '09:15 AM', '09:55 AM', 1, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (547, 39, 104, 'Wednesday', 2, 540, 108, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (548, 39, 104, 'Tuesday', 2, 540, 108, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (549, 39, 104, 'Monday', 2, 352, 135, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (550, 39, 104, 'Friday', 2, 352, 135, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (551, 39, 104, 'Thursday', 2, 352, 135, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (552, 39, 104, 'Saturday', 2, 352, 135, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (553, 39, 104, 'Tuesday', 3, 352, 135, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (554, 39, 104, 'Saturday', 3, 540, 108, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (555, 39, 104, 'Friday', 3, 540, 108, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (556, 39, 104, 'Monday', 3, 540, 108, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (557, 39, 104, 'Wednesday', 3, 532, 109, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (558, 39, 104, 'Thursday', 3, 532, 109, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (559, 39, 104, 'Monday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (560, 39, 104, 'Tuesday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (561, 39, 104, 'Wednesday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (562, 39, 104, 'Thursday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (563, 39, 104, 'Friday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (564, 39, 104, 'Saturday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (565, 39, 104, 'Saturday', 5, 532, 109, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (566, 39, 104, 'Thursday', 5, 540, 108, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (567, 39, 104, 'Monday', 5, 532, 109, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (568, 39, 104, 'Friday', 5, 538, 128, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (569, 39, 104, 'Tuesday', 5, 354, 116, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (570, 39, 104, 'Wednesday', 5, 534, 111, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (571, 39, 104, 'Monday', 6, 354, 116, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (572, 39, 104, 'Saturday', 6, 534, 111, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (573, 39, 104, 'Wednesday', 6, 533, 117, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (574, 39, 104, 'Thursday', 6, 539, 159, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (575, 39, 104, 'Tuesday', 6, 538, 128, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (576, 39, 104, 'Friday', 6, 533, 117, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (577, 39, 104, 'Tuesday', 7, 353, 128, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (578, 39, 104, 'Friday', 7, 537, 151, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (579, 39, 104, 'Monday', 7, 533, 117, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (580, 39, 104, 'Saturday', 7, 537, 151, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (581, 39, 104, 'Thursday', 7, 537, 151, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (582, 39, 104, 'Wednesday', 7, 353, 128, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (583, 39, 104, 'Monday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (584, 39, 104, 'Tuesday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (585, 39, 104, 'Wednesday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (586, 39, 104, 'Thursday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (587, 39, 104, 'Friday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (588, 39, 104, 'Saturday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (589, 39, 104, 'Friday', 9, 353, 128, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (590, 39, 104, 'Wednesday', 9, 354, 116, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (591, 39, 104, 'Monday', 9, 353, 128, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (592, 39, 104, 'Tuesday', 9, 533, 117, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (593, 39, 104, 'Thursday', 9, 354, 116, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (594, 39, 104, 'Saturday', 9, 353, 128, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (595, 39, 104, 'Thursday', 10, 532, 109, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (596, 39, 104, 'Saturday', 10, 354, 116, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (597, 39, 104, 'Tuesday', 10, 540, 108, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (598, 39, 104, 'Monday', 10, 540, 108, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (599, 39, 104, 'Wednesday', 10, 352, 135, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (600, 39, 104, 'Friday', 10, 352, 135, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:51:24');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (601, 38, 106, 'Saturday', 1, 524, 144, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (602, 38, 106, 'Wednesday', 1, 524, 144, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (603, 38, 106, 'Monday', 1, 524, 144, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (604, 38, 106, 'Tuesday', 1, 524, 144, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (605, 38, 106, 'Thursday', 1, 524, 144, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (606, 38, 106, 'Friday', 1, 524, 144, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (607, 38, 106, 'Friday', 2, 527, 128, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (608, 38, 106, 'Monday', 2, 519, 104, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (609, 38, 106, 'Tuesday', 2, 355, 135, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (610, 38, 106, 'Thursday', 2, 525, 124, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (611, 38, 106, 'Wednesday', 2, 523, 120, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (612, 38, 106, 'Saturday', 2, 527, 128, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (613, 38, 106, 'Thursday', 3, 355, 135, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (614, 38, 106, 'Saturday', 3, 528, 0, '10:35 AM', '11:15 AM', 1, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (615, 38, 106, 'Wednesday', 3, 528, 0, '10:35 AM', '11:15 AM', 1, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (616, 38, 106, 'Tuesday', 3, 520, 99, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (617, 38, 106, 'Monday', 3, 355, 135, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (618, 38, 106, 'Friday', 3, 355, 135, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (619, 38, 106, 'Monday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (620, 38, 106, 'Tuesday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (621, 38, 106, 'Wednesday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (622, 38, 106, 'Thursday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (623, 38, 106, 'Friday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (624, 38, 106, 'Saturday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (625, 38, 106, 'Tuesday', 5, 526, 159, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (626, 38, 106, 'Friday', 5, 526, 159, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (627, 38, 106, 'Saturday', 5, 520, 99, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (628, 38, 106, 'Thursday', 5, 520, 99, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (629, 38, 106, 'Monday', 5, 520, 99, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (630, 38, 106, 'Wednesday', 5, 520, 99, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (631, 38, 106, 'Saturday', 6, 519, 104, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (632, 38, 106, 'Wednesday', 6, 519, 104, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (633, 38, 106, 'Tuesday', 6, 519, 104, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (634, 38, 106, 'Friday', 6, 520, 99, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (635, 38, 106, 'Monday', 6, 529, 151, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (636, 38, 106, 'Thursday', 6, 519, 104, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (637, 38, 106, 'Saturday', 7, 355, 135, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (638, 38, 106, 'Friday', 7, 519, 104, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (639, 38, 106, 'Wednesday', 7, 355, 135, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (640, 38, 106, 'Monday', 7, 356, 127, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (641, 38, 106, 'Tuesday', 7, 357, 101, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (642, 38, 106, 'Thursday', 7, 522, 111, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (643, 38, 106, 'Monday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (644, 38, 106, 'Tuesday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (645, 38, 106, 'Wednesday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (646, 38, 106, 'Thursday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (647, 38, 106, 'Friday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (648, 38, 106, 'Saturday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (649, 38, 106, 'Wednesday', 9, 521, 121, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (650, 38, 106, 'Saturday', 9, 529, 151, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (651, 38, 106, 'Monday', 9, 357, 101, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (652, 38, 106, 'Thursday', 9, 357, 101, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (653, 38, 106, 'Tuesday', 9, 521, 121, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (654, 38, 106, 'Friday', 9, 356, 127, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (655, 38, 106, 'Monday', 10, 521, 121, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (656, 38, 106, 'Friday', 10, 357, 101, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (657, 38, 106, 'Saturday', 10, 356, 127, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (658, 38, 106, 'Tuesday', 10, 356, 127, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (659, 38, 106, 'Wednesday', 10, 519, 104, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (660, 38, 106, 'Thursday', 10, 355, 135, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:52:42');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (661, 0, 0, 'Monday', 1, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (662, 0, 0, 'Thursday', 1, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (663, 0, 0, 'Tuesday', 1, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (664, 0, 0, 'Saturday', 1, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (665, 0, 0, 'Wednesday', 1, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (666, 0, 0, 'Friday', 1, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (667, 0, 0, 'Thursday', 2, 0, 0, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (668, 0, 0, 'Tuesday', 2, 0, 0, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (669, 0, 0, 'Saturday', 2, 0, 0, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (670, 0, 0, 'Monday', 2, 0, 0, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (671, 0, 0, 'Friday', 2, 0, 0, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (672, 0, 0, 'Wednesday', 2, 0, 0, '09:55 AM', '10:35 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (673, 0, 0, 'Monday', 3, 0, 0, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (674, 0, 0, 'Wednesday', 3, 0, 0, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (675, 0, 0, 'Tuesday', 3, 0, 0, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (676, 0, 0, 'Friday', 3, 0, 0, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (677, 0, 0, 'Thursday', 3, 0, 0, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (678, 0, 0, 'Saturday', 3, 0, 0, '10:35 AM', '11:15 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (679, 0, 0, 'Monday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (680, 0, 0, 'Tuesday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (681, 0, 0, 'Wednesday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (682, 0, 0, 'Thursday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (683, 0, 0, 'Friday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (684, 0, 0, 'Saturday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (685, 0, 0, 'Monday', 5, 0, 0, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (686, 0, 0, 'Tuesday', 5, 0, 0, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (687, 0, 0, 'Wednesday', 5, 0, 0, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (688, 0, 0, 'Thursday', 5, 0, 0, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (689, 0, 0, 'Friday', 5, 0, 0, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (690, 0, 0, 'Saturday', 5, 0, 0, '11:40 AM', '12:20 PM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (691, 0, 0, 'Saturday', 6, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (692, 0, 0, 'Monday', 6, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (693, 0, 0, 'Tuesday', 6, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (694, 0, 0, 'Friday', 6, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (695, 0, 0, 'Thursday', 6, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (696, 0, 0, 'Wednesday', 6, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (697, 0, 0, 'Saturday', 7, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (698, 0, 0, 'Thursday', 7, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (699, 0, 0, 'Friday', 7, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (700, 0, 0, 'Monday', 7, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (701, 0, 0, 'Tuesday', 7, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (702, 0, 0, 'Wednesday', 7, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (703, 0, 0, 'Monday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (704, 0, 0, 'Tuesday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (705, 0, 0, 'Wednesday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (706, 0, 0, 'Thursday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (707, 0, 0, 'Friday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (708, 0, 0, 'Saturday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (709, 0, 0, 'Monday', 9, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (710, 0, 0, 'Friday', 9, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (711, 0, 0, 'Thursday', 9, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (712, 0, 0, 'Wednesday', 9, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (713, 0, 0, 'Tuesday', 9, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (714, 0, 0, 'Saturday', 9, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (715, 0, 0, 'Tuesday', 10, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (716, 0, 0, 'Thursday', 10, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (717, 0, 0, 'Monday', 10, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (718, 0, 0, 'Saturday', 10, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (719, 0, 0, 'Wednesday', 10, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (720, 0, 0, 'Friday', 10, 0, 0, '09:15 AM', '09:55 AM', 0, '2025-08-08 12:54:32');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (721, 24, 59, 'Thursday', 1, 429, 126, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (722, 24, 59, 'Friday', 1, 429, 126, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (723, 24, 59, 'Wednesday', 1, 429, 126, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (724, 24, 59, 'Tuesday', 1, 398, 89, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (725, 24, 59, 'Monday', 1, 398, 89, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (726, 24, 59, 'Saturday', 1, 429, 126, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (727, 24, 59, 'Thursday', 2, 426, 145, '09:55 AM', '10:35 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (728, 24, 59, 'Saturday', 2, 426, 145, '09:55 AM', '10:35 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (729, 24, 59, 'Monday', 2, 429, 126, '09:55 AM', '10:35 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (730, 24, 59, 'Tuesday', 2, 426, 145, '09:55 AM', '10:35 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (731, 24, 59, 'Friday', 2, 426, 145, '09:55 AM', '10:35 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (732, 24, 59, 'Wednesday', 2, 398, 89, '09:55 AM', '10:35 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (733, 24, 59, 'Monday', 3, 426, 145, '10:35 AM', '11:15 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (734, 24, 59, 'Wednesday', 3, 430, 96, '10:35 AM', '11:15 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (735, 24, 59, 'Friday', 3, 398, 89, '10:35 AM', '11:15 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (736, 24, 59, 'Saturday', 3, 427, 115, '10:35 AM', '11:15 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (737, 24, 59, 'Thursday', 3, 398, 89, '10:35 AM', '11:15 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (738, 24, 59, 'Tuesday', 3, 429, 126, '10:35 AM', '11:15 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (739, 24, 59, 'Monday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (740, 24, 59, 'Tuesday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (741, 24, 59, 'Wednesday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (742, 24, 59, 'Thursday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (743, 24, 59, 'Friday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (744, 24, 59, 'Saturday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (745, 24, 59, 'Wednesday', 5, 426, 145, '11:40 AM', '12:20 PM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (746, 24, 59, 'Saturday', 5, 398, 89, '11:40 AM', '12:20 PM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (747, 24, 59, 'Thursday', 5, 428, 98, '11:40 AM', '12:20 PM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (748, 24, 59, 'Monday', 5, 430, 96, '11:40 AM', '12:20 PM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (749, 24, 59, 'Tuesday', 5, 406, 102, '11:40 AM', '12:20 PM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (750, 24, 59, 'Friday', 5, 428, 98, '11:40 AM', '12:20 PM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (751, 24, 59, 'Saturday', 6, 405, 84, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (752, 24, 59, 'Thursday', 6, 432, 102, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (753, 24, 59, 'Tuesday', 6, 433, 84, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (754, 24, 59, 'Wednesday', 6, 431, 161, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (755, 24, 59, 'Monday', 6, 431, 161, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (756, 24, 59, 'Friday', 6, 405, 84, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (757, 24, 59, 'Friday', 7, 431, 161, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (758, 24, 59, 'Wednesday', 7, 428, 98, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (759, 24, 59, 'Saturday', 7, 406, 102, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (760, 24, 59, 'Thursday', 7, 406, 102, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (761, 24, 59, 'Monday', 7, 405, 84, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (762, 24, 59, 'Tuesday', 7, 407, 94, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (763, 24, 59, 'Monday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (764, 24, 59, 'Tuesday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (765, 24, 59, 'Wednesday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (766, 24, 59, 'Thursday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (767, 24, 59, 'Friday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (768, 24, 59, 'Saturday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (769, 24, 59, 'Wednesday', 9, 432, 102, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (770, 24, 59, 'Thursday', 9, 427, 115, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (771, 24, 59, 'Tuesday', 9, 427, 115, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (772, 24, 59, 'Monday', 9, 407, 94, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (773, 24, 59, 'Friday', 9, 433, 84, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (774, 24, 59, 'Saturday', 9, 407, 94, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (775, 24, 59, 'Tuesday', 10, 398, 89, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (776, 24, 59, 'Saturday', 10, 427, 115, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (777, 24, 59, 'Wednesday', 10, 407, 94, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (778, 24, 59, 'Friday', 10, 427, 115, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (779, 24, 59, 'Monday', 10, 426, 145, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (780, 24, 59, 'Thursday', 10, 426, 145, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:07:08');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (781, 39, 108, 'Friday', 1, 361, 105, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (782, 39, 108, 'Monday', 1, 361, 105, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (783, 39, 108, 'Thursday', 1, 361, 105, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (784, 39, 108, 'Tuesday', 1, 361, 105, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (785, 39, 108, 'Saturday', 1, 361, 105, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (786, 39, 108, 'Wednesday', 1, 361, 105, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (787, 39, 108, 'Thursday', 2, 362, 99, '09:55 AM', '10:35 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (788, 39, 108, 'Tuesday', 2, 517, 147, '09:55 AM', '10:35 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (789, 39, 108, 'Monday', 2, 550, 0, '09:55 AM', '10:35 AM', 1, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (790, 39, 108, 'Saturday', 2, 358, 90, '09:55 AM', '10:35 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (791, 39, 108, 'Wednesday', 2, 358, 90, '09:55 AM', '10:35 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (792, 39, 108, 'Friday', 2, 513, 0, '09:55 AM', '10:35 AM', 1, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (793, 39, 108, 'Friday', 3, 364, 144, '10:35 AM', '11:15 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (794, 39, 108, 'Tuesday', 3, 364, 144, '10:35 AM', '11:15 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (795, 39, 108, 'Monday', 3, 365, 124, '10:35 AM', '11:15 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (796, 39, 108, 'Saturday', 3, 362, 99, '10:35 AM', '11:15 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (797, 39, 108, 'Wednesday', 3, 513, 0, '10:35 AM', '11:15 AM', 1, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (798, 39, 108, 'Thursday', 3, 512, 163, '10:35 AM', '11:15 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (799, 39, 108, 'Monday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (800, 39, 108, 'Tuesday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (801, 39, 108, 'Wednesday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (802, 39, 108, 'Thursday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (803, 39, 108, 'Friday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (804, 39, 108, 'Saturday', 4, -2, 0, '11:10 AM', '11:40 AM', 1, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (805, 39, 108, 'Friday', 5, 362, 99, '11:40 AM', '12:20 PM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (806, 39, 108, 'Monday', 5, 364, 144, '11:40 AM', '12:20 PM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (807, 39, 108, 'Tuesday', 5, 362, 99, '11:40 AM', '12:20 PM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (808, 39, 108, 'Thursday', 5, 513, 0, '11:40 AM', '12:20 PM', 1, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (809, 39, 108, 'Wednesday', 5, 364, 144, '11:40 AM', '12:20 PM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (810, 39, 108, 'Saturday', 5, 513, 0, '11:40 AM', '12:20 PM', 1, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (811, 39, 108, 'Tuesday', 6, 358, 90, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (812, 39, 108, 'Monday', 6, 358, 90, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (813, 39, 108, 'Friday', 6, 358, 90, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (814, 39, 108, 'Thursday', 6, 364, 144, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (815, 39, 108, 'Saturday', 6, 364, 144, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (816, 39, 108, 'Wednesday', 6, 362, 99, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (817, 39, 108, 'Monday', 7, 362, 99, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (818, 39, 108, 'Tuesday', 7, 514, 122, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (819, 39, 108, 'Thursday', 7, 358, 90, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (820, 39, 108, 'Saturday', 7, 516, 110, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (821, 39, 108, 'Friday', 7, 359, 164, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (822, 39, 108, 'Wednesday', 7, 359, 164, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (823, 39, 108, 'Monday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (824, 39, 108, 'Tuesday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (825, 39, 108, 'Wednesday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (826, 39, 108, 'Thursday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (827, 39, 108, 'Friday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (828, 39, 108, 'Saturday', 8, -1, 0, '01:40 PM', '01:50 PM', 1, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (829, 39, 108, 'Friday', 9, 363, 121, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (830, 39, 108, 'Tuesday', 9, 359, 164, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (831, 39, 108, 'Wednesday', 9, 360, 101, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (832, 39, 108, 'Saturday', 9, 360, 101, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (833, 39, 108, 'Thursday', 9, 359, 164, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (834, 39, 108, 'Monday', 9, 514, 122, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (835, 39, 108, 'Friday', 10, 361, 105, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (836, 39, 108, 'Tuesday', 10, 360, 101, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (837, 39, 108, 'Monday', 10, 360, 101, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (838, 39, 108, 'Thursday', 10, 361, 105, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (839, 39, 108, 'Saturday', 10, 358, 90, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (840, 39, 108, 'Wednesday', 10, 358, 90, '09:15 AM', '09:55 AM', 0, '2025-08-11 11:08:14');


#
# TABLE STRUCTURE FOR: class_weekly_periods
#

DROP TABLE IF EXISTS `class_weekly_periods`;

CREATE TABLE `class_weekly_periods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_section_id` int(11) NOT NULL,
  `periods` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4;

INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (1, 47, '48', '2025-02-20 16:55:00', '2025-05-11 07:20:45');
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (2, 1, '48', '2025-05-17 19:12:19', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (3, 56, '48', '2025-06-30 15:57:04', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (4, 59, '48', '2025-07-03 16:55:50', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (5, 60, '48', '2025-07-03 16:56:02', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (6, 134, '48', '2025-07-03 16:56:15', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (7, 62, '48', '2025-07-03 16:58:49', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (8, 102, '48', '2025-07-11 13:56:33', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (9, 103, '48', '2025-07-11 13:56:45', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (10, 117, '48', '2025-07-11 13:56:50', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (11, 104, '48', '2025-07-11 13:56:59', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (12, 105, '48', '2025-07-11 13:57:03', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (13, 125, '48', '2025-07-11 13:57:07', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (14, 106, '48', '2025-07-11 13:57:19', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (15, 107, '48', '2025-07-11 13:57:23', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (16, 133, '48', '2025-07-11 13:57:27', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (17, 108, '48', '2025-07-11 13:57:43', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (18, 109, '48', '2025-07-11 13:57:49', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (19, 110, '48', '2025-07-11 13:57:54', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (20, 111, '48', '2025-07-11 13:58:15', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (21, 112, '48', '2025-07-11 13:58:19', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (22, 113, '48', '2025-07-11 13:58:26', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (23, 114, '48', '2025-07-11 13:58:53', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (24, 115, '48', '2025-07-11 13:58:56', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (25, 116, '48', '2025-07-11 13:58:59', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (26, 123, '48', '2025-07-11 13:59:06', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (27, 124, '48', '2025-07-11 13:59:11', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (28, 137, '48', '2025-07-11 13:59:16', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (29, 57, '48', '2025-07-11 13:59:28', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (30, 136, '48', '2025-07-11 13:59:32', NULL);
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (31, 63, '48', '2025-07-11 14:00:04', NULL);


#
# TABLE STRUCTURE FOR: classes
#

DROP TABLE IF EXISTS `classes`;

CREATE TABLE `classes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class` varchar(60) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `course_id` int(11) DEFAULT NULL,
  `numeric_name` varchar(50) DEFAULT NULL,
  `monthly_tution_fee` varchar(50) DEFAULT NULL,
  `admission_fee` varchar(50) DEFAULT NULL,
  `exam_fee` varchar(50) DEFAULT NULL,
  `certificate_fee` varchar(50) DEFAULT NULL,
  `note` varchar(300) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `modified_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) DEFAULT NULL,
  `modified_by` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8;

INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`, `name`, `course_id`, `numeric_name`, `monthly_tution_fee`, `admission_fee`, `exam_fee`, `certificate_fee`, `note`, `status`, `modified_at`, `created_by`, `modified_by`) VALUES (23, '8th', 'no', '2024-06-20 15:07:12', '0000-00-00 00:00:00', 'CLASS 8TH', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', NULL, NULL, NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`, `name`, `course_id`, `numeric_name`, `monthly_tution_fee`, `admission_fee`, `exam_fee`, `certificate_fee`, `note`, `status`, `modified_at`, `created_by`, `modified_by`) VALUES (24, '9th ', 'no', '2024-06-20 15:07:02', '0000-00-00 00:00:00', 'CLASS 9TH', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', NULL, NULL, NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`, `name`, `course_id`, `numeric_name`, `monthly_tution_fee`, `admission_fee`, `exam_fee`, `certificate_fee`, `note`, `status`, `modified_at`, `created_by`, `modified_by`) VALUES (25, '10th', 'no', '2024-06-20 15:06:52', '0000-00-00 00:00:00', 'STD 10TH', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1', NULL, NULL, NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`, `name`, `course_id`, `numeric_name`, `monthly_tution_fee`, `admission_fee`, `exam_fee`, `certificate_fee`, `note`, `status`, `modified_at`, `created_by`, `modified_by`) VALUES (36, '1st ', 'no', '2024-06-20 15:06:40', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`, `name`, `course_id`, `numeric_name`, `monthly_tution_fee`, `admission_fee`, `exam_fee`, `certificate_fee`, `note`, `status`, `modified_at`, `created_by`, `modified_by`) VALUES (37, '2nd ', 'no', '2024-06-20 15:06:33', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`, `name`, `course_id`, `numeric_name`, `monthly_tution_fee`, `admission_fee`, `exam_fee`, `certificate_fee`, `note`, `status`, `modified_at`, `created_by`, `modified_by`) VALUES (38, '3rd', 'no', '2024-06-20 15:06:26', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`, `name`, `course_id`, `numeric_name`, `monthly_tution_fee`, `admission_fee`, `exam_fee`, `certificate_fee`, `note`, `status`, `modified_at`, `created_by`, `modified_by`) VALUES (39, '4th ', 'no', '2024-06-20 15:06:11', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`, `name`, `course_id`, `numeric_name`, `monthly_tution_fee`, `admission_fee`, `exam_fee`, `certificate_fee`, `note`, `status`, `modified_at`, `created_by`, `modified_by`) VALUES (40, '5th ', 'no', '2024-06-20 15:06:16', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`, `name`, `course_id`, `numeric_name`, `monthly_tution_fee`, `admission_fee`, `exam_fee`, `certificate_fee`, `note`, `status`, `modified_at`, `created_by`, `modified_by`) VALUES (41, '6th ', 'no', '2024-06-20 15:05:55', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`, `name`, `course_id`, `numeric_name`, `monthly_tution_fee`, `admission_fee`, `exam_fee`, `certificate_fee`, `note`, `status`, `modified_at`, `created_by`, `modified_by`) VALUES (43, '7TH ', 'no', '2024-11-19 12:34:37', '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(255) NOT NULL,
  `source` varchar(255) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(15) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `description` text NOT NULL,
  `action_taken` varchar(200) NOT NULL,
  `assigned` varchar(50) NOT NULL,
  `note` text NOT NULL,
  `image` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: conference_sections
#

DROP TABLE IF EXISTS `conference_sections`;

CREATE TABLE `conference_sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) DEFAULT NULL,
  `cls_section_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `conference_sections_ibfk_1` (`conference_id`),
  KEY `conference_sections_ibfk_2` (`cls_section_id`),
  CONSTRAINT `conference_sections_ibfk_1` FOREIGN KEY (`conference_id`) REFERENCES `conferences` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conference_sections_ibfk_2` FOREIGN KEY (`cls_section_id`) REFERENCES `class_sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: conference_staff
#

DROP TABLE IF EXISTS `conference_staff`;

CREATE TABLE `conference_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `conference_staff_ibfk_1` (`conference_id`),
  KEY `conference_staff_ibfk_2` (`staff_id`),
  CONSTRAINT `conference_staff_ibfk_1` FOREIGN KEY (`conference_id`) REFERENCES `conferences` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conference_staff_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: conferences
#

DROP TABLE IF EXISTS `conferences`;

CREATE TABLE `conferences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purpose` varchar(20) NOT NULL DEFAULT 'class',
  `staff_id` int(11) DEFAULT NULL,
  `created_id` int(10) NOT NULL,
  `title` text,
  `date` datetime DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `password` varchar(50) DEFAULT NULL,
  `subject` varchar(50) DEFAULT NULL,
  `class_id` int(10) DEFAULT NULL,
  `section_id` int(10) DEFAULT NULL,
  `session_id` int(10) NOT NULL,
  `host_video` int(1) NOT NULL DEFAULT '1',
  `client_video` int(1) NOT NULL DEFAULT '1',
  `description` varchar(50) DEFAULT NULL,
  `timezone` varchar(100) DEFAULT NULL,
  `return_response` text,
  `api_type` varchar(30) NOT NULL,
  `status` int(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `conferences_ibfk_1` (`staff_id`),
  KEY `conferences_ibfk_2` (`created_id`),
  CONSTRAINT `conferences_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_2` FOREIGN KEY (`created_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: conferences_history
#

DROP TABLE IF EXISTS `conferences_history`;

CREATE TABLE `conferences_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `total_hit` int(10) NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `conferences_history_ibfk_1` (`conference_id`),
  KEY `conferences_history_ibfk_2` (`staff_id`),
  KEY `conferences_history_ibfk_3` (`student_id`),
  CONSTRAINT `conferences_history_ibfk_1` FOREIGN KEY (`conference_id`) REFERENCES `conferences` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_history_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_history_ibfk_3` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: content_for
#

DROP TABLE IF EXISTS `content_for`;

CREATE TABLE `content_for` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(50) DEFAULT NULL,
  `content_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `content_for_ibfk_1` FOREIGN KEY (`content_id`) REFERENCES `contents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_3` FOREIGN KEY (`content_id`) REFERENCES `contents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_4` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: content_types
#

DROP TABLE IF EXISTS `content_types`;

CREATE TABLE `content_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `description` text,
  `is_active` int(11) DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `content_types` (`id`, `name`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'attu', '', 1, '2025-06-12 17:43:10', '2025-06-12 17:43:10');


#
# TABLE STRUCTURE FOR: contents
#

DROP TABLE IF EXISTS `contents`;

CREATE TABLE `contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `is_public` varchar(10) DEFAULT 'No',
  `class_id` int(11) DEFAULT NULL,
  `cls_sec_id` int(11) DEFAULT NULL,
  `file` varchar(250) DEFAULT NULL,
  `date` date NOT NULL,
  `note` text,
  `is_active` varchar(255) DEFAULT 'no',
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `class_id` (`class_id`),
  KEY `cls_sec_id` (`cls_sec_id`),
  CONSTRAINT `contents_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contents_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contents_ibfk_3` FOREIGN KEY (`cls_sec_id`) REFERENCES `class_sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: course_category
#

DROP TABLE IF EXISTS `course_category`;

CREATE TABLE `course_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(255) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `is_active` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: course_lesson_quiz_order
#

DROP TABLE IF EXISTS `course_lesson_quiz_order`;

CREATE TABLE `course_lesson_quiz_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(10) DEFAULT NULL,
  `course_section_id` int(11) DEFAULT NULL,
  `lesson_quiz_id` int(11) DEFAULT NULL,
  `order` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `section_id` (`course_section_id`),
  CONSTRAINT `course_lesson_quiz_order_ibfk_1` FOREIGN KEY (`course_section_id`) REFERENCES `online_course_section` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: course_progress
#

DROP TABLE IF EXISTS `course_progress`;

CREATE TABLE `course_progress` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) DEFAULT NULL,
  `guest_id` int(1) DEFAULT NULL,
  `course_id` int(11) DEFAULT NULL,
  `course_section_id` int(11) DEFAULT NULL,
  `lesson_quiz_id` int(11) DEFAULT NULL,
  `lesson_quiz_type` int(11) DEFAULT NULL COMMENT '1 lesson, 2 quiz, 3 assignment,4 exam',
  PRIMARY KEY (`id`),
  KEY `course_id` (`course_id`),
  KEY `student_id` (`student_id`),
  KEY `course_section_id` (`course_section_id`),
  CONSTRAINT `course_progress_ibfk_1` FOREIGN KEY (`course_id`) REFERENCES `online_courses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `course_progress_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `course_progress_ibfk_3` FOREIGN KEY (`course_section_id`) REFERENCES `online_course_section` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: course_quiz_answer
#

DROP TABLE IF EXISTS `course_quiz_answer`;

CREATE TABLE `course_quiz_answer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) DEFAULT NULL,
  `guest_id` int(11) DEFAULT NULL,
  `course_quiz_id` int(11) DEFAULT NULL,
  `course_quiz_question_id` int(11) DEFAULT NULL,
  `answer` varchar(255) DEFAULT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `quiz_id` (`course_quiz_id`),
  KEY `question_id` (`course_quiz_question_id`),
  CONSTRAINT `course_quiz_answer_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `course_quiz_answer_ibfk_2` FOREIGN KEY (`course_quiz_id`) REFERENCES `online_course_quiz` (`id`) ON DELETE CASCADE,
  CONSTRAINT `course_quiz_answer_ibfk_3` FOREIGN KEY (`course_quiz_question_id`) REFERENCES `course_quiz_question` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: course_quiz_question
#

DROP TABLE IF EXISTS `course_quiz_question`;

CREATE TABLE `course_quiz_question` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_quiz_id` int(11) DEFAULT NULL,
  `question` text,
  `option_1` varchar(255) DEFAULT NULL,
  `option_2` varchar(255) DEFAULT NULL,
  `option_3` varchar(255) DEFAULT NULL,
  `option_4` varchar(255) DEFAULT NULL,
  `option_5` varchar(255) DEFAULT NULL,
  `correct_answer` varchar(255) DEFAULT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `course_quiz_id` (`course_quiz_id`),
  CONSTRAINT `course_quiz_question_ibfk_1` FOREIGN KEY (`course_quiz_id`) REFERENCES `online_course_quiz` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: course_rating
#

DROP TABLE IF EXISTS `course_rating`;

CREATE TABLE `course_rating` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) DEFAULT NULL,
  `guest_id` int(11) DEFAULT NULL,
  `course_id` int(11) NOT NULL,
  `rating` varchar(200) NOT NULL,
  `review` text NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_course_id` (`course_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: courses
#

DROP TABLE IF EXISTS `courses`;

CREATE TABLE `courses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_name` varchar(255) NOT NULL,
  `course_description` varchar(255) DEFAULT NULL,
  `course_status` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

INSERT INTO `courses` (`id`, `course_name`, `course_description`, `course_status`, `created_at`, `updated_at`) VALUES (1, 'Test Course', 'An introductory course to programming using Python.', '1', '2024-06-23 11:10:16', '2024-12-24 19:50:25');
INSERT INTO `courses` (`id`, `course_name`, `course_description`, `course_status`, `created_at`, `updated_at`) VALUES (2, 'Data Structures and Algorithms', 'A course on data structures and algorithms in computer science.', '1', '2024-06-23 11:10:16', NULL);
INSERT INTO `courses` (`id`, `course_name`, `course_description`, `course_status`, `created_at`, `updated_at`) VALUES (3, 'Test Course', 'Test Description', '1', '2024-06-23 18:54:12', NULL);
INSERT INTO `courses` (`id`, `course_name`, `course_description`, `course_status`, `created_at`, `updated_at`) VALUES (4, 'Testing01', 'test02', '0', '2024-06-29 17:52:39', '2024-06-29 17:53:14');


#
# TABLE STRUCTURE FOR: cumulative_fine
#

DROP TABLE IF EXISTS `cumulative_fine`;

CREATE TABLE `cumulative_fine` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `overdue_day` int(11) NOT NULL,
  `fine_amount` float(10,2) NOT NULL,
  `fee_groups_feetype_id` int(11) NOT NULL,
  `fee_session_group_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: currencies
#

DROP TABLE IF EXISTS `currencies`;

CREATE TABLE `currencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `short_name` varchar(100) DEFAULT NULL,
  `symbol` varchar(10) DEFAULT NULL,
  `base_price` varchar(10) NOT NULL DEFAULT '1',
  `is_active` int(11) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=180 DEFAULT CHARSET=utf8;

INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'AED', 'AED', 'AEDf', '1', 1, '2022-12-30 11:49:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'AFN', 'AFN', '؋', '1', 0, '2022-12-30 11:49:19', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'ALL', 'ALL', 'ALL', '1', 0, '2022-12-30 11:49:22', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'AMD', 'AMD', 'AMD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'ANG', 'ANG', 'ANG', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'AOA', 'AOA', 'AOA', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'ARS', 'ARS', 'ARS', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'AUD', 'AUD', 'AUD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'AWG', 'AWG', 'AWG', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'AZN', 'AZN', 'AZN', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'BAM', 'BAM', 'BAM', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (12, 'BAM', 'BAM', 'BAM', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'BDT', 'BDT', 'BDT', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'BGN', 'BGN', 'BGN', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'BHD', 'BHD', 'BHD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'BIF', 'BIF', 'BIF', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'BMD', 'BMD', 'BMD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'BND', 'BND', 'BND', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'BOB', 'BOB', 'BOB', '1', 0, '2022-12-30 11:49:29', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (20, 'BOV', 'BOV', 'BOV', '1', 0, '2022-12-30 11:49:38', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'BRL', 'BRL', 'BRL', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'BSD', 'BSD', 'BSD', '1', 0, '2022-12-30 11:49:40', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'BTN', 'BTN', 'BTN', '1', 0, '2022-12-30 11:49:42', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'BWP', 'BWP', 'BWP', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'BYN', 'BYN', 'BYN', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'BYR', 'BYR', 'BYR', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'BZD', 'BZD', 'BZD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'CAD', 'CAD', 'CAD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'CDF', 'CDF', 'CDF', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'CHE', 'CHE', 'CHE', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'CHF', 'CHF', 'CHF', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (32, 'CHW', 'CHW', 'CHW', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'CLF', 'CLF', 'CLF', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'CLP', 'CLP', 'CLP', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (35, 'CNY', 'CNY', 'CNY', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'COP', 'COP', 'COP', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'COU', 'COU', 'COU', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'CRC', 'CRC', 'CRC', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'CUC', 'CUC', 'CUC', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'CUP', 'CUP', 'CUP', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'CVE', 'CVE', 'CVE', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (42, 'CZK', 'CZK', 'CZK', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'DJF', 'DJF', 'DJF', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'DKK', 'DKK', 'DKK', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'DOP', 'DOP', 'DOP', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'DZD', 'DZD', 'DZD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'EGP', 'EGP', 'EGP', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'ERN', 'ERN', 'ERN', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'ETB', 'ETB', 'ETB', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (50, 'EUR', 'EUR', '€', '1', 0, '2022-12-30 11:50:25', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'FJD', 'FJD', 'FJD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'FKP', 'FKP', 'FKP', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'GBP', 'GBP', '£', '1', 0, '2022-12-30 11:50:29', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'GEL', 'GEL', 'GEL', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'GHS', 'GHS', 'GHS', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (56, 'GIP', 'GIP', 'GIP', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'GMD', 'GMD', 'GMD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (58, 'GNF', 'GNF', 'GNF', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'GTQ', 'GTQ', 'GTQ', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'GYD', 'GYD', 'GYD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'HKD', 'HKD', 'HKD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'HNL', 'HNL', 'HNL', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (63, 'HRK', 'HRK', 'HRK', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'HTG', 'HTG', 'HTG', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'HUF', 'HUF', 'HUF', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'IDR', 'IDR', 'IDR', '1', 0, '2022-12-30 11:50:34', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'ILS', 'ILS', 'ILS', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'INR', 'INR', '₹', '1', 1, '2022-12-30 11:50:37', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (69, 'IQD', 'IQD', 'IQD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'IRR', 'IRR', 'IRR', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'ISK', 'ISK', 'ISK', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'JMD', 'JMD', 'JMD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (73, 'JOD', 'JOD', 'JOD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'JPY', 'JPY', 'JPY', '1', 0, '2022-12-30 11:49:56', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'KES', 'KES', 'KES', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (76, 'KGS', 'KGS', 'KGS', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'KHR', 'KHR', 'KHR', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (78, 'KMF', 'KMF', 'KMF', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (79, 'KPW', 'KPW', 'KPW', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (80, 'KRW', 'KRW', 'KRW', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (81, 'KWD', 'KWD', 'KWD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (82, 'KYD', 'KYD', 'KYD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (83, 'KZT', 'KZT', 'KZT', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (84, 'LAK', 'LAK', 'LAK', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (85, 'LBP', 'LBP', 'LBP', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (86, 'LKR', 'LKR', 'LKR', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (87, 'LRD', 'LRD', 'LRD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (88, 'LSL', 'LSL', 'LSL', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (89, 'LYD', 'LYD', 'LYD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (90, 'MAD', 'MAD', 'MAD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (91, 'MDL', 'MDL', 'MDL', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (92, 'MGA', 'MGA', 'MGA', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (93, 'MKD', 'MKD', 'MKD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (94, 'MMK', 'MMK', 'MMK', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (95, 'MNT', 'MNT', 'MNT', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (96, 'MOP', 'MOP', 'MOP', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (97, 'MRO', 'MRO', 'MRO', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (98, 'MUR', 'MUR', 'MUR', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (99, 'MVR', 'MVR', 'MVR', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (100, 'MWK', 'MWK', 'MWK', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (101, 'MXN', 'MXN', 'MXN', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (102, 'MXV', 'MXV', 'MXV', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (103, 'MYR', 'MYR', 'MYR', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (104, 'MZN', 'MZN', 'MZN', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (105, 'NAD', 'NAD', 'NAD', '1', 0, '2022-07-30 15:02:37', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (106, 'NGN', 'NGN', 'NGN', '1', 0, '2022-12-30 11:50:42', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (107, 'NIO', 'NIO', 'NIO', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (108, 'NOK', 'NOK', 'NOK', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (109, 'NPR', 'NPR', 'NPR', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (110, 'NZD', 'NZD', 'NZD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (111, 'OMR', 'OMR', 'OMR', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (112, 'PAB', 'PAB', 'PAB', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (113, 'PEN', 'PEN', 'PEN', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (114, 'PGK', 'PGK', 'PGK', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (115, 'PHP', 'PHP', 'PHP', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (116, 'PKR', 'PKR', 'PKR', '1', 0, '2022-12-30 11:50:19', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (117, 'PLN', 'PLN', 'PLN', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (118, 'PYG', 'PYG', 'PYG', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (119, 'QAR', 'QAR', 'QAR', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (120, 'RON', 'RON', 'RON', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (121, 'RSD', 'RSD', 'RSD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (122, 'RUB', 'RUB', 'RUB', '1', 0, '2022-12-30 11:50:16', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (123, 'RWF', 'RWF', 'RWF', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (124, 'SAR', 'SAR', 'SAR', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (125, 'SBD', 'SBD', 'SBD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (126, 'SCR', 'SCR', 'SCR', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (127, 'SDG', 'SDG', 'SDG', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (128, 'SEK', 'SEK', 'SEK', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (129, 'SGD', 'SGD', 'SGD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (130, 'SHP', 'SHP', 'SHP', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (131, 'SLL', 'SLL', 'SLL', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (132, 'SOS', 'SOS', 'SOS', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (133, 'SRD', 'SRD', 'SRD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (134, 'SSP', 'SSP', 'SSP', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (135, 'STD', 'STD', 'STD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (136, 'SVC', 'SVC', 'SVC', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (137, 'SYP', 'SYP', 'SYP', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (138, 'SZL', 'SZL', 'SZL', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (139, 'THB', 'THB', 'THB', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (140, 'TJS', 'TJS', 'TJS', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (141, 'TMT', 'TMT', 'TMT', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (142, 'TND', 'TND', 'TND', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (143, 'TOP', 'TOP', 'TOP', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (144, 'TRY', 'TRY', 'TRY', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (145, 'TTD', 'TTD', 'TTD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (146, 'TWD', 'TWD', 'TWD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (147, 'TZS', 'TZS', 'TZS', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (148, 'UAH', 'UAH', 'UAH', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (149, 'UGX', 'UGX', 'UGX', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (150, 'USD', 'USD', '$', '1', 1, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (151, 'USN', 'USN', 'USN', '1', 0, '2022-12-30 11:50:03', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (152, 'UYI', 'UYI', 'UYI', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (153, 'UYU', 'UYU', 'UYU', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (154, 'UZS', 'UZS', 'UZS', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (155, 'VEF', 'VEF', 'VEF', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (156, 'VND', 'VND', 'VND', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (157, 'VUV', 'VUV', 'VUV', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (158, 'WST', 'WST', 'WST', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (159, 'XAF', 'XAF', 'XAF', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (160, 'XAG', 'XAG', 'XAG', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (161, 'XAU', 'XAU', 'XAU', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (162, 'XBA', 'XBA', 'XBA', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (163, 'XBB', 'XBB', 'XBB', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (164, 'XBC', 'XBC', 'XBC', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (165, 'XBD', 'XBD', 'XBD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (166, 'XCD', 'XCD', 'XCD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (167, 'XDR', 'XDR', 'XDR', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (168, 'XOF', 'XOF', 'XOF', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (169, 'XPD', 'XPD', 'XPD', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (170, 'XPF', 'XPF', 'XPF', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (171, 'XPT', 'XPT', 'XPT', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (172, 'XSU', 'XSU', 'XSU', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (173, 'XTS', 'XTS', 'XTS', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (174, 'XUA', 'XUA', 'XUA', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (175, 'XXX', 'XXX', 'XXX', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (176, 'YER', 'YER', 'YER', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (177, 'ZAR', 'ZAR', 'ZAR', '1', 0, '2022-12-30 11:50:07', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (178, 'ZMW', 'ZMW', 'ZMW', '1', 0, '2022-07-30 13:04:00', '2025-04-10 03:22:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (179, 'ZWL', 'ZWL', 'ZWL', '1', 0, '2022-07-22 16:25:15', '2025-04-10 03:22:05');


#
# TABLE STRUCTURE FOR: custom_field_values
#

DROP TABLE IF EXISTS `custom_field_values`;

CREATE TABLE `custom_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `belong_table_id` int(11) DEFAULT NULL,
  `custom_field_id` int(11) DEFAULT NULL,
  `field_value` varchar(500) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`),
  KEY `idx_belong_table_id` (`belong_table_id`),
  KEY `idx_field_value` (`field_value`),
  KEY `belong_table_id` (`belong_table_id`),
  KEY `field_value` (`field_value`),
  CONSTRAINT `custom_field_values_ibfk_1` FOREIGN KEY (`custom_field_id`) REFERENCES `custom_fields` (`id`) ON DELETE CASCADE,
  CONSTRAINT `custom_field_values_ibfk_2` FOREIGN KEY (`custom_field_id`) REFERENCES `custom_fields` (`id`) ON DELETE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: custom_fields
#

DROP TABLE IF EXISTS `custom_fields`;

CREATE TABLE `custom_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `belong_to` varchar(100) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `bs_column` int(11) DEFAULT NULL,
  `validation` int(11) DEFAULT '0',
  `field_values` text,
  `show_table` varchar(100) DEFAULT NULL,
  `visible_on_table` int(11) NOT NULL,
  `weight` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`),
  KEY `idx_belong_to` (`belong_to`),
  KEY `idx_type` (`type`),
  KEY `idx_visible_on_table` (`visible_on_table`),
  KEY `idx_weight` (`weight`),
  KEY `name` (`name`),
  KEY `belong_to` (`belong_to`),
  KEY `type` (`type`),
  KEY `visible_on_table` (`visible_on_table`),
  KEY `weight` (`weight`),
  KEY `field_values` (`field_values`(1024)),
  FULLTEXT KEY `idx_field_values` (`field_values`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: daily_assignment
#

DROP TABLE IF EXISTS `daily_assignment`;

CREATE TABLE `daily_assignment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_session_id` int(11) NOT NULL,
  `subject_group_subject_id` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `attachment` varchar(255) DEFAULT NULL,
  `evaluated_by` int(11) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `evaluation_date` date DEFAULT NULL,
  `remark` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `student_session_id` (`student_session_id`),
  KEY `evaluated_by` (`evaluated_by`),
  KEY `subject_group_subject_id` (`subject_group_subject_id`),
  CONSTRAINT `daily_assignment_ibfk_1` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE,
  CONSTRAINT `daily_assignment_ibfk_2` FOREIGN KEY (`evaluated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `daily_assignment_ibfk_3` FOREIGN KEY (`subject_group_subject_id`) REFERENCES `subject_group_subjects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `daily_assignment_ibfk_4` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE,
  CONSTRAINT `daily_assignment_ibfk_5` FOREIGN KEY (`evaluated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `daily_assignment_ibfk_6` FOREIGN KEY (`subject_group_subject_id`) REFERENCES `subject_group_subjects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: department
#

DROP TABLE IF EXISTS `department`;

CREATE TABLE `department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(200) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (1, 'Non-Teaching Staff', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (2, 'Teaching Staff', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (3, 'Principal', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (4, 'Peon', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (5, 'Vice Principal', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (6, 'Spervisor', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (7, 'Driver', 'yes');


#
# TABLE STRUCTURE FOR: disable_reason
#

DROP TABLE IF EXISTS `disable_reason`;

CREATE TABLE `disable_reason` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `disable_reason` (`id`, `reason`, `created_at`, `updated_at`) VALUES (1, 'Regular Absent', '2025-04-18 20:41:52', '2025-04-18 20:41:52');
INSERT INTO `disable_reason` (`id`, `reason`, `created_at`, `updated_at`) VALUES (2, 'Fees Not Paid', '2025-04-18 20:42:08', '2025-04-18 20:42:08');
INSERT INTO `disable_reason` (`id`, `reason`, `created_at`, `updated_at`) VALUES (4, 'Leaving Certificate Generated', '2025-06-24 12:23:26', NULL);
INSERT INTO `disable_reason` (`id`, `reason`, `created_at`, `updated_at`) VALUES (5, 'Nor Coming to School', '2025-06-24 12:23:42', NULL);


#
# TABLE STRUCTURE FOR: dispatch_receive
#

DROP TABLE IF EXISTS `dispatch_receive`;

CREATE TABLE `dispatch_receive` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(50) NOT NULL,
  `to_title` varchar(100) NOT NULL,
  `type` varchar(10) NOT NULL,
  `address` varchar(500) NOT NULL,
  `note` varchar(500) NOT NULL,
  `from_title` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `image` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `type`, `address`, `note`, `from_title`, `date`, `image`, `created_at`, `updated_at`) VALUES (1, '23412', 'School board office	', 'dispatch', '', '', 'school board office	', '2025-04-24', NULL, '2025-04-18 19:42:52', '2025-04-18 19:42:52');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `type`, `address`, `note`, `from_title`, `date`, `image`, `created_at`, `updated_at`) VALUES (2, '23423', 'Johnson Book seller	', 'dispatch', '', '', 'Johnson Book seller	', '2025-04-25', NULL, '2025-04-18 19:43:28', '2025-04-18 19:43:28');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `type`, `address`, `note`, `from_title`, `date`, `image`, `created_at`, `updated_at`) VALUES (3, '454623', 'Fees Discussion	', 'dispatch', '', '', 'Fees Discussion	', '2025-04-20', NULL, '2025-04-18 19:44:08', '2025-04-18 19:44:08');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `type`, `address`, `note`, `from_title`, `date`, `image`, `created_at`, `updated_at`) VALUES (4, '34522', 'Food Deliver Instruction	', 'dispatch', '', '', 'Food Deliver Instruction	', '2025-04-18', NULL, '2025-04-18 19:44:54', '2025-04-18 19:44:54');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `type`, `address`, `note`, `from_title`, `date`, `image`, `created_at`, `updated_at`) VALUES (5, '78333', 'National Cadet Corps	', 'receive', '', '', 'National Cadet Corps	', '2025-04-30', NULL, '2025-04-18 19:45:30', '2025-04-18 19:45:30');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `type`, `address`, `note`, `from_title`, `date`, `image`, `created_at`, `updated_at`) VALUES (6, '68734', 'Books deliver In School	', 'receive', '', '', 'Books deliver In School	', '2025-04-25', NULL, '2025-04-18 19:46:05', '2025-04-18 19:46:05');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `type`, `address`, `note`, `from_title`, `date`, `image`, `created_at`, `updated_at`) VALUES (7, '89066', 'Fees Discussion	', 'receive', '', '', 'Fees Discussion	', '2025-04-18', NULL, '2025-04-18 19:46:38', '2025-04-18 19:46:38');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `type`, `address`, `note`, `from_title`, `date`, `image`, `created_at`, `updated_at`) VALUES (8, '45623', 'Food Deliver Instruction	', 'receive', '', '', 'Food Deliver Instruction	', '2025-04-18', NULL, '2025-04-18 19:47:08', '2025-04-18 19:47:08');


#
# TABLE STRUCTURE FOR: duplicate_tc_request
#

DROP TABLE IF EXISTS `duplicate_tc_request`;

CREATE TABLE `duplicate_tc_request` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `request_by` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `approved_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `duplicate_tc_request` (`id`, `student_id`, `request_by`, `status`, `approved_by`, `created_at`, `updated_at`) VALUES (1, 1226, 1, 1, 1, '2025-08-06 16:20:06', '2025-08-07 02:19:56');
INSERT INTO `duplicate_tc_request` (`id`, `student_id`, `request_by`, `status`, `approved_by`, `created_at`, `updated_at`) VALUES (2, 1499, 1, 1, 1, '2025-09-30 11:59:46', '2025-09-30 11:59:57');


#
# TABLE STRUCTURE FOR: email_attachments
#

DROP TABLE IF EXISTS `email_attachments`;

CREATE TABLE `email_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message_id` int(11) NOT NULL,
  `directory` varchar(255) NOT NULL,
  `attachment` varchar(255) NOT NULL,
  `attachment_name` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `message_id` (`message_id`),
  CONSTRAINT `email_attachments_ibfk_1` FOREIGN KEY (`message_id`) REFERENCES `messages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email_type` varchar(100) DEFAULT NULL,
  `smtp_server` varchar(100) DEFAULT NULL,
  `smtp_port` varchar(100) DEFAULT NULL,
  `smtp_email` varchar(255) DEFAULT NULL,
  `smtp_username` varchar(100) DEFAULT NULL,
  `smtp_password` varchar(100) DEFAULT NULL,
  `ssl_tls` varchar(100) DEFAULT NULL,
  `smtp_auth` varchar(10) NOT NULL,
  `api_key` varchar(255) DEFAULT NULL,
  `api_secret` varchar(255) DEFAULT NULL,
  `region` varchar(255) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `email_config` (`id`, `email_type`, `smtp_server`, `smtp_port`, `smtp_email`, `smtp_username`, `smtp_password`, `ssl_tls`, `smtp_auth`, `api_key`, `api_secret`, `region`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'sendmail', NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, 'yes', '2020-02-28 19:16:03', '2025-04-10 03:22:05');


#
# TABLE STRUCTURE FOR: email_template
#

DROP TABLE IF EXISTS `email_template`;

CREATE TABLE `email_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `message` text NOT NULL,
  `created_at` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: email_template_attachment
#

DROP TABLE IF EXISTS `email_template_attachment`;

CREATE TABLE `email_template_attachment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email_template_id` int(11) NOT NULL,
  `attachment` varchar(100) NOT NULL,
  `attachment_name` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: enquiry
#

DROP TABLE IF EXISTS `enquiry`;

CREATE TABLE `enquiry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(20) NOT NULL,
  `address` text NOT NULL,
  `reference` varchar(20) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(500) NOT NULL,
  `follow_up_date` date NOT NULL,
  `note` text NOT NULL,
  `source` varchar(50) NOT NULL,
  `email` varchar(50) DEFAULT NULL,
  `assigned` int(11) DEFAULT NULL,
  `class_id` int(11) DEFAULT NULL,
  `no_of_child` varchar(11) DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `assigned` (`assigned`),
  KEY `enquiry_ibfk_4` (`class_id`),
  CONSTRAINT `enquiry_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `enquiry_ibfk_3` FOREIGN KEY (`assigned`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `enquiry_ibfk_4` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: enquiry_type
#

DROP TABLE IF EXISTS `enquiry_type`;

CREATE TABLE `enquiry_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enquiry_type` varchar(100) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: event_certificates
#

DROP TABLE IF EXISTS `event_certificates`;

CREATE TABLE `event_certificates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `certificate_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `event_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `student_id` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `class_id` int(11) DEFAULT NULL,
  `section_id` int(11) DEFAULT NULL,
  `position` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `session_id` int(11) DEFAULT NULL,
  `date` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `event_certificates` (`id`, `certificate_name`, `event_name`, `student_id`, `class_id`, `section_id`, `position`, `session_id`, `date`) VALUES (7, 'ANNUAL SPORTS MEET', 'Long Jump', '2676', 23, 3, '1', 28, '');
INSERT INTO `event_certificates` (`id`, `certificate_name`, `event_name`, `student_id`, `class_id`, `section_id`, `position`, `session_id`, `date`) VALUES (8, 'ANNUAL SPORTS MEET', 'Long Jump', '2675', 23, 3, '1', 28, '');


#
# TABLE STRUCTURE FOR: events
#

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_title` varchar(200) NOT NULL,
  `event_description` text NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `event_type` varchar(100) NOT NULL,
  `event_color` varchar(200) NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `role_id` int(11) DEFAULT NULL,
  `is_active` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `events_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'summer', '', '2025-06-04 05:30:00', '2025-06-04 05:30:00', 'protected', '#337ab7', '1', NULL, '', '2025-06-15 12:58:53', '2025-06-15 12:58:53');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'software demo', '', '2025-07-02 00:00:00', '2025-07-02 00:00:00', 'task', '#000', '1', 7, 'yes', '2025-07-02 10:47:29', NULL);


#
# TABLE STRUCTURE FOR: exam_class_subjects_component
#

DROP TABLE IF EXISTS `exam_class_subjects_component`;

CREATE TABLE `exam_class_subjects_component` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `session_id` int(10) DEFAULT NULL,
  `class_id` int(10) DEFAULT NULL,
  `subject_id` int(10) DEFAULT NULL,
  `mdtid` int(5) DEFAULT NULL,
  `mdcid` text,
  `mark` int(10) DEFAULT NULL,
  `remark_language` varchar(50) DEFAULT NULL COMMENT 'Eng/Mar/Hindi',
  `status` int(5) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

INSERT INTO `exam_class_subjects_component` (`id`, `session_id`, `class_id`, `subject_id`, `mdtid`, `mdcid`, `mark`, `remark_language`, `status`, `created_at`, `updated_at`) VALUES (10, NULL, 20, 2, NULL, '[{\"mdtid\":1,\"mdcid\":\"1\",\"mark\":\"25\"},{\"mdtid\":1,\"mdcid\":\"2\",\"mark\":\"25\"},{\"mdtid\":1,\"mdcid\":\"7\",\"mark\":\"\"},{\"mdtid\":3,\"mdcid\":\"4\",\"mark\":\"30\"},{\"mdtid\":3,\"mdcid\":\"5\",\"mark\":\"20\"},{\"mdtid\":3,\"mdcid\":\"6\",\"mark\":\"\"}]', NULL, 'mr', 3, '2024-01-21 15:08:41', NULL);
INSERT INTO `exam_class_subjects_component` (`id`, `session_id`, `class_id`, `subject_id`, `mdtid`, `mdcid`, `mark`, `remark_language`, `status`, `created_at`, `updated_at`) VALUES (9, NULL, 20, 1, NULL, '[{\"mdtid\":1,\"mdcid\":\"1\",\"mark\":\"20\"},{\"mdtid\":1,\"mdcid\":\"2\",\"mark\":\"30\"},{\"mdtid\":1,\"mdcid\":\"7\",\"mark\":\"\"},{\"mdtid\":3,\"mdcid\":\"4\",\"mark\":\"30\"},{\"mdtid\":3,\"mdcid\":\"5\",\"mark\":\"20\"},{\"mdtid\":3,\"mdcid\":\"6\",\"mark\":\"\"}]', NULL, 'eng', 3, '2024-01-19 00:26:53', NULL);
INSERT INTO `exam_class_subjects_component` (`id`, `session_id`, `class_id`, `subject_id`, `mdtid`, `mdcid`, `mark`, `remark_language`, `status`, `created_at`, `updated_at`) VALUES (11, NULL, 20, 6, NULL, '[{\"mdtid\":1,\"mdcid\":\"1\",\"mark\":\"0\"},{\"mdtid\":1,\"mdcid\":\"2\",\"mark\":\"0\"},{\"mdtid\":3,\"mdcid\":\"4\",\"mark\":\"0\"},{\"mdtid\":3,\"mdcid\":\"5\",\"mark\":\"0\"},{\"mdtid\":3,\"mdcid\":\"6\",\"mark\":\"0\"}]', NULL, 'hi', 3, '2024-01-21 15:17:49', NULL);
INSERT INTO `exam_class_subjects_component` (`id`, `session_id`, `class_id`, `subject_id`, `mdtid`, `mdcid`, `mark`, `remark_language`, `status`, `created_at`, `updated_at`) VALUES (12, NULL, 20, 3, NULL, '[{\"mdtid\":1,\"mdcid\":\"1\",\"mark\":\"10\"},{\"mdtid\":1,\"mdcid\":\"2\",\"mark\":\"30\"},{\"mdtid\":1,\"mdcid\":\"7\",\"mark\":\"\"},{\"mdtid\":3,\"mdcid\":\"4\",\"mark\":\"20\"},{\"mdtid\":3,\"mdcid\":\"5\",\"mark\":\"20\"},{\"mdtid\":3,\"mdcid\":\"6\",\"mark\":\"20\"}]', NULL, 'eng', 3, '2024-01-27 00:08:11', NULL);
INSERT INTO `exam_class_subjects_component` (`id`, `session_id`, `class_id`, `subject_id`, `mdtid`, `mdcid`, `mark`, `remark_language`, `status`, `created_at`, `updated_at`) VALUES (13, NULL, 1, 1, NULL, '[{\"mdtid\":1,\"mdcid\":\"1\",\"mark\":\"20\"},{\"mdtid\":1,\"mdcid\":\"2\",\"mark\":\"10\"},{\"mdtid\":1,\"mdcid\":\"7\",\"mark\":\"10\"},{\"mdtid\":1,\"mdcid\":\"8\",\"mark\":\"10\"},{\"mdtid\":3,\"mdcid\":\"4\",\"mark\":\"\"},{\"mdtid\":3,\"mdcid\":\"5\",\"mark\":\"50\"},{\"mdtid\":3,\"mdcid\":\"6\",\"mark\":\"\"}]', NULL, 'eng', 1, '2025-05-18 02:53:57', NULL);
INSERT INTO `exam_class_subjects_component` (`id`, `session_id`, `class_id`, `subject_id`, `mdtid`, `mdcid`, `mark`, `remark_language`, `status`, `created_at`, `updated_at`) VALUES (14, NULL, 1, 2, NULL, '[{\"mdtid\":1,\"mdcid\":\"1\",\"mark\":\"20\"},{\"mdtid\":1,\"mdcid\":\"2\",\"mark\":\"10\"},{\"mdtid\":1,\"mdcid\":\"7\",\"mark\":\"10\"},{\"mdtid\":1,\"mdcid\":\"8\",\"mark\":\"10\"},{\"mdtid\":3,\"mdcid\":\"4\",\"mark\":\"\"},{\"mdtid\":3,\"mdcid\":\"5\",\"mark\":\"50\"},{\"mdtid\":3,\"mdcid\":\"6\",\"mark\":\"\"}]', NULL, 'eng', 1, '2025-05-18 02:54:38', NULL);


#
# TABLE STRUCTURE FOR: exam_classwise_subjects_mark
#

DROP TABLE IF EXISTS `exam_classwise_subjects_mark`;

CREATE TABLE `exam_classwise_subjects_mark` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `class_id` int(10) DEFAULT NULL,
  `subject_id` int(10) DEFAULT NULL,
  `subject_mark_type` int(5) DEFAULT NULL COMMENT '1-Marks/2-Grade',
  `max_mark` int(10) DEFAULT NULL,
  `min_mark` int(10) DEFAULT NULL,
  `aakarik_mark` int(10) DEFAULT NULL,
  `sankalit_mark` int(10) DEFAULT NULL,
  `description` varchar(100) DEFAULT NULL,
  `status` int(5) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO `exam_classwise_subjects_mark` (`id`, `class_id`, `subject_id`, `subject_mark_type`, `max_mark`, `min_mark`, `aakarik_mark`, `sankalit_mark`, `description`, `status`, `created_at`, `updated_at`) VALUES (1, 20, 2, 1, 100, 35, 50, 50, '', 1, '2023-12-02 22:33:06', NULL);
INSERT INTO `exam_classwise_subjects_mark` (`id`, `class_id`, `subject_id`, `subject_mark_type`, `max_mark`, `min_mark`, `aakarik_mark`, `sankalit_mark`, `description`, `status`, `created_at`, `updated_at`) VALUES (2, 20, 1, 1, 100, 33, 50, 50, '', 1, '2023-12-02 22:33:06', NULL);
INSERT INTO `exam_classwise_subjects_mark` (`id`, `class_id`, `subject_id`, `subject_mark_type`, `max_mark`, `min_mark`, `aakarik_mark`, `sankalit_mark`, `description`, `status`, `created_at`, `updated_at`) VALUES (3, 20, 4, 2, 40, 20, 25, 15, '', 1, '2023-12-02 22:33:06', NULL);
INSERT INTO `exam_classwise_subjects_mark` (`id`, `class_id`, `subject_id`, `subject_mark_type`, `max_mark`, `min_mark`, `aakarik_mark`, `sankalit_mark`, `description`, `status`, `created_at`, `updated_at`) VALUES (4, 20, 4, 1, 20, 10, 10, 10, '', 1, '2023-12-08 20:33:07', NULL);
INSERT INTO `exam_classwise_subjects_mark` (`id`, `class_id`, `subject_id`, `subject_mark_type`, `max_mark`, `min_mark`, `aakarik_mark`, `sankalit_mark`, `description`, `status`, `created_at`, `updated_at`) VALUES (5, 20, 3, 1, 100, 35, 40, 60, '', 3, '2024-01-27 00:02:19', NULL);
INSERT INTO `exam_classwise_subjects_mark` (`id`, `class_id`, `subject_id`, `subject_mark_type`, `max_mark`, `min_mark`, `aakarik_mark`, `sankalit_mark`, `description`, `status`, `created_at`, `updated_at`) VALUES (6, 1, 1, 1, 100, 33, 50, 50, '', 1, '2025-05-18 02:51:47', NULL);
INSERT INTO `exam_classwise_subjects_mark` (`id`, `class_id`, `subject_id`, `subject_mark_type`, `max_mark`, `min_mark`, `aakarik_mark`, `sankalit_mark`, `description`, `status`, `created_at`, `updated_at`) VALUES (7, 1, 2, 1, 100, 33, 50, 50, '', 1, '2025-05-18 02:52:21', NULL);


#
# TABLE STRUCTURE FOR: exam_group_class_batch_exam_students
#

DROP TABLE IF EXISTS `exam_group_class_batch_exam_students`;

CREATE TABLE `exam_group_class_batch_exam_students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_class_batch_exam_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `student_session_id` int(11) NOT NULL,
  `roll_no` int(11) DEFAULT NULL,
  `teacher_remark` text,
  `rank` int(11) NOT NULL DEFAULT '0',
  `is_active` int(11) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_class_batch_exam_id` (`exam_group_class_batch_exam_id`),
  KEY `student_id` (`student_id`),
  KEY `student_session_id` (`student_session_id`),
  CONSTRAINT `exam_group_class_batch_exam_students_ibfk_1` FOREIGN KEY (`exam_group_class_batch_exam_id`) REFERENCES `exam_group_class_batch_exams` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_class_batch_exam_students_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_class_batch_exam_students_ibfk_3` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (1, 1, 2474, 4380, NULL, NULL, 0, 0, '2025-08-28 15:44:43', NULL);
INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (2, 1, 2482, 4388, NULL, NULL, 0, 0, '2025-09-04 18:46:49', NULL);


#
# TABLE STRUCTURE FOR: exam_group_class_batch_exam_subjects
#

DROP TABLE IF EXISTS `exam_group_class_batch_exam_subjects`;

CREATE TABLE `exam_group_class_batch_exam_subjects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_class_batch_exams_id` int(11) DEFAULT NULL,
  `subject_id` int(11) NOT NULL,
  `class_id` int(11) DEFAULT NULL,
  `section_id` int(11) DEFAULT NULL,
  `date_from` date NOT NULL,
  `time_from` time NOT NULL,
  `duration` varchar(50) NOT NULL,
  `room_no` varchar(100) DEFAULT NULL,
  `mark_entry_type` int(11) NOT NULL DEFAULT '1',
  `max_marks` float(10,2) DEFAULT NULL,
  `min_marks` float(10,2) DEFAULT NULL,
  `credit_hours` float(10,2) DEFAULT '0.00',
  `date_to` datetime DEFAULT NULL,
  `is_active` int(11) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_class_batch_exams_id` (`exam_group_class_batch_exams_id`),
  KEY `subject_id` (`subject_id`),
  CONSTRAINT `exam_group_class_batch_exam_subjects_ibfk_1` FOREIGN KEY (`exam_group_class_batch_exams_id`) REFERENCES `exam_group_class_batch_exams` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_class_batch_exam_subjects_ibfk_2` FOREIGN KEY (`subject_id`) REFERENCES `subjects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (7, 1, 2, NULL, NULL, '2025-06-13', '16:06:41', '0', '1', 2, '0.00', '0.00', '0.00', NULL, 0, '2025-06-13 16:07:07', '2025-06-13 16:07:07');


#
# TABLE STRUCTURE FOR: exam_group_class_batch_exams
#

DROP TABLE IF EXISTS `exam_group_class_batch_exams`;

CREATE TABLE `exam_group_class_batch_exams` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam` varchar(250) DEFAULT NULL,
  `passing_percentage` float(10,2) DEFAULT NULL,
  `session_id` int(11) NOT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `exam_group_id` int(11) DEFAULT NULL,
  `use_exam_roll_no` int(11) NOT NULL DEFAULT '1',
  `is_termexam` varchar(50) DEFAULT NULL,
  `is_publish` int(11) DEFAULT '0',
  `is_rank_generated` int(11) NOT NULL DEFAULT '0',
  `description` text,
  `is_active` int(11) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_id` (`exam_group_id`),
  KEY `exam_group_class_batch_exams_ibfk_2` (`session_id`),
  CONSTRAINT `exam_group_class_batch_exams_ibfk_1` FOREIGN KEY (`exam_group_id`) REFERENCES `exam_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_class_batch_exams_ibfk_2` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_termexam`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'test exam', NULL, 28, NULL, NULL, 1, 1, NULL, 0, 0, 'test', 1, '2025-08-28 14:39:28', NULL);


#
# TABLE STRUCTURE FOR: exam_group_exam_connections
#

DROP TABLE IF EXISTS `exam_group_exam_connections`;

CREATE TABLE `exam_group_exam_connections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_id` int(11) DEFAULT NULL,
  `exam_group_class_batch_exams_id` int(11) DEFAULT NULL,
  `exam_weightage` float(10,2) DEFAULT '0.00',
  `is_active` int(11) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_id` (`exam_group_id`),
  KEY `exam_group_class_batch_exams_id` (`exam_group_class_batch_exams_id`),
  CONSTRAINT `exam_group_exam_connections_ibfk_1` FOREIGN KEY (`exam_group_id`) REFERENCES `exam_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_exam_connections_ibfk_2` FOREIGN KEY (`exam_group_class_batch_exams_id`) REFERENCES `exam_group_class_batch_exams` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: exam_group_exam_results
#

DROP TABLE IF EXISTS `exam_group_exam_results`;

CREATE TABLE `exam_group_exam_results` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_class_batch_exam_student_id` int(11) NOT NULL,
  `exam_group_class_batch_exam_subject_id` int(11) DEFAULT NULL,
  `exam_group_student_id` int(11) DEFAULT NULL,
  `attendence` varchar(10) DEFAULT NULL,
  `get_marks` float(10,2) DEFAULT '0.00',
  `get_grade` varchar(100) DEFAULT NULL,
  `note` text,
  `is_active` int(11) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `exam_group_class_batch_exam_subject_id` (`exam_group_class_batch_exam_subject_id`),
  KEY `exam_group_student_id` (`exam_group_student_id`),
  KEY `exam_group_class_batch_exam_student_id` (`exam_group_class_batch_exam_student_id`),
  CONSTRAINT `exam_group_exam_results_ibfk_1` FOREIGN KEY (`exam_group_class_batch_exam_subject_id`) REFERENCES `exam_group_class_batch_exam_subjects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_exam_results_ibfk_2` FOREIGN KEY (`exam_group_student_id`) REFERENCES `exam_group_students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_exam_results_ibfk_3` FOREIGN KEY (`exam_group_class_batch_exam_student_id`) REFERENCES `exam_group_class_batch_exam_students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `get_grade`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1, 1, 7, NULL, 'present', '0.00', 'A1', '', 0, '2025-08-28 15:55:41', '2025-08-28 15:55:41');
INSERT INTO `exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `exam_group_student_id`, `attendence`, `get_marks`, `get_grade`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2, 2, 7, NULL, 'present', '0.00', 'A1', '', 0, '2025-09-04 18:47:18', '2025-09-04 18:47:18');


#
# TABLE STRUCTURE FOR: exam_group_students
#

DROP TABLE IF EXISTS `exam_group_students`;

CREATE TABLE `exam_group_students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `student_session_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exam_group_id` (`exam_group_id`),
  KEY `student_id` (`student_id`),
  KEY `student_session_id` (`student_session_id`),
  CONSTRAINT `exam_group_students_ibfk_1` FOREIGN KEY (`exam_group_id`) REFERENCES `exam_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_students_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_students_ibfk_3` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: exam_groups
#

DROP TABLE IF EXISTS `exam_groups`;

CREATE TABLE `exam_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `exam_type` varchar(250) DEFAULT NULL,
  `description` text,
  `is_active` int(11) DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'test', 'basic_system', 'lorem', 0, '2025-05-21 10:28:00', '2025-05-21 10:28:00');


#
# TABLE STRUCTURE FOR: exam_mark_distribution_component
#

DROP TABLE IF EXISTS `exam_mark_distribution_component`;

CREATE TABLE `exam_mark_distribution_component` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `mdtid` int(5) DEFAULT NULL,
  `name` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `description` varchar(200) CHARACTER SET utf8 DEFAULT NULL,
  `status` int(5) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (1, 3, 'Unit Testta', '', 1, '2023-11-21 23:05:20', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (2, 1, 'Home work', '', 1, '2023-11-21 23:05:20', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (3, 1, 'sdfsdf', '', 3, '2023-11-21 23:05:20', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (4, 3, 'Oral test', '', 1, '2023-12-09 14:11:00', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (5, 3, 'Writtrn test', '', 1, '2023-12-09 14:11:00', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (6, 3, 'Health test', '', 1, '2024-01-21 15:13:35', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (7, 1, 'Tondi kaam', '', 1, '2024-01-26 23:51:17', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (8, 1, 'Sports', '', 1, '2025-05-18 02:44:36', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (9, 1, 'a', '', 1, '2025-05-19 13:01:06', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (10, 1, 'a', '', 1, '2025-05-19 13:01:06', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (11, 5, 'ANIL TESTING', '', 1, '2025-05-22 05:25:06', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (12, 3, 'yes', '', 1, '2025-06-11 17:38:59', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (13, 3, 'udgir', '', 1, '2025-06-11 17:38:59', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (14, 3, 'ATTAR', '', 1, '2025-06-15 22:08:38', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (15, 4, 'ATTAR', '', 1, '2025-06-15 22:08:57', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (16, 4, 'ATTAR', '', 1, '2025-06-15 22:08:57', NULL);


#
# TABLE STRUCTURE FOR: exam_marks_distribution_type
#

DROP TABLE IF EXISTS `exam_marks_distribution_type`;

CREATE TABLE `exam_marks_distribution_type` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `description` varchar(200) CHARACTER SET utf8 DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

INSERT INTO `exam_marks_distribution_type` (`id`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (1, 'आकारीक2', 'basic_systemx आकारीक', 1, '2023-11-21 12:33:07', '2023-11-21 06:00:00');
INSERT INTO `exam_marks_distribution_type` (`id`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (3, 'संकलित', 'संकलित mark Distribution Type', 1, '2023-12-09 14:09:37', NULL);
INSERT INTO `exam_marks_distribution_type` (`id`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (4, 'a', 'a', 1, '2025-05-19 12:32:54', NULL);
INSERT INTO `exam_marks_distribution_type` (`id`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (5, 'Dev sys', '', 1, '2025-05-22 05:24:45', NULL);
INSERT INTO `exam_marks_distribution_type` (`id`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (6, 'att', 'tets', 1, '2025-06-11 17:36:59', NULL);
INSERT INTO `exam_marks_distribution_type` (`id`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (7, 'ATTAR', '', 1, '2025-06-15 22:07:57', NULL);
INSERT INTO `exam_marks_distribution_type` (`id`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (8, 'ATTAR', '', 1, '2025-06-15 22:08:09', NULL);
INSERT INTO `exam_marks_distribution_type` (`id`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (9, 'ATTAR', '', 1, '2025-06-15 22:08:24', NULL);


#
# TABLE STRUCTURE FOR: exam_schedules
#

DROP TABLE IF EXISTS `exam_schedules`;

CREATE TABLE `exam_schedules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) NOT NULL,
  `exam_id` int(11) DEFAULT NULL,
  `teacher_subject_id` int(11) DEFAULT NULL,
  `date_of_exam` date DEFAULT NULL,
  `start_to` varchar(50) DEFAULT NULL,
  `end_from` varchar(50) DEFAULT NULL,
  `room_no` varchar(50) DEFAULT NULL,
  `full_marks` int(11) DEFAULT NULL,
  `passing_marks` int(11) DEFAULT NULL,
  `note` text,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `teacher_subject_id` (`teacher_subject_id`),
  KEY `session_id` (`session_id`),
  KEY `exam_id` (`exam_id`),
  CONSTRAINT `exam_schedules_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_schedules_ibfk_2` FOREIGN KEY (`exam_id`) REFERENCES `exams` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: exam_scorecard_component
#

DROP TABLE IF EXISTS `exam_scorecard_component`;

CREATE TABLE `exam_scorecard_component` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `component_name` varchar(100) DEFAULT NULL,
  `subject_mark_grade` varchar(100) DEFAULT NULL,
  `classes` varchar(100) DEFAULT NULL,
  `status` int(5) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

INSERT INTO `exam_scorecard_component` (`id`, `component_name`, `subject_mark_grade`, `classes`, `status`, `created_at`, `updated_at`) VALUES (1, 'NEED TO IMPROVE', '', '[\"1\"]', 1, '2024-03-11 03:04:54', NULL);
INSERT INTO `exam_scorecard_component` (`id`, `component_name`, `subject_mark_grade`, `classes`, `status`, `created_at`, `updated_at`) VALUES (2, 'Pragati important', '[\"3\"]', '[\"19\",\"20\"]', 1, '2024-03-11 10:18:29', NULL);
INSERT INTO `exam_scorecard_component` (`id`, `component_name`, `subject_mark_grade`, `classes`, `status`, `created_at`, `updated_at`) VALUES (3, 'need book', '', '[\"5\",\"6\"]', 1, '2025-05-21 09:29:43', NULL);
INSERT INTO `exam_scorecard_component` (`id`, `component_name`, `subject_mark_grade`, `classes`, `status`, `created_at`, `updated_at`) VALUES (4, 'attu', '', '[\"6\"]', 1, '2025-06-11 18:24:43', NULL);
INSERT INTO `exam_scorecard_component` (`id`, `component_name`, `subject_mark_grade`, `classes`, `status`, `created_at`, `updated_at`) VALUES (5, 'a', '', '[\"1\"]', 1, '2025-06-11 18:25:00', NULL);
INSERT INTO `exam_scorecard_component` (`id`, `component_name`, `subject_mark_grade`, `classes`, `status`, `created_at`, `updated_at`) VALUES (6, 'primary', '', '[\"1\",\"2\",\"3\",\"4\",\"5\",\"6\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\"]', 1, '2025-06-16 10:02:07', NULL);
INSERT INTO `exam_scorecard_component` (`id`, `component_name`, `subject_mark_grade`, `classes`, `status`, `created_at`, `updated_at`) VALUES (7, 'attar', '', '[\"1\",\"2\",\"3\",\"4\",\"5\",\"6\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\"]', 1, '2025-06-16 10:11:06', NULL);


#
# TABLE STRUCTURE FOR: exam_subjectwise_remark
#

DROP TABLE IF EXISTS `exam_subjectwise_remark`;

CREATE TABLE `exam_subjectwise_remark` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `subject_id` int(5) DEFAULT NULL,
  `remark_name` varchar(200) CHARACTER SET utf8 DEFAULT NULL,
  `note` varchar(200) CHARACTER SET utf8 DEFAULT NULL,
  `lang_id` varchar(300) DEFAULT NULL,
  `subjects` varchar(300) DEFAULT NULL,
  `status` int(5) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=latin1;

INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (6, 1, 'ALWAYS PARTICIPATES IN ROLE PLAYS AND DRAMAS', NULL, 'eng', 'english', 3, '2024-01-26 23:01:12', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (5, 1, 'ACTIVELY PARTICIPATES IN ENGLISH PARIPATH IN SCHOOL', NULL, 'eng', 'english', 1, '2024-01-26 23:01:12', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (7, 1, 'COMPLETES THE GIVEN HOMEWORK IN TIME', NULL, 'eng', 'english', 1, '2024-01-26 23:01:12', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (8, 1, 'CONSTRUCTS SIMPLE SENTENCES IN ENGLISH', NULL, 'eng', 'english', 1, '2024-01-26 23:05:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (9, 1, 'COPIES THE LETTERS AND WORDS CORRECTLY', NULL, 'eng', 'english', 1, '2024-01-26 23:05:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (10, 1, 'ENJOYS THE RHYTHM AND UNDERSTANDS', NULL, 'eng', 'english', 1, '2024-01-26 23:05:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (11, 1, 'GIVES RESPONSES IN VARIOUS CONTEXT', NULL, 'eng', 'english', 1, '2024-01-26 23:05:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (12, 1, 'GOOD', NULL, 'eng', 'english', 1, '2024-01-26 23:05:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (13, 1, 'IDENTIFIES COMMONLY USED WORDS', NULL, 'eng', 'english', 1, '2024-01-26 23:05:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (14, 1, 'LIKES TO READ SIMPLE ENGLISH STORIES IN SPARE TIME', NULL, 'eng', 'english', 1, '2024-01-26 23:05:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (15, 1, 'LISTENS CAREFULLY AND FOLLOWS THE INSTRUCTIONS', NULL, 'eng', 'english', 1, '2024-01-26 23:05:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (16, 1, 'LISTENS WITH CONCENTRATION', NULL, 'eng', 'english', 1, '2024-01-26 23:05:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (17, 1, 'PARTICIPATES IN CONVERSATIONS', NULL, 'eng', 'english', 1, '2024-01-26 23:05:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (18, 1, 'READS ALOUD FROM TEXTBOOK', NULL, 'eng', 'english', 1, '2024-01-26 23:05:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (19, 1, 'READS ALOUD WITH PROPER PUNCTUATION', NULL, 'eng', 'english', 1, '2024-01-26 23:05:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (20, 1, 'READS AND ACT ACCORDINGLY', NULL, 'eng', 'english', 1, '2024-01-26 23:07:55', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (21, 1, 'READS ENGLISH DAILY NEWSPAPER', NULL, 'eng', 'english', 1, '2024-01-26 23:07:55', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (22, 1, 'READS SILENTLY BY UNDERSTANDING', NULL, 'eng', 'english', 1, '2024-01-26 23:07:55', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (23, 1, 'READS THE PART IN DIALOGUES WITH UNDERSTANDING', NULL, 'eng', 'english', 1, '2024-01-26 23:07:55', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (24, 1, 'READS THE POEM IN RHYTHM', NULL, 'eng', 'english', 1, '2024-01-26 23:07:55', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (25, 1, 'REARRANGES COMMONLY USED WORDS', NULL, 'eng', 'english', 1, '2024-01-26 23:07:55', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (26, 1, 'REARRANGES THE STORY EVENTS', NULL, 'eng', 'english', 1, '2024-01-26 23:07:55', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (27, 1, 'RECITES POEMS AND SONGS WITH FUN', NULL, 'eng', 'english', 1, '2024-01-26 23:07:55', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (28, 2, 'ALWAYS PARTICIPATES IN ROLE PLAYS AND DRAMAS', '', NULL, NULL, 1, '2025-02-28 16:04:36', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (29, 1, 'EXCELENT', '', NULL, NULL, 3, '2025-05-18 02:50:02', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (30, 1, 'ANIL REMARK', '', NULL, NULL, 1, '2025-05-22 05:25:32', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (31, 31, 'ATTAR', '', NULL, NULL, 1, '2025-06-15 22:09:56', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (32, 31, 'ATTAR', '', NULL, NULL, 1, '2025-06-15 22:09:56', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (33, 31, 'ATTAR', '', NULL, NULL, 1, '2025-06-15 22:09:57', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (34, 31, 'ATTAR', '', NULL, NULL, 1, '2025-06-15 22:09:57', NULL);


#
# TABLE STRUCTURE FOR: exams
#

DROP TABLE IF EXISTS `exams`;

CREATE TABLE `exams` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `sesion_id` int(11) NOT NULL,
  `note` text,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sesion_id` (`sesion_id`),
  CONSTRAINT `exams_ibfk_1` FOREIGN KEY (`sesion_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: expense_head
#

DROP TABLE IF EXISTS `expense_head`;

CREATE TABLE `expense_head` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_category` varchar(50) DEFAULT NULL,
  `description` text,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_head_id` int(11) DEFAULT NULL,
  `inc_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `documents` varchar(255) DEFAULT NULL,
  `note` text,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `exp_head_id` (`exp_head_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `expenses` (`id`, `exp_head_id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (1, 1, 0, 'test', '32324', '2025-06-03', '200.00', NULL, 'test', 'yes', 'no', '2025-06-03 14:32:11', '2025-06-03 10:02:11');
INSERT INTO `expenses` (`id`, `exp_head_id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (2, 1, 2, 'acc', '987', '2025-06-11', '100000.00', NULL, '', 'yes', 'no', '2025-06-11 23:35:38', '2025-06-11 19:05:38');


#
# TABLE STRUCTURE FOR: fee_groups
#

DROP TABLE IF EXISTS `fee_groups`;

CREATE TABLE `fee_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `is_system` int(11) NOT NULL DEFAULT '0',
  `description` text,
  `nature` varchar(255) NOT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `nature`, `is_active`, `created_at`, `updated_at`) VALUES (1, '1st Class Registration Fees', 0, '1st Class Registration Fees', '', 'no', '2025-05-07 16:57:07', '2025-05-07 16:57:07');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `nature`, `is_active`, `created_at`, `updated_at`) VALUES (2, '1-Tution Fees', 0, '1-Tution Fees', '', 'no', '2025-06-11 21:37:44', '2025-06-11 21:37:44');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `nature`, `is_active`, `created_at`, `updated_at`) VALUES (3, '1-Term Fees', 0, '1-Term Fees', '', 'no', '2025-06-24 13:50:29', NULL);
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `nature`, `is_active`, `created_at`, `updated_at`) VALUES (4, '1-Other Fees', 0, '1-Other Fees', '', 'no', '2025-06-24 13:50:51', NULL);
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `nature`, `is_active`, `created_at`, `updated_at`) VALUES (5, '2_4 Class Term Fees', 0, '2_4 Class Term Fees', '', 'no', '2025-06-24 14:04:38', NULL);
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `nature`, `is_active`, `created_at`, `updated_at`) VALUES (6, '2_4-Tution Fees', 0, '2_4-Tution Fees', '', 'no', '2025-06-24 14:04:48', NULL);
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `nature`, `is_active`, `created_at`, `updated_at`) VALUES (7, '2_4-Other Fees', 0, '2_4-Other Fees', '', 'no', '2025-06-24 14:05:02', NULL);
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `nature`, `is_active`, `created_at`, `updated_at`) VALUES (8, '5_8-Term Fees', 0, '5_8-Term Fees', '', 'no', '2025-06-24 14:11:22', NULL);
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `nature`, `is_active`, `created_at`, `updated_at`) VALUES (9, '5_8-Tution Fees', 0, '5_8-Tution Fees', '', 'no', '2025-06-24 14:11:28', NULL);
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `nature`, `is_active`, `created_at`, `updated_at`) VALUES (10, '5_8-Other Fees', 0, '5_8-Other Fees', '', 'no', '2025-06-24 14:11:46', NULL);
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `nature`, `is_active`, `created_at`, `updated_at`) VALUES (11, '9_10-Term Fees', 0, '9_10-Term Fees', '', 'no', '2025-06-24 14:11:51', NULL);
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `nature`, `is_active`, `created_at`, `updated_at`) VALUES (12, '9_10-Tution Fees', 0, '9_10-Tution Fees', '', 'no', '2025-06-24 14:11:58', NULL);
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `nature`, `is_active`, `created_at`, `updated_at`) VALUES (13, '9_10-Other Fees', 0, '9_10-Other Fees', '', 'no', '2025-06-24 14:12:05', NULL);


#
# TABLE STRUCTURE FOR: fee_groups_feetype
#

DROP TABLE IF EXISTS `fee_groups_feetype`;

CREATE TABLE `fee_groups_feetype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fee_session_group_id` int(11) DEFAULT NULL,
  `fee_groups_id` int(11) DEFAULT NULL,
  `feetype_id` int(11) DEFAULT NULL,
  `session_id` int(11) DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `fine_type` varchar(50) NOT NULL DEFAULT 'none',
  `due_date` date DEFAULT NULL,
  `fee_receipt_date` varchar(50) DEFAULT NULL,
  `fine_percentage` float(10,2) NOT NULL DEFAULT '0.00',
  `fine_amount` float(10,2) NOT NULL DEFAULT '0.00',
  `fine_per_day` int(11) NOT NULL DEFAULT '0',
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fee_session_group_id` (`fee_session_group_id`),
  KEY `fee_groups_id` (`fee_groups_id`),
  KEY `feetype_id` (`feetype_id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `fee_groups_feetype_ibfk_1` FOREIGN KEY (`fee_session_group_id`) REFERENCES `fee_session_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_groups_feetype_ibfk_2` FOREIGN KEY (`fee_groups_id`) REFERENCES `fee_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_groups_feetype_ibfk_4` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8;

INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fee_receipt_date`, `fine_percentage`, `fine_amount`, `fine_per_day`, `is_active`, `created_at`, `updated_at`) VALUES (1, 1, 1, 1, 19, '10000.00', 'none', NULL, NULL, '0.00', '0.00', 0, 'no', '2025-05-07 16:58:16', '2025-05-07 16:58:16');
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fee_receipt_date`, `fine_percentage`, `fine_amount`, `fine_per_day`, `is_active`, `created_at`, `updated_at`) VALUES (59, 2, 1, 1, 28, '5000.00', 'none', '2025-07-31', NULL, '0.00', '0.00', 0, 'no', '2025-06-24 13:45:12', NULL);
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fee_receipt_date`, `fine_percentage`, `fine_amount`, `fine_per_day`, `is_active`, `created_at`, `updated_at`) VALUES (72, 15, 3, 2, 28, '5000.00', 'none', '2025-07-31', NULL, '0.00', '0.00', 0, 'no', '2025-06-24 13:58:09', NULL);
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fee_receipt_date`, `fine_percentage`, `fine_amount`, `fine_per_day`, `is_active`, `created_at`, `updated_at`) VALUES (73, 16, 2, 3, 28, '32000.00', 'none', '2025-07-31', NULL, '0.00', '0.00', 0, 'no', '2025-06-24 13:59:08', NULL);
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fee_receipt_date`, `fine_percentage`, `fine_amount`, `fine_per_day`, `is_active`, `created_at`, `updated_at`) VALUES (74, 17, 4, 4, 28, '3200.00', 'none', '2025-07-31', NULL, '0.00', '0.00', 0, 'no', '2025-06-24 14:00:01', NULL);
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fee_receipt_date`, `fine_percentage`, `fine_amount`, `fine_per_day`, `is_active`, `created_at`, `updated_at`) VALUES (75, 18, 5, 5, 28, '5000.00', 'none', NULL, NULL, '0.00', '0.00', 0, 'no', '2025-06-24 14:13:06', NULL);
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fee_receipt_date`, `fine_percentage`, `fine_amount`, `fine_per_day`, `is_active`, `created_at`, `updated_at`) VALUES (76, 19, 6, 6, 28, '32000.00', 'none', NULL, NULL, '0.00', '0.00', 0, 'no', '2025-06-24 14:13:49', NULL);
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fee_receipt_date`, `fine_percentage`, `fine_amount`, `fine_per_day`, `is_active`, `created_at`, `updated_at`) VALUES (77, 20, 7, 7, 28, '3200.00', 'none', NULL, NULL, '0.00', '0.00', 0, 'no', '2025-06-24 14:14:16', NULL);
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fee_receipt_date`, `fine_percentage`, `fine_amount`, `fine_per_day`, `is_active`, `created_at`, `updated_at`) VALUES (78, 21, 8, 8, 28, '5000.00', 'none', NULL, '25-06-2025', '0.00', '0.00', 0, 'no', '2025-06-24 14:14:38', NULL);
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fee_receipt_date`, `fine_percentage`, `fine_amount`, `fine_per_day`, `is_active`, `created_at`, `updated_at`) VALUES (79, 22, 9, 9, 28, '36000.00', 'none', NULL, NULL, '0.00', '0.00', 0, 'no', '2025-06-24 14:14:53', NULL);
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fee_receipt_date`, `fine_percentage`, `fine_amount`, `fine_per_day`, `is_active`, `created_at`, `updated_at`) VALUES (80, 23, 10, 10, 28, '3700.00', 'none', NULL, NULL, '0.00', '0.00', 0, 'no', '2025-06-24 14:15:08', NULL);
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fee_receipt_date`, `fine_percentage`, `fine_amount`, `fine_per_day`, `is_active`, `created_at`, `updated_at`) VALUES (81, 24, 11, 11, 28, '5000.00', 'none', NULL, NULL, '0.00', '0.00', 0, 'no', '2025-06-24 14:15:33', NULL);
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fee_receipt_date`, `fine_percentage`, `fine_amount`, `fine_per_day`, `is_active`, `created_at`, `updated_at`) VALUES (82, 25, 12, 12, 28, '4000.00', 'none', NULL, NULL, '0.00', '0.00', 0, 'no', '2025-06-24 14:15:50', NULL);
INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fee_receipt_date`, `fine_percentage`, `fine_amount`, `fine_per_day`, `is_active`, `created_at`, `updated_at`) VALUES (83, 26, 13, 13, 28, '4900.00', 'none', NULL, NULL, '0.00', '0.00', 0, 'no', '2025-06-24 14:16:04', NULL);


#
# TABLE STRUCTURE FOR: fee_head_course
#

DROP TABLE IF EXISTS `fee_head_course`;

CREATE TABLE `fee_head_course` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` int(11) NOT NULL,
  `class_ids` int(11) NOT NULL,
  `section_id` varchar(255) NOT NULL,
  `fee_cat_id` int(11) NOT NULL,
  `fee_type_id` int(11) NOT NULL,
  `amount` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4;

INSERT INTO `fee_head_course` (`id`, `course_id`, `class_ids`, `section_id`, `fee_cat_id`, `fee_type_id`, `amount`, `status`, `created_at`, `updated_at`) VALUES (2, 2, 20, '[\"1\",\"2\"]', 1, 0, '100', '1', '2024-08-28 18:44:20', NULL);
INSERT INTO `fee_head_course` (`id`, `course_id`, `class_ids`, `section_id`, `fee_cat_id`, `fee_type_id`, `amount`, `status`, `created_at`, `updated_at`) VALUES (3, 2, 20, '[\"1\"]', 1, 2, '100', '1', '2024-08-30 12:39:50', NULL);
INSERT INTO `fee_head_course` (`id`, `course_id`, `class_ids`, `section_id`, `fee_cat_id`, `fee_type_id`, `amount`, `status`, `created_at`, `updated_at`) VALUES (5, 3, 1, '[\"1\"]', 2, 2, '100', '1', '2025-06-12 14:42:56', NULL);
INSERT INTO `fee_head_course` (`id`, `course_id`, `class_ids`, `section_id`, `fee_cat_id`, `fee_type_id`, `amount`, `status`, `created_at`, `updated_at`) VALUES (6, 3, 1, '[\"1\"]', 2, 2, '100', '1', '2025-06-12 15:09:42', NULL);
INSERT INTO `fee_head_course` (`id`, `course_id`, `class_ids`, `section_id`, `fee_cat_id`, `fee_type_id`, `amount`, `status`, `created_at`, `updated_at`) VALUES (7, 3, 1, '[\"1\"]', 2, 2, '100', '1', '2025-06-12 15:10:36', NULL);
INSERT INTO `fee_head_course` (`id`, `course_id`, `class_ids`, `section_id`, `fee_cat_id`, `fee_type_id`, `amount`, `status`, `created_at`, `updated_at`) VALUES (8, 3, 1, '[\"1\"]', 2, 2, '100', '1', '2025-06-12 15:12:52', NULL);
INSERT INTO `fee_head_course` (`id`, `course_id`, `class_ids`, `section_id`, `fee_cat_id`, `fee_type_id`, `amount`, `status`, `created_at`, `updated_at`) VALUES (9, 3, 1, '[\"1\"]', 2, 2, '100', '1', '2025-06-12 15:12:57', NULL);
INSERT INTO `fee_head_course` (`id`, `course_id`, `class_ids`, `section_id`, `fee_cat_id`, `fee_type_id`, `amount`, `status`, `created_at`, `updated_at`) VALUES (10, 3, 1, '[\"1\"]', 2, 2, '100', '1', '2025-06-12 15:13:27', NULL);
INSERT INTO `fee_head_course` (`id`, `course_id`, `class_ids`, `section_id`, `fee_cat_id`, `fee_type_id`, `amount`, `status`, `created_at`, `updated_at`) VALUES (11, 3, 1, '[\"2\"]', 2, 2, '1000', '0', '2025-06-12 15:14:10', '2025-06-12 15:14:20');


#
# TABLE STRUCTURE FOR: fee_receipt_no
#

DROP TABLE IF EXISTS `fee_receipt_no`;

CREATE TABLE `fee_receipt_no` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: fee_session_groups
#

DROP TABLE IF EXISTS `fee_session_groups`;

CREATE TABLE `fee_session_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fee_groups_id` int(11) DEFAULT NULL,
  `session_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fee_groups_id` (`fee_groups_id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `fee_session_groups_ibfk_1` FOREIGN KEY (`fee_groups_id`) REFERENCES `fee_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_session_groups_ibfk_2` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8;

INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`, `updated_at`) VALUES (1, 1, 19, 'no', '2025-05-07 16:58:16', '2025-05-07 16:58:16');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`, `updated_at`) VALUES (2, 1, 28, 'no', '2025-06-24 13:45:12', NULL);
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`, `updated_at`) VALUES (15, 3, 28, 'no', '2025-06-24 13:58:09', NULL);
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`, `updated_at`) VALUES (16, 2, 28, 'no', '2025-06-24 13:59:08', NULL);
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`, `updated_at`) VALUES (17, 4, 28, 'no', '2025-06-24 14:00:01', NULL);
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`, `updated_at`) VALUES (18, 5, 28, 'no', '2025-06-24 14:13:06', NULL);
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`, `updated_at`) VALUES (19, 6, 28, 'no', '2025-06-24 14:13:49', NULL);
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`, `updated_at`) VALUES (20, 7, 28, 'no', '2025-06-24 14:14:16', NULL);
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`, `updated_at`) VALUES (21, 8, 28, 'no', '2025-06-24 14:14:38', NULL);
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`, `updated_at`) VALUES (22, 9, 28, 'no', '2025-06-24 14:14:53', NULL);
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`, `updated_at`) VALUES (23, 10, 28, 'no', '2025-06-24 14:15:08', NULL);
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`, `updated_at`) VALUES (24, 11, 28, 'no', '2025-06-24 14:15:33', NULL);
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`, `updated_at`) VALUES (25, 12, 28, 'no', '2025-06-24 14:15:50', NULL);
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`, `updated_at`) VALUES (26, 13, 28, 'no', '2025-06-24 14:16:04', NULL);


#
# TABLE STRUCTURE FOR: feecategory
#

DROP TABLE IF EXISTS `feecategory`;

CREATE TABLE `feecategory` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(50) DEFAULT NULL,
  `cast_cat_id` int(11) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `feecategory` (`id`, `category`, `cast_cat_id`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'GOI', 1, 'no', '2024-08-26 22:42:58', NULL);
INSERT INTO `feecategory` (`id`, `category`, `cast_cat_id`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'test', 2, 'no', '2025-06-04 14:33:53', NULL);


#
# TABLE STRUCTURE FOR: feemasters
#

DROP TABLE IF EXISTS `feemasters`;

CREATE TABLE `feemasters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) DEFAULT NULL,
  `feetype_id` int(11) NOT NULL,
  `class_id` int(11) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `description` text,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  KEY `feetype_id` (`feetype_id`),
  KEY `class_id` (`class_id`),
  CONSTRAINT `feemasters_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `feemasters_ibfk_2` FOREIGN KEY (`feetype_id`) REFERENCES `oldfeetype` (`id`) ON DELETE CASCADE,
  CONSTRAINT `feemasters_ibfk_3` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: fees_discounts
#

DROP TABLE IF EXISTS `fees_discounts`;

CREATE TABLE `fees_discounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `code` varchar(100) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `percentage` float(10,2) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `discount_limit` int(11) DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `description` text,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `fees_discounts_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: fees_reminder
#

DROP TABLE IF EXISTS `fees_reminder`;

CREATE TABLE `fees_reminder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reminder_type` varchar(10) DEFAULT NULL,
  `day` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `fees_reminder` (`id`, `reminder_type`, `day`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'before', 2, 1, '2020-02-28 19:08:32', NULL);
INSERT INTO `fees_reminder` (`id`, `reminder_type`, `day`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'before', 5, 1, '2020-02-28 19:08:36', NULL);
INSERT INTO `fees_reminder` (`id`, `reminder_type`, `day`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'after', 2, 1, '2020-02-28 19:08:40', NULL);
INSERT INTO `fees_reminder` (`id`, `reminder_type`, `day`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'after', 5, 1, '2020-02-28 19:08:44', NULL);


#
# TABLE STRUCTURE FOR: feesrevert_reasons
#

DROP TABLE IF EXISTS `feesrevert_reasons`;

CREATE TABLE `feesrevert_reasons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason` varchar(255) NOT NULL,
  `description` varchar(1000) DEFAULT NULL,
  `status` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

INSERT INTO `feesrevert_reasons` (`id`, `reason`, `description`, `status`, `created_at`, `updated_at`) VALUES (1, 'test1', 'testing1', '1', '2024-08-27 20:49:45', '2024-08-27 21:14:41');


#
# TABLE STRUCTURE FOR: feetype
#

DROP TABLE IF EXISTS `feetype`;

CREATE TABLE `feetype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_system` int(11) NOT NULL DEFAULT '0',
  `feecategory_id` int(11) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `bank_account` varchar(255) DEFAULT NULL,
  `collection_type` varchar(255) DEFAULT NULL,
  `code` varchar(100) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `description` text,
  `session_id` int(11) DEFAULT NULL,
  `student_session_id` int(11) DEFAULT NULL,
  `nature` varchar(255) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `bank_account`, `collection_type`, `code`, `is_active`, `description`, `session_id`, `student_session_id`, `nature`, `status`, `created_at`, `updated_at`) VALUES (1, 0, NULL, '1st Class Registration Fees', '1', 'income', 'Reg-F', 'no', '1st Class Registration Fees', NULL, NULL, '', '1', '2025-05-07 16:57:26', '2025-05-07 12:27:26');
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `bank_account`, `collection_type`, `code`, `is_active`, `description`, `session_id`, `student_session_id`, `nature`, `status`, `created_at`, `updated_at`) VALUES (2, 0, NULL, '1-Term Fees', '1', 'income', 'TF01', 'no', '1-Term Fees', NULL, NULL, '', '1', '2025-06-03 12:11:28', '2025-06-03 07:41:28');
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `bank_account`, `collection_type`, `code`, `is_active`, `description`, `session_id`, `student_session_id`, `nature`, `status`, `created_at`, `updated_at`) VALUES (3, 0, NULL, '1-Tution Fees', '1', 'income', '1-TUF01', 'no', '1-Tution Fees', NULL, NULL, '', '1', '2025-06-11 21:38:36', '2025-06-11 17:08:36');
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `bank_account`, `collection_type`, `code`, `is_active`, `description`, `session_id`, `student_session_id`, `nature`, `status`, `created_at`, `updated_at`) VALUES (4, 0, NULL, '1-Other Fees', '1', 'income', '1-OF01', 'no', '1-Other Fees', NULL, NULL, '', '1', '2025-06-24 13:49:24', '2025-06-24 09:19:24');
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `bank_account`, `collection_type`, `code`, `is_active`, `description`, `session_id`, `student_session_id`, `nature`, `status`, `created_at`, `updated_at`) VALUES (5, 0, NULL, ' 2_4 Class Term Fees', '1', 'income', '2_4-TF02', 'no', ' 2_4 Class Term Fees', NULL, NULL, '', '1', '2025-06-24 14:01:10', '2025-06-24 09:31:10');
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `bank_account`, `collection_type`, `code`, `is_active`, `description`, `session_id`, `student_session_id`, `nature`, `status`, `created_at`, `updated_at`) VALUES (6, 0, NULL, '2_4-Tution Fees', '1', 'income', '2_4-TUF02', 'no', '2_4-Tution Fees', NULL, NULL, '', '1', '2025-06-24 14:03:35', '2025-06-24 09:33:35');
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `bank_account`, `collection_type`, `code`, `is_active`, `description`, `session_id`, `student_session_id`, `nature`, `status`, `created_at`, `updated_at`) VALUES (7, 0, NULL, '2_4-Other Fees', '1', 'income', '2_4-OF02', 'no', '2_4-Other Fees', NULL, NULL, '', '1', '2025-06-24 14:04:15', '2025-06-24 09:34:15');
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `bank_account`, `collection_type`, `code`, `is_active`, `description`, `session_id`, `student_session_id`, `nature`, `status`, `created_at`, `updated_at`) VALUES (8, 0, NULL, '5_8-Term Fees', '1', 'income', '5_8-TF03', 'no', '5_8-Term Fees', NULL, NULL, '', '1', '2025-06-24 14:06:41', '2025-06-24 09:36:41');
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `bank_account`, `collection_type`, `code`, `is_active`, `description`, `session_id`, `student_session_id`, `nature`, `status`, `created_at`, `updated_at`) VALUES (9, 0, NULL, '5_8-Tution Fees', '1', 'income', '5_8-TUF03', 'no', '5_8-Tution Fees', NULL, NULL, '', '1', '2025-06-24 14:07:19', '2025-06-24 09:37:19');
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `bank_account`, `collection_type`, `code`, `is_active`, `description`, `session_id`, `student_session_id`, `nature`, `status`, `created_at`, `updated_at`) VALUES (10, 0, NULL, '5_8-Other Fees', '1', 'income', '5_8-OF03', 'no', '5_8-Other Fees', NULL, NULL, '', '1', '2025-06-24 14:07:50', '2025-06-24 09:37:50');
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `bank_account`, `collection_type`, `code`, `is_active`, `description`, `session_id`, `student_session_id`, `nature`, `status`, `created_at`, `updated_at`) VALUES (11, 0, NULL, '9_10-Term Fees', '1', 'income', '9_10-TF04', 'no', '9_10-Term Fees', NULL, NULL, '', '1', '2025-06-24 14:08:46', '2025-06-24 09:38:46');
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `bank_account`, `collection_type`, `code`, `is_active`, `description`, `session_id`, `student_session_id`, `nature`, `status`, `created_at`, `updated_at`) VALUES (12, 0, NULL, '9_10-Tution Fees', '1', 'income', '9_10-TUF04', 'no', '9_10-Tution Fees', NULL, NULL, '', '1', '2025-06-24 14:09:24', '2025-06-24 09:39:24');
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `bank_account`, `collection_type`, `code`, `is_active`, `description`, `session_id`, `student_session_id`, `nature`, `status`, `created_at`, `updated_at`) VALUES (13, 0, NULL, '9_10-Other Fees', '1', 'income', '9_10-OF03', 'no', '9_10-Other Fees', NULL, NULL, '', '1', '2025-06-24 14:09:54', '2025-06-24 09:39:54');


#
# TABLE STRUCTURE FOR: filetypes
#

DROP TABLE IF EXISTS `filetypes`;

CREATE TABLE `filetypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_extension` text,
  `file_mime` text,
  `file_size` int(11) NOT NULL,
  `image_extension` text,
  `image_mime` text,
  `image_size` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `filetypes` (`id`, `file_extension`, `file_mime`, `file_size`, `image_extension`, `image_mime`, `image_size`, `created_at`, `updated_at`) VALUES (1, 'pdf, zip, jpg, jpeg, png, txt, 7z, gif, csv, docx, mp3, mp4, accdb, odt, ods, ppt, pptx, xlsx, wmv, jfif, apk, ppt, bmp, jpe, mdb, rar, xls, svg', 'application/pdf, image/zip, image/jpg, image/png, image/jpeg, text/plain, application/x-zip-compressed, application/zip, image/gif, text/csv, application/vnd.openxmlformats-officedocument.wordprocessingml.document, audio/mpeg, application/msaccess, application/vnd.oasis.opendocument.text, application/vnd.oasis.opendocument.spreadsheet, application/vnd.ms-powerpoint, application/vnd.openxmlformats-officedocument.presentationml.presentation, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, video/x-ms-wmv, video/mp4, image/jpeg, application/vnd.android.package-archive, application/x-msdownload, application/vnd.ms-powerpoint, image/bmp, image/jpeg, application/msaccess, application/vnd.ms-excel, image/svg+xml', 100048576, 'jfif, png, jpe, jpeg, jpg, bmp, gif, svg', 'image/jpeg, image/png, image/jpeg, image/jpeg, image/bmp, image/gif, image/x-ms-bmp, image/svg+xml', 10048576, '2021-01-30 18:33:03', '2025-04-10 03:22:06');


#
# TABLE STRUCTURE FOR: follow_up
#

DROP TABLE IF EXISTS `follow_up`;

CREATE TABLE `follow_up` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enquiry_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `next_date` date NOT NULL,
  `response` text NOT NULL,
  `note` text NOT NULL,
  `followup_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `enquiry_id` (`enquiry_id`),
  KEY `followup_by` (`followup_by`),
  CONSTRAINT `follow_up_ibfk_1` FOREIGN KEY (`enquiry_id`) REFERENCES `enquiry` (`id`) ON DELETE CASCADE,
  CONSTRAINT `follow_up_ibfk_2` FOREIGN KEY (`followup_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_media_gallery
#

DROP TABLE IF EXISTS `front_cms_media_gallery`;

CREATE TABLE `front_cms_media_gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image` varchar(300) DEFAULT NULL,
  `thumb_path` varchar(300) DEFAULT NULL,
  `dir_path` varchar(300) DEFAULT NULL,
  `img_name` varchar(300) DEFAULT NULL,
  `thumb_name` varchar(300) DEFAULT NULL,
  `file_type` varchar(100) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `vid_url` text NOT NULL,
  `vid_title` varchar(250) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_menu_items
#

DROP TABLE IF EXISTS `front_cms_menu_items`;

CREATE TABLE `front_cms_menu_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) NOT NULL,
  `menu` varchar(100) DEFAULT NULL,
  `page_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `ext_url` text,
  `open_new_tab` int(11) DEFAULT '0',
  `ext_url_link` text,
  `slug` varchar(200) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `publish` int(11) NOT NULL DEFAULT '0',
  `description` text,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_id` (`menu_id`),
  CONSTRAINT `front_cms_menu_items_ibfk_1` FOREIGN KEY (`menu_id`) REFERENCES `front_cms_menus` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 1, 'Home', 1, 0, NULL, NULL, NULL, 'home', 1, 0, NULL, 'no', '2019-12-03 03:41:50', '2025-04-10 03:22:06');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (2, 1, 'Contact Us', 76, 0, NULL, NULL, NULL, 'contact-us', 4, 0, NULL, 'no', '2019-12-03 03:41:52', '2025-04-10 03:22:06');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (3, 1, 'Complain', 2, 0, NULL, NULL, NULL, 'complain', 3, 0, NULL, 'no', '2019-12-03 03:41:52', '2025-04-10 03:22:06');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (4, 1, 'Online Admission', 0, 0, '1', NULL, 'http://yourschoolurl.com/online_admission', 'admssion', 2, 0, NULL, 'no', '2019-12-21 21:03:00', '2025-04-10 03:22:06');


#
# TABLE STRUCTURE 