#
# TABLE STRUCTURE FOR: OLDlanguages
#

DROP TABLE IF EXISTS `OLDlanguages`;

CREATE TABLE `OLDlanguages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(50) DEFAULT NULL,
  `short_code` varchar(255) NOT NULL,
  `country_code` varchar(255) NOT NULL,
  `is_rtl` int(11) NOT NULL,
  `is_deleted` varchar(10) NOT NULL DEFAULT 'yes',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=95 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Azerbaijan', 'az', 'az', 0, 'no', 'no', '2019-11-20 11:23:12', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Albanian', 'sq', 'al', 0, 'no', 'no', '2019-11-20 11:42:42', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Amharic', 'am', 'am', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'English', 'en', 'us', 0, 'no', 'yes', '2019-11-20 11:38:50', '2025-05-25 08:11:40');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Arabic', 'ar', 'sa', 0, 'no', 'no', '2019-11-20 11:47:28', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'Afrikaans', 'af', 'af', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Basque', 'eu', 'es', 0, 'no', 'no', '2019-11-20 11:54:10', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'Bengali', 'bn', 'in', 0, 'no', 'no', '2019-11-20 11:41:53', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'Bosnian', 'bs', 'bs', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'Welsh', 'cy', 'cy', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'Hungarian', 'hu', 'hu', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'Vietnamese', 'vi', 'vi', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'Haitian', 'ht', 'ht', 0, 'no', 'no', '2021-01-23 07:09:32', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'Galician', 'gl', 'gl', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'Dutch', 'nl', 'nl', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'Greek', 'el', 'gr', 0, 'no', 'no', '2019-11-20 12:12:08', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'Georgian', 'ka', 'ge', 0, 'no', 'no', '2019-11-20 12:11:40', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'Gujarati', 'gu', 'in', 0, 'no', 'no', '2019-11-20 11:39:16', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'Danish', 'da', 'dk', 0, 'no', 'no', '2019-11-20 12:03:25', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'Hebrew', 'he', 'il', 0, 'no', 'no', '2019-11-20 12:13:50', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'Yiddish', 'yi', 'il', 0, 'no', 'no', '2019-11-20 12:25:33', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'Indonesian', 'id', 'id', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'Irish', 'ga', 'ga', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'Italian', 'it', 'it', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'Icelandic', 'is', 'is', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'Spanish', 'es', 'es', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'Kannada', 'kn', 'in', 0, 'no', 'no', '2019-11-20 11:24:23', '2025-04-15 21:46:44');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'Catalan', 'ca', 'ca', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'Chinese', 'zh', 'cn', 0, 'no', 'no', '2019-11-20 12:01:48', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'Korean', 'ko', 'kr', 0, 'no', 'no', '2019-11-20 12:19:09', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'Xhosa', 'xh', 'ls', 0, 'no', 'no', '2019-11-20 12:24:39', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'Latin', 'la', 'it', 0, 'no', 'no', '2021-01-23 07:09:32', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'Latvian', 'lv', 'lv', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'Lithuanian', 'lt', 'lt', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'Malagasy', 'mg', 'mg', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'Malay', 'ms', 'ms', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'Malayalam', 'ml', 'ml', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'Maltese', 'mt', 'mt', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'Macedonian', 'mk', 'mk', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'Maori', 'mi', 'nz', 0, 'no', 'no', '2019-11-20 12:20:27', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'Marathi', 'mr', 'in', 0, 'no', 'no', '2019-11-20 11:39:51', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'Mongolian', 'mn', 'mn', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'German', 'de', 'de', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'Nepali', 'ne', 'ne', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'Norwegian', 'no', 'no', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'Punjabi', 'pa', 'in', 0, 'no', 'no', '2019-11-20 11:40:16', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'Persian', 'fa', 'ir', 0, 'no', 'no', '2019-11-20 12:21:17', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'Portuguese', 'pt', 'pt', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'Romanian', 'ro', 'ro', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'Russian', 'ru', 'ru', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'Cebuano', 'ceb', 'ph', 0, 'no', 'no', '2019-11-20 11:59:12', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'Sinhala', 'si', 'lk ', 0, 'no', 'no', '2021-01-23 07:09:32', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'Slovakian', 'sk', 'sk', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'Slovenian', 'sl', 'sl', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'Swahili', 'sw', 'ke', 0, 'no', 'no', '2019-11-20 12:21:57', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'Sundanese', 'su', 'sd', 0, 'no', 'no', '2019-12-03 11:06:57', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'Thai', 'th', 'th', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'Tagalog', 'tl', 'tl', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'Tamil', 'ta', 'in', 0, 'no', 'no', '2019-11-20 11:40:53', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'Telugu', 'te', 'in', 0, 'no', 'no', '2019-11-20 11:41:15', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'Turkish', 'tr', 'tr', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'Uzbek', 'uz', 'uz', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (79, 'Urdu', 'ur', 'pk', 0, 'no', 'no', '2019-11-20 12:23:57', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (80, 'Finnish', 'fi', 'fi', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (81, 'French', 'fr', 'fr', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (82, 'Hindi', 'hi', 'in', 0, 'no', 'no', '2019-11-20 11:36:34', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (84, 'Czech', 'cs', 'cz', 0, 'no', 'no', '2019-11-20 12:02:36', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (85, 'Swedish', 'sv', 'sv', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (86, 'Scottish', 'gd', 'gd', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (87, 'Estonian', 'et', 'et', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (88, 'Esperanto', 'eo', 'br', 0, 'no', 'no', '2019-11-21 04:49:18', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (89, 'Javanese', 'jv', 'id', 0, 'no', 'no', '2019-11-20 12:18:29', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (90, 'Japanese', 'ja', 'jp', 0, 'no', 'no', '2019-11-20 12:14:39', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (91, 'Polish', 'pl', 'pl', 0, 'no', 'no', '2020-06-15 04:25:27', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (92, 'Kurdish', 'ku', 'iq', 0, 'no', 'no', '2020-12-21 00:15:31', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (93, 'Lao', 'lo', 'la', 0, 'no', 'no', '2020-12-21 00:15:36', '0000-00-00 00:00:00');
INSERT INTO `OLDlanguages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (94, 'Croatia', 'hr', 'hr', 0, 'no', 'no', '2022-06-07 12:48:21', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: QR_code_settings
#

DROP TABLE IF EXISTS `QR_code_settings`;

CREATE TABLE `QR_code_settings` (
  `id` int(11) NOT NULL,
  `camera_type` varchar(15) DEFAULT NULL,
  `auto_attendance` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `QR_code_settings` (`id`, `camera_type`, `auto_attendance`, `created_at`) VALUES (1, 'environment', 1, '2025-05-02 19:58:03');


#
# TABLE STRUCTURE FOR: addon_versions
#

DROP TABLE IF EXISTS `addon_versions`;

CREATE TABLE `addon_versions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `addon_id` int(11) DEFAULT NULL,
  `version` varchar(10) DEFAULT NULL,
  `version_order` int(11) DEFAULT NULL,
  `folder_path` text DEFAULT NULL,
  `sort_description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `addon_id` (`addon_id`),
  CONSTRAINT `addon_versions_ibfk_1` FOREIGN KEY (`addon_id`) REFERENCES `addons` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: addons
#

DROP TABLE IF EXISTS `addons`;

CREATE TABLE `addons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `image` text NOT NULL,
  `name` varchar(500) DEFAULT NULL,
  `config_name` varchar(200) NOT NULL DEFAULT '',
  `short_name` varchar(100) NOT NULL,
  `directory` varchar(500) NOT NULL,
  `description` text DEFAULT NULL,
  `price` float(10,2) NOT NULL DEFAULT 0.00,
  `current_version` varchar(50) DEFAULT NULL,
  `article_link` text NOT NULL,
  `installation_by` int(11) DEFAULT NULL,
  `uninstall_version` varchar(50) DEFAULT NULL,
  `unistall_by` int(11) DEFAULT NULL,
  `addon_prod` text DEFAULT NULL,
  `addon_ver` text DEFAULT NULL,
  `last_update` datetime DEFAULT NULL,
  `current_stage` int(11) NOT NULL DEFAULT 0 COMMENT '0 for buy addon,1 for folder available ready to install,2 for folder addon installed',
  `product_order` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (1, 47443722, 'uploads/addon_images/sscbse_images.jpg', 'Do Little Tech CBSE Examination    ', 'cbse-config', 'sscbse', 'cbse_examination', 'CBSE Examination addon adds CBSE Examination module in Do Little Tech. Using this module teacher/staff can create and print marksheets with advance features.', '0.00', '', '#', NULL, NULL, NULL, NULL, NULL, '2024-09-03 16:04:58', 0, 4, '2024-09-03 17:04:58', '2025-05-09 21:50:50');
INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (2, 44278049, 'uploads/addon_images/sstfa_images.jpg', 'Do Little Tech Two Factor Authentication', 'google-authenticate-config', 'sstfa', 'two_factor_authentication', 'Two Factor Authentication addon adds Two Factor Authentication module in Do Little Tech. Using this module you can enhance login security of your Do Little Tech users.', '0.00', NULL, '#', NULL, NULL, NULL, NULL, NULL, '2025-01-29 11:16:14', 0, 5, '2024-09-07 11:45:18', '2025-05-09 21:54:01');
INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (3, 44277916, 'uploads/addon_images/ssmb_images.jpg', 'Do Little Tech Multi Branch', 'multibranch-config', 'ssmb', 'multi_branch', 'Multi Branch addon adds Multi Branch module in Do Little Tech. Using this module Superadmin user can add other any number of schools/branches.', '0.00', NULL, '#', NULL, NULL, NULL, NULL, NULL, '2025-01-29 11:16:15', 0, 6, '2024-09-07 11:45:18', '2025-05-09 21:50:50');
INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (4, 44247532, 'uploads/addon_images/ssbr_images.jpg', 'Do Little Tech Behaviour Records', 'behaviour-report-config', 'ssbr', 'behavior_records', 'Behaviour Records addon adds Behaviour Records module in Do Little Tech. Using this module teacher/staff can create different incidents with positive/negative marks and then assign these incidents on students.', '0.00', '3.0', '#', NULL, '1.0', NULL, NULL, NULL, '2025-01-29 11:16:19', 0, 7, '2024-09-07 11:45:42', '2025-05-09 21:50:50');
INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (5, 33101540, 'uploads/addon_images/ssoclc_images.jpg', 'Do Little Tech Online Course', 'onlinecourse-config', 'ssoclc', 'online_course', 'Online Course addon adds Online Course module in Do Little Tech. Using this module teacher/staff can create free or paid online course with their study material based on video, audio or in document content format.', '0.00', '4.0', '#', NULL, '1.0', NULL, NULL, NULL, '2025-01-29 11:16:19', 0, 8, '2024-09-07 11:45:42', '2025-05-09 21:54:01');
INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (6, 27492043, 'uploads/addon_images/sszlc_images.jpg', 'Do Little Tech Zoom Live Classes', 'zoom-config', 'sszlc', 'zoom_live_class', 'Zoom Live Class addon adds Zoom Live Class module in Do Little Tech. Using this module teacher/staff can create live online classes using Zoom.us service. Further students can join these classes.', '0.00', NULL, '#', NULL, NULL, NULL, NULL, NULL, '2025-01-29 11:16:17', 0, 10, '2024-09-07 11:46:10', '2025-05-09 21:54:01');
INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (7, 28941973, 'uploads/addon_images/ssglc_images.jpg', 'Do Little Tech  Gmeet Live Class', 'gmeet-config', 'ssglc', 'gmeet_live_class', 'Gmeet Live Class addon adds Gmeet Live Class module in Do Little Tech. Using this module teacher/staff can create live online classes using http://meet.google.com service. Further students can join these classes.', '0.00', NULL, '#', NULL, NULL, NULL, NULL, NULL, '2025-01-29 11:16:24', 0, 9, '2024-09-07 11:46:10', '2025-05-09 21:54:01');
INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (8, 50336584, 'uploads/addon_images/ssqra_images.jpg', 'Do Little Tech QR Code Attendance', 'qrattendance-config', 'ssqra', 'qr_code_attendance', 'QR Code Attendance addon adds automated Student/Staff attendance using QR/Barcode module in Do Little Tech. Using this module Student/Staff can submit their attendance by just scanning their ID Card.', '0.00', '2.0', '#', NULL, '1.0', NULL, NULL, NULL, '2025-01-28 22:28:58', 0, 3, '2025-01-13 13:10:06', '2025-05-09 21:54:01');
INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (9, 57220011, 'uploads/addon_images/ssqfc_images.jpg', 'Do Little Tech Quick Fees Create', 'quickfees-config', 'ssqfc', 'quick_fees_create', 'Quick Fees Create addon adds one click fees create feature in Do Little Tech Fees Collection module. Using this you can create and assign fees on students in just few seconds and all Fees Category, Fees Groups, Fees Masters will be create automatically in your Do Little Tech.', '0.00', NULL, '#', NULL, NULL, NULL, NULL, NULL, '2025-01-28 22:28:58', 0, 2, '2025-01-13 13:10:06', '2025-05-09 21:54:28');
INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (10, 57219905, 'uploads/addon_images/sstpa_images.jpg', 'Do Little Tech Thermal Print', 'thermalprint-config', 'sstpa', 'thermal_print', 'Thermal Print addon adds Thermal Printer compatible small size fees receipt print capability in Do Little Tech. Using this module you can utilize modern cost effective fees receipt printing in Do Little Tech.', '0.00', NULL, '#\r\n', NULL, NULL, NULL, NULL, NULL, '2025-01-30 10:28:42', 0, 1, '2025-01-13 13:10:06', '2025-05-09 21:54:28');


#
# TABLE STRUCTURE FOR: alumni_events
#

DROP TABLE IF EXISTS `alumni_events`;

CREATE TABLE `alumni_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `session_id` int(11) DEFAULT NULL,
  `class_id` int(11) DEFAULT NULL,
  `section` varchar(255) NOT NULL,
  `from_date` datetime NOT NULL,
  `to_date` datetime NOT NULL,
  `note` text NOT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `is_active` int(11) NOT NULL,
  `event_notification_message` text NOT NULL,
  `show_onwebsite` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  KEY `class_id` (`class_id`),
  CONSTRAINT `alumni_events_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `alumni_events_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `alumni_events` (`id`, `title`, `event_for`, `session_id`, `class_id`, `section`, `from_date`, `to_date`, `note`, `photo`, `is_active`, `event_notification_message`, `show_onwebsite`, `created_at`, `updated_at`) VALUES (1, 'annual school', 'all', NULL, NULL, 'null', '2025-06-04 00:00:00', '2025-06-10 23:59:00', '', '', 0, '', 0, '2025-06-13 14:19:06', '2025-06-13 14:19:06');


#
# TABLE STRUCTURE FOR: alumni_students
#

DROP TABLE IF EXISTS `alumni_students`;

CREATE TABLE `alumni_students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `current_email` varchar(255) NOT NULL,
  `current_phone` varchar(255) NOT NULL,
  `occupation` text NOT NULL,
  `address` text NOT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `alumni_students_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `alumni_students` (`id`, `student_id`, `photo`, `created_at`, `current_email`, `current_phone`, `occupation`, `address`, `updated_at`) VALUES (1, 1, NULL, '2025-06-05 13:17:16', 'ar0362698@gmail.com', '9131411409', 'IAS', 'industry house indore', '2025-06-05 13:17:16');


#
# TABLE STRUCTURE FOR: annual_calendar
#

DROP TABLE IF EXISTS `annual_calendar`;

CREATE TABLE `annual_calendar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) DEFAULT NULL,
  `holiday_type` int(11) NOT NULL,
  `from_date` datetime DEFAULT NULL,
  `to_date` datetime DEFAULT NULL,
  `description` text NOT NULL,
  `is_active` int(11) NOT NULL DEFAULT 1,
  `holiday_color` varchar(200) NOT NULL,
  `front_site` int(11) NOT NULL DEFAULT 0,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `annual_calendar_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `annual_calendar` (`id`, `session_id`, `holiday_type`, `from_date`, `to_date`, `description`, `is_active`, `holiday_color`, `front_site`, `created_by`, `created_at`, `updated_at`) VALUES (1, 19, 1, '2025-04-27 00:00:00', '2025-04-27 23:59:00', 'Sunday', 1, '#008000', 1, 2, '2025-04-26 09:30:16', '2025-04-26 10:30:16');
INSERT INTO `annual_calendar` (`id`, `session_id`, `holiday_type`, `from_date`, `to_date`, `description`, `is_active`, `holiday_color`, `front_site`, `created_by`, `created_at`, `updated_at`) VALUES (2, 19, 1, '2025-06-02 00:00:00', '2025-06-04 23:59:00', 'civil holiday', 1, '#008000', 0, 1, '2025-06-13 06:56:44', '2025-06-13 07:56:44');
INSERT INTO `annual_calendar` (`id`, `session_id`, `holiday_type`, `from_date`, `to_date`, `description`, `is_active`, `holiday_color`, `front_site`, `created_by`, `created_at`, `updated_at`) VALUES (3, 19, 2, '2025-06-03 00:00:00', '2025-06-12 23:59:00', 'eid holiday', 1, '#008000', 0, 1, '2025-06-13 06:57:48', '2025-06-13 07:57:48');
INSERT INTO `annual_calendar` (`id`, `session_id`, `holiday_type`, `from_date`, `to_date`, `description`, `is_active`, `holiday_color`, `front_site`, `created_by`, `created_at`, `updated_at`) VALUES (4, 19, 3, '2025-05-22 00:00:00', '2025-06-29 23:59:00', 'diwali holiday', 1, '#008000', 0, 1, '2025-06-13 06:58:23', '2025-06-13 07:58:23');


#
# TABLE STRUCTURE FOR: assessment_results
#

DROP TABLE IF EXISTS `assessment_results`;

CREATE TABLE `assessment_results` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `assessment_id` int(11) NOT NULL,
  `attendance` varchar(255) NOT NULL,
  `get_marks` varchar(255) NOT NULL,
  `month` varchar(255) NOT NULL,
  `created_at` int(11) NOT NULL,
  `updated_at` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=828 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (1, 91, 1, 'present', '3', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (2, 69, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (3, 97, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (4, 84, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (5, 76, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (6, 70, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (7, 98, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (8, 83, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (9, 75, 1, 'present', '3', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (10, 1518, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (11, 1512, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (12, 1509, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (13, 88, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (14, 93, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (15, 74, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (16, 79, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (17, 96, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (18, 94, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (19, 72, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (20, 82, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (21, 85, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (22, 92, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (23, 86, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (24, 89, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (25, 67, 1, 'present', '2', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (26, 80, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (27, 90, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (28, 78, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (29, 87, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (30, 71, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (31, 73, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (32, 81, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (33, 77, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (34, 68, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (35, 1515, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (36, 1519, 1, 'present', '4', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (37, 1516, 1, 'absent', '0', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (38, 1520, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (39, 1510, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (40, 1513, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (41, 95, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (42, 1514, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (43, 1511, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (44, 1508, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (45, 1517, 1, 'present', '5', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (46, 91, 1, 'present', '8', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (47, 69, 1, 'present', '12', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (48, 97, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (49, 84, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (50, 76, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (51, 70, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (52, 98, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (53, 83, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (54, 75, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (55, 1518, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (56, 1512, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (57, 1509, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (58, 88, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (59, 93, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (60, 74, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (61, 79, 1, 'present', '12', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (62, 96, 1, 'present', '13', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (63, 94, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (64, 72, 1, 'present', '16', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (65, 82, 1, 'present', '17', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (66, 85, 1, 'present', '11', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (67, 92, 1, 'present', '19', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (68, 86, 1, 'present', '18', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (69, 89, 1, 'present', '12', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (70, 67, 1, 'present', '20', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (71, 80, 1, 'present', '12', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (72, 90, 1, 'present', '14', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (73, 78, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (74, 87, 1, 'present', '16', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (75, 71, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (76, 73, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (77, 81, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (78, 77, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (79, 68, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (80, 1515, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (81, 1521, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (82, 1519, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (83, 1516, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (84, 1520, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (85, 1510, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (86, 1513, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (87, 95, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (88, 1514, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (89, 1511, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (90, 1508, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (91, 1517, 1, 'present', '15', '06', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (92, 91, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (93, 69, 2, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (94, 97, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (95, 84, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (96, 76, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (97, 70, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (98, 98, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (99, 83, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (100, 75, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (101, 1518, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (102, 1512, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (103, 1509, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (104, 88, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (105, 93, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (106, 74, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (107, 79, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (108, 96, 2, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (109, 94, 2, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (110, 72, 2, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (111, 82, 2, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (112, 85, 2, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (113, 92, 2, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (114, 86, 2, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (115, 89, 2, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (116, 67, 2, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (117, 80, 2, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (118, 90, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (119, 78, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (120, 87, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (121, 71, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (122, 73, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (123, 81, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (124, 77, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (125, 68, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (126, 1515, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (127, 1521, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (128, 1519, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (129, 1516, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (130, 1520, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (131, 1510, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (132, 1513, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (133, 95, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (134, 1514, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (135, 1511, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (136, 1508, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (137, 1517, 2, 'present', '8', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (138, 91, 3, 'absent', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (139, 69, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (140, 97, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (141, 84, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (142, 76, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (143, 70, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (144, 98, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (145, 83, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (146, 75, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (147, 1518, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (148, 1512, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (149, 1509, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (150, 88, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (151, 93, 3, 'absent', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (152, 74, 3, 'absent', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (153, 79, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (154, 96, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (155, 94, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (156, 72, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (157, 82, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (158, 85, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (159, 92, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (160, 86, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (161, 89, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (162, 67, 3, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (163, 80, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (164, 90, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (165, 78, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (166, 87, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (167, 71, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (168, 73, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (169, 81, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (170, 77, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (171, 68, 3, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (172, 1515, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (173, 1521, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (174, 1519, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (175, 1516, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (176, 1520, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (177, 1510, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (178, 1513, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (179, 95, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (180, 1514, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (181, 1511, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (182, 1508, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (183, 1517, 3, 'absent', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (184, 91, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (185, 69, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (186, 97, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (187, 84, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (188, 76, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (189, 70, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (190, 98, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (191, 83, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (192, 75, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (193, 1518, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (194, 1512, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (195, 1509, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (196, 88, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (197, 93, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (198, 74, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (199, 79, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (200, 96, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (201, 94, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (202, 72, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (203, 82, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (204, 85, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (205, 92, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (206, 86, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (207, 89, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (208, 67, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (209, 80, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (210, 90, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (211, 78, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (212, 87, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (213, 71, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (214, 73, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (215, 81, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (216, 77, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (217, 68, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (218, 1515, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (219, 1521, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (220, 1519, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (221, 1516, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (222, 1520, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (223, 1510, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (224, 1513, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (225, 95, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (226, 1514, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (227, 1511, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (228, 1508, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (229, 1517, 5, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (230, 91, 6, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (231, 69, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (232, 97, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (233, 84, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (234, 76, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (235, 70, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (236, 98, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (237, 83, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (238, 75, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (239, 1518, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (240, 1512, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (241, 1509, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (242, 88, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (243, 93, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (244, 74, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (245, 79, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (246, 96, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (247, 94, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (248, 72, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (249, 82, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (250, 85, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (251, 92, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (252, 86, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (253, 89, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (254, 67, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (255, 80, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (256, 90, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (257, 78, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (258, 87, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (259, 71, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (260, 73, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (261, 81, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (262, 77, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (263, 68, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (264, 1515, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (265, 1521, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (266, 1519, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (267, 1516, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (268, 1520, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (269, 1510, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (270, 1513, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (271, 95, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (272, 1514, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (273, 1511, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (274, 1508, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (275, 1517, 6, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (276, 91, 7, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (277, 69, 7, 'present', '12', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (278, 97, 7, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (279, 84, 7, 'absent', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (280, 76, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (281, 70, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (282, 98, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (283, 83, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (284, 75, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (285, 1518, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (286, 1512, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (287, 1509, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (288, 88, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (289, 93, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (290, 74, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (291, 79, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (292, 96, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (293, 94, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (294, 72, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (295, 82, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (296, 85, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (297, 92, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (298, 86, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (299, 89, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (300, 67, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (301, 80, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (302, 90, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (303, 78, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (304, 87, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (305, 71, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (306, 73, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (307, 81, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (308, 77, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (309, 68, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (310, 1515, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (311, 1521, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (312, 1519, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (313, 1516, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (314, 1520, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (315, 1510, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (316, 1513, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (317, 95, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (318, 1514, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (319, 1511, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (320, 1508, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (321, 1517, 7, 'present', '10', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (322, 91, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (323, 69, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (324, 97, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (325, 84, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (326, 76, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (327, 70, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (328, 98, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (329, 83, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (330, 75, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (331, 1518, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (332, 1512, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (333, 1509, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (334, 88, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (335, 93, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (336, 74, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (337, 79, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (338, 96, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (339, 94, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (340, 72, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (341, 82, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (342, 85, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (343, 92, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (344, 86, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (345, 89, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (346, 67, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (347, 80, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (348, 90, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (349, 78, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (350, 87, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (351, 71, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (352, 73, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (353, 81, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (354, 77, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (355, 68, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (356, 1515, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (357, 1521, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (358, 1519, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (359, 1516, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (360, 1520, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (361, 1510, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (362, 1513, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (363, 95, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (364, 1514, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (365, 1511, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (366, 1508, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (367, 1517, 8, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (368, 91, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (369, 69, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (370, 97, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (371, 84, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (372, 76, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (373, 70, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (374, 98, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (375, 83, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (376, 75, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (377, 1518, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (378, 1512, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (379, 1509, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (380, 88, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (381, 93, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (382, 74, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (383, 79, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (384, 96, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (385, 94, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (386, 72, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (387, 82, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (388, 85, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (389, 92, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (390, 86, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (391, 89, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (392, 67, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (393, 80, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (394, 90, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (395, 78, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (396, 87, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (397, 71, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (398, 73, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (399, 81, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (400, 77, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (401, 68, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (402, 1515, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (403, 1521, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (404, 1519, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (405, 1516, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (406, 1520, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (407, 1510, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (408, 1513, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (409, 95, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (410, 1514, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (411, 1511, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (412, 1508, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (413, 1517, 9, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (414, 91, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (415, 69, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (416, 97, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (417, 84, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (418, 76, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (419, 70, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (420, 98, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (421, 83, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (422, 75, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (423, 1518, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (424, 1512, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (425, 1509, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (426, 88, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (427, 93, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (428, 74, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (429, 79, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (430, 96, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (431, 94, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (432, 72, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (433, 82, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (434, 85, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (435, 92, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (436, 86, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (437, 89, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (438, 67, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (439, 80, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (440, 90, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (441, 78, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (442, 87, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (443, 71, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (444, 73, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (445, 81, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (446, 77, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (447, 68, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (448, 1515, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (449, 1521, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (450, 1519, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (451, 1516, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (452, 1520, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (453, 1510, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (454, 1513, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (455, 95, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (456, 1514, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (457, 1511, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (458, 1508, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (459, 1517, 10, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (460, 91, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (461, 69, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (462, 97, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (463, 84, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (464, 76, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (465, 70, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (466, 98, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (467, 83, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (468, 75, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (469, 1518, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (470, 1512, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (471, 1509, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (472, 88, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (473, 93, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (474, 74, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (475, 79, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (476, 96, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (477, 94, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (478, 72, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (479, 82, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (480, 85, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (481, 92, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (482, 86, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (483, 89, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (484, 67, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (485, 80, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (486, 90, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (487, 78, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (488, 87, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (489, 71, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (490, 73, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (491, 81, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (492, 77, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (493, 68, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (494, 1515, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (495, 1521, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (496, 1519, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (497, 1516, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (498, 1520, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (499, 1510, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (500, 1513, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (501, 95, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (502, 1514, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (503, 1511, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (504, 1508, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (505, 1517, 11, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (506, 91, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (507, 69, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (508, 97, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (509, 84, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (510, 76, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (511, 70, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (512, 98, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (513, 83, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (514, 75, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (515, 1518, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (516, 1512, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (517, 1509, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (518, 88, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (519, 93, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (520, 74, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (521, 79, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (522, 96, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (523, 94, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (524, 72, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (525, 82, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (526, 85, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (527, 92, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (528, 86, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (529, 89, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (530, 67, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (531, 80, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (532, 90, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (533, 78, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (534, 87, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (535, 71, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (536, 73, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (537, 81, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (538, 77, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (539, 68, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (540, 1515, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (541, 1521, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (542, 1519, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (543, 1516, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (544, 1520, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (545, 1510, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (546, 1513, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (547, 95, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (548, 1514, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (549, 1511, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (550, 1508, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (551, 1517, 12, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (552, 91, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (553, 69, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (554, 97, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (555, 84, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (556, 76, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (557, 70, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (558, 98, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (559, 83, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (560, 75, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (561, 1518, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (562, 1512, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (563, 1509, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (564, 88, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (565, 93, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (566, 74, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (567, 79, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (568, 96, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (569, 94, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (570, 72, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (571, 82, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (572, 85, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (573, 92, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (574, 86, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (575, 89, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (576, 67, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (577, 80, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (578, 90, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (579, 78, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (580, 87, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (581, 71, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (582, 73, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (583, 81, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (584, 77, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (585, 68, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (586, 1515, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (587, 1521, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (588, 1519, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (589, 1516, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (590, 1520, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (591, 1510, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (592, 1513, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (593, 95, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (594, 1514, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (595, 1511, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (596, 1508, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (597, 1517, 13, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (598, 91, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (599, 69, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (600, 97, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (601, 84, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (602, 76, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (603, 70, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (604, 98, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (605, 83, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (606, 75, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (607, 1518, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (608, 1512, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (609, 1509, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (610, 88, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (611, 93, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (612, 74, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (613, 79, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (614, 96, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (615, 94, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (616, 72, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (617, 82, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (618, 85, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (619, 92, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (620, 86, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (621, 89, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (622, 67, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (623, 80, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (624, 90, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (625, 78, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (626, 87, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (627, 71, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (628, 73, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (629, 81, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (630, 77, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (631, 68, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (632, 1515, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (633, 1521, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (634, 1519, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (635, 1516, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (636, 1520, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (637, 1510, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (638, 1513, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (639, 95, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (640, 1514, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (641, 1511, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (642, 1508, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (643, 1517, 14, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (644, 91, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (645, 69, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (646, 97, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (647, 84, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (648, 76, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (649, 70, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (650, 98, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (651, 83, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (652, 75, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (653, 1518, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (654, 1512, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (655, 1509, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (656, 88, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (657, 93, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (658, 74, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (659, 79, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (660, 96, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (661, 94, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (662, 72, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (663, 82, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (664, 85, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (665, 92, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (666, 86, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (667, 89, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (668, 67, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (669, 80, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (670, 90, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (671, 78, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (672, 87, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (673, 71, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (674, 73, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (675, 81, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (676, 77, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (677, 68, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (678, 1515, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (679, 1521, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (680, 1519, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (681, 1516, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (682, 1520, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (683, 1510, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (684, 1513, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (685, 95, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (686, 1514, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (687, 1511, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (688, 1508, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (689, 1517, 15, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (690, 91, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (691, 69, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (692, 97, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (693, 84, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (694, 76, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (695, 70, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (696, 98, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (697, 83, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (698, 75, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (699, 1518, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (700, 1512, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (701, 1509, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (702, 88, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (703, 93, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (704, 74, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (705, 79, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (706, 96, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (707, 94, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (708, 72, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (709, 82, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (710, 85, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (711, 92, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (712, 86, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (713, 89, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (714, 67, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (715, 80, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (716, 90, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (717, 78, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (718, 87, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (719, 71, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (720, 73, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (721, 81, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (722, 77, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (723, 68, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (724, 1515, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (725, 1521, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (726, 1519, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (727, 1516, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (728, 1520, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (729, 1510, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (730, 1513, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (731, 95, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (732, 1514, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (733, 1511, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (734, 1508, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (735, 1517, 16, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (736, 91, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (737, 69, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (738, 97, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (739, 84, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (740, 76, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (741, 70, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (742, 98, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (743, 83, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (744, 75, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (745, 1518, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (746, 1512, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (747, 1509, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (748, 88, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (749, 93, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (750, 74, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (751, 79, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (752, 96, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (753, 94, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (754, 72, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (755, 82, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (756, 85, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (757, 92, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (758, 86, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (759, 89, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (760, 67, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (761, 80, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (762, 90, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (763, 78, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (764, 87, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (765, 71, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (766, 73, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (767, 81, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (768, 77, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (769, 68, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (770, 1515, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (771, 1521, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (772, 1519, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (773, 1516, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (774, 1520, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (775, 1510, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (776, 1513, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (777, 95, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (778, 1514, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (779, 1511, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (780, 1508, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (781, 1517, 17, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (782, 91, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (783, 69, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (784, 97, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (785, 84, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (786, 76, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (787, 70, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (788, 98, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (789, 83, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (790, 75, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (791, 1518, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (792, 1512, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (793, 1509, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (794, 88, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (795, 93, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (796, 74, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (797, 79, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (798, 96, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (799, 94, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (800, 72, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (801, 82, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (802, 85, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (803, 92, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (804, 86, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (805, 89, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (806, 67, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (807, 80, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (808, 90, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (809, 78, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (810, 87, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (811, 71, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (812, 73, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (813, 81, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (814, 77, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (815, 68, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (816, 1515, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (817, 1521, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (818, 1519, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (819, 1516, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (820, 1520, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (821, 1510, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (822, 1513, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (823, 95, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (824, 1514, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (825, 1511, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (826, 1508, 18, 'present', '15', '01', 0, 0);
INSERT INTO `assessment_results` (`id`, `student_id`, `assessment_id`, `attendance`, `get_marks`, `month`, `created_at`, `updated_at`) VALUES (827, 1517, 18, 'present', '15', '01', 0, 0);


#
# TABLE STRUCTURE FOR: assessment_types
#

DROP TABLE IF EXISTS `assessment_types`;

CREATE TABLE `assessment_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `assessment_min_marks` varchar(255) NOT NULL,
  `assessment_max_marks` varchar(255) NOT NULL,
  `term_exam_out_of_marks` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `assessment_types` (`id`, `type`, `assessment_min_marks`, `assessment_max_marks`, `term_exam_out_of_marks`, `description`, `status`, `created_at`, `updated_at`) VALUES (1, 'test', '', '', '', 'testing', 3, '2024-10-01 09:57:03', '2024-10-01 10:16:49');
INSERT INTO `assessment_types` (`id`, `type`, `assessment_min_marks`, `assessment_max_marks`, `term_exam_out_of_marks`, `description`, `status`, `created_at`, `updated_at`) VALUES (2, 'Homework', '7', '20', '5', '', 1, '2024-10-01 10:24:43', '2025-03-13 09:24:40');
INSERT INTO `assessment_types` (`id`, `type`, `assessment_min_marks`, `assessment_max_marks`, `term_exam_out_of_marks`, `description`, `status`, `created_at`, `updated_at`) VALUES (3, 'Worksheet', '7', '20', '5', 'Worksheet', 1, '2025-03-06 08:14:52', '2025-03-29 13:23:32');
INSERT INTO `assessment_types` (`id`, `type`, `assessment_min_marks`, `assessment_max_marks`, `term_exam_out_of_marks`, `description`, `status`, `created_at`, `updated_at`) VALUES (4, 'SEA', '', '', '', '', 1, '2025-03-06 08:27:10', NULL);
INSERT INTO `assessment_types` (`id`, `type`, `assessment_min_marks`, `assessment_max_marks`, `term_exam_out_of_marks`, `description`, `status`, `created_at`, `updated_at`) VALUES (5, 'N-Book', '', '', '', '', 1, '2025-03-06 08:27:30', NULL);
INSERT INTO `assessment_types` (`id`, `type`, `assessment_min_marks`, `assessment_max_marks`, `term_exam_out_of_marks`, `description`, `status`, `created_at`, `updated_at`) VALUES (6, 'Class Work', '7', '20', '5', '', 1, '2025-03-06 08:27:40', '2025-03-30 20:27:48');
INSERT INTO `assessment_types` (`id`, `type`, `assessment_min_marks`, `assessment_max_marks`, `term_exam_out_of_marks`, `description`, `status`, `created_at`, `updated_at`) VALUES (7, 'test', '45', '54', '100', '', 1, '2025-06-16 05:50:16', NULL);


#
# TABLE STRUCTURE FOR: assessments
#

DROP TABLE IF EXISTS `assessments`;

CREATE TABLE `assessments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `subject_group_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `assessment_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `status` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (1, 6, 18, 20, 1, 1, 2, 'HW1', 1, '2024-10-02 11:20:00', '2025-03-12 06:58:26');
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (2, 6, 18, 20, 1, 1, 2, 'HW2', 1, '2024-10-02 11:20:00', '2025-03-12 06:58:59');
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (3, 6, 18, 20, 1, 1, 3, 'WS-1', 1, '2025-03-29 10:32:50', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (4, 6, 18, 20, 1, 1, 3, 'WS-2', 1, '2025-03-29 10:32:50', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (7, 6, 18, 20, 1, 2, 2, 'HW3', 1, '2025-04-08 10:47:27', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (8, 6, 18, 20, 1, 2, 2, 'HW4', 1, '2025-04-08 10:47:27', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (9, 6, 18, 20, 1, 2, 3, 'HW5', 1, '2025-04-08 10:48:34', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (10, 6, 18, 20, 1, 2, 3, 'HW6', 1, '2025-04-08 10:48:34', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (13, 6, 18, 20, 1, 4, 2, 'HW7', 1, '2025-04-08 10:51:11', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (14, 6, 18, 20, 1, 4, 2, 'HW8', 1, '2025-04-08 10:51:11', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (15, 6, 18, 20, 1, 4, 3, 'WS3', 1, '2025-04-08 10:52:03', NULL);
INSERT INTO `assessments` (`id`, `subject_group_id`, `session_id`, `class_id`, `section_id`, `subject_id`, `assessment_type_id`, `name`, `status`, `created_at`, `updated_at`) VALUES (16, 6, 18, 20, 1, 4, 3, 'WS4', 1, '2025-04-08 10:52:03', NULL);


#
# TABLE STRUCTURE FOR: attendence_type
#

DROP TABLE IF EXISTS `attendence_type`;

CREATE TABLE `attendence_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `key_value` varchar(50) NOT NULL,
  `long_lang_name` varchar(250) DEFAULT NULL,
  `long_name_style` varchar(250) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `for_qr_attendance` int(11) NOT NULL DEFAULT 1,
  `for_schedule` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `for_schedule`, `created_at`, `updated_at`) VALUES (1, 'Present', '<b class=\"text text-success\">P</b>', 'present', 'label label-success', 'yes', 1, 1, '2023-12-13 07:53:10', '0000-00-00 00:00:00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `for_schedule`, `created_at`, `updated_at`) VALUES (2, 'Late With Excuse', '<b class=\"text text-warning\">E</b>', 'late_with_excuse', 'label label-warning text-dark', 'no', 0, 0, '2023-12-13 07:51:03', '0000-00-00 00:00:00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `for_schedule`, `created_at`, `updated_at`) VALUES (3, 'Late', '<b class=\"text text-warning\">L</b>', 'late', 'label label-warning text-dark', 'yes', 1, 1, '2023-12-13 07:51:09', '0000-00-00 00:00:00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `for_schedule`, `created_at`, `updated_at`) VALUES (4, 'Absent', '<b class=\"text text-danger\">A</b>', 'absent', 'label label-danger', 'yes', 0, 0, '2023-12-15 06:18:05', '0000-00-00 00:00:00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `for_schedule`, `created_at`, `updated_at`) VALUES (5, 'Holiday', 'H', 'holiday', 'label label-info', 'yes', 0, 0, '2023-12-14 12:57:13', '0000-00-00 00:00:00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `long_lang_name`, `long_name_style`, `is_active`, `for_qr_attendance`, `for_schedule`, `created_at`, `updated_at`) VALUES (6, 'Half Day', '<b class=\"text text-warning\">F</b>', 'half_day', 'label label-warning text-dark', 'yes', 1, 1, '2023-12-15 06:18:37', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: aws_s3_settings
#

DROP TABLE IF EXISTS `aws_s3_settings`;

CREATE TABLE `aws_s3_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `api_key` varchar(250) DEFAULT NULL,
  `api_secret` varchar(250) DEFAULT NULL,
  `bucket_name` varchar(250) DEFAULT NULL,
  `region` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `aws_s3_settings` (`id`, `api_key`, `api_secret`, `bucket_name`, `region`) VALUES (1, '34', 'attu', '112', '12');


#
# TABLE STRUCTURE FOR: bank_details
#

DROP TABLE IF EXISTS `bank_details`;

CREATE TABLE `bank_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_number` varchar(255) NOT NULL,
  `bank_name` varchar(255) NOT NULL,
  `branch_name` varchar(255) NOT NULL,
  `ac_holder_name` varchar(255) NOT NULL,
  `ifsc_code` varchar(255) NOT NULL,
  `is_primary` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `bank_details` (`id`, `account_number`, `bank_name`, `branch_name`, `ac_holder_name`, `ifsc_code`, `is_primary`, `status`, `created_at`, `updated_at`) VALUES (1, '032411011003', 'bank of india', 'BODA', 'asr', 'BKID009959', '', '1', '2024-07-19 18:32:19', '2024-07-23 16:44:32');
INSERT INTO `bank_details` (`id`, `account_number`, `bank_name`, `branch_name`, `ac_holder_name`, `ifsc_code`, `is_primary`, `status`, `created_at`, `updated_at`) VALUES (2, '03211100023', '', 'bkid009969', 'Ashok Singh Rajput', 'bkid009969', 'on', '1', '2024-07-19 18:34:02', '2024-07-19 21:08:25');
INSERT INTO `bank_details` (`id`, `account_number`, `bank_name`, `branch_name`, `ac_holder_name`, `ifsc_code`, `is_primary`, `status`, `created_at`, `updated_at`) VALUES (3, '098765433', '', 'india', 'ashok', 'bkdir3435', '', '1', '2024-07-19 18:34:45', NULL);


#
# TABLE STRUCTURE FOR: behaviour_settings
#

DROP TABLE IF EXISTS `behaviour_settings`;

CREATE TABLE `behaviour_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `comment_option` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `behaviour_settings` (`id`, `comment_option`, `created_at`) VALUES (1, '[\"student\",\"parent\"]', '2022-12-31 06:19:38');


#
# TABLE STRUCTURE FOR: book_issues
#

DROP TABLE IF EXISTS `book_issues`;

CREATE TABLE `book_issues` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `book_id` int(11) NOT NULL,
  `member_id` int(11) DEFAULT NULL,
  `duereturn_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `is_returned` int(11) DEFAULT 0,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `book_id` (`book_id`),
  KEY `member_id` (`member_id`),
  CONSTRAINT `book_issues_ibfk_1` FOREIGN KEY (`book_id`) REFERENCES `books` (`id`) ON DELETE CASCADE,
  CONSTRAINT `book_issues_ibfk_2` FOREIGN KEY (`member_id`) REFERENCES `libarary_members` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: books
#

DROP TABLE IF EXISTS `books`;

CREATE TABLE `books` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `book_title` varchar(100) NOT NULL,
  `book_no` varchar(50) NOT NULL,
  `isbn_no` varchar(100) NOT NULL,
  `subject` varchar(100) DEFAULT NULL,
  `rack_no` varchar(100) NOT NULL,
  `publish` varchar(100) DEFAULT NULL,
  `author` varchar(100) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `perunitcost` float(10,2) DEFAULT NULL,
  `postdate` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `available` varchar(10) DEFAULT 'yes',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: captcha
#

DROP TABLE IF EXISTS `captcha`;

CREATE TABLE `captcha` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`, `updated_at`) VALUES (1, 'userlogin', 0, '2021-01-19 08:10:29', '2025-04-09 22:52:05');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`, `updated_at`) VALUES (2, 'login', 0, '2021-01-19 08:10:31', '2025-04-09 22:52:05');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`, `updated_at`) VALUES (3, 'admission', 0, '2021-01-19 04:48:11', '2025-04-09 22:52:05');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`, `updated_at`) VALUES (4, 'complain', 0, '2021-01-19 04:48:13', '2025-04-09 22:52:05');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`, `updated_at`) VALUES (5, 'contact_us', 0, '2021-01-19 04:48:15', '2025-04-09 22:52:05');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`, `updated_at`) VALUES (6, 'guest_login_signup', 0, '2022-12-07 01:41:31', '2025-04-09 23:03:30');


#
# TABLE STRUCTURE FOR: categories
#

DROP TABLE IF EXISTS `categories`;

CREATE TABLE `categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(100) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'GENERAL', 'no', '2025-04-15 20:23:40', '2025-04-15 20:23:40');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'OBC', 'no', '2025-04-15 20:23:45', '2025-04-15 20:23:45');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'SC', 'no', '2025-04-15 20:23:48', '2025-04-15 20:23:48');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'ST', 'no', '2025-04-15 20:23:52', '2025-04-15 20:23:52');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'SBC', 'no', '2025-04-15 20:23:54', '2025-04-15 20:23:54');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'VJNT', 'no', '2025-04-15 20:23:57', '2025-04-15 20:23:57');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'NT-B', 'no', '2025-04-15 20:24:00', '2025-04-15 20:24:00');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'NT-C', 'no', '2025-04-15 20:24:02', '2025-04-15 20:24:02');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'NT-D', 'no', '2025-04-15 20:24:07', '2025-04-15 20:24:07');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'NBC', 'no', '2025-04-15 20:24:11', '2025-04-15 20:24:11');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'MINORITY', 'no', '2025-04-15 20:24:14', '2025-04-15 20:24:14');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'OPEN', 'no', '2025-04-15 20:25:01', '2025-04-15 20:25:01');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'ibc', 'no', '2025-06-11 15:01:52', '2025-06-11 15:01:52');


#
# TABLE STRUCTURE FOR: cbse_exam_assessment_types
#

DROP TABLE IF EXISTS `cbse_exam_assessment_types`;

CREATE TABLE `cbse_exam_assessment_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_assessment_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `code` varchar(100) NOT NULL,
  `maximum_marks` float NOT NULL,
  `pass_percentage` float NOT NULL,
  `description` mediumtext NOT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `cbse_exam_assessment_id` (`cbse_exam_assessment_id`),
  KEY `idx_name` (`name`),
  KEY `idx_code` (`code`),
  CONSTRAINT `cbse_exam_assessment_types_ibfk_1` FOREIGN KEY (`cbse_exam_assessment_id`) REFERENCES `cbse_exam_assessments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_exam_assessments
#

DROP TABLE IF EXISTS `cbse_exam_assessments`;

CREATE TABLE `cbse_exam_assessments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_exam_class_sections
#

DROP TABLE IF EXISTS `cbse_exam_class_sections`;

CREATE TABLE `cbse_exam_class_sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_id` int(11) NOT NULL,
  `class_section_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `class_section_id` (`class_section_id`),
  KEY `cbse_exam_id` (`cbse_exam_id`),
  CONSTRAINT `cbse_exam_class_sections_ibfk_1` FOREIGN KEY (`class_section_id`) REFERENCES `class_sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_exam_class_sections_ibfk_2` FOREIGN KEY (`cbse_exam_id`) REFERENCES `cbse_exams` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_exam_grades
#

DROP TABLE IF EXISTS `cbse_exam_grades`;

CREATE TABLE `cbse_exam_grades` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_exam_grades_range
#

DROP TABLE IF EXISTS `cbse_exam_grades_range`;

CREATE TABLE `cbse_exam_grades_range` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_grade_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `minimum_percentage` float NOT NULL,
  `maximum_percentage` float NOT NULL,
  `description` mediumtext NOT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `cbse_exam_grade_id` (`cbse_exam_grade_id`),
  KEY `idx_name` (`name`),
  CONSTRAINT `cbse_exam_grades_range_ibfk_1` FOREIGN KEY (`cbse_exam_grade_id`) REFERENCES `cbse_exam_grades` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_exam_group_class_batch_exam_students
#

DROP TABLE IF EXISTS `cbse_exam_group_class_batch_exam_students`;

CREATE TABLE `cbse_exam_group_class_batch_exam_students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_class_batch_exam_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `student_session_id` int(11) NOT NULL,
  `roll_no` varchar(255) NOT NULL DEFAULT '0',
  `teacher_remark` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `is_active` int(11) NOT NULL DEFAULT 0,
  `exam_seat_no` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_session_id` (`student_session_id`),
  KEY `student_id` (`student_id`),
  KEY `exam_group_class_batch_exam_id` (`exam_group_class_batch_exam_id`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (50, 6, 91, 112, '0', '', 0, NULL, '2025-03-07 08:45:14', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (51, 6, 69, 90, '0', '', 0, NULL, '2025-03-07 08:45:14', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (52, 7, 91, 112, '0', '', 0, NULL, '2025-03-11 10:54:46', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (53, 7, 69, 90, '0', '', 0, NULL, '2025-03-11 10:54:46', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (54, 7, 97, 118, '0', '', 0, NULL, '2025-03-11 10:54:46', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (55, 8, 91, 112, '0', '', 0, NULL, '2025-04-08 10:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (56, 8, 69, 90, '0', '', 0, NULL, '2025-04-08 10:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (57, 8, 97, 118, '0', '', 0, NULL, '2025-04-08 10:35:25', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (58, 9, 91, 112, '0', '', 0, NULL, '2025-04-08 10:38:48', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (59, 9, 69, 90, '0', '', 0, NULL, '2025-04-08 10:38:48', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (60, 9, 97, 118, '0', '', 0, NULL, '2025-04-08 10:38:48', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (61, 10, 1, 1, '0', '', 0, NULL, '2025-05-17 23:48:56', NULL);
INSERT INTO `cbse_exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `is_active`, `exam_seat_no`, `created_at`, `updated_at`) VALUES (62, 11, 1, 1, '0', '', 0, NULL, '2025-05-17 23:51:33', NULL);


#
# TABLE STRUCTURE FOR: cbse_exam_group_class_batch_exam_subjects
#

DROP TABLE IF EXISTS `cbse_exam_group_class_batch_exam_subjects`;

CREATE TABLE `cbse_exam_group_class_batch_exam_subjects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_class_batch_exams_id` int(11) DEFAULT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `class_id` int(11) DEFAULT NULL,
  `section_id` int(11) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `time_from` time DEFAULT NULL,
  `duration` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `room_no` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `mark_entry_type` int(11) DEFAULT NULL,
  `max_marks` float(10,2) DEFAULT NULL,
  `min_marks` float(10,2) DEFAULT NULL,
  `credit_hours` float(10,2) DEFAULT NULL,
  `date_to` datetime DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `exam_group_class_batch_exams_id` (`exam_group_class_batch_exams_id`),
  KEY `subject_id` (`subject_id`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (72, 12, 1, 1, 1, '2025-05-20', '00:00:00', '', '', NULL, '80.00', '40.00', '0.00', NULL, 0, '2025-05-20 12:47:31', '2025-05-20 12:55:18');
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (73, 12, 2, 1, 1, '2025-05-20', '00:00:00', '', '', NULL, '80.00', '0.00', '0.00', NULL, 0, '2025-05-20 12:47:31', '2025-05-20 12:55:18');
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (74, 12, 3, 1, 1, '2025-05-20', '00:00:00', '', '', NULL, '80.00', '0.00', '0.00', NULL, 0, '2025-05-20 12:47:31', '2025-05-20 12:55:18');
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (75, 12, 4, 1, 1, '2025-05-20', '00:00:00', '', '', NULL, '80.00', '0.00', '0.00', NULL, 0, '2025-05-20 12:47:31', '2025-05-20 12:55:18');
INSERT INTO `cbse_exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `mark_entry_type`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (76, 12, 5, 1, 1, '2025-05-20', '00:00:00', '', '', NULL, '80.00', '0.00', '0.00', NULL, 0, '2025-05-20 12:47:31', '2025-05-20 12:55:18');


#
# TABLE STRUCTURE FOR: cbse_exam_group_class_batch_exams
#

DROP TABLE IF EXISTS `cbse_exam_group_class_batch_exams`;

CREATE TABLE `cbse_exam_group_class_batch_exams` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam` varchar(255) DEFAULT NULL,
  `session_id` int(11) NOT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `exam_group_id` int(11) NOT NULL,
  `use_exam_roll_no` varchar(255) NOT NULL DEFAULT '1',
  `is_termexam` varchar(255) NOT NULL DEFAULT 'no',
  `is_publish` int(11) NOT NULL DEFAULT 0,
  `is_active` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `exam_group_id` (`exam_group_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `cbse_exam_group_class_batch_exams` (`id`, `exam`, `session_id`, `date_from`, `date_to`, `description`, `exam_group_id`, `use_exam_roll_no`, `is_termexam`, `is_publish`, `is_active`, `created_at`, `updated_at`) VALUES (12, 'loewew', 19, NULL, NULL, 'faddfa', 3, '1', 'yes', 0, 0, '2025-05-20 09:32:31', NULL);


#
# TABLE STRUCTURE FOR: cbse_exam_group_exam_results
#

DROP TABLE IF EXISTS `cbse_exam_group_exam_results`;

CREATE TABLE `cbse_exam_group_exam_results` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_class_batch_exam_student_id` int(11) NOT NULL,
  `exam_group_class_batch_exam_subject_id` int(11) NOT NULL,
  `attendence` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `get_marks` float(10,2) DEFAULT 0.00,
  `term_marks` varchar(255) DEFAULT NULL,
  `get_grade` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `assessment_type_marks` text DEFAULT NULL,
  `previous_exammarks` varchar(255) DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  `is_active` int(11) NOT NULL DEFAULT 0,
  `exam_group_student_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `exam_group_class_batch_exam_student_id` (`exam_group_class_batch_exam_student_id`),
  KEY `exam_group_class_batch_exam_subject_id` (`exam_group_class_batch_exam_subject_id`),
  KEY `exam_group_student_id` (`exam_group_student_id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (13, 50, 5, 'present', '30.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '5', 0, 0, '2025-03-11 10:22:52', '2025-03-13 08:25:50');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (14, 51, 5, 'present', '30.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '14', 0, 0, '2025-03-11 10:22:52', '2025-03-13 08:26:16');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (15, 52, 7, 'present', '64.38', '50', NULL, '[{\"assessment_type_id\":\"2\",\"assessment_type_mark\":\"1.63\"},{\"assessment_type_id\":\"3\",\"assessment_type_mark\":\"2.50\"}]', '{\"previous_exam_id\":\"6\",\"previous_exam_marks\":\"7.50\"}', '', 0, 0, '2025-03-13 07:14:34', '2025-04-17 00:21:19');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (16, 53, 7, 'present', '76.01', '60', NULL, '[{\"assessment_type_id\":\"2\",\"assessment_type_mark\":\"2.13\"},{\"assessment_type_id\":\"3\",\"assessment_type_mark\":\"3.00\"}]', '{\"previous_exam_id\":\"6\",\"previous_exam_marks\":\"7.50\"}', '', 0, 0, '2025-03-13 07:14:34', '2025-04-17 00:21:36');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (17, 54, 7, 'present', '78.26', '70', NULL, '[{\"assessment_type_id\":\"2\",\"assessment_type_mark\":\"1.88\"},{\"assessment_type_id\":\"3\",\"assessment_type_mark\":\"3.00\"}]', '{\"previous_exam_id\":\"6\",\"previous_exam_marks\":\"-\"}', '', 0, 0, '2025-03-13 07:14:34', '2025-04-17 00:20:51');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (18, 50, 6, 'present', '30.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-03-21 10:07:32', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (19, 51, 6, 'present', '35.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-03-21 10:07:32', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (20, 52, 8, 'present', '68.75', '50', NULL, '[{\"assessment_type_id\":\"2\",\"assessment_type_mark\":\"3.75\"},{\"assessment_type_id\":\"3\",\"assessment_type_mark\":\"3.75\"}]', '{\"previous_exam_id\":\"6\",\"previous_exam_marks\":\"7.50\"}', '', 0, 0, '2025-03-21 10:14:12', '2025-04-17 00:22:26');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (21, 53, 8, 'present', '79.63', '60', NULL, '[{\"assessment_type_id\":\"2\",\"assessment_type_mark\":\"3.38\"},{\"assessment_type_id\":\"3\",\"assessment_type_mark\":\"3.75\"}]', '{\"previous_exam_id\":\"6\",\"previous_exam_marks\":\"8.75\"}', '', 0, 0, '2025-03-21 10:14:12', '2025-04-17 00:22:43');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (22, 54, 8, 'present', '11.25', '', NULL, '[{\"assessment_type_id\":\"2\",\"assessment_type_mark\":\"3.75\"},{\"assessment_type_id\":\"3\",\"assessment_type_mark\":\"3.75\"}]', '{\"previous_exam_id\":\"6\",\"previous_exam_marks\":\"-\"}', '', 0, 0, '2025-03-21 10:14:12', '2025-04-17 00:21:06');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (23, 55, 9, 'present', '10.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-04-08 10:36:48', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (24, 56, 9, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-04-08 10:36:48', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (25, 57, 9, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-04-08 10:36:48', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (26, 55, 10, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-04-08 10:37:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (27, 56, 10, 'present', '14.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-04-08 10:37:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (28, 57, 10, 'present', '12.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-04-08 10:37:17', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (29, 55, 11, 'present', '10.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-04-08 10:37:39', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (30, 56, 11, 'present', '9.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-04-08 10:37:39', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (31, 57, 11, 'present', '8.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-04-08 10:37:39', NULL);
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (32, 58, 12, 'present', '71.88', '60', NULL, '[{\"assessment_type_id\":\"2\",\"assessment_type_mark\":\"1.63\"},{\"assessment_type_id\":\"3\",\"assessment_type_mark\":\"2.50\"}]', '{\"previous_exam_id\":\"8\",\"previous_exam_marks\":\"5.00\"}', '', 0, 0, '2025-04-08 10:45:05', '2025-04-17 00:23:57');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (33, 59, 12, 'present', '84.51', '70', NULL, '[{\"assessment_type_id\":\"2\",\"assessment_type_mark\":\"2.13\"},{\"assessment_type_id\":\"3\",\"assessment_type_mark\":\"3.00\"}]', '{\"previous_exam_id\":\"8\",\"previous_exam_marks\":\"6.00\"}', '', 0, 0, '2025-04-08 10:45:05', '2025-04-17 00:24:22');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (34, 60, 12, 'present', '65.76', '50', NULL, '[{\"assessment_type_id\":\"2\",\"assessment_type_mark\":\"1.88\"},{\"assessment_type_id\":\"3\",\"assessment_type_mark\":\"3.00\"}]', '{\"previous_exam_id\":\"8\",\"previous_exam_marks\":\"7.50\"}', '', 0, 0, '2025-04-08 10:45:05', '2025-04-17 00:25:20');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (35, 58, 13, 'present', '67.25', '50', NULL, '[{\"assessment_type_id\":\"2\",\"assessment_type_mark\":\"3.75\"},{\"assessment_type_id\":\"3\",\"assessment_type_mark\":\"3.75\"}]', '{\"previous_exam_id\":\"8\",\"previous_exam_marks\":\"6.00\"}', '', 0, 0, '2025-04-08 11:10:52', '2025-04-17 00:24:42');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (36, 59, 13, 'present', '77.88', '60', NULL, '[{\"assessment_type_id\":\"2\",\"assessment_type_mark\":\"3.38\"},{\"assessment_type_id\":\"3\",\"assessment_type_mark\":\"3.75\"}]', '{\"previous_exam_id\":\"8\",\"previous_exam_marks\":\"7.00\"}', '', 0, 0, '2025-04-08 11:10:52', '2025-04-17 00:25:00');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (37, 60, 13, 'present', '87.25', '70', NULL, '[{\"assessment_type_id\":\"2\",\"assessment_type_mark\":\"3.75\"},{\"assessment_type_id\":\"3\",\"assessment_type_mark\":\"3.75\"},{\"assessment_type_id\":\"6\",\"assessment_type_mark\":\"3.75\"}]', '{\"previous_exam_id\":\"8\",\"previous_exam_marks\":\"6.00\"}', '', 0, 0, '2025-04-08 11:10:52', '2025-04-16 01:26:34');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (38, 58, 14, 'present', '76.25', '60', NULL, '[{\"assessment_type_id\":\"2\",\"assessment_type_mark\":\"3.75\"},{\"assessment_type_id\":\"3\",\"assessment_type_mark\":\"3.75\"},{\"assessment_type_id\":\"6\",\"assessment_type_mark\":\"3.75\"}]', '{\"previous_exam_id\":\"8\",\"previous_exam_marks\":\"5.00\"}', '', 0, 0, '2025-04-08 11:11:30', '2025-04-16 01:26:53');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (39, 59, 14, 'present', '55.75', '40', NULL, '[{\"assessment_type_id\":\"2\",\"assessment_type_mark\":\"3.75\"},{\"assessment_type_id\":\"3\",\"assessment_type_mark\":\"3.75\"}]', '{\"previous_exam_id\":\"8\",\"previous_exam_marks\":\"4.50\"}', '', 0, 0, '2025-04-08 11:11:30', '2025-04-17 00:23:42');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (40, 60, 14, 'present', '75.25', '60', NULL, '[{\"assessment_type_id\":\"2\",\"assessment_type_mark\":\"3.75\"},{\"assessment_type_id\":\"3\",\"assessment_type_mark\":\"3.75\"}]', '{\"previous_exam_id\":\"8\",\"previous_exam_marks\":\"4.00\"}', '', 0, 0, '2025-04-08 11:11:30', '2025-04-17 00:23:22');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (41, 61, 15, 'present', '10.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', 'test', 0, 0, '2025-05-17 23:50:02', '2025-05-18 00:00:59');
INSERT INTO `cbse_exam_group_exam_results` (`id`, `exam_group_class_batch_exam_student_id`, `exam_group_class_batch_exam_subject_id`, `attendence`, `get_marks`, `term_marks`, `get_grade`, `assessment_type_marks`, `previous_exammarks`, `note`, `is_active`, `exam_group_student_id`, `created_at`, `updated_at`) VALUES (42, 61, 16, 'present', '15.00', NULL, NULL, '[]', '{\"previous_exam_id\":null,\"previous_exam_marks\":null}', '', 0, 0, '2025-05-17 23:50:22', NULL);


#
# TABLE STRUCTURE FOR: cbse_exam_groups
#

DROP TABLE IF EXISTS `cbse_exam_groups`;

CREATE TABLE `cbse_exam_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `exam_type` varchar(255) NOT NULL,
  `description` varchar(1000) DEFAULT NULL,
  `is_active` int(11) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `cbse_exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Term-2', 'basic_system', '', 0, '2025-04-08 10:33:29', NULL);
INSERT INTO `cbse_exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'Term1', 'basic_system', '', 0, '2025-05-17 23:47:44', NULL);
INSERT INTO `cbse_exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'test', 'basic_system', 'erwe', 0, '2025-05-27 18:44:30', NULL);
INSERT INTO `cbse_exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'attiu', 'school_grade_system', '', 0, '2025-06-11 13:55:17', NULL);
INSERT INTO `cbse_exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'as', 'school_grade_system', '', 0, '2025-06-11 13:55:36', NULL);
INSERT INTO `cbse_exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'winter', 'school_grade_system', '', 0, '2025-06-16 05:48:09', NULL);
INSERT INTO `cbse_exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'Ashfaq', 'coll_grade_system', '', 0, '2025-06-16 05:49:22', NULL);
INSERT INTO `cbse_exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'attar', 'average_passing', '', 0, '2025-06-16 05:49:35', NULL);
INSERT INTO `cbse_exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'attar', 'basic_system', '', 0, '2025-06-16 05:49:46', NULL);
INSERT INTO `cbse_exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (12, 'attar', 'basic_system', '', 0, '2025-06-16 05:49:46', NULL);


#
# TABLE STRUCTURE FOR: cbse_exam_observations
#

DROP TABLE IF EXISTS `cbse_exam_observations`;

CREATE TABLE `cbse_exam_observations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_exam_student_subject_rank
#

DROP TABLE IF EXISTS `cbse_exam_student_subject_rank`;

CREATE TABLE `cbse_exam_student_subject_rank` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_template_id` int(11) DEFAULT NULL,
  `student_session_id` int(11) DEFAULT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `rank` int(11) DEFAULT NULL,
  `rank_percentage` float(10,2) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `cbse_template_id` (`cbse_template_id`),
  KEY `student_session_id` (`student_session_id`),
  KEY `subject_id` (`subject_id`),
  KEY `idx_rank` (`rank`),
  CONSTRAINT `cbse_exam_student_subject_rank_ibfk_1` FOREIGN KEY (`cbse_template_id`) REFERENCES `cbse_template` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_exam_student_subject_rank_ibfk_2` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_exam_student_subject_rank_ibfk_3` FOREIGN KEY (`subject_id`) REFERENCES `subjects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_exam_students
#

DROP TABLE IF EXISTS `cbse_exam_students`;

CREATE TABLE `cbse_exam_students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_id` int(11) NOT NULL,
  `student_session_id` int(11) NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `roll_no` varchar(20) DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `total_present_days` int(11) DEFAULT NULL,
  `delete_student_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `cbse_exam_id` (`cbse_exam_id`),
  KEY `student_session_id` (`student_session_id`),
  CONSTRAINT `cbse_exam_students_ibfk_1` FOREIGN KEY (`cbse_exam_id`) REFERENCES `cbse_exams` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_exam_students_ibfk_2` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_exam_timetable
#

DROP TABLE IF EXISTS `cbse_exam_timetable`;

CREATE TABLE `cbse_exam_timetable` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_id` int(11) DEFAULT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `date` date NOT NULL,
  `time_from` time NOT NULL,
  `time_to` time NOT NULL,
  `duration` int(11) NOT NULL,
  `room_no` varchar(255) NOT NULL,
  `is_written` int(1) NOT NULL DEFAULT 1,
  `written_maximum_marks` float NOT NULL,
  `is_practical` int(1) NOT NULL,
  `practical_maximum_mark` float DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `cbse_exam_id` (`cbse_exam_id`),
  KEY `subject_id` (`subject_id`),
  CONSTRAINT `cbse_exam_timetable_ibfk_1` FOREIGN KEY (`cbse_exam_id`) REFERENCES `cbse_exams` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_exam_timetable_ibfk_2` FOREIGN KEY (`subject_id`) REFERENCES `subjects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_exam_timetable_assessment_types
#

DROP TABLE IF EXISTS `cbse_exam_timetable_assessment_types`;

CREATE TABLE `cbse_exam_timetable_assessment_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_timetable_id` int(11) DEFAULT NULL,
  `cbse_exam_assessment_type_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `cbse_exam_timetable_id` (`cbse_exam_timetable_id`),
  KEY `cbse_exam_assessment_type_id` (`cbse_exam_assessment_type_id`),
  CONSTRAINT `cbse_exam_timetable_assessment_types_ibfk_1` FOREIGN KEY (`cbse_exam_timetable_id`) REFERENCES `cbse_exam_timetable` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_exam_timetable_assessment_types_ibfk_2` FOREIGN KEY (`cbse_exam_assessment_type_id`) REFERENCES `cbse_exam_assessment_types` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_exams
#

DROP TABLE IF EXISTS `cbse_exams`;

CREATE TABLE `cbse_exams` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `total_working_days` int(11) DEFAULT 0,
  `cbse_term_id` int(11) DEFAULT NULL,
  `cbse_exam_assessment_id` int(11) DEFAULT NULL,
  `cbse_exam_grade_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `exam_code` varchar(200) DEFAULT NULL,
  `session_id` int(11) NOT NULL,
  `description` mediumtext NOT NULL,
  `is_publish` int(1) NOT NULL,
  `is_active` int(1) NOT NULL,
  `created_by` int(11) DEFAULT NULL,
  `use_exam_roll_no` int(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `cbse_term_id` (`cbse_term_id`),
  KEY `cbse_exam_grade_id` (`cbse_exam_grade_id`),
  KEY `cbse_exam_assessment_id` (`cbse_exam_assessment_id`),
  KEY `session_id` (`session_id`),
  KEY `idx_name` (`name`),
  KEY `idx_exam_code` (`exam_code`),
  CONSTRAINT `cbse_exams_ibfk_1` FOREIGN KEY (`cbse_term_id`) REFERENCES `cbse_terms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_exams_ibfk_2` FOREIGN KEY (`cbse_exam_grade_id`) REFERENCES `cbse_exam_grades` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_exams_ibfk_3` FOREIGN KEY (`cbse_exam_assessment_id`) REFERENCES `cbse_exam_assessments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_exams_ibfk_4` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_marksheet_type
#

DROP TABLE IF EXISTS `cbse_marksheet_type`;

CREATE TABLE `cbse_marksheet_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `short_code` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`),
  KEY `idx_short_code` (`short_code`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `cbse_marksheet_type` (`id`, `name`, `short_code`) VALUES (1, 'All Terms', 'all_term');
INSERT INTO `cbse_marksheet_type` (`id`, `name`, `short_code`) VALUES (2, 'Term Wise', 'term_wise');
INSERT INTO `cbse_marksheet_type` (`id`, `name`, `short_code`) VALUES (3, 'Single Exam Without Term', 'exam_wise');
INSERT INTO `cbse_marksheet_type` (`id`, `name`, `short_code`) VALUES (4, 'Multiple Exams Without Term', 'without_term');


#
# TABLE STRUCTURE FOR: cbse_observation_class_section
#

DROP TABLE IF EXISTS `cbse_observation_class_section`;

CREATE TABLE `cbse_observation_class_section` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_observation_parameter_id` int(11) NOT NULL,
  `class_section_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_observation_parameters
#

DROP TABLE IF EXISTS `cbse_observation_parameters`;

CREATE TABLE `cbse_observation_parameters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_observation_subparameter
#

DROP TABLE IF EXISTS `cbse_observation_subparameter`;

CREATE TABLE `cbse_observation_subparameter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_observation_id` int(11) NOT NULL,
  `cbse_observation_parameter_id` int(11) NOT NULL,
  `maximum_marks` float NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `cbse_observation_parameter_id_ibfk_1` (`cbse_observation_parameter_id`),
  KEY `cbse_exam_observation_id_ibfk_1` (`cbse_exam_observation_id`),
  CONSTRAINT `cbse_exam_observation_id_ibfk_1` FOREIGN KEY (`cbse_exam_observation_id`) REFERENCES `cbse_exam_observations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_observation_parameter_id_ibfk_1` FOREIGN KEY (`cbse_observation_parameter_id`) REFERENCES `cbse_observation_parameters` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_observation_term_student_subparameter
#

DROP TABLE IF EXISTS `cbse_observation_term_student_subparameter`;

CREATE TABLE `cbse_observation_term_student_subparameter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_ovservation_term_id` int(11) DEFAULT NULL,
  `cbse_observation_subparameter_id` int(11) DEFAULT NULL,
  `student_session_id` int(11) DEFAULT NULL,
  `obtain_marks` float(10,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `cbse_observation_term_student_subparameter_ibfk_1` (`cbse_ovservation_term_id`),
  KEY `cbse_observation_subparameter_id` (`cbse_observation_subparameter_id`),
  KEY `student_session_id` (`student_session_id`),
  CONSTRAINT `cbse_observation_term_student_subparameter_ibfk_1` FOREIGN KEY (`cbse_ovservation_term_id`) REFERENCES `cbse_observation_terms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_observation_term_student_subparameter_ibfk_2` FOREIGN KEY (`cbse_observation_subparameter_id`) REFERENCES `cbse_observation_subparameter` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_observation_term_student_subparameter_ibfk_3` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_observation_terms
#

DROP TABLE IF EXISTS `cbse_observation_terms`;

CREATE TABLE `cbse_observation_terms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_observation_id` int(11) NOT NULL,
  `cbse_term_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cbse_term_id` (`cbse_term_id`),
  KEY `cbse_ovservation_terms_ibfk_3` (`session_id`),
  KEY `cbse_exam_observations_ibfk_1` (`cbse_exam_observation_id`),
  CONSTRAINT `cbse_exam_observations_ibfk_1` FOREIGN KEY (`cbse_exam_observation_id`) REFERENCES `cbse_exam_observations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_observation_terms_ibfk_2` FOREIGN KEY (`cbse_term_id`) REFERENCES `cbse_terms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_observation_terms_ibfk_3` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_student_exam_ranks
#

DROP TABLE IF EXISTS `cbse_student_exam_ranks`;

CREATE TABLE `cbse_student_exam_ranks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_id` int(11) NOT NULL,
  `student_session_id` int(11) DEFAULT NULL,
  `rank` int(11) DEFAULT NULL,
  `rank_percentage` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `cbse_exam_id` (`cbse_exam_id`),
  KEY `student_session_id` (`student_session_id`),
  KEY `idx_rank` (`rank`),
  KEY `idx_rank_percentage` (`rank_percentage`),
  CONSTRAINT `cbse_student_exam_ranks_ibfk_1` FOREIGN KEY (`cbse_exam_id`) REFERENCES `cbse_exams` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_student_exam_ranks_ibfk_2` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_student_subject_marks
#

DROP TABLE IF EXISTS `cbse_student_subject_marks`;

CREATE TABLE `cbse_student_subject_marks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_timetable_assessment_type_id` int(11) NOT NULL,
  `cbse_exam_timetable_id` int(11) DEFAULT NULL,
  `cbse_exam_student_id` int(11) DEFAULT NULL,
  `cbse_exam_assessment_type_id` int(11) DEFAULT NULL,
  `is_absent` int(1) NOT NULL DEFAULT 0,
  `marks` float(10,2) DEFAULT 0.00,
  `note` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `cbse_exam_timetable_id` (`cbse_exam_timetable_id`),
  KEY `cbse_exam_student_id` (`cbse_exam_student_id`),
  KEY `cbse_exam_assessment_type_id` (`cbse_exam_assessment_type_id`),
  KEY `cbse_exam_timetable_assessment_type_ibfk_4` (`cbse_exam_timetable_assessment_type_id`),
  CONSTRAINT `cbse_exam_timetable_assessment_type_ibfk_4` FOREIGN KEY (`cbse_exam_timetable_assessment_type_id`) REFERENCES `cbse_exam_timetable_assessment_types` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_student_subject_marks_ibfk_1` FOREIGN KEY (`cbse_exam_timetable_id`) REFERENCES `cbse_exam_timetable` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_student_subject_marks_ibfk_2` FOREIGN KEY (`cbse_exam_student_id`) REFERENCES `cbse_exam_students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_student_subject_marks_ibfk_3` FOREIGN KEY (`cbse_exam_assessment_type_id`) REFERENCES `cbse_exam_assessment_types` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_student_subject_result
#

DROP TABLE IF EXISTS `cbse_student_subject_result`;

CREATE TABLE `cbse_student_subject_result` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_exam_timetable_id` int(11) DEFAULT NULL,
  `cbse_exam_student_id` int(11) DEFAULT NULL,
  `note` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_student_template_rank
#

DROP TABLE IF EXISTS `cbse_student_template_rank`;

CREATE TABLE `cbse_student_template_rank` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_template_id` int(11) DEFAULT NULL,
  `student_session_id` int(11) DEFAULT NULL,
  `rank` int(20) DEFAULT NULL,
  `rank_percentage` float(10,2) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_session_id` (`student_session_id`),
  KEY `cbse_template_id` (`cbse_template_id`),
  KEY `idx_rank` (`rank`),
  KEY `idx_rank_percentage` (`rank_percentage`),
  CONSTRAINT `cbse_student_template_rank_ibfk_1` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_student_template_rank_ibfk_2` FOREIGN KEY (`cbse_template_id`) REFERENCES `cbse_template` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_template
#

DROP TABLE IF EXISTS `cbse_template`;

CREATE TABLE `cbse_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `orientation` varchar(1) NOT NULL DEFAULT 'P',
  `description` varchar(255) NOT NULL,
  `gradeexam_id` int(11) DEFAULT NULL,
  `remarkexam_id` int(11) DEFAULT NULL,
  `is_weightage` varchar(10) NOT NULL,
  `marksheet_type` varchar(50) NOT NULL,
  `created_by` int(11) NOT NULL,
  `header_image` varbinary(500) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `left_logo` varchar(200) DEFAULT NULL,
  `right_logo` varchar(200) DEFAULT NULL,
  `exam_name` varchar(200) DEFAULT NULL,
  `school_name` varchar(200) DEFAULT NULL,
  `exam_center` varchar(200) DEFAULT NULL,
  `session_id` int(11) NOT NULL,
  `left_sign` varchar(200) DEFAULT NULL,
  `middle_sign` varchar(200) DEFAULT NULL,
  `right_sign` varchar(200) DEFAULT NULL,
  `background_img` varchar(200) DEFAULT NULL,
  `content` text DEFAULT NULL,
  `content_footer` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  `is_name` int(1) DEFAULT 1,
  `is_father_name` int(1) DEFAULT 1,
  `is_mother_name` int(1) DEFAULT 1,
  `exam_session` int(1) DEFAULT 1,
  `is_admission_no` int(1) DEFAULT 1,
  `is_division` int(1) NOT NULL DEFAULT 1,
  `is_roll_no` int(1) DEFAULT 1,
  `is_photo` int(1) DEFAULT 1,
  `is_class` int(1) NOT NULL DEFAULT 0,
  `is_section` int(1) NOT NULL DEFAULT 0,
  `is_dob` int(1) DEFAULT 1,
  `is_remark` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `cbse_template_ibfk_3` (`session_id`),
  KEY `cbse_template_ibfk_1` (`gradeexam_id`),
  KEY `cbse_template_ibfk_2` (`remarkexam_id`),
  KEY `idx_name` (`name`),
  KEY `idx_marksheet_type` (`marksheet_type`),
  KEY `idx_exam_name` (`exam_name`),
  KEY `idx_school_name` (`school_name`),
  CONSTRAINT `cbse_template_ibfk_1` FOREIGN KEY (`gradeexam_id`) REFERENCES `cbse_exams` (`id`) ON DELETE SET NULL,
  CONSTRAINT `cbse_template_ibfk_2` FOREIGN KEY (`remarkexam_id`) REFERENCES `cbse_exams` (`id`) ON DELETE SET NULL,
  CONSTRAINT `cbse_template_ibfk_3` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_template_class_sections
#

DROP TABLE IF EXISTS `cbse_template_class_sections`;

CREATE TABLE `cbse_template_class_sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_template_id` int(11) NOT NULL,
  `class_section_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `cbse_template_id` (`cbse_template_id`),
  KEY `class_section_id` (`class_section_id`),
  CONSTRAINT `cbse_template_class_sections_ibfk_1` FOREIGN KEY (`cbse_template_id`) REFERENCES `cbse_template` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_template_class_sections_ibfk_2` FOREIGN KEY (`class_section_id`) REFERENCES `class_sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_template_term_exams
#

DROP TABLE IF EXISTS `cbse_template_term_exams`;

CREATE TABLE `cbse_template_term_exams` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_template_term_id` int(11) DEFAULT NULL,
  `cbse_exam_id` int(11) NOT NULL,
  `cbse_template_id` int(11) NOT NULL,
  `weightage` float NOT NULL DEFAULT 100,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `cbse_template_term_id` (`cbse_template_term_id`),
  KEY `cbse_template_term_exams_ibfk_3` (`cbse_exam_id`),
  KEY `cbse_template_term_exams_ibfk_4` (`cbse_template_id`),
  KEY `idx_weightage` (`weightage`),
  CONSTRAINT `cbse_template_term_exams_ibfk_1` FOREIGN KEY (`cbse_exam_id`) REFERENCES `cbse_exams` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_template_term_exams_ibfk_2` FOREIGN KEY (`cbse_template_term_id`) REFERENCES `cbse_template_terms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_template_term_exams_ibfk_4` FOREIGN KEY (`cbse_template_id`) REFERENCES `cbse_template` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_template_terms
#

DROP TABLE IF EXISTS `cbse_template_terms`;

CREATE TABLE `cbse_template_terms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cbse_template_id` int(11) NOT NULL,
  `cbse_term_id` int(11) NOT NULL,
  `weightage` float NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `cbse_template_id` (`cbse_template_id`),
  KEY `cbse_term_id` (`cbse_term_id`),
  KEY `idx_weightage` (`weightage`),
  CONSTRAINT `cbse_template_terms_ibfk_1` FOREIGN KEY (`cbse_template_id`) REFERENCES `cbse_template` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cbse_template_terms_ibfk_2` FOREIGN KEY (`cbse_term_id`) REFERENCES `cbse_terms` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cbse_terms
#

DROP TABLE IF EXISTS `cbse_terms`;

CREATE TABLE `cbse_terms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `term_code` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`),
  KEY `idx_term_code` (`term_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cert_settings
#

DROP TABLE IF EXISTS `cert_settings`;

CREATE TABLE `cert_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cert_type` varchar(200) DEFAULT NULL,
  `inst_type` varchar(200) DEFAULT NULL,
  `cert_auto_insert` varchar(200) DEFAULT NULL,
  `cert_prefix` varchar(200) DEFAULT NULL,
  `cert_start_from` varchar(200) DEFAULT NULL,
  `cert_no_digit` varchar(200) DEFAULT NULL,
  `cert_update_status` varchar(200) DEFAULT NULL,
  `created_by` int(10) DEFAULT NULL,
  `created_ts` timestamp NULL DEFAULT current_timestamp(),
  `updated_ts` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `cert_settings` (`id`, `cert_type`, `inst_type`, `cert_auto_insert`, `cert_prefix`, `cert_start_from`, `cert_no_digit`, `cert_update_status`, `created_by`, `created_ts`, `updated_ts`) VALUES (1, 'cert_leaving', 'primary', '1', '2324', '1', '4', '1', 1, '2020-06-27 11:24:13', '2024-05-22 12:23:43');
INSERT INTO `cert_settings` (`id`, `cert_type`, `inst_type`, `cert_auto_insert`, `cert_prefix`, `cert_start_from`, `cert_no_digit`, `cert_update_status`, `created_by`, `created_ts`, `updated_ts`) VALUES (2, 'cert_leaving', 'secondary', '1', '2324', '0001', '4', '0', 1, '2020-07-02 13:30:58', '2024-06-12 01:52:10');
INSERT INTO `cert_settings` (`id`, `cert_type`, `inst_type`, `cert_auto_insert`, `cert_prefix`, `cert_start_from`, `cert_no_digit`, `cert_update_status`, `created_by`, `created_ts`, `updated_ts`) VALUES (3, 'cert_bonafide', 'primary', '1', '2324', '0001', '4', '1', 1, '2023-10-22 12:10:27', '2023-10-22 04:40:51');
INSERT INTO `cert_settings` (`id`, `cert_type`, `inst_type`, `cert_auto_insert`, `cert_prefix`, `cert_start_from`, `cert_no_digit`, `cert_update_status`, `created_by`, `created_ts`, `updated_ts`) VALUES (4, 'cert_bonafide', 'secondary', '1', '2324', '0001', '4', '1', 1, '2023-10-22 12:11:09', '2023-10-22 04:43:32');
INSERT INTO `cert_settings` (`id`, `cert_type`, `inst_type`, `cert_auto_insert`, `cert_prefix`, `cert_start_from`, `cert_no_digit`, `cert_update_status`, `created_by`, `created_ts`, `updated_ts`) VALUES (5, 'cert_bonafide', 'higher_secondary', '1', '2324', '0001', '4', '1', 1, '2023-10-22 12:11:26', '2023-10-22 04:43:41');
INSERT INTO `cert_settings` (`id`, `cert_type`, `inst_type`, `cert_auto_insert`, `cert_prefix`, `cert_start_from`, `cert_no_digit`, `cert_update_status`, `created_by`, `created_ts`, `updated_ts`) VALUES (6, 'cert_entry', 'primary', '1', '2324', '0001', '4', '1', 1, '2023-10-22 12:11:45', NULL);
INSERT INTO `cert_settings` (`id`, `cert_type`, `inst_type`, `cert_auto_insert`, `cert_prefix`, `cert_start_from`, `cert_no_digit`, `cert_update_status`, `created_by`, `created_ts`, `updated_ts`) VALUES (7, 'cert_entry', 'secondary', '1', '2324', '0001', '4', '1', 1, '2023-10-22 12:12:06', NULL);
INSERT INTO `cert_settings` (`id`, `cert_type`, `inst_type`, `cert_auto_insert`, `cert_prefix`, `cert_start_from`, `cert_no_digit`, `cert_update_status`, `created_by`, `created_ts`, `updated_ts`) VALUES (8, 'cert_leaving', 'higher_secondary', '1', '2324', '0001', '4', '1', 1, '2023-10-22 12:12:52', NULL);
INSERT INTO `cert_settings` (`id`, `cert_type`, `inst_type`, `cert_auto_insert`, `cert_prefix`, `cert_start_from`, `cert_no_digit`, `cert_update_status`, `created_by`, `created_ts`, `updated_ts`) VALUES (9, 'fees_entry', '', '1', '202425', '001', '3', '1', 1, '2025-05-17 01:34:13', NULL);


#
# TABLE STRUCTURE FOR: certificatecounts
#

DROP TABLE IF EXISTS `certificatecounts`;

CREATE TABLE `certificatecounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `certificate` varchar(100) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `sessionid` varchar(255) NOT NULL,
  `created_at` varchar(40) DEFAULT NULL,
  `updated_at` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=320 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (11, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (13, 1, 'Bonafied', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (14, 1, 'Entry', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (16, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (17, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (18, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (19, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (20, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (21, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (22, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (23, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (24, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (25, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (26, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (27, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (28, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (29, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (30, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (31, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (32, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (33, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (34, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (35, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (36, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (37, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (38, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (39, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (40, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (41, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (42, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (43, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (44, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (45, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (46, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (47, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (48, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (49, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (50, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (51, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (52, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (53, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (54, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (55, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (56, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (57, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (58, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (59, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (60, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (61, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (62, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (63, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (64, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (65, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (66, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (67, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (68, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (69, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (70, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (71, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (72, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (73, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (74, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (75, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (76, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (77, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (78, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (79, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (80, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (81, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (82, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (83, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (84, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (85, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (86, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (87, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (88, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (89, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (90, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (91, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (92, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (93, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (94, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (95, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (96, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (97, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (98, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (99, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (100, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (101, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (102, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (103, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (104, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (105, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (106, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (107, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (108, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (109, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (110, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (111, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (112, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (113, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (114, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (115, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (116, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (117, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (118, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (119, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (120, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (121, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (122, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (123, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (124, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (125, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (126, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (127, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (128, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (129, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (130, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (131, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (132, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (133, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (134, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (135, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (136, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (137, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (138, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (139, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (140, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (141, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (142, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (143, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (144, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (145, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (146, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (147, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (148, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (149, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (150, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (151, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (152, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (153, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (154, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (155, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (156, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (157, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (158, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (159, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (160, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (161, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (162, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (163, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (164, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (165, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (166, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (167, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (168, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (169, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (170, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (171, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (172, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (173, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (174, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (175, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (176, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (177, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (178, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (179, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (180, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (181, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (182, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (183, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (184, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (185, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (186, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (187, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (188, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (189, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (190, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (191, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (192, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (193, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (194, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (195, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (196, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (197, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (198, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (199, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (200, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (201, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (202, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (203, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (204, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (205, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (206, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (207, 1, 'Leaving', 1, '', '27-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (208, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (209, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (210, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (211, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (212, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (213, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (214, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (215, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (216, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (217, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (218, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (219, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (220, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (221, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (222, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (223, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (224, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (225, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (226, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (227, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (228, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (229, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (230, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (231, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (232, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (233, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (234, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (235, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (236, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (237, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (238, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (239, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (240, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (241, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (242, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (243, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (244, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (245, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (246, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (247, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (248, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (249, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (250, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (251, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (252, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (253, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (254, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (255, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (256, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (257, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (258, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (259, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (260, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (261, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (262, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (263, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (264, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (265, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (266, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (267, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (268, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (269, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (270, 1, 'Leaving', 1, '', '29-05-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (271, 2, 'Leaving', 1, '', '02-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (272, 2, 'Leaving', 1, '', '02-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (273, 2, 'Leaving', 1, '', '02-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (274, 2, 'Leaving', 1, '', '02-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (275, 2, 'Leaving', 1, '', '02-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (276, 2, 'Leaving', 1, '', '02-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (277, 2, 'Leaving', 1, '', '02-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (278, 2, 'Leaving', 1, '', '02-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (279, 2, 'Leaving', 1, '', '02-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (280, 2, 'Leaving', 1, '', '02-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (281, 2, 'Leaving', 1, '', '02-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (282, 2, 'Leaving', 1, '', '02-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (283, 1, 'Leaving', 1, '', '02-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (284, 1, 'Leaving', 1, '', '02-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (285, 1, 'Leaving', 1, '', '02-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (286, 1, 'Leaving', 1, '', '02-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (287, 1, 'Leaving', 1, '', '02-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (288, 1, 'Leaving', 1, '', '02-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (289, 1, 'Leaving', 1, '', '02-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (290, 1, 'Leaving', 1, '', '02-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (291, 1, 'Leaving', 1, '', '03-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (292, 1, 'Leaving', 1, '', '03-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (293, 1, 'Entry', 1, '', '03-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (294, 1, 'Leaving', 1, '', '05-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (295, 7, 'Leaving', 1, '', '10-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (296, 2, 'Leaving', 1, '', '11-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (297, 1, 'Leaving', 1, '', '11-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (298, 1, 'Leaving', 1, '', '11-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (299, 1, 'Leaving', 1, '', '11-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (300, 1, 'Leaving', 1, '', '11-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (301, 1, 'Leaving', 1, '', '11-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (302, 1, 'Leaving', 1, '', '11-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (303, 1, 'Leaving', 1, '', '11-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (304, 1, 'Leaving', 1, '', '11-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (305, 1, 'Leaving', 1, '', '11-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (306, 1, 'Leaving', 1, '', '11-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (307, 1, 'Leaving', 1, '', '11-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (308, 1, 'Leaving', 1, '', '11-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (309, 1, 'Leaving', 1, '', '11-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (310, 1, 'Leaving', 1, '', '11-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (311, 1, 'Leaving', 1, '', '11-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (312, 1, 'Leaving', 1, '', '11-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (313, 1, 'Leaving', 1, '', '11-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (314, 1, 'Leaving', 1, '', '11-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (315, 66, 'Leaving', 1, '', '21-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (316, 65, 'Bonafied', 1, '', '21-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (317, 74, 'Leaving', 1, '', '21-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (318, 74, 'Leaving', 1, '', '21-06-2025', NULL);
INSERT INTO `certificatecounts` (`id`, `student_id`, `certificate`, `user_id`, `sessionid`, `created_at`, `updated_at`) VALUES (319, 74, 'Bonafied', 1, '', '21-06-2025', NULL);


#
# TABLE STRUCTURE FOR: certificates
#

DROP TABLE IF EXISTS `certificates`;

CREATE TABLE `certificates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `certificate_name` varchar(100) NOT NULL,
  `certificate_text` text NOT NULL,
  `left_header` varchar(100) NOT NULL,
  `center_header` varchar(100) NOT NULL,
  `right_header` varchar(100) NOT NULL,
  `left_footer` varchar(100) NOT NULL,
  `right_footer` varchar(100) NOT NULL,
  `center_footer` varchar(100) NOT NULL,
  `background_image` varchar(100) DEFAULT NULL,
  `created_for` tinyint(1) NOT NULL COMMENT '1 = staff, 2 = students',
  `status` tinyint(1) NOT NULL,
  `header_height` int(11) NOT NULL,
  `content_height` int(11) NOT NULL,
  `footer_height` int(11) NOT NULL,
  `content_width` int(11) NOT NULL,
  `enable_student_image` tinyint(1) NOT NULL COMMENT '0=no,1=yes',
  `enable_image_height` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_student_image`, `enable_image_height`, `created_at`, `updated_at`) VALUES (1, 'Sample Transfer Certificate', 'This is certify that <b>[name]</b> has born on [dob]  <br> and have following details [present_address] [guardian] [created_at] [admission_no] [roll_no] [class] [section] [gender] [admission_date] [category] [cast] [father_name] [mother_name] [religion] [email] [phone] .<br>We wish best of luck for future endeavors.', 'Reff. No.....1111111.........', 'To Whomever It May Concern', 'Date: _10__/_10__/__2019__', '.................................<br>admin', '.................................<br>principal', '.................................<br>admin', 'sampletc121.png', 2, 1, 360, 400, 480, 810, 1, 230, '2019-12-21 15:14:34', '0000-00-00 00:00:00');
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_student_image`, `enable_image_height`, `created_at`, `updated_at`) VALUES (2, 'testing certifiacate', 'manual', '', '', '', '', '', '', 'error', 2, 1, 0, 0, 0, 0, 0, 0, '2025-06-13 13:53:36', '2025-06-13 13:53:36');


#
# TABLE STRUCTURE FOR: changelogs
#

DROP TABLE IF EXISTS `changelogs`;

CREATE TABLE `changelogs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `developerName` varchar(255) NOT NULL,
  `latest_version_name` varchar(255) NOT NULL,
  `current_version` varchar(255) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `status` varchar(255) NOT NULL,
  `note` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `changelogs` (`id`, `developerName`, `latest_version_name`, `current_version`, `type`, `status`, `note`, `created_at`, `updated_at`) VALUES (1, 'anil', 'Version 7.1.0.1', 'Version 7.1.0', 'Bug Fixes', 'Devops Done', 'ewrew', '2025-06-03 21:11:16', '2025-06-03 22:01:36');
INSERT INTO `changelogs` (`id`, `developerName`, `latest_version_name`, `current_version`, `type`, `status`, `note`, `created_at`, `updated_at`) VALUES (3, 'arun', 'Version 7.1.0 DLT 0.0.1', 'Version 7.1.0 ', 'General Changes', 'Deployement Live', '1.Transport fees now working as session wise\n2. In Student Id Card roll number and house name added\n3. In balance fees report mobile number added\n4. Download centre shared content public page design updated\n5. Student and staff barcode/qrcode generate', '2025-06-05 08:08:07', '2025-06-05 08:08:07');
INSERT INTO `changelogs` (`id`, `developerName`, `latest_version_name`, `current_version`, `type`, `status`, `note`, `created_at`, `updated_at`) VALUES (4, 'ashok', 'Version 7.1.0 DLT 0.0.1', 'Version 7.1.0 DLT 0.0.1', 'Feature Enhancement', 'Devops Done', 'Fees Module\r\n\r\n1. Added a new module of College Fees Master\r\n2. Add bank account functionality\r\n3. Added Revert Fees functionality\r\n4. Income head income list and income voucher functionality \r\n5. Expense head expense list and expense voucher functionalit', '2025-06-05 08:17:07', '2025-06-05 08:17:32');
INSERT INTO `changelogs` (`id`, `developerName`, `latest_version_name`, `current_version`, `type`, `status`, `note`, `created_at`, `updated_at`) VALUES (5, 'arun', 'Version 7.1.0 DLT 0.0.1', 'Version 7.1.0', 'Feature Enhancement', 'DeployementLive', '1 Attendance moduel. Added a new module hostal module\n 2 Attendance Report.Added a new moduel for show hostal attendance  \nrecord \n3 Student Deatils :In disabled student show reason of disabled in list why student disabled\n 4 Alumni . Show designation', '2025-06-05 13:13:37', '2025-06-05 13:16:25');
INSERT INTO `changelogs` (`id`, `developerName`, `latest_version_name`, `current_version`, `type`, `status`, `note`, `created_at`, `updated_at`) VALUES (6, 'arun', 'Version 7.1.0 DLT 0.0.1', 'Version 7.1.0', 'Feature Enhancement', 'Devops Done', ' 1 In hostal attendance they want to take student attendance three time   in a day \r\n morning shift  \r\n afternoon shift  \r\n  night shift  \r\n2 also there attendance report according to there shift ', '2025-06-09 13:32:28', '2025-06-09 13:32:28');


#
# TABLE STRUCTURE FOR: chat_connections
#

DROP TABLE IF EXISTS `chat_connections`;

CREATE TABLE `chat_connections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `chat_user_one` int(11) NOT NULL,
  `chat_user_two` int(11) NOT NULL,
  `ip` varchar(30) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `chat_user_one` (`chat_user_one`),
  KEY `chat_user_two` (`chat_user_two`),
  CONSTRAINT `chat_connections_ibfk_1` FOREIGN KEY (`chat_user_one`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_connections_ibfk_2` FOREIGN KEY (`chat_user_two`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `chat_connections` (`id`, `chat_user_one`, `chat_user_two`, `ip`, `time`, `created_at`, `updated_at`) VALUES (1, 1, 2, NULL, NULL, '2025-06-21 10:24:30', '2025-06-21 10:24:30');


#
# TABLE STRUCTURE FOR: chat_messages
#

DROP TABLE IF EXISTS `chat_messages`;

CREATE TABLE `chat_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text DEFAULT NULL,
  `chat_user_id` int(11) NOT NULL,
  `ip` varchar(30) NOT NULL,
  `time` int(11) NOT NULL,
  `is_first` int(11) DEFAULT 0,
  `is_read` int(11) NOT NULL DEFAULT 0,
  `chat_connection_id` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `chat_user_id` (`chat_user_id`),
  KEY `chat_connection_id` (`chat_connection_id`),
  CONSTRAINT `chat_messages_ibfk_1` FOREIGN KEY (`chat_user_id`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_messages_ibfk_2` FOREIGN KEY (`chat_connection_id`) REFERENCES `chat_connections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `chat_messages` (`id`, `message`, `chat_user_id`, `ip`, `time`, `is_first`, `is_read`, `chat_connection_id`, `created_at`, `updated_at`) VALUES (1, 'you are now connected on chat', 2, '', 0, 1, 0, 1, NULL, '2025-06-21 10:24:30');
INSERT INTO `chat_messages` (`id`, `message`, `chat_user_id`, `ip`, `time`, `is_first`, `is_read`, `chat_connection_id`, `created_at`, `updated_at`) VALUES (2, 'hi', 2, '', 0, 0, 0, 1, '2025-06-21 14:54:33', '2025-06-21 10:24:33');


#
# TABLE STRUCTURE FOR: chat_users
#

DROP TABLE IF EXISTS `chat_users`;

CREATE TABLE `chat_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_type` varchar(20) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `create_staff_id` int(11) DEFAULT NULL,
  `create_student_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `student_id` (`student_id`),
  KEY `create_staff_id` (`create_staff_id`),
  KEY `create_student_id` (`create_student_id`),
  CONSTRAINT `chat_users_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_3` FOREIGN KEY (`create_staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_4` FOREIGN KEY (`create_student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `chat_users` (`id`, `user_type`, `staff_id`, `student_id`, `create_staff_id`, `create_student_id`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'staff', 1, NULL, NULL, NULL, 0, '2025-06-21 10:24:30', '2025-06-21 10:24:30');
INSERT INTO `chat_users` (`id`, `user_type`, `staff_id`, `student_id`, `create_staff_id`, `create_student_id`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'student', NULL, 1, 1, NULL, 0, '2025-06-21 10:24:30', '2025-06-21 10:24:30');


#
# TABLE STRUCTURE FOR: class_section_times
#

DROP TABLE IF EXISTS `class_section_times`;

CREATE TABLE `class_section_times` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_section_id` int(11) DEFAULT NULL,
  `time` time DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `class_section_id` (`class_section_id`),
  CONSTRAINT `class_section_times_ibfk_1` FOREIGN KEY (`class_section_id`) REFERENCES `class_sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (1, 1, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (2, 2, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (3, 3, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (4, 4, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (5, 5, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (6, 6, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (7, 7, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (8, 8, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (9, 9, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (10, 10, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (11, 11, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (12, 12, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (13, 13, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (14, 14, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (15, 15, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (16, 16, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (17, 17, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (18, 18, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (19, 19, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (20, 20, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (21, 21, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (22, 22, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (23, 23, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (24, 24, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (25, 25, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (26, 26, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (27, 27, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (28, 28, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');
INSERT INTO `class_section_times` (`id`, `class_section_id`, `time`, `created_at`, `updated_at`) VALUES (29, 29, '00:00:00', '2025-04-17 19:57:47', '2025-04-17 19:57:47');


#
# TABLE STRUCTURE FOR: class_sections
#

DROP TABLE IF EXISTS `class_sections`;

CREATE TABLE `class_sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) DEFAULT NULL,
  `section_id` int(11) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `class_id` (`class_id`),
  KEY `section_id` (`section_id`),
  CONSTRAINT `class_sections_ibfk_1` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `class_sections_ibfk_2` FOREIGN KEY (`section_id`) REFERENCES `sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1, 1, 1, 'no', '2025-04-15 19:45:47', '2025-04-15 19:45:47');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (2, 1, 2, 'no', '2025-04-15 19:45:47', '2025-04-15 19:45:47');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (3, 1, 3, 'no', '2025-04-15 19:45:47', '2025-04-15 19:45:47');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (4, 2, 1, 'no', '2025-04-15 19:45:55', '2025-04-15 19:45:55');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (5, 2, 2, 'no', '2025-04-15 19:45:55', '2025-04-15 19:45:55');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (6, 3, 1, 'no', '2025-04-15 19:46:07', '2025-04-15 19:46:07');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (7, 3, 2, 'no', '2025-04-15 19:46:07', '2025-04-15 19:46:07');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (8, 4, 1, 'no', '2025-04-15 19:46:12', '2025-04-15 19:46:12');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (9, 4, 2, 'no', '2025-04-15 19:46:12', '2025-04-15 19:46:12');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (10, 5, 1, 'no', '2025-04-15 19:46:20', '2025-04-15 19:46:20');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (11, 5, 2, 'no', '2025-04-15 19:46:20', '2025-04-15 19:46:20');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (12, 5, 3, 'no', '2025-04-15 19:46:20', '2025-04-15 19:46:20');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (13, 6, 1, 'no', '2025-04-15 19:46:29', '2025-04-15 19:46:29');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (14, 6, 2, 'no', '2025-04-15 19:46:29', '2025-04-15 19:46:29');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (15, 7, 1, 'no', '2025-04-15 19:46:38', '2025-04-15 19:46:38');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (16, 7, 2, 'no', '2025-04-15 19:46:38', '2025-04-15 19:46:38');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (17, 7, 3, 'no', '2025-04-15 19:46:38', '2025-04-15 19:46:38');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (18, 8, 1, 'no', '2025-04-15 19:53:02', '2025-04-15 19:53:02');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (19, 8, 2, 'no', '2025-04-15 19:53:02', '2025-04-15 19:53:02');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (20, 8, 3, 'no', '2025-04-15 19:53:02', '2025-04-15 19:53:02');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (21, 9, 1, 'no', '2025-04-15 19:53:10', '2025-04-15 19:53:10');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (22, 9, 2, 'no', '2025-04-15 19:53:10', '2025-04-15 19:53:10');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (23, 9, 3, 'no', '2025-04-15 19:53:10', '2025-04-15 19:53:10');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (24, 10, 1, 'no', '2025-04-15 19:53:16', '2025-04-15 19:53:16');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (25, 10, 2, 'no', '2025-04-15 19:53:16', '2025-04-15 19:53:16');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (26, 11, 1, 'no', '2025-04-15 19:53:23', '2025-04-15 19:53:23');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (27, 12, 1, 'no', '2025-04-15 19:53:28', '2025-04-15 19:53:28');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (28, 13, 1, 'no', '2025-04-15 19:53:42', '2025-04-15 19:53:42');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (29, 13, 2, 'no', '2025-04-15 19:53:42', '2025-04-15 19:53:42');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (30, 14, 1, 'no', '2025-06-11 18:50:58', '2025-06-11 18:50:58');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (31, 6, 3, 'no', '2025-06-18 05:17:02', '2025-06-18 05:17:02');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (32, 13, 3, 'no', '2025-06-19 11:17:08', '2025-06-19 11:17:08');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (33, 2, 3, 'no', '2025-06-19 11:17:24', '2025-06-19 11:17:24');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (34, 3, 3, 'no', '2025-06-19 11:17:41', '2025-06-19 11:17:41');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (35, 4, 3, 'no', '2025-06-19 11:17:52', '2025-06-19 11:17:52');


#
# TABLE STRUCTURE FOR: class_subject_periods
#

DROP TABLE IF EXISTS `class_subject_periods`;

CREATE TABLE `class_subject_periods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_section_id` int(11) NOT NULL,
  `subject_group_subject_id` int(11) NOT NULL,
  `periods` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (1, 1, 1, '10', '2025-05-17 14:46:30', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (2, 1, 2, '10', '2025-05-17 14:46:30', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (3, 1, 3, '10', '2025-05-17 14:46:30', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (4, 1, 4, '10', '2025-05-17 14:46:30', NULL);
INSERT INTO `class_subject_periods` (`id`, `class_section_id`, `subject_group_subject_id`, `periods`, `created_at`, `updated_at`) VALUES (5, 1, 5, '8', '2025-05-17 14:46:30', NULL);


#
# TABLE STRUCTURE FOR: class_teacher
#

DROP TABLE IF EXISTS `class_teacher`;

CREATE TABLE `class_teacher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `class_id` (`class_id`),
  KEY `section_id` (`section_id`),
  KEY `session_id` (`session_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `class_teacher_ibfk_1` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `class_teacher_ibfk_2` FOREIGN KEY (`section_id`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `class_teacher_ibfk_3` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `class_teacher_ibfk_4` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (1, 20, 1, 1, 3);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (2, 20, 1, 2, 3);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (3, 20, 10, 1, 3);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (4, 25, 1, 1, 3);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (5, 25, 1, 2, 3);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (6, 25, 10, 1, 3);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (7, 19, 1, 1, 3);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (8, 24, 1, 1, 3);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (9, 24, 1, 1, 3);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (10, 19, 7, 1, 3);
INSERT INTO `class_teacher` (`id`, `session_id`, `class_id`, `section_id`, `staff_id`) VALUES (11, 19, 4, 2, 3);


#
# TABLE STRUCTURE FOR: class_timeline
#

DROP TABLE IF EXISTS `class_timeline`;

CREATE TABLE `class_timeline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `day` varchar(20) DEFAULT NULL,
  `period_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `teacher_id` int(11) NOT NULL,
  `time_from` varchar(100) NOT NULL,
  `time_to` varchar(100) NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=97 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (1, 1, 1, 'Monday', 1, 4, 0, '08:45 AM', '09:25 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (2, 1, 1, 'Monday', 2, 5, 0, '09:25 AM', '10:05 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (3, 1, 1, 'Monday', 3, -1, 0, '10:05 AM', '10:45 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (4, 1, 1, 'Monday', 4, 5, 0, '10:45 AM', '11:25 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (5, 1, 1, 'Monday', 5, 2, 0, '11:25 AM', '12:05 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (6, 1, 1, 'Monday', 6, -2, 0, '12:05 PM', '12:45 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (7, 1, 1, 'Monday', 7, 5, 0, '12:45 PM', '01:20 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (8, 1, 1, 'Monday', 8, 4, 0, '01:20 PM', '01:55 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (9, 1, 1, 'Tuesday', 1, 1, 0, '08:45 AM', '09:25 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (10, 1, 1, 'Tuesday', 2, 3, 0, '09:25 AM', '10:05 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (11, 1, 1, 'Tuesday', 3, -1, 0, '10:05 AM', '10:45 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (12, 1, 1, 'Tuesday', 4, 3, 0, '10:45 AM', '11:25 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (13, 1, 1, 'Tuesday', 5, 5, 0, '11:25 AM', '12:05 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (14, 1, 1, 'Tuesday', 6, -2, 0, '12:05 PM', '12:45 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (15, 1, 1, 'Tuesday', 7, 3, 0, '12:45 PM', '01:20 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (16, 1, 1, 'Tuesday', 8, 1, 0, '01:20 PM', '01:55 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (17, 1, 1, 'Wednesday', 1, 2, 0, '08:45 AM', '09:25 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (18, 1, 1, 'Wednesday', 2, 2, 0, '09:25 AM', '10:05 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (19, 1, 1, 'Wednesday', 3, -1, 0, '10:05 AM', '10:45 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (20, 1, 1, 'Wednesday', 4, 5, 0, '10:45 AM', '11:25 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (21, 1, 1, 'Wednesday', 5, 4, 0, '11:25 AM', '12:05 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (22, 1, 1, 'Wednesday', 6, -2, 0, '12:05 PM', '12:45 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (23, 1, 1, 'Wednesday', 7, 1, 0, '12:45 PM', '01:20 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (24, 1, 1, 'Wednesday', 8, 2, 0, '01:20 PM', '01:55 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (25, 1, 1, 'Thursday', 1, 1, 0, '08:45 AM', '09:25 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (26, 1, 1, 'Thursday', 2, 3, 0, '09:25 AM', '10:05 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (27, 1, 1, 'Thursday', 3, -1, 0, '10:05 AM', '10:45 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (28, 1, 1, 'Thursday', 4, 4, 0, '10:45 AM', '11:25 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (29, 1, 1, 'Thursday', 5, 2, 0, '11:25 AM', '12:05 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (30, 1, 1, 'Thursday', 6, -2, 0, '12:05 PM', '12:45 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (31, 1, 1, 'Thursday', 7, 3, 0, '12:45 PM', '01:20 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (32, 1, 1, 'Thursday', 8, 3, 0, '01:20 PM', '01:55 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (33, 1, 1, 'Friday', 1, 1, 0, '08:45 AM', '09:25 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (34, 1, 1, 'Friday', 2, 3, 0, '09:25 AM', '10:05 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (35, 1, 1, 'Friday', 3, -1, 0, '10:05 AM', '10:45 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (36, 1, 1, 'Friday', 4, 2, 0, '10:45 AM', '11:25 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (37, 1, 1, 'Friday', 5, 4, 0, '11:25 AM', '12:05 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (38, 1, 1, 'Friday', 6, -2, 0, '12:05 PM', '12:45 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (39, 1, 1, 'Friday', 7, 1, 0, '12:45 PM', '01:20 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (40, 1, 1, 'Friday', 8, 1, 0, '01:20 PM', '01:55 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (41, 1, 1, 'Saturday', 1, 2, 0, '08:45 AM', '09:25 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (42, 1, 1, 'Saturday', 2, 3, 0, '09:25 AM', '10:05 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (43, 1, 1, 'Saturday', 3, -1, 0, '10:05 AM', '10:45 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (44, 1, 1, 'Saturday', 4, 2, 0, '10:45 AM', '11:25 AM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (45, 1, 1, 'Saturday', 5, 4, 0, '11:25 AM', '12:05 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (46, 1, 1, 'Saturday', 6, -2, 0, '12:05 PM', '12:45 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (47, 1, 1, 'Saturday', 7, 5, 0, '12:45 PM', '01:20 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (48, 1, 1, 'Saturday', 8, 4, 0, '01:20 PM', '01:55 PM', 1, '2025-05-17 15:16:03');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (49, 9, 21, 'Monday', 1, 0, 0, '08:45 AM', '09:25 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (50, 9, 21, 'Monday', 2, 0, 0, '09:25 AM', '10:05 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (51, 9, 21, 'Monday', 3, -1, 0, '10:05 AM', '10:45 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (52, 9, 21, 'Monday', 4, 0, 0, '10:45 AM', '11:25 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (53, 9, 21, 'Monday', 5, 0, 0, '11:25 AM', '12:05 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (54, 9, 21, 'Monday', 6, -2, 0, '12:05 PM', '12:45 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (55, 9, 21, 'Monday', 7, 0, 0, '12:45 PM', '01:20 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (56, 9, 21, 'Monday', 8, 0, 0, '01:20 PM', '01:55 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (57, 9, 21, 'Tuesday', 1, 0, 0, '08:45 AM', '09:25 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (58, 9, 21, 'Tuesday', 2, 0, 0, '09:25 AM', '10:05 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (59, 9, 21, 'Tuesday', 3, -1, 0, '10:05 AM', '10:45 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (60, 9, 21, 'Tuesday', 4, 0, 0, '10:45 AM', '11:25 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (61, 9, 21, 'Tuesday', 5, 0, 0, '11:25 AM', '12:05 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (62, 9, 21, 'Tuesday', 6, -2, 0, '12:05 PM', '12:45 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (63, 9, 21, 'Tuesday', 7, 0, 0, '12:45 PM', '01:20 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (64, 9, 21, 'Tuesday', 8, 0, 0, '01:20 PM', '01:55 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (65, 9, 21, 'Wednesday', 1, 0, 0, '08:45 AM', '09:25 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (66, 9, 21, 'Wednesday', 2, 0, 0, '09:25 AM', '10:05 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (67, 9, 21, 'Wednesday', 3, -1, 0, '10:05 AM', '10:45 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (68, 9, 21, 'Wednesday', 4, 0, 0, '10:45 AM', '11:25 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (69, 9, 21, 'Wednesday', 5, 0, 0, '11:25 AM', '12:05 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (70, 9, 21, 'Wednesday', 6, -2, 0, '12:05 PM', '12:45 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (71, 9, 21, 'Wednesday', 7, 0, 0, '12:45 PM', '01:20 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (72, 9, 21, 'Wednesday', 8, 0, 0, '01:20 PM', '01:55 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (73, 9, 21, 'Thursday', 1, 0, 0, '08:45 AM', '09:25 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (74, 9, 21, 'Thursday', 2, 0, 0, '09:25 AM', '10:05 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (75, 9, 21, 'Thursday', 3, -1, 0, '10:05 AM', '10:45 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (76, 9, 21, 'Thursday', 4, 0, 0, '10:45 AM', '11:25 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (77, 9, 21, 'Thursday', 5, 0, 0, '11:25 AM', '12:05 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (78, 9, 21, 'Thursday', 6, -2, 0, '12:05 PM', '12:45 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (79, 9, 21, 'Thursday', 7, 0, 0, '12:45 PM', '01:20 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (80, 9, 21, 'Thursday', 8, 0, 0, '01:20 PM', '01:55 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (81, 9, 21, 'Friday', 1, 0, 0, '08:45 AM', '09:25 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (82, 9, 21, 'Friday', 2, 0, 0, '09:25 AM', '10:05 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (83, 9, 21, 'Friday', 3, -1, 0, '10:05 AM', '10:45 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (84, 9, 21, 'Friday', 4, 0, 0, '10:45 AM', '11:25 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (85, 9, 21, 'Friday', 5, 0, 0, '11:25 AM', '12:05 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (86, 9, 21, 'Friday', 6, -2, 0, '12:05 PM', '12:45 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (87, 9, 21, 'Friday', 7, 0, 0, '12:45 PM', '01:20 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (88, 9, 21, 'Friday', 8, 0, 0, '01:20 PM', '01:55 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (89, 9, 21, 'Saturday', 1, 0, 0, '08:45 AM', '09:25 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (90, 9, 21, 'Saturday', 2, 0, 0, '09:25 AM', '10:05 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (91, 9, 21, 'Saturday', 3, -1, 0, '10:05 AM', '10:45 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (92, 9, 21, 'Saturday', 4, 0, 0, '10:45 AM', '11:25 AM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (93, 9, 21, 'Saturday', 5, 0, 0, '11:25 AM', '12:05 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (94, 9, 21, 'Saturday', 6, -2, 0, '12:05 PM', '12:45 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (95, 9, 21, 'Saturday', 7, 0, 0, '12:45 PM', '01:20 PM', 1, '2025-06-11 18:52:00');
INSERT INTO `class_timeline` (`id`, `class_id`, `section_id`, `day`, `period_id`, `subject_id`, `teacher_id`, `time_from`, `time_to`, `status`, `created_at`) VALUES (96, 9, 21, 'Saturday', 8, 0, 0, '01:20 PM', '01:55 PM', 1, '2025-06-11 18:52:00');


#
# TABLE STRUCTURE FOR: class_weekly_periods
#

DROP TABLE IF EXISTS `class_weekly_periods`;

CREATE TABLE `class_weekly_periods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_section_id` int(11) NOT NULL,
  `periods` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (1, 47, '48', '2025-02-20 11:25:00', '2025-05-11 02:50:45');
INSERT INTO `class_weekly_periods` (`id`, `class_section_id`, `periods`, `created_at`, `updated_at`) VALUES (2, 1, '48', '2025-05-17 14:42:19', NULL);


#
# TABLE STRUCTURE FOR: classes
#

DROP TABLE IF EXISTS `classes`;

CREATE TABLE `classes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` int(11) NOT NULL,
  `class` varchar(60) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `classes` (`id`, `course_id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (1, 3, '8th', 'no', '2025-06-12 10:04:19', '2025-06-12 10:04:19');
INSERT INTO `classes` (`id`, `course_id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (2, 0, '9th', 'no', '2025-04-15 19:45:55', '2025-04-15 19:53:51');
INSERT INTO `classes` (`id`, `course_id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (3, 0, '7th', 'no', '2025-04-15 19:46:07', '2025-04-15 19:54:04');
INSERT INTO `classes` (`id`, `course_id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (4, 0, '6th', 'no', '2025-04-15 19:46:12', '2025-04-15 19:54:13');
INSERT INTO `classes` (`id`, `course_id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (5, 0, '5th	', 'no', '2025-04-15 19:46:20', '2025-04-15 19:46:20');
INSERT INTO `classes` (`id`, `course_id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (6, 0, '4th', 'no', '2025-04-15 19:46:29', '2025-04-15 19:46:29');
INSERT INTO `classes` (`id`, `course_id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (7, 0, '3rd', 'no', '2025-04-15 19:46:38', '2025-04-15 19:46:38');
INSERT INTO `classes` (`id`, `course_id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (8, 0, '2nd	', 'no', '2025-04-15 19:53:02', '2025-04-15 19:53:02');
INSERT INTO `classes` (`id`, `course_id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (9, 0, '1st	', 'no', '2025-04-15 19:53:10', '2025-04-15 19:53:10');
INSERT INTO `classes` (`id`, `course_id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (10, 0, 'SR.KG	', 'no', '2025-04-15 19:53:16', '2025-04-15 19:53:16');
INSERT INTO `classes` (`id`, `course_id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (11, 0, 'JR. KG	', 'no', '2025-04-15 19:53:23', '2025-04-15 19:53:23');
INSERT INTO `classes` (`id`, `course_id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (12, 0, 'NURSERY DAISY	', 'no', '2025-04-15 19:53:28', '2025-04-15 19:53:28');
INSERT INTO `classes` (`id`, `course_id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (13, 0, '10th', 'no', '2025-04-15 19:53:42', '2025-04-15 19:53:42');
INSERT INTO `classes` (`id`, `course_id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (14, 0, '11', 'no', '2025-06-11 18:50:58', '2025-06-11 18:50:58');


#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(255) NOT NULL,
  `source` varchar(255) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(15) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `description` text NOT NULL,
  `action_taken` varchar(200) NOT NULL,
  `assigned` varchar(50) NOT NULL,
  `note` text NOT NULL,
  `image` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`, `updated_at`) VALUES (1, 'Fees	', 'Fees	', '2025-06-21 11:40:29', '2025-06-21 11:40:29');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`, `updated_at`) VALUES (2, 'Study', 'Study', '2025-06-21 11:40:42', '2025-06-21 11:40:42');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`, `updated_at`) VALUES (3, 'Teacher', 'Teacher', '2025-06-21 11:40:48', '2025-06-21 11:40:48');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`, `updated_at`) VALUES (4, 'Sports', 'Sports', '2025-06-21 11:40:55', '2025-06-21 11:40:55');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`, `updated_at`) VALUES (5, 'Transport', 'Transport', '2025-06-21 11:41:02', '2025-06-21 11:41:02');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`, `updated_at`) VALUES (6, 'Hostel', 'Hostel', '2025-06-21 11:41:18', '2025-06-21 11:41:18');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`, `updated_at`) VALUES (7, 'Front Office', 'Front Office', '2025-06-21 11:41:23', '2025-06-21 11:41:23');


#
# TABLE STRUCTURE FOR: conference_sections
#

DROP TABLE IF EXISTS `conference_sections`;

CREATE TABLE `conference_sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) DEFAULT NULL,
  `cls_section_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `conference_sections_ibfk_1` (`conference_id`),
  KEY `conference_sections_ibfk_2` (`cls_section_id`),
  CONSTRAINT `conference_sections_ibfk_1` FOREIGN KEY (`conference_id`) REFERENCES `conferences` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conference_sections_ibfk_2` FOREIGN KEY (`cls_section_id`) REFERENCES `class_sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: conference_staff
#

DROP TABLE IF EXISTS `conference_staff`;

CREATE TABLE `conference_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `conference_staff_ibfk_1` (`conference_id`),
  KEY `conference_staff_ibfk_2` (`staff_id`),
  CONSTRAINT `conference_staff_ibfk_1` FOREIGN KEY (`conference_id`) REFERENCES `conferences` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conference_staff_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: conferences
#

DROP TABLE IF EXISTS `conferences`;

CREATE TABLE `conferences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purpose` varchar(20) NOT NULL DEFAULT 'class',
  `staff_id` int(11) DEFAULT NULL,
  `created_id` int(10) NOT NULL,
  `title` text DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `password` varchar(50) DEFAULT NULL,
  `subject` varchar(50) DEFAULT NULL,
  `class_id` int(10) DEFAULT NULL,
  `section_id` int(10) DEFAULT NULL,
  `session_id` int(10) NOT NULL,
  `host_video` int(1) NOT NULL DEFAULT 1,
  `client_video` int(1) NOT NULL DEFAULT 1,
  `description` varchar(50) DEFAULT NULL,
  `timezone` varchar(100) DEFAULT NULL,
  `return_response` text DEFAULT NULL,
  `api_type` varchar(30) NOT NULL,
  `status` int(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `conferences_ibfk_1` (`staff_id`),
  KEY `conferences_ibfk_2` (`created_id`),
  CONSTRAINT `conferences_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_2` FOREIGN KEY (`created_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: conferences_history
#

DROP TABLE IF EXISTS `conferences_history`;

CREATE TABLE `conferences_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `total_hit` int(10) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `conferences_history_ibfk_1` (`conference_id`),
  KEY `conferences_history_ibfk_2` (`staff_id`),
  KEY `conferences_history_ibfk_3` (`student_id`),
  CONSTRAINT `conferences_history_ibfk_1` FOREIGN KEY (`conference_id`) REFERENCES `conferences` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_history_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_history_ibfk_3` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: content_for
#

DROP TABLE IF EXISTS `content_for`;

CREATE TABLE `content_for` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(50) DEFAULT NULL,
  `content_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `content_for_ibfk_1` FOREIGN KEY (`content_id`) REFERENCES `contents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_3` FOREIGN KEY (`content_id`) REFERENCES `contents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_4` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: content_types
#

DROP TABLE IF EXISTS `content_types`;

CREATE TABLE `content_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` int(11) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `content_types` (`id`, `name`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'attu', '', 1, '2025-06-12 13:13:10', '2025-06-12 13:13:10');


#
# TABLE STRUCTURE FOR: contents
#

DROP TABLE IF EXISTS `contents`;

CREATE TABLE `contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `is_public` varchar(10) DEFAULT 'No',
  `class_id` int(11) DEFAULT NULL,
  `cls_sec_id` int(11) DEFAULT NULL,
  `file` varchar(250) DEFAULT NULL,
  `date` date NOT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `class_id` (`class_id`),
  KEY `cls_sec_id` (`cls_sec_id`),
  CONSTRAINT `contents_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contents_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contents_ibfk_3` FOREIGN KEY (`cls_sec_id`) REFERENCES `class_sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: course_category
#

DROP TABLE IF EXISTS `course_category`;

CREATE TABLE `course_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(255) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `is_active` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: course_lesson_quiz_order
#

DROP TABLE IF EXISTS `course_lesson_quiz_order`;

CREATE TABLE `course_lesson_quiz_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(10) DEFAULT NULL,
  `course_section_id` int(11) DEFAULT NULL,
  `lesson_quiz_id` int(11) DEFAULT NULL,
  `order` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `section_id` (`course_section_id`),
  CONSTRAINT `course_lesson_quiz_order_ibfk_1` FOREIGN KEY (`course_section_id`) REFERENCES `online_course_section` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: course_progress
#

DROP TABLE IF EXISTS `course_progress`;

CREATE TABLE `course_progress` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) DEFAULT NULL,
  `guest_id` int(1) DEFAULT NULL,
  `course_id` int(11) DEFAULT NULL,
  `course_section_id` int(11) DEFAULT NULL,
  `lesson_quiz_id` int(11) DEFAULT NULL,
  `lesson_quiz_type` int(11) DEFAULT NULL COMMENT '1 lesson, 2 quiz, 3 assignment,4 exam',
  PRIMARY KEY (`id`),
  KEY `course_id` (`course_id`),
  KEY `student_id` (`student_id`),
  KEY `course_section_id` (`course_section_id`),
  CONSTRAINT `course_progress_ibfk_1` FOREIGN KEY (`course_id`) REFERENCES `online_courses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `course_progress_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `course_progress_ibfk_3` FOREIGN KEY (`course_section_id`) REFERENCES `online_course_section` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: course_quiz_answer
#

DROP TABLE IF EXISTS `course_quiz_answer`;

CREATE TABLE `course_quiz_answer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) DEFAULT NULL,
  `guest_id` int(11) DEFAULT NULL,
  `course_quiz_id` int(11) DEFAULT NULL,
  `course_quiz_question_id` int(11) DEFAULT NULL,
  `answer` varchar(255) DEFAULT NULL,
  `created_date` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `quiz_id` (`course_quiz_id`),
  KEY `question_id` (`course_quiz_question_id`),
  CONSTRAINT `course_quiz_answer_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `course_quiz_answer_ibfk_2` FOREIGN KEY (`course_quiz_id`) REFERENCES `online_course_quiz` (`id`) ON DELETE CASCADE,
  CONSTRAINT `course_quiz_answer_ibfk_3` FOREIGN KEY (`course_quiz_question_id`) REFERENCES `course_quiz_question` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: course_quiz_question
#

DROP TABLE IF EXISTS `course_quiz_question`;

CREATE TABLE `course_quiz_question` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_quiz_id` int(11) DEFAULT NULL,
  `question` text DEFAULT NULL,
  `option_1` varchar(255) DEFAULT NULL,
  `option_2` varchar(255) DEFAULT NULL,
  `option_3` varchar(255) DEFAULT NULL,
  `option_4` varchar(255) DEFAULT NULL,
  `option_5` varchar(255) DEFAULT NULL,
  `correct_answer` varchar(255) DEFAULT NULL,
  `created_date` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `course_quiz_id` (`course_quiz_id`),
  CONSTRAINT `course_quiz_question_ibfk_1` FOREIGN KEY (`course_quiz_id`) REFERENCES `online_course_quiz` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: course_rating
#

DROP TABLE IF EXISTS `course_rating`;

CREATE TABLE `course_rating` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) DEFAULT NULL,
  `guest_id` int(11) DEFAULT NULL,
  `course_id` int(11) NOT NULL,
  `rating` varchar(200) NOT NULL,
  `review` text NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_course_id` (`course_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: courses
#

DROP TABLE IF EXISTS `courses`;

CREATE TABLE `courses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_name` varchar(255) NOT NULL,
  `course_description` varchar(255) DEFAULT NULL,
  `course_status` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `courses` (`id`, `course_name`, `course_description`, `course_status`, `created_at`, `updated_at`) VALUES (1, 'Test Course', 'An introductory course to programming using Python.', '1', '2024-06-23 06:40:16', '2024-12-24 14:20:25');
INSERT INTO `courses` (`id`, `course_name`, `course_description`, `course_status`, `created_at`, `updated_at`) VALUES (2, 'Data Structures and Algorithms', 'A course on data structures and algorithms in computer science.', '1', '2024-06-23 06:40:16', NULL);
INSERT INTO `courses` (`id`, `course_name`, `course_description`, `course_status`, `created_at`, `updated_at`) VALUES (3, 'Test Course', 'Test Description', '1', '2024-06-23 14:24:12', NULL);
INSERT INTO `courses` (`id`, `course_name`, `course_description`, `course_status`, `created_at`, `updated_at`) VALUES (4, 'Testing01', 'test02', '0', '2024-06-29 13:22:39', '2024-06-29 13:23:14');


#
# TABLE STRUCTURE FOR: cumulative_fine
#

DROP TABLE IF EXISTS `cumulative_fine`;

CREATE TABLE `cumulative_fine` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `overdue_day` int(11) NOT NULL,
  `fine_amount` float(10,2) NOT NULL,
  `fee_groups_feetype_id` int(11) NOT NULL,
  `fee_session_group_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: currencies
#

DROP TABLE IF EXISTS `currencies`;

CREATE TABLE `currencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `short_name` varchar(100) DEFAULT NULL,
  `symbol` varchar(10) DEFAULT NULL,
  `base_price` varchar(10) NOT NULL DEFAULT '1',
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=180 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'AED', 'AED', 'AEDf', '1', 0, '2022-12-30 06:19:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'AFN', 'AFN', '؋', '1', 0, '2022-12-30 06:19:19', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'ALL', 'ALL', 'ALL', '1', 0, '2022-12-30 06:19:22', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'AMD', 'AMD', 'AMD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'ANG', 'ANG', 'ANG', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'AOA', 'AOA', 'AOA', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'ARS', 'ARS', 'ARS', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'AUD', 'AUD', 'AUD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'AWG', 'AWG', 'AWG', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'AZN', 'AZN', 'AZN', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'BAM', 'BAM', 'BAM', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (12, 'BAM', 'BAM', 'BAM', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'BDT', 'BDT', 'BDT', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'BGN', 'BGN', 'BGN', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'BHD', 'BHD', 'BHD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'BIF', 'BIF', 'BIF', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'BMD', 'BMD', 'BMD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'BND', 'BND', 'BND', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'BOB', 'BOB', 'BOB', '1', 0, '2022-12-30 06:19:29', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (20, 'BOV', 'BOV', 'BOV', '1', 0, '2022-12-30 06:19:38', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'BRL', 'BRL', 'BRL', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'BSD', 'BSD', 'BSD', '1', 0, '2022-12-30 06:19:40', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'BTN', 'BTN', 'BTN', '1', 0, '2022-12-30 06:19:42', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'BWP', 'BWP', 'BWP', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'BYN', 'BYN', 'BYN', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'BYR', 'BYR', 'BYR', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'BZD', 'BZD', 'BZD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'CAD', 'CAD', 'CAD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'CDF', 'CDF', 'CDF', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'CHE', 'CHE', 'CHE', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'CHF', 'CHF', 'CHF', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (32, 'CHW', 'CHW', 'CHW', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'CLF', 'CLF', 'CLF', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'CLP', 'CLP', 'CLP', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (35, 'CNY', 'CNY', 'CNY', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'COP', 'COP', 'COP', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'COU', 'COU', 'COU', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'CRC', 'CRC', 'CRC', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'CUC', 'CUC', 'CUC', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'CUP', 'CUP', 'CUP', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'CVE', 'CVE', 'CVE', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (42, 'CZK', 'CZK', 'CZK', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'DJF', 'DJF', 'DJF', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'DKK', 'DKK', 'DKK', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'DOP', 'DOP', 'DOP', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'DZD', 'DZD', 'DZD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'EGP', 'EGP', 'EGP', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'ERN', 'ERN', 'ERN', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'ETB', 'ETB', 'ETB', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (50, 'EUR', 'EUR', '€', '1', 0, '2022-12-30 06:20:25', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'FJD', 'FJD', 'FJD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'FKP', 'FKP', 'FKP', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'GBP', 'GBP', '£', '1', 0, '2022-12-30 06:20:29', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'GEL', 'GEL', 'GEL', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'GHS', 'GHS', 'GHS', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (56, 'GIP', 'GIP', 'GIP', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'GMD', 'GMD', 'GMD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (58, 'GNF', 'GNF', 'GNF', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'GTQ', 'GTQ', 'GTQ', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'GYD', 'GYD', 'GYD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'HKD', 'HKD', 'HKD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'HNL', 'HNL', 'HNL', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (63, 'HRK', 'HRK', 'HRK', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'HTG', 'HTG', 'HTG', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'HUF', 'HUF', 'HUF', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'IDR', 'IDR', 'IDR', '1', 0, '2022-12-30 06:20:34', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'ILS', 'ILS', 'ILS', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'INR', 'INR', '₹', '1', 0, '2022-12-30 06:20:37', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (69, 'IQD', 'IQD', 'IQD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'IRR', 'IRR', 'IRR', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'ISK', 'ISK', 'ISK', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'JMD', 'JMD', 'JMD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (73, 'JOD', 'JOD', 'JOD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'JPY', 'JPY', 'JPY', '1', 0, '2022-12-30 06:19:56', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'KES', 'KES', 'KES', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (76, 'KGS', 'KGS', 'KGS', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'KHR', 'KHR', 'KHR', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (78, 'KMF', 'KMF', 'KMF', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (79, 'KPW', 'KPW', 'KPW', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (80, 'KRW', 'KRW', 'KRW', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (81, 'KWD', 'KWD', 'KWD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (82, 'KYD', 'KYD', 'KYD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (83, 'KZT', 'KZT', 'KZT', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (84, 'LAK', 'LAK', 'LAK', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (85, 'LBP', 'LBP', 'LBP', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (86, 'LKR', 'LKR', 'LKR', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (87, 'LRD', 'LRD', 'LRD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (88, 'LSL', 'LSL', 'LSL', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (89, 'LYD', 'LYD', 'LYD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (90, 'MAD', 'MAD', 'MAD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (91, 'MDL', 'MDL', 'MDL', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (92, 'MGA', 'MGA', 'MGA', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (93, 'MKD', 'MKD', 'MKD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (94, 'MMK', 'MMK', 'MMK', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (95, 'MNT', 'MNT', 'MNT', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (96, 'MOP', 'MOP', 'MOP', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (97, 'MRO', 'MRO', 'MRO', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (98, 'MUR', 'MUR', 'MUR', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (99, 'MVR', 'MVR', 'MVR', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (100, 'MWK', 'MWK', 'MWK', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (101, 'MXN', 'MXN', 'MXN', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (102, 'MXV', 'MXV', 'MXV', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (103, 'MYR', 'MYR', 'MYR', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (104, 'MZN', 'MZN', 'MZN', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (105, 'NAD', 'NAD', 'NAD', '1', 0, '2022-07-30 10:32:37', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (106, 'NGN', 'NGN', 'NGN', '1', 0, '2022-12-30 06:20:42', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (107, 'NIO', 'NIO', 'NIO', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (108, 'NOK', 'NOK', 'NOK', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (109, 'NPR', 'NPR', 'NPR', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (110, 'NZD', 'NZD', 'NZD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (111, 'OMR', 'OMR', 'OMR', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (112, 'PAB', 'PAB', 'PAB', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (113, 'PEN', 'PEN', 'PEN', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (114, 'PGK', 'PGK', 'PGK', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (115, 'PHP', 'PHP', 'PHP', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (116, 'PKR', 'PKR', 'PKR', '1', 0, '2022-12-30 06:20:19', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (117, 'PLN', 'PLN', 'PLN', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (118, 'PYG', 'PYG', 'PYG', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (119, 'QAR', 'QAR', 'QAR', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (120, 'RON', 'RON', 'RON', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (121, 'RSD', 'RSD', 'RSD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (122, 'RUB', 'RUB', 'RUB', '1', 0, '2022-12-30 06:20:16', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (123, 'RWF', 'RWF', 'RWF', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (124, 'SAR', 'SAR', 'SAR', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (125, 'SBD', 'SBD', 'SBD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (126, 'SCR', 'SCR', 'SCR', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (127, 'SDG', 'SDG', 'SDG', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (128, 'SEK', 'SEK', 'SEK', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (129, 'SGD', 'SGD', 'SGD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (130, 'SHP', 'SHP', 'SHP', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (131, 'SLL', 'SLL', 'SLL', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (132, 'SOS', 'SOS', 'SOS', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (133, 'SRD', 'SRD', 'SRD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (134, 'SSP', 'SSP', 'SSP', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (135, 'STD', 'STD', 'STD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (136, 'SVC', 'SVC', 'SVC', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (137, 'SYP', 'SYP', 'SYP', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (138, 'SZL', 'SZL', 'SZL', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (139, 'THB', 'THB', 'THB', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (140, 'TJS', 'TJS', 'TJS', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (141, 'TMT', 'TMT', 'TMT', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (142, 'TND', 'TND', 'TND', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (143, 'TOP', 'TOP', 'TOP', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (144, 'TRY', 'TRY', 'TRY', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (145, 'TTD', 'TTD', 'TTD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (146, 'TWD', 'TWD', 'TWD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (147, 'TZS', 'TZS', 'TZS', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (148, 'UAH', 'UAH', 'UAH', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (149, 'UGX', 'UGX', 'UGX', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (150, 'USD', 'USD', '$', '1', 1, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (151, 'USN', 'USN', 'USN', '1', 0, '2022-12-30 06:20:03', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (152, 'UYI', 'UYI', 'UYI', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (153, 'UYU', 'UYU', 'UYU', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (154, 'UZS', 'UZS', 'UZS', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (155, 'VEF', 'VEF', 'VEF', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (156, 'VND', 'VND', 'VND', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (157, 'VUV', 'VUV', 'VUV', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (158, 'WST', 'WST', 'WST', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (159, 'XAF', 'XAF', 'XAF', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (160, 'XAG', 'XAG', 'XAG', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (161, 'XAU', 'XAU', 'XAU', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (162, 'XBA', 'XBA', 'XBA', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (163, 'XBB', 'XBB', 'XBB', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (164, 'XBC', 'XBC', 'XBC', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (165, 'XBD', 'XBD', 'XBD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (166, 'XCD', 'XCD', 'XCD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (167, 'XDR', 'XDR', 'XDR', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (168, 'XOF', 'XOF', 'XOF', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (169, 'XPD', 'XPD', 'XPD', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (170, 'XPF', 'XPF', 'XPF', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (171, 'XPT', 'XPT', 'XPT', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (172, 'XSU', 'XSU', 'XSU', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (173, 'XTS', 'XTS', 'XTS', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (174, 'XUA', 'XUA', 'XUA', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (175, 'XXX', 'XXX', 'XXX', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (176, 'YER', 'YER', 'YER', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (177, 'ZAR', 'ZAR', 'ZAR', '1', 0, '2022-12-30 06:20:07', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (178, 'ZMW', 'ZMW', 'ZMW', '1', 0, '2022-07-30 08:34:00', '2025-04-09 22:52:05');
INSERT INTO `currencies` (`id`, `name`, `short_name`, `symbol`, `base_price`, `is_active`, `created_at`, `updated_at`) VALUES (179, 'ZWL', 'ZWL', 'ZWL', '1', 0, '2022-07-22 11:55:15', '2025-04-09 22:52:05');


#
# TABLE STRUCTURE FOR: custom_field_values
#

DROP TABLE IF EXISTS `custom_field_values`;

CREATE TABLE `custom_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `belong_table_id` int(11) DEFAULT NULL,
  `custom_field_id` int(11) DEFAULT NULL,
  `field_value` varchar(500) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`),
  KEY `idx_belong_table_id` (`belong_table_id`),
  KEY `idx_field_value` (`field_value`),
  KEY `belong_table_id` (`belong_table_id`),
  KEY `field_value` (`field_value`),
  CONSTRAINT `custom_field_values_ibfk_1` FOREIGN KEY (`custom_field_id`) REFERENCES `custom_fields` (`id`) ON DELETE CASCADE,
  CONSTRAINT `custom_field_values_ibfk_2` FOREIGN KEY (`custom_field_id`) REFERENCES `custom_fields` (`id`) ON DELETE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: custom_fields
#

DROP TABLE IF EXISTS `custom_fields`;

CREATE TABLE `custom_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `belong_to` varchar(100) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `bs_column` int(11) DEFAULT NULL,
  `validation` int(11) DEFAULT 0,
  `field_values` text DEFAULT NULL,
  `show_table` varchar(100) DEFAULT NULL,
  `visible_on_table` int(11) NOT NULL,
  `weight` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`),
  KEY `idx_belong_to` (`belong_to`),
  KEY `idx_type` (`type`),
  KEY `idx_visible_on_table` (`visible_on_table`),
  KEY `idx_weight` (`weight`),
  KEY `name` (`name`),
  KEY `belong_to` (`belong_to`),
  KEY `type` (`type`),
  KEY `visible_on_table` (`visible_on_table`),
  KEY `weight` (`weight`),
  KEY `field_values` (`field_values`(1024)),
  FULLTEXT KEY `idx_field_values` (`field_values`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: daily_assignment
#

DROP TABLE IF EXISTS `daily_assignment`;

CREATE TABLE `daily_assignment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_session_id` int(11) NOT NULL,
  `subject_group_subject_id` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `attachment` varchar(255) DEFAULT NULL,
  `evaluated_by` int(11) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `evaluation_date` date DEFAULT NULL,
  `remark` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_session_id` (`student_session_id`),
  KEY `evaluated_by` (`evaluated_by`),
  KEY `subject_group_subject_id` (`subject_group_subject_id`),
  CONSTRAINT `daily_assignment_ibfk_1` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE,
  CONSTRAINT `daily_assignment_ibfk_2` FOREIGN KEY (`evaluated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `daily_assignment_ibfk_3` FOREIGN KEY (`subject_group_subject_id`) REFERENCES `subject_group_subjects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `daily_assignment_ibfk_4` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE,
  CONSTRAINT `daily_assignment_ibfk_5` FOREIGN KEY (`evaluated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `daily_assignment_ibfk_6` FOREIGN KEY (`subject_group_subject_id`) REFERENCES `subject_group_subjects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: department
#

DROP TABLE IF EXISTS `department`;

CREATE TABLE `department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(200) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'IT Support', 'yes', '2025-04-17 19:13:26', '2025-04-17 19:13:26');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Teacher', 'yes', '2025-05-02 19:53:00', '2025-05-02 19:53:00');


#
# TABLE STRUCTURE FOR: disable_reason
#

DROP TABLE IF EXISTS `disable_reason`;

CREATE TABLE `disable_reason` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `disable_reason` (`id`, `reason`, `created_at`, `updated_at`) VALUES (1, 'Regular Absent', '2025-04-18 16:11:52', '2025-04-18 16:11:52');
INSERT INTO `disable_reason` (`id`, `reason`, `created_at`, `updated_at`) VALUES (2, 'Fees Not Paid', '2025-04-18 16:12:08', '2025-04-18 16:12:08');
INSERT INTO `disable_reason` (`id`, `reason`, `created_at`, `updated_at`) VALUES (3, 'accidential', '2025-06-11 15:02:51', '2025-06-11 15:02:51');


#
# TABLE STRUCTURE FOR: dispatch_receive
#

DROP TABLE IF EXISTS `dispatch_receive`;

CREATE TABLE `dispatch_receive` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(50) NOT NULL,
  `to_title` varchar(100) NOT NULL,
  `type` varchar(10) NOT NULL,
  `address` varchar(500) NOT NULL,
  `note` varchar(500) NOT NULL,
  `from_title` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `image` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `type`, `address`, `note`, `from_title`, `date`, `image`, `created_at`, `updated_at`) VALUES (1, '23412', 'School board office	', 'dispatch', '', '', 'school board office	', '2025-04-24', NULL, '2025-04-18 15:12:52', '2025-04-18 15:12:52');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `type`, `address`, `note`, `from_title`, `date`, `image`, `created_at`, `updated_at`) VALUES (2, '23423', 'Johnson Book seller	', 'dispatch', '', '', 'Johnson Book seller	', '2025-04-25', NULL, '2025-04-18 15:13:28', '2025-04-18 15:13:28');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `type`, `address`, `note`, `from_title`, `date`, `image`, `created_at`, `updated_at`) VALUES (3, '454623', 'Fees Discussion	', 'dispatch', '', '', 'Fees Discussion	', '2025-04-20', NULL, '2025-04-18 15:14:08', '2025-04-18 15:14:08');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `type`, `address`, `note`, `from_title`, `date`, `image`, `created_at`, `updated_at`) VALUES (4, '34522', 'Food Deliver Instruction	', 'dispatch', '', '', 'Food Deliver Instruction	', '2025-04-18', NULL, '2025-04-18 15:14:54', '2025-04-18 15:14:54');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `type`, `address`, `note`, `from_title`, `date`, `image`, `created_at`, `updated_at`) VALUES (5, '78333', 'National Cadet Corps	', 'receive', '', '', 'National Cadet Corps	', '2025-04-30', NULL, '2025-04-18 15:15:30', '2025-04-18 15:15:30');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `type`, `address`, `note`, `from_title`, `date`, `image`, `created_at`, `updated_at`) VALUES (6, '68734', 'Books deliver In School	', 'receive', '', '', 'Books deliver In School	', '2025-04-25', NULL, '2025-04-18 15:16:05', '2025-04-18 15:16:05');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `type`, `address`, `note`, `from_title`, `date`, `image`, `created_at`, `updated_at`) VALUES (7, '89066', 'Fees Discussion	', 'receive', '', '', 'Fees Discussion	', '2025-04-18', NULL, '2025-04-18 15:16:38', '2025-04-18 15:16:38');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `type`, `address`, `note`, `from_title`, `date`, `image`, `created_at`, `updated_at`) VALUES (8, '4562378', 'Food Deliver Instruction	', 'receive', '', '', 'Food Deliver Instruction	', '2025-04-18', NULL, '2025-04-18 15:17:08', '2025-06-21 11:58:51');


#
# TABLE STRUCTURE FOR: email_attachments
#

DROP TABLE IF EXISTS `email_attachments`;

CREATE TABLE `email_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message_id` int(11) NOT NULL,
  `directory` varchar(255) NOT NULL,
  `attachment` varchar(255) NOT NULL,
  `attachment_name` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `message_id` (`message_id`),
  CONSTRAINT `email_attachments_ibfk_1` FOREIGN KEY (`message_id`) REFERENCES `messages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email_type` varchar(100) DEFAULT NULL,
  `smtp_server` varchar(100) DEFAULT NULL,
  `smtp_port` varchar(100) DEFAULT NULL,
  `smtp_email` varchar(255) DEFAULT NULL,
  `smtp_username` varchar(100) DEFAULT NULL,
  `smtp_password` varchar(100) DEFAULT NULL,
  `ssl_tls` varchar(100) DEFAULT NULL,
  `smtp_auth` varchar(10) NOT NULL,
  `api_key` varchar(255) DEFAULT NULL,
  `api_secret` varchar(255) DEFAULT NULL,
  `region` varchar(255) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `email_config` (`id`, `email_type`, `smtp_server`, `smtp_port`, `smtp_email`, `smtp_username`, `smtp_password`, `ssl_tls`, `smtp_auth`, `api_key`, `api_secret`, `region`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'sendmail', NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, 'yes', '2020-02-28 13:46:03', '2025-04-09 22:52:05');


#
# TABLE STRUCTURE FOR: email_template
#

DROP TABLE IF EXISTS `email_template`;

CREATE TABLE `email_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `message` text NOT NULL,
  `created_at` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: email_template_attachment
#

DROP TABLE IF EXISTS `email_template_attachment`;

CREATE TABLE `email_template_attachment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email_template_id` int(11) NOT NULL,
  `attachment` varchar(100) NOT NULL,
  `attachment_name` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: enquiry
#

DROP TABLE IF EXISTS `enquiry`;

CREATE TABLE `enquiry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(20) NOT NULL,
  `address` text NOT NULL,
  `reference` varchar(20) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(500) NOT NULL,
  `follow_up_date` date NOT NULL,
  `note` text NOT NULL,
  `source` varchar(50) NOT NULL,
  `email` varchar(50) DEFAULT NULL,
  `assigned` int(11) DEFAULT NULL,
  `class_id` int(11) DEFAULT NULL,
  `no_of_child` varchar(11) DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `assigned` (`assigned`),
  KEY `enquiry_ibfk_4` (`class_id`),
  CONSTRAINT `enquiry_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `enquiry_ibfk_3` FOREIGN KEY (`assigned`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `enquiry_ibfk_4` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `enquiry` (`id`, `name`, `contact`, `address`, `reference`, `date`, `description`, `follow_up_date`, `note`, `source`, `email`, `assigned`, `class_id`, `no_of_child`, `status`, `created_by`, `created_at`, `updated_at`) VALUES (1, 'Akhilesh Holkunde', '09030506522', '304,span residency, Narayanguda, HYDERABAD, TELANGANA, 500029, India', 'Self', '2025-06-21', 'New Admission', '2025-06-28', 'New Admission', 'Front Office', 'rohitkappikere@gmail.com', 1, 9, '4', 'passive', 1, '2025-06-21 11:45:03', '2025-06-21 11:45:18');


#
# TABLE STRUCTURE FOR: enquiry_type
#

DROP TABLE IF EXISTS `enquiry_type`;

CREATE TABLE `enquiry_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enquiry_type` varchar(100) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: events
#

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_title` varchar(200) NOT NULL,
  `event_description` text NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `event_type` varchar(100) NOT NULL,
  `event_color` varchar(200) NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `role_id` int(11) DEFAULT NULL,
  `is_active` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `events_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'summer', '', '2025-06-04 05:30:00', '2025-06-04 05:30:00', 'protected', '#337ab7', '1', NULL, '', '2025-06-15 08:28:53', '2025-06-15 08:28:53');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Demo Link for New Client', '', '2025-06-16 00:00:00', '2025-06-16 00:00:00', 'task', '#000', '1', 7, 'no', '2025-06-16 12:50:23', '2025-06-16 12:50:23');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Need to visit to latur for client', 'Need to visit to latur for client', '2025-06-17 05:30:00', '2025-06-17 05:30:00', 'public', '#337ab7', '0', NULL, '', '2025-06-16 12:51:15', '2025-06-16 12:51:15');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'Need to visit to latur for client', 'Need to visit to latur for client', '2025-06-17 05:30:00', '2025-06-17 05:30:00', 'public', '#337ab7', '0', NULL, '', '2025-06-16 12:51:17', '2025-06-16 12:51:17');


#
# TABLE STRUCTURE FOR: exam_class_subjects_component
#

DROP TABLE IF EXISTS `exam_class_subjects_component`;

CREATE TABLE `exam_class_subjects_component` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `session_id` int(10) DEFAULT NULL,
  `class_id` int(10) DEFAULT NULL,
  `subject_id` int(10) DEFAULT NULL,
  `mdtid` int(5) DEFAULT NULL,
  `mdcid` varchar(300) DEFAULT NULL,
  `mark` int(10) DEFAULT NULL,
  `remark_language` varchar(50) DEFAULT NULL COMMENT 'Eng/Mar/Hindi',
  `status` int(5) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `exam_class_subjects_component` (`id`, `session_id`, `class_id`, `subject_id`, `mdtid`, `mdcid`, `mark`, `remark_language`, `status`, `created_at`, `updated_at`) VALUES (10, NULL, 20, 2, NULL, '[{\"mdtid\":1,\"mdcid\":\"1\",\"mark\":\"25\"},{\"mdtid\":1,\"mdcid\":\"2\",\"mark\":\"25\"},{\"mdtid\":1,\"mdcid\":\"7\",\"mark\":\"\"},{\"mdtid\":3,\"mdcid\":\"4\",\"mark\":\"30\"},{\"mdtid\":3,\"mdcid\":\"5\",\"mark\":\"20\"},{\"mdtid\":3,\"mdcid\":\"6\",\"mark\":\"\"}]', NULL, 'mr', 3, '2024-01-21 09:38:41', NULL);
INSERT INTO `exam_class_subjects_component` (`id`, `session_id`, `class_id`, `subject_id`, `mdtid`, `mdcid`, `mark`, `remark_language`, `status`, `created_at`, `updated_at`) VALUES (9, NULL, 20, 1, NULL, '[{\"mdtid\":1,\"mdcid\":\"1\",\"mark\":\"20\"},{\"mdtid\":1,\"mdcid\":\"2\",\"mark\":\"30\"},{\"mdtid\":1,\"mdcid\":\"7\",\"mark\":\"\"},{\"mdtid\":3,\"mdcid\":\"4\",\"mark\":\"30\"},{\"mdtid\":3,\"mdcid\":\"5\",\"mark\":\"20\"},{\"mdtid\":3,\"mdcid\":\"6\",\"mark\":\"\"}]', NULL, 'eng', 3, '2024-01-18 18:56:53', NULL);
INSERT INTO `exam_class_subjects_component` (`id`, `session_id`, `class_id`, `subject_id`, `mdtid`, `mdcid`, `mark`, `remark_language`, `status`, `created_at`, `updated_at`) VALUES (11, NULL, 20, 6, NULL, '[{\"mdtid\":1,\"mdcid\":\"1\",\"mark\":\"0\"},{\"mdtid\":1,\"mdcid\":\"2\",\"mark\":\"0\"},{\"mdtid\":3,\"mdcid\":\"4\",\"mark\":\"0\"},{\"mdtid\":3,\"mdcid\":\"5\",\"mark\":\"0\"},{\"mdtid\":3,\"mdcid\":\"6\",\"mark\":\"0\"}]', NULL, 'hi', 3, '2024-01-21 09:47:49', NULL);
INSERT INTO `exam_class_subjects_component` (`id`, `session_id`, `class_id`, `subject_id`, `mdtid`, `mdcid`, `mark`, `remark_language`, `status`, `created_at`, `updated_at`) VALUES (12, NULL, 20, 3, NULL, '[{\"mdtid\":1,\"mdcid\":\"1\",\"mark\":\"10\"},{\"mdtid\":1,\"mdcid\":\"2\",\"mark\":\"30\"},{\"mdtid\":1,\"mdcid\":\"7\",\"mark\":\"\"},{\"mdtid\":3,\"mdcid\":\"4\",\"mark\":\"20\"},{\"mdtid\":3,\"mdcid\":\"5\",\"mark\":\"20\"},{\"mdtid\":3,\"mdcid\":\"6\",\"mark\":\"20\"}]', NULL, 'eng', 3, '2024-01-26 18:38:11', NULL);
INSERT INTO `exam_class_subjects_component` (`id`, `session_id`, `class_id`, `subject_id`, `mdtid`, `mdcid`, `mark`, `remark_language`, `status`, `created_at`, `updated_at`) VALUES (13, NULL, 1, 1, NULL, '[{\"mdtid\":1,\"mdcid\":\"1\",\"mark\":\"20\"},{\"mdtid\":1,\"mdcid\":\"2\",\"mark\":\"10\"},{\"mdtid\":1,\"mdcid\":\"7\",\"mark\":\"10\"},{\"mdtid\":1,\"mdcid\":\"8\",\"mark\":\"10\"},{\"mdtid\":3,\"mdcid\":\"4\",\"mark\":\"\"},{\"mdtid\":3,\"mdcid\":\"5\",\"mark\":\"50\"},{\"mdtid\":3,\"mdcid\":\"6\",\"mark\":\"\"}]', NULL, 'eng', 1, '2025-05-17 22:23:57', NULL);
INSERT INTO `exam_class_subjects_component` (`id`, `session_id`, `class_id`, `subject_id`, `mdtid`, `mdcid`, `mark`, `remark_language`, `status`, `created_at`, `updated_at`) VALUES (14, NULL, 1, 2, NULL, '[{\"mdtid\":1,\"mdcid\":\"1\",\"mark\":\"20\"},{\"mdtid\":1,\"mdcid\":\"2\",\"mark\":\"10\"},{\"mdtid\":1,\"mdcid\":\"7\",\"mark\":\"10\"},{\"mdtid\":1,\"mdcid\":\"8\",\"mark\":\"10\"},{\"mdtid\":3,\"mdcid\":\"4\",\"mark\":\"\"},{\"mdtid\":3,\"mdcid\":\"5\",\"mark\":\"50\"},{\"mdtid\":3,\"mdcid\":\"6\",\"mark\":\"\"}]', NULL, 'eng', 1, '2025-05-17 22:24:38', NULL);


#
# TABLE STRUCTURE FOR: exam_classwise_subjects_mark
#

DROP TABLE IF EXISTS `exam_classwise_subjects_mark`;

CREATE TABLE `exam_classwise_subjects_mark` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `class_id` int(10) DEFAULT NULL,
  `subject_id` int(10) DEFAULT NULL,
  `subject_mark_type` int(5) DEFAULT NULL COMMENT '1-Marks/2-Grade',
  `max_mark` int(10) DEFAULT NULL,
  `min_mark` int(10) DEFAULT NULL,
  `aakarik_mark` int(10) DEFAULT NULL,
  `sankalit_mark` int(10) DEFAULT NULL,
  `description` varchar(100) DEFAULT NULL,
  `status` int(5) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `exam_classwise_subjects_mark` (`id`, `class_id`, `subject_id`, `subject_mark_type`, `max_mark`, `min_mark`, `aakarik_mark`, `sankalit_mark`, `description`, `status`, `created_at`, `updated_at`) VALUES (1, 20, 2, 1, 100, 35, 50, 50, '', 1, '2023-12-02 17:03:06', NULL);
INSERT INTO `exam_classwise_subjects_mark` (`id`, `class_id`, `subject_id`, `subject_mark_type`, `max_mark`, `min_mark`, `aakarik_mark`, `sankalit_mark`, `description`, `status`, `created_at`, `updated_at`) VALUES (2, 20, 1, 1, 100, 33, 50, 50, '', 1, '2023-12-02 17:03:06', NULL);
INSERT INTO `exam_classwise_subjects_mark` (`id`, `class_id`, `subject_id`, `subject_mark_type`, `max_mark`, `min_mark`, `aakarik_mark`, `sankalit_mark`, `description`, `status`, `created_at`, `updated_at`) VALUES (3, 20, 4, 2, 40, 20, 25, 15, '', 1, '2023-12-02 17:03:06', NULL);
INSERT INTO `exam_classwise_subjects_mark` (`id`, `class_id`, `subject_id`, `subject_mark_type`, `max_mark`, `min_mark`, `aakarik_mark`, `sankalit_mark`, `description`, `status`, `created_at`, `updated_at`) VALUES (4, 20, 4, 1, 20, 10, 10, 10, '', 1, '2023-12-08 15:03:07', NULL);
INSERT INTO `exam_classwise_subjects_mark` (`id`, `class_id`, `subject_id`, `subject_mark_type`, `max_mark`, `min_mark`, `aakarik_mark`, `sankalit_mark`, `description`, `status`, `created_at`, `updated_at`) VALUES (5, 20, 3, 1, 100, 35, 40, 60, '', 3, '2024-01-26 18:32:19', NULL);
INSERT INTO `exam_classwise_subjects_mark` (`id`, `class_id`, `subject_id`, `subject_mark_type`, `max_mark`, `min_mark`, `aakarik_mark`, `sankalit_mark`, `description`, `status`, `created_at`, `updated_at`) VALUES (6, 1, 1, 1, 100, 33, 50, 50, '', 1, '2025-05-17 22:21:47', NULL);
INSERT INTO `exam_classwise_subjects_mark` (`id`, `class_id`, `subject_id`, `subject_mark_type`, `max_mark`, `min_mark`, `aakarik_mark`, `sankalit_mark`, `description`, `status`, `created_at`, `updated_at`) VALUES (7, 1, 2, 1, 100, 33, 50, 50, '', 1, '2025-05-17 22:22:21', NULL);


#
# TABLE STRUCTURE FOR: exam_group_class_batch_exam_students
#

DROP TABLE IF EXISTS `exam_group_class_batch_exam_students`;

CREATE TABLE `exam_group_class_batch_exam_students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_class_batch_exam_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `student_session_id` int(11) NOT NULL,
  `roll_no` int(11) DEFAULT NULL,
  `teacher_remark` text DEFAULT NULL,
  `rank` int(11) NOT NULL DEFAULT 0,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `exam_group_class_batch_exam_id` (`exam_group_class_batch_exam_id`),
  KEY `student_id` (`student_id`),
  KEY `student_session_id` (`student_session_id`),
  CONSTRAINT `exam_group_class_batch_exam_students_ibfk_1` FOREIGN KEY (`exam_group_class_batch_exam_id`) REFERENCES `exam_group_class_batch_exams` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_class_batch_exam_students_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_class_batch_exam_students_ibfk_3` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `exam_group_class_batch_exam_students` (`id`, `exam_group_class_batch_exam_id`, `student_id`, `student_session_id`, `roll_no`, `teacher_remark`, `rank`, `is_active`, `created_at`, `updated_at`) VALUES (1, 1, 1, 1, NULL, NULL, 0, 0, '2025-06-13 11:36:29', '2025-06-13 11:36:29');


#
# TABLE STRUCTURE FOR: exam_group_class_batch_exam_subjects
#

DROP TABLE IF EXISTS `exam_group_class_batch_exam_subjects`;

CREATE TABLE `exam_group_class_batch_exam_subjects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_class_batch_exams_id` int(11) DEFAULT NULL,
  `subject_id` int(11) NOT NULL,
  `class_id` int(11) DEFAULT NULL,
  `section_id` int(11) DEFAULT NULL,
  `date_from` date NOT NULL,
  `time_from` time NOT NULL,
  `duration` varchar(50) NOT NULL,
  `room_no` varchar(100) DEFAULT NULL,
  `max_marks` float(10,2) DEFAULT NULL,
  `min_marks` float(10,2) DEFAULT NULL,
  `credit_hours` float(10,2) DEFAULT 0.00,
  `date_to` datetime DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `exam_group_class_batch_exams_id` (`exam_group_class_batch_exams_id`),
  KEY `subject_id` (`subject_id`),
  CONSTRAINT `exam_group_class_batch_exam_subjects_ibfk_1` FOREIGN KEY (`exam_group_class_batch_exams_id`) REFERENCES `exam_group_class_batch_exams` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_class_batch_exam_subjects_ibfk_2` FOREIGN KEY (`subject_id`) REFERENCES `subjects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `exam_group_class_batch_exam_subjects` (`id`, `exam_group_class_batch_exams_id`, `subject_id`, `class_id`, `section_id`, `date_from`, `time_from`, `duration`, `room_no`, `max_marks`, `min_marks`, `credit_hours`, `date_to`, `is_active`, `created_at`, `updated_at`) VALUES (7, 1, 2, NULL, NULL, '2025-06-13', '16:06:41', '0', '1', '100.00', '33.00', '0.00', NULL, 0, '2025-06-13 11:37:07', '2025-06-13 11:37:07');


#
# TABLE STRUCTURE FOR: exam_group_class_batch_exams
#

DROP TABLE IF EXISTS `exam_group_class_batch_exams`;

CREATE TABLE `exam_group_class_batch_exams` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam` varchar(250) DEFAULT NULL,
  `passing_percentage` float(10,2) DEFAULT NULL,
  `session_id` int(11) NOT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `exam_group_id` int(11) DEFAULT NULL,
  `use_exam_roll_no` int(11) NOT NULL DEFAULT 1,
  `is_termexam` varchar(50) DEFAULT NULL,
  `is_publish` int(11) DEFAULT 0,
  `is_rank_generated` int(11) NOT NULL DEFAULT 0,
  `description` text DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `exam_group_id` (`exam_group_id`),
  KEY `exam_group_class_batch_exams_ibfk_2` (`session_id`),
  CONSTRAINT `exam_group_class_batch_exams_ibfk_1` FOREIGN KEY (`exam_group_id`) REFERENCES `exam_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_class_batch_exams_ibfk_2` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `exam_group_class_batch_exams` (`id`, `exam`, `passing_percentage`, `session_id`, `date_from`, `date_to`, `exam_group_id`, `use_exam_roll_no`, `is_termexam`, `is_publish`, `is_rank_generated`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Exam test', NULL, 19, NULL, NULL, 1, 1, NULL, 1, 0, 'lorem', 1, '2025-05-21 05:59:06', '2025-06-13 11:41:26');


#
# TABLE STRUCTURE FOR: exam_group_exam_connections
#

DROP TABLE IF EXISTS `exam_group_exam_connections`;

CREATE TABLE `exam_group_exam_connections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_id` int(11) DEFAULT NULL,
  `exam_group_class_batch_exams_id` int(11) DEFAULT NULL,
  `exam_weightage` float(10,2) DEFAULT 0.00,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `exam_group_id` (`exam_group_id`),
  KEY `exam_group_class_batch_exams_id` (`exam_group_class_batch_exams_id`),
  CONSTRAINT `exam_group_exam_connections_ibfk_1` FOREIGN KEY (`exam_group_id`) REFERENCES `exam_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_exam_connections_ibfk_2` FOREIGN KEY (`exam_group_class_batch_exams_id`) REFERENCES `exam_group_class_batch_exams` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: exam_group_exam_results
#

DROP TABLE IF EXISTS `exam_group_exam_results`;

CREATE TABLE `exam_group_exam_results` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_class_batch_exam_student_id` int(11) NOT NULL,
  `exam_group_class_batch_exam_subject_id` int(11) DEFAULT NULL,
  `exam_group_student_id` int(11) DEFAULT NULL,
  `attendence` varchar(10) DEFAULT NULL,
  `get_marks` float(10,2) DEFAULT 0.00,
  `note` text DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `exam_group_class_batch_exam_subject_id` (`exam_group_class_batch_exam_subject_id`),
  KEY `exam_group_student_id` (`exam_group_student_id`),
  KEY `exam_group_class_batch_exam_student_id` (`exam_group_class_batch_exam_student_id`),
  CONSTRAINT `exam_group_exam_results_ibfk_1` FOREIGN KEY (`exam_group_class_batch_exam_subject_id`) REFERENCES `exam_group_class_batch_exam_subjects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_exam_results_ibfk_2` FOREIGN KEY (`exam_group_student_id`) REFERENCES `exam_group_students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_exam_results_ibfk_3` FOREIGN KEY (`exam_group_class_batch_exam_student_id`) REFERENCES `exam_group_class_batch_exam_students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: exam_group_students
#

DROP TABLE IF EXISTS `exam_group_students`;

CREATE TABLE `exam_group_students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_group_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `student_session_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `exam_group_id` (`exam_group_id`),
  KEY `student_id` (`student_id`),
  KEY `student_session_id` (`student_session_id`),
  CONSTRAINT `exam_group_students_ibfk_1` FOREIGN KEY (`exam_group_id`) REFERENCES `exam_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_students_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_group_students_ibfk_3` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: exam_groups
#

DROP TABLE IF EXISTS `exam_groups`;

CREATE TABLE `exam_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `exam_type` varchar(250) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` int(11) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `exam_groups` (`id`, `name`, `exam_type`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'test', 'basic_system', 'lorem', 0, '2025-05-21 05:58:00', '2025-05-21 05:58:00');


#
# TABLE STRUCTURE FOR: exam_mark_distribution_component
#

DROP TABLE IF EXISTS `exam_mark_distribution_component`;

CREATE TABLE `exam_mark_distribution_component` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `mdtid` int(5) DEFAULT NULL,
  `name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `description` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `status` int(5) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (1, 3, 'Unit Testta', '', 1, '2023-11-21 17:35:20', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (2, 1, 'Home work', '', 1, '2023-11-21 17:35:20', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (3, 1, 'sdfsdf', '', 3, '2023-11-21 17:35:20', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (4, 3, 'Oral test', '', 1, '2023-12-09 08:41:00', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (5, 3, 'Writtrn test', '', 1, '2023-12-09 08:41:00', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (6, 3, 'Health test', '', 3, '2024-01-21 09:43:35', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (7, 1, 'Tondi kaam', '', 3, '2024-01-26 18:21:17', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (8, 1, 'Sports', '', 3, '2025-05-17 22:14:36', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (9, 1, 'a', '', 3, '2025-05-19 08:31:06', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (10, 1, 'a', '', 3, '2025-05-19 08:31:06', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (11, 5, 'ANIL TESTING', '', 3, '2025-05-22 00:55:06', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (12, 3, 'yes', '', 3, '2025-06-11 13:08:59', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (13, 3, 'udgir', '', 3, '2025-06-11 13:08:59', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (14, 3, 'ATTAR', '', 3, '2025-06-15 17:38:38', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (15, 4, 'ATTAR', '', 3, '2025-06-15 17:38:57', NULL);
INSERT INTO `exam_mark_distribution_component` (`id`, `mdtid`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (16, 4, 'ATTAR', '', 3, '2025-06-15 17:38:57', NULL);


#
# TABLE STRUCTURE FOR: exam_marks_distribution_type
#

DROP TABLE IF EXISTS `exam_marks_distribution_type`;

CREATE TABLE `exam_marks_distribution_type` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `description` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `exam_marks_distribution_type` (`id`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (1, 'आकारीक2', 'basic_systemx आकारीक', 1, '2023-11-21 07:03:07', '2023-11-21 06:00:00');
INSERT INTO `exam_marks_distribution_type` (`id`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (3, 'संकलित', 'संकलित mark Distribution Type', 1, '2023-12-09 08:39:37', NULL);
INSERT INTO `exam_marks_distribution_type` (`id`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (4, 'a', 'a', 1, '2025-05-19 08:02:54', NULL);
INSERT INTO `exam_marks_distribution_type` (`id`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (5, 'Dev sys', '', 1, '2025-05-22 00:54:45', NULL);
INSERT INTO `exam_marks_distribution_type` (`id`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (6, 'att', 'tets', 1, '2025-06-11 13:06:59', NULL);
INSERT INTO `exam_marks_distribution_type` (`id`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (7, 'ATTAR', '', 1, '2025-06-15 17:37:57', NULL);
INSERT INTO `exam_marks_distribution_type` (`id`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (8, 'ATTAR', '', 1, '2025-06-15 17:38:09', NULL);
INSERT INTO `exam_marks_distribution_type` (`id`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES (9, 'ATTAR', '', 1, '2025-06-15 17:38:24', NULL);


#
# TABLE STRUCTURE FOR: exam_schedules
#

DROP TABLE IF EXISTS `exam_schedules`;

CREATE TABLE `exam_schedules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) NOT NULL,
  `exam_id` int(11) DEFAULT NULL,
  `teacher_subject_id` int(11) DEFAULT NULL,
  `date_of_exam` date DEFAULT NULL,
  `start_to` varchar(50) DEFAULT NULL,
  `end_from` varchar(50) DEFAULT NULL,
  `room_no` varchar(50) DEFAULT NULL,
  `full_marks` int(11) DEFAULT NULL,
  `passing_marks` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `teacher_subject_id` (`teacher_subject_id`),
  KEY `session_id` (`session_id`),
  KEY `exam_id` (`exam_id`),
  CONSTRAINT `exam_schedules_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `exam_schedules_ibfk_2` FOREIGN KEY (`exam_id`) REFERENCES `exams` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: exam_scorecard_component
#

DROP TABLE IF EXISTS `exam_scorecard_component`;

CREATE TABLE `exam_scorecard_component` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `component_name` varchar(100) DEFAULT NULL,
  `subject_mark_grade` varchar(100) DEFAULT NULL,
  `classes` varchar(100) DEFAULT NULL,
  `status` int(5) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `exam_scorecard_component` (`id`, `component_name`, `subject_mark_grade`, `classes`, `status`, `created_at`, `updated_at`) VALUES (1, 'NEED TO IMPROVE', '', '[\"1\"]', 1, '2024-03-10 21:34:54', NULL);
INSERT INTO `exam_scorecard_component` (`id`, `component_name`, `subject_mark_grade`, `classes`, `status`, `created_at`, `updated_at`) VALUES (2, 'Pragati important', '[\"3\"]', '[\"19\",\"20\"]', 1, '2024-03-11 04:48:29', NULL);
INSERT INTO `exam_scorecard_component` (`id`, `component_name`, `subject_mark_grade`, `classes`, `status`, `created_at`, `updated_at`) VALUES (3, 'need book', '', '[\"5\",\"6\"]', 1, '2025-05-21 04:59:43', NULL);
INSERT INTO `exam_scorecard_component` (`id`, `component_name`, `subject_mark_grade`, `classes`, `status`, `created_at`, `updated_at`) VALUES (4, 'attu', '', '[\"6\"]', 1, '2025-06-11 13:54:43', NULL);
INSERT INTO `exam_scorecard_component` (`id`, `component_name`, `subject_mark_grade`, `classes`, `status`, `created_at`, `updated_at`) VALUES (5, 'a', '', '[\"1\"]', 1, '2025-06-11 13:55:00', NULL);
INSERT INTO `exam_scorecard_component` (`id`, `component_name`, `subject_mark_grade`, `classes`, `status`, `created_at`, `updated_at`) VALUES (6, 'primary', '', '[\"1\",\"2\",\"3\",\"4\",\"5\",\"6\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\"]', 1, '2025-06-16 05:32:07', NULL);
INSERT INTO `exam_scorecard_component` (`id`, `component_name`, `subject_mark_grade`, `classes`, `status`, `created_at`, `updated_at`) VALUES (7, 'attar', '', '[\"1\",\"2\",\"3\",\"4\",\"5\",\"6\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\"]', 1, '2025-06-16 05:41:06', NULL);


#
# TABLE STRUCTURE FOR: exam_subjectwise_remark
#

DROP TABLE IF EXISTS `exam_subjectwise_remark`;

CREATE TABLE `exam_subjectwise_remark` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `subject_id` int(5) DEFAULT NULL,
  `remark_name` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `note` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `lang_id` varchar(300) DEFAULT NULL,
  `subjects` varchar(300) DEFAULT NULL,
  `status` int(5) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (6, 1, 'ALWAYS PARTICIPATES IN ROLE PLAYS AND DRAMAS', NULL, 'eng', 'english', 3, '2024-01-26 17:31:12', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (5, 1, 'ACTIVELY PARTICIPATES IN ENGLISH PARIPATH IN SCHOOL', NULL, 'eng', 'english', 1, '2024-01-26 17:31:12', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (7, 1, 'COMPLETES THE GIVEN HOMEWORK IN TIME', NULL, 'eng', 'english', 1, '2024-01-26 17:31:12', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (8, 1, 'CONSTRUCTS SIMPLE SENTENCES IN ENGLISH', NULL, 'eng', 'english', 1, '2024-01-26 17:35:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (9, 1, 'COPIES THE LETTERS AND WORDS CORRECTLY', NULL, 'eng', 'english', 1, '2024-01-26 17:35:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (10, 1, 'ENJOYS THE RHYTHM AND UNDERSTANDS', NULL, 'eng', 'english', 1, '2024-01-26 17:35:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (11, 1, 'GIVES RESPONSES IN VARIOUS CONTEXT', NULL, 'eng', 'english', 1, '2024-01-26 17:35:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (12, 1, 'GOOD', NULL, 'eng', 'english', 1, '2024-01-26 17:35:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (13, 1, 'IDENTIFIES COMMONLY USED WORDS', NULL, 'eng', 'english', 1, '2024-01-26 17:35:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (14, 1, 'LIKES TO READ SIMPLE ENGLISH STORIES IN SPARE TIME', NULL, 'eng', 'english', 1, '2024-01-26 17:35:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (15, 1, 'LISTENS CAREFULLY AND FOLLOWS THE INSTRUCTIONS', NULL, 'eng', 'english', 1, '2024-01-26 17:35:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (16, 1, 'LISTENS WITH CONCENTRATION', NULL, 'eng', 'english', 1, '2024-01-26 17:35:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (17, 1, 'PARTICIPATES IN CONVERSATIONS', NULL, 'eng', 'english', 1, '2024-01-26 17:35:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (18, 1, 'READS ALOUD FROM TEXTBOOK', NULL, 'eng', 'english', 1, '2024-01-26 17:35:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (19, 1, 'READS ALOUD WITH PROPER PUNCTUATION', NULL, 'eng', 'english', 1, '2024-01-26 17:35:24', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (20, 1, 'READS AND ACT ACCORDINGLY', NULL, 'eng', 'english', 1, '2024-01-26 17:37:55', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (21, 1, 'READS ENGLISH DAILY NEWSPAPER', NULL, 'eng', 'english', 1, '2024-01-26 17:37:55', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (22, 1, 'READS SILENTLY BY UNDERSTANDING', NULL, 'eng', 'english', 1, '2024-01-26 17:37:55', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (23, 1, 'READS THE PART IN DIALOGUES WITH UNDERSTANDING', NULL, 'eng', 'english', 1, '2024-01-26 17:37:55', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (24, 1, 'READS THE POEM IN RHYTHM', NULL, 'eng', 'english', 1, '2024-01-26 17:37:55', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (25, 1, 'REARRANGES COMMONLY USED WORDS', NULL, 'eng', 'english', 1, '2024-01-26 17:37:55', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (26, 1, 'REARRANGES THE STORY EVENTS', NULL, 'eng', 'english', 1, '2024-01-26 17:37:55', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (27, 1, 'RECITES POEMS AND SONGS WITH FUN', NULL, 'eng', 'english', 1, '2024-01-26 17:37:55', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (28, 2, 'ALWAYS PARTICIPATES IN ROLE PLAYS AND DRAMAS', '', NULL, NULL, 1, '2025-02-28 10:34:36', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (29, 1, 'EXCELENT', '', NULL, NULL, 3, '2025-05-17 22:20:02', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (30, 1, 'ANIL REMARK', '', NULL, NULL, 1, '2025-05-22 00:55:32', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (31, 31, 'ATTAR', '', NULL, NULL, 1, '2025-06-15 17:39:56', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (32, 31, 'ATTAR', '', NULL, NULL, 1, '2025-06-15 17:39:56', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (33, 31, 'ATTAR', '', NULL, NULL, 1, '2025-06-15 17:39:57', NULL);
INSERT INTO `exam_subjectwise_remark` (`id`, `subject_id`, `remark_name`, `note`, `lang_id`, `subjects`, `status`, `created_at`, `updated_at`) VALUES (34, 31, 'ATTAR', '', NULL, NULL, 1, '2025-06-15 17:39:57', NULL);


#
# TABLE STRUCTURE FOR: exams
#

DROP TABLE IF EXISTS `exams`;

CREATE TABLE `exams` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `sesion_id` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `sesion_id` (`sesion_id`),
  CONSTRAINT `exams_ibfk_1` FOREIGN KEY (`sesion_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: expense_head
#

DROP TABLE IF EXISTS `expense_head`;

CREATE TABLE `expense_head` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_category` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_head_id` int(11) DEFAULT NULL,
  `inc_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `documents` varchar(255) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `exp_head_id` (`exp_head_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `expenses` (`id`, `exp_head_id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (1, 1, 0, 'test', '32324', '2025-06-03', '200.00', NULL, 'test', 'yes', 'no', '2025-06-03 10:02:11', '2025-06-03 10:02:11');
INSERT INTO `expenses` (`id`, `exp_head_id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES (2, 1, 2, 'acc', '987', '2025-06-11', '100000.00', NULL, '', 'yes', 'no', '2025-06-11 19:05:38', '2025-06-11 19:05:38');


#
# TABLE STRUCTURE FOR: fee_groups
#

DROP TABLE IF EXISTS `fee_groups`;

CREATE TABLE `fee_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `is_system` int(11) NOT NULL DEFAULT 0,
  `description` text DEFAULT NULL,
  `nature` varchar(255) NOT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `nature`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Primary', 0, 'Primary', '', 'no', '2025-05-07 12:27:07', '2025-05-07 12:27:07');
INSERT INTO `fee_groups` (`id`, `name`, `is_system`, `description`, `nature`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'attu', 0, '', '', 'no', '2025-06-11 17:07:44', '2025-06-11 17:07:44');


#
# TABLE STRUCTURE FOR: fee_groups_feetype
#

DROP TABLE IF EXISTS `fee_groups_feetype`;

CREATE TABLE `fee_groups_feetype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fee_session_group_id` int(11) DEFAULT NULL,
  `fee_groups_id` int(11) DEFAULT NULL,
  `feetype_id` int(11) DEFAULT NULL,
  `session_id` int(11) DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `fine_type` varchar(50) NOT NULL DEFAULT 'none',
  `due_date` date DEFAULT NULL,
  `fine_percentage` float(10,2) NOT NULL DEFAULT 0.00,
  `fine_amount` float(10,2) NOT NULL DEFAULT 0.00,
  `fine_per_day` int(11) NOT NULL DEFAULT 0,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `fee_session_group_id` (`fee_session_group_id`),
  KEY `fee_groups_id` (`fee_groups_id`),
  KEY `feetype_id` (`feetype_id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `fee_groups_feetype_ibfk_1` FOREIGN KEY (`fee_session_group_id`) REFERENCES `fee_session_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_groups_feetype_ibfk_2` FOREIGN KEY (`fee_groups_id`) REFERENCES `fee_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_groups_feetype_ibfk_4` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `fee_groups_feetype` (`id`, `fee_session_group_id`, `fee_groups_id`, `feetype_id`, `session_id`, `amount`, `fine_type`, `due_date`, `fine_percentage`, `fine_amount`, `fine_per_day`, `is_active`, `created_at`, `updated_at`) VALUES (1, 6, 1, 1, 21, '1000.00', 'none', '2025-06-30', '0.00', '0.00', 0, 'no', '2025-06-19 10:15:00', '2025-06-19 10:15:00');


#
# TABLE STRUCTURE FOR: fee_head_course
#

DROP TABLE IF EXISTS `fee_head_course`;

CREATE TABLE `fee_head_course` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` int(11) NOT NULL,
  `class_ids` int(11) NOT NULL,
  `section_id` varchar(255) NOT NULL,
  `fee_cat_id` int(11) NOT NULL,
  `fee_type_id` int(11) NOT NULL,
  `amount` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `fee_head_course` (`id`, `course_id`, `class_ids`, `section_id`, `fee_cat_id`, `fee_type_id`, `amount`, `status`, `created_at`, `updated_at`) VALUES (2, 2, 20, '[\"1\",\"2\"]', 1, 0, '100', '1', '2024-08-28 14:14:20', NULL);
INSERT INTO `fee_head_course` (`id`, `course_id`, `class_ids`, `section_id`, `fee_cat_id`, `fee_type_id`, `amount`, `status`, `created_at`, `updated_at`) VALUES (3, 2, 20, '[\"1\"]', 1, 2, '100', '1', '2024-08-30 08:09:50', NULL);
INSERT INTO `fee_head_course` (`id`, `course_id`, `class_ids`, `section_id`, `fee_cat_id`, `fee_type_id`, `amount`, `status`, `created_at`, `updated_at`) VALUES (5, 3, 1, '[\"1\"]', 2, 2, '100', '1', '2025-06-12 10:12:56', NULL);
INSERT INTO `fee_head_course` (`id`, `course_id`, `class_ids`, `section_id`, `fee_cat_id`, `fee_type_id`, `amount`, `status`, `created_at`, `updated_at`) VALUES (6, 3, 1, '[\"1\"]', 2, 2, '100', '1', '2025-06-12 10:39:42', NULL);
INSERT INTO `fee_head_course` (`id`, `course_id`, `class_ids`, `section_id`, `fee_cat_id`, `fee_type_id`, `amount`, `status`, `created_at`, `updated_at`) VALUES (7, 3, 1, '[\"1\"]', 2, 2, '100', '1', '2025-06-12 10:40:36', NULL);
INSERT INTO `fee_head_course` (`id`, `course_id`, `class_ids`, `section_id`, `fee_cat_id`, `fee_type_id`, `amount`, `status`, `created_at`, `updated_at`) VALUES (8, 3, 1, '[\"1\"]', 2, 2, '100', '1', '2025-06-12 10:42:52', NULL);
INSERT INTO `fee_head_course` (`id`, `course_id`, `class_ids`, `section_id`, `fee_cat_id`, `fee_type_id`, `amount`, `status`, `created_at`, `updated_at`) VALUES (9, 3, 1, '[\"1\"]', 2, 2, '100', '1', '2025-06-12 10:42:57', NULL);
INSERT INTO `fee_head_course` (`id`, `course_id`, `class_ids`, `section_id`, `fee_cat_id`, `fee_type_id`, `amount`, `status`, `created_at`, `updated_at`) VALUES (10, 3, 1, '[\"1\"]', 2, 2, '100', '1', '2025-06-12 10:43:27', NULL);
INSERT INTO `fee_head_course` (`id`, `course_id`, `class_ids`, `section_id`, `fee_cat_id`, `fee_type_id`, `amount`, `status`, `created_at`, `updated_at`) VALUES (11, 3, 1, '[\"2\"]', 2, 2, '1000', '0', '2025-06-12 10:44:10', '2025-06-12 10:44:20');


#
# TABLE STRUCTURE FOR: fee_receipt_no
#

DROP TABLE IF EXISTS `fee_receipt_no`;

CREATE TABLE `fee_receipt_no` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: fee_session_groups
#

DROP TABLE IF EXISTS `fee_session_groups`;

CREATE TABLE `fee_session_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fee_groups_id` int(11) DEFAULT NULL,
  `session_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `fee_groups_id` (`fee_groups_id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `fee_session_groups_ibfk_1` FOREIGN KEY (`fee_groups_id`) REFERENCES `fee_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fee_session_groups_ibfk_2` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`, `updated_at`) VALUES (1, 1, 19, 'no', '2025-05-07 12:28:16', '2025-05-07 12:28:16');
INSERT INTO `fee_session_groups` (`id`, `fee_groups_id`, `session_id`, `is_active`, `created_at`, `updated_at`) VALUES (6, 1, 21, 'no', '2025-06-19 10:15:00', '2025-06-19 10:15:00');


#
# TABLE STRUCTURE FOR: feecategory
#

DROP TABLE IF EXISTS `feecategory`;

CREATE TABLE `feecategory` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(50) DEFAULT NULL,
  `cast_cat_id` int(11) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `feecategory` (`id`, `category`, `cast_cat_id`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'GOI', 1, 'no', '2024-08-26 18:12:58', NULL);
INSERT INTO `feecategory` (`id`, `category`, `cast_cat_id`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'test', 2, 'no', '2025-06-04 10:03:53', NULL);


#
# TABLE STRUCTURE FOR: feemasters
#

DROP TABLE IF EXISTS `feemasters`;

CREATE TABLE `feemasters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) DEFAULT NULL,
  `feetype_id` int(11) NOT NULL,
  `class_id` int(11) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  KEY `feetype_id` (`feetype_id`),
  KEY `class_id` (`class_id`),
  CONSTRAINT `feemasters_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `feemasters_ibfk_2` FOREIGN KEY (`feetype_id`) REFERENCES `oldfeetype` (`id`) ON DELETE CASCADE,
  CONSTRAINT `feemasters_ibfk_3` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: fees_discounts
#

DROP TABLE IF EXISTS `fees_discounts`;

CREATE TABLE `fees_discounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `code` varchar(100) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `percentage` float(10,2) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `discount_limit` int(11) DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `fees_discounts_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: fees_reminder
#

DROP TABLE IF EXISTS `fees_reminder`;

CREATE TABLE `fees_reminder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reminder_type` varchar(10) DEFAULT NULL,
  `day` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `fees_reminder` (`id`, `reminder_type`, `day`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'before', 2, 1, '2020-02-28 13:38:32', NULL);
INSERT INTO `fees_reminder` (`id`, `reminder_type`, `day`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'before', 5, 1, '2020-02-28 13:38:36', NULL);
INSERT INTO `fees_reminder` (`id`, `reminder_type`, `day`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'after', 2, 1, '2020-02-28 13:38:40', NULL);
INSERT INTO `fees_reminder` (`id`, `reminder_type`, `day`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'after', 5, 1, '2020-02-28 13:38:44', NULL);


#
# TABLE STRUCTURE FOR: feesrevert_reasons
#

DROP TABLE IF EXISTS `feesrevert_reasons`;

CREATE TABLE `feesrevert_reasons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason` varchar(255) NOT NULL,
  `description` varchar(1000) DEFAULT NULL,
  `status` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `feesrevert_reasons` (`id`, `reason`, `description`, `status`, `created_at`, `updated_at`) VALUES (1, 'test1', 'testing1', '1', '2024-08-27 16:19:45', '2024-08-27 16:44:41');


#
# TABLE STRUCTURE FOR: feetype
#

DROP TABLE IF EXISTS `feetype`;

CREATE TABLE `feetype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_system` int(11) NOT NULL DEFAULT 0,
  `feecategory_id` int(11) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `bank_account` varchar(255) DEFAULT NULL,
  `collection_type` varchar(255) DEFAULT NULL,
  `code` varchar(100) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `description` text DEFAULT NULL,
  `session_id` int(11) DEFAULT NULL,
  `student_session_id` int(11) DEFAULT NULL,
  `nature` varchar(255) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `bank_account`, `collection_type`, `code`, `is_active`, `description`, `session_id`, `student_session_id`, `nature`, `status`, `created_at`, `updated_at`) VALUES (1, 0, NULL, 'Primary ', '2', 'expense', 'PRM01', 'no', '', NULL, NULL, '', '1', '2025-05-07 12:27:26', '2025-05-07 12:27:26');
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `bank_account`, `collection_type`, `code`, `is_active`, `description`, `session_id`, `student_session_id`, `nature`, `status`, `created_at`, `updated_at`) VALUES (2, 0, NULL, 'Bus Fees', '2', 'income', 'bus01', 'no', '', NULL, NULL, '', '1', '2025-06-03 07:41:28', '2025-06-03 07:41:28');
INSERT INTO `feetype` (`id`, `is_system`, `feecategory_id`, `type`, `bank_account`, `collection_type`, `code`, `is_active`, `description`, `session_id`, `student_session_id`, `nature`, `status`, `created_at`, `updated_at`) VALUES (3, 0, NULL, 'attu', '2', 'expense', '80000', 'no', 'atta', NULL, NULL, '', '1', '2025-06-11 17:08:36', '2025-06-11 17:08:36');


#
# TABLE STRUCTURE FOR: filetypes
#

DROP TABLE IF EXISTS `filetypes`;

CREATE TABLE `filetypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_extension` text DEFAULT NULL,
  `file_mime` text DEFAULT NULL,
  `file_size` int(11) NOT NULL,
  `image_extension` text DEFAULT NULL,
  `image_mime` text DEFAULT NULL,
  `image_size` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `filetypes` (`id`, `file_extension`, `file_mime`, `file_size`, `image_extension`, `image_mime`, `image_size`, `created_at`, `updated_at`) VALUES (1, 'pdf, zip, jpg, jpeg, png, txt, 7z, gif, csv, docx, mp3, mp4, accdb, odt, ods, ppt, pptx, xlsx, wmv, jfif, apk, ppt, bmp, jpe, mdb, rar, xls, svg', 'application/pdf, image/zip, image/jpg, image/png, image/jpeg, text/plain, application/x-zip-compressed, application/zip, image/gif, text/csv, application/vnd.openxmlformats-officedocument.wordprocessingml.document, audio/mpeg, application/msaccess, application/vnd.oasis.opendocument.text, application/vnd.oasis.opendocument.spreadsheet, application/vnd.ms-powerpoint, application/vnd.openxmlformats-officedocument.presentationml.presentation, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, video/x-ms-wmv, video/mp4, image/jpeg, application/vnd.android.package-archive, application/x-msdownload, application/vnd.ms-powerpoint, image/bmp, image/jpeg, application/msaccess, application/vnd.ms-excel, image/svg+xml', 100048576, 'jfif, png, jpe, jpeg, jpg, bmp, gif, svg', 'image/jpeg, image/png, image/jpeg, image/jpeg, image/bmp, image/gif, image/x-ms-bmp, image/svg+xml', 10048576, '2021-01-30 13:03:03', '2025-04-09 22:52:06');


#
# TABLE STRUCTURE FOR: follow_up
#

DROP TABLE IF EXISTS `follow_up`;

CREATE TABLE `follow_up` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enquiry_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `next_date` date NOT NULL,
  `response` text NOT NULL,
  `note` text NOT NULL,
  `followup_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `enquiry_id` (`enquiry_id`),
  KEY `followup_by` (`followup_by`),
  CONSTRAINT `follow_up_ibfk_1` FOREIGN KEY (`enquiry_id`) REFERENCES `enquiry` (`id`) ON DELETE CASCADE,
  CONSTRAINT `follow_up_ibfk_2` FOREIGN KEY (`followup_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `follow_up` (`id`, `enquiry_id`, `date`, `next_date`, `response`, `note`, `followup_by`, `created_at`, `updated_at`) VALUES (1, 1, '2025-06-21', '2025-06-30', 'new month', '', 1, '2025-06-21 11:45:28', '2025-06-21 11:45:28');


#
# TABLE STRUCTURE FOR: front_cms_media_gallery
#

DROP TABLE IF EXISTS `front_cms_media_gallery`;

CREATE TABLE `front_cms_media_gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image` varchar(300) DEFAULT NULL,
  `thumb_path` varchar(300) DEFAULT NULL,
  `dir_path` varchar(300) DEFAULT NULL,
  `img_name` varchar(300) DEFAULT NULL,
  `thumb_name` varchar(300) DEFAULT NULL,
  `file_type` varchar(100) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `vid_url` text NOT NULL,
  `vid_title` varchar(250) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_menu_items
#

DROP TABLE IF EXISTS `front_cms_menu_items`;

CREATE TABLE `front_cms_menu_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) NOT NULL,
  `menu` varchar(100) DEFAULT NULL,
  `page_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `ext_url` text DEFAULT NULL,
  `open_new_tab` int(11) DEFAULT 0,
  `ext_url_link` text DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `menu_id` (`menu_id`),
  CONSTRAINT `front_cms_menu_items_ibfk_1` FOREIGN KEY (`menu_id`) REFERENCES `front_cms_menus` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 1, 'Home', 1, 0, NULL, NULL, NULL, 'home', 1, 0, NULL, 'no', '2019-12-02 22:11:50', '2025-04-09 22:52:06');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (2, 1, 'Contact Us', 76, 0, NULL, NULL, NULL, 'contact-us', 4, 0, NULL, 'no', '2019-12-02 22:11:52', '2025-04-09 22:52:06');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (3, 1, 'Complain', 2, 0, NULL, NULL, NULL, 'complain', 3, 0, NULL, 'no', '2019-12-02 22:11:52', '2025-04-09 22:52:06');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (4, 1, 'Online Admission', 0, 0, '1', NULL, 'http://yourschoolurl.com/online_admission', 'admssion', 2, 0, NULL, 'no', '2019-12-21 15:33:00', '2025-04-09 22:52:06');


#
# TABLE STRUCTURE FOR: front_cms_menus
#

DROP TABLE IF EXISTS `front_cms_menus`;

CREATE TABLE `front_cms_menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu` varchar(100) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `open_new_tab` int(11) NOT NULL DEFAULT 0,
  `ext_url` text NOT NULL,
  `ext_url_link` text NOT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `content_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Main Menu', 'main-menu', 'Main menu', 0, '', '', 0, 'default', 'no', '2018-04-20 15:54:49', '2025-04-09 22:52:06');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Bottom Menu', 'bottom-menu', 'Bottom Menu', 0, '', '', 0, 'default', 'no', '2018-04-20 15:54:55', '2025-04-09 22:52:06');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'top', 'top', '', 0, '', '', 0, 'manual', 'no', '2025-06-13 14:17:05', '2025-06-13 14:17:05');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'verticle menu', 'verticle-menu', '', 0, '', '', 0, 'manual', 'no', '2025-06-14 08:58:41', '2025-06-14 08:58:41');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'horizontal', 'horizontal', '', 0, '', '', 0, 'manual', 'no', '2025-06-14 08:58:54', '2025-06-14 08:58:54');


#
# TABLE STRUCTURE FOR: front_cms_page_contents
#

DROP TABLE IF EXISTS `front_cms_page_contents`;

CREATE TABLE `front_cms_page_contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_id` int(11) DEFAULT NULL,
  `content_type` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `page_id` (`page_id`),
  CONSTRAINT `front_cms_page_contents_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `front_cms_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_homepage` int(11) DEFAULT 0,
  `title` varchar(250) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `meta_title` text DEFAULT NULL,
  `meta_description` text DEFAULT NULL,
  `meta_keyword` text DEFAULT NULL,
  `feature_image` varchar(200) NOT NULL,
  `description` longtext DEFAULT NULL,
  `publish_date` date DEFAULT NULL,
  `publish` int(11) DEFAULT 0,
  `sidebar` int(11) DEFAULT 0,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'default', 1, 'Home', 'page/home', 'page', 'home', '', '', '', '', '<p>home page</p>', '0000-00-00', 1, NULL, 'no', '2019-12-02 15:23:47', '2025-04-09 22:52:06');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'default', 0, 'Complain', 'page/complain', 'page', 'complain', 'Complain form', '                                                                                                                                                                                    complain form                                                                                                                                                                                                                                ', 'complain form', '', '<p>[form-builder:complain]</p>', '0000-00-00', 1, NULL, 'no', '2019-11-13 10:16:36', '2025-04-09 22:52:06');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'default', 0, '404 page', 'page/404-page', 'page', '404-page', '', '                                ', '', '', '<html>\r\n<head>\r\n <title></title>\r\n</head>\r\n<body>\r\n<p>404 page found</p>\r\n</body>\r\n</html>', '0000-00-00', 0, NULL, 'no', '2018-05-18 15:46:04', '2025-04-09 22:52:06');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'default', 0, 'Contact us', 'page/contact-us', 'page', 'contact-us', '', '', '', '', '<section class=\"contact\">\r\n<div class=\"container\">\r\n<div class=\"row\">\r\n<h2 class=\"col-md-12 col-sm-12\">Send In Your Query</h2>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<div class=\"col-md-12 col-sm-12\">[form-builder:contact_us]<!--./row--></div>\r\n<!--./col-md-12--></div>\r\n<!--./row--></div>\r\n<!--./container--></section>\r\n\r\n<div class=\"col-md-4 col-sm-4\">\r\n<div class=\"contact-item\">\r\n<h3>Our Location</h3>\r\n\r\n<p>350 Fifth Avenue, 34th floor New York NY 10118-3299 USA</p>\r\n</div>\r\n<!--./contact-item--></div>\r\n<!--./col-md-4-->\r\n\r\n<div class=\"col-md-4 col-sm-4\">\r\n<div class=\"contact-item\">\r\n<h3>CALL US</h3>\r\n\r\n<p>E-mail : info@abcschool.com</p>\r\n\r\n<p>Mobile : +91-9009987654</p>\r\n</div>\r\n<!--./contact-item--></div>\r\n<!--./col-md-4-->\r\n\r\n<div class=\"col-md-4 col-sm-4\">\r\n<div class=\"contact-item\">\r\n<h3>Working Hours</h3>\r\n\r\n<p>Mon-Fri : 9 am to 5 pm</p>\r\n\r\n<p>Sat : 9 am to 3 pm</p>\r\n</div>\r\n<!--./contact-item--></div>\r\n<!--./col-md-4-->\r\n\r\n<div class=\"col-md-12 col-sm-12\">\r\n<div class=\"mapWrapper fullwidth\"><iframe frameborder=\"0\" height=\"500\" marginheight=\"0\" marginwidth=\"0\" scrolling=\"no\" src=\"http://maps.google.com/maps?f=q&source=s_q&hl=EN&q=time+square&aq=&sll=40.716558,-73.931122&sspn=0.40438,1.056747&ie=UTF8&rq=1&ev=p&split=1&radius=33.22&hq=time+square&hnear=&ll=37.061753,-95.677185&spn=0.438347,0.769043&z=9&output=embed\" width=\"100%\"></iframe></div>\r\n</div>', '0000-00-00', 0, NULL, 'no', '2019-05-04 16:46:41', '2025-05-09 21:51:49');


#
# TABLE STRUCTURE FOR: front_cms_program_photos
#

DROP TABLE IF EXISTS `front_cms_program_photos`;

CREATE TABLE `front_cms_program_photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `program_id` int(11) DEFAULT NULL,
  `media_gallery_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `program_id` (`program_id`),
  CONSTRAINT `front_cms_program_photos_ibfk_1` FOREIGN KEY (`program_id`) REFERENCES `front_cms_programs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_programs
#

DROP TABLE IF EXISTS `front_cms_programs`;

CREATE TABLE `front_cms_programs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `url` text DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `event_start` date DEFAULT NULL,
  `event_end` date DEFAULT NULL,
  `event_venue` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `meta_title` text NOT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `feature_image` text NOT NULL,
  `publish_date` date DEFAULT NULL,
  `publish` varchar(10) DEFAULT '0',
  `sidebar` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_settings
#

DROP TABLE IF EXISTS `front_cms_settings`;

CREATE TABLE `front_cms_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `theme` varchar(50) DEFAULT NULL,
  `is_active_rtl` int(11) DEFAULT 0,
  `is_active_front_cms` int(11) DEFAULT 0,
  `is_active_sidebar` int(11) DEFAULT 0,
  `logo` varchar(200) DEFAULT NULL,
  `contact_us_email` varchar(100) DEFAULT NULL,
  `complain_form_email` varchar(100) DEFAULT NULL,
  `sidebar_options` text NOT NULL,
  `whatsapp_url` varchar(255) NOT NULL,
  `fb_url` varchar(200) NOT NULL,
  `twitter_url` varchar(200) NOT NULL,
  `youtube_url` varchar(200) NOT NULL,
  `google_plus` varchar(200) NOT NULL,
  `instagram_url` varchar(200) NOT NULL,
  `pinterest_url` varchar(200) NOT NULL,
  `linkedin_url` varchar(200) NOT NULL,
  `google_analytics` text DEFAULT NULL,
  `footer_text` varchar(500) DEFAULT NULL,
  `cookie_consent` varchar(255) NOT NULL,
  `fav_icon` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `front_cms_settings` (`id`, `theme`, `is_active_rtl`, `is_active_front_cms`, `is_active_sidebar`, `logo`, `contact_us_email`, `complain_form_email`, `sidebar_options`, `whatsapp_url`, `fb_url`, `twitter_url`, `youtube_url`, `google_plus`, `instagram_url`, `pinterest_url`, `linkedin_url`, `google_analytics`, `footer_text`, `cookie_consent`, `fav_icon`, `created_at`, `updated_at`) VALUES (1, 'yellow', NULL, 1, 1, './uploads/school_content/logo/1750492287-17475097656856647fd5038company logo.png', '', '', '[\"news\",\"complain\"]', '', '', '', '', '', '', '', '', '', '', '', './uploads/school_content/logo/1750491891-1909549495685662f3c3ee9LOGO-removebg-preview.png', '2023-01-05 06:42:55', '2025-06-21 08:51:27');


#
# TABLE STRUCTURE FOR: gatepasses
#

DROP TABLE IF EXISTS `gatepasses`;

CREATE TABLE `gatepasses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `student_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `start_date` varchar(255) NOT NULL,
  `end_date` varchar(255) NOT NULL,
  `in_time` time NOT NULL,
  `out_time` time NOT NULL,
  `note` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `gatepasses` (`id`, `type`, `student_id`, `staff_id`, `start_date`, `end_date`, `in_time`, `out_time`, `note`) VALUES (1, 'student', 1, NULL, '2025-05-13', '2025-05-13', '13:14:00', '17:14:00', 'GatPass');
INSERT INTO `gatepasses` (`id`, `type`, `student_id`, `staff_id`, `start_date`, `end_date`, `in_time`, `out_time`, `note`) VALUES (2, 'student', 65, NULL, '2025-06-21', '2025-06-21', '13:48:00', '13:52:00', 'qweqw');


#
# TABLE STRUCTURE FOR: gateway_ins
#

DROP TABLE IF EXISTS `gateway_ins`;

CREATE TABLE `gateway_ins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `online_admission_id` int(11) DEFAULT NULL,
  `gateway_name` varchar(50) NOT NULL,
  `module_type` varchar(255) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `parameter_details` mediumtext NOT NULL,
  `payment_status` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `online_admission_id` (`online_admission_id`),
  CONSTRAINT `gateway_ins_ibfk_1` FOREIGN KEY (`online_admission_id`) REFERENCES `online_admissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: gateway_ins_response
#

DROP TABLE IF EXISTS `gateway_ins_response`;

CREATE TABLE `gateway_ins_response` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gateway_ins_id` int(11) DEFAULT NULL,
  `posted_data` text DEFAULT NULL,
  `response` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `gateway_ins_id` (`gateway_ins_id`),
  CONSTRAINT `gateway_ins_response_ibfk_1` FOREIGN KEY (`gateway_ins_id`) REFERENCES `gateway_ins` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: general_calls
#

DROP TABLE IF EXISTS `general_calls`;

CREATE TABLE `general_calls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(12) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(500) NOT NULL,
  `follow_up_date` date NOT NULL,
  `call_duration` varchar(50) NOT NULL,
  `note` text NOT NULL,
  `call_type` varchar(20) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `general_calls` (`id`, `name`, `contact`, `date`, `description`, `follow_up_date`, `call_duration`, `note`, `call_type`, `created_at`, `updated_at`) VALUES (1, 'Sports Games', '8900567342', '2025-04-18', '', '2025-04-25', '35', '', 'Outgoing', '2025-04-18 14:54:53', '2025-04-18 14:54:53');
INSERT INTO `general_calls` (`id`, `name`, `contact`, `date`, `description`, `follow_up_date`, `call_duration`, `note`, `call_type`, `created_at`, `updated_at`) VALUES (2, 'Marketing Manager	', '8909423424', '2025-04-18', '', '2025-04-25', '45', '', 'Incoming', '2025-04-18 14:55:32', '2025-04-18 14:55:32');
INSERT INTO `general_calls` (`id`, `name`, `contact`, `date`, `description`, `follow_up_date`, `call_duration`, `note`, `call_type`, `created_at`, `updated_at`) VALUES (3, 'New Book-Stock	', '845340890', '2025-04-18', '', '2025-04-25', '30', '', 'Outgoing', '2025-04-18 15:11:13', '2025-04-18 15:11:13');
INSERT INTO `general_calls` (`id`, `name`, `contact`, `date`, `description`, `follow_up_date`, `call_duration`, `note`, `call_type`, `created_at`, `updated_at`) VALUES (4, 'Telephone Office	', '890672323', '2025-04-18', '', '2025-04-25', '45', '', 'Incoming', '2025-04-18 15:11:58', '2025-04-18 15:11:58');
INSERT INTO `general_calls` (`id`, `name`, `contact`, `date`, `description`, `follow_up_date`, `call_duration`, `note`, `call_type`, `created_at`, `updated_at`) VALUES (5, 'NILESH', '1916505488', '2025-06-19', '', '0000-00-00', '', '', 'Incoming', '2025-06-19 04:57:51', '2025-06-19 04:57:51');
INSERT INTO `general_calls` (`id`, `name`, `contact`, `date`, `description`, `follow_up_date`, `call_duration`, `note`, `call_type`, `created_at`, `updated_at`) VALUES (6, 'SATISH', '6545088191', '2025-06-19', '', '0000-00-00', '', '', 'Outgoing', '2025-06-19 05:31:00', '2025-06-19 05:31:00');


#
# TABLE STRUCTURE FOR: generalcertificate
#

DROP TABLE IF EXISTS `generalcertificate`;

CREATE TABLE `generalcertificate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `serialno` int(11) DEFAULT NULL,
  `register_no` varchar(100) DEFAULT NULL,
  `first_name` varchar(100) DEFAULT NULL,
  `father_name` varchar(100) DEFAULT NULL,
  `last_name` varchar(100) DEFAULT NULL,
  `mother_tongue` varchar(50) DEFAULT NULL,
  `religion` varchar(50) DEFAULT NULL,
  `caste` varchar(50) DEFAULT NULL,
  `place_of_birth` varchar(250) DEFAULT NULL,
  `dob` varchar(100) DEFAULT NULL,
  `prev_school_name` varchar(100) DEFAULT NULL,
  `admission_date` varchar(50) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `admission_no` varchar(50) DEFAULT NULL,
  `student_idno` varchar(50) DEFAULT NULL,
  `subcaste` varchar(50) DEFAULT NULL,
  `reaon_leaving` varchar(100) DEFAULT NULL,
  `adharno` varchar(50) DEFAULT NULL,
  `certificate_number` varchar(50) DEFAULT NULL,
  `admitted_class` varchar(100) DEFAULT NULL,
  `academic_preference` varchar(100) DEFAULT NULL,
  `academic_conduct` varchar(100) DEFAULT NULL,
  `date_of_leaving` varchar(100) DEFAULT NULL,
  `left_class` varchar(100) DEFAULT NULL,
  `remark` varchar(100) DEFAULT NULL,
  `created_at` date DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `generalcertificate` (`id`, `serialno`, `register_no`, `first_name`, `father_name`, `last_name`, `mother_tongue`, `religion`, `caste`, `place_of_birth`, `dob`, `prev_school_name`, `admission_date`, `type`, `admission_no`, `student_idno`, `subcaste`, `reaon_leaving`, `adharno`, `certificate_number`, `admitted_class`, `academic_preference`, `academic_conduct`, `date_of_leaving`, `left_class`, `remark`, `created_at`) VALUES (26, 1, '5345353453534534', 'arun', 'rajput', 'rajput', '', '', '', '', '', '', '', 'Exit', NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', '', '', '', '2025-06-11');
INSERT INTO `generalcertificate` (`id`, `serialno`, `register_no`, `first_name`, `father_name`, `last_name`, `mother_tongue`, `religion`, `caste`, `place_of_birth`, `dob`, `prev_school_name`, `admission_date`, `type`, `admission_no`, `student_idno`, `subcaste`, `reaon_leaving`, `adharno`, `certificate_number`, `admitted_class`, `academic_preference`, `academic_conduct`, `date_of_leaving`, `left_class`, `remark`, `created_at`) VALUES (27, 1, NULL, 'arun', 'rajput', 'rajput', '', '', '', '', '', '', '', 'Entry', '', '', '', '', '', '', '', NULL, NULL, '', '', '', '2025-06-11');
INSERT INTO `generalcertificate` (`id`, `serialno`, `register_no`, `first_name`, `father_name`, `last_name`, `mother_tongue`, `religion`, `caste`, `place_of_birth`, `dob`, `prev_school_name`, `admission_date`, `type`, `admission_no`, `student_idno`, `subcaste`, `reaon_leaving`, `adharno`, `certificate_number`, `admitted_class`, `academic_preference`, `academic_conduct`, `date_of_leaving`, `left_class`, `remark`, `created_at`) VALUES (28, 1, '', '', '', '', '', '', '', '', '', '', '', 'Exit', NULL, NULL, NULL, NULL, NULL, NULL, '', '', '', '', '', '', '2025-06-13');
INSERT INTO `generalcertificate` (`id`, `serialno`, `register_no`, `first_name`, `father_name`, `last_name`, `mother_tongue`, `religion`, `caste`, `place_of_birth`, `dob`, `prev_school_name`, `admission_date`, `type`, `admission_no`, `student_idno`, `subcaste`, `reaon_leaving`, `adharno`, `certificate_number`, `admitted_class`, `academic_preference`, `academic_conduct`, `date_of_leaving`, `left_class`, `remark`, `created_at`) VALUES (29, 1, NULL, '', '', '', '', '', '', '', '', '', '', 'Entry', '', '', '', '', '', '', '', NULL, NULL, '', '', '', '2025-06-13');


#
# TABLE STRUCTURE FOR: gmeet
#

DROP TABLE IF EXISTS `gmeet`;

CREATE TABLE `gmeet` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purpose` varchar(20) NOT NULL DEFAULT 'class',
  `staff_id` int(11) DEFAULT NULL,
  `created_id` int(10) NOT NULL,
  `title` text DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `type` varchar(20) NOT NULL DEFAULT 'manual',
  `api_data` text DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `subject` varchar(50) DEFAULT NULL,
  `url` text NOT NULL,
  `session_id` int(10) NOT NULL,
  `description` text DEFAULT NULL,
  `timezone` varchar(100) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `created_id` (`created_id`),
  KEY `session_id` (`session_id`),
  CONSTRAINT `gmeet_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `gmeet_ibfk_2` FOREIGN KEY (`created_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `gmeet_ibfk_3` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `gmeet` (`id`, `purpose`, `staff_id`, `created_id`, `title`, `date`, `type`, `api_data`, `duration`, `subject`, `url`, `session_id`, `description`, `timezone`, `status`, `created_at`) VALUES (1, 'meeting', NULL, 1, 'Syllabus Complete Before date', '2025-04-25 01:02:00', 'manual', NULL, 40, NULL, 'https://meet.google.com/gyx-xyof-ppf', 19, 'Syllabus Complete Before date', 'UTC', 0, '2025-04-18 20:35:35');
INSERT INTO `gmeet` (`id`, `purpose`, `staff_id`, `created_id`, `title`, `date`, `type`, `api_data`, `duration`, `subject`, `url`, `session_id`, `description`, `timezone`, `status`, `created_at`) VALUES (2, 'class', 2, 1, 'Tet', '2025-04-19 01:06:00', 'manual', NULL, 40, NULL, 'https://meet.google.com/gyx-xyof-ppf', 19, 'Test', 'UTC', 0, '2025-04-18 20:36:38');


#
# TABLE STRUCTURE FOR: gmeet_history
#

DROP TABLE IF EXISTS `gmeet_history`;

CREATE TABLE `gmeet_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gmeet_id` int(11) NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `total_hit` int(10) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `gmeet_id` (`gmeet_id`),
  KEY `staff_id` (`staff_id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `gmeet_history_ibfk_1` FOREIGN KEY (`gmeet_id`) REFERENCES `gmeet` (`id`) ON DELETE CASCADE,
  CONSTRAINT `gmeet_history_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `gmeet_history_ibfk_3` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: gmeet_sections
#

DROP TABLE IF EXISTS `gmeet_sections`;

CREATE TABLE `gmeet_sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gmeet_id` int(11) NOT NULL,
  `cls_section_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `cls_section_id` (`cls_section_id`),
  KEY `gmeet_id` (`gmeet_id`),
  CONSTRAINT `gmeet_sections_ibfk_1` FOREIGN KEY (`cls_section_id`) REFERENCES `class_sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `gmeet_sections_ibfk_2` FOREIGN KEY (`gmeet_id`) REFERENCES `gmeet` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `gmeet_sections` (`id`, `gmeet_id`, `cls_section_id`, `created_at`) VALUES (1, 2, 1, '2025-04-18 20:36:38');


#
# TABLE STRUCTURE FOR: gmeet_settings
#

DROP TABLE IF EXISTS `gmeet_settings`;

CREATE TABLE `gmeet_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `api_key` varchar(200) DEFAULT NULL,
  `api_secret` varchar(200) DEFAULT NULL,
  `use_api` int(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `gmeet_settings` (`id`, `api_key`, `api_secret`, `use_api`, `created_at`) VALUES (1, 'w', 'w', 1, '2025-06-11 19:04:14');


#
# TABLE STRUCTURE FOR: gmeet_staff
#

DROP TABLE IF EXISTS `gmeet_staff`;

CREATE TABLE `gmeet_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gmeet_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `gmeet_id` (`gmeet_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `gmeet_staff_ibfk_1` FOREIGN KEY (`gmeet_id`) REFERENCES `gmeet` (`id`) ON DELETE CASCADE,
  CONSTRAINT `gmeet_staff_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `gmeet_staff` (`id`, `gmeet_id`, `staff_id`, `created_at`) VALUES (1, 1, 2, '2025-04-18 20:35:35');


#
# TABLE STRUCTURE FOR: google_authenticator
#

DROP TABLE IF EXISTS `google_authenticator`;

CREATE TABLE `google_authenticator` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `use_authenticator` int(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `google_authenticator` (`id`, `use_authenticator`, `created_at`) VALUES (1, 1, '2025-06-12 13:06:13');


#
# TABLE STRUCTURE FOR: grades
#

DROP TABLE IF EXISTS `grades`;

CREATE TABLE `grades` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_type` varchar(250) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `point` float(10,1) DEFAULT NULL,
  `mark_from` float(10,2) DEFAULT NULL,
  `mark_upto` float(10,2) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: guest
#

DROP TABLE IF EXISTS `guest`;

CREATE TABLE `guest` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `guest_name` varchar(200) NOT NULL,
  `guest_unique_id` varchar(200) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `currency_id` int(11) NOT NULL,
  `email` varchar(200) NOT NULL,
  `mobileno` varchar(100) NOT NULL,
  `password` varchar(200) NOT NULL,
  `dob` varchar(200) NOT NULL,
  `gender` varchar(10) DEFAULT NULL,
  `note` text NOT NULL,
  `address` varchar(200) NOT NULL,
  `guest_image` varchar(200) NOT NULL,
  `verification_code` varchar(200) NOT NULL,
  `created_at` date NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `idx_lang_id` (`lang_id`),
  KEY `idx_currency_id` (`currency_id`),
  KEY `idx_email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: holiday_type
#

DROP TABLE IF EXISTS `holiday_type`;

CREATE TABLE `holiday_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT NULL,
  `is_default` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `holiday_type` (`id`, `type`, `is_default`) VALUES (1, 'Holiday', 1);
INSERT INTO `holiday_type` (`id`, `type`, `is_default`) VALUES (2, 'Vacation', 1);
INSERT INTO `holiday_type` (`id`, `type`, `is_default`) VALUES (3, 'Activity', 1);
INSERT INTO `holiday_type` (`id`, `type`, `is_default`) VALUES (4, 'summer ', 0);
INSERT INTO `holiday_type` (`id`, `type`, `is_default`) VALUES (5, 'winter', 0);
INSERT INTO `holiday_type` (`id`, `type`, `is_default`) VALUES (6, 'winnter', 0);
INSERT INTO `holiday_type` (`id`, `type`, `is_default`) VALUES (7, 'festivals', 0);


#
# TABLE STRUCTURE FOR: homework
#

DROP TABLE IF EXISTS `homework`;

CREATE TABLE `homework` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `subject_group_subject_id` int(11) DEFAULT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `homework_date` date NOT NULL,
  `submit_date` date NOT NULL,
  `marks` float(10,2) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `create_date` date NOT NULL,
  `evaluation_date` date DEFAULT NULL,
  `document` varchar(200) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `evaluated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `subject_group_subject_id` (`subject_group_subject_id`),
  KEY `class_id` (`class_id`),
  KEY `section_id` (`section_id`),
  KEY `session_id` (`session_id`),
  KEY `staff_id` (`staff_id`),
  KEY `subject_id` (`subject_id`),
  KEY `evaluated_by` (`evaluated_by`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `homework_ibfk_1` FOREIGN KEY (`subject_group_subject_id`) REFERENCES `subject_group_subjects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_2` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_3` FOREIGN KEY (`section_id`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_4` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_5` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_6` FOREIGN KEY (`subject_id`) REFERENCES `subjects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_7` FOREIGN KEY (`evaluated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_ibfk_8` FOREIGN KEY (`created_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: homework_evaluation
#

DROP TABLE IF EXISTS `homework_evaluation`;

CREATE TABLE `homework_evaluation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `homework_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `student_session_id` int(11) DEFAULT NULL,
  `marks` float(10,2) DEFAULT NULL,
  `note` varchar(255) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `homework_id` (`homework_id`),
  KEY `student_id` (`student_id`),
  KEY `student_session_id` (`student_session_id`),
  CONSTRAINT `homework_evaluation_ibfk_1` FOREIGN KEY (`homework_id`) REFERENCES `homework` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_evaluation_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `homework_evaluation_ibfk_3` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: hostalattendance
#

DROP TABLE IF EXISTS `hostalattendance`;

CREATE TABLE `hostalattendance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_session_id` int(11) DEFAULT NULL,
  `biometric_attendence` int(11) NOT NULL DEFAULT 0,
  `qrcode_attendance` int(11) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `attendence_type_id` int(11) DEFAULT NULL,
  `remark` varchar(200) NOT NULL,
  `biometric_device_data` text DEFAULT NULL,
  `attendance_type` varchar(50) DEFAULT NULL,
  `user_agent` varchar(250) DEFAULT NULL,
  `in_time` time DEFAULT NULL,
  `out_time` time DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `student_session_id` (`student_session_id`),
  KEY `attendence_type_id` (`attendence_type_id`),
  CONSTRAINT `hostalattendance_ibfk_1` FOREIGN KEY (`attendence_type_id`) REFERENCES `attendence_type` (`id`) ON DELETE CASCADE,
  CONSTRAINT `hostalattendance_ibfk_2` FOREIGN KEY (`student_session_id`) REFERENCES `student_session` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `hostalattendance` (`id`, `student_session_id`, `biometric_attendence`, `qrcode_attendance`, `date`, `attendence_type_id`, `remark`, `biometric_device_data`, `attendance_type`, `user_agent`, `in_time`, `out_time`, `is_active`, `created_at`, `updated_at`) VALUES (1, 1, 0, 1, '2025-04-17', 1, '', '{\"uid\":\"\",\"user_id\":\"\",\"t\":\"\",\"ip\":\"183.82.232.140\",\"serial_number\":\"\",\"country\":\"India\",\"city\":\"Hyderabad\",\"region\":\"Telangana\",\"latitude\":17.385044,\"longitude\":78.486671}', NULL, 'Desktop | Windows 10 | Chrome 135.0.0.0', '19:09:13', '19:09:41', 'no', '2025-04-17 19:09:13', '2025-04-17 20:09:41');
INSERT INTO `hostalattendance` (`id`, `student_session_id`, `biometric_attendence`, `qrcode_attendance`, `date`, `attendence_type_id`, `remark`, `biometric_device_data`, `attendance_type`, `user_agent`, `in_time`, `out_time`, `is_active`, `created_at`, `updated_at`) VALUES (8, 1, 0, 0, '2025-06-05', 4, '', NULL, 'hostal', NULL, NULL, NULL, 'no', '2025-06-05 11:46:35', '2025-06-05 12:04:56');
INSERT INTO `hostalattendance` (`id`, `student_session_id`, `biometric_attendence`, `qrcode_attendance`, `date`, `attendence_type_id`, `remark`, `biometric_device_data`, `attendance_type`, `user_agent`, `in_time`, `out_time`, `is_active`, `created_at`, `updated_at`) VALUES (9, 1, 0, 0, '2025-06-09', 1, '', NULL, 'hostal', NULL, '00:00:00', '00:00:00', 'no', '2025-06-09 07:26:10', '2025-06-09 07:26:10');
INSERT INTO `hostalattendance` (`id`, `student_session_id`, `biometric_attendence`, `qrcode_attendance`, `date`, `attendence_type_id`, `remark`, `biometric_device_data`, `attendance_type`, `user_agent`, `in_time`, `out_time`, `is_active`, `created_at`, `updated_at`) VALUES (10, 7, 0, 0, '2025-06-09', 4, '', NULL, 'hostal', NULL, NULL, NULL, 'no', '2025-06-09 07:26:10', '2025-06-09 07:26:10');


#
# TABLE STRUCTURE FOR: hostalattendanceafternoon
#

DROP TABLE IF EXISTS `hostalattendanceafternoon`;

CREATE TABLE `hostalattendanceafternoon` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_session_id` int(11) DEFAULT NULL,
  `biometric_attendence` int(11) DEFAULT NULL,
  `qrcode_attendance` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `attendence_type_id` int(11) DEFAULT NULL,
  `remark` varchar(100) DEFAULT NULL,
  `biometric_device_data` text DEFAULT NULL,
  `attendance_type` varchar(50) DEFAULT NULL,
  `user_agent` varchar(100) DEFAULT NULL,
  `in_time` time DEFAULT NULL,
  `out_time` time DEFAULT NULL,
  `is_active` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: hostalattendancenight
#

DROP TABLE IF EXISTS `hostalattendancenight`;

CREATE TABLE `hostalattendancenight` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_session_id` int(11) DEFAULT NULL,
  `biometric_attendence` int(11) DEFAULT NULL,
  `qrcode_attendance` int(11) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `attendence_type_id` int(11) DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `biometric_device_data` text DEFAULT NULL,
  `attendance_type` varchar(100) NOT NULL,
  `user_agent` varchar(100) DEFAULT NULL,
  `in_time` time DEFAULT NULL,
  `out_time` time DEFAULT NULL,
  `is_active` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

#
# TABLE STRUCTURE FOR: hostel
#

DROP TABLE IF EXISTS `hostel`;

CREATE TABLE `hostel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hostel_name` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `intake` int(11) DEFAULT NULL,
  `hostel_manager` int(11) DEFAULT NULL,
  `hostel_warden` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `hostel_manager`, `hostel_warden`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'hostel 1', 'Combine', '', 0, 2, 0, '', 'yes', '0000-00-00 00:00:00', '2025-05-22 08:30:50');
INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `hostel_manager`, `hostel_warden`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'mauli hostel', 'Girl', '', 0, NULL, NULL, '', 'no', '2025-06-13 13:52:20', '2025-06-13 13:52:20');
INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `hostel_manager`, `hostel_warden`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'nilesh', 'Boy', '', 0, NULL, NULL, '', 'no', '2025-06-13 13:52:35', '2025-06-13 13:52:35');
INSERT INTO `hostel` (`id`, `hostel_name`, `type`, `address`, `intake`, `hostel_manager`, `hostel_warden`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'nilesh', 'Boy', '', 0, NULL, NULL, '', 'no', '2025-06-13 13:52:36', '2025-06-13 13:52:36');


#
# TABLE STRUCTURE FOR: hostel_rooms
#

DROP TABLE IF EXISTS `hostel_rooms`;

CREATE TABLE `hostel_rooms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hostel_id` int(11) DEFAULT NULL,
  `room_type_id` int(11) DEFAULT NULL,
  `room_no` varchar(200) DEFAULT NULL,
  `no_of_bed` int(11) DEFAULT NULL,
  `cost_per_bed` float(10,2) DEFAULT 0.00,
  `title` varchar(200) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `hostel_id` (`hostel_id`),
  KEY `room_type_id` (`room_type_id`),
  CONSTRAINT `hostel_rooms_ibfk_1` FOREIGN KEY (`hostel_id`) REFERENCES `hostel` (`id`) ON DELETE CASCADE,
  CONSTRAINT `hostel_rooms_ibfk_2` FOREIGN KEY (`room_type_id`) REFERENCES `room_types` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`, `updated_at`) VALUES (1, 1, 1, 'test', 23, '500.00', NULL, 'lorem', '2025-06-05 07:45:38', '2025-06-05 07:45:38');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`, `updated_at`) VALUES (2, 1, 1, '001', 90, '700.00', NULL, '', '2025-06-13 13:50:36', '2025-06-13 13:50:36');
INSERT INTO `hostel_rooms` (`id`, `hostel_id`, `room_type_id`, `room_no`, `no_of_bed`, `cost_per_bed`, `title`, `description`, `created_at`, `updated_at`) VALUES (3, 1, 1, '04', 987, '100.00', NULL, '', '2025-06-13 13:51:06', '2025-06-13 13:51:06');


#
# TABLE STRUCTURE FOR: id_card
#

DROP TABLE IF EXISTS `id_card`;

CREATE TABLE `id_card` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `school_name` varchar(100) NOT NULL,
  `school_address` varchar(500) NOT NULL,
  `background` varchar(100) DEFAULT NULL,
  `logo` varchar(100) NOT NULL,
  `sign_image` varchar(100) NOT NULL,
  `enable_vertical_card` int(11) NOT NULL DEFAULT 0,
  `header_color` varchar(100) NOT NULL,
  `enable_admission_no` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_student_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_class` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_fathers_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_mothers_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_address` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_phone` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_dob` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_blood_group` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_student_barcode` tinyint(4) NOT NULL DEFAULT 1 COMMENT '0=disable,1=enable',
  `enable_student_rollno` tinyint(1) NOT NULL COMMENT '0=disable,1=enable	',
  `enable_student_house_name` tinyint(1) DEFAULT 0 COMMENT '0=disable,1=enable	',
  `status` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `id_card` (`id`, `title`, `school_name`, `school_address`, `background`, `logo`, `sign_image`, `enable_vertical_card`, `header_color`, `enable_admission_no`, `enable_student_name`, `enable_class`, `enable_fathers_name`, `enable_mothers_name`, `enable_address`, `enable_phone`, `enable_dob`, `enable_blood_group`, `enable_student_barcode`, `enable_student_rollno`, `enable_student_house_name`, `status`, `created_at`, `updated_at`) VALUES (1, 'Sample Student Identity Card Horizontal', 'Mount Carmel School', '110 Kings Street, CA  Phone: 456542 Email: mount@gmail.com', 'samplebackground12.png', 'samplelogo12.png', 'samplesign12.png', 1, '#595959', 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, '2025-04-09 22:52:06', '2025-04-18 21:01:59');
INSERT INTO `id_card` (`id`, `title`, `school_name`, `school_address`, `background`, `logo`, `sign_image`, `enable_vertical_card`, `header_color`, `enable_admission_no`, `enable_student_name`, `enable_class`, `enable_fathers_name`, `enable_mothers_name`, `enable_address`, `enable_phone`, `enable_dob`, `enable_blood_group`, `enable_student_barcode`, `enable_student_rollno`, `enable_student_house_name`, `status`, `created_at`, `updated_at`) VALUES (2, 'Sample Student Identity Card Vertical', 'Mount Carmel School', '110 Kings Street, CA  Phone: 456542 Email: mount@gmail.com', 'samplebackground12.png', 'samplelogo12.png', 'samplesign12.png', 1, '#595959', 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, '2025-04-09 22:52:06', '2025-04-09 22:52:06');
INSERT INTO `id_card` (`id`, `title`, `school_name`, `school_address`, `background`, `logo`, `sign_image`, `enable_vertical_card`, `header_color`, `enable_admission_no`, `enable_student_name`, `enable_class`, `enable_fathers_name`, `enable_mothers_name`, `enable_address`, `enable_phone`, `enable_dob`, `enable_blood_group`, `enable_student_barcode`, `enable_student_rollno`, `enable_student_house_name`, `status`, `created_at`, `updated_at`) VALUES (3, 'school', 'baswanna wale', '1916505488', '', '', '', 1, '', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, '2025-06-13 14:10:51', '2025-06-13 14:10:51');


#
# TABLE STRUCTURE FOR: income
#

DROP TABLE IF EXISTS `income`;

CREATE TABLE `income` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inc_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT 0.00,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `documents` varchar(255) DEFAULT NULL,
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `income_head_id` (`inc_head_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (1, 2, 'test', '2323', '2025-06-01', '200.00', 'test', 'yes', NULL, 'no', '2025-06-03 09:03:14', '2025-06-03 09:17:30');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `documents`, `is_deleted`, `created_at`, `updated_at`) VALUES (2, 2, 'arr', 'att', '2025-06-03', '1232.00', '', 'yes', NULL, 'no', '2025-06-11 19:04:51', '2025-06-11 19:04:51');


#
# TABLE STRUCTURE FOR: income_head
#

DROP TABLE IF EXISTS `income_head`;

CREATE TABLE `income_head` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `income_category` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `is_active` varchar(255) NOT NULL DEFAULT 'yes',
  `is_deleted` varchar(255) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: item
#

DROP TABLE IF EXISTS `item`;

CREATE TABLE `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_category_id` int(11) DEFAULT NULL,
  `item_store_id` int(11) DEFAULT NULL,
  `item_supplier_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `unit` varchar(100) NOT NULL,
  `item_photo` varchar(225) DEFAULT NULL,
  `description` text NOT NULL,
  `quantity` int(11) NOT NULL,
  `date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_category_id` (`item_category_id`),
  KEY `item_store_id` (`item_store_id`),
  KEY `item_supplier_id` (`item_supplier_id`),
  CONSTRAINT `item_ibfk_1` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_ibfk_2` FOREIGN KEY (`item_store_id`) REFERENCES `item_store` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_ibfk_3` FOREIGN KEY (`item_supplier_id`) REFERENCES `item_supplier` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: item_category
#

DROP TABLE IF EXISTS `item_category`;

CREATE TABLE `item_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_category` varchar(255) NOT NULL,
  `is_active` varchar(255) NOT NULL DEFAULT 'yes',
  `description` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (1, 'normal', 'yes', '', '2025-06-13 13:20:20', '2025-06-13 13:20:20');
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES (2, 'soft', 'yes', '', '2025-06-13 13:20:30', '2025-06-13 13:20:30');


#
# TABLE STRUCTURE FOR: item_issue
#

DROP TABLE IF EXISTS `item_issue`;

CREATE TABLE `item_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_type` varchar(15) DEFAULT NULL,
  `issue_to` int(11) NOT NULL,
  `issue_by` int(11) DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `item_category_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `quantity` int(11) NOT NULL,
  `note` text NOT NULL,
  `is_returned` int(11) NOT NULL DEFAULT 1,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `item_category_id` (`item_category_id`),
  KEY `issue_to` (`issue_to`),
  KEY `issue_by` (`issue_by`),
  CONSTRAINT `item_issue_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_2` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_3` FOREIGN KEY (`issue_to`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_4` FOREIGN KEY (`issue_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: item_stock
#

DROP TABLE IF EXISTS `item_stock`;

CREATE TABLE `item_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `store_id` int(11) DEFAULT NULL,
  `symbol` varchar(10) NOT NULL DEFAULT '+',
  `quantity` int(11) DEFAULT NULL,
  `purchase_price` float(10,2) NOT NULL,
  `date` date NOT NULL,
  `attachment` varchar(250) DEFAULT NULL,
  `description` text NOT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `item_stock_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_2` FOREIGN KEY (`supplier_id`) REFERENCES `item_supplier` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `item_store` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: item_store
#

DROP TABLE IF EXISTS `item_store`;

CREATE TABLE `item_store` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_store` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`, `updated_at`) VALUES (1, 'krashna book', '854783', '', '2025-06-13 13:21:01', '2025-06-13 13:21:34');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`, `updated_at`) VALUES (2, 'himalaya bookk', '0989', '', '2025-06-13 13:21:25', '2025-06-13 13:21:25');


#
# TABLE STRUCTURE FOR: item_supplier
#

DROP TABLE IF EXISTS `item_supplier`;

CREATE TABLE `item_supplier` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_supplier` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `contact_person_name` varchar(255) NOT NULL,
  `contact_person_phone` varchar(255) NOT NULL,
  `contact_person_email` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `item_supplier` (`id`, `item_supplier`, `phone`, `email`, `address`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `description`, `created_at`, `updated_at`) VALUES (1, 'Attar', '9161545088', 'attarmohammadk7@gmail.com', '', '9161545088', '9161545088', '', '', '2025-06-13 13:23:22', '2025-06-13 13:23:22');
INSERT INTO `item_supplier` (`id`, `item_supplier`, `phone`, `email`, `address`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `description`, `created_at`, `updated_at`) VALUES (2, 'Attar', '9161545088', 'attarmohammadk7@gmail.com', '', '9161545088', '9161545088', '', '', '2025-06-13 13:23:22', '2025-06-13 13:23:22');


#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(50) DEFAULT NULL,
  `short_code` varchar(255) NOT NULL,
  `country_code` varchar(255) NOT NULL,
  `is_rtl` int(11) NOT NULL,
  `is_deleted` varchar(10) NOT NULL DEFAULT 'yes',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=95 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Azerbaijan', 'az', 'az', 0, 'no', 'no', '2019-11-20 11:23:12', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Albanian', 'sq', 'al', 0, 'no', 'no', '2019-11-20 11:42:42', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Amharic', 'am', 'am', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'English', 'en', 'us', 0, 'no', 'no', '2019-11-20 11:38:50', '2025-05-27 11:18:26');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Arabic', 'ar', 'sa', 0, 'no', 'no', '2019-11-20 11:47:28', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'Afrikaans', 'af', 'af', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Basque', 'eu', 'es', 0, 'no', 'no', '2019-11-20 11:54:10', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'Bengali', 'bn', 'in', 0, 'no', 'no', '2019-11-20 11:41:53', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'Bosnian', 'bs', 'bs', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'Welsh', 'cy', 'cy', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'Hungarian', 'hu', 'hu', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'Vietnamese', 'vi', 'vi', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'Haitian', 'ht', 'ht', 0, 'no', 'no', '2021-01-23 07:09:32', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'Galician', 'gl', 'gl', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'Dutch', 'nl', 'nl', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'Greek', 'el', 'gr', 0, 'no', 'no', '2019-11-20 12:12:08', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'Georgian', 'ka', 'ge', 0, 'no', 'no', '2019-11-20 12:11:40', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'Gujarati', 'gu', 'in', 0, 'no', 'no', '2019-11-20 11:39:16', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'Danish', 'da', 'dk', 0, 'no', 'no', '2019-11-20 12:03:25', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'Hebrew', 'he', 'il', 0, 'no', 'no', '2019-11-20 12:13:50', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'Yiddish', 'yi', 'il', 0, 'no', 'no', '2019-11-20 12:25:33', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'Indonesian', 'id', 'id', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'Irish', 'ga', 'ga', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'Italian', 'it', 'it', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'Icelandic', 'is', 'is', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'Spanish', 'es', 'es', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'Kannada', 'kn', 'in', 0, 'no', 'no', '2019-11-20 11:24:23', '2025-04-15 21:46:44');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'Catalan', 'ca', 'ca', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'Chinese', 'zh', 'cn', 0, 'no', 'no', '2019-11-20 12:01:48', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'Korean', 'ko', 'kr', 0, 'no', 'no', '2019-11-20 12:19:09', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'Xhosa', 'xh', 'ls', 0, 'no', 'no', '2019-11-20 12:24:39', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'Latin', 'la', 'it', 0, 'no', 'no', '2021-01-23 07:09:32', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'Latvian', 'lv', 'lv', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'Lithuanian', 'lt', 'lt', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'Malagasy', 'mg', 'mg', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'Malay', 'ms', 'ms', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'Malayalam', 'ml', 'ml', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'Maltese', 'mt', 'mt', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'Macedonian', 'mk', 'mk', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'Maori', 'mi', 'nz', 0, 'no', 'no', '2019-11-20 12:20:27', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'Marathi', 'mr', 'in', 0, 'no', 'no', '2019-11-20 11:39:51', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'Mongolian', 'mn', 'mn', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'German', 'de', 'de', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'Nepali', 'ne', 'ne', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'Norwegian', 'no', 'no', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'Punjabi', 'pa', 'in', 0, 'no', 'no', '2019-11-20 11:40:16', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'Persian', 'fa', 'ir', 0, 'no', 'no', '2019-11-20 12:21:17', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'Portuguese', 'pt', 'pt', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'Romanian', 'ro', 'ro', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'Russian', 'ru', 'ru', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'Cebuano', 'ceb', 'ph', 0, 'no', 'no', '2019-11-20 11:59:12', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'Sinhala', 'si', 'lk ', 0, 'no', 'no', '2021-01-23 07:09:32', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'Slovakian', 'sk', 'sk', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'Slovenian', 'sl', 'sl', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'Swahili', 'sw', 'ke', 0, 'no', 'no', '2019-11-20 12:21:57', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'Sundanese', 'su', 'sd', 0, 'no', 'no', '2019-12-03 11:06:57', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'Thai', 'th', 'th', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'Tagalog', 'tl', 'tl', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'Tamil', 'ta', 'in', 0, 'no', 'no', '2019-11-20 11:40:53', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'Telugu', 'te', 'in', 0, 'no', 'no', '2019-11-20 11:41:15', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'Turkish', 'tr', 'tr', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'Uzbek', 'uz', 'uz', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (79, 'Urdu', 'ur', 'pk', 0, 'no', 'no', '2019-11-20 12:23:57', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (80, 'Finnish', 'fi', 'fi', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (81, 'French', 'fr', 'fr', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (82, 'Hindi', 'hi', 'in', 0, 'no', 'no', '2019-11-20 11:36:34', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (84, 'Czech', 'cs', 'cz', 0, 'no', 'no', '2019-11-20 12:02:36', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (85, 'Swedish', 'sv', 'sv', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (86, 'Scottish', 'gd', 'gd', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (87, 'Estonian', 'et', 'et', 0, 'no', 'no', '2019-11-20 11:24:23', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (88, 'Esperanto', 'eo', 'br', 0, 'no', 'no', '2019-11-21 04:49:18', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (89, 'Javanese', 'jv', 'id', 0, 'no', 'no', '2019-11-20 12:18:29', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (90, 'Japanese', 'ja', 'jp', 0, 'no', 'no', '2019-11-20 12:14:39', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (91, 'Polish', 'pl', 'pl', 0, 'no', 'no', '2020-06-15 04:25:27', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (92, 'Kurdish', 'ku', 'iq', 0, 'no', 'no', '2020-12-21 00:15:31', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (93, 'Lao', 'lo', 'la', 0, 'no', 'no', '2020-12-21 00:15:36', '0000-00-00 00:00:00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_rtl`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (94, 'Croatia', 'hr', 'hr', 0, 'no', 'no', '2022-06-07 12:48:21', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: leave_types
#

DROP TABLE IF EXISTS `leave_types`;

CREATE TABLE `leave_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `leave_types` (`id`, `type`, `is_active`) VALUES (1, 'test', 'yes');


#
# TABLE STRUCTURE FOR: lesson
#

DROP TABLE IF EXISTS `lesson`;

CREATE TABLE `lesson` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) NOT NULL,
  `subject_group_subject_id` int(11) NOT NULL,
  `subject_group_class_sections_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  KEY `subject_group_subject_id` (`subject_group_subject_id`),
  KEY `subject_group_class_sections_id` (`subject_group_class_sections_id`),
  CONSTRAINT `lesson_ibfk_1` FOREIGN KEY (`session_id`) REFERENCES `sessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `lesson_ibfk_2` FOREIGN KEY (`subject_group_subject_id`) REFERENCES `subject_group_subjects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `lesson_ibfk_3` FOREIGN KEY (`subject_group_class_sections_id`) REFERENCES `subject_group_class_sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `lesson` (`id`, `session_id`, `subject_group_subject_id`, `subject_group_class_sections_id`, `name`, `created_at`, `updated_at`) VALUES (1, 19, 330, 68, 'Lesson Name  1', '2025-06-03 20:07:48', '2025-06-03 20:07:48');


#
# TABLE STRUCTURE FOR: lesson_plan_forum
#

DROP TABLE IF EXISTS `lesson_plan_forum`;

CREATE TABLE `lesson_plan_forum` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `subject_syllabus_id` int(11) NOT NULL,
  `type` varchar(20) NOT NULL COMMENT 'staff,student',
  `staff_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `message` text NOT NULL,
  `created_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `subject_syllabus_id` (`subject_syllabus_id`),
  KEY `student_id` (`student_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `lesson_plan_forum_ibfk_1` FOREIGN KEY (`subject_syllabus_id`) REFERENCES `subject_syllabus` (`id`) ON DELETE CASCADE,
  CONSTRAINT `lesson_plan_forum_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  CONSTRAINT `lesson_plan_forum_ibfk_3` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: libarary_members
#

DROP TABLE IF EXISTS `libarary_members`;

CREATE TABLE `libarary_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `library_card_no` varchar(50) DEFAULT NULL,
  `member_type` varchar(50) DEFAULT NULL,
  `member_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: logs
#

DROP TABLE IF EXISTS `logs`;

CREATE TABLE `logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text DEFAULT NULL,
  `record_id` text DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `action` varchar(50) DEFAULT NULL,
  `ip_address` varchar(50) DEFAULT NULL,
  `platform` varchar(50) DEFAULT NULL,
  `agent` varchar(50) DEFAULT NULL,
  `time` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1964 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1, 'Record updated On QR Attendance settings id 1', '1', 1, 'Update', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-09 17:37:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2, 'Record updated On QR Attendance settings id 1', '1', 1, 'Update', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-09 17:41:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (3, 'Record updated On settings id 1', '1', 1, 'Update', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-14 14:17:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (4, 'Record updated On settings id 1', '1', 1, 'Update', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:03:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (5, 'Record updated On settings id 1', '1', 1, 'Update', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:06:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (6, 'Record updated On settings id 1', '1', 1, 'Update', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:06:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (7, 'New Record inserted On sections id 1', '1', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:15:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (8, 'New Record inserted On sections id 2', '2', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:15:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (9, 'New Record inserted On sections id 3', '3', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:15:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (10, 'New Record inserted On subject groups id 1', '1', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:15:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (11, 'New Record inserted On subject groups id 2', '2', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:15:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (12, 'New Record inserted On subject groups id 3', '3', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:16:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (13, 'New Record inserted On subject groups id 4', '4', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:16:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (14, 'New Record inserted On subject groups id 5', '5', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:16:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (15, 'New Record inserted On subject groups id 6', '6', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:16:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (16, 'New Record inserted On subject groups id 7', '7', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:16:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (17, 'Record updated On settings id 1', '1', 1, 'Update', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:21:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (18, 'Record updated On settings id 1', '1', 1, 'Update', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:22:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (19, 'New Record inserted On subject groups id 8', '8', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:23:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (20, 'New Record inserted On subject groups id 9', '9', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:23:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (21, 'New Record inserted On subject groups id 10', '10', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:23:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (22, 'New Record inserted On subject groups id 11', '11', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:23:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (23, 'New Record inserted On subject groups id 12', '12', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:23:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (24, 'New Record inserted On subject groups id 13', '13', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:23:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (25, 'New Record inserted On subjects id 1', '1', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:26:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (26, 'New Record inserted On subjects id 2', '2', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:26:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (27, 'New Record inserted On subjects id 3', '3', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:27:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (28, 'New Record inserted On subjects id 4', '4', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:28:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (29, 'New Record inserted On subjects id 5', '5', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:29:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (30, 'New Record inserted On  categories id 1', '1', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:53:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (31, 'New Record inserted On  categories id 2', '2', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:53:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (32, 'New Record inserted On  categories id 3', '3', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:53:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (33, 'New Record inserted On  categories id 4', '4', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:53:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (34, 'New Record inserted On  categories id 5', '5', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:53:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (35, 'New Record inserted On  categories id 6', '6', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:53:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (36, 'New Record inserted On  categories id 7', '7', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:54:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (37, 'New Record inserted On  categories id 8', '8', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:54:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (38, 'New Record inserted On  categories id 9', '9', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:54:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (39, 'New Record inserted On  categories id 10', '10', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:54:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (40, 'New Record inserted On  categories id 11', '11', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:54:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (41, 'New Record inserted On  categories id 12', '12', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:54:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (42, 'Record deleted On categories id 12', '12', 1, 'Delete', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:54:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (43, 'New Record inserted On  categories id 13', '13', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:54:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (44, 'Record deleted On categories id 13', '13', 1, 'Delete', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:54:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (45, 'New Record inserted On  categories id 14', '14', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 14:55:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (46, 'New Record inserted On transport route id 1', '1', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 15:08:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (47, 'New Record inserted On transport route id 2', '2', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 15:08:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (48, 'Record updated On  transport route id 1', '1', 1, 'Update', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 15:08:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (49, 'Record updated On  transport route id 1', '1', 1, 'Update', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 15:14:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (50, 'Record updated On  transport route id 1', '1', 1, 'Update', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 15:17:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (51, 'Record updated On  transport route id 1', '1', 1, 'Update', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 15:17:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (52, 'Record updated On  transport route id 2', '2', 1, 'Update', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 15:18:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (53, 'New Record inserted On vehicles id 1', '1', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 15:21:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (54, 'New Record inserted On vehicles id 2', '2', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 15:21:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (55, 'New Record inserted On vehicle routes id 1', '1', 1, 'Insert', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 15:22:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (56, 'Record updated On settings id 1', '1', 1, 'Update', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 16:14:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (57, 'Record updated On settings id 1', '1', 1, 'Update', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 16:14:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (58, 'Record updated On settings id 1', '1', 1, 'Update', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 16:14:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (59, 'Record updated On settings id 1', '1', 1, 'Update', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 16:15:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (60, 'Record updated On settings id 1', '1', 1, 'Update', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-15 16:16:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (61, 'Record updated On permission group id 1200', '1200', 1, 'Update', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-16 11:58:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (62, 'Record updated On permission group id 1200', '1200', 1, 'Update', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-16 11:58:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (63, 'Record updated On settings id 1', '1', 1, 'Update', '49.43.235.71', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 17:54:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (64, 'Record updated On QR Attendance settings id 1', '1', 1, 'Update', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 18:03:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (65, 'New Record inserted On department id 1', '1', 1, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 18:13:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (66, 'New Record inserted On  staff designation id 1', '1', 1, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 18:13:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (67, 'Record updated On staff id 2', '2', 1, 'Update', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 18:14:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (68, 'Record updated On QR Attendance settings id 1', '1', 2, 'Update', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 18:15:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (69, 'New Record inserted On students id 1', '1', 2, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 18:17:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (70, 'New Record inserted On  student session id 1', '1', 2, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 18:17:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (71, 'New Record inserted On users id 1', '1', 2, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 18:17:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (72, 'New Record inserted On users id 2', '2', 2, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 18:17:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (73, 'Record updated On students id 1', '1', 2, 'Update', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 18:17:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (74, 'Record updated On QR Attendance settings id 1', '1', 2, 'Update', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 18:18:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (75, 'Record updated On QR Attendance settings id 1', '1', 2, 'Update', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 18:19:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (76, 'Record updated On QR Attendance settings id 1', '1', 2, 'Update', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 18:19:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (77, 'Record updated On students id 1', '1', 2, 'Update', '152.59.3.64', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 18:34:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (78, 'Record updated On  student session id 1', '1', 2, 'Update', '152.59.3.64', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 18:34:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (79, 'Record updated On QR Attendance settings id 1', '1', 1, 'Update', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 18:43:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (80, 'Record updated On settings id 1', '1', 1, 'Update', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 18:45:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (81, 'Record updated On settings id 1', '1', 1, 'Update', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 18:46:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (82, 'New Record inserted On school houses id 1', '1', 2, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 19:18:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (83, 'New Record inserted On visitors purpose id 1', '1', 2, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 19:20:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (84, 'New Record inserted On visitors purpose id 2', '2', 2, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 19:20:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (85, 'New Record inserted On visitors purpose id 3', '3', 2, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 19:20:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (86, 'New Record inserted On visitors purpose id 4', '4', 2, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 19:20:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (87, 'New Record inserted On visitors purpose id 5', '5', 2, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 19:20:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (88, 'New Record inserted On visitors purpose id 6', '6', 2, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 19:21:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (89, 'Record updated On settings id 1', '1', 1, 'Update', '::1', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-17 16:52:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (90, 'New Record inserted On  Phone Call Log id 1', '1', 1, 'Insert', '49.37.131.224', 'Windows 10', 'Chrome 134.0.0.0', '2025-04-18 13:54:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (91, 'New Record inserted On  Phone Call Log id 2', '2', 1, 'Insert', '49.37.131.224', 'Windows 10', 'Chrome 134.0.0.0', '2025-04-18 13:55:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (92, 'New Record inserted On  Phone Call Log id 3', '3', 1, 'Insert', '49.37.131.224', 'Windows 10', 'Chrome 134.0.0.0', '2025-04-18 14:11:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (93, 'New Record inserted On  Phone Call Log id 4', '4', 1, 'Insert', '49.37.131.224', 'Windows 10', 'Chrome 134.0.0.0', '2025-04-18 14:11:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (94, 'New Record inserted On  Admission Enquiry  Postal Dispatch id 1', '1', 1, 'Insert', '49.37.131.224', 'Windows 10', 'Chrome 134.0.0.0', '2025-04-18 14:12:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (95, 'New Record inserted On  Admission Enquiry  Postal Dispatch id 2', '2', 1, 'Insert', '49.37.131.224', 'Windows 10', 'Chrome 134.0.0.0', '2025-04-18 14:13:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (96, 'New Record inserted On  Admission Enquiry  Postal Dispatch id 3', '3', 1, 'Insert', '49.37.131.224', 'Windows 10', 'Chrome 134.0.0.0', '2025-04-18 14:14:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (97, 'New Record inserted On  Admission Enquiry  Postal Dispatch id 4', '4', 1, 'Insert', '49.37.131.224', 'Windows 10', 'Chrome 134.0.0.0', '2025-04-18 14:14:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (98, 'New Record inserted On  Admission Enquiry  Postal Receive id 5', '5', 1, 'Insert', '49.37.131.224', 'Windows 10', 'Chrome 134.0.0.0', '2025-04-18 14:15:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (99, 'New Record inserted On  Admission Enquiry  Postal Receive id 6', '6', 1, 'Insert', '49.37.131.224', 'Windows 10', 'Chrome 134.0.0.0', '2025-04-18 14:16:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (100, 'New Record inserted On  Admission Enquiry  Postal Receive id 7', '7', 1, 'Insert', '49.37.131.224', 'Windows 10', 'Chrome 134.0.0.0', '2025-04-18 14:16:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (101, 'New Record inserted On  Admission Enquiry  Postal Receive id 8', '8', 1, 'Insert', '49.37.131.224', 'Windows 10', 'Chrome 134.0.0.0', '2025-04-18 14:17:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (102, 'New Record inserted On school houses id 2', '2', 1, 'Insert', '49.37.129.186', 'Windows 10', 'Chrome 134.0.0.0', '2025-04-18 15:10:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (103, 'New Record inserted On school houses id 3', '3', 1, 'Insert', '49.37.129.186', 'Windows 10', 'Chrome 134.0.0.0', '2025-04-18 15:11:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (104, 'New Record inserted On school houses id 4', '4', 1, 'Insert', '49.37.129.186', 'Windows 10', 'Chrome 134.0.0.0', '2025-04-18 15:11:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (105, 'New Record inserted On disable reason id 1', '1', 1, 'Insert', '49.37.129.186', 'Windows 10', 'Chrome 134.0.0.0', '2025-04-18 15:11:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (106, 'New Record inserted On disable reason id 2', '2', 1, 'Insert', '49.37.129.186', 'Windows 10', 'Chrome 134.0.0.0', '2025-04-18 15:12:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (107, 'New Record inserted On student behaviour id 1', '1', 1, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-18 19:24:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (108, 'Record updated On  student behaviour id 1', '1', 1, 'Update', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-18 19:25:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (109, 'New Record inserted On student behaviour id 2', '2', 1, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-18 19:25:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (110, 'New Record inserted On student behaviour id 3', '3', 1, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-18 19:26:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (111, 'New Record inserted On student behaviour id 4', '4', 1, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-18 19:27:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (112, 'New Record inserted On student behaviour id 5', '5', 1, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-18 19:28:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (113, 'New Record inserted On student behaviour id 6', '6', 1, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-18 19:28:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (114, 'New Record inserted On student behaviour id 7', '7', 1, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-18 19:29:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (115, 'New Record inserted On student incidents id 1', '1', 1, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-18 19:30:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (116, 'New Record inserted On student incidents id 2', '2', 1, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-18 19:30:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (117, 'New Record inserted On student incidents id 3', '3', 1, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-18 19:30:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (118, 'New Record inserted On student incidents id 4', '4', 1, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-18 19:30:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (119, 'New Record inserted On student incidents id 5', '5', 1, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-18 19:30:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (120, 'New Record inserted On gmeet id 1', '1', 1, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-18 19:35:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (121, 'New Record inserted On gmeet id 2', '2', 1, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-18 19:36:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (122, 'New Record inserted On subject groups id 1', '1', 1, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-18 19:50:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (123, 'Record updated On  id card id 1', '1', 1, 'Update', '152.58.34.56', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-18 20:01:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (124, 'New Record inserted On homework id 1', '1', 1, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-18 20:32:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (125, 'New Record inserted On homework id 2', '2', 1, 'Insert', '183.82.232.140', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-18 20:33:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (126, 'Record updated On students id 1', '1', 1, 'Update', '103.74.237.3', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-24 02:00:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (127, 'New Record inserted On  holiday master  id 1', '1', 2, 'Insert', '106.193.193.109', 'Windows 10', 'Chrome 135.0.0.0', '2025-04-26 09:30:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (128, 'New Record inserted On subject groups id 2', '2', 1, 'Insert', '27.59.54.112', 'Windows 10', 'Chrome 135.0.0.0', '2025-05-02 18:52:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (129, 'New Record inserted On department id 2', '2', 1, 'Insert', '27.59.54.112', 'Windows 10', 'Chrome 135.0.0.0', '2025-05-02 18:53:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (130, 'New Record inserted On  staff designation id 2', '2', 1, 'Insert', '27.59.54.112', 'Windows 10', 'Chrome 135.0.0.0', '2025-05-02 18:53:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (131, 'Record updated On staff id 3', '3', 1, 'Update', '27.59.54.112', 'Windows 10', 'Chrome 135.0.0.0', '2025-05-02 18:54:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (132, 'Record updated On QR Attendance settings id 1', '1', 1, 'Update', '27.59.54.112', 'Windows 10', 'Chrome 135.0.0.0', '2025-05-02 18:58:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (133, 'Record updated On QR Attendance settings id 1', '1', 1, 'Update', '27.59.54.112', 'Windows 10', 'Chrome 135.0.0.0', '2025-05-02 19:02:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (134, 'New Record inserted On  fee group id 1', '1', 2, 'Insert', '59.96.214.232', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-07 11:27:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (135, 'New Record inserted On  fee type id 1', '1', 2, 'Insert', '59.96.214.232', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-07 11:27:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (136, 'New Record inserted On  fee groups feetype id 1', '1', 2, 'Insert', '59.96.214.232', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-07 11:28:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (137, 'New Record inserted On subject groups id 3', '3', 1, 'Insert', '152.58.36.1', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-09 21:02:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (138, 'New Record inserted On subject groups id 4', '4', 1, 'Insert', '152.58.36.1', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-09 21:02:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (139, 'New Record inserted On subject groups id 5', '5', 1, 'Insert', '152.58.36.1', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-09 21:03:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (140, 'New Record inserted On  subject timetable id 1', '1', 1, 'Insert', '152.58.36.1', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-09 21:04:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (141, 'New Record inserted On  subject timetable id 0', '0', 1, 'Insert', '152.58.36.1', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-09 21:04:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (142, 'New Record inserted On  subject timetable id -1', '-1', 1, 'Insert', '152.58.36.1', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-09 21:04:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (143, 'New Record inserted On  subject timetable id 4', '4', 1, 'Insert', '152.58.36.1', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-09 21:04:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (144, 'New Record inserted On  subject timetable id 3', '3', 1, 'Insert', '152.58.36.1', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-09 21:04:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (145, 'New Record inserted On  subject timetable id 2', '2', 1, 'Insert', '152.58.36.1', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-09 21:04:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (146, 'New Record inserted On  subject timetable id 7', '7', 1, 'Insert', '152.58.36.1', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-09 21:05:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (147, 'New Record inserted On  subject timetable id 6', '6', 1, 'Insert', '152.58.36.1', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-09 21:05:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (148, 'New Record inserted On class teacher id 1', '1', 1, 'Insert', '152.58.36.1', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-09 21:05:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (149, 'New Record inserted On class teacher id 2', '2', 1, 'Insert', '152.58.36.1', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-09 21:05:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (150, 'New Record inserted On class teacher id 3', '3', 1, 'Insert', '152.58.36.1', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-09 21:06:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (151, 'New Record inserted On homework id 3', '3', 1, 'Insert', '103.181.36.203', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-10 08:10:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (152, 'New Record inserted On  Gatepass  Gatepass Create id 0', '0', 1, 'Insert', '152.59.36.208', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-13 19:38:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (153, 'Record updated On Front CMS Setting id 1', '1', 1, 'Update', '152.59.36.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-13 20:03:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (154, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.36.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-13 20:03:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (155, 'Record updated On Front CMS Setting id 1', '1', 1, 'Update', '152.59.36.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-13 20:03:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (156, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.36.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-13 20:03:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (157, 'Record updated On  school houses id 1', '1', 1, 'Update', '42.106.37.184', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-14 20:01:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (158, 'New Record inserted On school houses id 5', '5', 1, 'Insert', '42.106.37.184', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-14 20:02:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (159, 'New Record inserted On school houses id 6', '6', 1, 'Insert', '42.106.37.184', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-14 20:02:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (160, 'Record deleted On exam groups id 2', '2', 1, 'Delete', '1.187.183.123', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-16 09:32:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (161, 'Record updated On settings id 1', '1', 1, 'Update', '103.89.43.102', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-16 20:28:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (162, 'Record updated On settings id 1', '1', 1, 'Update', '103.89.43.102', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-16 20:29:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (163, 'Record updated On settings id 1', '1', 1, 'Update', '103.89.43.102', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-16 20:29:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (164, 'Record updated On settings id 1', '1', 1, 'Update', '103.89.43.102', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-16 20:30:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (165, 'Record updated On settings id 1', '1', 1, 'Update', '103.89.43.102', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-16 20:32:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (166, 'Record updated On settings id 1', '1', 1, 'Update', '103.89.43.102', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-16 20:33:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (167, 'Record updated On cbse exam group exams name id 9', '9', 1, 'Update', '171.79.37.54', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-17 15:09:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (168, 'Record updated On  mh exam groups id 1', '1', 1, 'Update', '152.59.22.242', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-17 16:48:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (169, 'New Record inserted On mh exam groups id 2', '2', 1, 'Insert', '27.59.118.252', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-17 20:43:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (170, 'Record updated On mh exam group exams name id 6', '6', 1, 'Update', '27.59.118.252', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-17 20:58:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (171, 'New Record inserted On mh exam group exams name id 7', '7', 1, 'Insert', '27.59.118.252', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-17 21:04:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (172, 'Record updated On mh exam group exams name id 7', '7', 1, 'Update', '27.59.118.252', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-17 21:33:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (173, 'Record updated On mh exam group exams name id 7', '7', 1, 'Update', '27.59.118.252', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-17 21:39:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (174, 'New Record inserted On exam group exams name id 10', '10', 1, 'Insert', '27.59.124.252', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-17 22:48:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (175, 'New Record inserted On exam group exams name id 11', '11', 1, 'Insert', '27.59.124.252', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-17 22:50:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (176, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.47.122', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-19 05:52:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (177, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.47.189', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-19 05:54:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (178, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.47.147', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-19 05:56:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (179, 'New Record inserted On mh exam groups id 3', '3', 1, 'Insert', '1.187.212.65', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-19 06:31:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (180, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.24.233', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-19 10:40:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (181, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.24.184', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-19 10:46:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (182, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.24.184', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-19 10:46:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (183, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.24.184', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-19 10:46:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (184, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.24.136', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-19 10:47:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (185, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.24.8', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-19 11:05:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (186, 'New Record inserted On subject groups id 9', '9', 1, 'Insert', '152.58.41.1', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-20 07:05:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (187, 'New Record inserted On subject groups id 10', '10', 1, 'Insert', '152.58.41.167', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-20 07:16:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (188, 'Record deleted On subject groups id 10', '10', 1, 'Delete', '152.58.41.165', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-20 07:17:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (189, 'New Record inserted On subject groups id 11', '11', 1, 'Insert', '152.58.41.38', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-20 07:45:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (190, 'Record deleted On subject groups id 11', '11', 1, 'Delete', '152.58.41.23', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-20 07:46:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (191, 'New Record inserted On subject groups id 12', '12', 1, 'Insert', '152.58.41.220', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-20 07:47:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (192, 'Record deleted On subject groups id 2', '2', 1, 'Delete', '152.58.41.62', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-20 08:08:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (193, 'Record deleted On subject groups id 9', '9', 1, 'Delete', '152.58.41.62', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-20 08:08:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (194, 'Record deleted On subject groups id 12', '12', 1, 'Delete', '152.58.41.62', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-20 08:08:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (195, 'Record deleted On subject groups id 1', '1', 1, 'Delete', '152.58.41.115', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-20 08:09:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (196, 'New Record inserted On subject groups id 13', '13', 1, 'Insert', '152.58.41.222', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-20 08:10:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (197, 'Record deleted On subject groups id 13', '13', 1, 'Delete', '152.58.41.239', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-20 08:11:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (198, 'New Record inserted On subject groups id 14', '14', 1, 'Insert', '152.58.41.168', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-20 08:12:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (199, 'New Record inserted On exam group exams name id 12', '12', 1, 'Insert', '152.58.41.126', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-20 08:32:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (200, 'Record deleted On subject groups id 14', '14', 1, 'Delete', '152.58.41.236', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-20 09:16:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (201, 'New Record inserted On subject groups id 15', '15', 1, 'Insert', '152.58.41.236', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-20 09:17:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (202, 'New Record inserted On exam groups id 1', '1', 1, 'Insert', '152.59.46.134', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-21 04:58:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (203, 'New Record inserted On exam group exams name id 1', '1', 1, 'Insert', '152.59.46.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-21 04:59:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (204, 'New Record inserted On student apply leave id 1', '1', 1, 'Insert', '27.60.9.182', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-21 09:25:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (205, 'Record updated On  student apply leave id 1', '1', 1, 'Update', '27.60.9.182', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-21 09:26:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (206, 'New Record inserted On class teacher id 7', '7', 1, 'Insert', '27.60.9.182', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-21 09:54:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (207, 'New Record inserted On student apply leave id 1', '1', 1, 'Insert', '27.60.9.182', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-21 10:04:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (208, 'New Record inserted On exam group exams name id 2', '2', 1, 'Insert', '152.59.48.158', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-21 11:07:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (209, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.62.211', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-21 16:24:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (210, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.62.211', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-21 16:24:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (211, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.62.211', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-21 16:25:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (212, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.62.211', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-21 16:27:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (213, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.62.211', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-21 16:29:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (214, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.62.211', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-21 16:29:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (215, 'Record updated On staff id 2', '2', 1, 'Update', '27.60.11.206', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-21 23:15:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (216, 'Record updated On staff id 2', '2', 1, 'Update', '27.60.11.206', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-21 23:15:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (217, 'Record updated On staff id 2', '2', 1, 'Update', '27.60.11.206', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-21 23:16:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (218, 'Record updated On staff id 2', '2', 1, 'Update', '27.60.11.206', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-21 23:16:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (219, 'New Record inserted On mh exam groups id 4', '4', 1, 'Insert', '152.58.62.194', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-21 23:50:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (220, 'Record updated On  mh exam groups id 4', '4', 1, 'Update', '152.58.62.194', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-21 23:51:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (221, 'New Record inserted On mh exam group exams name id 8', '8', 1, 'Insert', '152.58.62.194', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-21 23:51:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (222, 'New Record inserted On mh exam groups id 5', '5', 1, 'Insert', '27.97.102.201', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-22 03:16:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (223, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.33.181', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-24 18:54:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (224, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.33.181', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-24 19:04:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (225, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.33.34', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-24 19:16:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (226, 'New Record inserted On mh exam groups id 6', '6', 1, 'Insert', '152.58.61.96', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-25 07:10:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (227, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.61.96', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-25 07:28:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (228, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.61.96', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-25 07:34:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (229, 'Record updated On students id 1', '1', 1, 'Update', '27.60.7.104', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 05:54:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (230, 'Record updated On students id 1', '1', 1, 'Update', '27.60.7.104', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 05:55:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (231, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.183', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:04:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (232, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.217', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:05:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (233, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.217', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:06:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (234, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.83', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:12:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (235, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.122', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:15:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (236, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.122', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:15:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (237, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.122', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:15:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (238, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.97', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:40:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (239, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.150', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:44:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (240, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.150', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:44:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (241, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.51', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:47:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (242, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.51', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:47:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (243, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.139', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:48:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (244, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:50:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (245, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.1', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:53:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (246, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.205', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:55:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (247, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.211', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:55:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (248, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.89', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:56:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (249, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.148', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:57:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (250, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.201', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:58:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (251, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.130', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:59:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (252, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.130', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 09:59:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (253, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.103', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:00:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (254, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.235', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:00:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (255, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.162', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:01:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (256, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.205', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:18:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (257, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.80', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:19:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (258, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.196', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:21:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (259, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.187', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:28:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (260, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.56.254', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:29:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (261, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:29:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (262, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.220', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:29:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (263, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.56.203', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:30:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (264, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.56.239', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:33:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (265, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.56.159', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:33:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (266, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.56.179', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:34:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (267, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.56.248', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:34:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (268, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.56.123', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:36:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (269, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.56.146', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:40:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (270, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.251', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:41:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (271, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.56.73', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:42:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (272, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.245', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:44:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (273, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.128', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:45:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (274, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.13', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 10:47:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (275, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.56.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 11:07:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (276, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.56.81', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 11:13:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (277, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.251', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 11:13:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (278, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.56.60', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 11:14:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (279, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.60', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 11:14:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (280, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.56.158', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 11:15:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (281, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.158', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 11:15:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (282, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.211', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 11:16:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (283, 'Record updated On students id 1', '1', 1, 'Update', '152.58.56.117', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 11:16:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (284, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.240', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 12:22:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (285, 'Record updated On users id 1', '1', 1, 'Update', '152.58.24.66', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 12:23:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (286, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.40', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 12:26:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (287, 'Record updated On users id 1', '1', 1, 'Update', '152.58.24.40', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 12:26:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (288, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.45', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 12:27:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (289, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.103', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 12:30:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (290, 'Record updated On users id 1', '1', 1, 'Update', '152.58.24.36', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 12:30:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (291, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.59', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 12:33:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (292, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.241', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 12:34:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (293, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.183', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 12:36:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (294, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.161', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 12:36:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (295, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.167', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 12:37:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (296, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.91', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 12:38:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (297, 'Record updated On users id 1', '1', 1, 'Update', '152.58.24.11', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 12:38:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (298, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.24.206', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 12:51:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (299, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.24.27', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 12:51:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (300, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.194', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 13:14:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (301, 'Record updated On users id 1', '1', 1, 'Update', '152.58.24.252', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 13:18:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (302, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.26', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 13:25:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (303, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.142', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 13:32:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (304, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:07:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (305, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:09:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (306, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:09:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (307, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:09:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (308, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:09:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (309, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:09:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (310, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:09:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (311, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:10:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (312, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:10:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (313, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:11:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (314, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:12:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (315, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:12:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (316, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:12:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (317, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:13:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (318, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:14:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (319, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:15:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (320, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:17:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (321, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:19:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (322, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:19:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (323, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:19:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (324, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:19:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (325, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:19:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (326, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:20:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (327, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:20:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (328, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:20:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (329, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:20:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (330, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:20:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (331, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:21:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (332, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:21:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (333, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:21:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (334, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:22:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (335, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:23:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (336, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:23:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (337, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.216', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:24:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (338, 'Record updated On students id 1', '1', 1, 'Update', '152.58.35.146', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:30:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (339, 'Record updated On students id 1', '1', 1, 'Update', '152.58.35.146', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:31:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (340, 'Record updated On students id 1', '1', 1, 'Update', '152.58.35.146', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:32:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (341, 'Record updated On students id 1', '1', 1, 'Update', '152.58.35.32', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:33:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (342, 'Record updated On students id 1', '1', 1, 'Update', '152.58.35.32', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:33:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (343, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.56', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:36:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (344, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.56', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:37:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (345, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.56', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:38:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (346, 'Record updated On students id 1', '1', 1, 'Update', '152.58.34.56', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:38:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (347, 'Record updated On students id 1', '1', 1, 'Update', '152.58.35.186', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:39:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (348, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:51:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (349, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:51:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (350, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:54:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (351, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:54:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (352, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:54:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (353, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:54:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (354, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:55:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (355, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:56:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (356, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:57:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (357, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 18:58:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (358, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:00:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (359, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:00:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (360, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:01:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (361, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:01:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (362, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:01:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (363, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:02:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (364, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:02:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (365, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:14:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (366, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:15:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (367, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:15:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (368, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:18:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (369, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:18:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (370, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:18:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (371, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:22:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (372, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:22:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (373, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:22:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (374, 'Record updated On students id 1', '1', 1, 'Update', '42.104.232.10', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:22:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (375, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:24:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (376, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:24:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (377, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:25:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (378, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:25:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (379, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:25:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (380, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:25:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (381, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:26:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (382, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:26:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (383, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:26:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (384, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:26:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (385, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:27:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (386, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:27:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (387, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:27:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (388, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:29:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (389, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:29:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (390, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:29:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (391, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:29:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (392, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:29:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (393, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:30:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (394, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:31:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (395, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:31:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (396, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:31:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (397, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:32:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (398, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:32:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (399, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:32:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (400, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:32:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (401, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:32:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (402, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:32:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (403, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:33:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (404, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:33:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (405, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:33:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (406, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:34:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (407, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:34:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (408, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:34:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (409, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:35:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (410, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:35:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (411, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:35:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (412, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:36:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (413, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:36:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (414, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:36:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (415, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:36:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (416, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:37:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (417, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:37:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (418, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:38:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (419, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:38:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (420, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:38:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (421, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:38:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (422, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:39:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (423, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:39:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (424, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:39:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (425, 'Record updated On students id 1', '1', 1, 'Update', '152.58.63.185', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:40:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (426, 'Record updated On students id 1', '1', 1, 'Update', '152.58.63.185', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:40:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (427, 'Record updated On students id 1', '1', 1, 'Update', '152.58.63.185', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:40:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (428, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:40:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (429, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:41:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (430, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:41:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (431, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:42:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (432, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:43:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (433, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:43:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (434, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:44:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (435, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:45:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (436, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:45:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (437, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:46:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (438, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:47:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (439, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:47:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (440, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:47:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (441, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:48:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (442, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:48:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (443, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:48:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (444, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:48:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (445, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:48:50', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (446, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:48:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (447, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:49:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (448, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:49:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (449, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:50:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (450, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:50:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (451, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:50:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (452, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:50:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (453, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:50:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (454, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:51:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (455, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:51:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (456, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:52:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (457, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:52:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (458, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:52:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (459, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:52:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (460, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:54:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (461, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:54:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (462, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:55:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (463, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:55:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (464, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:55:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (465, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:55:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (466, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:55:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (467, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:58:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (468, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:58:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (469, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 19:58:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (470, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 20:00:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (471, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 20:00:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (472, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 20:00:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (473, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 20:01:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (474, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 20:01:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (475, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 20:02:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (476, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 20:03:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (477, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 20:03:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (478, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 20:04:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (479, 'Record updated On students id 1', '1', 1, 'Update', '152.58.62.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-27 20:05:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (480, 'Record updated On users id 1', '1', 1, 'Update', '152.58.25.215', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-28 05:28:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (481, 'New Record inserted On student apply leave id 2', '2', 0, 'Insert', '152.58.25.215', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-28 05:31:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (482, 'Record updated On students id 1', '1', 1, 'Update', '152.58.25.68', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-28 05:56:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (483, 'Record updated On  student session id 1', '1', 1, 'Update', '152.58.25.68', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-28 05:56:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (484, 'Record updated On students id 1', '1', 1, 'Update', '152.58.25.68', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-28 05:56:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (485, 'Record updated On  student session id 1', '1', 1, 'Update', '152.58.25.68', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-28 05:56:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (486, 'Record updated On students id 1', '1', 1, 'Update', '152.58.25.68', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-28 05:56:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (487, 'Record updated On  student session id 1', '1', 1, 'Update', '152.58.25.68', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-28 05:56:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (488, 'Record updated On settings id 1', '1', 1, 'Update', '106.216.251.54', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-28 06:17:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (489, 'New Record inserted On  online exam id 1', '1', 1, 'Insert', '106.216.251.54', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-28 07:43:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (490, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.24.54', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 04:51:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (491, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.24.54', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 04:54:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (492, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.24.54', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 04:57:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (493, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.24.54', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 04:57:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (494, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.24.54', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 04:58:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (495, 'New Record inserted On student incident comments id 1', '1', 1, 'Insert', '1.187.214.133', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 07:25:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (496, 'Record updated On students id 1', '1', 1, 'Update', '103.137.155.13', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 08:17:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (497, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.24', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:19:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (498, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.250', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:21:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (499, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:24:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (500, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.86', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:30:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (501, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.86', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:30:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (502, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.86', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:30:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (503, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.86', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:30:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (504, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.86', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:31:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (505, 'Record updated On students id 1', '1', 1, 'Update', '152.58.59.136', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:31:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (506, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.86', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:31:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (507, 'Record updated On students id 1', '1', 1, 'Update', '152.58.59.136', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:33:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (508, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.86', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:34:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (509, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.86', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:34:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (510, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.86', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:35:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (511, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.86', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:35:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (512, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.86', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:36:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (513, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.86', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:38:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (514, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.86', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:38:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (515, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.86', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:39:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (516, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.86', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:39:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (517, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.86', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:39:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (518, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.86', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:39:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (519, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.86', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:39:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (520, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.86', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:40:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (521, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.24', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:47:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (522, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.150', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:49:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (523, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.100', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:50:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (524, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.46', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:50:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (525, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.96', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:53:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (526, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.243', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:53:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (527, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.176', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:54:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (528, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.246', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:54:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (529, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.246', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:54:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (530, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.154', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 08:56:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (531, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.106', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 09:08:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (532, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.106', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 09:08:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (533, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.106', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 09:08:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (534, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.106', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 09:08:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (535, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.93', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 09:09:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (536, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.93', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 09:09:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (537, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.148', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 09:12:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (538, 'Record updated On students id 1', '1', 1, 'Update', '152.58.24.129', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 09:12:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (539, 'Record updated On users id 1', '1', 1, 'Update', '110.224.174.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 09:21:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (540, 'Record updated On students id 1', '1', 1, 'Update', '110.224.174.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 09:22:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (541, 'New Record inserted On students id 2', '2', 1, 'Insert', '103.137.155.13', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 09:22:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (542, 'New Record inserted On  student session id 2', '2', 1, 'Insert', '103.137.155.13', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 09:22:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (543, 'New Record inserted On users id 3', '3', 1, 'Insert', '103.137.155.13', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 09:22:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (544, 'New Record inserted On users id 4', '4', 1, 'Insert', '103.137.155.13', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 09:22:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (545, 'Record updated On students id 2', '2', 1, 'Update', '103.137.155.13', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 09:22:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (546, 'Record updated On students id 1', '1', 1, 'Update', '110.224.174.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 09:23:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (547, 'Record updated On students id 1', '1', 1, 'Update', '110.224.174.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 09:23:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (548, 'Record updated On students id 1', '1', 1, 'Update', '110.224.174.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 09:24:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (549, 'Record updated On students id 1', '1', 1, 'Update', '110.224.174.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 09:24:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (550, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.24.82', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 09:32:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (551, 'Record updated On students id 1', '1', 1, 'Update', '110.224.174.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 09:45:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (552, 'Record updated On students id 1', '1', 1, 'Update', '110.224.174.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 09:45:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (553, 'Record updated On students id 1', '1', 1, 'Update', '110.224.174.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 09:58:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (554, 'Record updated On students id 1', '1', 1, 'Update', '110.224.174.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 09:58:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (555, 'Record updated On students id 1', '1', 1, 'Update', '110.224.174.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 09:59:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (556, 'Record updated On students id 1', '1', 1, 'Update', '110.224.174.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 09:59:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (557, 'Record updated On students id 1', '1', 1, 'Update', '110.224.174.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 10:00:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (558, 'Record updated On students id 1', '1', 1, 'Update', '110.224.174.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 10:02:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (559, 'Record updated On students id 1', '1', 1, 'Update', '110.224.174.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 10:03:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (560, 'Record updated On students id 1', '1', 1, 'Update', '110.224.174.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 10:09:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (561, 'Record updated On students id 1', '1', 1, 'Update', '110.224.174.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 10:09:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (562, 'Record updated On students id 1', '1', 1, 'Update', '110.224.174.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 10:15:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (563, 'Record updated On students id 1', '1', 1, 'Update', '110.224.174.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 10:17:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (564, 'Record updated On students id 1', '1', 1, 'Update', '110.224.174.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 10:24:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (565, 'Record updated On students id 1', '1', 1, 'Update', '110.224.174.199', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 10:25:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (566, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.25.232', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 10:40:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (567, 'New Record inserted On mark_divisions id 1', '1', 1, 'Update', '152.59.49.85', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-31 11:21:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (568, 'Record deleted On mark_divisions id 1', '1', 1, 'Delete', '152.59.49.85', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-31 11:21:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (569, 'New Record inserted On email template id 1', '1', 1, 'Insert', '152.59.49.85', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-31 11:42:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (570, 'Record deleted On email template id 1', '1', 1, 'Delete', '152.59.49.85', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-31 11:42:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (571, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.20.114', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-01 01:50:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (572, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.20.114', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-01 01:50:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (573, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.20.114', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-01 01:56:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (574, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.20.114', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-01 01:56:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (575, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.20.114', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-01 01:58:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (576, 'Record updated On students id 2', '2', 1, 'Update', '152.59.23.159', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-02 17:28:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (577, 'Record updated On students id 2', '2', 1, 'Update', '152.59.23.159', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-02 17:34:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (578, 'Record updated On students id 2', '2', 1, 'Update', '152.59.23.159', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-02 17:34:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (579, 'Record updated On students id 2', '2', 1, 'Update', '152.59.23.159', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-02 17:35:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (580, 'Record updated On students id 2', '2', 1, 'Update', '152.59.23.159', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-02 17:35:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (581, 'Record updated On students id 2', '2', 1, 'Update', '152.59.23.159', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-02 17:36:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (582, 'Record updated On students id 2', '2', 1, 'Update', '152.59.23.159', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-02 17:36:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (583, 'Record updated On students id 2', '2', 1, 'Update', '152.59.23.159', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-02 17:36:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (584, 'Record updated On students id 2', '2', 1, 'Update', '42.106.9.72', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-02 18:06:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (585, 'Record updated On students id 2', '2', 1, 'Update', '42.106.9.72', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-02 18:06:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (586, 'Record updated On students id 2', '2', 1, 'Update', '42.106.9.72', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-02 18:20:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (587, 'Record updated On students id 2', '2', 1, 'Update', '42.106.9.72', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-02 18:21:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (588, 'Record updated On students id 1', '1', 1, 'Update', '42.106.9.72', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-02 18:37:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (589, 'Record updated On students id 1', '1', 1, 'Update', '42.106.9.72', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-02 18:39:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (590, 'Record updated On students id 1', '1', 1, 'Update', '42.106.9.72', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-02 18:41:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (591, 'Record updated On users id 1', '1', 1, 'Update', '103.112.33.108', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 04:44:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (592, 'Record updated On students id 1', '1', 1, 'Update', '103.112.33.108', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 04:45:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (593, 'Record updated On students id 1', '1', 1, 'Update', '103.112.33.108', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 04:46:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (594, 'Record updated On students id 1', '1', 1, 'Update', '103.112.33.108', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 04:46:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (595, 'New Record inserted On subject groups id 26', '26', 1, 'Insert', '152.59.49.141', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-03 05:38:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (596, 'Record deleted On subject groups id 26', '26', 1, 'Delete', '152.59.49.141', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-03 05:38:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (597, 'Record deleted On exam groups id 1', '1', 1, 'Delete', '152.59.49.160', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-03 05:53:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (598, 'Record deleted On exam groups id 2', '2', 1, 'Delete', '152.59.49.160', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-03 05:53:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (599, 'Record deleted On exam groups id 3', '3', 1, 'Delete', '152.59.49.160', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-03 05:53:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (600, 'Record deleted On exam groups id 4', '4', 1, 'Delete', '152.59.49.160', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-03 05:53:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (601, 'Record deleted On exam groups id 5', '5', 1, 'Delete', '152.59.49.160', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-03 05:53:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (602, 'Record deleted On exam groups id 6', '6', 1, 'Delete', '152.59.49.160', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-03 05:53:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (603, 'New Record inserted On mh exam groups id 7', '7', 1, 'Insert', '152.59.49.7', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-03 05:54:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (604, 'New Record inserted On mh exam group exams name id 9', '9', 1, 'Insert', '152.59.49.248', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-03 05:56:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (605, 'New Record inserted On mh exam groups id 8', '8', 1, 'Insert', '152.59.49.233', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-03 06:12:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (606, 'New Record inserted On mh exam groups id 9', '9', 1, 'Insert', '152.59.49.99', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-03 06:13:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (607, 'New Record inserted On mh exam groups id 10', '10', 1, 'Insert', '152.59.49.211', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-03 06:13:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (608, 'New Record inserted On mh exam groups id 11', '11', 1, 'Insert', '152.59.49.211', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-03 06:13:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (609, 'New Record inserted On mh exam groups id 12', '12', 1, 'Insert', '152.59.49.211', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-03 06:14:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (610, 'New Record inserted On mh exam groups id 13', '13', 1, 'Insert', '152.59.49.211', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-03 06:14:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (611, 'New Record inserted On mh exam groups id 14', '14', 1, 'Insert', '152.59.49.211', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-03 06:14:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (612, 'New Record inserted On mh exam groups id 15', '15', 1, 'Insert', '152.59.49.200', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-03 06:15:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (613, 'New Record inserted On mh exam groups id 16', '16', 1, 'Insert', '152.59.49.27', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-03 06:15:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (614, 'New Record inserted On mh exam groups id 17', '17', 1, 'Insert', '152.59.49.11', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-03 06:16:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (615, 'New Record inserted On mh exam groups id 18', '18', 1, 'Insert', '152.59.49.66', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-03 06:16:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (616, 'New Record inserted On subject groups id 26', '26', 1, 'Insert', '152.58.35.18', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 19:06:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (617, 'New Record inserted On lesson id 1', '1', 1, 'Insert', '152.58.34.82', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 19:07:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (618, 'Record updated On Front CMS Setting id 1', '1', 1, 'Update', '152.58.35.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 19:27:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (619, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.35.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 19:27:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (620, 'Record updated On Front CMS Setting id 1', '1', 1, 'Update', '152.58.35.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 19:33:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (621, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.35.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 19:33:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (622, 'Record updated On Front CMS Setting id 1', '1', 1, 'Update', '152.58.35.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 19:37:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (623, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.35.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 19:37:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (624, 'Record updated On Front CMS Setting id 1', '1', 1, 'Update', '152.58.35.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 19:39:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (625, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.35.155', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 19:39:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (626, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.34.182', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 19:43:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (627, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.34.182', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 19:45:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (628, 'Record updated On users id 1', '1', 1, 'Update', '152.58.35.105', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 20:05:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (629, 'New Record inserted On  Gatepass  Gatepass Create id 2', '2', 1, 'Insert', '152.58.34.252', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 20:18:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (630, 'New Record inserted On  Gatepass  Gatepass Create id 1', '1', 1, 'Insert', '152.58.34.124', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 21:11:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (631, 'New Record inserted On  Gatepass  Gatepass Create id 2', '2', 1, 'Insert', '152.58.34.124', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 21:23:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (632, 'Record updated On Admission Enquiry Gatepass Update  id 2', '2', 1, 'Update', '152.58.35.73', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 22:01:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (633, 'Record updated On Admission Enquiry Gatepass Update  id 1', '1', 1, 'Update', '152.58.35.73', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 22:01:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (634, 'Record updated On Admission Enquiry Gatepass Update  id 2', '2', 1, 'Update', '152.58.35.73', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 22:06:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (635, 'Record deleted Change Logs 2', '2', 1, 'Delete', '152.58.35.73', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-03 22:09:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (636, 'New Record inserted On room types id 1', '1', 1, 'Insert', '152.59.48.20', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-05 06:43:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (637, 'New Record inserted On hostel rooms id 1', '1', 1, 'Insert', '152.59.48.114', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-05 06:45:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (638, 'Record updated On students id 1', '1', 1, 'Update', '152.59.48.69', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-05 06:51:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (639, 'Record updated On  student session id 1', '1', 1, 'Update', '152.59.48.69', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-05 06:51:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (640, 'New Record inserted On  Gatepass  ChangeLog Create id 3', '3', 1, 'Insert', '171.79.37.10', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-05 08:08:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (641, 'New Record inserted On  Gatepass  ChangeLog Create id 4', '4', 1, 'Insert', '171.79.37.10', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-05 08:17:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (642, 'Record updated On Admission Enquiry Gatepass Update  id 4', '4', 1, 'Update', '171.79.37.10', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-05 08:17:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (643, 'New Record inserted On leave types id 1', '1', 1, 'Insert', '152.59.49.196', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-05 11:47:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (644, 'Record updated On leave types id 1', '1', 1, 'Update', '152.59.49.245', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-05 11:51:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (645, 'Record updated On students id 1', '1', 1, 'Update', '152.59.49.20', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-05 12:07:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (646, 'New Record inserted On Alumni Student id 1', '1', 1, 'Insert', '152.59.49.17', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-05 12:17:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (647, 'Record updated On users id 1', '1', 1, 'Update', '152.59.49.51', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-05 12:55:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (648, 'New Record inserted On  Gatepass  ChangeLog Create id 5', '5', 1, 'Insert', '152.59.49.255', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-05 13:13:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (649, 'Record updated On Admission Enquiry Gatepass Update  id 5', '5', 1, 'Update', '152.59.49.28', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-05 13:16:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (650, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.48.116', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 04:40:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (651, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.59.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 10:28:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (652, 'New Record inserted On students id 3', '3', 1, 'Insert', '152.59.31.198', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 10:51:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (653, 'New Record inserted On  student session id 3', '3', 1, 'Insert', '152.59.31.198', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 10:51:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (654, 'New Record inserted On users id 5', '5', 1, 'Insert', '152.59.31.198', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 10:51:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (655, 'New Record inserted On users id 6', '6', 1, 'Insert', '152.59.31.198', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 10:51:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (656, 'Record updated On students id 3', '3', 1, 'Update', '152.59.31.198', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 10:51:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (657, 'Record updated On students id 1', '1', 1, 'Update', '152.59.29.250', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:20:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (658, 'Record updated On students id 3', '3', 1, 'Update', '152.59.31.205', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:38:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (659, 'Record updated On  student session id 3', '3', 1, 'Update', '152.59.31.205', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:38:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (660, 'New Record inserted On students id 4', '4', 1, 'Insert', '152.59.31.205', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:43:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (661, 'New Record inserted On  student session id 4', '4', 1, 'Insert', '152.59.31.205', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:43:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (662, 'New Record inserted On users id 7', '7', 1, 'Insert', '152.59.31.205', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:43:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (663, 'New Record inserted On users id 8', '8', 1, 'Insert', '152.59.31.205', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:43:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (664, 'Record updated On students id 4', '4', 1, 'Update', '152.59.31.205', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:43:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (665, 'New Record inserted On students id 5', '5', 1, 'Insert', '152.59.31.19', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:48:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (666, 'New Record inserted On  student session id 5', '5', 1, 'Insert', '152.59.31.19', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:48:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (667, 'New Record inserted On users id 9', '9', 1, 'Insert', '152.59.31.19', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:48:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (668, 'New Record inserted On users id 10', '10', 1, 'Insert', '152.59.31.19', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:48:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (669, 'Record updated On students id 5', '5', 1, 'Update', '152.59.31.19', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:48:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (670, 'Record updated On students id 5', '5', 1, 'Update', '152.59.31.10', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:51:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (671, 'Record updated On users id 9', '9', 1, 'Update', '152.59.31.188', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:52:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (672, 'Record updated On students id 5', '5', 1, 'Update', '152.59.31.171', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:53:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (673, 'Record updated On users id 9', '9', 1, 'Update', '152.59.31.9', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:55:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (674, 'Record updated On students id 5', '5', 1, 'Update', '152.59.31.230', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:55:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (675, 'Record updated On  student session id 5', '5', 1, 'Update', '152.59.31.230', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:55:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (676, 'New Record inserted On students id 6', '6', 1, 'Insert', '152.59.31.197', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:57:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (677, 'New Record inserted On  student session id 6', '6', 1, 'Insert', '152.59.31.197', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:57:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (678, 'New Record inserted On users id 11', '11', 1, 'Insert', '152.59.31.197', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:57:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (679, 'New Record inserted On users id 12', '12', 1, 'Insert', '152.59.31.197', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:57:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (680, 'Record updated On students id 6', '6', 1, 'Update', '152.59.31.197', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:57:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (681, 'Record updated On students id 6', '6', 1, 'Update', '152.59.31.197', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 11:58:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (682, 'New Record inserted On students id 7', '7', 1, 'Insert', '152.59.31.201', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 12:04:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (683, 'New Record inserted On  student session id 7', '7', 1, 'Insert', '152.59.31.201', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 12:04:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (684, 'New Record inserted On users id 13', '13', 1, 'Insert', '152.59.31.201', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 12:04:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (685, 'New Record inserted On users id 14', '14', 1, 'Insert', '152.59.31.201', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 12:04:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (686, 'Record updated On students id 7', '7', 1, 'Update', '152.59.31.201', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 12:04:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (687, 'Record updated On students id 7', '7', 1, 'Update', '152.59.31.201', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 12:05:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (688, 'Record updated On users id 13', '13', 1, 'Update', '152.59.31.94', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 12:08:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (689, 'Record updated On students id 7', '7', 1, 'Update', '152.59.31.5', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 12:09:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (690, 'Record updated On  student session id 7', '7', 1, 'Update', '152.59.31.5', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 12:09:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (691, 'Record updated On students id 7', '7', 1, 'Update', '152.59.31.255', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 12:10:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (692, 'Record updated On  student session id 7', '7', 1, 'Update', '152.59.31.255', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 12:10:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (693, 'Record updated On students id 7', '7', 1, 'Update', '152.59.31.255', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 12:12:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (694, 'Record updated On  student session id 7', '7', 1, 'Update', '152.59.31.255', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 12:12:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (695, 'Record updated On students id 7', '7', 1, 'Update', '152.59.31.15', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 12:15:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (696, 'Record updated On  student session id 7', '7', 1, 'Update', '152.59.31.15', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 12:15:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (697, 'Record updated On students id 7', '7', 1, 'Update', '152.59.31.251', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 12:15:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (698, 'Record updated On students id 7', '7', 1, 'Update', '152.59.31.251', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 12:15:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (699, 'Record updated On users id 13', '13', 1, 'Update', '152.59.31.76', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 12:15:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (700, 'Record updated On students id 7', '7', 1, 'Update', '152.59.31.122', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 13:49:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (701, 'Record updated On  student session id 7', '7', 1, 'Update', '152.59.31.122', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-06 13:49:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (702, 'Record updated On users id 1', '1', 1, 'Update', '152.58.26.91', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-07 11:42:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (703, 'New Record inserted On  Gatepass  ChangeLog Create id 6', '6', 1, 'Insert', '152.59.31.128', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-09 13:32:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (704, 'Record updated On student fees deposite id 1', '1', 1, 'Update', '27.60.6.83', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-10 06:47:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (705, 'Record deleted On student applied discounts id 1 and subinvoice id1', '1', 1, 'Delete', '27.60.6.83', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-10 06:47:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (706, 'Record updated On student fees deposite id 1', '1', 1, 'Update', '27.60.6.83', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-10 06:47:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (707, 'Record deleted On student applied discounts id 1 and subinvoice id1', '1', 1, 'Delete', '27.60.6.83', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-10 06:47:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (708, 'New Record inserted On revert_fees_request id 24', '24', 1, 'Insert', '27.60.6.83', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-10 07:04:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (709, 'New Record inserted On revert_fees_request id 1', '1', 1, 'Insert', '27.60.6.83', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-10 07:13:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (710, 'Record updated On students id 7', '7', 1, 'Update', '152.59.47.20', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-10 07:20:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (711, 'Record updated On users id 3', '3', 1, 'Update', '152.58.56.66', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-10 08:37:17', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (712, 'New Record inserted On revert_fees_request id 1', '1', 1, 'Insert', '1.187.182.229', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-10 09:44:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (713, 'Record updated On students id 2', '2', 1, 'Update', '152.58.58.90', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 04:37:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (714, 'Record updated On students id 1', '1', 1, 'Update', '27.60.4.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 06:48:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (715, 'Record updated On students id 1', '1', 1, 'Update', '27.60.4.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 07:27:24', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (716, 'Record updated On students id 1', '1', 1, 'Update', '27.60.4.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 07:27:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (717, 'Record updated On students id 1', '1', 1, 'Update', '27.60.4.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 07:27:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (718, 'Record updated On students id 1', '1', 1, 'Update', '27.60.4.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 07:28:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (719, 'Record updated On students id 1', '1', 1, 'Update', '27.60.4.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 07:30:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (720, 'Record updated On students id 1', '1', 1, 'Update', '27.60.4.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 07:31:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (721, 'Record updated On students id 1', '1', 1, 'Update', '27.60.4.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 07:32:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (722, 'Record updated On students id 1', '1', 1, 'Update', '27.60.4.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 07:32:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (723, 'Record updated On students id 1', '1', 1, 'Update', '27.60.4.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 07:35:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (724, 'Record updated On students id 1', '1', 1, 'Update', '27.60.4.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 07:40:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (725, 'Record updated On settings id 1', '1', 1, 'Update', '27.60.4.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 07:45:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (726, 'Record updated On students id 1', '1', 1, 'Update', '27.60.4.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 07:45:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (727, 'Record updated On students id 1', '1', 1, 'Update', '27.60.4.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 07:52:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (728, 'Record updated On students id 1', '1', 1, 'Update', '27.60.4.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 07:53:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (729, 'Record updated On students id 1', '1', 1, 'Update', '27.60.4.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 08:01:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (730, 'Record updated On students id 1', '1', 1, 'Update', '152.58.25.58', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 09:42:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (731, 'Record updated On staff id 1', '1', 1, 'Update', '106.220.215.215', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 11:50:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (732, 'Record updated On staff id 1', '1', 1, 'Update', '106.220.215.215', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 11:50:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (733, 'Record updated On students id 1', '1', 1, 'Update', '152.59.49.159', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 11:54:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (734, 'Record updated On staff id 1', '1', 1, 'Update', '106.220.215.215', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 11:59:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (735, 'Record updated On staff id 1', '1', 1, 'Update', '106.220.215.215', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 11:59:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (736, 'New Record inserted On mh exam groups id 19', '19', 1, 'Insert', '106.220.215.215', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 12:06:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (737, 'New Record inserted On students id 8', '8', 1, 'Insert', '106.220.215.215', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 13:33:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (738, 'New Record inserted On  student session id 8', '8', 1, 'Insert', '106.220.215.215', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 13:33:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (739, 'New Record inserted On users id 15', '15', 1, 'Insert', '106.220.215.215', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 13:33:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (740, 'New Record inserted On users id 16', '16', 1, 'Insert', '106.220.215.215', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 13:33:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (741, 'Record updated On students id 8', '8', 1, 'Update', '106.220.215.215', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 13:33:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (742, 'New Record inserted On  categories id 15', '15', 1, 'Insert', '106.220.215.215', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 14:01:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (743, 'New Record inserted On school houses id 7', '7', 1, 'Insert', '106.220.215.215', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 14:02:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (744, 'New Record inserted On disable reason id 3', '3', 1, 'Insert', '106.220.215.215', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 14:02:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (745, 'New Record inserted On  fee group id 2', '2', 1, 'Insert', '152.56.6.171', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 16:07:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (746, 'New Record inserted On  fee type id 3', '3', 1, 'Insert', '152.56.6.171', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 16:08:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (747, 'Record updated On Behaviour Settings id 1', '1', 1, 'Update', '106.220.215.215', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 17:10:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (748, 'Record updated On Behaviour Settings id 1', '1', 1, 'Update', '106.220.215.215', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 17:20:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (749, 'New Record inserted On class teacher id 10', '10', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 17:44:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (750, 'New Record inserted On subject groups id 28', '28', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 17:50:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (751, 'New Record inserted On subjects id 34', '34', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 17:50:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (752, 'New Record inserted On subject groups id 14', '14', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 17:50:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (753, 'New Record inserted On sections id 4', '4', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 17:51:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (754, 'New Record inserted On gmeet settings id 1', '1', 1, 'Insert', '152.56.6.79', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 18:03:59', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (755, 'Record updated On gmeet settings id 1', '1', 1, 'Update', '152.56.6.79', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 18:04:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (756, 'Record updated On gmeet settings id 1', '1', 1, 'Update', '152.56.6.79', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 18:04:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (757, 'Record updated On gmeet settings id 1', '1', 1, 'Update', '152.56.6.79', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 18:04:19', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (758, 'New Record inserted On  Income   id 2', '2', 1, 'Insert', '152.56.6.79', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 18:04:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (759, 'New Record inserted On  expenses   id 2', '2', 1, 'Insert', '152.56.6.79', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-11 18:05:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (760, 'New Record inserted On fee head course id 5', '5', 1, 'Insert', '27.60.6.90', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-12 09:12:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (761, 'New Record inserted On fee head course id 6', '6', 1, 'Insert', '27.60.7.99', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-12 09:39:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (762, 'New Record inserted On fee head course id 7', '7', 1, 'Insert', '27.60.7.99', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-12 09:40:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (763, 'New Record inserted On fee head course id 8', '8', 1, 'Insert', '27.60.7.99', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-12 09:42:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (764, 'New Record inserted On fee head course id 9', '9', 1, 'Insert', '27.60.7.99', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-12 09:42:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (765, 'New Record inserted On fee head course id 10', '10', 1, 'Insert', '27.60.7.99', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-12 09:43:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (766, 'New Record inserted On fee head course id 11', '11', 1, 'Insert', '27.60.7.99', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-12 09:44:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (767, 'Record updated On fee headcourse status updated id 11', '11', 1, 'Update', '27.60.7.99', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-12 09:44:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (768, 'Record updated On online_course_settings id 1', '1', 1, 'Update', '106.221.4.229', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-12 11:59:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (769, 'Record updated On online_course_settings id 1', '1', 1, 'Update', '106.221.4.229', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-12 11:59:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (770, 'Record updated On Behaviour Settings id 1', '1', 1, 'Update', '106.221.4.229', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-12 12:00:57', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (771, 'New Record inserted On  content_types id 1', '1', 1, 'Insert', '106.221.4.229', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-12 12:13:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (772, 'New Record inserted On class teacher id 11', '11', 1, 'Insert', '106.221.4.229', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-12 12:18:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (773, 'New Record inserted On students id 9', '9', 1, 'Insert', '152.59.48.73', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:47:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (774, 'New Record inserted On  student session id 9', '9', 1, 'Insert', '152.59.48.73', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:47:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (775, 'New Record inserted On users id 17', '17', 1, 'Insert', '152.59.48.73', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:47:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (776, 'New Record inserted On users id 18', '18', 1, 'Insert', '152.59.48.73', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:47:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (777, 'Record updated On students id 9', '9', 1, 'Update', '152.59.48.73', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:47:08', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (778, 'New Record inserted On students id 10', '10', 1, 'Insert', '152.59.48.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:49:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (779, 'New Record inserted On  student session id 10', '10', 1, 'Insert', '152.59.48.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:49:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (780, 'New Record inserted On users id 19', '19', 1, 'Insert', '152.59.48.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:49:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (781, 'New Record inserted On users id 20', '20', 1, 'Insert', '152.59.48.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:49:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (782, 'Record updated On students id 10', '10', 1, 'Update', '152.59.48.60', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:49:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (783, 'New Record inserted On students id 11', '11', 1, 'Insert', '152.59.48.13', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:52:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (784, 'New Record inserted On  student session id 11', '11', 1, 'Insert', '152.59.48.13', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:52:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (785, 'New Record inserted On users id 21', '21', 1, 'Insert', '152.59.48.13', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:52:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (786, 'New Record inserted On users id 22', '22', 1, 'Insert', '152.59.48.13', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:52:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (787, 'Record updated On students id 11', '11', 1, 'Update', '152.59.48.13', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:52:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (788, 'New Record inserted On students id 12', '12', 1, 'Insert', '152.59.48.105', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:53:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (789, 'New Record inserted On  student session id 12', '12', 1, 'Insert', '152.59.48.105', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:53:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (790, 'New Record inserted On users id 23', '23', 1, 'Insert', '152.59.48.105', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:53:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (791, 'New Record inserted On users id 24', '24', 1, 'Insert', '152.59.48.105', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:53:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (792, 'Record updated On students id 12', '12', 1, 'Update', '152.59.48.105', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:53:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (793, 'New Record inserted On students id 13', '13', 1, 'Insert', '152.59.48.170', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:57:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (794, 'New Record inserted On  student session id 13', '13', 1, 'Insert', '152.59.48.170', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:57:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (795, 'New Record inserted On users id 25', '25', 1, 'Insert', '152.59.48.170', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:57:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (796, 'New Record inserted On users id 26', '26', 1, 'Insert', '152.59.48.170', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:57:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (797, 'Record updated On students id 13', '13', 1, 'Update', '152.59.48.170', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:57:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (798, 'New Record inserted On students id 14', '14', 1, 'Insert', '152.59.48.170', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:57:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (799, 'New Record inserted On  student session id 14', '14', 1, 'Insert', '152.59.48.170', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:57:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (800, 'New Record inserted On users id 27', '27', 1, 'Insert', '152.59.48.170', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:57:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (801, 'New Record inserted On users id 28', '28', 1, 'Insert', '152.59.48.170', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:57:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (802, 'Record updated On students id 14', '14', 1, 'Update', '152.59.48.170', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:57:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (803, 'New Record inserted On students id 15', '15', 1, 'Insert', '152.59.48.135', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:59:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (804, 'New Record inserted On  student session id 15', '15', 1, 'Insert', '152.59.48.135', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:59:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (805, 'New Record inserted On users id 29', '29', 1, 'Insert', '152.59.48.135', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:59:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (806, 'New Record inserted On users id 30', '30', 1, 'Insert', '152.59.48.135', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:59:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (807, 'Record updated On students id 15', '15', 1, 'Update', '152.59.48.135', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:59:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (808, 'New Record inserted On students id 16', '16', 1, 'Insert', '152.59.48.33', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 05:00:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (809, 'New Record inserted On  student session id 16', '16', 1, 'Insert', '152.59.48.33', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 05:00:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (810, 'New Record inserted On users id 31', '31', 1, 'Insert', '152.59.48.33', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 05:00:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (811, 'New Record inserted On users id 32', '32', 1, 'Insert', '152.59.48.33', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 05:00:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (812, 'Record updated On students id 16', '16', 1, 'Update', '152.59.48.33', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 05:00:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (813, 'New Record inserted On students id 17', '17', 1, 'Insert', '152.59.48.239', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 05:00:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (814, 'New Record inserted On  student session id 17', '17', 1, 'Insert', '152.59.48.239', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 05:00:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (815, 'New Record inserted On users id 33', '33', 1, 'Insert', '152.59.48.239', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 05:00:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (816, 'New Record inserted On users id 34', '34', 1, 'Insert', '152.59.48.239', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 05:00:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (817, 'Record updated On students id 17', '17', 1, 'Update', '152.59.48.239', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 05:00:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (818, 'New Record inserted On  holiday master  id 2', '2', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 06:56:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (819, 'New Record inserted On  holiday master  id 3', '3', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 06:57:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (820, 'New Record inserted On  holiday master  id 4', '4', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 06:58:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (821, 'New Record inserted On holiday_type id 4', '4', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 06:58:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (822, 'New Record inserted On holiday_type id 5', '5', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 06:58:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (823, 'New Record inserted On holiday_type id 6', '6', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 06:59:05', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (824, 'New Record inserted On holiday_type id 7', '7', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 06:59:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (825, 'Record updated On staff id 2', '2', 1, 'Update', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 07:10:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (826, 'Record updated On staff id 2', '2', 1, 'Update', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 07:10:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (827, 'Record updated On staff id 1', '1', 1, 'Update', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 07:11:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (828, 'Record updated On staff id 1', '1', 1, 'Update', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 07:11:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (829, 'Record updated On staff id 4', '4', 1, 'Update', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 07:14:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (830, 'Record updated On settings id 1', '1', 1, 'Update', '49.35.140.240', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 07:57:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (831, 'Record updated On staff id 1', '1', 1, 'Update', '1.187.183.152', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 08:48:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (832, 'Record updated On staff id 1', '1', 1, 'Update', '1.187.183.152', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 08:48:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (833, 'Record updated On staff id 1', '1', 1, 'Update', '1.187.183.152', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 08:48:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (834, 'Record updated On staff id 1', '1', 1, 'Update', '1.187.183.152', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 08:48:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (835, 'Record updated On staff id 1', '1', 1, 'Update', '1.187.183.152', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 08:52:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (836, 'Record updated On staff id 1', '1', 1, 'Update', '1.187.183.152', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 08:52:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (837, 'Record updated On staff id 1', '1', 1, 'Update', '1.187.183.152', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 08:53:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (838, 'Record updated On staff id 1', '1', 1, 'Update', '1.187.183.152', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 08:53:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (839, 'Record updated On staff id 1', '1', 1, 'Update', '1.187.183.152', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 08:56:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (840, 'Record updated On staff id 1', '1', 1, 'Update', '1.187.183.152', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 08:56:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (841, 'Record updated On staff id 1', '1', 1, 'Update', '1.187.183.152', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 08:57:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (842, 'Record updated On staff id 1', '1', 1, 'Update', '1.187.183.152', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 08:57:10', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (843, 'Record updated On staff id 1', '1', 1, 'Update', '27.60.13.200', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 09:39:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (844, 'Record updated On staff id 1', '1', 1, 'Update', '27.60.13.200', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 09:39:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (845, 'Record updated On users id 1', '1', 1, 'Update', '27.60.13.200', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 10:34:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (846, 'New Record inserted On students id 18', '18', 1, 'Insert', '152.59.48.252', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 10:38:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (847, 'New Record inserted On  student session id 18', '18', 1, 'Insert', '152.59.48.252', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 10:38:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (848, 'New Record inserted On users id 35', '35', 1, 'Insert', '152.59.48.252', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 10:38:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (849, 'New Record inserted On users id 36', '36', 1, 'Insert', '152.59.48.252', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 10:38:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (850, 'Record updated On students id 18', '18', 1, 'Update', '152.59.48.252', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 10:38:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (851, 'New Record inserted On students id 19', '19', 1, 'Insert', '152.59.48.239', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 10:39:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (852, 'New Record inserted On  student session id 19', '19', 1, 'Insert', '152.59.48.239', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 10:39:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (853, 'New Record inserted On users id 37', '37', 1, 'Insert', '152.59.48.239', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 10:39:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (854, 'New Record inserted On users id 38', '38', 1, 'Insert', '152.59.48.239', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 10:39:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (855, 'Record updated On students id 19', '19', 1, 'Update', '152.59.48.239', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 10:39:37', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (856, 'Record updated On  exam group exams name id 1', '1', 1, 'Update', '27.60.13.200', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 10:41:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (857, 'New Record inserted On students id 20', '20', 1, 'Insert', '152.59.48.67', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 11:58:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (858, 'New Record inserted On  student session id 20', '20', 1, 'Insert', '152.59.48.67', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 11:58:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (859, 'New Record inserted On users id 39', '39', 1, 'Insert', '152.59.48.67', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 11:58:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (860, 'New Record inserted On users id 40', '40', 1, 'Insert', '152.59.48.67', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 11:58:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (861, 'Record updated On students id 20', '20', 1, 'Update', '152.59.48.67', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 11:58:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (862, 'New Record inserted On students id 21', '21', 1, 'Insert', '152.59.48.216', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:13:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (863, 'New Record inserted On  student session id 21', '21', 1, 'Insert', '152.59.48.216', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:13:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (864, 'New Record inserted On users id 41', '41', 1, 'Insert', '152.59.48.216', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:13:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (865, 'New Record inserted On users id 42', '42', 1, 'Insert', '152.59.48.216', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:13:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (866, 'Record updated On students id 21', '21', 1, 'Update', '152.59.48.216', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:13:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (867, 'New Record inserted On item category id 1', '1', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:20:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (868, 'New Record inserted On item category id 2', '2', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:20:30', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (869, 'New Record inserted On item store id 1', '1', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:21:01', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (870, 'New Record inserted On item store id 2', '2', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:21:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (871, 'Record updated On  item store id 1', '1', 1, 'Update', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:21:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (872, 'New Record inserted On item supplier id 1', '1', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:23:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (873, 'New Record inserted On item supplier id 2', '2', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:23:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (874, 'New Record inserted On transport route id 3', '3', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:39:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (875, 'New Record inserted On transport route id 4', '4', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:40:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (876, 'Record updated On  vehicles id 2', '2', 1, 'Update', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:40:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (877, 'New Record inserted On hostel rooms id 2', '2', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:50:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (878, 'New Record inserted On hostel rooms id 3', '3', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:51:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (879, 'New Record inserted On room types id 2', '2', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:51:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (880, 'New Record inserted On room types id 3', '3', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:51:28', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (881, 'New Record inserted On room types id 4', '4', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:51:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (882, 'New Record inserted On room types id 5', '5', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:51:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (883, 'New Record inserted On hostel id 2', '2', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:52:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (884, 'New Record inserted On hostel id 3', '3', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:52:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (885, 'New Record inserted On hostel id 4', '4', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:52:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (886, 'New Record inserted On certificates id 2', '2', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 12:53:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (887, 'New Record inserted On id card id 3', '3', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 13:10:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (888, 'New Record inserted On id card id 3', '3', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 13:12:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (889, 'New Record inserted On students id 22', '22', 1, 'Insert', '152.59.47.211', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 13:18:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (890, 'New Record inserted On  student session id 22', '22', 1, 'Insert', '152.59.47.211', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 13:18:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (891, 'New Record inserted On users id 43', '43', 1, 'Insert', '152.59.47.211', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 13:18:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (892, 'New Record inserted On users id 44', '44', 1, 'Insert', '152.59.47.211', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 13:18:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (893, 'Record updated On students id 22', '22', 1, 'Update', '152.59.47.211', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 13:18:21', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (894, 'New Record inserted On Alumni Event id 1', '1', 1, 'Insert', '106.221.4.236', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 13:19:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (895, 'New Record inserted On students id 23', '23', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 05:17:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (896, 'New Record inserted On  student session id 23', '23', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 05:17:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (897, 'New Record inserted On users id 45', '45', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 05:17:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (898, 'New Record inserted On users id 46', '46', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 05:17:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (899, 'Record updated On students id 23', '23', 1, 'Update', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 05:17:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (900, 'New Record inserted On students id 24', '24', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 05:18:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (901, 'New Record inserted On  student session id 24', '24', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 05:18:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (902, 'New Record inserted On users id 47', '47', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 05:18:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (903, 'New Record inserted On users id 48', '48', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 05:18:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (904, 'Record updated On students id 24', '24', 1, 'Update', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 05:18:32', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (905, 'Record updated On staff id 5', '5', 1, 'Update', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 05:37:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (906, 'Record updated On staff id 5', '5', 1, 'Update', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 06:14:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (907, 'Record updated On staff id 5', '5', 1, 'Update', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 06:14:52', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (908, 'Record updated On staff id 6', '6', 1, 'Update', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 06:25:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (909, 'Record updated On staff id 7', '7', 1, 'Update', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 06:37:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (910, 'New Record inserted On students id 25', '25', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 06:53:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (911, 'New Record inserted On  student session id 25', '25', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 06:53:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (912, 'New Record inserted On users id 49', '49', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 06:53:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (913, 'New Record inserted On users id 50', '50', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 06:53:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (914, 'Record updated On students id 25', '25', 1, 'Update', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 06:53:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (915, 'New Record inserted On students id 26', '26', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:02:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (916, 'New Record inserted On  student session id 26', '26', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:02:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (917, 'New Record inserted On users id 51', '51', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:02:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (918, 'New Record inserted On users id 52', '52', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:02:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (919, 'Record updated On students id 26', '26', 1, 'Update', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:02:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (920, 'New Record inserted On students id 27', '27', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:03:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (921, 'New Record inserted On  student session id 27', '27', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:03:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (922, 'New Record inserted On users id 53', '53', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:03:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (923, 'New Record inserted On users id 54', '54', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:03:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (924, 'Record updated On students id 27', '27', 1, 'Update', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:03:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (925, 'New Record inserted On students id 28', '28', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:04:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (926, 'New Record inserted On  student session id 28', '28', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:04:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (927, 'New Record inserted On users id 55', '55', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:04:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (928, 'New Record inserted On users id 56', '56', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:04:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (929, 'Record updated On students id 28', '28', 1, 'Update', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:04:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (930, 'New Record inserted On students id 29', '29', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:05:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (931, 'New Record inserted On  student session id 29', '29', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:05:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (932, 'New Record inserted On users id 57', '57', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:05:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (933, 'New Record inserted On users id 58', '58', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:05:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (934, 'Record updated On students id 29', '29', 1, 'Update', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:05:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (935, 'New Record inserted On students id 30', '30', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:06:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (936, 'New Record inserted On  student session id 30', '30', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:06:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (937, 'New Record inserted On users id 59', '59', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:06:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (938, 'New Record inserted On users id 60', '60', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:06:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (939, 'Record updated On students id 30', '30', 1, 'Update', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:06:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (940, 'New Record inserted On students id 31', '31', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:08:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (941, 'New Record inserted On  student session id 31', '31', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:08:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (942, 'New Record inserted On users id 61', '61', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:08:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (943, 'New Record inserted On users id 62', '62', 1, 'Insert', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:08:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (944, 'Record updated On students id 31', '31', 1, 'Update', '152.59.46.186', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:08:12', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (945, 'Record updated On  Page List id 1', '1', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 07:57:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (946, 'Record updated On Alumni Event id 1', '1', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 08:18:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (947, 'Record updated On settings id 1', '1', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 10:49:06', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (948, 'New Record inserted On sessions id 26', '26', 1, 'Insert', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 19:50:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (949, 'Record updated On settings id 1', '1', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 19:53:07', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (950, 'New Record inserted On sessions id 27', '27', 1, 'Insert', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:07:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (951, 'Record updated On notification setting id 1', '1', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (952, 'Record updated On notification setting id 2', '2', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (953, 'Record updated On notification setting id 3', '3', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (954, 'Record updated On notification setting id 4', '4', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (955, 'Record updated On notification setting id 6', '6', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (956, 'Record updated On notification setting id 7', '7', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (957, 'Record updated On notification setting id 8', '8', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (958, 'Record updated On notification setting id 9', '9', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (959, 'Record updated On notification setting id 10', '10', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (960, 'Record updated On notification setting id 11', '11', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (961, 'Record updated On notification setting id 12', '12', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (962, 'Record updated On notification setting id 13', '13', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (963, 'Record updated On notification setting id 14', '14', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (964, 'Record updated On notification setting id 15', '15', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (965, 'Record updated On notification setting id 16', '16', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (966, 'Record updated On notification setting id 17', '17', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (967, 'Record updated On notification setting id 18', '18', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (968, 'Record updated On notification setting id 23', '23', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (969, 'Record updated On notification setting id 24', '24', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (970, 'Record updated On notification setting id 25', '25', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (971, 'Record updated On notification setting id 26', '26', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (972, 'Record updated On notification setting id 27', '27', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (973, 'Record updated On notification setting id 28', '28', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (974, 'Record updated On notification setting id 29', '29', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (975, 'Record updated On notification setting id 30', '30', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (976, 'Record updated On notification setting id 31', '31', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (977, 'Record updated On notification setting id 32', '32', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (978, 'Record updated On notification setting id 33', '33', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (979, 'Record updated On notification setting id 34', '34', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (980, 'Record updated On notification setting id 35', '35', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (981, 'Record updated On notification setting id 36', '36', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (982, 'Record updated On notification setting id 37', '37', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (983, 'Record updated On notification setting id 38', '38', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (984, 'Record updated On notification setting id 39', '39', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (985, 'Record updated On notification setting id 20', '20', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (986, 'Record updated On notification setting id 19', '19', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (987, 'Record updated On notification setting id 21', '21', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (988, 'Record updated On notification setting id 22', '22', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (989, 'New Record inserted On sms config id 1', '1', 1, 'Insert', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (990, 'Record updated On sms config id clickatell', 'clickatell', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:09:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (991, 'New Record inserted On sms config id 2', '2', 1, 'Insert', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:10:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (992, 'Record updated On sms config id twilio', 'twilio', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:10:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (993, 'New Record inserted On sms config id 3', '3', 1, 'Insert', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:10:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (994, 'New Record inserted On sms config id 4', '4', 1, 'Insert', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:10:54', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (995, 'New Record inserted On sms config id 5', '5', 1, 'Insert', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:11:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (996, 'New Record inserted On sms config id 6', '6', 1, 'Insert', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:11:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (997, 'New Record inserted On sms config id 7', '7', 1, 'Insert', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:11:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (998, 'New Record inserted On sms config id 8', '8', 1, 'Insert', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:11:58', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (999, 'New Record inserted On payment settings id 1', '1', 1, 'Insert', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:13:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1000, 'Record updated On Front CMS Setting id 1', '1', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:15:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1001, 'Record updated On settings id 1', '1', 1, 'Update', '103.112.33.163', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-14 20:15:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1002, 'Record updated On staff id 1', '1', 1, 'Update', '106.221.4.249', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 16:04:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1003, 'Record updated On staff id 1', '1', 1, 'Update', '106.221.4.249', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 16:04:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1004, 'Record updated On staff id 2', '2', 1, 'Update', '106.221.4.249', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 16:06:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1005, 'Record updated On staff id 2', '2', 1, 'Update', '106.221.4.249', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 16:06:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1006, 'Record updated On staff id 8', '8', 1, 'Update', '152.58.56.226', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 18:49:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1007, 'Record updated On staff id 9', '9', 1, 'Update', '152.58.56.226', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 18:52:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1008, 'New Record inserted On students id 32', '32', 1, 'Insert', '152.58.56.226', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 18:55:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1009, 'New Record inserted On  student session id 32', '32', 1, 'Insert', '152.58.56.226', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 18:55:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1010, 'New Record inserted On users id 63', '63', 1, 'Insert', '152.58.56.226', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 18:55:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1011, 'New Record inserted On users id 64', '64', 1, 'Insert', '152.58.56.226', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 18:55:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1012, 'Record updated On students id 32', '32', 1, 'Update', '152.58.56.226', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 18:55:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1013, 'New Record inserted On students id 33', '33', 1, 'Insert', '152.58.56.83', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 18:58:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1014, 'New Record inserted On  student session id 33', '33', 1, 'Insert', '152.58.56.83', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 18:58:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1015, 'New Record inserted On users id 65', '65', 1, 'Insert', '152.58.56.83', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 18:58:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1016, 'New Record inserted On users id 66', '66', 1, 'Insert', '152.58.56.83', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 18:58:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1017, 'Record updated On students id 33', '33', 1, 'Update', '152.58.56.83', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 18:58:49', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1018, 'New Record inserted On students id 34', '34', 1, 'Insert', '152.58.56.250', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:03:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1019, 'New Record inserted On  student session id 34', '34', 1, 'Insert', '152.58.56.250', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:03:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1020, 'New Record inserted On users id 67', '67', 1, 'Insert', '152.58.56.250', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:03:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1021, 'New Record inserted On users id 68', '68', 1, 'Insert', '152.58.56.250', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:03:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1022, 'Record updated On students id 34', '34', 1, 'Update', '152.58.56.250', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:03:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1023, 'New Record inserted On students id 35', '35', 1, 'Insert', '152.58.56.168', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:05:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1024, 'New Record inserted On  student session id 35', '35', 1, 'Insert', '152.58.56.168', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:05:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1025, 'New Record inserted On users id 69', '69', 1, 'Insert', '152.58.56.168', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:05:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1026, 'New Record inserted On users id 70', '70', 1, 'Insert', '152.58.56.168', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:05:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1027, 'Record updated On students id 35', '35', 1, 'Update', '152.58.56.168', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:05:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1028, 'New Record inserted On students id 36', '36', 1, 'Insert', '152.58.56.160', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:07:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1029, 'New Record inserted On  student session id 36', '36', 1, 'Insert', '152.58.56.160', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:07:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1030, 'New Record inserted On users id 71', '71', 1, 'Insert', '152.58.56.160', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:07:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1031, 'New Record inserted On users id 72', '72', 1, 'Insert', '152.58.56.160', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:07:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1032, 'Record updated On students id 36', '36', 1, 'Update', '152.58.56.160', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:07:20', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1033, 'New Record inserted On students id 37', '37', 1, 'Insert', '152.58.56.74', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:16:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1034, 'New Record inserted On  student session id 37', '37', 1, 'Insert', '152.58.56.74', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:16:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1035, 'New Record inserted On users id 73', '73', 1, 'Insert', '152.58.56.74', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:16:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1036, 'New Record inserted On users id 74', '74', 1, 'Insert', '152.58.56.74', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:16:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1037, 'Record updated On students id 37', '37', 1, 'Update', '152.58.56.74', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:16:23', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1038, 'New Record inserted On students id 38', '38', 1, 'Insert', '152.58.56.199', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:20:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1039, 'New Record inserted On  student session id 38', '38', 1, 'Insert', '152.58.56.199', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:20:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1040, 'New Record inserted On users id 75', '75', 1, 'Insert', '152.58.56.199', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:20:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1041, 'New Record inserted On users id 76', '76', 1, 'Insert', '152.58.56.199', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:20:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1042, 'Record updated On students id 38', '38', 1, 'Update', '152.58.56.199', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:20:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1043, 'New Record inserted On students id 39', '39', 1, 'Insert', '152.58.56.181', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:22:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1044, 'New Record inserted On  student session id 39', '39', 1, 'Insert', '152.58.56.181', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:22:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1045, 'New Record inserted On users id 77', '77', 1, 'Insert', '152.58.56.181', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:22:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1046, 'New Record inserted On users id 78', '78', 1, 'Insert', '152.58.56.181', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:22:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1047, 'Record updated On students id 39', '39', 1, 'Update', '152.58.56.181', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:22:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1048, 'New Record inserted On students id 40', '40', 1, 'Insert', '152.58.56.125', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:26:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1049, 'New Record inserted On  student session id 40', '40', 1, 'Insert', '152.58.56.125', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:26:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1050, 'New Record inserted On users id 79', '79', 1, 'Insert', '152.58.56.125', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:26:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1051, 'New Record inserted On users id 80', '80', 1, 'Insert', '152.58.56.125', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:26:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1052, 'Record updated On students id 40', '40', 1, 'Update', '152.58.56.125', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:26:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1053, 'New Record inserted On students id 41', '41', 1, 'Insert', '152.58.56.62', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:34:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1054, 'New Record inserted On  student session id 41', '41', 1, 'Insert', '152.58.56.62', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:34:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1055, 'New Record inserted On users id 81', '81', 1, 'Insert', '152.58.56.62', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:34:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1056, 'New Record inserted On users id 82', '82', 1, 'Insert', '152.58.56.62', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:34:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1057, 'Record updated On students id 41', '41', 1, 'Update', '152.58.56.62', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:34:44', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1058, 'New Record inserted On students id 42', '42', 1, 'Insert', '152.58.56.18', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:37:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1059, 'New Record inserted On  student session id 42', '42', 1, 'Insert', '152.58.56.18', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:37:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1060, 'New Record inserted On users id 83', '83', 1, 'Insert', '152.58.56.18', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:37:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1061, 'New Record inserted On users id 84', '84', 1, 'Insert', '152.58.56.18', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:37:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1062, 'Record updated On students id 42', '42', 1, 'Update', '152.58.56.18', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:37:48', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1063, 'New Record inserted On students id 43', '43', 1, 'Insert', '152.58.56.232', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:38:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1064, 'New Record inserted On  student session id 43', '43', 1, 'Insert', '152.58.56.232', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:38:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1065, 'New Record inserted On users id 85', '85', 1, 'Insert', '152.58.56.232', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:38:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1066, 'New Record inserted On users id 86', '86', 1, 'Insert', '152.58.56.232', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:38:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1067, 'Record updated On students id 43', '43', 1, 'Update', '152.58.56.232', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:38:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1068, 'New Record inserted On students id 44', '44', 1, 'Insert', '152.58.56.28', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:41:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1069, 'New Record inserted On  student session id 44', '44', 1, 'Insert', '152.58.56.28', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:41:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1070, 'New Record inserted On users id 87', '87', 1, 'Insert', '152.58.56.28', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:41:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1071, 'New Record inserted On users id 88', '88', 1, 'Insert', '152.58.56.28', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:41:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1072, 'Record updated On students id 44', '44', 1, 'Update', '152.58.56.28', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:41:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1073, 'New Record inserted On students id 45', '45', 1, 'Insert', '152.58.56.28', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:44:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1074, 'New Record inserted On  student session id 45', '45', 1, 'Insert', '152.58.56.28', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:44:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1075, 'New Record inserted On users id 89', '89', 1, 'Insert', '152.58.56.28', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:44:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1076, 'New Record inserted On users id 90', '90', 1, 'Insert', '152.58.56.28', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:44:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1077, 'Record updated On students id 45', '45', 1, 'Update', '152.58.56.28', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:44:46', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1078, 'New Record inserted On students id 46', '46', 1, 'Insert', '152.58.56.146', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:53:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1079, 'New Record inserted On  student session id 46', '46', 1, 'Insert', '152.58.56.146', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:53:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1080, 'New Record inserted On users id 91', '91', 1, 'Insert', '152.58.56.146', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:53:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1081, 'New Record inserted On users id 92', '92', 1, 'Insert', '152.58.56.146', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:53:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1082, 'Record updated On students id 46', '46', 1, 'Update', '152.58.56.146', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:53:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1083, 'New Record inserted On students id 47', '47', 1, 'Insert', '152.58.56.146', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:54:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1084, 'New Record inserted On  student session id 47', '47', 1, 'Insert', '152.58.56.146', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:54:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1085, 'New Record inserted On users id 93', '93', 1, 'Insert', '152.58.56.146', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:54:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1086, 'New Record inserted On users id 94', '94', 1, 'Insert', '152.58.56.146', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:54:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1087, 'Record updated On students id 47', '47', 1, 'Update', '152.58.56.146', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:54:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1088, 'New Record inserted On students id 48', '48', 1, 'Insert', '152.58.56.146', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:55:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1089, 'New Record inserted On  student session id 48', '48', 1, 'Insert', '152.58.56.146', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:55:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1090, 'New Record inserted On users id 95', '95', 1, 'Insert', '152.58.56.146', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:55:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1091, 'New Record inserted On users id 96', '96', 1, 'Insert', '152.58.56.146', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:55:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1092, 'Record updated On students id 48', '48', 1, 'Update', '152.58.56.146', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:55:41', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1093, 'New Record inserted On students id 49', '49', 1, 'Insert', '152.58.56.146', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:59:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1094, 'New Record inserted On  student session id 49', '49', 1, 'Insert', '152.58.56.146', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:59:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1095, 'New Record inserted On users id 97', '97', 1, 'Insert', '152.58.56.146', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:59:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1096, 'New Record inserted On users id 98', '98', 1, 'Insert', '152.58.56.146', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:59:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1097, 'Record updated On students id 49', '49', 1, 'Update', '152.58.56.146', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 19:59:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1098, 'New Record inserted On students id 50', '50', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:29:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1099, 'New Record inserted On  student session id 50', '50', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:29:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1100, 'New Record inserted On users id 99', '99', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:29:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1101, 'New Record inserted On users id 100', '100', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:29:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1102, 'Record updated On students id 50', '50', 1, 'Update', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:29:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1103, 'New Record inserted On students id 51', '51', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:35:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1104, 'New Record inserted On  student session id 51', '51', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:35:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1105, 'New Record inserted On users id 101', '101', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:35:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1106, 'New Record inserted On users id 102', '102', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:35:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1107, 'Record updated On students id 51', '51', 1, 'Update', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:35:11', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1108, 'New Record inserted On students id 52', '52', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:37:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1109, 'New Record inserted On  student session id 52', '52', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:37:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1110, 'New Record inserted On users id 103', '103', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:37:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1111, 'New Record inserted On users id 104', '104', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:37:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1112, 'Record updated On students id 52', '52', 1, 'Update', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:37:22', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1113, 'New Record inserted On students id 53', '53', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:38:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1114, 'New Record inserted On  student session id 53', '53', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:38:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1115, 'New Record inserted On users id 105', '105', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:38:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1116, 'New Record inserted On users id 106', '106', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:38:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1117, 'Record updated On students id 53', '53', 1, 'Update', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:38:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1118, 'New Record inserted On students id 54', '54', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:40:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1119, 'New Record inserted On  student session id 54', '54', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:40:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1120, 'New Record inserted On users id 107', '107', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:40:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1121, 'New Record inserted On users id 108', '108', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:40:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1122, 'Record updated On students id 54', '54', 1, 'Update', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:40:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1123, 'New Record inserted On students id 55', '55', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:44:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1124, 'New Record inserted On  student session id 55', '55', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:44:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1125, 'New Record inserted On users id 109', '109', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:44:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1126, 'New Record inserted On users id 110', '110', 1, 'Insert', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:44:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1127, 'Record updated On students id 55', '55', 1, 'Update', '152.58.56.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 20:44:13', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1128, 'New Record inserted On students id 56', '56', 1, 'Insert', '152.58.56.170', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:12:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1129, 'New Record inserted On  student session id 56', '56', 1, 'Insert', '152.58.56.170', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:12:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1130, 'New Record inserted On users id 111', '111', 1, 'Insert', '152.58.56.170', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:12:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1131, 'New Record inserted On users id 112', '112', 1, 'Insert', '152.58.56.170', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:12:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1132, 'Record updated On students id 56', '56', 1, 'Update', '152.58.56.170', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:12:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1133, 'New Record inserted On students id 57', '57', 1, 'Insert', '152.58.56.170', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:12:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1134, 'New Record inserted On  student session id 57', '57', 1, 'Insert', '152.58.56.170', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:12:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1135, 'New Record inserted On users id 113', '113', 1, 'Insert', '152.58.56.170', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:12:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1136, 'New Record inserted On users id 114', '114', 1, 'Insert', '152.58.56.170', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:12:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1137, 'Record updated On students id 57', '57', 1, 'Update', '152.58.56.170', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:12:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1138, 'New Record inserted On students id 58', '58', 1, 'Insert', '152.58.56.149', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:40:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1139, 'New Record inserted On  student session id 58', '58', 1, 'Insert', '152.58.56.149', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:40:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1140, 'New Record inserted On users id 115', '115', 1, 'Insert', '152.58.56.149', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:40:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1141, 'New Record inserted On users id 116', '116', 1, 'Insert', '152.58.56.149', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:40:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1142, 'Record updated On students id 58', '58', 1, 'Update', '152.58.56.149', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:40:39', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1143, 'New Record inserted On students id 59', '59', 1, 'Insert', '152.58.56.149', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:40:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1144, 'New Record inserted On  student session id 59', '59', 1, 'Insert', '152.58.56.149', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:40:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1145, 'New Record inserted On users id 117', '117', 1, 'Insert', '152.58.56.149', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:40:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1146, 'New Record inserted On users id 118', '118', 1, 'Insert', '152.58.56.149', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:40:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1147, 'Record updated On students id 59', '59', 1, 'Update', '152.58.56.149', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:40:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1148, 'New Record inserted On students id 60', '60', 1, 'Insert', '152.58.56.35', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:50:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1149, 'New Record inserted On  student session id 60', '60', 1, 'Insert', '152.58.56.35', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:50:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1150, 'New Record inserted On users id 119', '119', 1, 'Insert', '152.58.56.35', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:50:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1151, 'New Record inserted On users id 120', '120', 1, 'Insert', '152.58.56.35', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:50:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1152, 'Record updated On students id 60', '60', 1, 'Update', '152.58.56.35', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:50:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1153, 'New Record inserted On students id 61', '61', 1, 'Insert', '152.58.56.35', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:50:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1154, 'New Record inserted On  student session id 61', '61', 1, 'Insert', '152.58.56.35', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:50:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1155, 'New Record inserted On users id 121', '121', 1, 'Insert', '152.58.56.35', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:50:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1156, 'New Record inserted On users id 122', '122', 1, 'Insert', '152.58.56.35', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:50:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1157, 'Record updated On students id 61', '61', 1, 'Update', '152.58.56.35', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:50:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1158, 'New Record inserted On students id 62', '62', 1, 'Insert', '152.58.56.122', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:52:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1159, 'New Record inserted On  student session id 62', '62', 1, 'Insert', '152.58.56.122', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:52:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1160, 'New Record inserted On users id 123', '123', 1, 'Insert', '152.58.56.122', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:52:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1161, 'New Record inserted On users id 124', '124', 1, 'Insert', '152.58.56.122', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:52:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1162, 'Record updated On students id 62', '62', 1, 'Update', '152.58.56.122', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:52:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1163, 'New Record inserted On students id 63', '63', 1, 'Insert', '152.58.56.122', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:52:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1164, 'New Record inserted On  student session id 63', '63', 1, 'Insert', '152.58.56.122', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:52:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1165, 'New Record inserted On users id 125', '125', 1, 'Insert', '152.58.56.122', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:52:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1166, 'New Record inserted On users id 126', '126', 1, 'Insert', '152.58.56.122', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:52:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1167, 'Record updated On students id 63', '63', 1, 'Update', '152.58.56.122', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-15 21:52:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1168, 'New Record inserted On mh exam group exams name id 10', '10', 1, 'Insert', '106.193.121.86', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-16 01:37:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1169, 'Record updated On staff id 1', '1', 1, 'Update', '152.59.47.174', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-16 13:52:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1170, 'Record updated On staff id 1', '1', 1, 'Update', '152.59.47.174', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-16 13:52:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1171, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.47.82', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-16 17:18:42', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1172, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.47.35', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-16 17:19:26', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1173, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.47.196', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-16 17:19:51', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1174, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.48.0', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-16 18:50:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1175, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.48.0', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-16 18:50:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1176, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.48.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-16 18:51:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1177, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.48.166', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-16 18:51:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1178, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.48.248', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-16 18:56:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1179, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.48.240', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-16 18:58:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1180, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.48.240', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-16 18:58:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1181, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.48.240', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-16 19:00:33', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1182, 'Record updated On settings id 1', '1', 1, 'Update', '152.59.48.66', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-16 19:41:29', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1183, 'Record updated On settings id 1', '1', 1, 'Update', '117.99.243.39', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-16 20:55:04', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1184, 'Record updated On settings id 1', '1', 1, 'Update', '117.99.243.39', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-16 20:56:27', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1185, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.25.16', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 12:25:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1186, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.25.65', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 12:27:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1187, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.25.70', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 12:27:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1188, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.25.244', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 12:28:00', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1189, 'New Record inserted On mh exam groups id 20', '20', 1, 'Insert', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 13:08:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1190, 'New Record inserted On mh exam groups id 21', '21', 1, 'Insert', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 13:09:14', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1191, 'New Record inserted On mh exam groups id 22', '22', 1, 'Insert', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 13:09:15', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1192, 'New Record inserted On mh exam groups id 23', '23', 1, 'Insert', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 13:09:16', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1193, 'New Record inserted On mh exam groups id 24', '24', 1, 'Insert', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 13:09:36', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1194, 'New Record inserted On mh exam groups id 25', '25', 1, 'Insert', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 13:10:09', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1195, 'New Record inserted On mh exam groups id 26', '26', 1, 'Insert', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 13:10:35', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1196, 'Record updated On students id 1', '1', 1, 'Update', '152.58.25.176', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 13:37:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1197, 'Record updated On  student session id 1', '1', 1, 'Update', '152.58.25.176', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 13:37:31', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1198, 'Record updated On settings id 1', '1', 1, 'Update', '152.58.25.176', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 13:38:47', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1199, 'Record updated On students id 1', '1', 1, 'Update', '152.58.25.176', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 13:39:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1200, 'Record updated On  student session id 1', '1', 1, 'Update', '152.58.25.176', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 13:39:53', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1201, 'Record updated On settings id 1', '1', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:03:38', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1202, 'New Record inserted On sessions id 28', '28', 1, 'Insert', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:03:55', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1203, 'New Record inserted On sessions id 29', '29', 1, 'Insert', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:04:02', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1204, 'New Record inserted On sessions id 30', '30', 1, 'Insert', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:04:43', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1205, 'Record updated On notification setting id 1', '1', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1206, 'Record updated On notification setting id 2', '2', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1207, 'Record updated On notification setting id 3', '3', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1208, 'Record updated On notification setting id 4', '4', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1209, 'Record updated On notification setting id 6', '6', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1210, 'Record updated On notification setting id 7', '7', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1211, 'Record updated On notification setting id 8', '8', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1212, 'Record updated On notification setting id 9', '9', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1213, 'Record updated On notification setting id 10', '10', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1214, 'Record updated On notification setting id 11', '11', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1215, 'Record updated On notification setting id 12', '12', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1216, 'Record updated On notification setting id 13', '13', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1217, 'Record updated On notification setting id 14', '14', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1218, 'Record updated On notification setting id 15', '15', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1219, 'Record updated On notification setting id 16', '16', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1220, 'Record updated On notification setting id 17', '17', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1221, 'Record updated On notification setting id 18', '18', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1222, 'Record updated On notification setting id 23', '23', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1223, 'Record updated On notification setting id 24', '24', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1224, 'Record updated On notification setting id 25', '25', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1225, 'Record updated On notification setting id 26', '26', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1226, 'Record updated On notification setting id 27', '27', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1227, 'Record updated On notification setting id 28', '28', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1228, 'Record updated On notification setting id 29', '29', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1229, 'Record updated On notification setting id 30', '30', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1230, 'Record updated On notification setting id 31', '31', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1231, 'Record updated On notification setting id 32', '32', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1232, 'Record updated On notification setting id 33', '33', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1233, 'Record updated On notification setting id 34', '34', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1234, 'Record updated On notification setting id 35', '35', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1235, 'Record updated On notification setting id 36', '36', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1236, 'Record updated On notification setting id 37', '37', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1237, 'Record updated On notification setting id 38', '38', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1238, 'Record updated On notification setting id 39', '39', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1239, 'Record updated On notification setting id 20', '20', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1240, 'Record updated On notification setting id 19', '19', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1241, 'Record updated On notification setting id 21', '21', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1242, 'Record updated On notification setting id 22', '22', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:05:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1243, 'Record updated On notification setting id 1', '1', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1244, 'Record updated On notification setting id 2', '2', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1245, 'Record updated On notification setting id 3', '3', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1246, 'Record updated On notification setting id 4', '4', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1247, 'Record updated On notification setting id 6', '6', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1248, 'Record updated On notification setting id 7', '7', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1249, 'Record updated On notification setting id 8', '8', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1250, 'Record updated On notification setting id 9', '9', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1251, 'Record updated On notification setting id 10', '10', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1252, 'Record updated On notification setting id 11', '11', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1253, 'Record updated On notification setting id 12', '12', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1254, 'Record updated On notification setting id 13', '13', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1255, 'Record updated On notification setting id 14', '14', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1256, 'Record updated On notification setting id 15', '15', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1257, 'Record updated On notification setting id 16', '16', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1258, 'Record updated On notification setting id 17', '17', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1259, 'Record updated On notification setting id 18', '18', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1260, 'Record updated On notification setting id 23', '23', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1261, 'Record updated On notification setting id 24', '24', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1262, 'Record updated On notification setting id 25', '25', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1263, 'Record updated On notification setting id 26', '26', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1264, 'Record updated On notification setting id 27', '27', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1265, 'Record updated On notification setting id 28', '28', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1266, 'Record updated On notification setting id 29', '29', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1267, 'Record updated On notification setting id 30', '30', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1268, 'Record updated On notification setting id 31', '31', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1269, 'Record updated On notification setting id 32', '32', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1270, 'Record updated On notification setting id 33', '33', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1271, 'Record updated On notification setting id 34', '34', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1272, 'Record updated On notification setting id 35', '35', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1273, 'Record updated On notification setting id 36', '36', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1274, 'Record updated On notification setting id 37', '37', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1275, 'Record updated On notification setting id 38', '38', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1276, 'Record updated On notification setting id 39', '39', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1277, 'Record updated On notification setting id 20', '20', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1278, 'Record updated On notification setting id 19', '19', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1279, 'Record updated On notification setting id 21', '21', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1280, 'Record updated On notification setting id 22', '22', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:03', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1281, 'Record updated On notification setting id 1', '1', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1282, 'Record updated On notification setting id 2', '2', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1283, 'Record updated On notification setting id 3', '3', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1284, 'Record updated On notification setting id 4', '4', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1285, 'Record updated On notification setting id 6', '6', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1286, 'Record updated On notification setting id 7', '7', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1287, 'Record updated On notification setting id 8', '8', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1288, 'Record updated On notification setting id 9', '9', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1289, 'Record updated On notification setting id 10', '10', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1290, 'Record updated On notification setting id 11', '11', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1291, 'Record updated On notification setting id 12', '12', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1292, 'Record updated On notification setting id 13', '13', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1293, 'Record updated On notification setting id 14', '14', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1294, 'Record updated On notification setting id 15', '15', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1295, 'Record updated On notification setting id 16', '16', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1296, 'Record updated On notification setting id 17', '17', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1297, 'Record updated On notification setting id 18', '18', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1298, 'Record updated On notification setting id 23', '23', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1299, 'Record updated On notification setting id 24', '24', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1300, 'Record updated On notification setting id 25', '25', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1301, 'Record updated On notification setting id 26', '26', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1302, 'Record updated On notification setting id 27', '27', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1303, 'Record updated On notification setting id 28', '28', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1304, 'Record updated On notification setting id 29', '29', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1305, 'Record updated On notification setting id 30', '30', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1306, 'Record updated On notification setting id 31', '31', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1307, 'Record updated On notification setting id 32', '32', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1308, 'Record updated On notification setting id 33', '33', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1309, 'Record updated On notification setting id 34', '34', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1310, 'Record updated On notification setting id 35', '35', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1311, 'Record updated On notification setting id 36', '36', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1312, 'Record updated On notification setting id 37', '37', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1313, 'Record updated On notification setting id 38', '38', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1314, 'Record updated On notification setting id 39', '39', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1315, 'Record updated On notification setting id 20', '20', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1316, 'Record updated On notification setting id 19', '19', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1317, 'Record updated On notification setting id 21', '21', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1318, 'Record updated On notification setting id 22', '22', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:18', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1319, 'Record updated On notification setting id 1', '1', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1320, 'Record updated On notification setting id 2', '2', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1321, 'Record updated On notification setting id 3', '3', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1322, 'Record updated On notification setting id 4', '4', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1323, 'Record updated On notification setting id 6', '6', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1324, 'Record updated On notification setting id 7', '7', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1325, 'Record updated On notification setting id 8', '8', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1326, 'Record updated On notification setting id 9', '9', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1327, 'Record updated On notification setting id 10', '10', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1328, 'Record updated On notification setting id 11', '11', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1329, 'Record updated On notification setting id 12', '12', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1330, 'Record updated On notification setting id 13', '13', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1331, 'Record updated On notification setting id 14', '14', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1332, 'Record updated On notification setting id 15', '15', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1333, 'Record updated On notification setting id 16', '16', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1334, 'Record updated On notification setting id 17', '17', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1335, 'Record updated On notification setting id 18', '18', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1336, 'Record updated On notification setting id 23', '23', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1337, 'Record updated On notification setting id 24', '24', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1338, 'Record updated On notification setting id 25', '25', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1339, 'Record updated On notification setting id 26', '26', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1340, 'Record updated On notification setting id 27', '27', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1341, 'Record updated On notification setting id 28', '28', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1342, 'Record updated On notification setting id 29', '29', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1343, 'Record updated On notification setting id 30', '30', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1344, 'Record updated On notification setting id 31', '31', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1345, 'Record updated On notification setting id 32', '32', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1346, 'Record updated On notification setting id 33', '33', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1347, 'Record updated On notification setting id 34', '34', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1348, 'Record updated On notification setting id 35', '35', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1349, 'Record updated On notification setting id 36', '36', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1350, 'Record updated On notification setting id 37', '37', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1351, 'Record updated On notification setting id 38', '38', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1352, 'Record updated On notification setting id 39', '39', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1353, 'Record updated On notification setting id 20', '20', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1354, 'Record updated On notification setting id 19', '19', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1355, 'Record updated On notification setting id 21', '21', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1356, 'Record updated On notification setting id 22', '22', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:34', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1357, 'Record updated On notification setting id 1', '1', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1358, 'Record updated On notification setting id 2', '2', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1359, 'Record updated On notification setting id 3', '3', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1360, 'Record updated On notification setting id 4', '4', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1361, 'Record updated On notification setting id 6', '6', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1362, 'Record updated On notification setting id 7', '7', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1363, 'Record updated On notification setting id 8', '8', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1364, 'Record updated On notification setting id 9', '9', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1365, 'Record updated On notification setting id 10', '10', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1366, 'Record updated On notification setting id 11', '11', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1367, 'Record updated On notification setting id 12', '12', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1368, 'Record updated On notification setting id 13', '13', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1369, 'Record updated On notification setting id 14', '14', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1370, 'Record updated On notification setting id 15', '15', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1371, 'Record updated On notification setting id 16', '16', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1372, 'Record updated On notification setting id 17', '17', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1373, 'Record updated On notification setting id 18', '18', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1374, 'Record updated On notification setting id 23', '23', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1375, 'Record updated On notification setting id 24', '24', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1376, 'Record updated On notification setting id 25', '25', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1377, 'Record updated On notification setting id 26', '26', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1378, 'Record updated On notification setting id 27', '27', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1379, 'Record updated On notification setting id 28', '28', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1380, 'Record updated On notification setting id 29', '29', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1381, 'Record updated On notification setting id 30', '30', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1382, 'Record updated On notification setting id 31', '31', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1383, 'Record updated On notification setting id 32', '32', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1384, 'Record updated On notification setting id 33', '33', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1385, 'Record updated On notification setting id 34', '34', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1386, 'Record updated On notification setting id 35', '35', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1387, 'Record updated On notification setting id 36', '36', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1388, 'Record updated On notification setting id 37', '37', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1389, 'Record updated On notification setting id 38', '38', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1390, 'Record updated On notification setting id 39', '39', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1391, 'Record updated On notification setting id 20', '20', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1392, 'Record updated On notification setting id 19', '19', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1393, 'Record updated On notification setting id 21', '21', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1394, 'Record updated On notification setting id 22', '22', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:45', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1395, 'Record updated On notification setting id 1', '1', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1396, 'Record updated On notification setting id 2', '2', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1397, 'Record updated On notification setting id 3', '3', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1398, 'Record updated On notification setting id 4', '4', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1399, 'Record updated On notification setting id 6', '6', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1400, 'Record updated On notification setting id 7', '7', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1401, 'Record updated On notification setting id 8', '8', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1402, 'Record updated On notification setting id 9', '9', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1403, 'Record updated On notification setting id 10', '10', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1404, 'Record updated On notification setting id 11', '11', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1405, 'Record updated On notification setting id 12', '12', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1406, 'Record updated On notification setting id 13', '13', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1407, 'Record updated On notification setting id 14', '14', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1408, 'Record updated On notification setting id 15', '15', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1409, 'Record updated On notification setting id 16', '16', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1410, 'Record updated On notification setting id 17', '17', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1411, 'Record updated On notification setting id 18', '18', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1412, 'Record updated On notification setting id 23', '23', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1413, 'Record updated On notification setting id 24', '24', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1414, 'Record updated On notification setting id 25', '25', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1415, 'Record updated On notification setting id 26', '26', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1416, 'Record updated On notification setting id 27', '27', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1417, 'Record updated On notification setting id 28', '28', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1418, 'Record updated On notification setting id 29', '29', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1419, 'Record updated On notification setting id 30', '30', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1420, 'Record updated On notification setting id 31', '31', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1421, 'Record updated On notification setting id 32', '32', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1422, 'Record updated On notification setting id 33', '33', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1423, 'Record updated On notification setting id 34', '34', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1424, 'Record updated On notification setting id 35', '35', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1425, 'Record updated On notification setting id 36', '36', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1426, 'Record updated On notification setting id 37', '37', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1427, 'Record updated On notification setting id 38', '38', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1428, 'Record updated On notification setting id 39', '39', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1429, 'Record updated On notification setting id 20', '20', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1430, 'Record updated On notification setting id 19', '19', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1431, 'Record updated On notification setting id 21', '21', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1432, 'Record updated On notification setting id 22', '22', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:08:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1433, 'Record updated On notification setting id 1', '1', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1434, 'Record updated On notification setting id 2', '2', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1435, 'Record updated On notification setting id 3', '3', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1436, 'Record updated On notification setting id 4', '4', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1437, 'Record updated On notification setting id 6', '6', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1438, 'Record updated On notification setting id 7', '7', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1439, 'Record updated On notification setting id 8', '8', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1440, 'Record updated On notification setting id 9', '9', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1441, 'Record updated On notification setting id 10', '10', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1442, 'Record updated On notification setting id 11', '11', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1443, 'Record updated On notification setting id 12', '12', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1444, 'Record updated On notification setting id 13', '13', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1445, 'Record updated On notification setting id 14', '14', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1446, 'Record updated On notification setting id 15', '15', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1447, 'Record updated On notification setting id 16', '16', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1448, 'Record updated On notification setting id 17', '17', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1449, 'Record updated On notification setting id 18', '18', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1450, 'Record updated On notification setting id 23', '23', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1451, 'Record updated On notification setting id 24', '24', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1452, 'Record updated On notification setting id 25', '25', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1453, 'Record updated On notification setting id 26', '26', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1454, 'Record updated On notification setting id 27', '27', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1455, 'Record updated On notification setting id 28', '28', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1456, 'Record updated On notification setting id 29', '29', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1457, 'Record updated On notification setting id 30', '30', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1458, 'Record updated On notification setting id 31', '31', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1459, 'Record updated On notification setting id 32', '32', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1460, 'Record updated On notification setting id 33', '33', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1461, 'Record updated On notification setting id 34', '34', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1462, 'Record updated On notification setting id 35', '35', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1463, 'Record updated On notification setting id 36', '36', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1464, 'Record updated On notification setting id 37', '37', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1465, 'Record updated On notification setting id 38', '38', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1466, 'Record updated On notification setting id 39', '39', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1467, 'Record updated On notification setting id 20', '20', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1468, 'Record updated On notification setting id 19', '19', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1469, 'Record updated On notification setting id 21', '21', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1470, 'Record updated On notification setting id 22', '22', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:25', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1471, 'Record updated On notification setting id 1', '1', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1472, 'Record updated On notification setting id 2', '2', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1473, 'Record updated On notification setting id 3', '3', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1474, 'Record updated On notification setting id 4', '4', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1475, 'Record updated On notification setting id 6', '6', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1476, 'Record updated On notification setting id 7', '7', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1477, 'Record updated On notification setting id 8', '8', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1478, 'Record updated On notification setting id 9', '9', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1479, 'Record updated On notification setting id 10', '10', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1480, 'Record updated On notification setting id 11', '11', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1481, 'Record updated On notification setting id 12', '12', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1482, 'Record updated On notification setting id 13', '13', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1483, 'Record updated On notification setting id 14', '14', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1484, 'Record updated On notification setting id 15', '15', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1485, 'Record updated On notification setting id 16', '16', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1486, 'Record updated On notification setting id 17', '17', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1487, 'Record updated On notification setting id 18', '18', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1488, 'Record updated On notification setting id 23', '23', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1489, 'Record updated On notification setting id 24', '24', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1490, 'Record updated On notification setting id 25', '25', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1491, 'Record updated On notification setting id 26', '26', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1492, 'Record updated On notification setting id 27', '27', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1493, 'Record updated On notification setting id 28', '28', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1494, 'Record updated On notification setting id 29', '29', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1495, 'Record updated On notification setting id 30', '30', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1496, 'Record updated On notification setting id 31', '31', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1497, 'Record updated On notification setting id 32', '32', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1498, 'Record updated On notification setting id 33', '33', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1499, 'Record updated On notification setting id 34', '34', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1500, 'Record updated On notification setting id 35', '35', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1501, 'Record updated On notification setting id 36', '36', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1502, 'Record updated On notification setting id 37', '37', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1503, 'Record updated On notification setting id 38', '38', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1504, 'Record updated On notification setting id 39', '39', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1505, 'Record updated On notification setting id 20', '20', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1506, 'Record updated On notification setting id 19', '19', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1507, 'Record updated On notification setting id 21', '21', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1508, 'Record updated On notification setting id 22', '22', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:40', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1509, 'Record updated On notification setting id 1', '1', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1510, 'Record updated On notification setting id 2', '2', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1511, 'Record updated On notification setting id 3', '3', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1512, 'Record updated On notification setting id 4', '4', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1513, 'Record updated On notification setting id 6', '6', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1514, 'Record updated On notification setting id 7', '7', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1515, 'Record updated On notification setting id 8', '8', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1516, 'Record updated On notification setting id 9', '9', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1517, 'Record updated On notification setting id 10', '10', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1518, 'Record updated On notification setting id 11', '11', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1519, 'Record updated On notification setting id 12', '12', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1520, 'Record updated On notification setting id 13', '13', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1521, 'Record updated On notification setting id 14', '14', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1522, 'Record updated On notification setting id 15', '15', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1523, 'Record updated On notification setting id 16', '16', 1, 'Update', '117.99.245.29', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-17 16:09:56', NULL);
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `